----------------------------------------------------
local E = select(2, ...)
local CO, L = E:LoadModules("Config", "Locale")
local UF

local RRD = CreateFrame("Frame", "RaidRoleFrame", E.Parent, "SecureHandlerStateTemplate")
RRD.Autoload = true -- This will cause CUI to automatically load this module. No external init needed.
----------------------------------------------------

local Types = {[1] = {"TANK", "LEFT"}, [2] = {"HEALER", "CENTER"}, [3] = {"DAMAGER", "RIGHT"}}


function RRD:LoadProfile()
	self:SetScale(self.db.scale)
end

-- UnitGroupRolesAssigned(F.Unit)
function RRD:GetNumRoles(type)
	self.NumRoles = {}
	self.NumRoles.Count = 0
	if not IsInRaid() then
		if IsInGroup() then
			for i=1,4 do
				if UnitExists(string.format("party%s", i)) and UnitGroupRolesAssigned(string.format("party%s", i)) == type then
					self.NumRoles[i] = {}
					self.NumRoles[i].Count = self.NumRoles.Count + 1
					self.NumRoles[i].Unit = string.format("party%s", i)
					
					self.NumRoles.Count = self.NumRoles.Count + 1
				end
			end
			
			if UnitGroupRolesAssigned("player") == type then
				self.NumRoles[self.NumRoles.Count + 1] = {}
				self.NumRoles[self.NumRoles.Count + 1].Count = self.NumRoles.Count + 1
				self.NumRoles[self.NumRoles.Count + 1].Unit = "player"
				
				self.NumRoles.Count = self.NumRoles.Count + 1
			end
		end
	else
		for i=1,40 do
			if UnitExists(string.format("raid%s", i)) and UnitGroupRolesAssigned(string.format("raid%s", i)) == type then
				self.NumRoles[i] = {}
				self.NumRoles[i].Count = self.NumRoles.Count + 1
				self.NumRoles[i].Unit = string.format("raid%s", i)
				
				self.NumRoles.Count = self.NumRoles.Count + 1
			end
		end
	end
	
	return self.NumRoles
end

function RRD:InitUpdate()
	self:RegisterEvent("ROLE_CHANGED_INFORM")
	self:RegisterEvent("GROUP_ROSTER_UPDATE")
	self:RegisterEvent("UPDATE_INSTANCE_INFO")
	
	self:SetScript("OnEvent", Update)
end

function Update(self, event, ...)
	self.Roles.TANK.Num 	= self:GetNumRoles("TANK")
	self.Roles.HEALER.Num 	= self:GetNumRoles("HEALER")
	self.Roles.DAMAGER.Num 	= self:GetNumRoles("DAMAGER")
	
	self.Roles.TANK.Font:SetText(self.Roles.TANK.Num.Count)
	self.Roles.HEALER.Font:SetText(self.Roles.HEALER.Num.Count)
	self.Roles.DAMAGER.Font:SetText(self.Roles.DAMAGER.Num.Count)
end

function RRD:Construct()
	self:SetSize(210, 45)
	
	self.Background = UF:CreateBackground(self)
	self.Border 	= UF:CreateBorder(self)
	
	self.Roles = {}
	for k, v in pairs(Types) do
		self.Roles[v[1]] = CreateFrame("Frame", string.format("RaidRoleFrame%s", v[1]), self)
		self.Roles[v[1]]:SetSize(70, 40)
		self.Roles[v[1]]:SetPoint(v[2], self, v[2], 8, -3)
		
		self.Roles[v[1]]:EnableMouse(true)
		self.Roles[v[1]]:SetScript("OnEnter", function(self)
			GameTooltip:SetOwner(self, "ANCHOR_BOTTOM")
			
			for k,v in pairs(self.Num) do
				if type(v) == "table" then
					GameTooltip:AddLine(UnitName(v.Unit))
				end
			end
			
			GameTooltip:Show()
		end)
		self.Roles[v[1]]:SetScript("OnLeave", function(self)
			GameTooltip:Hide()
		end)
		
		self.Roles[v[1]].Icon = UF:CreateRole(self.Roles[v[1]])
		self.Roles[v[1]].Icon:ClearAllPoints()
		self.Roles[v[1]].Icon:SetPoint("LEFT", self.Roles[v[1]], "LEFT")
		self.Roles[v[1]].Icon.T:SetTexture(UF.RoleTexture[v[1]])
		
		self.Roles[v[1]].Font = self.Roles[v[1]]:CreateFontString(nil)
			E:InitializeFontFrame(self.Roles[v[1]].Font, "OVERLAY", "FRIZQT__.TTF", 11, {0.933, 0.886, 0.125}, 1, {-20,0}, "", 0, 0, self.Roles[v[1]], "RIGHT", {1,1})
		self.Roles[v[1]].Font:SetText(0)
	end
	
	self:InitUpdate()
	
	E:SetVisibilityHandler(self)
	RegisterStateDriver(self, "visible", "[group:raid] 1; [group:party] 1; 0")
	
	E:CreateMover(self, L["raidRoleFrame"])
end

function RRD:Init()
	self.db = CO.db.profile.dataframes.raidroledata
	
	UF = E:GetModule("Unitframes")

	self:Construct()
	self:LoadProfile()
end

E:AddModule("RaidRoleData", RRD)