local E = select(2, ...) -- Engine
local CO,L,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local C = {}
C.Parent = CreateFrame("Frame", "ChatParent")
C.E = CreateFrame("Frame")

local ChatFrameFont = ChatFrame1.FontStringContainer
local CHAT_MESSAGE_FONT

	CHAT_MESSAGE_FONT = "Raleway"

	
function C:SetupChat()
	self.channelList = {}
		
	for _, frameName in pairs(CHAT_FRAMES) do
		local frame = _G[frameName]
		local editbox = _G[frameName..'EditBox']
		local id = frame:GetID();
		local _, fontSize = FCF_GetChatWindowInfo(id);
	
		C.Parent:SetSize(frame:GetSize())
		frame:SetParent(C.Parent)
		
		-- We have to re-parent every chat tab to position them unfortunately. Thanks blizz :c
		frame:ClearAllPoints()
		frame:SetAllPoints(C.Parent)
	
		FCFTab_UpdateAlpha(frame)
		frame:SetFont("MORPHEUS.ttf", 13, "")
		FCF_SetChatWindowFontSize(frame,frame, 13)
		
		editbox:SetAltArrowKeyMode(false)
		local a, b, c = select(6, editbox:GetRegions()); a:SetTexture(nil); b:SetTexture(nil); c:SetTexture(nil)
		_G[format(editbox:GetName().."Left", id)]:SetTexture(nil)
		_G[format(editbox:GetName().."Mid", id)]:SetTexture(nil)
		_G[format(editbox:GetName().."Right", id)]:SetTexture(nil)
		
		editbox:ClearAllPoints()
		editbox:SetPoint("BOTTOM", frame, "BOTTOM", 0, -30)
		editbox:SetSize(frame:GetWidth(), 20)
		
		editbox.Background = editbox:CreateTexture(nil, "BACKGROUND")
		editbox.Background:SetAllPoints(editbox)
		editbox.Background:SetTexture(130937) -- Interface\\ChatFrame\\ChatFrameBackground - it didn't like the path. Rip
		editbox.Background:SetVertexColor(0,0,0, 0.65)
		
		--------------------------------------------------------------------------------------------------------------
		--	TAB Channel iterator 
		--------------------------------------------------------------------------------------------------------------
		editbox.currentChannel = -1
		local channelID = "s"
		
		editbox:SetScript("OnKeyDown", function(self, key)
			if key == "TAB" then
				-- General Channels can be retrieved with GetChannelList()
				-- editbox:SetText() can be used to replace the input content
				-- @TODO: Assign channels to a channel table and add channels like guild, party, instance, raid and maybe even whispers
				
				C:UpdateChannelList()
				
				channelID = C.channelList[self.currentChannel + 2]
				if not channelID then
					-- If we reached the end, start over
					channelID = -1
					self.currentChannel = -1
					
					channelID = C.channelList[self.currentChannel + 2]
				end
				if channelID then
					-- Change channel by setting "/" followed by the channel num/prefix and a space
					-- @TODO: Make this more versatile and do not hardcode this - please :c
					self:SetText("/" .. channelID .. " " .. self:GetText())
					
					self.currentChannel = self.currentChannel + 2
				end
			end
		end)
		
		frame:SetClampedToScreen(false)
	end
	
	E:CreateMover(C.Parent, L["chatFrame"])
end

function C:AddToChannelList(str, name)
	self.channelList[#self.channelList + 1] = str
	self.channelList[#self.channelList + 1] = name
end

function C:UpdateChannelList()
	wipe(self.channelList)
	--self.channelList = {GetChannelList()}
	
	
	C:AddToChannelList("s", "Say")
	-- C:AddToChannelList("y", "Yell")
	
	if ChatEdit_GetLastTellTarget() then
		C:AddToChannelList("r", "Reply")
	end
	if IsInGuild() then
		C:AddToChannelList("g", "Guild")
	end
	if UnitInParty("player") then
		C:AddToChannelList("p", "Party")
	end
	if IsInInstance() then
		C:AddToChannelList("i", "Instance")
	end
	if UnitInRaid("player") then
		C:AddToChannelList("ra", "Raid")
		
		if UnitIsGroupLeader("player") or UnitIsGroupAssistant("player") then
			C:AddToChannelList("rw", "Raidwarning")
		end
	end
	
	for k,v in pairs({GetChannelList()}) do
		table.insert(self.channelList, v)
	end
	--table.insert(self.channelList, {GetChannelList()})
end

function C:SetChatFont(dropDown, chatFrame, fontSize)
	if ( not chatFrame ) then
		chatFrame = FCF_GetCurrentChatFrame();
	end
	if ( not fontSize ) then
		fontSize = dropDown.value;
	end
	chatFrame:SetFont("MORPHEUS.ttf", 13, "")
end





--[[
	function CUI:Init_Fonts()
		local newFont = "MORPHEUS.ttf"
	 
		STANDARD_TEXT_FONT          = newFont
		UNIT_NAME_FONT              = newFont
		DAMAGE_TEXT_FONT            = newFont
		NAMEPLATE_FONT              = newFont
		NAMEPLATE_SPELLCAST_FONT    = newFont
	 
		local ForcedFontSize = {10, 14, 20, 64, 64}
	 
		local BlizFontObjects = {
	 
			-- Fonts.xml
	 
			-- These five fonts use the fixedSize argument, causing an incorrent font size return, so input our own sizes (ForcedFontSize)
			SystemFont_NamePlateCastBar, SystemFont_NamePlateFixed, SystemFont_LargeNamePlateFixed, SystemFont_World, SystemFont_World_ThickOutline,
	 
			SystemFont_Outline_Small, SystemFont_Outline, SystemFont_InverseShadow_Small, SystemFont_Med2, SystemFont_Med3, SystemFont_Shadow_Med3,
			SystemFont_Huge1, SystemFont_Huge1_Outline, SystemFont_OutlineThick_Huge2, SystemFont_OutlineThick_Huge4, SystemFont_OutlineThick_WTF,
			NumberFont_GameNormal, NumberFont_Shadow_Small, NumberFont_OutlineThick_Mono_Small, NumberFont_Shadow_Med, NumberFont_Normal_Med, 
			NumberFont_Outline_Med, NumberFont_Outline_Large, NumberFont_Outline_Huge, Fancy22Font, QuestFont_Huge, QuestFont_Outline_Huge,
			QuestFont_Super_Huge, QuestFont_Super_Huge_Outline, SplashHeaderFont, Game11Font, Game12Font, Game13Font, Game13FontShadow,
			Game15Font, Game18Font, Game20Font, Game24Font, Game27Font, Game30Font, Game32Font, Game36Font, Game48Font, Game48FontShadow,
			Game60Font, Game72Font, Game11Font_o1, Game12Font_o1, Game13Font_o1, Game15Font_o1, QuestFont_Enormous, DestinyFontLarge,
			CoreAbilityFont, DestinyFontHuge, QuestFont_Shadow_Small, MailFont_Large, SpellFont_Small, InvoiceFont_Med, InvoiceFont_Small,
			Tooltip_Med, Tooltip_Small, AchievementFont_Small, ReputationDetailFont, FriendsFont_Normal, FriendsFont_Small, FriendsFont_Large,
			FriendsFont_UserText, GameFont_Gigantic, ChatBubbleFont, Fancy16Font, Fancy18Font, Fancy20Font, Fancy24Font, Fancy27Font, Fancy30Font,
			Fancy32Font, Fancy48Font, SystemFont_NamePlate, SystemFont_LargeNamePlate,
	 
			-- SharedFonts.xml
	 
			SystemFont_Tiny2, SystemFont_Tiny, SystemFont_Shadow_Small, SystemFont_Small, SystemFont_Small2, SystemFont_Shadow_Small2, SystemFont_Shadow_Med1_Outline,
			SystemFont_Shadow_Med1, QuestFont_Large, SystemFont_Large, SystemFont_Shadow_Large_Outline, SystemFont_Shadow_Med2, SystemFont_Shadow_Large, 
			SystemFont_Shadow_Large2, SystemFont_Shadow_Huge1, SystemFont_Huge2, SystemFont_Shadow_Huge2, SystemFont_Shadow_Huge3, SystemFont_Shadow_Outline_Huge3,
			SystemFont_Shadow_Outline_Huge2, SystemFont_Med1, SystemFont_WTF2, SystemFont_Outline_WTF2, 
			GameTooltipHeader, System_IME,
		}
	 
		for i, FontObject in pairs(BlizFontObjects) do
			local _, oldSize, oldStyle  = FontObject:GetFont()
			FontObject:SetFont(newFont, ForcedFontSize[i] or oldSize, oldStyle)
		end
	 
		BlizFontObjects = nil
	end
]]






function C:Init()
	CO = E:GetModule("Config")
	C.E:RegisterEvent('UPDATE_CHAT_WINDOWS', 'SetupChat')
	C.E:RegisterEvent('UPDATE_FLOATING_CHAT_WINDOWS', 'SetupChat')
	hooksecurefunc('FCF_SetChatWindowFontSize', function(...) C:SetChatFont(...) end)
	
	self:SetupChat()
end

E:AddModule("Chat", C)