local E = select(2, ...) -- Engine
local CO,LOC,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local BE = {}
BE.E = CreateFrame("Frame")

local XPMax, XPCurrent, MaxLevel, PlayerLevel, BarX, BarY, BarPoint, BarParent, BarStrata, XPRested, XPRestedString
local BE_Bar, BE_BarOverlay, BE_BarBackground, BE_BarBorder, BE_BarRested, RGB, PlayerClass
local XPBAR_TEXTURE

	XPBAR_TEXTURE = [[Interface\AddOns\CUI\Textures\layout\modern\XPBar]]

function BE:SetValue(value)
	
	BE_BarOverlay:SetValue(value)
	
	XPRested = GetXPExhaustion()
	
	if XPRested then
		XPRestedString = string.format(" Rested: %s", E:readableNumber(XPRested, 2))
		BE_BarRested:SetValue(value + XPRested)
		
		return
	else
		BE_BarRested:SetValue(0)
	end
	
	XPRestedString = ""
end

function BE:Update()
	if MaxLevel ~= PlayerLevel then
		XPMax = UnitXPMax("player")
		XPCurrent = UnitXP("player")
		BE_BarOverlay:SetMinMaxValues(0, XPMax)
		BE_BarRested:SetMinMaxValues(0, XPMax)
		BE:SetValue(XPCurrent)
		BE_BarOverlay.Font:SetText(string.format("%s / %s (%s%%) %s", E:readableNumber(XPCurrent, 2), E:readableNumber(XPMax, 2), E:Round((XPCurrent/XPMax)*100,2), XPRestedString))
		BE_Bar:Show()
	else
		BE_Bar:Hide()
	end
end

function BE:Create()
	BarStrata, BarX, BarY, BarPoint, BarParent = "MEDIUM", 750, 14, {"BOTTOM", E.Parent, "BOTTOM"}, E.Parent
	
	BE_Bar = UF:CreateBar("Bar_Experience", BarStrata, BarX, BarY, BarPoint, BarParent)
	
	BE_BarOverlay = BE_Bar.Overlay
	BE_BarBackground = BE_Bar.Background
	BE_BarBorder = BE_Bar.Border
	
	
	--BE_BarBackground.Tex:SetTexture(XPBAR_TEXTURE)
	--BE_BarBackground.Tex:SetVertexColor(0.15,0.15,0.15,0.85)
	--BE_BarBorder:Hide()
	--BE_BarBorder:SetStatusBarTexture(XPBAR_TEXTURE)
	--BE_BarBackground:SetStatusBarTexture(XPBAR_TEXTURE)
	--BE_BarOverlay:SetStatusBarTexture(XPBAR_TEXTURE)
	
	BE_BarRested = E:NewFrame("Statusbar", "BE_BarRested", "MEDIUM", BarX, BarY, BarPoint, BE_BarBackground)
	BE_BarRested:SetStatusBarTexture(XPBAR_TEXTURE)
	--BE_BarOverlay:SetStatusBarTexture(XPBAR_TEXTURE)
	
	E:RegisterStatusBar(BE_BarRested)
	
	--BE_BarOverlay:SetAttribute("ReceivesGlobalTexture", false)
	--BE_BarRested:SetAttribute("ReceivesGlobalTexture", false)
	
	PlayerClass = select(3, UnitClass("player"))
	RGB = E.ClassColors[PlayerClass]
	BE_BarOverlay:GetStatusBarTexture():SetVertexColor(RGB[1], RGB[2], RGB[3], 0.9)
	BE_BarRested:GetStatusBarTexture():SetVertexColor(0.25, 0.25, 0.85, 0.9)
	BE_BarBackground.Tex:SetVertexColor(0.2,0.2,0.2,0.5)
	--BE_BarBorder:GetStatusBarTexture():SetVertexColor(0,0,0,0)
	E.LibSmooth:SmoothBar(BE_BarOverlay)
	E.LibSmooth:SmoothBar(BE_BarRested)
	
	-- BE_BarOverlay:EnableMouse() -- Already happens through the SetScript below
	
			--BE_BarOverlay:SetScript("OnEnter", _G["StatusTrackingBarManager"]:GetScript("OnEnter"))
	--BE_BarOverlay:SetScript("OnEnter", function(self) ExhaustionTickMixin:ExhaustionToolTipText() end)
			--BE_BarOverlay:SetScript("OnEnter", function() print("Enter") end)
	--BE_BarOverlay:SetScript("OnLeave", function(self) GameTooltip_Hide() end)
	
	BE_BarOverlay.Font = BE_BarOverlay:CreateFontString(nil, "ARTWORK")
	E:InitializeFontFrame(BE_BarOverlay.Font, "ARTWORK", nil, 11, {0.8,0.8,0.8}, 1, {0,-2}, "101010", 300, 20, BE_BarOverlay, nil, {1,1})
end

BE.E:RegisterEvent("PLAYER_XP_UPDATE")
BE.E:RegisterEvent("UPDATE_EXHAUSTION")
BE.E:SetScript("OnEvent", function(self, event, ...)
	BE:Update()
end)

function BE:Init()
	CO = E:GetModule("Config")
	MaxLevel = GetMaxPlayerLevel()
	PlayerLevel = UnitLevel("player")
	BE:Create()
	BE:Update()
end

E:AddModule("Bar_Experience", BE)