local E = select(2, ...) -- Engine
local CO,L,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")
CO.needsInit = false

local _

local AC										=			LibStub("AceConfig-3.0")
local ACR										=			LibStub("AceConfigRegistry-3.0")
local ACD										=			LibStub("AceConfigDialog-3.0")

local DEFAULT_WIDTH						= 			890
local DEFAULT_HEIGHT 					= 			650

-- Define Options table with accepted root value --------------------
CO.Options 								= 			{type = "group"}
E.ConfigDefaults 						= 			{}

--[[
	This is the Settings module of CUI.
]]-- 

CO.Media = LibStub("LibSharedMedia-3.0")
local KB = LibStub("LibKeyBound-1.0")


CO.AceGUIWidgetLSMlists = {
	['font'] = CO.Media:HashTable("font"),
	['sound'] = CO.Media:HashTable("sound"),
	['statusbar'] = CO.Media:HashTable("statusbar"),
	['border'] = CO.Media:HashTable("border"),
	['background'] = CO.Media:HashTable("background"),
}

local test, musicTest = false -- Is not supposed to be saved!
local CurrentShownNotification = nil
local testHealth = 1 -- *100 = In percent

CO.FontFlags = {
	[""] = "None",
	["OUTLINE"] = "OUTLINE",
	["THICKOUTLINE"] = "THICKOUTLINE",
	["MONOCHROME"] = "MONOCHROME",
}
CO.FontHorizontalAlign = {
	["LEFT"] = L["Left"],
	["CENTER"] = L["Center"],
	["RIGHT"] = L["Right"],
}
CO.FontVerticalAlign = {
	["TOP"] = "Top",
	["MIDDLE"] = "Center",
	["BOTTOM"] = "Bottom",
}

local NumberFormats = {
	[1.0]		=	"1.0",
	[10.0]		=	"10.0",
	[100.0]		=	"100.0",
	[1000.0]	=	"1000.0",
	[10000.0]	=	"10000.0",
	[100000.0]	=	"100000.0",
	[1000000.0]	=	"1000000.0",
}

local ThousandsDelimiter = {
	[","]		=	"( , )",
	["."]		=	"( . )",
	["-"]		=	"( - )",
}

E.BlendModes = {
	["BLEND"] = "BLEND",
	["ADD"] = "ADD",
	["MOD"] = "MOD",
	["DISABLE"] = "DISABLE",
}

E.Positions = {
	["TOPLEFT"] 		= "TOPLEFT",
	["LEFT"]		 	= "LEFT",
	["BOTTOMLEFT"] 		= "BOTTOMLEFT",
	["TOP"] 			= "TOP",
	["CENTER"] 			= "CENTER",
	["BOTTOM"] 			= "BOTTOM",
	["TOPRIGHT"] 		= "TOPRIGHT",
	["RIGHT"] 			= "RIGHT",
	["BOTTOMRIGHT"] 	= "BOTTOMRIGHT",
}

StaticPopupDialogs["FONT_TYPE_NOTIFICATION"] = {
  text = "The modifications you made, may not apply to every font type or just after the tooltip has been shown a few times!",
  button1 = "OK",
  OnAccept = function() CurrentShownNotification = nil end,
  OnCancel = function() CurrentShownNotification = nil end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}
StaticPopupDialogs["RELOAD_NOTIFICATION"] = {
  text = "The modifications you made, may not apply until your UI has been reloaded!",
  button1 = "OK",
  button2 = "Cancel",
  OnAccept = function() ReloadUI(); CurrentShownNotification = nil end,
  OnCancel = function() CurrentShownNotification = nil end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}
StaticPopupDialogs["HANDLE_MOVE_NOTIFICATION"] = {
  text = "The frames are now movable. To lock them, click the button below.",
  button1 = "Lock",
  OnAccept = function() CO.AB:UpdateBarHandles("disable"); ACD:Open("CUI"); CO:ToggleMoveGrid(); E:ToggleMover(false); UF:SetUnitDummys(false); CurrentShownNotification = type end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = false,
  preferredIndex = 10,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}
StaticPopupDialogs["CLEAR_ACTIONBARS_NOTIFICATION"] = {
  text = "You are about to empty ALL your actionbars ENTIRELY. Are you absolutely sure, you want to perform this action?",
  button1 = "Yes",
  button2 = "Cancel",
  OnAccept = function() CurrentShownNotification = nil CO:ShowNotification("CLEAR_ACTIONBARS_NOTIFICATION2"); end,
  OnCancel = function() CurrentShownNotification = nil end,
  timeout = 15,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}
StaticPopupDialogs["CLEAR_ACTIONBARS_NOTIFICATION2"] = {
  text = "This action cannot be reversed. Are you sure?",
  button1 = "Clear all Bars",
  button2 = "Cancel",
  OnAccept = function() for i = 1,120 do PickupAction(i) ClearCursor() end; CurrentShownNotification = nil end,
  OnCancel = function() CurrentShownNotification = nil end,
  timeout = 5,
  whileDead = true,
  hideOnEscape = true,
  preferredIndex = 3,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}
StaticPopupDialogs["KEYREBIND_ACTIVE"] = {
  text = "Key rebind enabled. You can now hover actionslots and press desired keys to assign. Use ESC to remove the current bind from the slot.",
  button1 = "Lock",
  OnAccept = function() CO.AB:SetKeybinder(false); ACD:Open("CUI"); CurrentShownNotification = nil end,
  timeout = 0,
  whileDead = true,
  hideOnEscape = false,
  preferredIndex = 10,  -- avoid some UI taint, see http://www.wowace.com/announcements/how-to-avoid-some-ui-taint/
}

function CO:ShowNotification(type)
	if CurrentShownNotification ~= type then
		StaticPopup_Show (type)
		CurrentShownNotification = type
	end
end

AC:RegisterOptionsTable("CUI", CO.Options)
ACD:SetDefaultSize("CUI", DEFAULT_WIDTH, DEFAULT_HEIGHT)

CO.Options.args = {
		CUIVersion = {
			order = 0,
			type = "description",
			name = "|cff1784d1Version: " .. E.Version .."\nUpdated: ".. E.VersionDate .."|r",
			width = "full"
		},
		CUIHeader = {
			order = 1,
			type = "header",
			name = "",
			width = "full",
		},
		LUAErrors = {
			order = 2,
			type = 'toggle',
			name = L["Lua-Errors"],
			desc = L["Show/Hide Lua-Errors. It currently is recommended to hide them!"],
			get = function(info) return CO.db.profile.LUAErrors or false end,
			set = function(info, value) CO.db.profile.LUAErrors = value end,
		},
		KeybindSetup = {
			order = 3,
			type = 'execute',
			name = L["SetKeybinds"],
			--name = "[Coming Soon]",
			func = function() KB:Toggle(); ACD:Close("CUI"); GameTooltip:Hide() end,
			--disabled = true,
		},
		Install = {
			order = 4,
			type = 'execute',
			name = L["Install"] .. " [TBD]",
			desc = L["Install everything"],
			func = function() E:print("This will trigger the installation!") end,
			disabled = true,
		},
		ToggleAnchors = {
			order = 5,
			type = "execute",
			name = L["Toggle Anchors"],
			desc = L["Unlock various elements of the UI to reposition them."],
			func = function() ACD:Close("CUI"); CO.AB:UpdateBarHandles(); E:ToggleMover(true); UF:SetUnitDummys(true); CO:ShowNotification("HANDLE_MOVE_NOTIFICATION"); CO:ToggleMoveGrid(); GameTooltip:Hide() end,
		},
		ResetAllMovers = {
			order = 6,
			type = "execute",
			name = L["Reset Anchors"] .. " [TBD]",
			desc = L["Reset all frames to their original positions."],
			func = function() E:print("This will reset all anchors to the default locations!") end,
			disabled = true,
		},
}

local Grid
-- Base by Akeru [http://www.wowinterface.com/downloads/info6153-Align.html]
function CO:ToggleMoveGrid()
	if Grid then
		Grid:Hide()
		Grid = nil
	else
		Grid = CreateFrame('Frame', nil, UIParent) 
		Grid:SetAllPoints(UIParent)
		local w = GetScreenWidth() / 128
		local h = GetScreenHeight() / 72
		for i = 0, 128 do
			local tex = Grid:CreateTexture(nil, 'BACKGROUND')
			if i == 64 then
				tex:SetColorTexture(1, 1, 0, 0.5)
			else
				tex:SetColorTexture(1, 1, 1, 0.15)
			end
			tex:SetPoint('TOPLEFT', Grid, 'TOPLEFT', i * w - 1, 0)
			tex:SetPoint('BOTTOMRIGHT', Grid, 'BOTTOMLEFT', i * w + 1, 0)
		end
		for i = 0, 72 do
			local tex = Grid:CreateTexture(nil, 'BACKGROUND')
			if i == 36 then
				tex:SetColorTexture(1, 1, 0, 0.5)
			else
				tex:SetColorTexture(1, 1, 1, 0.15)
			end
			tex:SetPoint('TOPLEFT', Grid, 'TOPLEFT', 0, -i * h + 1)
			tex:SetPoint('BOTTOMRIGHT', Grid, 'TOPRIGHT', 0, -i * h - 1)
		end	
	end
end

CO.Options.args.changelog = {
	type = "group",
	name = "Changelog",
	order = -2,
	args = {
		Header_042 = {
			order = 5989,
			type = "header",
			name = "Minor - 0.4.2 Release [July 4th 2018]",
		},
		Content_042 = {
			order = 5990,
			type = "description",
			name = "|cff1784d1- Changed actionbutton behaviour to react to the locked actionbar setting|r",
			fontSize = "medium",
		},
		Header_040 = {
			order = 5991,
			type = "header",
			name = "Major - 0.4.0 Release [July 2st 2018]",
		},
		Content_040 = {
			order = 5992,
			type = "description",
			name = "|cff1784d1- Added option so sort unitframe clusters and change the X and Y gap between each frame\n- Added tooltip information for units to display its current target and who in your raid has this unit as a target\n- Added a metric heck-ton of options for the unitframes and moved some of them to a better place!\n- Changed a lot of the settings descriptions to make clear what they do\n- Changed maximum value of the Head Tracking Strength to the appropiate maximum possible|r",
			fontSize = "medium",
		},
		Header_030 = {
			order = 5993,
			type = "header",
			name = "Major - 0.3.0 Release [June 20th 2018]",
		},
		Content_030 = {
			order = 5994,
			type = "description",
			name = "|cff1784d1- Tons of bugs have been fixed!\n- New default minimap style and scaling option.\n- Overhauled the screen textures and replaced them with some sleak and simple ones!\n- Added aura bars!\n- Changed the look of the chat input box and added a basic channel switch functionality via tab-key!\n- Added several new movers for default blizzard frames\n- Added option to toggle unitframe portraits\n- Added new 'engine' settings to fiddle around with the camera speed and the actioncam\n- Added a unit-dummy mode (accessible via Unitframes > Dummy Mode) for later re-ordering of unitframe groups!\n- Added options to move the unitframe powerbar\n- Added options to scale individual unitframes and their powerbars\n- Completely rewritten unitframes module for later possible unitframe creation on the fly\n- Added the interruptor name to the castbar interrupt text\n- Added pet actionbar\n- Fixed vanilla party and bossframe sometimes showing up\n- Added AddOn compability for both, Legion AND BfA. The system will now correctly respond to the API changes automatically!\n- Added visibility condition option for actionbars\n- The UI now reacts to petbattles and hides certain frames when neccessary\n- Added tooltip and aurabar options\n- Changed default frame positions a bit\n-Fixed actionbars once and for all\n- Fixed mover issues with the alternate power bar\n- Fixed castbar not working correctly for channel casts\n- Added state driver for the alternate power bar. It now will automatically hide if it does not contain your primary resource!\n- Added temporary fix for deathknight runes. Still needs better solution, since this one eats too much CPU time\n- Overhauled the actionbar system again. It now reacts to binding/hotkey updates\n- Added 3 optional actionbars [With a little warning text in the options. That problem caused me headaches in the past, as i set up ElvUI with extra bars]\n- Added Hot-Key reassign mode!\n- Stylized player tooltips\n- Applied various optimizations to the AddOn engine and its modules\n- Added role overview for party and raid|r",
			fontSize = "medium",
		},
		Header_020 = {
			order = 5995,
			type = "header",
			name = "Major - 0.2.0 B [May 12th 2018]",
		},
		Content_020 = {
			order = 5996,
			type = "description",
			name = "|cff1784d1- Added custom castbars for the main units (player, target and focus)\n- Fixed Aura display\n- Fixed option for personal nameplate to take effect on profile creation (and first login)\n- Fixed micromenu icons\n- Added player aura movers\n- Added questtracker mover\n- Added chat mover\n- Fixed default profile issues due to missing mover data\n- Added a color based status for FPS and Latency\n- Added a new Stat-icon layout and initial values for the character-frame (will be optional soon)\n- Updated default profile and added 3 new internal statusbar textures!|r",
			fontSize = "medium",
		},
		Header_011 = {
			order = 5997,
			type = "header",
			name = "Minor - 0.1.1 B [May 10th 2018]",
		},
		Content_011 = {
			order = 5998,
			type = "description",
			name = "|cff1784d1- Added new frame mover system. This now allows you to reposition unitframes!\n- Added locale system and english+german as initially supported languages! (We need translators :3)\n- Added XP-bar tooltip\n- Added missing casttime to castbar\n- Added mouseover highlight for unitframes!|r",
			fontSize = "medium",
		},
		Header_010 = {
			order = 5999,
			type = "header",
			name = "Major - 0.1.0 B [May 9th 2018]",
		},
		Content_010 = {
			order = 6000,
			type = "description",
			name = "|cff1784d1- Overhauled internal variables to use a different approach in OOP\n- Added visual anchor grid\n- Added various functionality\n- Fixed Warlock Soul Shard bar\n- Fixed occuring LUA-Errors for MainBarFrame\n- Fixed tons of taint issues (there are basically none left now)\n- Fixed display of location coordinates (Blizzard likes to change API things lately)\n- Added internal option to toggle the personal resource bar (The thing below your character in the middle of the screen)\n- Added rested bar to XP bar\n- Added Masque support!\n- Fixed an issue that caused the stancebar to be displayed on classes that don't have any shapeshifting\n- Added credits and changelog to the options panel|r",
			fontSize = "medium",
		},
	},
}

CO.Options.args.issuetracker = {
	type = "group",
	name = "Bugtracker",
	order = -1,
	args = {
		HeaderMajor = {
			order = 1,
			type = "header",
			name = "Major",
		},
		ContentMajor = {
			order = 2,
			type = "description",
			name = "|cff1784d1- Extra Actionbutton sometimes does not show up.\n- The 'Hide Notification' setting for the actioncam doesn't take effect on re-login, while it does when reloading\n|r",
			fontSize = "medium",
		},
		HeaderMinor = {
			order = 3,
			type = "header",
			name = "Minor",
		},
		ContentMinor = {
			order = 4,
			type = "description",
			name = "|cff1784d1- Toggling the player nameplate via blizzard options is not being registered by CUIs getter|r",
			fontSize = "medium",
		},
	}
}

CO.Options.args.credits = {
	type = "group",
	name = "Credits",
	order = -1,
	args = {
		Banner = {
			type = "description",
			name = "",
			image = [[Interface\AddOns\CUI\Textures\CUILogo]],
			imageWidth = 128,
			imageHeight = 128,
			width = "full",
			order = 1,
		},
		Description = {
			type = "description",
			name = "|cff1784d1" .. L["CUI is a Custom User Interface, designed to be yours. In every possible way. [At some point in the future]"] .. "|r",
			fontSize = "medium",
			order = 2,
		},
		Icon = {
			type = "description",
			name = "|cff1784d1" .. L["Developed by Arenima @ Alleria EU\nLeader of Bane of the Legion"] .. "|r",
			image = [[Interface\AddOns\CUI\Textures\BOTLLogo]],
			-- imageCoords = {0.1,0.9,0.1,0.9},
			imageWidth = 100,
			imageHeight = 100,
			order = 3,
		},
		ThanksTo = {
			type = "description",
			name = "|cff1784d1\n\nReally special thanks to:\n-Skaltryos @ Alleria EU\n-Tiray/Myralin @ Alleria EU\n\nYou are amazing!",
			fontSize = "small",
			order = 4,
		},
	},
}

CO.Options.args.global = {
	type = "group",
	name = "Global",
	order = 10,
	args = {
		nameplateHeader = {
			order = 1,
			type = "header",
			name = L["Nameplates"],
		},
		showPlayerNameplate = {
			type = "toggle",
			order = 2,
			name = L["Personal Nameplate"],
			desc = L["Enable/Disable the Blizzard default personal nameplate in the center of the screen"],
			get = function() return CO.db.profile.CVars.nameplateShowSelf end,
			set = function(info, value) CO.db.profile.CVars.nameplateShowSelf = value; SetCVar("nameplateShowSelf", value) end,
		},
		worldHeader = {
			order = 10,
			type = "header",
			name = "World Settings",
		},
		worldNameFont = {
		  name = "Name Font",
		  dialogControl = "LSM30_Font",
		  type = "select",
		  desc = "Changes the name font that is being rendered in the WorldFrame [Text above units]\nThis requires a relog, since reloading the UI is not enough for this",
		  order = 11,
		  values = CO.AceGUIWidgetLSMlists["font"],
		  get = function(info) return CO.db.profile.global.worldNameFont end,
		  set = function(info, value) CO.db.profile.global.worldNameFont = value end,
		},
		worldDamageFont = {
		  name = "Damage Font",
		  dialogControl = "LSM30_Font",
		  type = "select",
		  desc = "Changes the damage font that is being rendered in the WorldFrame\nThis requires a relog, since reloading the UI is not enough for this",
		  order = 12,
		  values = CO.AceGUIWidgetLSMlists["font"],
		  get = function(info) return CO.db.profile.global.worldDamageFont end,
		  set = function(info, value) CO.db.profile.global.worldDamageFont = value end,
		},
		worldDefaultFont = {
		  name = "Default Font",
		  dialogControl = "LSM30_Font",
		  type = "select",
		  desc = "Changes the default font that is being rendered in the WorldFrame. This includes texts like honor gain etc\nThis requires a relog, since reloading the UI is not enough for this",
		  order = 13,
		  values = CO.AceGUIWidgetLSMlists["font"],
		  get = function(info) return CO.db.profile.global.worldDefaultFont end,
		  set = function(info, value) CO.db.profile.global.worldDefaultFont = value end,
		},
	},
}

function CO:CreateOptions()
	CO.Options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(CO.db)
end

function CO:ProfileUpdate()
	CO:ShowNotification("RELOAD_NOTIFICATION")
end

function CO:InitializeOptionsCategory(TablePath, Name, Order)
	
	CO.Options.args[TablePath] = {
		type = "group",
		name = Name,
		order = Order,
		args = {},
	}
end

function CO:InitializeSettings()
	E.ConfigDefaults = {
		profile = {
			["LUAErrors"] = false,
			["castbar"] = {
				["fontType"] = "Oswald",
			},
			["layout"] = {
				["location"] = {
					["fontType"] = "Oswald",
				},
			},
			["dataframes"] = {
				["raidroledata"] = {
					["scale"] = 1,
				},
			},
			["auras"] = {
				["size"] = 32,
				["bars"] = {
					["playerAuras"] = true,
					["targetBuffs"] = false,
					["targetDebuffs"] = true,
				},
				["units"] = {
					["player"] = {
						["aurabars"] = {
							["enable"] = true,
							["width"] = 278,
							["height"] = 18,
							["gapY"] = 2,
							["iconSize"] = 18,
							
							["nameFontPosition"] = "LEFT",
							["nameFontXOffset"] = 10,
							["nameFontYOffset"] = 0,
							["nameFontHeight"] = 11,
							["nameFontType"] = "Walkway Black",
							["nameFontFlags"] = "",
							["nameFontShadowColor"] = {0,0,0,1},
							["nameXFontShadowOffset"] = 1,
							["nameYFontShadowOffset"] = 1,
							
							["timeFontPosition"] = "RIGHT",
							["timeFontXOffset"] = -10,
							["timeFontYOffset"] = 0,
							["timeFontHeight"] = 11,
							["timeFontType"] = "Walkway Black",
							["timeFontFlags"] = "",
							["timeFontShadowColor"] = {0,0,0,1},
							["timeXFontShadowOffset"] = 1,
							["timeYFontShadowOffset"] = 1,
							
							["backgroundColor"] = {0.15, 0.15, 0.15, 0.85},
						},
					},
					["target"] = {
						["aurabars"] = {
							["enable"] = true,
							["width"] = 278,
							["height"] = 18,
							["gapY"] = 2,
							["iconSize"] = 18,
							
							["nameFontPosition"] = "LEFT",
							["nameFontXOffset"] = 10,
							["nameFontYOffset"] = 0,
							["nameFontHeight"] = 11,
							["nameFontType"] = "Walkway Black",
							["nameFontFlags"] = "",
							["nameFontShadowColor"] = {0,0,0,1},
							["nameXFontShadowOffset"] = 1,
							["nameYFontShadowOffset"] = 1,
							
							["timeFontPosition"] = "RIGHT",
							["timeFontXOffset"] = -10,
							["timeFontYOffset"] = 0,
							["timeFontHeight"] = 11,
							["timeFontType"] = "Walkway Black",
							["timeFontFlags"] = "",
							["timeFontShadowColor"] = {0,0,0,1},
							["timeXFontShadowOffset"] = 1,
							["timeYFontShadowOffset"] = 1,
							
							["backgroundColor"] = {0.15, 0.15, 0.15, 0.85},
						},
					},
				},
			},
			["global"] = {
				["worldNameFont"] = "Michroma",
				["worldDamageFont"] = "EncodeSans Regular",
				["worldDefaultFont"] = "EncodeSans Regular",
			},
			["CVars"] = {
				["nameplateShowSelf"] = false,
				["test_cameraTargetFocusInteractEnable"] = false,
				["test_cameraTargetFocusEnemyEnable"] = false,
				["test_cameraTargetFocusEnemyStrengthPitch"] = 0.05,
				["cameraYawMoveSpeed"] = 0,
				["test_cameraTargetFocusEnemyStrengthYaw"] = 0.15,
				["test_cameraDynamicPitch"] = false,
				["test_cameraOverShoulder"] = 0,
				["test_cameraHeadMovementStrength"] = 0,
				["cameraPitchMoveSpeed"] = 0,
				["test_cameraDynamicPitchBaseFovPad"] = 0.25,
				["test_cameraDynamicPitchBaseFovPadFlying"] = 0.5,
			},
			["engine"] = {
				["hideActioncamNotification"] = true,
			},
			["minimap"] = {
				["scale"] = 1.15,
			},
			["movers"] = {
				["RaidRoleFrameMover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
					["yOffset"] = 0,
				},
				["arenaHolderMover"] = {
					["xOffset"] = 285.555694580078,
					["relativePoint"] = "TOPLEFT",
					["point"] = "TOPLEFT",
					["yOffset"] = -131.666549682617,
				},
				["bossHolderMover"] = {
					["xOffset"] = -330.555419921875,
					["yOffset"] = -225.555282592773,
					["point"] = "TOPRIGHT",
					["relativePoint"] = "TOPRIGHT",
				},
				["partyHolderMover"] = {
					["xOffset"] = 69.4441604614258,
					["yOffset"] = -130.555435180664,
					["point"] = "TOPLEFT",
					["relativePoint"] = "TOPLEFT",
				},
				["AlertFrameHolderMover"] = {
					["xOffset"] = -0.553298354148865,
					["yOffset"] = 234.667053222656,
					["point"] = "BOTTOM",
					["relativePoint"] = "BOTTOM",
				},
				["BNToastFrameMover"] = {
					["xOffset"] = -1.66770040988922,
					["relativePoint"] = "TOPRIGHT",
					["point"] = "TOPRIGHT",
					["yOffset"] = -254.999938964844,
				},
				["CUI_focusMover"] = {
					["xOffset"] = -417.499755859375,
					["relativePoint"] = "BOTTOMRIGHT",
					["point"] = "BOTTOMRIGHT",
					["yOffset"] = 84.7216949462891,
				},
				["CharacterMicroButtonMover"] = {
					["xOffset"] = -367.777404785156,
					["yOffset"] = -207.666641235352,
					["point"] = "TOP",
					["relativePoint"] = "TOP",
				},
				["MicroMenuMover"] = {
					["xOffset"] = 0,
					["yOffset"] = 0,
					["point"] = "TOPLEFT",
					["relativePoint"] = "TOPLEFT",
				},
				["ZoneAbilityFrameMover"] = {
					["xOffset"] = 475,
					["relativePoint"] = "LEFT",
					["point"] = "LEFT",
					["yOffset"] = 75,
				},
				["ExtraActionBarFrameMover"] = {
					["xOffset"] = -270,
					["yOffset"] = 75,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["PlayerPowerBarAltMover"] = {
					["xOffset"] = 0.555413782596588,
					["yOffset"] = 167.999984741211,
					["point"] = "BOTTOM",
					["relativePoint"] = "BOTTOM",
				},
				["CUIPlayerBuffsBarMover"] = {
					["xOffset"] = -323.888549804688,
					["yOffset"] = -163.333068847656,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["raidHolderMover"] = {
					["xOffset"] = 12.7772092819214,
					["yOffset"] = -242.776351928711,
					["point"] = "LEFT",
					["relativePoint"] = "LEFT",
				},
				["raid40HolderMover"] = {
					["xOffset"] = 37.2239456176758,
					["relativePoint"] = "LEFT",
					["point"] = "LEFT",
					["yOffset"] = -189.665802001953,
				},
				["CUIPlayerDebuffsBarMover"] = {
					["xOffset"] = -413.333312988281,
					["yOffset"] = -191.110748291016,
					["point"] = "CENTER",
					["relativePoint"] = "CENTER",
				},
				["CUIUnitDebuffsBarMover"] = {
					["xOffset"] = 317.777435302734,
					["yOffset"] = -106.666404724121,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["TooltipAnchorMover"] = {
					["xOffset"] = -56.6678199768067,
					["yOffset"] = 100.555641174316,
					["relativePoint"] = "BOTTOMRIGHT",
					["point"] = "BOTTOMRIGHT",
				},
				["AlternatePowerMainFrameMover"] = {
					["xOffset"] = -413.888366699219,
					["yOffset"] = -285.000152587891,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["ChatParentMover"] = {
					["xOffset"] = 37.7778129577637,
					["yOffset"] = 73.3341903686524,
					["point"] = "BOTTOMLEFT",
					["relativePoint"] = "BOTTOMLEFT",
				},
				["CUI_targettargetMover"] = {
					["xOffset"] = 497.222198486328,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 188.334884643555,
				},
				["FocustargetMainFrameMover"] = {
					["xOffset"] = -20.5554180145264,
					["yOffset"] = -57.5001029968262,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["PartyMainFrameMover"] = {
					["xOffset"] = 116.111915588379,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = -84.6656341552735,
				},
				["TotMainFrameMover"] = {
					["xOffset"] = 57.2219963073731,
					["yOffset"] = -0.277524560689926,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["PetMainFrameMover"] = {
					["xOffset"] = -63.8885612487793,
					["yOffset"] = -2.22169184684753,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["FocusMainFrameMover"] = {
					["xOffset"] = 170.555892944336,
					["yOffset"] = 3.0555784702301,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["BossMainFrameMover"] = {
					["xOffset"] = -92.7774505615235,
					["yOffset"] = 217.22216796875,
					["point"] = "BOTTOM",
					["relativePoint"] = "BOTTOM",
				},
				["RaidMainFrameMover"] = {
					["xOffset"] = -327.220520019531,
					["yOffset"] = 161.388595581055,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["TargetMainFrameMover"] = {
					["xOffset"] = -3.33306646347046,
					["yOffset"] = -12.4995460510254,
					["point"] = "CENTER",
					["relativePoint"] = "CENTER",
				},
				["CUI_petMover"] = {
					["xOffset"] = -471.666198730469,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 168.333938598633,
				},
				["CUI_playerPowerContainerMover"] = {
					["xOffset"] = -317.77783203125,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 240.833084106445,
				},
				["CUI_targetPowerContainerMover"] = {
					["xOffset"] = 339.44384765625,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 235.27799987793,
				},
				["CUI_targetMover"] = {
					["xOffset"] = 414.999847412109,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 231.111526489258,
				},
				["CUI_focustargetMover"] = {
					["xOffset"] = -417.499755859375,
					["relativePoint"] = "BOTTOMRIGHT",
					["point"] = "BOTTOMRIGHT",
					["yOffset"] = 45.8336067199707,
				},
				["CUI_playerMover"] = {
					["xOffset"] = -413.888610839844,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 231.111389160156,
				},
				
				["CUIPlayerBuffsMover"] = {
					["xOffset"] = -221.778030395508,
					["yOffset"] = -12.6115560531616,
					["point"] = "TOPRIGHT",
					["relativePoint"] = "TOPRIGHT",
				},
				["CUIPlayerDebuffsMover"] = {
					["xOffset"] = -221.778610229492,
					["yOffset"] = -103.166763305664,
					["point"] = "TOPRIGHT",
					["relativePoint"] = "TOPRIGHT",
				},
				["CUITargetBuffsBarMover"] = {
					["xOffset"] = 414.444122314453,
					["yOffset"] = -143.888534545898,
					["point"] = "CENTER",
					["relativePoint"] = "CENTER",
				},
				["AuraBarContainerplayerMover"] = {
					["xOffset"] = -414.999237060547,
					["yOffset"] = -125.277473449707,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["AuraBarContainertargetMover"] = {
					["xOffset"] = 415,
					["yOffset"] = -70,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
				},
				["ObjectiveTrackerFrameMover"] = {
					["xOffset"] = -91.3889846801758,
					["yOffset"] = 24.3640956878662,
					["relativePoint"] = "BOTTOMRIGHT",
					["point"] = "BOTTOMRIGHT",
				},
				
				["CUI_playerCastbar1Mover"] = {
					["xOffset"] = -7.29463936295360e-005,
					["yOffset"] = -283.611328125,
					["point"] = "CENTER",
					["relativePoint"] = "CENTER",
				},
				["CUI_targetCastbar1Mover"] = {
					["xOffset"] = 444.443756103516,
					["yOffset"] = -286.389495849609,
					["point"] = "CENTER",
					["relativePoint"] = "CENTER",
				},
				
				["CUI_focusCastbar1Mover"] = {
					["xOffset"] = -416.944061279297,
					["yOffset"] = 123.88835144043,
					["point"] = "BOTTOMRIGHT",
					["relativePoint"] = "BOTTOMRIGHT",
				},
				
				["CUI_PetActionbarMover"] = {
					["xOffset"] = 1.77710914611816,
					["relativePoint"] = "TOPLEFT",
					["point"] = "TOPLEFT",
					["yOffset"] = -36.055721282959,
				},
				["CUI_ActionBar1Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "CENTER",
					["point"] = "BOTTOM",
					["yOffset"] = 105,
				},
				["CUI_ActionBar4Mover"] = {
					["xOffset"] = -10,
					["relativePoint"] = "RIGHT",
					["point"] = "RIGHT",
					["yOffset"] = 0,
				},
				["CUI_ActionBar8Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
					["yOffset"] = 0,
				},
				["CUI_StanceBarMover"] = {
					["point"] = "TOPLEFT",
					["relativePoint"] = "TOPLEFT",
					["barPosition"] = "TOPLEFT",
					["xOffset"] = 30.555549621582,
					["yOffset"] = -70.1109619140625,
				},
				["CUI_ActionBar6Mover"] = {
					["xOffset"] = -50,
					["yOffset"] = 0,
					["point"] = "RIGHT",
					["relativePoint"] = "RIGHT",
				},
				["ChatFrame1Mover"] = {
					["xOffset"] = 43.3344345092773,
					["relativePoint"] = "BOTTOMLEFT",
					["point"] = "BOTTOMLEFT",
					["yOffset"] = 77.7770156860352,
				},
				["CUI_ActionBar3Mover"] = {
					["xOffset"] = 315,
					["yOffset"] = 25,
					["point"] = "BOTTOM",
					["relativePoint"] = "BOTTOM",
				},
				["CUI_ActionBar5Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 25,
				},
				["CUI_ActionBar2Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "BOTTOM",
					["point"] = "BOTTOM",
					["yOffset"] = 65,
				},
				["CUI_ActionBar7Mover"] = {
					["xOffset"] = -315,
					["relativePoint"] = "CENTER",
					["point"] = "BOTTOM",
					["yOffset"] = 25,
				},
				["CUI_ActionBar9Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
					["yOffset"] = 40,
				},
				["CUI_ActionBar10Mover"] = {
					["xOffset"] = 0,
					["relativePoint"] = "CENTER",
					["point"] = "CENTER",
					["yOffset"] = 80,
				},
			},
			["tooltip"] = {
				["header"] = {
					["fontType"] = "Raleway",
					["fontSize"] = 14,
					["fontFlags"] = "",
				},
				["body"] = {
					["fontType"] = "Raleway",
					["fontSize"] = 12,
					["fontFlags"] = "",
				},
				["background"] = {
					["border"] = "",
					["backgroundFile"] = "Interface/Tooltips/UI-Tooltip-Background",
					["alpha"] = 1
				},
			},
			["actionbar"] = {
					["global"] = {
						["borderTextureColor"] = {["r"] = 0, ["g"] = 0, ["b"] = 0, ["a"] = 1},
						["normalTextureColor"] = {["r"] = 0.55, ["g"] = 0.55, ["b"] = 0.55, ["a"] = 1},
						["highlightTextureColor"] = {["r"] = 0.9, ["g"] = 0.9, ["b"] = 0.9, ["a"] = 1},
						["pushedTextureColor"] = {["r"] = 0.9, ["g"] = 0.9, ["b"] = 0.9, ["a"] = 1},
						["normalTextureBlendMode"] = "BLEND",
						["borderTextureBlendMode"] = "BLEND",
						["highlightTextureBlendMode"] = "ADD",
						["pushedTextureBlendMode"] = "ADD",
						["useMasque"] = false,
					},
					["useMasque"] = false,
					["micromenu"] = {
						["buttonSizeMultiplier"] = 1,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
					},
					["zonebar"] = {
						["buttonSizeMultiplier"] = 1,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 0,
						["yOffset"] = -350,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["enable"] = true,
					},
					["extrabar"] = {
						["buttonSizeMultiplier"] = 1.25,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 0,
						["yOffset"] = -350,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["enable"] = true,
					},
					["stancebar"] = {
						["buttonSizeMultiplier"] = 0.75,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 10,
						["yOffset"] = -50,
						["point"] = "TOPLEFT",
						["relativePoint"] = "TOPLEFT",
						["enable"] = true,
						["visibilityCondition"] = "[petbattle] 0;1",
					},
					["petbar"] = {
						["buttonSizeMultiplier"] = 0.8,
						["buttonsPerRow"] = -1,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = 0,
						["yOffset"] = 105,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0; [overridebar] 0;[pet] 1;0",
					},
					["bar1"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 7,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = 0,
						["yOffset"] = 105,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0;1",
						["showGrid"] = true,
					},
					["bar2"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = -50,
						["yOffset"] = 0,
						["point"] = "RIGHT",
						["relativePoint"] = "RIGHT",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar3"] = {
						["buttonSizeMultiplier"] = 0.85,
						["buttonsPerRow"] = 3,
						["buttonNum"] = 6,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = 0,
						["yOffset"] = 20,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar4"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = -1,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = -10,
						["yOffset"] = 0,
						["point"] = "RIGHT",
						["relativePoint"] = "RIGHT",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar5"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = 0,
						["yOffset"] = 60,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar6"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 1,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = true,
						["xOffset"] = 315,
						["yOffset"] = 20,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar7"] = {
						["buttonSizeMultiplier"] = 0.85,
						["buttonsPerRow"] = 3,
						["buttonNum"] = 6,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 0,
						["yOffset"] = 0,
						["point"] = "CENTER",
						["relativePoint"] = "CENTER",
						["enable"] = true,
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar8"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 1,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["enable"] = false,
						["xOffset"] = -315,
						["yOffset"] = 20,
						["point"] = "BOTTOM",
						["relativePoint"] = "BOTTOM",
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar9"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 0,
						["yOffset"] = 0,
						["point"] = "CENTER",
						["relativePoint"] = "CENTER",
						["enable"] = false,
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
					["bar10"] = {
						["buttonSizeMultiplier"] = 0.9,
						["buttonsPerRow"] = 12,
						["buttonNum"] = 12,
						["buttonGap"] = AB.ACTIONBUTTON_GAP,
						["xOffset"] = 0,
						["yOffset"] = 0,
						["point"] = "CENTER",
						["relativePoint"] = "CENTER",
						["enable"] = false,
						["visibilityCondition"] = "[petbattle] 0; [vehicleui] 0;[overridebar] 0;1",
						["showGrid"] = true,
					},
			},
			["unitframe"] = {
					["units"] = {
						["player"] = {
							["enable"] = true,
							["healthWidth"] = 295,
							["healthHeight"] = 70,
							["width"] = 295,
							["height"] = 70,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 290,
								["barHeight"] = 10,
								["barXOffset"] = 0,
								["barYOffset"] = 2,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["fontFlags"] = "",
								["xOffset"] = 10,
								["xFontShadowOffset"] = -1,
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 18,
								["fontType"] = "Walkway Black",
								["xFontShadowOffset"] = -1,
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 175,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "TOPLEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 10,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["target"] = {
							["enable"] = true,
							["healthWidth"] = 295,
							["healthHeight"] = 70,
							["width"] = 295,
							["height"] = 70,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 290,
								["barHeight"] = 10,
								["barXOffset"] = 0,
								["barYOffset"] = 2,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 18,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 175,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "TOPLEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 10,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["targettarget"] = {
							["enable"] = true,
							["healthWidth"] = 130,
							["healthHeight"] = 30,
							["width"] = 150,
							["height"] = 50,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 130,
								["barHeight"] = 8,
								["barXOffset"] = 0,
								["barYOffset"] = -8,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "BOTTOM",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = false,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 100,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 14,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 125,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["focus"] = {
							["enable"] = true,
							["healthWidth"] = 180,
							["healthHeight"] = 40,
							["width"] = 150,
							["height"] = 173,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 11,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 180,
								["barHeight"] = 8,
								["barXOffset"] = 0,
								["barYOffset"] = -8,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 11,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 14,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 85,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 11,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -20,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["focustarget"] = {
							["enable"] = true,
							["healthWidth"] = 130,
							["healthHeight"] = 30,
							["width"] = 60,
							["height"] = 91,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["barWidth"] = 130,
								["barHeight"] = 8,
								["barXOffset"] = 0,
								["barYOffset"] = -8,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = false,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 14,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 64,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["xOffset"] = -25,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["pet"] = {
							["enable"] = true,
							["healthWidth"] = 180,
							["healthHeight"] = 50,
							["width"] = 138,
							["height"] = 138,
							["debuffs"] = {
								["perrow"] = 7,
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["barWidth"] = 180,
								["barHeight"] = 10,
								["barXOffset"] = 0,
								["barYOffset"] = -10,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["level"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["height"] = 15,
								["yOffset"] = 40,
								["xOffset"] = 0,
								["fontType"] = "Walkway Black",
								["fontFlags"] = "",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 18,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 60,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -24,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["arena"] = {
							["targetWrapWidth"] = 180,
							["enable"] = true,
							["healthWidth"] = 180,
							["healthHeight"] = 45,
							["width"] = 158,
							["height"] = 130,
							["visibilityCondition"] = "1",
							["debuffs"] = {
								["perrow"] = 7,
							},
							["sort"] = {
								["startFrom"] = "TOPLEFT",
								["gapX"] = 0,
								["gapY"] = 15,
								["directionHorizontal"] = "+",
								["directionVertical"] = "-",
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 180,
								["barHeight"] = 8,
								["barXOffset"] = 0,
								["barYOffset"] = 0,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 18,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 175,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["party"] = {
							["targetWrapWidth"] = 180,
							["enable"] = true,
							["healthWidth"] = 180,
							["healthHeight"] = 45,
							["width"] = 158,
							["height"] = 130,
							["visibilityCondition"] = "[group:raid] 0; [group:party] 1; 0",
							["debuffs"] = {
								["perrow"] = 7,
							},
							["sort"] = {
								["startFrom"] = "TOPLEFT",
								["gapX"] = 0,
								["gapY"] = 15,
								["directionHorizontal"] = "+",
								["directionVertical"] = "-",
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 180,
								["barHeight"] = 8,
								["barXOffset"] = 0,
								["barYOffset"] = 0,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 18,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 175,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["raid"] = {
							["targetWrapWidth"] = 460,
							["enable"] = true,
							["healthWidth"] = 85,
							["healthHeight"] = 45,
							["width"] = 70,
							["height"] = 40,
							["visibilityCondition"] = "[@raid21, noexists] 1; 0",
							["debuffs"] = {
								["perrow"] = 7,
							},
							["sort"] = {
								["gapX"] = 1,
								["gapY"] = 1,
								["directionHorizontal"] = "-",
								["directionVertical"] = "+",
							},
							["portrait"] = {
								["enable"] = false,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 80,
								["barHeight"] = 9,
								["barXOffset"] = 0,
								["barYOffset"] = 2,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "LEFT",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = false,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 11,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 50,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 25,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["raid40"] = {
							["targetWrapWidth"] = 420,
							["enable"] = true,
							["healthWidth"] = 80,
							["healthHeight"] = 35,
							["width"] = 70,
							["height"] = 40,
							["visibilityCondition"] = "[@raid21, exists] 1; 0",
							["debuffs"] = {
								["perrow"] = 7,
							},
							["sort"] = {
								["startFrom"] = "TOPRIGHT",
								["gapX"] = 1,
								["gapY"] = 1,
								["directionHorizontal"] = "-",
								["directionVertical"] = "+",
							},
							["portrait"] = {
								["enable"] = false,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 75,
								["barHeight"] = 7,
								["barXOffset"] = 0,
								["barYOffset"] = 2,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "LEFT",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = false,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 0,
								["fontHeight"] = 11,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 50,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = false,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 25,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["boss"] = {
							["targetWrapWidth"] = 190,
							["enable"] = true,
							["healthWidth"] = 190,
							["healthHeight"] = 40,
							["width"] = 115,
							["height"] = 68,
							["visibilityCondition"] = "1",
							["debuffs"] = {
								["perrow"] = 7,
							},
							["sort"] = {
								["startFrom"] = "TOPLEFT",
								["gapX"] = 0,
								["gapY"] = 15,
								["directionHorizontal"] = "+",
								["directionVertical"] = "-",
							},
							["portrait"] = {
								["enable"] = true,
								["alpha"] = 0.25,
							},
							["power"] = {
								["text_format"] = "[powercolor][power:current-max]",
								["fontType"] = "Walkway Black",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "RIGHT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -10,
								["yOffset"] = 0,
								["width"] = 0,
								["barWidth"] = 190,
								["barHeight"] = 10,
								["barXOffset"] = 0,
								["barYOffset"] = -10,
								["barPosition"] = "BOTTOM",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["combatfade"] = true,
							["castbar"] = {
								["iconAttached"] = false,
								["iconSize"] = 54,
								["height"] = 35,
								["width"] = 478,
							},
							["health"] = {
								["text_format"] = "[healthcolor][health:current-max]",
								["position"] = "LEFT",
								["point"] = "TOP",
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["yOffset"] = 0,
								["fontType"] = "Walkway Black",
								["xOffset"] = 10,
								["fontFlags"] = "",
								["width"] = 0,
								["horizontalAlign"] = "LEFT",
								["barBackgroundColor"] = {0.1, 0.1, 0.1, 0.9},
								["barBorderColor"] = {0, 0, 0, 1},
								["fontColor"] = {1, 0.84, 0, 1},
								["barInverseFill"] = false,
								["barOrientation"] = "HORIZONTAL",
							},
							["name"] = {
								["text_format"] = "[namecolor][name]",
								["position"] = "CENTER",
								["enable"] = true,
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["xOffset"] = 0,
								["yOffset"] = 30,
								["fontHeight"] = 13,
								["fontType"] = "Walkway Black",
								["yFontShadowOffset"] = -1,
								["fontFlags"] = "OUTLINE",
								["width"] = 175,
							},
							["level"] = {
								["text_format"] = "[namecolor][name]",
								["fontHeight"] = 12,
								["position"] = "LEFT",
								["enable"] = true,
								["fontFlags"] = "",
								["fontType"] = "Walkway Black",
								["fontShadowColor"] = {0,0,0,1},
								["xFontShadowOffset"] = 1,
								["yFontShadowOffset"] = 1,
								["xOffset"] = -25,
								["yOffset"] = 0,
								["doNotShowOnMaxLevel"] = true,
								["width"] = 0,
								["fontColor"] = {1, 0.84, 0, 1},
							},
							["infoPanel"] = {
								["enable"] = true,
							},
							["height"] = 80,
							["classbar"] = {
								["height"] = 15,
								["autoHide"] = true,
							},
						},
						["all"] = {
							["reactionColors"] = {
								["friendly"] = E.ReactionColors["friendly"],
								["neutral"] = E.ReactionColors["neutral"],
								["unfriendly"] = E.ReactionColors["unfriendly"],
								["hostile"] = E.ReactionColors["hostile"],
							},
							["nameFont"] = {
								["type"] = "Walkway Black",
								["height"] = 15,
								["shadow"] = {}
							},
							["borderWidth"] = 50,
							["borderHeight"] = 1,
							["barTexture"] = "CUI Modern 2",
							["barTexturePath"] = "Interface/AddOns/CUI/Textures/minimalistic/minimalistic",
						},
					},
					
			},
		}
	}
	
	CO.db	=	LibStub("AceDB-3.0"):New("CUIDB", E.ConfigDefaults)
	CO.db:RegisterDefaults(E.ConfigDefaults)
	
	CO.db.RegisterCallback(CO, "OnProfileChanged", "ProfileUpdate");
	CO.db.RegisterCallback(CO, "OnProfileCopied", "ProfileUpdate");
	CO.db.RegisterCallback(CO, "OnProfileReset", "ProfileUpdate");
	--self.db.RegisterCallback(self, "OnDatabaseShutdown", "overrideFrames");
	
	CO:CreateOptions()
end

function CO:OpenOptions()
	-- E:print_r(ACD:Open("CUI")) -- Now returns a widget reference
	ACD:Open("CUI")
end

function CO:Init()
	L,UF,AB,LT,AUR,TT = E:LoadModules("Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")
	
	CO.AB = AB
	CO.UF = UF
	
	CO:InitializeSettings() -- Delay to access all modules [again. . .]
end

E:AddModule("Config", CO)