local E = select(2, ...) -- Engine
local CO,LOC,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local CO = CO
local db
local TTC = {}
	TTC.E = CreateFrame("Frame")

local Index = 85

CO:InitializeOptionsCategory("tooltip", "Tooltip", Index)

local function UpdateTooltip(type)
	local tooltipSettingType = CO.db.profile.tooltip[type]
	local profileData = tooltipSettingType
end

CO.Options.args.tooltip = {
	name = "Tooltip",
	type = 'group',
	order = 100,
	disabled = false,
	args = {
		headerHeader = {
			order = 1,
			type = "header",
			name = "Header",
		},
		headerFontType = {
			name = "Font Type",
			dialogControl = "LSM30_Font",
			type = "select",
			desc = "Font Type",
			order = 2,
			-- style = "dropdown",
			values = CO.AceGUIWidgetLSMlists["font"],
			get = function(info) return CO.db.profile.tooltip.header["fontType"] end,
			set = function(info, value) CO.db.profile.tooltip.header["fontType"] = value; end,
		},
		headerFontSize = {
			order = 3,
			type = 'range',
			name = "Font height",
			desc = "Font height",
			min = 3, max = 90, step = 1,
			get = function(info) return CO.db.profile.tooltip.header["fontSize"] end,
			set = function(info, value) CO.db.profile.tooltip.header["fontSize"] = value; CO:ShowNotification("FONT_TYPE_NOTIFICATION") end,
		},
		
		bodyHeader = {
			order = 11,
			type = "header",
			name = "Body",
		},
		bodyFontType = {
			name = "Font Type",
			dialogControl = "LSM30_Font",
			type = "select",
			desc = "Font Type",
			order = 12,
			-- style = "dropdown",
			values = CO.AceGUIWidgetLSMlists["font"],
			get = function(info) return CO.db.profile.tooltip.body["fontType"] end,
			set = function(info, value) CO.db.profile.tooltip.body["fontType"] = value; end,
		},
		bodyFontSize = {
			order = 13,
			type = 'range',
			name = "Font height",
			desc = "Font height",
			min = 3, max = 90, step = 1,
			get = function(info) return CO.db.profile.tooltip.body["fontSize"] end,
			set = function(info, value) CO.db.profile.tooltip.body["fontSize"] = value; CO:ShowNotification("FONT_TYPE_NOTIFICATION") end,
		},
		--name = GetOptionsTable_Text("boss", "name"),
		--health = GetOptionsTable_Text("boss", "health"),
		--power = GetOptionsTable_Text("boss", "power"),
		--level = GetOptionsTable_Text("boss", "level"),

		bgHeader = {
			order = 21,
			type = "header",
			name = "Background",
		},
		bgAlpha = {
			order = 22,
			type = 'range',
			name = "Background Alpha",
			desc = "Background Alpha",
			min = 0, max = 1, step = 0.01,
			get = function(info) return CO.db.profile.tooltip.background["alpha"] end,
			set = function(info, value) CO.db.profile.tooltip.background["alpha"] = value; CO:ShowNotification("FONT_TYPE_NOTIFICATION") end,
		},
	},
	
}

-- Initial callback when the addon is ready (E:OnEnable)
-- It is elemental for this to be designed around update calls that don't need any args !!!
function TTC:Init()
	db = CO.db.profile.tooltip
end

E:AddSettingsModule(TTC)