local E = select(2, ...) -- Engine
local CO,LOC,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local CO = CO
local db
local MM = {}
	MM.E = CreateFrame("Frame")

local Index = 85

CO:InitializeOptionsCategory("minimap", "Minimap", Index)



function MM:updateSize()
	MinimapCluster:SetScale(db.scale)
end

CO.Options.args.minimap = {
	name = "Minimap",
	type = 'group',
	order = Index,
	disabled = false,
	args = {
		minimapHeader = {
			order = 1,
			type = "header",
			name = "Camera Settings",
		},
		minimapDesc = {
			type = "description",
			order = 2,
			name = "",
			fontSize = "small",
		},
		scale = {
			order = 3,
			type = 'range',
			name = "Scale",
			desc = "Set the minimap scaling factor",
			min = 0.01, max = 10, step = 0.01,
			width = "full",
			get = function() return db.scale end,
			set = function(info, value) db.scale = value; MM:updateSize(); end,
		},
		
	},
}

-- Initial callback when the addon is ready (E:OnEnable)
-- It is elemental for this to be designed around update calls that don't need any args !!!
function MM:Init()
	db = CO.db.profile.minimap
	
	self:updateSize()
end

E:AddSettingsModule(MM)