local E = select(2, ...) -- Engine
local CO,LOC,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local CO = CO
local ES = {} -- EngineSettings
	ES.E = CreateFrame("Frame")

local Index = 75

CO:InitializeOptionsCategory("engine", "Engine", Index)

-- Call Camera adjust on event to be absolutely sure [worked for a REALLY long time now]
do
	ES.E:RegisterEvent("ADDON_LOADED")
	ES.E:RegisterEvent("PLAYER_ENTERING_WORLD")
end

function ES:updateCameraSpeed()
	SetCVar("cameraPitchMoveSpeed", CO.db.profile.CVars.cameraPitchMoveSpeed)
	SetCVar("cameraYawMoveSpeed", CO.db.profile.CVars.cameraYawMoveSpeed)
	
	SetCVar("cameraPitchSmoothSpeed", CO.db.profile.CVars.cameraPitchMoveSpeed - 10)
	SetCVar("cameraYawSmoothSpeed", CO.db.profile.CVars.cameraYawMoveSpeed - 10)
end

function ES:updateDynamic()	
	SetCVar("test_cameraDynamicPitch", CO.db.profile.CVars.test_cameraDynamicPitch)
	SetCVar("test_cameraDynamicPitchBaseFovPad", CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPad)
	SetCVar("test_cameraDynamicPitchBaseFovPadFlying", CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPadFlying)
	
	SetCVar("test_cameraTargetFocusEnemyEnable", CO.db.profile.CVars.test_cameraTargetFocusEnemyEnable)
	SetCVar("test_cameraTargetFocusEnemyStrengthPitch", CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthPitch)
	SetCVar("test_cameraTargetFocusEnemyStrengthYaw", CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthYaw)
	
	SetCVar("test_cameraTargetFocusInteractEnable", CO.db.profile.CVars.test_cameraTargetFocusInteractEnable)
	SetCVar("test_cameraTargetFocusInteractStrengthPitch", CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthPitch)
	SetCVar("test_cameraTargetFocusInteractStrengthYaw", CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthYaw)
	
	SetCVar("test_cameraOverShoulder", CO.db.profile.CVars.test_cameraOverShoulder)
	SetCVar("test_cameraHeadMovementStrength", CO.db.profile.CVars.test_cameraHeadMovementStrength)
end

CO.Options.args.engine = {
	name = "Engine",
	type = 'group',
	childGroups = "tab",
	order = Index,
	disabled = false,
	args = {
		generalCamera = {
			name = "Camera",
			type = "group",
			order = 1,
			args = {
				cameraHeader = {
					order = 1,
					type = "header",
					name = TUTORIAL_TITLE3,
				},
				cameraDesc = {
					type = "description",
					order = 2,
					name = "Those settings are intended for high-DPI displays or high resolutions in general, since the default camera settings does not do a good job on them. Feel free to experiment for what suits your feeling or set one or both settings to 0 to use the engines default value |cffFF0000after a required reload (just for a value of 0 !)|r.",
					fontSize = "small",
				},
				yawSpeed = {
					order = 3,
					type = 'range',
					name = "Yaw Speed Override",
					desc = "Adjust the camera yaw speed (Left/Right)\nSet to 0 and use /reload to use the engine default",
					min = 0, max = 200, step = 0.05,
					width = "full",
					get = function() return CO.db.profile.CVars.cameraYawMoveSpeed end,
					set = function(info, value) CO.db.profile.CVars.cameraYawMoveSpeed = value; ES:updateCameraSpeed(); end,
				},
				pitchSpeed = {
					order = 4,
					type = 'range',
					name = "Pitch Speed Override",
					desc = "Adjust the camera pitch speed (Up/Down)\nSet to 0 and use /reload to use the engine default",
					min = 0, max = 200, step = 0.05,
					width = "full",
					get = function() return CO.db.profile.CVars.cameraPitchMoveSpeed end,
					set = function(info, value) CO.db.profile.CVars.cameraPitchMoveSpeed = value; ES:updateCameraSpeed(); end,
				},
			},
		},
		actioncam = {
			name = "Actioncam",
			type = "group",
			order = 2,
			args = {
				cameraDesc = {
					type = "description",
					order = 0,
					name = "Those settings provide basic functionality of the new (Legion) actioncam. If you want further options, it is advised to uncheck the checkboxes below, leave the shoulder offset at 0 and using 'DynamicCam' for it!",
					fontSize = "small",
				},
				notificationToggle = {
					order = 1,
					type = "toggle",
					name = "Hide Notification",
					desc = "Hide/Show the blizzard actioncam notification on login.",
					set = function(info, value) CO.db.profile.engine.hideActioncamNotification = value; end,
					get = function() return CO.db.profile.engine.hideActioncamNotification end
				},
				test_cameraHeadMovementStrength = {
					order = 3,
					type = 'range',
					name = "Head Tracking Strength",
					desc = "Adjusts how much the camera is affected by head movement",
					min = 0, max = 5, step = 0.1,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraHeadMovementStrength end,
					set = function(info, value) CO.db.profile.CVars.test_cameraHeadMovementStrength = value; ES:updateDynamic(); end,
				},
				test_cameraOverShoulder = {
					order = 4,
					type = 'range',
					name = "Camera Shoulder Offset",
					desc = "Adjusts how far the camera should be offset to the left/right",
					min = -5, max = 5, step = 0.1,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraOverShoulder end,
					set = function(info, value) CO.db.profile.CVars.test_cameraOverShoulder = value; ES:updateDynamic(); end,
				},
				cameraHeader = {
					order = 10,
					type = "header",
					name = "Dynamic Pitch",
				},
				dynamicCameraPitch = {
					order = 15,
					type = "toggle",
					name = "Dynamic Camera Pitch",
					desc = "Use the new actioncam to control the camera pitch",
					width = "full",
					set = function(info, value) CO.db.profile.CVars.test_cameraDynamicPitch = value; ES:updateDynamic(); end,
					get = function() return CO.db.profile.CVars.test_cameraDynamicPitch end
				},
				test_cameraDynamicPitchBaseFovPad = {
					order = 16,
					type = 'range',
					name = "Base FoV Pad",
					desc = "Adjusts how far the camera is turned up/down",
					min = 0, max = 1, step = 0.01,
					get = function() return CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPad end,
					set = function(info, value) CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPad = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraDynamicPitch end,
				},
				test_cameraDynamicPitchBaseFovPadFlying = {
					order = 17,
					type = 'range',
					name = "Flying FoV Pad",
					desc = "Adjusts how far the camera is turned up/down when flying",
					min = 0, max = 1, step = 0.01,
					get = function() return CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPadFlying end,
					set = function(info, value) CO.db.profile.CVars.test_cameraDynamicPitchBaseFovPadFlying = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraDynamicPitch end,
				},
				focusEnemyHeader = {
					order = 24,
					type = "header",
					name = "|cffbc1a32Enemy Focus|r",
				},
				cameraFocusEnemyTarget = {
					order = 25,
					type = "toggle",
					name = "|cffbc1a32Focus Enemy|r",
					desc = "Use the new actioncam to control the camera pitch",
					width = "full",
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusEnemyEnable = value; ES:updateDynamic(); end,
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusEnemyEnable end
				},
				test_cameraTargetFocusEnemyStrengthPitch = {
					order = 26,
					type = 'range',
					name = "|cffbc1a32Focus Pitch Strength|r",
					desc = "Adjusts how much the cameras pitch (up/down) is being influenced by the focus",
					min = 0, max = 1, step = 0.01,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthPitch end,
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthPitch = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraTargetFocusEnemyEnable end,
				},
				test_cameraTargetFocusEnemyStrengthYaw = {
					order = 27,
					type = 'range',
					name = "|cffbc1a32Focus Yaw Strength|r",
					desc = "Adjusts how much the cameras yaw (left/right) is being influenced by the focus",
					min = 0, max = 1, step = 0.01,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthYaw end,
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusEnemyStrengthYaw = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraTargetFocusEnemyEnable end,
				},
				focusFriendlyHeader = {
					order = 30,
					type = "header",
					name = "|cff1a65bcFriendly Focus|r",
				},
				test_cameraTargetFocusInteractEnable = {
					order = 31,
					type = "toggle",
					name = "|cff1a65bcCamera focus friendly target|r",
					desc = "Use the new actioncam to control the camera pitch",
					width = "full",
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusInteractEnable = value; ES:updateDynamic(); end,
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusInteractEnable end
				},
				test_cameraTargetFocusInteractStrengthPitch = {
					order = 32,
					type = 'range',
					name = "|cff1a65bcFocus Pitch Strength|r",
					desc = "Adjusts how much the cameras pitch (up/down) is being influenced by the focus",
					min = 0, max = 1, step = 0.01,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthPitch end,
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthPitch = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraTargetFocusInteractEnable end,
				},
				test_cameraTargetFocusInteractStrengthYaw = {
					order = 33,
					type = 'range',
					name = "|cff1a65bcFocus Yaw Strength|r",
					desc = "Adjusts how much the cameras yaw (left/right) is being influenced by the focus",
					min = 0, max = 1, step = 0.01,
					width = "full",
					get = function() return CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthYaw end,
					set = function(info, value) CO.db.profile.CVars.test_cameraTargetFocusInteractStrengthYaw = value; ES:updateDynamic(); end,
					disabled = function() return not CO.db.profile.CVars.test_cameraTargetFocusInteractEnable end,
				},
			},
		},
	},
}

-- Initial callback when the addon is ready (E:OnEnable)
-- It is elemental for this to be designed around update calls that don't need any args !!!
function ES:Init()
	ES.E:SetScript("OnEvent", function(self, event, ...)
		ES:updateCameraSpeed()
		ES:updateDynamic()
	end)
	
	-- Hide and then hook to hide the next one that probably shows up - This thing is annoying. Cannot do anything about the sound sadly
	if CO.db.profile.engine.hideActioncamNotification then
		UIParent:UnregisterEvent("EXPERIMENTAL_CVAR_CONFIRMATION_NEEDED")
		--StaticPopup_Hide("EXPERIMENTAL_CVAR_WARNING")
		--hooksecurefunc("StaticPopup_Show", function(...) StaticPopup_Hide("EXPERIMENTAL_CVAR_WARNING") end)
	end
end

E:AddSettingsModule(ES)