local E = select(2, ...) -- Engine
local CO,L = E:LoadModules("Config", "Locale")

local _
local CO = CO
local db
local RRD
local DF = {}
	DF.E = CreateFrame("Frame")

local Index = 90

CO:InitializeOptionsCategory("dataframes", "Dataframes", Index)

CO.Options.args.dataframes = {
	name = "Dataframes",
	type = 'group',
	order = 100,
	childGroups = "tab",
	args = {
		raidroledata = {
			order = 1,
			type = 'group',
			name = "RaidRoleData",
			get = function(info) return CO.db.profile.dataframes["raidroledata"][ info[#info] ] end,
			set = function(info, value) CO.db.profile.dataframes["raidroledata"][ info[#info] ] = value; RRD:LoadProfile() end,
			args = {
				scale = {
					order = 1,
					type = 'range',
					name = "Scale",
					desc = "Scale",
					min = 0.1, max = 5, step = 0.01,
				},
				toggle = {
					order = 2,
					type = "execute",
					name = "Toggle",
					desc = "Toggle",
					func = function() if not RRD:IsVisible() then RRD:Show(); else RRD:Hide(); end; end,
				}
			}
		}
	},
	
}

-- Initial callback when the addon is ready (E:OnEnable)
-- It is elemental for this to be designed around update calls that don't need any args !!!
function DF:Init()
	db = CO.db.profile.dataframes
	
	RRD = E:GetModule("RaidRoleData")
end

E:AddSettingsModule(DF)