local E = select(2, ...) -- Engine
local CO,L,UF,AB,LT,AUR,TT = E:LoadModules("Config", "Locale", "Unitframes", "Actionbars", "Layout", "Auras", "Tooltip")

local _
local CO = CO

local Index = 50

CO:InitializeOptionsCategory("actionbar", L["Actionbars"], Index)

local function GetOptionsTable_Actionbar(index, indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = string.format("%s %s", L["Bar"], index),
		get = function(info) return CO.db.profile.actionbar["bar" .. index][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["bar" .. index][ info[#info] ] = value; CO.AB:UpdateActionbar(index); CO.AB:UpdateActionButtonStyle() end,
		args = {
			header = {
				order = 10,
				type = "header",
				name = string.format("%s %s", L["Bar"], index),
			},
			enable = {
				type = "toggle",
				order = 11,
				name = L["Enable"],
				width = "full",
			},
			showGrid = {
				type = "toggle",
				order = 12,
				name = L["ShowGrid"],
				width = "full",
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			barPosition = {
				type = 'select',
				order = 20,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["point"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["point"] = value
					
					CO.AB:UpdateActionbar(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			xOffset = {
				order = 21,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["xOffset"] = value
					CO.AB:UpdateActionbar(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			yOffset = {
				order = 22,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_ActionBar" .. index .. "Mover"]["yOffset"] = value
					CO.AB:UpdateActionbar(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			visibilityCondition = {
				order = 23,
				type = 'input',
				name = "Visibility",
				desc = "A string of macro conditionals to determine, whether the bar should be displayed.\nSome possible values:\n[pet] [petbattle] [combat] [vehicle] [flying] [form:N] [stealth]\n\nFind more at https://wow.gamepedia.com/Macro_conditionals",
				width = "full",
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			defaultVisibility = {
				order = 24,
				type = "execute",
				name = "Default Visiblity",
				desc = "In case you want to reset the visiblity string to default",
				func = function()
					CO.db.profile.actionbar["bar" .. index].visibilityCondition = E.ConfigDefaults.profile.actionbar["bar" .. index].visibilityCondition
					CO.AB:UpdateActionbar(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			header = {
				order = 40,
				type = "header",
				name = "Button Config",
			},
			buttonsPerRow = {
				order = 41,
				type = 'range',
				name = "Buttons per row",
				desc = "Buttons per row. Set to negative value to invert the direction",
				min = -12, max = 12, step = 1,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			buttonNum = {
				order = 42,
				type = 'range',
				name = "Button Count",
				desc = "Button Count",
				min = 1, max = 12, step = 1,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			buttonSizeMultiplier = {
				order = 43,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			buttonGap = {
				order = 44,
				type = 'range',
				name = "Button Gap",
				desc = "Button Gap",
				min = -50, max = 50, step = 1,
				disabled = function() return not CO.db.profile.actionbar["bar" .. index]["enable"] end,
			},
			
		},
	}
	
	if index > 7 then
		local extension = {
			warningDesc = {
				type = "description",
				order = 1,
				name = "|cffFF0000WARNING: This bar is already reserved for Druid Shapeshifting!\nBar 8 also for the Rogue Stealth!\nIf you change/remove any spells from this bar, this will also affect your main bar!\nIt is advised to leave this bar untouched and disabled when playing a Druid or a Rogue!\n\n|r",
				fontSize = "small",
			},
		}
		
		for k,v in pairs(extension) do
			config.args[k] = v
		end
	end

	return config
end

local function GetOptionsTable_Petbar(index, indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = "Pet Bar",
		get = function(info) return CO.db.profile.actionbar["petbar"][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["petbar"][ info[#info] ] = value; CO.AB:UpdateActionbar("petbar"); CO.AB:UpdateActionButtonStyle() end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = "Pet Bar",
			},
			enable = {
				type = "toggle",
				order = 2,
				name = L["Enable"],
				width = "full",
			},
			barPosition = {
				type = 'select',
				order = 3,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["CUI_PetActionbarMover"]["point"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_PetActionbarMover"]["point"] = value
					
					CO.AB:UpdateActionbar("petbar")
				end,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			xOffset = {
				order = 4,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_PetActionbarMover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_PetActionbarMover"]["xOffset"] = value
					CO.AB:UpdateActionbar("petbar")
				end,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			yOffset = {
				order = 5,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_PetActionbarMover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_PetActionbarMover"]["yOffset"] = value
					CO.AB:UpdateActionbar("petbar")
				end,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			visibilityCondition = {
				order = 6,
				type = 'input',
				name = "Visibility",
				desc = "A string of macro conditionals to determine, whether the bar should be displayed.\nSome possible values:\n[pet] [petbattle] [combat] [vehicle] [flying] [form:N] [stealth]\n\nFind more at https://wow.gamepedia.com/Macro_conditionals",
				width = "full",
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			defaultVisibility = {
				order = 7,
				type = "execute",
				name = "Default Visiblity",
				desc = "In case you want to reset the visiblity string to default",
				func = function()
					CO.db.profile.actionbar["petbar"].visibilityCondition = E.ConfigDefaults.profile.actionbar["petbar"].visibilityCondition
					CO.AB:UpdateActionbar("petbar")
				end,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			header = {
				order = 10,
				type = "header",
				name = "Button Config",
			},
			buttonsPerRow = {
				order = 11,
				type = 'range',
				name = "Buttons per row",
				desc = "Buttons per row. Set to negative value to invert the direction",
				min = -12, max = 12, step = 1,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			buttonSizeMultiplier = {
				order = 12,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			buttonGap = {
				order = 13,
				type = 'range',
				name = "Button Gap",
				desc = "Button Gap",
				min = -50, max = 50, step = 1,
				disabled = function() return not CO.db.profile.actionbar["petbar"]["enable"] end,
			},
			
		},
	}

	return config
end

local function GetOptionsTable_Stancebar(indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = L["Stancebar"],
		get = function(info) return CO.db.profile.actionbar["stancebar"][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["stancebar"][ info[#info] ] = value; CO.AB:UpdateActionbar("stancebar") end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = L["Stancebar"],
			},
			enable = {
				type = "toggle",
				order = 2,
				name = L["Enable"],
				width = "full",
			},
			barPosition = {
				type = 'select',
				order = 3,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["CUI_StanceBarMover"]["barPosition"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_StanceBarMover"]["barPosition"] = value
					CO.AB:UpdateActionbar("stancebar")
				end,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
			xOffset = {
				order = 4,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_StanceBarMover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_StanceBarMover"]["xOffset"] = value
					CO.AB:UpdateActionbar("stancebar")
				end,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
			yOffset = {
				order = 5,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["CUI_StanceBarMover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["CUI_StanceBarMover"]["yOffset"] = value
					CO.AB:UpdateActionbar("stancebar")
				end,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
			header = {
				order = 6,
				type = "header",
				name = "Button Config",
			},
			buttonsPerRow = {
				order = 7,
				type = 'range',
				name = "Buttons per row",
				desc = "Buttons per row. Set to negative value to invert the direction",
				min = -12, max = 12, step = 1,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
			buttonNum = {
				order = 8,
				type = 'range',
				name = "Button Count",
				desc = "Button Count",
				min = 1, max = 12, step = 1,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] or true end,
			},
			buttonSizeMultiplier = {
				order = 9,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
			buttonGap = {
				order = 10,
				type = 'range',
				name = "Button Gap",
				desc = "Button Gap",
				min = -50, max = 50, step = 1,
				disabled = function() return not CO.db.profile.actionbar["stancebar"]["enable"] end,
			},
		},
	}

	return config
end

local function GetOptionsTable_Extrabar(indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = "Extra Button",
		get = function(info) return CO.db.profile.actionbar["extrabar"][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["extrabar"][ info[#info] ] = value; CO.AB:UpdateExtraActionButton() end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = "Extra Button",
			},
			barPosition = {
				type = 'select',
				order = 3,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["ExtraActionBarFrameMover"]["point"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ExtraActionBarFrameMover"]["point"] = value
					CO.AB:UpdateExtraActionButton()
				end,
			},
			xOffset = {
				order = 4,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["ExtraActionBarFrameMover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ExtraActionBarFrameMover"]["xOffset"] = value
					CO.AB:UpdateExtraActionButton(index)
				end,
			},
			yOffset = {
				order = 5,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["ExtraActionBarFrameMover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ExtraActionBarFrameMover"]["yOffset"] = value
					CO.AB:UpdateExtraActionButton(index)
				end,
			},
			buttonSizeMultiplier = {
				order = 9,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
			},
		},
	}

	return config
end

local function GetOptionsTable_Zonebar(indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = "Zone Button",
		get = function(info) return CO.db.profile.actionbar["zonebar"][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["zonebar"][ info[#info] ] = value; CO.AB:UpdateZoneActionButton() end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = "Zone Button",
			},
			barPosition = {
				type = 'select',
				order = 3,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["ZoneAbilityFrameMover"]["point"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ZoneAbilityFrameMover"]["point"] = value
					CO.AB:UpdateZoneActionButton()
				end,
			},
			xOffset = {
				order = 4,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["ZoneAbilityFrameMover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ZoneAbilityFrameMover"]["xOffset"] = value
					CO.AB:UpdateZoneActionButton(index)
				end,
			},
			yOffset = {
				order = 5,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["ZoneAbilityFrameMover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["ZoneAbilityFrameMover"]["yOffset"] = value
					CO.AB:UpdateZoneActionButton(index)
				end,
			},
			buttonSizeMultiplier = {
				order = 9,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
			},
		},
	}

	return config
end

local function GetOptionsTable_MicroMenu(indexOrder)
	
	local config = {
		order = indexOrder,
		type = 'group',
		name = "Micromenu",
		get = function(info) return CO.db.profile.actionbar["micromenu"][ info[#info] ] end,
		set = function(info, value) CO.db.profile.actionbar["micromenu"][ info[#info] ] = value; CO.AB:UpdateMicroMenu() end,
		args = {
			header = {
				order = 1,
				type = "header",
				name = "Micromenu",
			},
			enable = {
				type = "toggle",
				order = 2,
				name = L["Enable"],
				width = "full",
			},
			barPosition = {
				type = 'select',
				order = 3,
				name = "Position",
				values = E.Positions,
				get = function(info)
					return CO.db.profile.movers["MicroMenuMover"]["point"]
				end,
				set = function(info, value)
					CO.db.profile.movers["MicroMenuMover"]["point"] = value
					CO.AB:UpdateMicroMenu()
				end,
				disabled = function() return not CO.db.profile.actionbar["micromenu"]["enable"] end,
			},
			xOffset = {
				order = 4,
				type = 'range',
				name = "xOffset",
				desc = "xOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["MicroMenuMover"]["xOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["MicroMenuMover"]["xOffset"] = value
					CO.AB:UpdateMicroMenu(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["micromenu"]["enable"] end,
			},
			yOffset = {
				order = 5,
				type = 'range',
				name = "yOffset",
				desc = "yOffset",
				min = -1920, max = 1920, step = 1,
				get = function(info)
					return CO.db.profile.movers["MicroMenuMover"]["yOffset"]
				end,
				set = function(info, value)
					CO.db.profile.movers["MicroMenuMover"]["yOffset"] = value
					CO.AB:UpdateMicroMenu(index)
				end,
				disabled = function() return not CO.db.profile.actionbar["micromenu"]["enable"] end,
			},
			buttonSizeMultiplier = {
				order = 9,
				type = 'range',
				name = "Button size",
				desc = "Button size multiplier",
				min = 0.1, max = 5, step = 0.05,
				disabled = function() return not CO.db.profile.actionbar["micromenu"]["enable"] end,
			},
		},
	}

	return config
end

CO.Options.args.actionbar = {
	name = L["Actionbars"],
	type = 'group',
	order = Index,
	disabled = false,
	args = {
		borderHeader = {
			order = 1,
			type = "header",
			name = "Button Border Texture",
		},
		borderTextureColor = {
		  name = "Border Color",
		  type = "color",
		  hasAlpha = true,
		  desc = "Border Color",
		  order = 2,
		  get = function(info)
				local c = CO.db.profile.actionbar["global"]["borderTextureColor"]
				return c.r, c.g, c.b, c.a
		  end,
		  set = function(info, r, g, b, a)
				CO.db.profile.actionbar["global"]["borderTextureColor"].r, CO.db.profile.actionbar["global"]["borderTextureColor"].g, CO.db.profile.actionbar["global"]["borderTextureColor"].b, CO.db.profile.actionbar["global"]["borderTextureColor"].a = r, g, b, a
				CO.AB:UpdateActionButtonStyle()
		  end,
		  disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		borderTextureBlendMode = {
			type = 'select',
			order = 3,
			name = "Blend Mode",
			values = E.BlendModes,
			get = function(info)
				return CO.db.profile.actionbar["global"]["borderTextureBlendMode"]
			end,
			set = function(info, value)
				CO.db.profile.actionbar["global"]["borderTextureBlendMode"] = value
				CO.AB:UpdateActionButtonStyle()
			end,
			disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		normalHeader = {
			order = 10,
			type = "header",
			name = "Button Normal Texture",
		},
		normalTextureColor = {
		  name = "Normal Color",
		  type = "color",
		  hasAlpha = true,
		  desc = "Normal Color",
		  order = 11,
		  get = function(info)
				local c = CO.db.profile.actionbar["global"]["normalTextureColor"]
				return c.r, c.g, c.b, c.a
		  end,
		  set = function(info, r, g, b, a)
				local c = CO.db.profile.actionbar["global"]["normalTextureColor"]
				c.r, c.g, c.b, c.a = r, g, b, a
				CO.AB:UpdateActionButtonStyle()
		  end,
		  disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		normalTextureBlendMode = {
			type = 'select',
			order = 12,
			name = "Blend Mode",
			values = E.BlendModes,
			get = function(info)
				return CO.db.profile.actionbar["global"]["normalTextureBlendMode"]
			end,
			set = function(info, value)
				CO.db.profile.actionbar["global"]["normalTextureBlendMode"] = value
				CO.AB:UpdateActionButtonStyle()
			end,
			disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		highlightHeader = {
			order = 20,
			type = "header",
			name = "Button Highlight Texture",
		},
		highlightTextureColor = {
		  name = "Highlight Color",
		  type = "color",
		  hasAlpha = true,
		  desc = "Highlight Color",
		  order = 21,
		  get = function(info)
				local c = CO.db.profile.actionbar["global"]["highlightTextureColor"]
				return c.r, c.g, c.b, c.a
		  end,
		  set = function(info, r, g, b, a)
				local c = CO.db.profile.actionbar["global"]["highlightTextureColor"]
				c.r, c.g, c.b, c.a = r, g, b, a
				CO.AB:UpdateActionButtonStyle()
		  end,
		  disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		highlightTextureBlendMode = {
			type = 'select',
			order = 22,
			name = "Blend Mode",
			values = E.BlendModes,
			get = function(info)
				return CO.db.profile.actionbar["global"]["highlightTextureBlendMode"]
			end,
			set = function(info, value)
				CO.db.profile.actionbar["global"]["highlightTextureBlendMode"] = value
				CO.AB:UpdateActionButtonStyle()
			end,
			disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		pushedHeader = {
			order = 23,
			type = "header",
			name = "Button Pushed Texture",
		},
		pushedTextureColor = {
		  name = "Pushed Color",
		  type = "color",
		  hasAlpha = true,
		  desc = "Pushed Color",
		  order = 24,
		  get = function(info)
				local c = CO.db.profile.actionbar["global"]["pushedTextureColor"]
				return c.r, c.g, c.b, c.a
		  end,
		  set = function(info, r, g, b, a)
				local c = CO.db.profile.actionbar["global"]["pushedTextureColor"]
				c.r, c.g, c.b, c.a = r, g, b, a
				CO.AB:UpdateActionButtonStyle()
		  end,
		  disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		pushedTextureBlendMode = {
			type = 'select',
			order = 25,
			name = "Blend Mode",
			desc = "Pushed Blend Mode",
			values = E.BlendModes,
			get = function(info)
				return CO.db.profile.actionbar["global"]["pushedTextureBlendMode"]
			end,
			set = function(info, value)
				CO.db.profile.actionbar["global"]["pushedTextureBlendMode"] = value
				CO.AB:UpdateActionButtonStyle()
			end,
			disabled = function() return CO.db.profile.actionbar.useMasque end,
		},
		
		masqueHeader = {
			order = 26,
			type = "header",
			name = "Additional AddOns",
		},
		useMasque = {
			type = "toggle",
			order = 27,
			name = "Use Masque",
			desc = "Leave styling the actionbuttons to masque (if installed)",
			get = function() return CO.db.profile.actionbar.useMasque end,
			set = function(info, value) CO.db.profile.actionbar.useMasque = value; CO:ProfileUpdate() end,
		},
		functionHeader = {
			order = 50,
			type = "header",
			name = "Global Functions",
		},
		clearAllButtons = {
			type = "execute",
			name = "Clear all Slots",
			desc = "This action literally clears all your actionbars. Use with caution and just if you really want to do this!",
			width = "full",
			order = 51,
			func = function()
				CO:ShowNotification("CLEAR_ACTIONBARS_NOTIFICATION")
			end
		},
		
		bar1 = GetOptionsTable_Actionbar(1,1),
		bar2 = GetOptionsTable_Actionbar(2,2),
		bar3 = GetOptionsTable_Actionbar(3,3),
		bar4 = GetOptionsTable_Actionbar(4,4),
		bar5 = GetOptionsTable_Actionbar(5,5),
		bar6 = GetOptionsTable_Actionbar(6,6),
		bar7 = GetOptionsTable_Actionbar(7,7),
		bar8 = GetOptionsTable_Actionbar(8,8),
		bar9 = GetOptionsTable_Actionbar(9,9),
		bar10 = GetOptionsTable_Actionbar(10,10),
		-- bar11 = GetOptionsTable_Actionbar(11,11),
		-- bar12 = GetOptionsTable_Actionbar(12,12),
		petbar = GetOptionsTable_Petbar(15),
		stancebar = GetOptionsTable_Stancebar(20),
		extrabar = GetOptionsTable_Extrabar(30),
		zonebar = GetOptionsTable_Zonebar(40),
		micromenu = GetOptionsTable_MicroMenu(50),
	},
}