------------------------------------------------------------------------------------------
-- DO NOT TOUCH CONTENTS BELOW (unless you know what you're doing) !!
------------------------------------------------------------------------------------------
local E = select(2, ...) -- Engine
local CO, AL = E:LoadModules("Config", "ArtLib")

local Dir = [[Interface\AddOns\CUI\]]
local FontDir = Dir .. [[Fonts\]]
local TextureDir = Dir .. [[Textures\statusbar\]]
------------------------------------------------------------------------------------------
-- DO NOT TOUCH CONTENTS ABOVE (unless you know what you're doing) !!
------------------------------------------------------------------------------------------

-- BLPNG-Converter: http://www.wowinterface.com/downloads/info22128-BLPNGConverter.html

--[[
	-- General Lua-programming note:
		-- 	double [ stands for a concatenation of letters/symbols/names/ etc.
		--	It defines a so called "string" that will not be closed by symbols like " and also registers line breaks.
		-- The .. operator is used for string concatenation. Using it like "Hello" .. "World" will result in "HelloWorld".
		
		-- Below, you'll find the AL.Fonts and AL.StatusbarTextures tables.
		-- A table stores various information - and - in some cases - even other tables and so on.
		-- If we write ["FontName"] inside of that table, we created a so called key.
		-- A key can hold the precious values we want to access (or other tables that contain values)
		-- Sometimes, if we need just one "value", the key alone will do its job. The only thing that changes is the syntax.
		-- It then changes to just "FontName". We simply remove the brackets.
		
	-- General Game Texture note:
		-- All game textures have to have a width and height by the power of two.
		-- This means, accepted width and height values are: 2,4,8,16,32,64,128,256,512,1024,2048,4096 and so on.
		-- The width and height are not required to be the same!
		-- For WoW, they come in the BLP or TGA format.
		-- I've found BLP for me to be the way to go, since it's really powerful, high-quality and easy to create.
		-- You may have noticed, that programs like photoshop do NOT support the BLP format.
		-- The way i go about it is to simply create the desired texture, save it as a png (you also may use transparency)
		-- and convert it to BLP via "BLPNG Converter". This is a very powerful and accurate tool when it comes to converting textures.
		-- You simply drag the png texture from your explorer into "BLPNG"'s "BLP" field and the tool will do the magic.
		-- You can find the link to this tool up here in the description.
		-- All our statusbar textures are getting tiled, not stretched. So, in theory, a texture with the dimensions
		-- 2 x 128 would work. Just mind the power of two!
		-- Congrats, you just created your very own texture!
		-- Now add it to the table below~
]]

---------------------------------------------------------------
-- EDITABLE AREA
---------------------------------------------------------------



-- Syntax: ["FontName"] = [[Path\To\Font]],
-- Mind the , at the end of each line and make sure you closed all [ and " !!
-- The key is the Font name listed in the dropdown menus!
-- Example: ["Walkway Oblique"] 	= FontDir .. [[Walkway_Oblique.ttf]],
-- FontDir represents the "Font" directory in the CUI root.
AL.Fonts = {
	-- DEFAULTS, DO NOT REMOVE
	["EncodeSans Black"] 			= FontDir .. [[EncodeSans-Black.ttf]],
	["EncodeSans Bold"] 			= FontDir .. [[EncodeSans-Bold.ttf]],
	["EncodeSans ExtraBold"] 		= FontDir .. [[EncodeSans-ExtraBold.ttf]],
	["EncodeSans ExtraLight"] 		= FontDir .. [[EncodeSans-ExtraLight.ttf]],
	["EncodeSans Light"] 			= FontDir .. [[EncodeSans-Light.ttf]],
	["EncodeSans Medium"] 			= FontDir .. [[EncodeSans-Medium.ttf]],
	["EncodeSans Regular"] 			= FontDir .. [[EncodeSans-Regular.ttf]],
	["EncodeSans SemiBold"] 		= FontDir .. [[EncodeSans-SemiBold.ttf]],
	["EncodeSans Thin"] 			= FontDir .. [[EncodeSans-Thin.ttf]],
	["Michroma"] 					= FontDir .. [[Michroma.ttf]],
	["Julius Sans One"] 			= FontDir .. [[JuliusSansOne-Regular.ttf]],
	["Walkway Oblique"] 			= FontDir .. [[Walkway_Oblique.ttf]],
	["Walkway Oblique UltraBold"] 	= FontDir .. [[Walkway_Oblique_UltraBold.ttf]],
	["Walkway Black"] 				= FontDir .. [[Walkway_Black.ttf]],
	["Walkway Oblique Black"] 		= FontDir .. [[Walkway_Oblique_Black.ttf]],
	["Raleway Bold Italic"] 		= FontDir .. [[Raleway-BoldItalic.ttf]],
	["Raleway ExtraLight"] 			= FontDir .. [[Raleway-ExtraLight.ttf]],
	["Raleway"] 					= FontDir .. [[Raleway-Regular.ttf]],
	["Raleway SemiBold"] 			= FontDir .. [[Raleway-SemiBold.ttf]],
	["Raleway SemiBold Italic"] 	= FontDir .. [[Raleway-SemiBoldItalic.ttf]],
	["Raleway Thin Italic"] 		= FontDir .. [[FRaleway-ThinItalic.ttf]],
	["Raleway Thin"] 				= FontDir .. [[Raleway-Thin.ttf]],
	
	-- vvvv Add yours here vvvv
	
}

-- Syntax: ["TextureName"] = [[Path\\To\\Texture]],
-- Mind the , at the end of each line and make sure you closed all [ and " !!
-- The key is the Texture name listed in the dropdown menus!
-- Example: ["CUI Modern"] = TextureDir .. [[modern]],
-- TextureDir represents the "Textures\statusbar\" directory in the CUI root.
AL.StatusbarTextures = {
	-- DEFAULTS, DO NOT REMOVE
	["CUI Modern"] 					= TextureDir .. [[modern]],
	["CUI Modern 2"] 				= TextureDir .. [[modern2]],
	["CUI Modern 3"] 				= TextureDir .. [[modern3]],
	["CUI Simple Light"] 			= TextureDir .. [[simple]],
	["CUI Simple Medium"] 			= TextureDir .. [[simpleMedium]],
	["CUI Simple Darker"] 			= TextureDir .. [[simpleDarker]],
	["CUI Simple Darkest"] 			= TextureDir .. [[simpleDarkest]],
	["CUI XPBar"] 					= Dir .. [[Textures\layout\modern\XPBar]],
	
	-- vvvv Add yours here vvvv
	
}



---------------------------------------------------------------
-- EDITABLE AREA END
---------------------------------------------------------------

------------------------------------------------------------------------------------------
-- DO NOT TOUCH CONTENTS BELOW (unless you know what you're doing) !!
------------------------------------------------------------------------------------------
function AL:Init()
	-- Add fonts and textures to AceWidget Dropdowns
	for k, v in pairs(AL.Fonts) do
		CO.Media:Register("font", k, v)
	end
	for k, v in pairs(AL.StatusbarTextures) do
		CO.Media:Register("statusbar", k, v)
	end
	E.StatusbarTextures = AL.StatusbarTextures
	
	UNIT_NAME_FONT		= CO.Media:Fetch("font", CO.db.profile.global.worldNameFont)
	DAMAGE_TEXT_FONT	= CO.Media:Fetch("font", CO.db.profile.global.worldDamageFont)
	STANDARD_TEXT_FONT	= CO.Media:Fetch("font", CO.db.profile.global.worldDefaultFont)
end

E:AddModule("ArtLib", AL)