
local addon, ns = ...
-- ----------------------------------------------------------------- --
-- Localization metatable function                                   --
-- Instructions for Non-Ace3 method taken from Phanx at WowInterface --
-- http://www.wowinterface.com/portal.php?&id=224&pageid=250         --
-- ================================================================= --
-- Extended version by Hizuro to use some localization strings       --
-- from Blizzard                                                     --
-- ----------------------------------------------------------------- --

local L = {};

ns.L = setmetatable({}, {
	__newindex = function(t,k,v)
		L[k] = v;
	end,
	__index = function(t, k)
		local k=tostring(k);
		if ns.debugMode then
			return L[k] or "<"..k..">";
		end
		return L[k] or k;
	end
});


-- localization by Blizzard - step 1
L["Achievements"] = ACHIEVEMENTS;
L["Archaeology"] = PROFESSIONS_ARCHAEOLOGY
L["Clock"] = TIMEMANAGER_TITLE
L["Currency"] = CURRENCY
L["Dungeon"] = LFG_TYPE_DUNGEON
L["Dungeons"] = DUNGEONS
L["Durability"] = DURABILITY
L["Equipment"] = BAG_FILTER_EQUIPMENT
L["Exalted"] = FACTION_STANDING_LABEL8
L["Followers"] = GARRISON_FOLLOWERS
L["Friendly"] = FACTION_STANDING_LABEL5
L["Game Menu"] = MAINMENU_BUTTON
L["Garrison"] = GARRISON_LOCATION_TOOLTIP
L["General"] = GENERAL
L["Gold"] = BONUS_ROLL_REWARD_MONEY
L["Guild"] = GUILD
L["Hated"] = FACTION_STANDING_LABEL1
L["Honoured"] = FACTION_STANDING_LABEL6
L["Hostile"] = FACTION_STANDING_LABEL2
L["Inn"] = HOME_INN
L["Mail"] = BUTTON_LAG_MAIL
L["Missions"] = GARRISON_MISSIONS
L["Neutral"] = FACTION_STANDING_LABEL4
L["OptGeneral"] = GENERAL
L["OptMisc"] = AUCTION_SUBCATEGORY_OTHER
L["Professions"] = TRADE_SKILLS
L["Quest Log"] = QUESTLOG_BUTTON
L["Raids"] = RAIDS
L["Reputation"] = REPUTATION
L["Revered"] = FACTION_STANDING_LABEL7
L["Ships"] = GARRISON_SHIPYARD_FOLLOWERS
L["System"] = CHAT_MSG_SYSTEM
L["Tracking"] = TRACKING
L["Unfriendly"] = FACTION_STANDING_LABEL3
L["Volume"] = VOLUME
L["Wardrobe"] = WARDROBE
L["XP"] = XP
L["Disabled"] = ADDON_DISABLED
L["Misc"] = AUCTION_SUBCATEGORY_OTHER or CALENDAR_TYPE_OTHER


-- localization by Blizzard - step 2
L["FPS"] = FRAMERATE_LABEL:gsub(":",""):gsub("：",""):trim();
L["Home"], L["World"] = MAINMENUBAR_LATENCY_LABEL:match("%((.*)%).*%((.*)%)");
L["Officer notes"] = OFFICER_NOTE_COLON:gsub(":",""):gsub("：",""):trim();

-- localization by Blizzard - step 3 (by events)
local byItemId = {
	-- [<itemId>] = "<english name>",
};

function ns.LocalizationsOnEvent(event,...) -- executed by core.lua > Broker_Everything:SetScript("OnEvent"...
	if event=="ADDON_LOADED" and addon==... then
		local name;
		for id, key in pairs(byItemId) do
			name = GetItemInfo(id);
			if name then
				L[key] = name;
			end
		end
	elseif event=="GET_ITEM_INFO_RECEIVED" then
		local id = ...;
		if byItemId[id] then
			L[byItemId[id]] = GetItemInfo(id);
		end
	end
end

-- localization by ;) - step 3
local locale = GetLocale();
L["WoWToken"] = ({
	deDE="WoW-Marke",
	esES="Ficha de WoW",
	esMX="Ficha de WoW",
	frFR="Jeton WoW",
	itIT="Gettone WoW",
	koKR="WoW 토큰",
	ptBR="Ficha de WoW",
	ptPT="Ficha de WoW",
	ruRU="Жетон WoW",
	zhCN="魔兽世界时光徽章",
	zhTW="魔獸代幣"
})[locale] or "WoW Token";

L[addon.."_Shortcut"] = "BE";

-- last step: localization filled by curse packager
L["%d unspent talent"] = "%d unspent talent"
L["%d unspent talents"] = "%d unspent talents"
L["%s has its own tracking icon."] = "%s has its own tracking icon."
L["(current)"] = "(current)"
L["(finished)"] = "(finished)"
L["(session only)"] = "(session only)"
L["(soon)"] = "(soon)"
L["* (Asterisk) behind character name if on foreign realm"] = "* (Asterisk) behind character name if on foreign realm"
L["_ (undercore) > [_60 fps]"] = "_ (undercore) > [_60 fps]"
L["0 (zero) > [060 fps]"] = "0 (zero) > [060 fps]"
L["12 / 24 hours mode"] = "12 / 24 hours mode"
L["24 hours mode"] = "24 hours mode"
L["Accepted"] = "Accepted"
L["Action"] = "Action"
L["Activate specialization"] = "Activate specialization"
L["Active"] = "Active"
L["Active quests"] = "Active quests"
L["Active since"] = "Active since"
L["Add a currency"] = "Add a currency"
L["Add a profession"] = "Add a profession"
L["Add more space between displayed currencies on broker button"] = "Add more space between displayed currencies on broker button"
L["Add new note"] = "Add new note"
L["Add time zones to display in tooltip"] = "Add time zones to display in tooltip"
L["Additional time zones"] = "Additional time zones"
L["Addon"] = "Addon"
L["Addon list"] = "Addon list"
L["Addon panel"] = "Addon panel"
L["AddOnLoaded"] = "AddOn loaded..."
L["AddOns and memory"] = "AddOns and memory"
L["Adjust the count of numbers behind the dot."] = "Adjust the count of numbers behind the dot."
L["Adjust the maximum of tooltip height in percent of your screen height."] = "Adjust the maximum of tooltip height in percent of your screen height."
L["all"] = "all"
L["All 10 minutes"] = "All 10 minutes"
L["All 20 minutes"] = "All 20 minutes"
L["All 30 seconds"] = "All 30 seconds"
L["All 40 minutes"] = "All 40 minutes"
L["All 5 minutes"] = "All 5 minutes"
L["All data will be delete."] = "All data will be delete."
L["All factions"] = "All factions"
L["All realms"] = "All realms"
L["all realms and factions"] = "all realms and factions"
L["All slots are empty"] = "All slots are empty"
L["Allow mouseover"] = "Allow mouseover"
L["Allows you to adjust the display options."] = "Allows you to adjust the display options."
L["An option menu with all entries."] = "An option menu with all entries."
L["and %d more"] = "and %d more"
L["Any update of the addon memory usage can cause results in fps drops and 'Script ran too long' error messages!"] = "Any update of the addon memory usage can cause results in fps drops and 'Script ran too long' error messages!"
L["Applicant"] = "Applicant"
L["Applicants"] = "Applicants"
L["Archaeology frame"] = "Archaeology frame"
L["Are you sure you want to Reload the UI?"] = "Are you sure you want to Reload the UI?"
L["Artifact frame"] = "Artifact frame"
L["Artifact knowledge"] = "Artifact knowledge"
L["Artifact relic are displayable after opening artifact window. Shift Right-Click on your equipped artifact weapon."] = "Artifact relic are displayable after opening artifact window. Shift Right-Click on your equipped artifact weapon."
L["Artifact weapon"] = "Artifact weapon"
L["Artifact weapon not equipped"] = "Artifact weapon not equipped"
L["Artifacts"] = "Artifacts"
L["Auto"] = "Auto"
L["Auto crap selling - Summary"] = "Auto crap selling - Summary"
L["Automatic"] = "Automatic"
L["Automatic crap/junk selling on opening a mergant frame."] = "Automatic crap/junk selling on opening a mergant frame."
L["Automatic deposit"] = "Automatic deposit"
L["Automatic deposit the collected cash flow summary"] = "Automatic deposit the collected cash flow summary"
L["Automatic repair failed. Not enough money..."] = "Automatic repair failed. Not enough money..."
L["Automatically repair your equipment on opening a merchant with repair option."] = "Automatically repair your equipment on opening a merchant with repair option."
L["Automatically repaired with guild money"] = "Automatically repaired with guild money"
L["Automatically repaired with player money"] = "Automatically repaired with player money"
L["AutoRepair"] = "AutoRepair"
L["available"] = "available"
L["Available blueprints level 3"] = "Available blueprints level 3"
L["Average"] = "Average"
L["Back from missions"] = "Back from missions"
L["Background colored row for status"] = "Background colored row for status"
L["Background reputation bar mode"] = "Background reputation bar mode"
L["Bags"] = "Bags"
L["Battle is over, Next in"] = "Battle is over, Next in"
L["BattleNet friends"] = "BattleNet friends"
L["blank > [ 60 fps]"] = "blank > [ 60 fps]"
L["Bosses"] = "Bosses"
L["Breaching the Tomb"] = "Breaching the Tomb"
L["Broken Isles Flying"] = "Broken Isles Flying"
L["Broken Isles Pathfinder, Part Two"] = "Broken Isles Pathfinder, Part Two"
L["Broker"] = "Broker"
L["Broker button options"] = "Broker button options"
L["Broker click options"] = "Broker click options"
L["Broker format"] = "Broker format"
L["Broker_Everything will use the new setting on next reload."] = "Broker_Everything will use the new setting on next reload."
L["Build date"] = "Build date"
L["Build version"] = "Build version"
L["buildings"] = "buildings"
L["Buyable"] = "Buyable"
L["By"] = "By"
L["by guild fund"] = "by guild fund"
L["by player money"] = "by player money"
L["Calendar"] = "Calendar"
L["Cancel ticket"] = "Cancel ticket"
L["Cfg"] = "Cfg"
L["Challenge mode"] = "Challenge mode"
L["Change how much digits display after the dot."] = "Change how much digits display after the dot."
L["Change number of displayed addons in module memory."] = "Change number of displayed addons in module memory."
L["Change steps"] = "Change steps"
L["Change the color of the icons"] = "Change the color of the icons"
L["Change the list style."] = "Change the list style."
L["Change the stepping width for volume changes with mousewheel and clicks."] = "Change the stepping width for volume changes with mousewheel and clicks."
L["Change the update interval or disable it."] = "Change the update interval or disable it."
L["Characters"] = "Characters"
L["CharData"] = "Character data"
L["Chat info"] = "Chat info"
L["ChatChannels"] = "Chat channels"
L["Chilling"] = "Chilling"
L["Choose character for little text bar"] = "Choose character for little text bar"
L["Choose how much entries the list of repair costs can have."] = "Choose how much entries the list of repair costs can have."
L["Choose the date format if used in the list of repair costs"] = "Choose the date format if used in the list of repair costs"
L["Choose what role info will be displayed on broker button"] = "Choose what role info will be displayed on broker button"
L["Choose your addon panel that opens if you rightclick on memory broker or disable the right click option."] = "Choose your addon panel that opens if you rightclick on memory broker or disable the right click option."
L["Choose your favorite"] = "Choose your favorite"
L["Choose your favorite color set in which the percent text in broker should be displayed."] = "Choose your favorite color set in which the percent text in broker should be displayed."
L["Choose your favorite date format"] = "Choose your favorite date format"
L["Choose your favorite display format for the broker button."] = "Choose your favorite display format for the broker button."
L["Choose your favorite website for further informations to a quest."] = "Choose your favorite website for further informations to a quest."
L["Classic size"] = "Classic size"
L["ClassSpecs"] = "Class specs"
L["Cleared"] = "Cleared"
L["Click to change your loot specialization"] = "Click to change your loot specialization"
L["ClickOptCharInfo"] = "Character info"
L["ClickOptDesc"] = "Choose your fav. combination of modifier and mouse for:"
L["ClickOptions"] = "Click options"
L["ClickOptMenu"] = "Option menu"
L["ClickOptMenuDesc"] = "open the option menu"
L["ClickOptMenuHint"] = "Open option menu"
L["ClickOptOpen"] = "Open: %s"
L["ClickOptPanel"] = "Option panel"
L["Client build"] = "Client build"
L["Client info"] = "Client info"
L["Client version"] = "Client version"
L["Close menu"] = "Close menu"
L["CmdEquipInfo"] = "List your equipment sets or equip a set."
L["CmdEquipInvalid"] = "Name of equipmentset are invalid"
L["CmdEquipMiss"] = "%d item(s) are not in your bag"
L["CmdEquipSets"] = "Available Sets:"
L["CmdEquipUsage"] = "Usage: /be equip [SetName]"
L["CmdNAInfo"] = "Sorry, this command is no longer available."
L["CmdNeedReload"] = "UI Reload is required..."
L["CmdResetInfo"] = "Reset all settings"
L["CmdStatusInfo"] = "List of available modules with his status"
L["CmdToggleInfo"] = "Enable/Disable a module"
L["CmdUsage"] = "Chat command list for /be & /broker_everything"
L["CmdVersion"] = "Display current version of Broker_Everything"
L["CoExistDisabled"] = "This option is disabled because other addons:"
L["CoExistOwn"] = "Has its own minimap button."
L["CoExistSimilar"] = "Has similar option to hide the minimap button."
L["CoExistUnsave"] = "Produce errors if this option is enabled."
L["collapsed"] = "collapsed"
L["Collecting Garbage..."] = "Collecting Garbage..."
L["Coloring limited currencies by total and/or weekly cap. If weekly cap not shown then will be colored total value by value which is near on cap."] = "Coloring limited currencies by total and/or weekly cap. If weekly cap not shown then will be colored total value by value which is near on cap."
L["Coloring total cap"] = "Coloring total cap"
L["Coloring total/weekly cap"] = "Coloring total/weekly cap"
L["Completed"] = "Completed"
L["Completed quests"] = "Completed quests"
L["Confirmed"] = "Confirmed"
L["Connected realms"] = "Connected realms"
L["Contested"] = "Contested"
L["Cooldown"] = "Cooldown"
L["Cooldowns"] = "Cooldowns"
L["Coordinates"] = "Coordinates"
L["Coordinates indeterminable"] = "Coordinates indeterminable"
L["Coordination format"] = "Coordination format"
L["Count"] = "Count"
L["Count of data to collect:"] = "Count of data to collect:"
L["Count of watched faction"] = "Count of watched faction"
L["Crap selling options"] = "Crap selling options"
L["Critical low free slots"] = "Critical low free slots"
L["Currency in title - menu"] = "Currency in title - menu"
L["Current / max xp"] = "Current / max xp"
L["Current group type:"] = "Current group type:"
L["Current price:"] = "Current price:"
L["Currently no artifact power items found"] = "Currently no artifact power items found"
L["Currently no battle.net friends online..."] = "Currently no battle.net friends online..."
L["Currently no friends online..."] = "Currently no friends online..."
L["Currently no price available..."] = "Currently no price available..."
L["Currently you have no artifact weapon equipped..."] = "Currently you have no artifact weapon equipped..."
L["Currently you have no artifact weapon obtained..."] = "Currently you have no artifact weapon obtained..."
L["Custom title"] = "Custom title"
L["Custom title in tooltip"] = "Custom title in tooltip"
L["CVarInCombat"] = "Sorry, CVar %s are no longer changeable while combat. Thanks @ Blizzard."
L["CVarScalingInCombat"] = "Changing UI scaling while combat nether an good idea."
L["Daily zone bonus"] = "Daily zone bonus"
L["Darker blue for fully upgraded"] = "Darker blue for fully upgraded"
L["Data modules:"] = "Data modules:"
L["Date"] = "Date"
L["Date format"] = "Date format"
L["Default: %s"] = "Default: %s"
L["Delete a character from the list"] = "Delete a character from the list"
L["Delete note"] = "Current group type:"
L["Demoted"] = "Demoted"
L["Difference"] = "Difference"
L["Difference to previous:"] = "Difference to previous:"
L["Disable all modules"] = "Disable all modules"
L["Disable Click options"] = "Disable Click options"
L["Disable the click options on broker button"] = "Disable the click options on broker button"
L["Disable this module"] = "Disable this module"
L["Disabling %s on next reload."] = "Disabling %s on next reload."
L["Display a list of chars on all realms with there mail counts and 3 lowest days before return to sender. Chars with empty mail box aren't displayed."] = "Display a list of chars on all realms with there mail counts and 3 lowest days before return to sender. Chars with empty mail box aren't displayed."
L["Display a list of currently equipped items"] = "Display a list of currently equipped items"
L["Display a list of events in tooltip"] = "Display a list of events in tooltip"
L["Display a list of legion respices with neccessary faction repution"] = "Display a list of legion respices with neccessary faction repution"
L["Display a list of my chars on same realm with her level and xp"] = "Display a list of my chars on same realm with her level and xp"
L["Display a list of the last repair costs in tooltip"] = "Display a list of the last repair costs in tooltip"
L["Display a list of your equipment sets"] = "Display a list of your equipment sets"
L["Display a red # on not enchanted/enchantable items"] = "Display a red # on not enchanted/enchantable items"
L["Display a T-Set label on items"] = "Display a T-Set label on items"
L["Display a yellow # on items with empty sockets"] = "Display a yellow # on items with empty sockets"
L["Display addon count on broker"] = "Display addon count on broker"
L["Display an item summary list by expansion in tooltip"] = "Display an item summary list by expansion in tooltip"
L["Display an item summary list by qualities in tooltip"] = "Display an item summary list by qualities in tooltip"
L["Display BattleNet friends in tooltip"] = "Display BattleNet friends in tooltip"
L["Display BattleTag and/or RealID in tooltip"] = "Display BattleTag and/or RealID in tooltip"
L["Display BattleTag in tooltip (BattleNet friend only)"] = "Display BattleTag in tooltip (BattleNet friend only)"
L["Display broadcast message in tooltip (BattleNet friend only)"] = "Display broadcast message in tooltip (BattleNet friend only)"
L["Display client build number on broker"] = "Display client build number on broker"
L["Display client info in tooltip"] = "Display client info in tooltip"
L["Display client version on broker"] = "Display client version on broker"
L["Display count of BattleNet friends on Broker if 'Split friends on Broker' enabled otherwise add BattleNet friends to summary count."] = "Display count of BattleNet friends on Broker if 'Split friends on Broker' enabled otherwise add BattleNet friends to summary count."
L["Display count of friends if 'Split friends on Broker' enabled otherwise add friends to summary count."] = "Display count of friends if 'Split friends on Broker' enabled otherwise add friends to summary count."
L["Display count of needed reputation to next standing of watched faction on broker button"] = "Display count of needed reputation to next standing of watched faction on broker button"
L["Display creature id on broker button"] = "Display creature id on broker button"
L["Display currency total cap in tooltip."] = "Display currency total cap in tooltip."
L["Display currency weekly earned and cap in tooltip."] = "Display currency weekly earned and cap in tooltip."
L["Display current/max reputation of watched faction on broker button"] = "Display current/max reputation of watched faction on broker button"
L["Display date in tooltip"] = "Display date in tooltip"
L["Display earn/loss reputation of watched faction on broker button"] = "Display earn/loss reputation of watched faction on broker button"
L["Display event title and start/end date in a single line in tooltip"] = "Display event title and start/end date in a single line in tooltip"
L["Display expired classic raids in tooltip"] = "Display expired classic raids in tooltip"
L["Display expired raids in tooltip"] = "Display expired raids in tooltip"
L["Display faction in tooltip (WoW only)"] = "Display faction in tooltip (WoW only)"
L["Display faction in tooltip if available"] = "Display faction in tooltip if available"
L["Display fps in tooltip"] = "Display fps in tooltip"
L["Display fps on broker"] = "Display fps on broker"
L["Display friends in tooltip"] = "Display friends in tooltip"
L["Display game icon or game shortcut in tooltip"] = "Display game icon or game shortcut in tooltip"
L["Display game in second tooltip"] = "Display game in second tooltip"
L["Display green text line from item tooltip like titanforged"] = "Display green text line from item tooltip like titanforged"
L["Display home latency"] = "Display home latency"
L["Display home latency on broker"] = "Display home latency on broker"
L["Display in broker zone and subzone if exists or one of it."] = "Display in broker zone and subzone if exists or one of it."
L["Display in tooltip a list of your sound output hardware."] = "Display in tooltip a list of your sound output hardware."
L["Display inbound traffic on broker"] = "Display inbound traffic on broker"
L["Display interface version on broker"] = "Display interface version on broker"
L["Display latency in tooltip"] = "Display latency in tooltip"
L["Display list of challenge IDs in tooltip"] = "Display list of challenge IDs in tooltip"
L["Display list of classic raid IDs in tooltip"] = "Display list of classic raid IDs in tooltip"
L["Display list of dungeon IDs in tooltip"] = "Display list of dungeon IDs in tooltip"
L["Display list of event IDs in tooltip"] = "Display list of event IDs in tooltip"
L["Display list of flex raid IDs in tooltip"] = "Display list of flex raid IDs in tooltip"
L["Display list of lfr IDs in tooltip"] = "Display list of lfr IDs in tooltip"
L["Display list of raid IDs in tooltip"] = "Display list of raid IDs in tooltip"
L["Display list of szenario IDs in tooltip"] = "Display list of szenario IDs in tooltip"
L["Display list of world boss IDs in tooltip"] = "Display list of world boss IDs in tooltip"
L["Display member notes in chat window after his/her login message"] = "Display member notes in chat window after his/her login message"
L["Display member officer notes in chat window after his/her login message"] = "Display member officer notes in chat window after his/her login message"
L["Display memory usage in tooltip"] = "Display memory usage in tooltip"
L["Display memory usage on broker"] = "Display memory usage on broker"
L["Display mobile chatter with own table in tooltip"] = "Display mobile chatter with own table in tooltip"
L["Display mode"] = "Display mode"
L["Display name of watched faction on broker button"] = "Display name of watched faction on broker button"
L["Display notes in second tooltip"] = "Display notes in second tooltip"
L["Display notes in tooltip"] = "Display notes in tooltip"
L["Display one of the selected tracking options in broker text."] = "Display one of the selected tracking options in broker text."
L["Display order hall upgrade tree and work orders from order hall and kitchen"] = "Display order hall upgrade tree and work orders from order hall and kitchen"
L["Display outbound traffic on broker"] = "Display outbound traffic on broker"
L["Display ownership on broker button"] = "Display ownership on broker button"
L["Display percent value of need reputation of watched faction on broker button"] = "Display percent value of need reputation of watched faction on broker button"
L["Display percent value of watched faction reputation on broker button"] = "Display percent value of watched faction reputation on broker button"
L["Display quest id in tooltip"] = "Display quest id in tooltip"
L["Display quest level in tooltip"] = "Display quest level in tooltip"
L["Display quest tags in tooltip"] = "Display quest tags in tooltip"
L["Display quest text in tooltip"] = "Display quest text in tooltip"
L["Display quest zone in tooltip"] = "Display quest zone in tooltip"
L["Display RealID in tooltip if available (BattleNet friend only)"] = "Display RealID in tooltip if available (BattleNet friend only)"
L["Display realm name in tooltip (WoW only)"] = "Display realm name in tooltip (WoW only)"
L["Display selection"] = "Display selection"
L["Display session earned/loss reputation in tooltip"] = "Display session earned/loss reputation in tooltip"
L["Display session profit in tooltip"] = "Display session profit in tooltip"
L["Display standing of watched faction on broker button"] = "Display standing of watched faction on broker button"
L["Display status like AFK in tooltip"] = "Display status like AFK in tooltip"
L["Display the content of the tooltip shorter"] = "Display the content of the tooltip shorter"
L["Display the lowest item durability in broker."] = "Display the lowest item durability in broker."
L["Display the options for this module"] = "Display the options for this module"
L["Display the time with seconds in broker button and tooltip"] = "Display the time with seconds in broker button and tooltip"
L["Display the transport menu without names of spells and items behind the icons."] = "Display the transport menu without names of spells and items behind the icons."
L["Display total/weekly caps in different colors"] = "Display total/weekly caps in different colors"
L["Display traffic in tooltip"] = "Display traffic in tooltip"
L["Display upgrade counter in darker blue on fully upgraded items"] = "Display upgrade counter in darker blue on fully upgraded items"
L["Display upgrade info like 2/6"] = "Display upgrade info like 2/6"
L["Display world latency"] = "Display world latency"
L["Display world latency on broker"] = "Display world latency on broker"
L["Display XP in broker"] = "Display XP in broker"
L["Display your average item level on broker button"] = "Display your average item level on broker button"
L["Display your current equipment set on broker button"] = "Display your current equipment set on broker button"
L["Display zone in second tooltip"] = "Display zone in second tooltip"
L["Display zone in tooltip"] = "Display zone in tooltip"
L["Display zone names"] = "Display zone names"
L["Do you really want to left the game?"] = "Do you really want to left the game?"
L["Do you really want to logout from this character?"] = "Do you really want to logout from this character?"
L["Do you really want to reload the UI?"] = "Do you really want to reload the UI?"
L["Do you really want to switch display mode?"] = "Do you really want to switch display mode?"
L["Earn/loss of watched faction"] = "Earn/loss of watched faction"
L["Edit ticket"] = "Edit ticket"
L["Emissary Quests"] = "Emissary Quests"
L["Emissary Quests-ShortCut"] = "EQ"
L["Enable all modules"] = "Enable all modules"
L["Enable auto repair"] = "Enable auto repair"
L["Enable crap/junk selling on opening a mergant frame."] = "Enable crap/junk selling on opening a mergant frame."
L["Enable it from the character info"] = "Enable it from the character info"
L["Enable this module"] = "Enable this module"
L["Enable to play a sound on receiving a new mail message. Default is off"] = "Enable to play a sound on receiving a new mail message. Default is off"
L["Enable/Disable class coloring of the information display suffixes. (eg, ms, fps etc)"] = "Enable/Disable class coloring of the information display suffixes. (eg, ms, fps etc)"
L["Enable/Disable the display of Guild Reputation in tooltip"] = "Enable/Disable the display of Guild Reputation in tooltip"
L["Enable/Disable the module"] = "Enable/Disable the module"
L["Enable/disable tooltip scaling."] = "Enable/disable tooltip scaling."
L["Enabling %s on next reload."] = "Enabling %s on next reload."
L["Equip a set."] = "Equip a set."
L["Equipment manager is not enabled"] = "Equipment manager is not enabled"
L["Equipped artifact weapon"] = "Equipped artifact weapon"
L["Error"] = "Error"
L["Explore Broken Shore"] = "Explore Broken Shore"
L["Extend ID"] = "Extend ID"
L["Faction icon in own column"] = "Faction icon in own column"
L["Faction name in own column"] = "Faction name in own column"
L["Failed quests"] = "Failed quests"
L["Fav. website"] = "Fav. website"
L["Favorites only"] = "Favorites only"
L["finished"] = "finished"
L["Flight licences"] = "Flight licences"
L["Found in your backpack"] = "Found in your backpack"
L["FPS"] = "FPS"
L["Framenames"] = "Framenames"
L["Free"] = "Free"
L["free job"] = "free job"
L["Free slots"] = "Free slots"
L["Friends"] = "Friends"
L["Game icon"] = "Game icon"
L["Game shortcut"] = "Game shortcut"
L["Garrison cache forcast"] = "Garrison cache forcast"
L["General options"] = "General options"
L["Gold information"] = "Gold information"
L["GPS"] = "GPS"
L["Guild MotD"] = "Guild MotD"
L["Guild perk"] = "Guild perk"
L["GuildLog"] = "Guild log"
L["has reached Level %d."] = "has reached Level %d."
L["Hidden"] = "Hidden"
L["Hidden random zone dailies"] = "Hidden random zone dailies"
L["Hide"] = "Hide"
L["Hide all characters who have reached the level cap."] = "Hide all characters who have reached the level cap."
L["Hide all entries with 'Demote' as action."] = "Hide all entries with 'Demote' as action."
L["Hide all entries with 'Invite' as action."] = "Hide all entries with 'Invite' as action."
L["Hide all entries with 'Join' as action."] = "Hide all entries with 'Join' as action."
L["Hide all entries with 'Leave' as action."] = "Hide all entries with 'Leave' as action."
L["Hide all entries with 'Promote' as action."] = "Hide all entries with 'Promote' as action."
L["Hide all entries with 'Remove' as action."] = "Hide all entries with 'Remove' as action."
L["Hide Blizzard's minimap calendar button"] = "Hide Blizzard's minimap calendar button"
L["Hide blizzard's tracking button on minimap"] = "Hide blizzard's tracking button on minimap"
L["Hide calendar button"] = "Hide calendar button"
L["Hide characters at maximum level"] = "Hide characters at maximum level"
L["Hide demotions"] = "Hide demotions"
L["Hide disabled followers"] = "Hide disabled followers"
L["Hide disabled followers in tooltip"] = "Hide disabled followers in tooltip"
L["Hide invites"] = "Hide invites"
L["Hide joins"] = "Hide joins"
L["Hide leaves"] = "Hide leaves"
L["Hide minimap button"] = "Hide minimap button"
L["Hide minimap mail icon"] = "Hide minimap mail icon"
L["Hide promotions"] = "Hide promotions"
L["Hide removes"] = "Hide removes"
L["Hide section 2"] = "Hide section 2"
L["Hide section 2 in tooltip"] = "Hide section 2 in tooltip"
L["Hide section 3"] = "Hide section 3"
L["Hide section 3 in tooltip"] = "Hide section 3 in tooltip"
L["Hide working followers"] = "Hide working followers"
L["Hide working followers in tooltip"] = "Hide working followers in tooltip"
L["Hide/Show tooltip hint."] = "Hide/Show tooltip hint."
L["History"] = "History"
L["Hold modifier key to display tooltip"] = "Hold modifier key to display tooltip"
L["Hold modifier key to use mouseover in tooltip"] = "Hold modifier key to use mouseover in tooltip"
L["Hold shift"] = "Hold shift"
L["Home"] = "Home"
L["Home latency"] = "Home latency"
L["Hostle NPCs"] = "Hostle NPCs"
L["How would you like to view coordinations."] = "How would you like to view coordinations."
L["How would you like to view numeric reputation format."] = "How would you like to view numeric reputation format."
L["How would you like to view the background reputation bar."] = "How would you like to view the background reputation bar."
L["Icon behind character name"] = "Icon behind character name"
L["IconColor"] = "Icon color"
L["IconColorDesc"] = "Change the color of the icons"
L["Icons"] = "Icons"
L["IconSets"] = "Iconsets"
L["IconSetsDesc"] = "Choose an custom icon set"
L["IconSetsInfo"] = "This addon offer the option to change the icons of the broker modules through LibSharedMedia. An example can be found on"
L["IDs"] = "IDs"
L["If you have more than one addon to display memory usage it is recommended to disable the update interval of this addon."] = "If you have more than one addon to display memory usage it is recommended to disable the update interval of this addon."
L["Ignore main hand"] = "Ignore main hand"
L["Ignore off-hand"] = "Ignore off-hand"
L["iLevel"] = "iLevel"
L["In progress"] = "In progress"
L["In Questlog"] = "In Questlog"
L["In title"] = "In title"
L["In:"] = "In:"
L["In|nprogress"] = "In|nprogress"
L["Inbound"] = "Inbound"
L["Inbound / Download"] = "Inbound / Download"
L["Inbound traffic"] = "Inbound traffic"
L["Instances"] = "Instances"
L["Interactive NPCs"] = "Interactive NPCs"
L["Interface version"] = "Interface version"
L["InvasionsNext"] = "Next invasions"
L[ [=[InvasionsNextIn
]=] ] = "Next in"
L["Invitation"] = "Invitation"
L["Invitations"] = "Invitations"
L["Invite a friend"] = "Invite a friend"
L["Invite a member"] = "Invite a member"
L["Item has empty socket"] = "Item has empty socket"
L["Item is not enchanted"] = "Item is not enchanted"
L["Item summary by expansion mode"] = "Item summary by expansion mode"
L["Item summary by quality mode"] = "Item summary by quality mode"
L["Item summary|nby expansion"] = "Item summary|nby expansion"
L["Item summary|nby quality"] = "Item summary|nby quality"
L["Jewels cooldown group"] = "Jewels cooldown group"
L["Jobs"] = "Jobs"
L["Keystones"] = "Keystones"
L["Larger"] = "Larger"
L["Last %d repair costs"] = "Last %d repair costs"
L["Last 3 new mails"] = "Last 3 new mails"
L["Last changed:"] = "Last changed:"
L["Latency"] = "Latency"
L["latest %d entries"] = "latest %d entries"
L["Learnable"] = "Learnable"
L["Leather cooldown group"] = "Leather cooldown group"
L["Left"] = "Left"
L["Left in mailbox"] = "Left in mailbox"
L["Left the guild"] = "Left the guild"
L["Legionfall Commander"] = "Legionfall Commander"
L["List mails on chars"] = "List mails on chars"
L["List of hardware"] = "List of hardware"
L["List of repair costs"] = "List of repair costs"
L["Loaded AddOns"] = "Loaded AddOns"
L["Local or realm time"] = "Local or realm time"
L["Local time"] = "Local time"
L["Locale string"] = "Locale string"
L["Locale:"] = "Locale:"
L["Location"] = "Location"
L["Louder"] = "Louder"
L["Lowest durability"] = "Lowest durability"
L["Lowest item"] = "Lowest item"
L["Mails"] = "Mails"
L["Main tooltip options"] = "Main tooltip options"
L["make volume louder"] = "make volume louder"
L["make volume quieter"] = "make volume quieter"
L["Max."] = "Max."
L["Max. Level reached"] = "Max. Level reached"
L["Max. list entries"] = "Max. list entries"
L["Max. Tooltip height"] = "Max. Tooltip height"
L["Memory"] = "Memory"
L["Memory usage"] = "Memory usage"
L["Min."] = "Min."
L["Misc"] = "Misc"
L["Misc options"] = "Misc options"
L["Misc. options"] = "Misc. options"
L["Missing artifact weapon data"] = "Missing artifact weapon data"
L["Mobile app user"] = "Mobile app user"
L["ModDesc-Achievements"] = "Broker to show earned achievements and the current tracking list"
L["ModDesc-Archaeology"] = "Broker to show archaeology factions with fragments, keystones and necessary amount of fragments to solve artifacts"
L["ModDesc-Artifact weapon"] = "Broker to display informations about your obtained artifact weapons on broker and in tooltip"
L["ModDesc-Bags"] = "Broker to show total, used and free slots of your bags"
L["ModDesc-Calendar"] = "Broker to show calendar events and invitations"
L["ModDesc-ChatChannels"] = "Broker to show count of users of all chat channels"
L["ModDesc-ClassSpecs"] = "Broker to show and switch your character specializations"
L["ModDesc-Clock"] = "Broker to show local and/or realm time"
L["ModDesc-Currency"] = "Broker to show your currencies"
L["ModDesc-Dungeons"] = "Broker to display a list of all available dungeons across extensions. A second tooltip will be displayed on mouseover an entry and display a list of your other toons and there status (completed or not)."
L["ModDesc-Durability"] = "Broker to show durability of your gear and estimated repair costs"
L["ModDesc-Emissary Quests"] = "Broker to show emissary quests status"
L["ModDesc-Equipment"] = "Broker to show current equipped items and list & modify equipment sets"
L["ModDesc-Followers"] = "Broker to show a list of your follower with level, quality, experience and more"
L["ModDesc-FPS"] = "Broker to show your frames per second in broker button and current session min/max in tooltip"
L["ModDesc-Framenames"] = "Broker to show names of frames under the mouse"
L["ModDesc-Friends"] = "Broker to show you which friends are online on realm and BattleNet"
L["ModDesc-Game Menu"] = "Broker to show combined list of clickable elements from game menu, microbutton bar. It is not recommended to use it in combat."
L["ModDesc-Garrison"] = "Broker to show garrison buildings, worker, active work orders, available blueprints, depending achievements and gives you a garrison cache forecast for all your chars"
L["ModDesc-Gold"] = "Broker to show gold of all your chars and lost and earned money for the current session"
L["ModDesc-GPS"] = "Broker to show the name of the current zone and the coordinates"
L["ModDesc-Guild"] = "Broker to show guild message of the day, your guild reputation, guild members, applicants and mobile app users"
L["ModDesc-GuildLog"] = "Broker to show last entries of the guild log"
L["ModDesc-IDs"] = "Broker to show locked raids, dungeons and world bosses"
L["ModDesc-Latency"] = "Broker to show current home and world network latency"
L["ModDesc-Location"] = "Broker to show your current coordinates"
L["ModDesc-Mail"] = "Broker to show incoming mails and stored mails on all your chars"
L["ModDesc-Memory"] = "Broker to show memory usage summary and single addons usage"
L["ModDesc-Missions"] = "Broker to show active and available missions for your followers and ships"
L["ModDesc-Nameplates"] = "Broker to show clickable nameplates options"
L["ModDesc-Notes"] = "Broker to give you a very simple option to note down some informations. A list of notes in tooltip and with a click on it will be opens a small window you can edit it."
L["ModDesc-Order hall"] = "Broker to display order hall upgrade tree and work orders from order hall and kitchen"
L["ModDesc-Professions"] = "Broker to show your profession skills and cooldowns"
L["ModDesc-Quest Log"] = "Broker to show count of quests in your questlog and quest titles in tooltip"
L["ModDesc-Raids"] = "Broker to display a list of all available raids across extensions. A second tooltip will be displayed on mouseover an entry and display a list of your other toons and there status (completed or not)."
L["ModDesc-Reputation"] = "Broker to show faction standing of your character"
L["ModDesc-Ships"] = "Broker to show your naval ships with level, quality, xp and more"
L["ModDesc-Speed"] = "Broker to show swimming, walking, riding and flying speed in broker button, a list of riding skills and currently active speed bonuses"
L["ModDesc-Stuff"] = "Broker to allow you to do...Stuff! Switch to windowed mode, reload ui, logout and quit."
L["ModDesc-Surprise"] = "Broker to have an eye on your suprise item. What is a suprise item? Anything thats needs some days to open it and thats lootable after the time. Can contain random objects like mounts, companions and more."
L["ModDesc-System"] = "Broker to show system infos like fps, traffic, latency and memory in broker and tooltip"
L["ModDesc-Tanaan Jungle Dailies"] = "Broker to show a list of solved/solvable tanaan jungle bosses, dailys, weeklys and bonus zones"
L["ModDesc-Tracking"] = "Broker to show current tracking list with option to change it"
L["ModDesc-Traffic"] = "Broker to show the traffic between blizzard and your game client"
L["ModDesc-Volume"] = "Broker to show current volume and in tooltip all changeable audio options"
L["ModDesc-Wardrobe"] = "Broker to show count of collected transmog templates"
L["ModDesc-WoWToken"] = "Broker to show current gold price for a WoW Token"
L["ModDesc-XP"] = "Broker to show experience from all chars in tooltip and the current character in broker button"
L["ModDesc-ZoneText"] = "Broker to show the name of the current zone"
L["ModKeyA"] = "Alt"
L["ModKeyC"] = "Ctrl"
L["ModKeyDefault"] = "Default (no modifier)"
L["ModKeyLA"] = "Left alt"
L["ModKeyLC"] = "Left ctrl"
L["ModKeyLS"] = "Left shift"
L["ModKeyRA"] = "Right alt"
L["ModKeyRC"] = "Right ctrl"
L["ModKeyRS"] = "Right shift"
L["ModKeyS"] = "Shift"
L["ModsToggle"] = "Enable/Disable modules"
L["Modules"] = "Modules"
L["More info in tooltip..."] = "More info in tooltip..."
L["More nameplate options"] = "More nameplate options"
L["More names"] = "More names"
L["MouseBtn"] = "Click"
L["MouseBtnL"] = "Left-click"
L["MouseBtnR"] = "Right-click"
L["Mousewheel"] = "Mousewheel"
L["Mute game sound"] = "Mute game sound"
L["My current broadcast message"] = "My current broadcast message"
L["Name"] = "Name"
L["Name of watched faction"] = "Name of watched faction"
L["Nameplate size"] = "Nameplate size"
L["Nameplates"] = "Nameplates"
L["Nameplates out of combat"] = "Nameplates out of combat"
L["Names/Nameplates on/off"] = "Names/Nameplates on/off"
L["Necessary achievements for blueprints level 3"] = "Necessary achievements for blueprints level 3"
L["need"] = "need"
L["Need (percent) of watched faction"] = "Need (percent) of watched faction"
L["Need level"] = "Need level"
L["Need of watched faction"] = "Need of watched faction"
L["Need to next point"] = "Need to next point"
L["New mail"] = "New mail"
L["New mails"] = "New mails"
L["New rank"] = "New rank"
L["next"] = "next"
L["Next artifact knowledge"] = "Next artifact knowledge"
L["No boss IDs found..."] = "No boss IDs found..."
L["No channels listed..."] = "No channels listed..."
L["No currencies found..."] = "No currencies found..."
L["No data"] = "No data"
L["No data found"] = "No data found"
L["No data found..."] = "No data found..."
L["No data to display..."] = "No data to display..."
L["No equipment sets found"] = "No equipment sets found"
L["No followers found..."] = "No followers found..."
L["No friends to diplay. You have both disabled for tooltip"] = "No friends to diplay. You have both disabled for tooltip"
L["No guild"] = "No guild"
L["No instance IDs found..."] = "No instance IDs found..."
L["No invitations found"] = "No invitations found"
L["No item found."] = "No item found."
L["No log entries found..."] = "No log entries found..."
L["No Mail"] = "No Mail"
L["No missions found..."] = "No missions found..."
L["No professions learned..."] = "No professions learned..."
L["No quests completed or in your quest log..."] = "No quests completed or in your quest log..."
L["No sets found"] = "No sets found"
L["No ships found..."] = "No ships found..."
L["No Spec!"] = "No Spec!"
L["No specialisation found"] = "No specialisation found"
L["No speed bonus found..."] = "No speed bonus found..."
L["No spells, items or toys found"] = "No spells, items or toys found"
L["No Text"] = "No Text"
L["No tracking option active."] = "No tracking option active."
L["None (disable right click)"] = "None (disable right click)"
L["Normal list of log entries"] = "Normal list of log entries"
L["Not equipped"] = "Not equipped"
L["Not in a guild"] = "Not in a guild"
L["Not learned"] = "Not learned"
L["Note"] = "Note"
L["Notes"] = "Notes"
L["Number of addons"] = "Number of addons"
L["Numeric format"] = "Numeric format"
L["On"] = "On"
L["On hold shift key"] = "On hold shift key"
L["On/Off"] = "On/Off"
L["One event per line"] = "One event per line"
L["One time per hour"] = "One time per hour"
L["One time per minute"] = "One time per minute"
L["Oops... You have all 'In tooltip' options disabled. :)"] = "Oops... You have all 'In tooltip' options disabled. :)"
L["Open"] = "Open"
L["Open achievement"] = "Open achievement"
L["Open all bags"] = "Open all bags"
L["Open archaeology frame with choosen faction"] = "Open archaeology frame with choosen faction"
L["Open chat channels window"] = "Open chat channels window"
L["Open currency pane"] = "Open currency pane"
L["Open equipment manager tab"] = "Open equipment manager tab"
L["Open friends roster"] = "Open friends roster"
L["Open garrison report"] = "Open garrison report"
L["Open GM Ticket"] = "Open GM Ticket"
L["Open guild roster"] = "Open guild roster"
L["Open options panel"] = "Open options panel"
L["Open profession menu"] = "Open profession menu"
L["Open quest log"] = "Open quest log"
L["Open questlog"] = "Open questlog"
L["Open QuestLog and select quest"] = "Open QuestLog and select quest"
L["Open reputation pane"] = "Open reputation pane"
L["Open talents"] = "Open talents"
L["open the character info"] = "open the character info"
L["open the chat channels tab on the contact window"] = "open the chat channels tab on the contact window"
L["open the currency pane"] = "open the currency pane"
L["open the equipment manager tab on character info"] = "open the equipment manager tab on character info"
L["open the friends roster"] = "open the friends roster"
L["open the garrison report"] = "open the garrison report"
L["open the guild roster"] = "open the guild roster"
L["open the profession menu"] = "open the profession menu"
L["open the quest log"] = "open the quest log"
L["open the reputation pane"] = "open the reputation pane"
L["open the time manager"] = "open the time manager"
L["Open time manager"] = "Open time manager"
L["Open tracking menu"] = "Open tracking menu"
L["open your archaeology frame"] = "open your archaeology frame"
L["open your bags"] = "open your bags"
L["open your questlog"] = "open your questlog"
L["Opens a little menu with 3 reset options"] = "Opens a little menu with 3 reset options"
L["OptAchievBars"] = "Progress bars"
L["OptAchievBarsDesc"] = "Show progress bars in tooltip"
L["OptAchievCat"] = "Achievement categories"
L["OptAchievCatDesc"] = "Show achievement categories in tooltip"
L["OptAchievCompleted"] = "Completed criteria"
L["OptAchievCompletedDesc"] = "Show completed criteria in watch list"
L["OptAchievCriteriaPL"] = "One criteria per line"
L["OptAchievCriteriaPLDesc"] = "Display one plain text criteria per line"
L["OptAchievLast"] = "Last achievements"
L["OptAchievLastDesc"] = "Show the 5 latest earned achievements in tooltip"
L["OptAchievWatchDesc"] = "Show watch list in tooltip"
L["OptAdvOpts"] = "Advanced options"
L["OptAdvOptsDesc"] = "Show advanced options"
L["OptArchOrder"] = "Order by continent"
L["OptArchOrderDesc"] = "Order archaeology races by continent"
L["OptArtKnowledge"] = "Show artifact knowledge"
L["OptArtKnowledgeDesc"] = "Show artifact knowledge in broker button"
L["OptArtName"] = "Artifact name"
L["OptArtNameDesc"] = "Show artifact weapon name in broker button"
L["OptartNotEquipped"] = "Show 'not equipped' warning"
L["OptartNotEquippedDesc"] = "Show 'artifact weapon not equipped' warning in broker button"
L["OptArtOthers"] = "Show your other artifacts"
L["OptArtOthersDesc"] = "Display a list of your other artifacts you have obtainted"
L["OptArtPoints"] = "Points"
L["OptArtPointsDesc"] = "Show spent/available points in broker button"
L["OptArtPower"] = "Show artifact power"
L["OptArtPowerDesc"] = "Show artifact weapon expierence (artifact power) in broker button"
L["OptArtPowerItems"] = "Show artifact power items"
L["OptArtPowerItemsDesc"] = "Display a list of artifact power items found in your bag in tooltip"
L["OptArtPowerTotal"] = "Show total used artifact power"
L["OptArtPowerTotalDesc"] = "Display amount of total used artifact power on current equipped artifact weapon. That doesn't includes point resets!"
L["OptArtRelic"] = "Show artifact relic"
L["OptArtRelicDesc"] = "Display a list of artifact relic slots in tooltip"
L["OptArtRelicILvl"] = "Show relic item level"
L["OptArtRelicILvlDesc"] = "Display relic item level"
L["OptArtReliciLvlInc"] = "Show increase item level by relic"
L["OptArtReliciLvlIncDesc"] = "Display increase item level by relic"
L["OptArtUnused"] = "Show unspend artifact power"
L["OptArtUnusedDesc"] = "Show amount summary of artifact power from items in your backpack in broker button"
L["OptCharDelAll"] = "Delete all character data"
L["OptCharDelAllDesc"] = "Delete data about all your characters"
L["OptCharInfo1"] = "1. Sort your characters"
L["OptCharInfo1Desc"] = "That means you can sort your chars like character choose panel and all modules with informations about your characters respect this order."
L["OptCharInfo2"] = "2. Delete character data"
L["OptCharInfo2Desc"] = "You can delete all collected data about your characters with a single click."
L["OptCharInfo3"] = "3. You can delete all data"
L["OptCharInfoHeader"] = "Your options on this panel:"
L["OptCharList"] = "List of your characters"
L["OptDigitGroup"] = "Digit grouping"
L["OptDigitGroupDesc"] = "Displays large numbers with digit group symbols to make it easily readable"
L["OptGoldColor"] = "Gold coloring"
L["OptGoldColorDesc"] = "Use colors instead of icons for gold, silver and copper"
L["OptHideCopper"] = "Hide copper"
L["OptHideCopperDesc"] = "Hide copper values of your money"
L["OptHideSilver"] = "Hide silver"
L["OptHideSilverDesc"] = "Hide copper and silver values of your money"
L["OptHideZeros"] = "Hide lower zeros"
L["OptHideZerosDesc"] = "Hide lower zero values of your money"
L["OptIconSets"] = "Icon sets"
L["option panel"] = "option panel"
L["Options"] = "Options"
L["OptMinimap"] = "Broker as Minimap Button"
L["OptMinimapDesc"] = "Create a minimap button for this broker"
L["OptMods"] = "Module options"
L["OptMoney"] = "Money display options"
L["OptReloadUI"] = "Reload UI"
L["OptReloadUIRequired"] = "An UI reload is necessary to apply all changes."
L["OptSCM"] = "Screen capture mode"
L["OptSCMDesc"] = "The screen capture mode replaces all characters of a name with wildcards (*) without the first. Your chars in XP, your friends battleTags/RealID and there character names and the character names in your guild and there notes."
L["OptTTHints"] = "Show hints"
L["OptTTHintsDesc"] = "Show hints in tooltips."
L["OptTTScale"] = "Tooltip Scaling"
L["OptTTScaleDesc"] = "Scale the tooltips with your UIScale."
L["Order hall"] = "Order hall"
L["Out of level"] = "Out of level"
L["Out:"] = "Out:"
L["Outbound"] = "Outbound"
L["Outbound / Upload"] = "Outbound / Upload"
L["Outbound traffic"] = "Outbound traffic"
L["Over"] = "Over"
L["Patch 7.2"] = "Patch 7.2"
L["Percent"] = "Percent"
L["Percent color set"] = "Percent color set"
L["Percent count of watched faction"] = "Percent count of watched faction"
L["Pet specialization"] = "Pet specialization"
L["Place"] = "Place"
L["Play sound on new mail"] = "Play sound on new mail"
L["Playtime"] = "Playtime"
L["Poor and common"] = "Poor and common"
L["Poor and common with vendor price"] = "Poor and common with vendor price"
L["Poor only"] = "Poor only"
L["Poor only with vendor price"] = "Poor only with vendor price"
L["Post earned money in general chat frame."] = "Post earned money in general chat frame."
L["Post repair actions in chatframe"] = "Post repair actions in chatframe"
L["Precision"] = "Precision"
L["Prepend a character to fill displayed fps up to 3 character."] = "Prepend a character to fill displayed fps up to 3 character."
L["Prepend character"] = "Prepend character"
L["Price history (last 5 changes)"] = "Price history (last 5 changes)"
L["Profiles"] = "Profiles"
L["Program"] = "Program"
L["Promoted"] = "Promoted"
L["PvE"] = "PvE"
L["PvP"] = "PvP"
L["PvP talents"] = "PvP talents"
L["Qualities"] = "Qualities"
L["Qualities (hide empty)"] = "Qualities (hide empty)"
L["Qualities with vendor price"] = "Qualities with vendor price"
L["Qualities with vendor price (hide empty)"] = "Qualities with vendor price (hide empty)"
L["Quest id"] = "Quest id"
L["Quest level"] = "Quest level"
L["Quest name"] = "Quest name"
L["Quest tags"] = "Quest tags"
L["Quest zone"] = "Quest zone"
L["QuestId"] = "QuestId"
L["QuestIDs"] = "QuestIDs"
L["QuestTagACC"] = "a"
L["QuestTagGRP"] = "g"
L["QuestTagHD"] = "hc"
L["QuestTagLEG"] = "leg"
L["QuestTagMD"] = "myth"
L["QuestTagND"] = "d"
L["QuestTagPVP"] = "pvp"
L["QuestTagR"] = "r"
L["QuestTagS"] = "s"
L["QuestTagTS"] = "ts"
L["QuestTagWQ"] = "wq"
L["Quieter"] = "Quieter"
L["Quit game"] = "Quit game"
L["Random zone dailies"] = "Random zone dailies"
L["Rare bosses"] = "Rare bosses"
L["Reactivate ID"] = "Reactivate ID"
L["ReadyToUse"] = "Ready to use..."
L["Real ID"] = "Real ID"
L["really?"] = "really?"
L["Realm"] = "Realm"
L["Realm name"] = "Realm name"
L["Realm name in character name column"] = "Realm name in character name column"
L["Realm name in own column"] = "Realm name in own column"
L["Realm time"] = "Realm time"
L["Recently"] = "Recently"
L["Recruite a Friend"] = "Recruite a Friend"
L["Reduce event list height in tooltip"] = "Reduce event list height in tooltip"
L["Reduce the broker text to a number without text"] = "Reduce the broker text to a number without text"
L["Reloads your user interface. (It does not save changes)"] = "Reloads your user interface. (It does not save changes)"
L["Remove entry"] = "Remove entry"
L["Remove the currency"] = "Remove the currency"
L["Removed"] = "Removed"
L["Repair info"] = "Repair info"
L["Repair options"] = "Repair options"
L["RepairAll"] = "RepairAll"
L["Reputation dailies"] = "Reputation dailies"
L["Reputation discounts"] = "Reputation discounts"
L["Reputation weeklies"] = "Reputation weeklies"
L["Reset all data"] = "Reset all data"
L["Reset config"] = "Reset config"
L["Reset last repairs"] = "Reset last repairs"
L["Reset session earn/loss counter"] = "Reset session earn/loss counter"
L["Reset session profit"] = "Reset session profit"
L["Reset unsaved changes"] = "Reset unsaved changes"
L["Resets your global and module settings but not collected data about your twinks to display mail, profession cooldowns and more."] = "Resets your global and module settings but not collected data about your twinks to display mail, profession cooldowns and more."
L["Resets your last unsaved changes. Not more..."] = "Resets your last unsaved changes. Not more..."
L["Rest"] = "Rest"
L["Reward: Broken Isles Flying"] = "Reward: Broken Isles Flying"
L["Riding skill"] = "Riding skill"
L["Right"] = "Right"
L["Roles"] = "Roles"
L["Same battlegroup"] = ""
L["Sanctuary"] = "Sanctuary"
L["Save changes without closing the option panel"] = "Save changes without closing the option panel"
L["Save repair costs"] = "Save repair costs"
L["'Save set' should ignore main hand weapon"] = "'Save set' should ignore main hand weapon"
L["'Save set' should ignore off-hand weapon"] = "'Save set' should ignore off-hand weapon"
L["Save the list of repair costs over the session"] = "Save the list of repair costs over the session"
L["Second tooltip"] = "Second tooltip"
L["Second tooltip options"] = "Second tooltip options"
L["Secondary tooltip options"] = "Secondary tooltip options"
L["Select the maximum free slot count to coloring in red."] = "Select the maximum free slot count to coloring in red."
L["Select the maximum free slot count to coloring in yellow."] = "Select the maximum free slot count to coloring in yellow."
L["Select the maximum number of addons to display, otherwise drag to '0' to display all."] = "Select the maximum number of addons to display, otherwise drag to '0' to display all."
L["Select the maximum number of entries from the guild log, otherwise drag to 'All'."] = "Select the maximum number of entries from the guild log, otherwise drag to 'All'."
L["Select to show XP as an absolute value; Deselected will show it as a percentage."] = "Select to show XP as an absolute value; Deselected will show it as a percentage."
L["Separate mobile app user"] = "Separate mobile app user"
L["Separate quests by"] = "Separate quests by"
L["Separate tables by actions and 'Show max. entries' used per table."] = "Separate tables by actions and 'Show max. entries' used per table."
L["Separate the quests by header (like Blizzard) or status"] = "Separate the quests by header (like Blizzard) or status"
L["Session"] = "Session"
L["Session loss"] = "Session loss"
L["Session profit"] = "Session profit"
L["Set"] = "Set"
L["Set your own Title instead of 'Game Menu'"] = "Set your own Title instead of 'Game Menu'"
L["Sets"] = "Sets"
L["Shipments"] = "Shipments"
L["Short Tooltip"] = "Short Tooltip"
L["Short transport menu"] = "Short transport menu"
L["Shorter Broker"] = "Shorter Broker"
L["Shorter Events"] = "Shorter Events"
L["Show a list of your characters with count of chilling, working and followers on missions in tooltip"] = "Show a list of your characters with count of chilling, working and followers on missions in tooltip"
L["Show a list of your characters with count of chilling, working and ships on missions in tooltip"] = "Show a list of your characters with count of chilling, working and ships on missions in tooltip"
L["Show a list of your characters with count of ready and active missions in tooltip"] = "Show a list of your characters with count of ready and active missions in tooltip"
L["Show a list of your characters with count of ready and available targets in tooltip"] = "Show a list of your characters with count of ready and available targets in tooltip"
L["Show active missions"] = "Show active missions"
L["Show active missions in tooltip"] = "Show active missions in tooltip"
L["Show 'AddOn Loaded...'"] = "Show 'AddOn Loaded...'"
L["Show 'AddOn Loaded...' message on logins and UI reloads"] = "Show 'AddOn Loaded...' message on logins and UI reloads"
L["Show all counts of followers, champions and troops as overall summary on broker button. You can disable single types with following toggles."] = "Show all counts of followers, champions and troops as overall summary on broker button. You can disable single types with following toggles."
L["Show all entries their tainting the environment. Be carefull. Can produce error in combat."] = "Show all entries their tainting the environment. Be carefull. Can produce error in combat."
L["Show all in one"] = "Show all in one"
L["Show applicants in tooltip"] = "Show applicants in tooltip"
L["Show applicants on broker button"] = "Show applicants on broker button"
L["Show archievements"] = "Show archievements"
L["Show artifact frame"] = "Show artifact frame"
L["Show available blueprints in tooltip"] = "Show available blueprints in tooltip"
L["Show available missions"] = "Show available missions"
L["Show available missions in tooltip"] = "Show available missions in tooltip"
L["Show average item level"] = "Show average item level"
L["Show bagspace instead used and max. bagslots in broker button"] = "Show bagspace instead used and max. bagslots in broker button"
L["Show BattleNet friends"] = "Show BattleNet friends"
L["Show BattleTag"] = "Show BattleTag"
L["Show BattleTag/RealID"] = "Show BattleTag/RealID"
L["Show blueprints"] = "Show blueprints"
L["Show broadcast message"] = "Show broadcast message"
L["Show cache forcast"] = "Show cache forcast"
L["Show cache forcast in title"] = "Show cache forcast in title"
L["Show challenges"] = "Show challenges"
L["Show champions"] = "Show champions"
L["Show champions in tooltip"] = "Show champions in tooltip"
L["Show champions summary on broker button"] = "Show champions summary on broker button"
L["Show character gold"] = "Show character gold"
L["Show character gold on broker button"] = "Show character gold on broker button"
L["Show characters"] = "Show characters"
L["Show characters from all factions (alliance, horde and neutral) in tooltip"] = "Show characters from all factions (alliance, horde and neutral) in tooltip"
L["Show characters from all factions in tooltip."] = "Show characters from all factions in tooltip."
L["Show characters from all realms in tooltip."] = "Show characters from all realms in tooltip."
L["Show characters from connected realms, same battlegroup or all realms in tooltip"] = "Show characters from connected realms, same battlegroup or all realms in tooltip"
L["Show classic raids"] = "Show classic raids"
L["Show cooldowns"] = "Show cooldowns"
L["Show count of mobile chatter on broker button"] = "Show count of mobile chatter on broker button"
L["Show current set"] = "Show current set"
L["Show current zone from guild member"] = "Show current zone from guild member"
L["Show current zone from guild members in tooltip"] = "Show current zone from guild members in tooltip"
L["Show date"] = "Show date"
L["Show difference of last change in tooltip"] = "Show difference of last change in tooltip"
L["Show dig site status"] = "Show dig site status"
L["Show dig site status in broker button."] = "Show dig site status in broker button."
L["Show discount"] = "Show discount"
L["Show dungeons"] = "Show dungeons"
L["Show 'empty socket' mark"] = "Show 'empty socket' mark"
L["Show equipment sets"] = "Show equipment sets"
L["Show events"] = "Show events"
L["Show expire date instead of duration"] = "Show expire date instead of duration"
L["Show expired classic raids"] = "Show expired classic raids"
L["Show expired raids"] = "Show expired raids"
L["Show faction"] = "Show faction"
L["Show favorites only in tooltip"] = "Show favorites only in tooltip"
L["Show flex raids"] = "Show flex raids"
L["Show follower slots"] = "Show follower slots"
L["Show followers"] = "Show followers"
L["Show followers in tooltip"] = "Show followers in tooltip"
L["Show followers on missions"] = "Show followers on missions"
L["Show followers summary on broker button"] = "Show followers summary on broker button"
L["Show freespace"] = "Show freespace"
L["Show friends"] = "Show friends"
L["Show game"] = "Show game"
L["Show garrison cache forecast for all your characters in tooltip"] = "Show garrison cache forecast for all your characters in tooltip"
L["Show garrison cache forecast for your current char in broker button"] = "Show garrison cache forecast for your current char in broker button"
L["Show GMTicket"] = "Show GMTicket"
L["Show GMTickets in tooltip and average wait time in broker button"] = "Show GMTickets in tooltip and average wait time in broker button"
L["Show green text"] = "Show green text"
L["Show group member name with same quests"] = "Show group member name with same quests"
L["Show guild member level up notification in chat frame. (This is not a gratulation bot!)"] = "Show guild member level up notification in chat frame. (This is not a gratulation bot!)"
L["Show Guild Message of the Day in tooltip"] = "Show Guild Message of the Day in tooltip"
L["Show history of the 5 last changes in tooltip"] = "Show history of the 5 last changes in tooltip"
L["Show home"] = "Show home"
L["Show inventory"] = "Show inventory"
L["Show item summary by expansion"] = "Show item summary by expansion"
L["Show item summary by quality"] = "Show item summary by quality"
L["Show level up notification"] = "Show level up notification"
L["Show lfr"] = "Show lfr"
L["Show list of buildings there are under construction in tooltip"] = "Show list of buildings there are under construction in tooltip"
L["Show list of reputation discounts in tooltip"] = "Show list of reputation discounts in tooltip"
L["Show max. entries"] = "Show max. entries"
L["Show memory usage"] = "Show memory usage"
L["Show mission follower slots in tooltip."] = "Show mission follower slots in tooltip."
L["Show mission iLevel"] = "Show mission iLevel"
L["Show mission item level in tooltip."] = "Show mission item level in tooltip."
L["Show mission level"] = "Show mission level"
L["Show mission level in tooltip."] = "Show mission level in tooltip."
L["Show mission type"] = "Show mission type"
L["Show mission type in tooltip."] = "Show mission type in tooltip."
L["Show mobile chatter"] = "Show mobile chatter"
L["Show mobile chatter in tooltip (Armory App users)"] = "Show mobile chatter in tooltip (Armory App users)"
L["Show necessary archievements to unlock blueprints in tooltip"] = "Show necessary archievements to unlock blueprints in tooltip"
L["Show 'not enchanted' mark"] = "Show 'not enchanted' mark"
L["Show notes from guild member"] = "Show notes from guild member"
L["Show notes from guild members in tooltip"] = "Show notes from guild members in tooltip"
L["Show notes in login"] = "Show notes in login"
L["Show off. notes on login"] = "Show off. notes on login"
L["Show officer notes from guild member"] = "Show officer notes from guild member"
L["Show officer notes from guild members in tooltip. (This option will be ignored if you have not permission to read the officer notes)"] = "Show officer notes from guild members in tooltip. (This option will be ignored if you have not permission to read the officer notes)"
L["Show options"] = "Show options"
L["Show other chars xp"] = "Show other chars xp"
L["Show ownership"] = "Show ownership"
L["Show professions from guild member"] = "Show professions from guild member"
L["Show professions from guild members in tooltip"] = "Show professions from guild members in tooltip"
L["Show PvP talents in tooltip"] = "Show PvP talents in tooltip"
L["Show quest id"] = "Show quest id"
L["Show quest id's"] = "Show quest id's"
L["Show quest id's in tooltip."] = "Show quest id's in tooltip."
L["Show quest level"] = "Show quest level"
L["Show quest option"] = "Show quest option"
L["Show quest options like track, untrack, share and cancel in tooltip."] = "Show quest options like track, untrack, share and cancel in tooltip."
L["Show quest tag"] = "Show quest tag"
L["Show quest tags"] = "Show quest tags"
L["Show quest tags in tooltip."] = "Show quest tags in tooltip."
L["Show quest text"] = "Show quest text"
L["Show quest unit circles"] = "Show quest unit circles"
L["Show quest zone"] = "Show quest zone"
L["Show quest zone in tooltip."] = "Show quest zone in tooltip."
L["Show QuestIDs in tooltip"] = "Show QuestIDs in tooltip"
L["Show race from guild member"] = "Show race from guild member"
L["Show race from guild members in tooltip"] = "Show race from guild members in tooltip"
L["Show raids"] = "Show raids"
L["Show rank from guild member"] = "Show rank from guild member"
L["Show rank name from guild members in tooltip"] = "Show rank name from guild members in tooltip"
L["Show ready missions"] = "Show ready missions"
L["Show ready missions in tooltip"] = "Show ready missions in tooltip"
L["Show RealID"] = "Show RealID"
L["Show realm"] = "Show realm"
L["Show realm gold"] = "Show realm gold"
L["Show realm names after character names from other realms (connected realms)."] = "Show realm names after character names from other realms (connected realms)."
L["Show realm names behind guild and character names in tooltip. Guilds and characters from connected-realms gets an asterisk behind the names if this option is unchecked."] = "Show realm names behind guild and character names in tooltip. Guilds and characters from connected-realms gets an asterisk behind the names if this option is unchecked."
L["Show seconds"] = "Show seconds"
L["Show session earn/loss"] = "Show session earn/loss"
L["Show session profit"] = "Show session profit"
L["Show session profit on broker button"] = "Show session profit on broker button"
L["Show short quest tags"] = "Show short quest tags"
L["Show short quest tags in tooltip."] = "Show short quest tags in tooltip."
L["Show standing text in tooltip"] = "Show standing text in tooltip"
L["Show status"] = "Show status"
L["Show summary of gold on current realm (factionbound) on broker button"] = "Show summary of gold on current realm (factionbound) on broker button"
L["Show szenarios"] = "Show szenarios"
L["Show tainting entries"] = "Show tainting entries"
L["Show talents"] = "Show talents"
L["Show talents in tooltip"] = "Show talents in tooltip"
L["Show time in characters list"] = "Show time in characters list"
L["Show tooltip"] = "Show tooltip"
L["Show total cap"] = "Show total cap"
L["Show total members count on broker button"] = "Show total members count on broker button"
L["Show total/weekly cap"] = "Show total/weekly cap"
L["Show troops"] = "Show troops"
L["Show troops in tooltip"] = "Show troops in tooltip"
L["Show troops summary on broker button"] = "Show troops summary on broker button"
L["Show T-Set"] = "Show T-Set"
L["Show under construction"] = "Show under construction"
L["Show upgrade info"] = "Show upgrade info"
L["Show weekly cap"] = "Show weekly cap"
L["Show world"] = "Show world"
L["Show world bosses"] = "Show world bosses"
L["Show your other chars"] = "Show your other chars"
L["Show/Hide profession cooldowns from all characters."] = "Show/Hide profession cooldowns from all characters."
L["Showing a maximum of %d addons."] = "Showing a maximum of %d addons."
L["Showing all addons."] = "Showing all addons."
L["Shown"] = "Shown"
L["SingleRepairSummary"] = "SingleRepairSummary"
L["SizeSuffix-10E12"] = "T"
L["SizeSuffix-10E15"] = "Qa"
L["SizeSuffix-10E18"] = "Qi"
L["SizeSuffix-10E3"] = "K"
L["SizeSuffix-10E6"] = "M"
L["SizeSuffix-10E9"] = "B"
L["Some shared options for the modules GPS, Location and ZoneText"] = "Some shared options for the modules GPS, Location and ZoneText"
L["Sorry"] = "Sorry"
L["Sorry, In combat lockdown."] = "Sorry, In combat lockdown."
L["Space between currencies"] = "Space between currencies"
L["Special NPCs"] = "Special NPCs"
L["Specialization"] = "Specialization"
L["Speed"] = "Speed"
L["Speed bonus"] = "Speed bonus"
L["Spent artifact power"] = "Spent artifact power"
L["Spent points"] = "Spent points"
L["Split Characters and BattleNet-Friends on Broker Button"] = "Split Characters and BattleNet-Friends on Broker Button"
L["Split friends on Broker"] = "Split friends on Broker"
L["Standing of watched faction"] = "Standing of watched faction"
L["Standing text"] = "Standing text"
L["Status icon"] = "Status icon"
L["Status text"] = "Status text"
L["Stored mails"] = "Stored mails"
L["Stuff"] = "Stuff"
L["Subzone"] = "Subzone"
L["Suffix coloring"] = "Suffix coloring"
L["Summary"] = "Summary"
L["Surprise"] = "Surprise"
L["switch between 12 and 24 time format"] = "switch between 12 and 24 time format"
L["Switch between global and per character saved settings"] = "Switch between global and per character saved settings"
L["switch between local and realm time"] = "switch between local and realm time"
L["Switch between local and realm time in broker button"] = "Switch between local and realm time in broker button"
L["Switch between time format 24 hours and 12 hours with AM/PM"] = "Switch between time format 24 hours and 12 hours with AM/PM"
L["Switch display"] = "Switch display"
L["switch displayed xp data for characters under the level cap"] = "switch displayed xp data for characters under the level cap"
L["Switch mode"] = "Switch mode"
L["Switch spec."] = "Switch spec."
L["Switch window/fullscreen mode"] = "Switch window/fullscreen mode"
L["Talents menu"] = "Talents menu"
L["Talents pane"] = "Talents pane"
L["Tanaan Jungle Dailies"] = "Tanaan Jungle Dailies"
L["Test"] = "Test phrase"
L["Text bar"] = "Text bar"
L["Text bar character"] = "Text bar character"
L["Text bar is a simple row of colored characters act like status, reputation or xp bar but without textures."] = "Text bar is a simple row of colored characters act like status, reputation or xp bar but without textures."
L["Text bar num characters"] = "Text bar num characters"
L["The necessary time to collect memory usage of all addons depends on CPU speed, CPU usage, the number of running addons and more."] = "The necessary time to collect memory usage of all addons depends on CPU speed, CPU usage, the number of running addons and more."
L["The secondary tooltip will be displayed by moving the mouse over a friend in main tooltip. The tooltip will be displayed if one of the following options activated."] = "The secondary tooltip will be displayed by moving the mouse over a friend in main tooltip. The tooltip will be displayed if one of the following options activated."
L["The secondary tooltip will be displayed by moving the mouse over a guild member in main tooltip. The tooltip will be displayed if one of the following options activated."] = "The secondary tooltip will be displayed by moving the mouse over a guild member in main tooltip. The tooltip will be displayed if one of the following options activated."
L["Then push again..."] = "Then push again..."
L["This module has no options"] = "This module has no options"
L["This module is waiting for some localized names."] = "This module is waiting for some localized names."
L["This option is disabled"] = "This option is disabled"
L["to"] = "to"
L["to delete"] = "to delete"
L["to equip"] = "to equip"
L["to update/save"] = "to update/save"
L["toggle between free and used/max bagslots in broker button"] = "toggle between free and used/max bagslots in broker button"
L["Tooltip"] = "Tooltip"
L["Total Gold"] = "Total Gold"
L["Total members count"] = "Total members count"
L["Total Memory usage"] = "Total Memory usage"
L["Total slots"] = "Total slots"
L["Traffic"] = "Traffic"
L["Transmutation cooldown group"] = "Transmutation cooldown group"
L["Try fallback to player money."] = "Try fallback to player money."
L["Under"] = "Under"
L["Under construction"] = "Under construction"
L["Unknown set"] = "Unknown set"
L["Unspent talents"] = "Unspent talents"
L["Update interval"] = "Update interval"
L["Upgrade finished"] = "Upgrade finished"
L["Use background colored row for follower status instead to split in separate tables"] = "Use background colored row for follower status instead to split in separate tables"
L["Use custom title as tooltip title"] = "Use custom title as tooltip title"
L["Use guild money"] = "Use guild money"
L["Use guild money on auto repair if you can"] = "Use guild money on auto repair if you can"
L["Use LibDBIcon to add Broker to Minimap"] = "Use LibDBIcon to add Broker to Minimap"
L["Use MouseWheel"] = "Use MouseWheel"
L["Use prefix"] = "Use prefix"
L["Use prefix 'BE..' on module registration at LibDataBroker. This fix problems with other addons with same broker names but effect your current settings in panel addons like Bazooka or Titan Panel."] = "Use prefix 'BE..' on module registration at LibDataBroker. This fix problems with other addons with same broker names but effect your current settings in panel addons like Bazooka or Titan Panel."
L["Use the MouseWheel to change the volume"] = "Use the MouseWheel to change the volume"
L["UTC time"] = "UTC time"
L["UTC:"] = "UTC:"
L["Value/Cap"] = "Value/Cap"
L["Vendor price"] = "Vendor price"
L["Version"] = "Version"
L["Video Volume"] = "Video Volume"
L["wait time"] = "wait time"
L["Warn low free slots"] = "Warn low free slots"
L["Watch list"] = "Watch list"
L["Weekly"] = "Weekly"
L["Where does the second tooltip for a single currency are displayed from the first tooltip"] = "Where does the second tooltip for a single currency are displayed from the first tooltip"
L["Whisper with a friend"] = "Whisper with a friend"
L["Whisper with a member"] = "Whisper with a member"
L["Windowed / Fullscreen"] = "Windowed / Fullscreen"
L["With options"] = "With options"
L["Without missions"] = "Without missions"
L["Without options"] = "Without options"
L["worker"] = "worker"
L["World"] = "World"
L["World bosses"] = "World bosses"
L["World latency"] = "World latency"
L["World quests status update|nneeds level 110 or higher"] = "World quests status update|nneeds level 110 or higher"
L["Worldbosses"] = "Worldbosses"
L["WoW Expansions"] = "WoW Expansions"
L["WoW Expansions (hide empty)"] = "WoW Expansions (hide empty)"
L["WoW Expansions with vendor price"] = "WoW Expansions with vendor price"
L["WoW Expansions with vendor price (hide empty)"] = "WoW Expansions with vendor price (hide empty)"
L["XP bonus"] = "XP bonus"
L["XP gain disabled"] = "XP gain disabled"
L["You are not in a queue."] = "You are not in a queue."
L["You have no quests in your quest log"] = "You have no quests in your quest log"
L["You have not unlocked your order hall"] = "You have not unlocked your order hall"
L["Your current settings and all other data collected by some modules like mail on other chars or profession cooldowns of your twinks."] = "Your current settings and all other data collected by some modules like mail on other chars or profession cooldowns of your twinks."
L["Your guild leadership denied the use of guild money for auto repair."] = "Your guild leadership denied the use of guild money for auto repair."
L["Your other chars (%s)"] = "Your other chars (%s)"
L["Your team"] = "Your team"
L["Zone status"] = "Zone status"
L["ZoneText"] = "ZoneText"


