local _, cfg = ... --export config
local addon, ns = ... --get addon namespace

if not cfg.pet.castbar.enable then return end
local unit = "pet"
local cf = CreateFrame("StatusBar")
cf:SetSize(unpack(cfg.pet.castbar.barsize))
cf:SetPoint("CENTER",UIParent,cfg.pet.castbar.x,cfg.pet.castbar.y)
cf:SetStatusBarTexture(cfg.pet.castbar.texture)
cf:SetStatusBarColor(1, 1, cfg.transparency.alpha)
cf:SetOrientation("VERTICAL")
cf:SetBackdrop({bgFile = cfg.pet.castbar.texture})
cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)

local cfet = 0
cf:SetScript("OnUpdate",
  function(f, e)
   cfet = cfet + e

    if cfet > 0 then
	  local spell, _, displayName, _, startTime, endTime, _, _, interrupt = UnitCastingInfo(unit)
	  
	  if not spell then
		spell, _, displayName, _, startTime, endTime, _, interrupt = UnitChannelInfo(unit)
	  end

	  if spell then
		cf:SetMinMaxValues(startTime, endTime)
		cf:SetValue(1000 * GetTime())

		if not interrupt then
		  cf:SetStatusBarColor(0, 0.9, 0, cfg.transparency.alpha)
		  cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)
		else
		  cf:SetStatusBarColor(1, 0.1, 0.1, cfg.transparency.alpha)
		  cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)
		end
	  else
		cf:SetStatusBarColor(0, 0, 0, 0)
		cf:SetBackdropColor(0, 0, 0, 0)
	  end
	  
	  cfet = 0
	end
  end
)
