local _, cfg = ... --export config
local addon, ns = ... --get addon namespace

if not cfg.focus.castbar.enable then return end
local unit = "focus"
local cf = CreateFrame("StatusBar")
cf:SetSize(unpack(cfg.focus.castbar.barsize))
cf:SetPoint("CENTER",UIParent,cfg.focus.castbar.x,cfg.focus.castbar.y)
cf:SetStatusBarTexture(cfg.focus.castbar.texture)
cf:SetStatusBarColor(1, 1, cfg.transparency.alpha)
cf:SetOrientation("VERTICAL")
cf:SetBackdrop({bgFile = cfg.focus.castbar.texture})
cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)
--cast text
cft = cf:CreateFontString(nil, "ARTWORK", "GameFontHighlight")
cft:SetPoint("BOTTOMRIGHT",cf,"BOTTOMLEFT",10,-12)

local cfet = 0
cf:SetScript("OnUpdate",
  function(f, e)
   cfet = cfet + e

    if cfet > 0 then
	  local spell, _, displayName, _, startTime, endTime, _, _, interrupt = UnitCastingInfo(unit)
	  
	  if not spell then
		spell, _, displayName, _, startTime, endTime, _, interrupt = UnitChannelInfo(unit)
	  end

	  if spell then
		cft:SetText(displayName)
		cf:SetMinMaxValues(startTime, endTime)
		cf:SetValue(1000 * GetTime())

		if not interrupt then
		  cf:SetStatusBarColor(0, 0.9, 0, cfg.transparency.alpha)
		  cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)
		  cft:SetTextColor(1, 1, 1, 1)
		else
		  cf:SetStatusBarColor(1, 0.1, 0.1, cfg.transparency.alpha.alpha)
		  cf:SetBackdropColor(0, 0, 0, cfg.transparency.alpha/2)
		  cft:SetTextColor(0.9, 0.9, 0.9, 1)
		end
	  else
		cf:SetStatusBarColor(0, 0, 0, 0)
		cf:SetBackdropColor(0, 0, 0, 0)
	    cft:SetTextColor(0, 0, 0, 0)
	  end
	  
	  cfet = 0
	end
  end
)
