-------------------------------------------------------------------------------

local VERSION = GetAddOnMetadata( "BloodthistleSimulator", "Version" )
local Main = LibStub("AceAddon-3.0"):NewAddon( "BloodthistleSimulator",
                                               "AceEvent-3.0" )
										

BloodthistleSimulator = Main
Main.version          = VERSION
Main.colormode        = "3"

Main.mods = {}
local g_intensity   = 0

local function SelectTime( p, start, finish, clamp )
	local a = (p-start) / (finish-start)
	if clamp then
		if a < 0 then a = 0 end
		if a > 1 then a = 1 end
	end
	return a
end

-- modulator function: function( progress, current )
--
-------------------------------------------------------------------------------
-- initial buzz
table.insert( Main.mods, function( p, cur )
	
	local a = SelectTime( p, 0.00, 1/60, true )
	a = 1-a
	a = math.pow( a, 2 )
	a = a * 500
	return cur + a
	
end)
table.insert( Main.mods, function( p, cur )
	if p < 0.5 then
		Main.colormode = "7"
	else
		Main.colormode = "3"
	end
	local a = SelectTime( p, 0.01, 0.35, true )
	a = 1-a
	a = math.pow( a, 5 )
	a = a * 150
	return cur + a
	
end)

-------------------------------------------------------------------------------
-- base level/eventual degradation
table.insert( Main.mods, function( p, cur )
	local a = SelectTime( p, 0, 30, true )
	a = 0.01 + a * 0.3
	return cur + a
end)

-------------------------------------------------------------------------------
-- withdrawal bonus
table.insert( Main.mods, function( p, cur )
	local a = SelectTime( p, 10, 30, true )
	a = a * 25
	return cur + a
end)
table.insert( Main.mods, function( p, cur )
	local a = SelectTime( p, 20, 30, true )
	a = a * 200
	return cur + a
end)

local g_heartbeat_time = 0

table.insert( Main.mods, function( p, cur )
	if p > 1 then
		local a = math.sin( GetTime() )
		return cur * (1 + a * 0.30)
	end
end)

-- heartbeat
table.insert( Main.mods, function( p, cur )
	if p > 9.5 then
		local rate = 1.2 - SelectTime( p, 9.5, 30, true ) * 0.4
		if GetTime() >= g_heartbeat_time + rate then
			g_heartbeat_time = GetTime()
		end
		
		local a = (GetTime() - g_heartbeat_time) / 0.4
		a = math.max(1-a,0)
		
		return cur * (1+a*2)
	end
end)

-- fade
table.insert( Main.mods, function( p, cur )
	local a = SelectTime( p, 30, 32, true )
	a = 1-a
	a = math.pow(a,3)
	return cur * a
end)

-------------------------------------------------------------------------------
-- Initialization.
--
function Main:OnInitialize()

end

-------------------------------------------------------------------------------
-- Post-initialization
--
function Main:OnEnable()
	g_intensity = 0
	SetCVar( 'colorblindWeaknessFactor', 0 )
	SetCVar( "colorblindSimulator", "0" )
	
	local frame = CreateFrame( "Frame" )
	Main.update_frame = frame
	frame:Show()
	frame:SetScript( "OnUpdate", function() Main.OnUpdate() end )
	Main:RegisterEvent( "PLAYER_LOGOUT", "OnLogout" )
	
	C_Timer.After( 10, function()
		-- just a bit scared if the race is actually readable when the addon loads.
		local _, raceEn = UnitRace('player')
		if raceEn ~= "BloodElf" then
			-- not a blood elf. disable.
			Main.update_frame:Hide()
		end
	end)
end



local g_expire_time = -3600

-------------------------------------------------------------------------------
function Main:OnLogout()
	SetCVar( 'colorblindWeaknessFactor', "0" )
	SetCVar( "colorblindSimulator", "0" )
	Main.update_frame:Hide()
end

-------------------------------------------------------------------------------
function Main.OnUpdate()
	if InCombatLockdown() then return end
	
	local buff,_,_,_,_,buff_duration,buff_expires = UnitBuff( "player", "Bloodthistle" )
	local debuff,_,_,_,_,debuff_duration,debuff_expires = UnitDebuff( "player", "Bloodthistle Withdrawal" )
	if debuff_expires then
		g_expire_time = debuff_expires
	end
	
	local intensity = 0
	local gt = GetTime()
	
	local progress -- done
	
	if buff then
		-- they're high
		progress = gt - (buff_expires - buff_duration)
	elseif debuff then
		-- they're low
		progress = gt - (debuff_expires - debuff_duration) + 10*60
	else
		-- recovering
		progress = (gt - g_expire_time) + 60*30
	end
	
	
	progress = progress / 60 -- minutes are a bit more wieldy in this case
	-- 0-10 = initial phase, 10-30 = withdrawal, above = recovery
	
	-- test mode --
	--[[
	if Main.testtime then
		progress = (gt - Main.testtime) / 60
	else
		local x, y = GetCursorPosition()
		progress = y / 768 * 10 -- set test range here
	end
	
	if not Main.testframe then
		Main.testframe = CreateFrame( "Frame", nil, UIParent )
		Main.testframe:SetSize( 200, 100 )
		Main.testframe:SetPoint( "CENTER" )
		Main.testframe.text = Main.testframe:CreateFontString()
		Main.testframe.text:SetAllPoints()
		Main.testframe.text:SetFont( "Fonts\\ARIALN.TTF", 14, "OUTLINE" )
		Main.testframe:Show()
	end
	---]]
	
	if progress > 40 then
		-- hard turn off.
		intensity = 0
	else
	
		for _, f in ipairs( Main.mods ) do
			intensity = f( progress, intensity ) or intensity
		end
	end
	
	if math.abs( g_intensity - intensity ) > 0.01 then
		g_intensity = g_intensity + (intensity-g_intensity) * 0.2
		
		-- colorblindSimulator		0-11
		-- colorblindWeaknessFactor	0-1000
		
		if g_intensity > 0.01 then
			if GetCVar( "colorblindSimulator" ) ~= Main.colormode then
				SetCVar( "colorblindSimulator", Main.colormode )
			end
			SetCVar( "colorblindWeaknessFactor", g_intensity )
		else
			if GetCVar( "colorblindSimulator" ) ~= "0" then
				SetCVar( "colorblindSimulator", "0" )
			end
		end
		
	end
	
	--Main.testframe.text:SetText( "BTS TEST\n" .. string.format( "%.2f min / %d sec", progress, progress * 60 ) .. "\n" .. g_intensity )
	
end

-------------------------------------------------------------------------------
-- Slash command.
--
SlashCmdList["BloodthistleSimulator"] = function( msg ) 
	
end

