local MAJOR, MINOR = "LibPetBreedInfo-1.0", 61
local lib, oldminor = LibStub:NewLibrary(MAJOR, MINOR)

if not lib then return end
lib.breedData = {}
--
-- GLOBALS:
--

local _G = _G
local hooksecurefunc, tinsert, pairs, wipe = _G.hooksecurefunc, _G.table.insert, _G.pairs, _G.wipe
local ipairs = _G.ipairs
local C_PetJournal, C_PetBattles = _G.C_PetJournal, _G.C_PetBattles
local _
local EMPTY_PET = "0x0000000000000000"
local epsilion = .005
local STATE_Mod_SpeedPrecent = 25
local STATE_MaxHealthBonus = 2
local STATE_Mod_MaxHealthPrercent = 99
local HEALTH,POWER,SPEED = 1,2,3
local BASE_HEALTH = 100
local HEALTH_PER_STAMINA = 5
local FALLBACK_BREEDS = {3,4,5,6,7,8,9,10,11,12}
local WILD_PET_HEALTH_MULTIPLIER = 1.2
local MAX_PETS_PER_TEAM = 3
--
-- Non Lib helper functions
--
local function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

local function clamp(num,minVal,maxVal)
	return math.min(math.max(num,minVal),maxVal)
end

local function inverseStats(num)
	return num ~= 0 and 100/(num+100) or 1
end


--Gets the breed index for the given pet
--Returns arg1: petIndex that can be used by GetBreedName to return the breeds name. arg2: a confidence indicator, lower numbers are better. A good cutoff for high confidence is .15
--Returns nil if the species cannot battle or does not have a base stats profile or if the petID is not valid
function lib:GetBreedByPetID(petID)
	if petID then
		local speciesID, _, level, _, _, _,_ ,_, _, _, _, _, _, _, canBattle = C_PetJournal.GetPetInfoByPetID(petID)
		if not canBattle then return end
		local _, maxHealth, power, speed, rarity = C_PetJournal.GetPetStats(petID)
			return self:GetBreedByStats(speciesID,level,rarity,maxHealth,power,speed)
	end
end

--Gets the breed index for the given hypothetical pet
--Returns arg1: petIndex that can be used by GetBreedName to return the breeds name. arg2: a confidence indicator, lower numbers are better. A good cutoff for high confidence is .15
--Returns nil if the species cannot battle or does not have a base stats profile or if level, health power and speed are not numbers and rarity is not between 1 and 4
function lib:GetBreedByStats(speciesID,level,rarity,health,power,speed)
	if not self.breedData.speciesToBaseStatProfile[speciesID] or not self.breedData.qualityMultiplier[rarity] or  
		type(level) ~= "number" or type(health) ~= "number" or type(power) ~= "number" or type(speed) ~= "number" then 
			return 
	end
	local canBattle	  = select(8,C_PetJournal.GetPetInfoBySpeciesID(speciesID))
	if not canBattle then return end
	local baseStats		 = self.breedData.speciesToBaseStatProfile[speciesID]
	local qualityMultiplier = self.breedData.qualityMultiplier[rarity]

	health = clamp(round(( ((health-BASE_HEALTH)/HEALTH_PER_STAMINA) / qualityMultiplier) - level * baseStats[HEALTH],1) / level,0,2)
	power  = clamp(round((									  power  / qualityMultiplier) - level * baseStats[POWER] ,1) / level,0,2)
	speed  = clamp(round((									speed  / qualityMultiplier) - level * baseStats[SPEED] ,1) / level,0,2)
	local breeds = self:GetAvailableBreeds(speciesID)
	breeds = --[[breeds and breeds or]] FALLBACK_BREEDS
	local leastDiff = 100
	local leastDiff2 = 100
	local breedID = 0
	for i=1,#breeds do
		local breedIndex = breeds[i]
		local breedData = self.breedData.breeds[breedIndex]
		local diff = round(math.abs(health - breedData[HEALTH]) + math.abs(power - breedData[POWER]) + math.abs(speed - breedData[SPEED]),2) + epsilion
			if diff < leastDiff then
			leastDiff2 = leastDiff
			leastDiff  = diff
			breedID	= breedIndex
		elseif diff < leastDiff2 then
			leastDiff2 = diff
		end
		end
	return breedID, round(leastDiff2 / leastDiff ,2)
end



--Gets the breed index for the given pet
--!!!Results are not valid if computed while a round play back is happening!!!
--Returns arg1: petIndex that can be used by GetBreedName to return the breeds name. arg2: a confidence indicator, lower numbers are better. A good cutoff for high confidence is .15
--Returns nil if the species cannot battle or does not have a base stats profile, or an invalid petOwner/petID is used, or if the player is not in a pet battle

--/run print(C_PetBattles.GetName(1,1),LibStub("LibPetBreedInfo-1.0"):GetBreedByPetBattleSlot(1,1))
function lib:GetBreedByPetBattleSlot(petOwner,id)
	if not C_PetBattles.IsInBattle() then return end
	if petOwner ~= LE_BATTLE_PET_ALLY and petOwner ~= LE_BATTLE_PET_ENEMY then return end
	if id <= 0 or id > MAX_PETS_PER_TEAM and id <= C_PetBattles.GetNumPets(petOwner) then return end
	local speedMultiplier  = C_PetBattles.GetStateValue(petOwner,id,STATE_Mod_SpeedPrecent)
	local healthMultiplier = C_PetBattles.GetStateValue(petOwner,id,STATE_Mod_MaxHealthPrercent)
	local healthModifier   = C_PetBattles.GetStateValue(petOwner,id,STATE_MaxHealthBonus)
	if not speedMultiplier or not healthMultiplier or not healthModifier then return end
	speedMultiplier  = inverseStats(speedMultiplier)
	healthMultiplier = inverseStats(healthMultiplier)

	if C_PetBattles.IsWildBattle() and petOwner == LE_BATTLE_PET_ENEMY then
		healthMultiplier = healthMultiplier * WILD_PET_HEALTH_MULTIPLIER
	end
	local speciesID = C_PetBattles.GetPetSpeciesID(petOwner,id)
	local speed	 = round(C_PetBattles.GetSpeed(petOwner,id) * speedMultiplier)
	local power	 = C_PetBattles.GetPower(petOwner,id)
	local health	= (C_PetBattles.GetMaxHealth(petOwner,id) * healthMultiplier) - healthModifier
	local rarity	= C_PetBattles.GetBreedQuality(petOwner,id)
	local level	 = C_PetBattles.GetLevel(petOwner,id)
	return self:GetBreedByStats(speciesID,level,rarity,health,power,speed)
end


--Gets the predicted stats for a species at a given level
--returns health,power,speed
--returns nil if the pet does not have a base stats profile, or if an invalid... breedID, rarity, or non numeric level is given.
function lib:GetPetPredictedStats(speciesID, breedID, rarity, level)
	if not self.breedData.breeds[breedID] or not self.breedData.speciesToBaseStatProfile[speciesID] or type(level) ~= "number" or not self.breedData.qualityMultiplier[rarity] then return end
	local baseStats	  = self.breedData.speciesToBaseStatProfile[speciesID]
	local multiplier	 = self.breedData.qualityMultiplier[rarity]
	local breedStats	 = self.breedData.breeds[breedID]
	local health = (round((baseStats[HEALTH] + breedStats[HEALTH]) * multiplier * level * HEALTH_PER_STAMINA) + BASE_HEALTH)
	local power  = round((baseStats[POWER]  + breedStats[POWER])  * multiplier * level) 
	local speed  = round((baseStats[SPEED]  + breedStats[SPEED])  * multiplier * level)
	return health, power , speed
end

--Gets a table containing the possible BreedID's for a given species
--Returns nil if no data is present for the given speciesID
--[[
function lib:GetAvailableBreeds(speciesID)
end]]

--Gets an iterator for all of the possible breed names
function lib:IterateBreedNames()
	return pairs(self.breedData.breedNames)
end

--Gets the string representation of a BreedID
--Returns nil for invalid breedID's
function lib:GetBreedName(breedID)
	return self.breedData.breedNames[breedID]
end


--Gets a table of possible breedId's for a given species
--BreedIDs are from 1-10
--Returns nil for invalid speciesID's
function lib:GetAvailableBreeds(speciesID)
	return self.breedData.speciesToAvailableBreeds[speciesID]
end

--/lb code LibStub("LibPetBreedInfo-1.0"):GetSpeciesWithoutProfiles()
--Gets a table of speciesIDs which are present in game but do not have a base stats profile
--This is a dev function to make updating this library easier
--Returns a table
--[[
function lib:GetSpeciesWithoutProfiles()
	local missingPets = {}
	for i=1,2000 do --2000 to catch new pet IDs
		name = C_PetJournal.GetPetInfoBySpeciesID(i)
		if name and not self.breedData.speciesToBaseStatProfile[i] then
			tinsert(missingPets,i)
		end
	end
	return missingPets
end]]

--/run LibStub("LibPetBreedInfo-1.0"):FindMissingSpeciesBreeds()
--[[function lib:FindMissingSpeciesBreeds()
	local lpj = LibStub("LibPetJournal-2.0")
	local availableBreeds = self.breedData.speciesToAvailableBreeds
	for _,v in lpj:IterateSpeciesIDs() do
		if not availableBreeds[v] then
			print(v,C_PetJournal.GetPetInfoBySpeciesID(v))
		end
	end
end]]

--/run LibStub("LibPetBreedInfo-1.0"):ExtractData()
--[[function lib:ExtractData()
	BPBID.InitializeArrays()
	local speciesToBaseStatProfile= self.breedData.speciesToBaseStatProfile
	for k,v in pairs(BPBID.BasePetStats) do
		if not speciesToBaseStatProfile[k] then 
			print(k)
		end
	end
end]]




lib.breedData.breeds = {
	[3]={.5,.5,.5}, --1
	[4]={0,2,0}, --2
	[5]={0,0,2}, --3
	[6]={2,0,0}, --4 
	[7]={.9,.9,0},--5
	[8]={0,.9,.9},--6
	[9]={.9,0,.9},--7
	[10]={.4,.9,.4},--8
	[11]={.4,.4,.9},--9
	[12]={.9,.4,.4}--10
}

lib.breedData.breedNames = {
	[3]="B/B", --1
	[4]="P/P", --2
	[5]="S/S", --3
	[6]="H/H", --4 
	[7]="H/P",--5
	[8]="P/S",--6
	[9]="H/S",--7
	[10]="P/B",--8
	[11]="S/B",--9
	[12]="H/B"--10
}

lib.breedData.qualityMultiplier = {1,1.1,1.2,1.3,1.4,1.5}


lib.breedData.speciesToBaseStatProfile = {
	[2] = {510.5, 8, 9.5},
	[39] = {8.5, 7.5, 8},
	[40] = {7, 8.5, 8.5},
	[41] = {7, 8.5, 8.5},
	[42] = {6.5, 9, 8.5},
	[43] = {7, 9, 8},
	[44] = {7, 8.5, 8.5},
	[45] = {7, 8.5, 8.5},
	[46] = {7.5, 7.5, 9},
	[47] = {8, 7.5, 8.5},
	[49] = {9, 7, 8},
	[50] = {9, 8, 7},
	[51] = {8.5, 8, 7.5},
	[52] = {8, 8, 8},
	[55] = {8.5, 7, 8.5},
	[56] = {8.5, 9, 6.5},
	[57] = {8.5, 7.5, 8},
	[58] = {7, 9, 8},
	[59] = {8.5, 8, 7.5},
	[64] = {8.5, 7.5, 8},
	[65] = {8.5, 7.5, 8},
	[67] = {8, 8, 8},
	[68] = {8, 8, 8},
	[69] = {7.5, 7.5, 9},
	[70] = {8, 7.5, 8.5},
	[71] = {8, 8, 8},
	[72] = {8, 7, 9},
	[73] = {8, 8, 8},
	[74] = {7.5, 7.5, 9},
	[75] = {7.5, 8.5, 8},
	[77] = {8, 8, 8},
	[78] = {7.5, 8.5, 8},
	[83] = {8.5, 7.5, 8},
	[84] = {8, 8, 8},
	[85] = {8.5, 7.5, 8},
	[86] = {8.5, 7.5, 8},
	[87] = {8, 8.5, 7.5},
	[89] = {8, 8, 8},
	[90] = {7, 8.5, 8.5},
	[92] = {8, 8, 8},
	[93] = {6.5, 9, 8.5},
	[94] = {7, 7, 10},
	[95] = {8, 8, 8},
	[106] = {8.5, 7.5, 8},
	[107] = {8, 8, 8},
	[111] = {8, 8, 8},
	[114] = {8.5, 8.5, 7},
	[115] = {8, 8, 8},
	[116] = {8, 8, 8},
	[117] = {8, 8, 8},
	[118] = {8, 8, 8},
	[119] = {8, 8, 8},
	[120] = {8, 8, 8},
	[121] = {8, 8, 8},
	[122] = {8, 8, 8},
	[124] = {8, 8, 8},
	[125] = {8, 8, 8},
	[126] = {8, 8, 8},
	[127] = {8, 7.5, 8.5},
	[128] = {8, 8, 8},
	[130] = {8, 8, 8},
	[131] = {8, 7.5, 8.5},
	[132] = {9, 8, 7},
	[136] = {8, 8, 8},
	[137] = {8, 7, 9},
	[138] = {8.5, 7.5, 8},
	[139] = {7.5, 8.5, 8},
	[140] = {8, 8.5, 7.5},
	[141] = {7.5, 7.5, 9},
	[142] = {8, 8.5, 7.5},
	[143] = {7.5, 8.5, 8},
	[144] = {7.5, 7.5, 9},
	[145] = {8.5, 7.5, 8},
	[146] = {7.5, 8, 8.5},
	[149] = {7.5, 7, 9.5},
	[153] = {8, 8, 8},
	[155] = {8, 8, 8},
	[156] = {8, 8, 8},
	[157] = {8, 8, 8},
	[158] = {8, 8, 8},
	[159] = {8, 8, 8},
	[160] = {8, 8, 8},
	[162] = {8, 8.5, 7.5},
	[163] = {8, 8.5, 7.5},
	[164] = {8, 8.5, 7.5},
	[165] = {8.5, 7.5, 8},
	[166] = {8.5, 8.5, 7},
	[167] = {9, 7.5, 7.5},
	[168] = {8.5, 7.5, 8},
	[169] = {8, 8, 8},
	[170] = {8, 8, 8},
	[171] = {8, 8, 8},
	[172] = {7.5, 8.5, 8},
	[173] = {8, 8.5, 7.5},
	[174] = {8, 8.5, 7.5},
	[175] = {7.5, 8.5, 8},
	[179] = {8.5, 8, 7.5},
	[180] = {8.5, 8, 7.5},
	[183] = {8, 8, 8},
	[186] = {7.5, 8.5, 8},
	[187] = {8.5, 8.5, 7},
	[188] = {8.5, 8.5, 7},
	[189] = {8, 8, 8},
	[190] = {8.5, 8.5, 7},
	[191] = {8.5, 7.5, 8},
	[192] = {8, 8, 8},
	[193] = {8, 8.5, 7.5},
	[194] = {8, 8, 8},
	[195] = {7.5, 7.5, 9},
	[196] = {8.5, 8, 7.5},
	[197] = {7.5, 8, 8.5},
	[198] = {8, 8, 8},
	[199] = {8, 8, 8},
	[200] = {8, 7, 9},
	[201] = {8, 8, 8},
	[202] = {8, 8, 8},
	[203] = {8, 7, 9},
	[204] = {8, 8, 8},
	[205] = {8, 8, 8},
	[206] = {8.5, 8.5, 7},
	[207] = {8, 8, 8},
	[209] = {8, 8, 8},
	[210] = {8, 8, 8},
	[211] = {8.5, 8, 7.5},
	[212] = {8, 8, 8},
	[213] = {8, 8, 8},
	[214] = {8, 8, 8},
	[215] = {8.5, 7.5, 8},
	[216] = {8, 8, 8},
	[217] = {8, 8, 8},
	[218] = {8.5, 7.5, 8},
	[220] = {8, 8, 8},
	[224] = {7, 8.5, 8.5},
	[225] = {8, 8, 8},
	[226] = {8, 8, 8},
	[227] = {8, 8, 8},
	[228] = {8, 8, 8},
	[229] = {8, 8, 8},
	[231] = {8.5, 8, 7.5},
	[232] = {7, 8.5, 8.5},
	[233] = {7, 8.5, 8.5},
	[234] = {7, 8.5, 8.5},
	[235] = {7, 8.5, 8.5},
	[236] = {7.5, 8.5, 8},
	[237] = {7, 8.5, 8.5},
	[238] = {7, 8.5, 8.5},
	[239] = {8, 8, 8},
	[240] = {8.5, 8.5, 7},
	[241] = {8, 8, 8},
	[242] = {7.5, 8.5, 8},
	[243] = {9, 9, 6},
	[244] = {8.5, 9, 6.5},
	[245] = {8, 8, 8},
	[246] = {8, 8, 8},
	[247] = {8, 8, 8},
	[248] = {8, 8, 8},
	[249] = {8.5, 8.5, 7},
	[250] = {7.5, 9, 7.5},
	[251] = {8.5, 8.5, 7},
	[253] = {8, 8, 8},
	[254] = {8, 8, 8},
	[255] = {7.5, 9, 7.5},
	[256] = {8, 9, 7},
	[257] = {8, 8, 8},
	[258] = {8.5, 9, 6.5},
	[259] = {8.5, 7.5, 8},
	[260] = {8, 8.5, 7.5},
	[261] = {8.5, 7.5, 8},
	[262] = {8.5, 7.5, 8},
	[264] = {8.5, 8.5, 7},
	[265] = {9.5, 8, 6.5},
	[266] = {8.5, 8.5, 7},
	[267] = {8, 8, 8},
	[268] = {8.5, 9, 6.5},
	[270] = {8.5, 8.5, 7},
	[271] = {8, 7.5, 8.5},
	[272] = {9, 7.5, 7.5},
	[277] = {8.5, 7.5, 8},
	[278] = {8, 8, 8},
	[279] = {8, 8, 8},
	[280] = {8, 8, 8},
	[281] = {8, 8, 8},
	[282] = {8, 8, 8},
	[283] = {8, 8, 8},
	[285] = {8, 9, 7},
	[286] = {9, 8, 7},
	[287] = {8, 7.5, 8.5},
	[289] = {9.5, 8.5, 6},
	[291] = {9, 7.5, 7.5},
	[292] = {8, 8, 8},
	[293] = {8, 8, 8},
	[294] = {8, 8, 8},
	[296] = {8, 8, 8},
	[297] = {8, 9.5, 6.5},
	[298] = {8, 8, 8},
	[301] = {7, 8.5, 8.5},
	[302] = {8.5, 8.5, 7},
	[303] = {7, 8.5, 8.5},
	[306] = {7, 8.5, 8.5},
	[307] = {8, 8, 8},
	[308] = {8, 8, 8},
	[309] = {6.5, 9, 8.5},
	[310] = {8, 8, 8},
	[311] = {8.5, 8, 7.5},
	[316] = {8.5, 7.5, 8},
	[317] = {8.5, 8.5, 7},
	[318] = {7.5, 8.5, 8},
	[319] = {6.5, 9, 8.5},
	[320] = {8.5, 7.5, 8},
	[321] = {8, 8, 8},
	[323] = {8, 8, 8},
	[325] = {7.5, 9, 7.5},
	[328] = {8, 8, 8},
	[329] = {8, 8, 8},
	[330] = {8, 8, 8},
	[331] = {8, 8, 8},
	[332] = {8, 8, 8},
	[333] = {8, 8, 8},
	[335] = {9, 7.5, 7.5},
	[336] = {8, 8, 8},
	[337] = {8, 8, 8},
	[338] = {8.5, 7.5, 8},
	[339] = {8, 8, 8},
	[340] = {8, 8, 8},
	[341] = {8, 8, 8},
	[342] = {8, 8, 8},
	[343] = {7, 8.5, 8.5},
	[344] = {8.5, 8, 7.5},
	[345] = {8, 8.5, 7.5},
	[346] = {8, 8, 8},
	[347] = {8, 8.75, 7.25},
	[348] = {8.5, 8.5, 7},
	[354] = {8, 8, 8},
	[374] = {8, 8, 8},
	[375] = {8, 8, 8},
	[378] = {8, 7, 9},
	[379] = {8, 7.5, 8.5},
	[380] = {8, 8, 8},
	[381] = {8, 8, 8},
	[382] = {8, 8, 8},
	[383] = {8, 7.5, 8.5},
	[384] = {8, 8, 8},
	[385] = {8, 7.5, 8.5},
	[386] = {8, 7.5, 8.5},
	[387] = {7.5, 8, 8.5},
	[388] = {8.5, 8, 7.5},
	[389] = {8.5, 7.5, 8},
	[390] = {8, 7.5, 8.5},
	[391] = {8, 7, 9},
	[392] = {8, 7.5, 8.5},
	[393] = {8.5, 7, 8.5},
	[394] = {8, 8, 8},
	[395] = {8.5, 8, 7.5},
	[396] = {7, 8.5, 8.5},
	[397] = {8, 8, 8},
	[398] = {8, 7.5, 8.5},
	[399] = {7.5, 8, 8.5},
	[400] = {7, 8.5, 8.5},
	[401] = {8.5, 8, 7.5},
	[402] = {8.5, 8, 7.5},
	[403] = {7.5, 8, 8.5},
	[404] = {8, 7.5, 8.5},
	[405] = {7.5, 8, 8.5},
	[406] = {8.5, 7.5, 8},
	[407] = {7, 8.5, 8.5},
	[408] = {7.5, 8, 8.5},
	[409] = {7, 8, 9},
	[410] = {8, 7.5, 8.5},
	[411] = {8, 8, 8},
	[412] = {7, 8.5, 8.5},
	[414] = {8, 8, 8},
	[415] = {7.5, 8.5, 8},
	[416] = {8, 8, 8},
	[417] = {8, 7.5, 8.5},
	[418] = {7.5, 8, 8.5},
	[419] = {8.5, 7.5, 8},
	[420] = {8.5, 7.5, 8},
	[421] = {8, 8.5, 7.5},
	[422] = {7.5, 8.5, 8},
	[423] = {8.5, 8.5, 7},
	[424] = {8.5, 7, 8.5},
	[425] = {7.5, 8, 8.5},
	[427] = {7, 8.5, 8.5},
	[428] = {7, 8.5, 8.5},
	[429] = {7.5, 8.5, 8},
	[430] = {8, 8.5, 7.5},
	[431] = {7.5, 8, 8.5},
	[432] = {8, 8, 8},
	[433] = {7.5, 8, 8.5},
	[434] = {8, 8, 8},
	[437] = {8, 8, 8},
	[438] = {7.5, 8, 8.5},
	[439] = {8.5, 8, 7.5},
	[440] = {8, 8, 8},
	[441] = {8, 7, 9},
	[442] = {9, 6.5, 8.5},
	[443] = {8, 8, 8},
	[444] = {8, 8, 8},
	[445] = {8, 8, 8},
	[446] = {8.5, 8, 7.5},
	[447] = {8, 7.5, 8.5},
	[448] = {8, 7, 9},
	[449] = {8, 8, 8},
	[450] = {9, 8, 7},
	[452] = {8, 8, 8},
	[453] = {9, 8, 7},
	[454] = {8, 7.5, 8.5},
	[455] = {8, 8, 8},
	[456] = {8, 8.5, 7.5},
	[457] = {9, 8, 7},
	[458] = {8.5, 8.5, 7},
	[459] = {7, 8.5, 8.5},
	[460] = {7.5, 8.5, 8},
	[461] = {9, 8, 7},
	[462] = {8, 8, 8},
	[463] = {9, 9, 6},
	[464] = {8, 8, 8},
	[465] = {7, 8.5, 8.5},
	[466] = {7.5, 8, 8.5},
	[467] = {7.5, 8.5, 8},
	[468] = {7.5, 8.5, 8},
	[469] = {7, 8.5, 8.5},
	[470] = {7, 8.5, 8.5},
	[471] = {8.5, 7.5, 8},
	[472] = {8.5, 7.5, 8},
	[473] = {9, 7.5, 7.5},
	[474] = {6, 8, 10},
	[475] = {8.5, 7, 8.5},
	[476] = {7.5, 7.5, 9},
	[477] = {7.5, 7.5, 9},
	[478] = {8.5, 8, 7.5},
	[479] = {8, 6.5, 9.5},
	[480] = {8, 8.5, 7.5},
	[482] = {7.5, 8, 8.5},
	[483] = {8.5, 7.5, 8},
	[484] = {7, 8.5, 8.5},
	[485] = {9, 7.5, 7.5},
	[486] = {8, 7.5, 8.5},
	[487] = {8, 8, 8},
	[488] = {7.5, 8, 8.5},
	[489] = {8, 8.5, 7.5},
	[491] = {7, 9, 8},
	[492] = {8, 8.5, 7.5},
	[493] = {9.5, 8.5, 6},
	[494] = {8, 8, 8},
	[495] = {8.5, 7.5, 8},
	[496] = {9.5, 8.5, 6},
	[497] = {8.5, 7, 8.5},
	[498] = {8.5, 8, 7.5},
	[499] = {8, 7.5, 8.5},
	[500] = {8, 8, 8},
	[502] = {8.5, 7.5, 8},
	[503] = {7.5, 7.5, 9},
	[504] = {8, 8.5, 7.5},
	[505] = {7.5, 8, 8.5},
	[506] = {7, 8.5, 8.5},
	[507] = {7.5, 8.5, 8},
	[508] = {8, 8, 8},
	[509] = {8, 8, 8},
	[510] = {8.5, 7.5, 8},
	[511] = {7.5, 8, 8.5},
	[512] = {7.5, 8.5, 8},
	[513] = {8, 8, 8},
	[514] = {8, 8, 8},
	[515] = {8, 8, 8},
	[517] = {8, 8, 8},
	[518] = {9, 8.5, 6.5},
	[519] = {8.5, 8, 7.5},
	[521] = {7, 9, 8},
	[523] = {9, 8, 7},
	[525] = {8, 8, 8},
	[528] = {7.5, 8, 8.5},
	[529] = {8, 8, 8},
	[530] = {8, 8, 8},
	[532] = {8.5, 9, 6.5},
	[534] = {7.5, 8.5, 8},
	[535] = {8, 8, 8},
	[536] = {8.5, 8, 7.5},
	[537] = {8.5, 8, 7.5},
	[538] = {8.5, 8.5, 7},
	[539] = {8, 7.5, 8.5},
	[540] = {8, 7.5, 8.5},
	[541] = {8.5, 7, 8.5},
	[542] = {8.5, 7.5, 8},
	[543] = {7.5, 8.5, 8},
	[544] = {8.5, 8.5, 7},
	[545] = {8, 8, 8},
	[546] = {7.5, 8.5, 8},
	[547] = {8, 7, 9},
	[548] = {7.5, 8.5, 8},
	[549] = {8, 8, 8},
	[550] = {8, 7.5, 8.5},
	[552] = {7.5, 8.5, 8},
	[553] = {8, 7.5, 8.5},
	[554] = {7.5, 8.5, 8},
	[555] = {8.5, 7, 8.5},
	[556] = {7.5, 8.5, 8},
	[557] = {7.5, 8.5, 8},
	[558] = {8, 8, 8},
	[559] = {7.5, 9, 7.5},
	[560] = {8.5, 7.5, 8},
	[562] = {7.5, 8, 8.5},
	[564] = {9.5, 7.5, 7},
	[565] = {8.5, 7.5, 8},
	[566] = {7.5, 7.5, 9},
	[567] = {7.5, 8, 8.5},
	[568] = {9.5, 8.5, 6},
	[569] = {8.5, 7.5, 8},
	[570] = {8, 8, 8},
	[571] = {7.5, 8, 8.5},
	[572] = {8.5, 8, 7.5},
	[573] = {9, 7, 8},
	[626] = {7.5, 8, 8.5},
	[627] = {8.5, 8.5, 7},
	[628] = {8.5, 8, 7.5},
	[629] = {8.5, 8, 7.5},
	[630] = {8, 8, 8},
	[631] = {7.5, 8, 8.5},
	[632] = {7.5, 8, 8.5},
	[633] = {8, 8, 8},
	[634] = {7, 8.5, 8.5},
	[635] = {7.5, 8, 8.5},
	[637] = {8, 8, 8},
	[638] = {8.5, 7, 8.5},
	[639] = {8, 7.5, 8.5},
	[640] = {8, 7, 9},
	[641] = {8, 7, 9},
	[644] = {8, 7.5, 8.5},
	[645] = {8, 8, 8},
	[646] = {8, 8, 8},
	[647] = {8, 8, 8},
	[648] = {9, 7.5, 7.5},
	[649] = {9, 7.5, 7.5},
	[650] = {8.5, 8, 7.5},
	[652] = {8, 8, 8},
	[665] = {7.5, 8.5, 8},
	[666] = {8, 8, 8},
	[671] = {8, 8, 8},
	[675] = {8, 7.5, 8.5},
	[677] = {8, 8, 8},
	[678] = {8, 8, 8},
	[679] = {8, 8, 8},
	[680] = {8, 8, 8},
	[699] = {7, 8.5, 8.5},
	[702] = {8.5, 7.5, 8},
	[703] = {8, 8, 8},
	[705] = {8, 8.5, 7.5},
	[706] = {8, 8, 8},
	[707] = {8, 8, 8},
	[708] = {8, 7.5, 8.5},
	[709] = {8, 7.5, 8.5},
	[710] = {8, 8, 8},
	[711] = {8, 8, 8},
	[712] = {8, 8, 8},
	[713] = {9, 7.5, 7.5},
	[714] = {7, 8.5, 8.5},
	[715] = {8, 8, 8},
	[716] = {7, 8.5, 8.5},
	[717] = {7.5, 8.5, 8},
	[718] = {8, 8, 8},
	[722] = {7.5, 8.5, 8},
	[723] = {9, 7.5, 7.5},
	[724] = {8, 8, 8},
	[725] = {8, 8, 8},
	[726] = {7, 8.5, 8.5},
	[727] = {8, 8, 8},
	[728] = {8, 8, 8},
	[729] = {8, 7, 9},
	[730] = {8, 7, 9},
	[731] = {7, 8.5, 8.5},
	[732] = {8, 8.5, 7.5},
	[733] = {8, 8, 8},
	[737] = {6.5, 8, 9.5},
	[739] = {7, 8, 9},
	[740] = {8, 7.5, 8.5},
	[741] = {8, 8, 8},
	[742] = {8, 8, 8},
	[743] = {9.5, 8.5, 6},
	[744] = {8.5, 7, 8.5},
	[745] = {8, 8, 8},
	[746] = {8.5, 9, 6.5},
	[747] = {7.5, 8.5, 8},
	[748] = {8, 8.5, 7.5},
	[749] = {8, 8, 8},
	[750] = {8, 8, 8},
	[751] = {8, 7.5, 8.5},
	[752] = {9, 7.5, 7.5},
	[753] = {7.5, 8.5, 8},
	[754] = {8, 8, 8},
	[755] = {9, 6.5, 8.5},
	[756] = {8.5, 7, 8.5},
	[757] = {8.5, 8, 7.5},
	[758] = {7.5, 8.5, 8},
	[792] = {8, 8.5, 7.5},
	[800] = {8, 8, 8},
	[802] = {8.5, 8.5, 7},
	[817] = {8.5, 8, 7.5},
	[818] = {8, 8.5, 7.5},
	[819] = {7.5, 8.5, 8},
	[820] = {8, 8, 8},
	[821] = {8, 8, 8},
	[823] = {8, 8, 8},
	[824] = {8, 8, 8},
	[825] = {8, 8, 8},
	[826] = {8, 8, 8},
	[827] = {8, 8, 8},
	[828] = {8, 8, 8},
	[829] = {8, 8, 8},
	[830] = {8, 8, 8},
	[831] = {8, 8, 8},
	[832] = {8, 8, 8},
	[833] = {8, 8, 8},
	[834] = {8.5, 8, 7.5},
	[835] = {8, 8, 8},
	[836] = {7.5, 7, 9.5},
	[837] = {8.5, 8, 7.5},
	[838] = {8, 8, 8},
	[844] = {8, 8.5, 7.5},
	[845] = {8, 8, 8},
	[846] = {6, 8, 10},
	[847] = {8, 8, 8},
	[848] = {8, 7, 9},
	[849] = {8, 8, 8},
	[850] = {8, 8, 8},
	[851] = {7.5, 8, 8.5},
	[855] = {7.5, 8.5, 8},
	[856] = {8, 8, 8},
	[868] = {8, 8, 8},
	[872] = {8, 8, 8},
	[873] = {8, 8, 8},
	[874] = {8, 8, 8},
	[875] = {8, 8, 8},
	[876] = {8, 8, 8},
	[877] = {8, 8, 8},
	[878] = {8, 8, 8},
	[879] = {8, 8, 8},
	[880] = {8, 8, 8},
	[881] = {8, 8, 8},
	[882] = {8, 8, 8},
	[883] = {8, 8, 8},
	[884] = {8, 8, 8},
	[885] = {8, 8, 8},
	[886] = {8, 8, 8},
	[887] = {8, 8, 8},
	[888] = {8, 8, 8},
	[889] = {8, 8, 8},
	[890] = {8, 8, 8},
	[891] = {8, 8, 8},
	[892] = {8, 8, 8},
	[893] = {8, 8, 8},
	[894] = {8, 8, 8},
	[895] = {8, 8, 8},
	[896] = {8, 8, 8},
	[897] = {8, 8, 8},
	[898] = {8, 8, 8},
	[899] = {8, 8, 8},
	[900] = {8, 8, 8},
	[901] = {8, 8, 8},
	[902] = {8, 8, 8},
	[903] = {7.5, 9, 7.5},
	[904] = {8, 8, 8},
	[905] = {8, 8, 8},
	[906] = {8, 8, 8},
	[907] = {8, 8, 8},
	[908] = {8, 8, 8},
	[909] = {8, 8, 8},
	[911] = {8, 8.5, 7.5},
	[912] = {8, 8.5, 7.5},
	[913] = {8, 8.5, 7.5},
	[915] = {8, 8, 8},
	[916] = {8, 8, 8},
	[917] = {8, 8, 8},
	[921] = {8, 8, 8},
	[922] = {8, 8, 8},
	[923] = {8.5, 7.5, 8},
	[924] = {8, 8, 8},
	[925] = {8, 8, 8},
	[926] = {8, 8, 8},
	[927] = {8, 8, 8},
	[928] = {8, 8, 8},
	[929] = {8, 8, 8},
	[931] = {8, 8, 8},
	[932] = {8, 8, 8},
	[933] = {8, 8, 8},
	[934] = {8, 8, 8},
	[935] = {8, 8, 8},
	[936] = {8, 8, 8},
	[937] = {8, 8, 8},
	[938] = {8, 8, 8},
	[939] = {8, 8, 8},
	[941] = {8, 8, 8},
	[942] = {8, 8, 8},
	[943] = {8, 8, 8},
	[944] = {8, 8, 8},
	[945] = {8, 8, 8},
	[946] = {8, 8, 8},
	[947] = {8, 8, 8},
	[948] = {8, 8, 8},
	[949] = {8, 8, 8},
	[950] = {8, 8, 8},
	[951] = {8, 8, 8},
	[952] = {8, 8, 8},
	[953] = {8, 8, 8},
	[954] = {8, 8, 8},
	[955] = {8, 8, 8},
	[956] = {8, 8, 8},
	[957] = {8, 8, 8},
	[958] = {8, 8, 8},
	[959] = {8, 8, 8},
	[960] = {8, 8, 8},
	[961] = {8, 8, 8},
	[962] = {8, 8, 8},
	[963] = {8, 8, 8},
	[964] = {8, 8, 8},
	[965] = {8, 8, 8},
	[966] = {8, 8, 8},
	[967] = {8, 8, 8},
	[968] = {8, 8, 8},
	[969] = {8, 8, 8},
	[970] = {8, 8, 8},
	[971] = {8, 8, 8},
	[972] = {8, 8, 8},
	[973] = {8, 8, 8},
	[974] = {8, 8, 8},
	[975] = {8, 8, 8},
	[976] = {8, 8, 8},
	[977] = {8, 8, 8},
	[978] = {8, 8, 8},
	[979] = {8, 8, 8},
	[980] = {8, 8, 8},
	[981] = {8, 8, 8},
	[982] = {8, 8, 8},
	[983] = {8, 8, 8},
	[984] = {8, 8, 8},
	[985] = {8, 8, 8},
	[986] = {8, 8, 8},
	[987] = {8, 8, 8},
	[988] = {8, 8, 8},
	[989] = {8, 8, 8},
	[990] = {8, 8, 8},
	[991] = {8, 8, 8},
	[992] = {8, 8, 8},
	[993] = {8, 8, 8},
	[994] = {8, 8, 8},
	[995] = {8, 8, 8},
	[996] = {8, 8, 8},
	[997] = {8, 8, 8},
	[998] = {8, 8, 8},
	[999] = {8, 8, 8},
	[1000] = {8, 8, 8},
	[1001] = {8, 8, 8},
	[1002] = {8, 8, 8},
	[1003] = {8, 8, 8},
	[1004] = {8, 8, 8},
	[1005] = {8, 8, 8},
	[1006] = {8, 8, 8},
	[1007] = {8, 8, 8},
	[1008] = {8, 8, 8},
	[1009] = {8, 8, 8},
	[1010] = {8, 8, 8},
	[1011] = {8, 8, 8},
	[1012] = {8, 8, 8},
	[1013] = {9, 7.5, 7.5},
	[1039] = {7.5, 7.5, 9},
	[1040] = {8, 8, 8},
	[1042] = {6.75, 10.5, 6.75},
	[1061] = {8, 8, 8},
	[1062] = {8, 7.5, 8.5},
	[1063] = {8.5, 8.5, 7},
	[1065] = {8.5, 8.5, 7},
	[1066] = {8, 8, 8},
	[1067] = {8.5, 7.5, 8},
	[1068] = {8, 8, 8},
	[1073] = {8, 8, 8},
	[1117] = {7.5, 8.5, 8.5},
	[1124] = {8, 8, 8},
	[1125] = {8, 8, 8},
	[1126] = {8, 8, 8},
	[1127] = {7.5, 8.5, 8},
	[1128] = {8, 8, 8},
	[1129] = {11.5, 15.5, 7.5},
	[1130] = {8, 8, 8},
	[1131] = {8, 8, 8},
	[1132] = {8, 8, 8},
	[1133] = {8, 8, 8},
	[1134] = {8, 8, 8},
	[1135] = {8, 8, 8},
	[1136] = {8, 8, 8},
	[1137] = {8, 8, 8},
	[1138] = {8, 8, 8},
	[1139] = {8, 8, 8},
	[1140] = {8, 8, 8},
	[1141] = {8, 8, 8},
	[1142] = {8.5, 7.5, 8},
	[1143] = {8, 8, 8},
	[1144] = {8, 8, 8},
	[1145] = {8, 8, 8},
	[1146] = {8, 8, 8},
	[1147] = {8, 8, 8},
	[1149] = {8, 8, 8},
	[1150] = {8, 8, 8},
	[1151] = {8, 8, 8},
	[1152] = {7.5, 8.5, 8},
	[1153] = {8, 8, 8},
	[1154] = {8, 8, 8},
	[1155] = {8, 8.5, 7.5},
	[1156] = {8, 8, 8},
	[1157] = {8, 8, 8},
	[1158] = {8, 8, 8},
	[1159] = {7.5, 8.5, 8},
	[1160] = {8.5, 8, 7.5},
	[1161] = {8, 8.5, 7.5},
	[1162] = {7, 9, 8},
	[1163] = {9, 8, 7},
	[1164] = {7.5, 8, 8.5},
	[1165] = {8, 8.5, 7.5},
	[1166] = {8, 8.5, 7.5},
	[1167] = {8, 8.5, 7.5},
	[1168] = {8, 8, 8},
	[1174] = {7.5, 8.5, 8},
	[1175] = {8, 8, 8},
	[1176] = {8, 8, 8},
	[1177] = {9, 8, 7},
	[1178] = {8, 8, 8},
	[1179] = {8, 8.5, 7.5},
	[1180] = {7, 8.5, 8.5},
	[1181] = {7.5, 8, 8.5},
	[1182] = {8.5, 7.5, 8},
	[1183] = {8, 8, 8},
	[1184] = {8.25, 8, 7.75},
	[1185] = {8, 8, 8},
	[1187] = {11.625, 15.375, 7.625},
	[1188] = {11.375, 15.125, 7.75},
	[1189] = {11.875, 16, 7.25},
	[1190] = {11.125, 14.25, 7.875},
	[1191] = {12, 15.75, 7},
	[1192] = {11.625, 15, 7.375},
	[1193] = {11, 14.5, 7.5},
	[1194] = {11.25, 15.25, 7.875},
	[1195] = {11, 15, 8},
	[1196] = {8, 8, 8},
	[1197] = {8, 8, 8},
	[1198] = {8, 8, 8},
	[1200] = {8.25, 8, 7.75},
	[1201] = {7, 8.5, 8.5},
	[1202] = {8, 7.5, 8.5},
	[1204] = {8.5, 7.5, 8},
	[1205] = {8.25, 8, 7.75},
	[1206] = {7.5, 8, 8.5},
	[1207] = {7.5, 8.5, 8.5},
	[1208] = {7.5, 8, 8.5},
	[1209] = {7.5, 8, 8.5},
	[1211] = {7, 8.5, 8.5},
	[1212] = {7, 8.5, 8.5},
	[1213] = {7, 8.5, 8.5},
	[1226] = {7.5, 8.5, 8},
	[1227] = {8.5, 8, 7.5},
	[1228] = {8, 8.25, 7.75},
	[1229] = {7.75, 8, 8.25},
	[1230] = {8.25, 8.25, 7.5},
	[1231] = {8, 8, 8},
	[1232] = {7.75, 8.25, 8},
	[1233] = {8.25, 8.5, 7.25},
	[1234] = {8.25, 8, 7.75},
	[1235] = {8, 8, 8},
	[1236] = {7.5, 8.25, 8.25},
	[1237] = {8, 8.25, 7.75},
	[1238] = {8.5, 8.5, 7},
	[1243] = {8, 8, 8},
	[1244] = {8, 8, 8},
	[1245] = {8, 8, 8},
	[1247] = {11, 16, 7},
	[1248] = {8.25, 8, 7.75},
	[1255] = {8, 8, 8},
	[1256] = {8, 8, 8},
	[1257] = {8, 8, 8},
	[1258] = {8, 9, 7},
	[1259] = {9, 8, 8},
	[1266] = {8, 8.25, 7.75},
	[1267] = {11.25, 15.25, 7},
	[1268] = {9, 8.375, 6.625},
	[1269] = {8, 9.25, 6.75},
	[1271] = {8, 7.5, 8.5},
	[1276] = {8, 8, 8},
	[1277] = {8.5, 8, 7.5},
	[1278] = {8, 8.25, 7.25},
	[1279] = {8.5, 8, 7.5},
	[1280] = {8.5, 8, 7.5},
	[1281] = {8, 8.5, 8},
	[1282] = {8, 9.25, 6.75},
	[1283] = {8, 9.5, 6.5},
	[1284] = {9.25, 8, 6.75},
	[1285] = {8, 7.5, 8.5},
	[1286] = {7.875, 7.875, 8.25},
	[1287] = {8, 9, 7.25},
	[1288] = {9.5, 8, 6.5},
	[1289] = {8, 9.5, 7},
	[1290] = {8.25, 8, 7.75},
	[1291] = {9.5, 8, 6.5},
	[1292] = {8, 8, 6.75},
	[1293] = {8, 7.5, 8},
	[1295] = {8, 8.75, 7},
	[1296] = {9.25, 8, 7},
	[1297] = {8, 8, 8.25},
	[1298] = {8, 8, 8},
	[1299] = {8, 8, 8},
	[1300] = {8, 8, 8},
	[1301] = {8, 8, 8},
	[1303] = {8.25, 8.25, 7.5},
	[1304] = {7, 8.5, 8.5},
	[1305] = {8.5, 8, 7.5},
	[1311] = {11.25, 15.25, 7.375},
	[1317] = {11.25, 15.25, 6.75},
	[1319] = {11.25, 15.25, 7.35},
	[1320] = {8, 8, 8},
	[1321] = {8, 8.5, 7.5},
	[1322] = {8.5, 8.5, 7},
	[1323] = {7.5, 8.25, 8.25},
	[1324] = {8, 8, 8},
	[1325] = {8, 8, 8},
	[1326] = {8, 8, 8},
	[1328] = {8, 8, 8},
	[1329] = {8, 8, 8},
	[1330] = {7.5, 8, 8.5},
	[1331] = {8, 8, 8},
	[1332] = {8, 8, 8},
	[1333] = {7.75, 8.5, 7.75},
	[1334] = {7.5, 8, 8.5},
	[1335] = {8, 8, 8},
	[1336] = {8, 8, 8},
	[1337] = {7.5, 9, 7.5},
	[1338] = {8.5, 7.5, 8},
	[1339] = {13, 19.5, 5},
	[1343] = {8, 8, 8},
	[1344] = {8.25, 8, 7.75},
	[1345] = {8, 8, 8},
	[1346] = {8, 8, 8},
	[1348] = {8, 8, 8},
	[1349] = {7.75, 8.25, 8},
	[1350] = {8, 8, 8},
	[1351] = {8, 8, 8},
	[1352] = {48, 8, 6.5},
	[1354] = {12, 15.25, 7.35},
	[1363] = {8, 8, 8},
	[1364] = {8.3, 7.9, 7.8},
	[1365] = {8, 8, 8},
	[1384] = {8, 8.75, 7.25},
	[1385] = {8, 8, 8},
	[1386] = {8.125, 8.375, 7.5},
	[1387] = {8, 8.5, 7.5},
	[1394] = {8.5, 8, 7.5},
	[1395] = {8, 8, 8},
	[1396] = {8.5, 8, 7.5},
	[1400] = {6.5, 9, 8.5},
	[1401] = {7, 9, 8},
	[1402] = {8, 7.25, 8.75},
	[1403] = {8, 8, 8},
	[1409] = {23, 8, 6.25},
	[1410] = {13.32, 7.5, 7.5},
	[1411] = {8, 8, 8},
	[1412] = {8, 8, 8},
	[1416] = {8, 8, 8},
	[1420] = {9, 8, 8},
	[1423] = {7, 8.5, 8.5},
	[1424] = {8, 8, 7.5},
	[1426] = {13, 8, 5.5},
	[1427] = {7.625, 7.875, 8.5},
	[1428] = {8, 8, 8},
	[1429] = {8, 8, 8},
	[1430] = {8, 8, 8},
	[1431] = {8, 8, 8},
	[1432] = {8, 8, 8},
	[1433] = {8, 8, 8},
	[1434] = {8, 8, 8},
	[1435] = {9, 8.5, 6.5},
	[1441] = {8.5, 7.5, 8},
	[1442] = {8, 8, 8},
	[1443] = {8, 8, 7.25},
	[1444] = {8, 8, 7.5},
	[1446] = {8, 8, 8},
	[1447] = {8, 8, 8},
	[1448] = {8, 8, 8},
	[1449] = {8, 8, 8},
	[1450] = {8, 8, 8},
	[1451] = {8, 8, 8},
	[1453] = {8, 8, 8},
	[1454] = {8, 8, 8},
	[1455] = {8, 8, 8},
	[1456] = {8, 8, 8},
	[1457] = {8, 8, 8},
	[1458] = {8, 8, 8},
	[1462] = {8, 8, 8},
	[1463] = {8, 8, 8},
	[1464] = {8, 8, 8},
	[1465] = {8, 8, 8},
	[1466] = {8, 8, 8},
	[1467] = {8, 8, 8},
	[1468] = {7.625, 8.25, 8.125},
	[1469] = {7.625, 8.25, 8.125},
	[1470] = {7.625, 8.25, 8.125},
	[1471] = {8, 8, 8},
	[1472] = {7.5, 8, 8.5},
	[1473] = {8.75, 8, 7.25},
	[1474] = {8.625, 8, 7.375},
	[1475] = {8, 8, 7.5},
	[1476] = {8, 8, 7.5},
	[1477] = {8, 8, 7.5},
	[1478] = {8, 8, 8},
	[1479] = {13.625, 7.5, 9},
	[1480] = {23.5, 8, 7.375},
	[1482] = {14.25, 8, 7},
	[1483] = {6, 10, 8},
	[1484] = {8, 8, 8},
	[1485] = {8, 8, 8},
	[1486] = {23, 8, 5.5},
	[1487] = {16, 8.25, 7.25},
	[1488] = {16, 8, 7.5},
	[1489] = {15.5, 9.25, 6.75},
	[1490] = {14.25, 9.25, 8},
	[1492] = {9, 8, 7},
	[1493] = {8, 8, 8},
	[1494] = {8, 8, 8},
	[1495] = {7.75, 7.75, 8.5},
	[1496] = {8, 8, 8},
	[1497] = {7.625, 8.25, 8.125},
	[1498] = {7.5, 9, 7.5},
	[1499] = {13.5, 9, 7},
	[1500] = {13.5, 7.5, 8.5},
	[1501] = {10, 7, 7},
	[1502] = {8, 8, 7.5},
	[1503] = {8.5, 8.5, 7},
	[1504] = {7.25, 7.25, 9.25},
	[1505] = {7.25, 8.75, 8},
	[1506] = {7.25, 8.75, 8},
	[1507] = {23, 10, 6},
	[1508] = {8.5, 7.5, 8},
	[1509] = {8, 8.75, 6.75},
	[1510] = {8.5, 8.5, 7},
	[1511] = {8, 8, 8},
	[1514] = {8, 8, 8},
	[1515] = {8, 8, 8},
	[1516] = {8, 8, 8},
	[1517] = {8, 8.5, 7.5},
	[1518] = {8, 8.5, 7.5},
	[1519] = {9.5, 9.75, 9.75},
	[1521] = {8, 8, 8},
	[1523] = {8, 8, 8},
	[1524] = {8, 8, 8},
	[1530] = {8, 8, 8},
	[1531] = {8.5, 7, 8.5},
	[1532] = {7.5, 9, 7.5},
	[1533] = {8.5, 9, 6.5},
	[1536] = {8, 8, 8},
	[1537] = {8, 8, 8},
	[1538] = {8, 8, 8},
	[1539] = {8, 8, 8},
	[1540] = {8, 8, 8},
	[1541] = {8, 8, 8},
	[1542] = {8, 8, 8},
	[1543] = {9, 8, 7},
	[1544] = {8, 8, 8},
	[1545] = {8, 8, 8},
	[1546] = {8, 8, 8},
	[1547] = {8, 8, 8},
	[1548] = {9.5, 8, 6.5},
	[1549] = {7.25, 9.25, 7.5},
	[1550] = {8, 8, 8},
	[1552] = {8, 8, 8},
	[1553] = {8, 8, 8},
	[1554] = {8, 8, 8},
	[1555] = {8, 8, 8},
	[1556] = {9.25, 9.25, 5.5},
	[1557] = {8, 8, 8},
	[1558] = {8, 8, 8},
	[1559] = {8, 8, 8},
	[1560] = {8, 10.75, 8},
	[1561] = {8, 9.5, 8},
	[1562] = {8, 10, 8},
	[1563] = {8, 8, 8},
	[1564] = {8, 8, 8},
	[1565] = {8, 8, 8},
	[1566] = {8, 8, 8},
	[1567] = {7.5, 8.5, 8},
	[1568] = {8, 8, 8},
	[1569] = {9.75, 7.25, 7},
	[1570] = {7.5, 9, 7.5},
	[1571] = {8, 8, 8},
	[1572] = {8, 8, 8},
	[1573] = {8, 8, 8},
	[1574] = {7.5, 9.5, 7},
	[1575] = {7, 9, 8},
	[1576] = {6.75, 9.25, 8},
	[1577] = {8, 8, 8},
	[1578] = {7.5, 9, 7.5},
	[1579] = {7.5, 9, 7.5},
	[1581] = {7.5, 9, 7.5},
	[1582] = {7.5, 9, 7.5},
	[1583] = {7.5, 9, 7.5},
	[1586] = {8, 8, 8},
	[1587] = {8, 8, 8},
	[1588] = {8, 8, 8},
	[1589] = {8, 8, 8},
	[1590] = {8, 7.5, 8.5},
	[1591] = {8, 7.5, 8.5},
	[1592] = {8, 7.5, 8.5},
	[1593] = {8, 7.5, 8.5},
	[1594] = {8, 8, 8},
	[1595] = {8, 8, 8},
	[1596] = {7.5, 9, 7.5},
	[1597] = {7.5, 9, 7.5},
	[1598] = {9, 7.5, 7.5},
	[1599] = {9, 7.5, 7.5},
	[1600] = {7.5, 9.5, 7},
	[1601] = {6.75, 9.25, 8},
	[1602] = {6.75, 9.25, 8},
	[1603] = {7, 8, 9},
	[1604] = {8, 8, 8},
	[1605] = {8, 9.5, 6.5},
	[1607] = {8.625, 8, 7.375},
	[1608] = {8.75, 8, 7.25},
	[1609] = {7.5, 8, 8.5},
	[1610] = {8.5, 8.5, 7},
	[1615] = {7.5, 8, 8.5},
	[1622] = {8.5, 8, 7.5},
	[1623] = {8, 8, 8},
	[1624] = {8, 8, 8},
	[1625] = {8, 8, 8},
	[1626] = {8, 8, 8},
	[1627] = {8, 8, 8},
	[1628] = {8, 8, 8},
	[1629] = {8, 8, 8},
	[1631] = {8, 8, 8},
	[1632] = {8, 8, 8},
	[1633] = {8, 8, 8},
	[1634] = {8, 8, 8},
	[1635] = {8, 8, 8},
	[1636] = {8, 8, 8},
	[1637] = {8, 8, 8},
	[1639] = {8.25, 8.25, 7.5},
	[1640] = {9, 7.5, 7.5},
	[1641] = {8, 8, 8},
	[1642] = {8, 8, 8},
	[1643] = {8, 8, 8},
	[1644] = {8, 8, 8},
	[1645] = {8, 7.5, 8.5},
	[1646] = {8, 8, 8},
	[1647] = {7.5, 9.5, 7},
	[1648] = {8, 8, 8},
	[1649] = {9, 8.5, 6.5},
	[1651] = {8.5, 7.5, 8},
	[1652] = {7.625, 7.875, 8.5},
	[1653] = {7.625, 7.875, 8.5},
	[1654] = {7.625, 7.875, 8.5},
	[1655] = {8, 8, 8},
	[1656] = {8, 8, 8},
	[1660] = {7.5, 8.5, 8},
	[1661] = {7.75, 7.75, 8.5},
	[1662] = {7, 8.5, 8.5},
	[1663] = {8.5, 8, 7.5},
	[1664] = {7.5, 8.5, 8},
	[1665] = {8.75, 8, 7.25},
	[1666] = {8, 8, 8},
	[1671] = {11.75, 9.25, 8},
	[1672] = {8.5, 8.75, 6.75},
	[1673] = {10.5, 10.5, 8},
	[1674] = {8, 11.75, 9.25},
	[1675] = {9.25, 10.5, 9.25},
	[1676] = {9.25, 8, 11.75},
	[1677] = {10.5, 9.25, 9.25},
	[1678] = {9.25, 9.25, 10.5},
	[1679] = {8, 10.5, 10.5},
	[1680] = {11.75, 8, 9.25},
	[1681] = {10.5, 8, 10.5},
	[1682] = {9.665, 9.665, 9.665},
	[1683] = {8, 13, 8},
	[1684] = {9.25, 11.75, 8},
	[1685] = {8, 9.25, 11.75},
	[1686] = {13, 8, 8},
	[1687] = {7.75, 8.5, 7.75},
	[1688] = {8.25, 8.25, 7.5},
	[1690] = {7.25, 8.75, 8},
	[1691] = {8, 8, 8},
	[1692] = {8, 8, 8},
	[1693] = {8, 8, 8},
	[1699] = {8.5, 8, 7.5},
	[1700] = {7.5, 8.5, 8},
	[1701] = {8, 7.5, 8.5},
	[1705] = {8.5, 8, 7.5},
	[1706] = {8.5, 8, 7.5},
	[1708] = {8.5, 8.5, 7},
	[1709] = {8, 8.5, 7.5},
	[1710] = {7.5, 8, 8.5},
	[1711] = {8.25, 8.25, 7.5},
	[1712] = {8, 8, 8},
	[1713] = {8.5, 8, 7.5},
	[1714] = {8, 8, 8},
	[1715] = {8, 8.5, 7.5},
	[1716] = {8, 8, 8},
	[1717] = {8.5, 7.5, 8},
	[1718] = {7.5, 8, 8.5},
	[1719] = {7.5, 8.25, 8.25},
	[1720] = {8, 7.5, 8.5},
	[1721] = {8, 8.5, 7.5},
	[1722] = {8, 8.5, 7.5},
	[1723] = {8, 8.5, 7.5},
	[1725] = {8.25, 8.5, 7.25},
	[1726] = {7, 8.5, 8.5},
	[1727] = {7, 8.5, 8.5},
	[1728] = {7.5, 9, 7.5},
	[1729] = {8, 7, 9},
	[1730] = {8, 8, 8},
	[1731] = {7, 8.5, 8.5},
	[1734] = {8, 7.5, 8.5},
	[1735] = {8.5, 8.5, 7},
	[1736] = {7.5, 8, 8.5},
	[1737] = {8, 8, 8},
	[1738] = {8, 8, 8},
	[1739] = {8, 7.5, 8.5},
	[1740] = {8, 8, 8},
	[1741] = {8, 8, 8},
	[1742] = {10.5, 10.5, 6.75},
	[1743] = {7.75, 7.75, 8.5},
	[1744] = {8, 8, 8},
	[1745] = {7.5, 7.5, 9},
	[1746] = {7.5, 7.5, 9},
	[1748] = {7, 8.5, 8.5},
	[1749] = {7.5, 8, 8.5},
	[1750] = {8.5, 8.5, 7},
	[1751] = {9, 8.5, 6.5},
	[1752] = {7.5, 9, 7.5},
	[1753] = {7.75, 8.5, 7.75},
	[1754] = {7.75, 8.5, 7.75},
	[1755] = {7.75, 8.5, 7.75},
	[1756] = {8.5, 8, 7.5},
	[1757] = {8.5, 8, 7.5},
	[1758] = {8.5, 8, 7.5},
	[1759] = {8.5, 8, 7.5},
	[1760] = {8, 8.5, 7.5},
	[1761] = {8.5, 8.5, 7},
	[1762] = {8, 8.5, 7.5},
	[1763] = {8.5, 8, 7.5},
	[1764] = {7.625, 8.375, 8},
	[1765] = {7.625, 8.375, 8},
	[1766] = {7.625, 8.375, 8},
	[1770] = {9, 8.5, 6.5},
	[1771] = {7.5, 8, 8.5},
	[1772] = {8, 8, 8},
	[1773] = {7.625, 8.375, 8},
	[1774] = {7.625, 8.375, 8},
	[1775] = {7.5, 8.5, 8},
	[1776] = {9.5, 8.5, 6},
	[1777] = {8.25, 8.25, 7.5},
	[1778] = {8, 7, 9},
	[1780] = {8, 7, 9},
	[1781] = {7.5, 9, 7.5},
	[1782] = {8, 8.25, 7.75},
	[1787] = {8.25, 8, 7.75},
	[1788] = {8.5, 7.5, 8},
	[1789] = {9, 7.5, 7.5},
	[1790] = {8.5, 7.5, 8},
	[1791] = {8, 8, 8},
	[1792] = {8.25, 8.25, 7.5},
	[1793] = {8, 8, 8},
	[1794] = {8.5, 8.5, 7},
	[1795] = {8.3, 7.9, 7.8},
	[1796] = {8, 8.5, 7.5},
	[1797] = {8, 8.5, 7.5},
	[1798] = {8.5, 7.5, 8},
	[1799] = {8, 8, 8},
	[1800] = {8.5, 8, 7.5},
	[1801] = {8.5, 7.5, 8},
	[1802] = {8, 8, 8},
	[1803] = {8, 8, 8},
	[1804] = {7, 8.5, 8.5},
	[1805] = {8, 7.5, 8.5},
	[1806] = {8, 8, 8},
	[1807] = {7, 8.5, 8.5},
	[1808] = {7, 8.5, 8.5},
	[1809] = {7, 8.5, 8.5},
	[1810] = {7, 8.5, 8.5},
	[1811] = {8, 8, 8},
	[1815] = {13, 9.25, 8},
	[1816] = {8, 8, 5.5},
	[1817] = {8, 8, 5.5},
	[1818] = {8, 8, 5.5},
	[1828] = {7.75, 8.25, 8},
	[1840] = {9.5, 8.5, 6},
	[1841] = {9.5, 8.5, 6},
	[1842] = {9.5, 8.5, 6},
	[1843] = {11.75, 8, 8},
	[1846] = {8, 8, 8},
	[1847] = {7.75, 8, 8.25},
	[1848] = {8, 8, 8},
	[1849] = {10.5, 9.25, 8},
	[1850] = {10.5, 8, 8},
	[1851] = {7.5, 8.5, 8},
	[1852] = {8, 8, 8},
	[1853] = {9.75, 7.25, 7},
	[1855] = {11.125, 14.25, 7.875},
	[1857] = {8, 8, 8},
	[1858] = {7.5, 8.25, 8.25},
	[1859] = {8, 8, 8},
	[1860] = {9, 8.5, 8.5},
	[1861] = {8, 8.5, 7.5},
	[1862] = {7.5, 8, 8.5},
	[1863] = {7.625, 8.375, 8},
	[1864] = {7.625, 8.375, 8},
	[1865] = {7.625, 8.375, 8},
	[1866] = {8, 8, 8},
	[1867] = {8, 8, 8},
	[1868] = {8.5, 8, 8},
	[1869] = {8, 8.25, 7.75},
	[1870] = {8, 8, 8},
	[1871] = {8.5, 8.5, 7},
	[1872] = {8.5, 8.5, 7},
	[1873] = {8.5, 8, 8.5},
	[1874] = {8.5, 8.5, 8},
	[1875] = {8.5, 8, 8.5},
	[1877] = {8.5, 7.5, 8},
	[1878] = {8.5, 7.5, 8},
	[1879] = {8.5, 7.5, 8},
	[1880] = {25.5, 10.5, 6},
	[1881] = {15.5, 10.5, 8},
	[1882] = {18, 9.25, 7},
	[1883] = {18, 9, 8},
	[1884] = {8, 8, 8},
	[1885] = {7.5, 8, 8.5},
	[1886] = {8, 8.5, 7.5},
	[1887] = {8, 8, 8},
	[1888] = {8, 8, 8},
	[1889] = {8, 8, 8},
	[1890] = {8, 8, 8},
	[1891] = {15.5, 10.5, 8},
	[1892] = {8, 8, 8},
	[1893] = {8, 8, 8},
	[1894] = {8, 8, 8},
	[1895] = {10.5, 9.25, 8},
	[1896] = {10.5, 9.25, 8},
	[1897] = {7.5, 8.5, 8},
	[1898] = {8.5, 8.5, 7},
	[1899] = {8, 8, 8},
	[1903] = {9.5, 8.5, -1.375},
	[1904] = {8, 8, 8},
	[1905] = {8, 8, 8},
	[1906] = {8, 8, 8},
	[1907] = {8, 8.5, 7.5},
	[1911] = {8, 8, 8},
	[1912] = {9, 7.5, 7.5},
	[1913] = {8, 8, 8},
	[1914] = {8, 8, 8},
	[1915] = {8, 8, 8},
	[1917] = {8, 8.5, 7.5},
	[1918] = {8, 8, 8},
	[1919] = {8, 8, 8},
	[1920] = {8.5, 8.5, 7},
	[1921] = {8.25, 7.75, 8},
	[1922] = {7.75, 8, 8.25},
	[1926] = {8, 9, 7},
	[1927] = {8, 8.5, 7.5},
	[1928] = {8, 8.5, 7.5},
	[1929] = {8, 8, 8},
	[1930] = {8, 8, 8},
	[1931] = {7.5, 8.5, 8},
	[1932] = {7.5, 8.5, 8},
	[1933] = {8, 8, 8},
	[1934] = {8.5, 8, 7.5},
	[1935] = {7.75, 7.75, 8.5},
	[1936] = {7.75, 8.25, 8},
	[1937] = {8, 8, 8},
	[1938] = {8, 8.25, 7.75},
	[1939] = {8, 8, 8},
	[1940] = {8, 8, 8},
	[1941] = {7.5, 8, 8.5},
	[1943] = {8, 7.5, 8.5},
	[1949] = {8, 8, 8},
	[1952] = {8, 8, 8},
	[1953] = {8, 7.75, 8.25},
	[1954] = {8, 8, 8},
	[1955] = {7, 9, 8},
	[1956] = {8.5, 8, 7.5},
	[1957] = {9, 8, 7},
	[1958] = {8, 8, 8},
	[1959] = {9, 7.625, 7.375},
	[1960] = {8, 8, 8},
	[1961] = {8.75, 7.75, 7.5},
	[1962] = {8, 8, 8},
	[1963] = {8, 8, 8},
	[1964] = {8, 8, 8},
	[1965] = {8.25, 8.25, 7.5},
	[1966] = {8, 8, 8},
	[1967] = {7.75, 8.25, 8},
	[1968] = {7.625, 8, 8.375},
	[1969] = {8.25, 8.25, 7.5},
	[1971] = {8.25, 8.5, 8.25},
	[1972] = {8.25, 8.25, 8.5},
	[1973] = {8.5, 8.5, 7},
	[1974] = {8, 8, 8},
	[1975] = {8, 8, 8},
	[1976] = {8, 8, 8},
	[1977] = {8, 8, 8},
	[1978] = {8, 8, 8},
	[1979] = {8, 8, 8},
	[1981] = {8, 8, 8},
	[1982] = {8, 8, 8},
	[1983] = {8, 8, 8},
	[1984] = {8.5, 8, 7.5},
	[2004] = {7.5, 8, 8.5},
	[2008] = {7.75, 8.25, 8},
	[2009] = {8, 8, 8},
	[2010] = {8.5, 8, 7.5},
	[2011] = {7.75, 8, 8.25},
	[2012] = {8, 8, 8},
	[2013] = {8, 8, 8},
	[2014] = {8, 8, 8},
	[2015] = {8, 8, 8},
	[2016] = {8, 8, 8},
	[2017] = {8, 8.5, 7.5},
	[2018] = {8, 8, 8},
	[2022] = {8, 9.25, 6.75},
	[2035] = {8, 8, 8},
	[2036] = {8, 8, 8},
	[2037] = {8, 8, 8},
	[2042] = {7.75, 7.75, 8.5},
	[2046] = {8, 8, 8},
	[2047] = {8, 8.25, 7.75},
}



lib.breedData.speciesToAvailableBreeds = {
	[39] = {11},
	[40] = {8},
	[41] = {4},
	[42] = {7},
	[43] = {3},
	[44] = {5},
	[45] = {3},
	[46] = {12},
	[47] = {3, 5},
	[49] = {3},
	[50] = {11},
	[51] = {3, 5},
	[52] = {3, 10, 11, 12},
	[55] = {3, 5, 6, 9},
	[56] = {8},
	[57] = {4},
	[58] = {8},
	[59] = {9},
	[64] = {9},
	[65] = {12},
	[67] = {3, 8, 10},
	[68] = {3, 6, 7},
	[69] = {3, 10, 11},
	[70] = {3, 5, 12},
	[72] = {3, 5, 11},
	[74] = {11},
	[75] = {5},
	[77] = {3},
	[78] = {12},
	[83] = {8},
	[84] = {3, 10, 11, 12},
	[85] = {9},
	[86] = {7},
	[87] = {5},
	[89] = {6},
	[90] = {7},
	[92] = {3},
	[93] = {4},
	[94] = {5},
	[95] = {3},
	[106] = {10},
	[107] = {3},
	[111] = {12},
	[114] = {12},
	[115] = {3},
	[116] = {12},
	[117] = {3},
	[118] = {3},
	[119] = {3},
	[120] = {3},
	[121] = {3},
	[122] = {5},
	[124] = {3},
	[125] = {5},
	[126] = {10},
	[127] = {7},
	[128] = {3},
	[130] = {3},
	[131] = {8},
	[132] = {6},
	[136] = {3, 7, 10, 12},
	[137] = {3, 5, 11},
	[138] = {3, 12},
	[139] = {3, 8, 12},
	[140] = {3, 4, 12},
	[141] = {3, 6, 12},
	[142] = {3, 5},
	[143] = {3, 5, 8},
	[144] = {3, 5, 11},
	[145] = {3, 5, 6, 8},
	[146] = {3, 5, 9, 12},
	[149] = {9},
	[153] = {7},
	[155] = {7},
	[156] = {3},
	[157] = {3},
	[158] = {3},
	[159] = {6},
	[160] = {4},
	[162] = {10},
	[163] = {8},
	[164] = {3},
	[165] = {9},
	[166] = {7},
	[167] = {3, 6, 9},
	[168] = {5},
	[169] = {3, 5},
	[170] = {7},
	[171] = {7},
	[172] = {10},
	[173] = {7},
	[174] = {3},
	[175] = {5},
	[179] = {7},
	[180] = {7},
	[183] = {3},
	[186] = {3, 4, 5, 8},
	[187] = {8},
	[188] = {6},
	[189] = {3},
	[190] = {6, 7, 12},
	[191] = {3},
	[192] = {9},
	[193] = {4},
	[194] = {3, 5, 8, 9, 11},
	[195] = {5, 8, 9, 11},
	[196] = {7},
	[197] = {8},
	[198] = {11},
	[199] = {10},
	[200] = {5},
	[201] = {7},
	[202] = {7},
	[203] = {12},
	[204] = {3},
	[205] = {7},
	[206] = {3, 9, 11},
	[207] = {8},
	[209] = {3},
	[210] = {5},
	[211] = {6},
	[212] = {3},
	[213] = {5},
	[214] = {3},
	[215] = {10},
	[216] = {3},
	[217] = {7},
	[218] = {4},
	[220] = {9},
	[224] = {10},
	[225] = {3},
	[226] = {4},
	[227] = {4},
	[228] = {7},
	[229] = {3},
	[231] = {3},
	[232] = {8},
	[233] = {8},
	[234] = {10},
	[235] = {10},
	[236] = {6},
	[237] = {3},
	[238] = {11},
	[239] = {4},
	[240] = {3},
	[241] = {12},
	[242] = {8},
	[243] = {10},
	[244] = {7},
	[245] = {8},
	[246] = {3},
	[247] = {6},
	[248] = {8},
	[249] = {7},
	[250] = {8},
	[251] = {3},
	[253] = {3},
	[254] = {3, 5, 8},
	[255] = {6},
	[256] = {7},
	[258] = {6},
	[259] = {12},
	[260] = {8},
	[261] = {4},
	[262] = {5},
	[264] = {8},
	[265] = {6},
	[266] = {8},
	[267] = {3},
	[268] = {4},
	[270] = {9},
	[271] = {3, 9, 10},
	[272] = {6, 9},
	[277] = {11},
	[278] = {9},
	[279] = {8},
	[280] = {3},
	[281] = {3},
	[282] = {3},
	[283] = {3},
	[285] = {10},
	[286] = {7},
	[287] = {3},
	[289] = {6},
	[291] = {12},
	[292] = {3},
	[293] = {9},
	[294] = {8},
	[296] = {3},
	[297] = {4},
	[298] = {3},
	[301] = {11},
	[302] = {7},
	[303] = {5},
	[306] = {11},
	[307] = {3},
	[308] = {3},
	[309] = {8},
	[310] = {8},
	[311] = {3},
	[316] = {3},
	[317] = {3},
	[318] = {3},
	[319] = {10},
	[320] = {7},
	[321] = {6},
	[323] = {8},
	[325] = {5, 8, 10},
	[328] = {4},
	[329] = {8},
	[330] = {10},
	[331] = {3},
	[332] = {3},
	[333] = {11},
	[335] = {12},
	[336] = {3},
	[337] = {12},
	[338] = {7},
	[339] = {12},
	[340] = {3},
	[341] = {3},
	[342] = {3},
	[343] = {3, 8},
	[346] = {3},
	[347] = {3},
	[348] = {8},
	[374] = {7, 8, 9, 10, 11, 12},
	[378] = {3, 5, 7, 9, 11, 12},
	[379] = {3, 5, 10, 11, 12},
	[380] = {3, 12},
	[381] = {9},
	[383] = {8, 11},
	[385] = {3, 5, 8, 11, 12},
	[386] = {3, 5, 11},
	[387] = {3, 5},
	[388] = {3, 6, 7},
	[389] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[391] = {3, 5, 9},
	[392] = {3, 5, 9, 11},
	[393] = {5, 6, 7, 9, 11, 12},
	[395] = {3, 6, 7},
	[396] = {8, 11},
	[397] = {3, 9, 11, 12},
	[398] = {3, 5, 9, 11},
	[399] = {3, 5, 8},
	[400] = {3, 4, 9, 11},
	[401] = {3, 6, 7},
	[402] = {3, 9, 12},
	[403] = {3, 5, 8, 10},
	[404] = {3, 12},
	[405] = {3, 4, 7},
	[406] = {3, 6, 7, 9},
	[407] = {3, 5, 8, 11},
	[408] = {3, 5, 11},
	[409] = {5, 8, 10},
	[410] = {3, 5, 9, 11},
	[411] = {3, 4},
	[412] = {3, 5, 11},
	[414] = {3, 8},
	[415] = {6, 7, 9},
	[416] = {3, 5, 8},
	[417] = {3, 5, 9, 11},
	[418] = {3, 11},
	[419] = {3, 11},
	[420] = {3, 7, 12},
	[421] = {3, 9, 12},
	[422] = {3, 5, 8},
	[423] = {3, 6, 9},
	[424] = {5, 6, 7, 9, 11, 12},
	[425] = {3, 8, 10},
	[427] = {3, 9},
	[428] = {3, 5, 8, 11},
	[429] = {4, 6, 7, 9},
	[430] = {5},
	[431] = {8, 9},
	[432] = {3, 8},
	[433] = {3, 5, 7},
	[437] = {3, 10},
	[438] = {6, 9},
	[439] = {6, 9},
	[440] = {3, 4, 8},
	[441] = {5, 7, 9},
	[442] = {6, 7, 9, 12},
	[443] = {3, 5, 7, 9, 11, 12},
	[445] = {6, 7, 9, 10},
	[446] = {3, 4, 6, 9},
	[447] = {3, 5, 9, 11, 12},
	[448] = {3, 5, 7, 9, 11, 12},
	[449] = {3, 5, 11},
	[450] = {3, 6},
	[452] = {3, 5, 10, 11, 12},
	[453] = {6, 7},
	[454] = {3, 5, 9, 11},
	[455] = {7, 8, 10},
	[456] = {3, 6, 7, 8},
	[457] = {6, 9},
	[458] = {3, 6},
	[459] = {3, 5, 8, 11},
	[460] = {3, 6, 9},
	[461] = {3},
	[463] = {6, 9},
	[464] = {3, 5, 9},
	[465] = {3, 4, 8},
	[466] = {3, 5, 7},
	[467] = {3, 6, 7, 9},
	[468] = {3, 6, 7, 9},
	[469] = {3, 4, 6, 7, 9},
	[470] = {3, 4, 7, 11},
	[471] = {3, 5, 6, 8, 9, 10},
	[472] = {3, 4, 5, 6, 7, 8, 10, 11},
	[473] = {3, 9},
	[474] = {5},
	[475] = {3, 12},
	[477] = {3, 11},
	[478] = {3, 9, 11, 12},
	[479] = {3, 11},
	[480] = {3, 6, 9},
	[482] = {3, 5},
	[483] = {3, 12},
	[484] = {3, 5, 8, 11},
	[485] = {6, 7, 9},
	[487] = {3, 5, 7, 10, 11, 12},
	[488] = {12},
	[489] = {4, 8, 10},
	[491] = {5, 8},
	[492] = {3, 6, 9},
	[493] = {3, 6, 7},
	[494] = {3, 6, 7},
	[495] = {3, 12},
	[496] = {3, 9, 12},
	[497] = {6, 7, 9, 12},
	[498] = {3, 8, 9},
	[499] = {7},
	[500] = {3, 4, 6, 7, 8, 10},
	[502] = {3, 12},
	[503] = {3, 5, 11},
	[504] = {3, 4, 10},
	[505] = {3, 5, 7, 11},
	[506] = {3, 6, 9, 11},
	[507] = {3, 9, 12},
	[508] = {3, 4, 7},
	[509] = {6, 7, 9},
	[511] = {3, 5, 11},
	[512] = {4, 6, 9, 12},
	[513] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[514] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[515] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[517] = {3, 8},
	[518] = {3, 6},
	[519] = {6, 7, 9},
	[521] = {10},
	[523] = {6, 9},
	[525] = {3, 5, 12},
	[528] = {9, 12},
	[529] = {4, 7},
	[530] = {3, 6, 7, 9},
	[532] = {4, 6},
	[534] = {3, 4, 5, 8, 10},
	[535] = {3, 9},
	[536] = {7, 9},
	[537] = {3, 4, 6, 7},
	[538] = {6, 8},
	[539] = {3, 5, 10, 11, 12},
	[540] = {3, 5, 10, 11, 12},
	[541] = {5, 6, 7, 9},
	[542] = {3, 12},
	[543] = {3, 5, 9},
	[544] = {5, 11, 12},
	[545] = {3, 5, 8},
	[546] = {6, 9, 12},
	[547] = {3, 5, 7, 9, 10, 11},
	[548] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[549] = {3, 5, 10, 11, 12},
	[550] = {3, 5, 10, 11, 12},
	[552] = {3, 4, 6, 7, 11},
	[553] = {3, 5, 10, 11, 12},
	[554] = {3, 7, 9},
	[555] = {5, 6, 7, 9},
	[556] = {6, 9, 12},
	[557] = {4, 5, 7, 10, 11},
	[558] = {8},
	[559] = {4, 6, 7, 9},
	[560] = {3, 5, 10},
	[562] = {3, 5, 8},
	[564] = {3, 6, 12},
	[565] = {3, 12},
	[566] = {3, 9, 12},
	[567] = {5, 10},
	[568] = {3, 9},
	[569] = {3, 12},
	[570] = {3, 10},
	[571] = {3, 5},
	[572] = {4, 6},
	[573] = {3, 5, 10, 11},
	[626] = {4, 5, 7, 8, 10, 11},
	[627] = {7, 10},
	[628] = {3, 10},
	[629] = {3, 4, 7},
	[630] = {3, 5, 8, 10},
	[631] = {7, 9},
	[632] = {3, 10},
	[633] = {3, 7, 9, 12},
	[634] = {3, 9},
	[635] = {3, 8, 10},
	[637] = {3, 5, 11},
	[638] = {5, 6, 7, 9},
	[639] = {3, 5, 10, 11, 12},
	[640] = {3, 5, 7, 9, 11, 12},
	[641] = {3, 5, 7, 9, 11, 12},
	[644] = {3, 5, 10, 11, 12},
	[645] = {3, 8, 9},
	[646] = {3, 5, 11, 12},
	[647] = {3, 5, 8, 10, 11},
	[648] = {3, 6, 7, 12},
	[649] = {3, 7, 8},
	[650] = {8},
	[652] = {11},
	[665] = {11},
	[671] = {8},
	[675] = {3, 5, 10, 11, 12},
	[677] = {3, 5, 8},
	[678] = {6, 9},
	[679] = {5, 11},
	[680] = {5, 11},
	[699] = {3, 9, 11, 12},
	[702] = {3, 5, 12},
	[703] = {3, 11},
	[706] = {3, 5, 8},
	[707] = {3, 5},
	[708] = {3, 5, 10, 11, 12},
	[709] = {3, 5, 11, 12},
	[710] = {3, 9, 11},
	[711] = {3, 5, 11},
	[712] = {3, 5, 11},
	[713] = {3, 9},
	[714] = {3, 4, 10, 11},
	[716] = {7, 9},
	[717] = {5, 6, 9, 12},
	[718] = {3, 8, 9},
	[722] = {3, 9, 10, 12},
	[723] = {3, 6, 9},
	[724] = {5, 10},
	[725] = {3, 11},
	[726] = {3, 5, 7},
	[727] = {3, 5, 8, 11, 12},
	[728] = {3, 5, 11, 12},
	[729] = {3, 5, 7, 9, 11, 12},
	[730] = {3, 5, 9, 11, 12},
	[731] = {7, 9},
	[732] = {8, 9},
	[733] = {3, 5, 11},
	[737] = {5, 8},
	[739] = {5, 8},
	[740] = {3, 9, 10, 11, 12},
	[741] = {3, 12},
	[742] = {3, 5},
	[743] = {3, 5, 12},
	[744] = {5, 6, 7, 9, 11, 12},
	[745] = {3, 9},
	[746] = {4, 6},
	[747] = {3, 9, 10, 12},
	[748] = {3, 5, 7, 8, 9, 10, 11, 12},
	[749] = {5, 11},
	[750] = {3, 5, 11},
	[751] = {3, 9, 11, 12},
	[752] = {3, 4, 12},
	[753] = {3, 9},
	[754] = {3, 5, 7, 8, 9, 11, 12},
	[755] = {8, 10},
	[756] = {3, 5, 9},
	[757] = {5},
	[758] = {8},
	[792] = {3, 12},
	[802] = {4},
	[817] = {7},
	[818] = {8},
	[819] = {5},
	[820] = {12},
	[821] = {11},
	[823] = {3, 5, 9, 12},
	[834] = {7},
	[835] = {5},
	[836] = {5},
	[837] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[838] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
	[844] = {5},
	[845] = {3, 8, 10},
	[846] = {5},
	[847] = {12},
	[848] = {3, 5, 9},
	[849] = {3},
	[850] = {3},
	[851] = {3, 5, 7},
	[855] = {3},
	[856] = {9, 12},
	[868] = {9},
	[872] = {3},
	[873] = {3},
	[874] = {3},
	[875] = {8},
	[876] = {7},
	[877] = {9},
	[878] = {3},
	[879] = {7},
	[880] = {7},
	[881] = {8},
	[882] = {9},
	[883] = {6},
	[884] = {8},
	[885] = {8},
	[886] = {9},
	[887] = {8},
	[888] = {3},
	[889] = {3},
	[890] = {3},
	[891] = {5},
	[892] = {8},
	[893] = {3},
	[894] = {5},
	[895] = {8},
	[896] = {6},
	[897] = {9},
	[898] = {3},
	[899] = {8},
	[900] = {6},
	[901] = {6},
	[902] = {9},
	[903] = {10},
	[904] = {9},
	[905] = {8},
	[906] = {5},
	[907] = {9},
	[908] = {8},
	[909] = {5},
	[911] = {7},
	[912] = {4},
	[913] = {8},
	[915] = {7},
	[916] = {8},
	[917] = {6},
	[921] = {7},
	[922] = {4},
	[923] = {6},
	[924] = {9},
	[925] = {7},
	[926] = {8},
	[927] = {5},
	[928] = {8},
	[929] = {9},
	[931] = {9},
	[932] = {6},
	[933] = {5},
	[934] = {6},
	[935] = {8},
	[936] = {3},
	[937] = {8},
	[938] = {9},
	[939] = {7},
	[941] = {8},
	[942] = {6},
	[943] = {9},
	[944] = {6},
	[945] = {7},
	[946] = {5},
	[947] = {9},
	[948] = {5},
	[949] = {8},
	[950] = {6},
	[951] = {7},
	[952] = {7},
	[953] = {6},
	[954] = {3},
	[955] = {5},
	[956] = {6},
	[957] = {8},
	[958] = {3},
	[959] = {8},
	[960] = {4},
	[961] = {4},
	[962] = {8},
	[963] = {7},
	[964] = {3},
	[965] = {3},
	[966] = {9},
	[967] = {8},
	[968] = {7},
	[969] = {9},
	[970] = {8},
	[971] = {7},
	[972] = {9},
	[973] = {8},
	[974] = {8},
	[975] = {6},
	[976] = {7},
	[977] = {9},
	[978] = {8},
	[979] = {6},
	[980] = {6},
	[981] = {8},
	[982] = {5},
	[983] = {6},
	[984] = {9},
	[985] = {7},
	[986] = {4},
	[987] = {9},
	[988] = {8},
	[989] = {9},
	[990] = {5},
	[991] = {8},
	[992] = {6},
	[993] = {5},
	[994] = {8},
	[995] = {9},
	[996] = {6},
	[997] = {7},
	[998] = {9},
	[999] = {6},
	[1000] = {8},
	[1001] = {8},
	[1002] = {9},
	[1003] = {9},
	[1004] = {9},
	[1005] = {9},
	[1006] = {6},
	[1007] = {4},
	[1008] = {6},
	[1009] = {7},
	[1010] = {8},
	[1011] = {7},
	[1012] = {5},
	[1013] = {3, 6, 9},
	[1039] = {6},
	[1040] = {6},
	[1042] = {8},
	[1061] = {5},
	[1062] = {3, 9, 10, 12},
	[1063] = {8},
	[1065] = {8},
	[1066] = {10},
	[1067] = {7},
	[1068] = {3, 5, 8, 10},
	[1073] = {12},
	[1117] = {3},
	[1124] = {8},
	[1125] = {3},
	[1126] = {7},
	[1127] = {8},
	[1128] = {3, 12},
	[1129] = {7},
	[1130] = {8},
	[1131] = {11},
	[1132] = {5},
	[1133] = {10},
	[1134] = {9},
	[1135] = {12},
	[1136] = {3},
	[1137] = {6},
	[1138] = {9},
	[1139] = {8},
	[1140] = {3},
	[1141] = {7},
	[1142] = {11},
	[1143] = {8},
	[1144] = {9},
	[1145] = {5},
	[1146] = {7},
	[1147] = {4},
	[1149] = {8},
	[1150] = {9},
	[1151] = {7},
	[1152] = {6},
	[1153] = {4},
	[1154] = {9},
	[1155] = {6},
	[1156] = {8},
	[1157] = {3, 12},
	[1158] = {12},
	[1159] = {12},
	[1160] = {8},
	[1161] = {4, 8, 10},
	[1162] = {5, 8},
	[1163] = {6, 7},
	[1164] = {3, 5, 11},
	[1165] = {4, 8, 10},
	[1166] = {4, 8, 10},
	[1167] = {4, 8, 10},
	[1168] = {12},
	[1174] = {12},
	[1175] = {3, 12},
	[1176] = {3},
	[1177] = {6, 7, 9, 10},
	[1178] = {4},
	[1179] = {3},
	[1180] = {4, 5, 8, 10},
	[1181] = {6, 9},
	[1182] = {3, 12},
	[1183] = {4},
	[1184] = {4},
	[1185] = {9},
	[1187] = {4},
	[1188] = {3},
	[1189] = {9},
	[1190] = {11},
	[1191] = {6},
	[1192] = {10},
	[1193] = {12},
	[1194] = {8},
	[1195] = {5},
	[1196] = {9},
	[1197] = {7},
	[1198] = {8},
	[1200] = {8},
	[1201] = {10},
	[1202] = {3, 10},
	[1204] = {11}, -- NEW: Pierre
	[1205] = {3, 6, 7, 9, 10},
	[1206] = {10},
	[1207] = {12},
	[1208] = {11},
	[1209] = {3},
	[1211] = {4, 5, 8, 10},
	[1212] = {4, 5, 8, 10},
	[1213] = {4, 5, 8, 10},
	[1226] = {3, 4, 5, 8, 10},
	[1227] = {6, 7, 9},
	[1228] = {4, 6, 8},
	[1229] = {5, 8, 10},
	[1230] = {6, 7, 9},
	[1231] = {3, 10, 11, 12},
	[1232] = {3, 10, 12},
	[1233] = {4, 6, 7, 8},
	[1234] = {3, 6, 7, 9},
	[1235] = {5, 11, 12},
	[1236] = {8},
	[1237] = {8},
	[1238] = {3, 6},
	[1243] = {8},
	[1244] = {7},
	[1245] = {3, 6, 9},
	[1247] = {8},
	[1248] = {3},
	[1255] = {7},
	[1256] = {10, 11},
	[1257] = {3},
	[1258] = {8},
	[1259] = {6},
	[1266] = {4},
	[1267] = {8},
	[1268] = {6},
	[1269] = {4},
	[1271] = {3},
	[1276] = {4, 5, 8},
	[1277] = {5},
	[1278] = {4},
	[1279] = {6},
	[1280] = {6},
	[1281] = {5},
	[1282] = {8},
	[1283] = {4},
	[1284] = {6},
	[1285] = {5},
	[1286] = {5},
	[1287] = {4},
	[1288] = {6},
	[1289] = {4},
	[1290] = {3},
	[1291] = {3},
	[1292] = {7},
	[1293] = {3},
	[1295] = {3},
	[1296] = {6},
	[1297] = {5},
	[1298] = {4},
	[1299] = {5},
	[1300] = {4},
	[1301] = {6},
	[1303] = {8},
	[1304] = {8},
	[1305] = {8},
	[1311] = {8},
	[1317] = {8},
	[1319] = {6},
	[1320] = {5},
	[1321] = {4, 5, 7, 8, 10},
	[1322] = {4, 6, 7},
	[1323] = {3, 4, 5, 10, 11},
	[1324] = {3, 8, 9, 11},
	[1325] = {3, 8, 9},
	[1326] = {3, 8, 9},
	[1328] = {3, 6, 7, 9, 12},
	[1329] = {5, 8, 9, 11},
	[1330] = {3, 4, 5, 6, 8},
	[1331] = {4, 8, 10},
	[1332] = {4, 5, 6},
	[1333] = {3, 5, 8, 9},
	[1334] = {6, 7, 9},
	[1335] = {8},
	[1336] = {3, 6, 7, 9, 12},
	[1337] = {4, 6},
	[1338] = {3, 7, 12},
	[1339] = {3},
	[1343] = {4, 5, 7, 8, 9},
	[1344] = {7},
	[1345] = {6, 9},
	[1346] = {9},
	[1348] = {8},
	[1349] = {4},
	[1350] = {3},
	[1351] = {7},
	[1352] = {6},
	[1354] = {3},
	[1363] = {8},
	[1364] = {4},
	[1365] = {9},
	[1384] = {7}, -- NEW: Hogs
	[1385] = {3, 4, 5, 8, 10}, -- NEW: Albino Chimaeraling
	[1386] = {4}, -- NEW: Dread Hatchling
	[1387] = {4, 6, 7, 8, 10}, -- NEW: Iron Starlette
	[1394] = {6}, -- NEW: Weebomination
	[1395] = {6}, -- NEW: Lil' Leftovers
	[1396] = {8}, -- NEW: Crazy Carrot
	[1400] = {3}, -- TAMER: Deebs
	[1401] = {3}, -- TAMER: Tyri
	[1402] = {3}, -- TAMER: Puzzle
	[1403] = {4, 5, 7, 10, 11}, -- NEW: Mechanical Axebeak
	[1409] = {3}, -- TAMER: Eleanor
	--[1410] = {???}, -- TAMER: Mechanical Training Dummy
	[1411] = {10}, -- NEW: Royal Peacock
	[1412] = {4, 5, 6}, -- NEW: Lifelike Mechanical Frostboar
	[1416] = {7}, -- NEW: Teroclaw Hatchling
	--[1420] = {???}, -- TAMER: Evil Widowling
	--[1423] = {???}, -- TAMER: Bitey
	[1424] = {11}, -- TAMER: Gyrexle, the Eternal Mechanic
	[1426] = {6}, -- NEW: Elekk Plushie
	[1427] = {3, 4, 5, 6, 7, 8, 12}, -- NEW: Frostfur Rat
	[1428] = {7}, -- NEW: Zomstrok
	[1429] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, -- NEW: Autumnal Sproutling
	[1430] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, -- NEW: Forest Sproutling
	--[1431] = {???}, -- NEW: Kelp Sproutling
	[1432] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, -- NEW: Nightshade Sproutling
	--[1433] = {???}, -- NEW: Sassy Sproutling
	[1434] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, -- NEW: Sun Sproutling
	[1435] = {3, 6}, -- NEW: Leatherhide Runt
	[1441] = {3, 12}, -- NEW: Mud Jumper
	[1442] = {6}, -- NEW: Ghastly Kid
	[1443] = {12}, -- TAMER: Idol of Decay
	[1444] = {3}, -- TAMER: Wishbright Lantern
	[1446] = {10}, -- NEW: Meadowstomper Calf
	[1447] = {4, 6, 7, 8}, -- NEW: Moonshell Crab
	[1448] = {3, 10, 11, 12}, -- NEW: Sea Calf
	[1449] = {4}, -- NEW: Deathwatch Hatchling
	[1450] = {8}, -- NEW: Draenei Micro Defender
	[1451] = {5}, -- NEW: Molten Corgi
	[1453] = {9}, -- NEW: River Calf
	[1454] = {3}, -- NEW: Murkidan
	[1455] = {3, 10, 11, 12}, -- NEW: Mossbite Skitterer
	[1456] = {3, 10, 11, 12}, -- NEW: Thicket Skitterer
	[1457] = {3, 10, 11, 12}, -- NEW: Icespine Hatchling
	[1458] = {3, 10, 11, 12}, -- NEW: Bone Wasp
	[1462] = {3, 10, 11, 12}, -- NEW: Bloodsting Wasp
	[1463] = {3, 10, 11, 12}, -- NEW: Wood Wasp
	[1464] = {3, 10, 11, 12}, -- NEW: Twilight Wasp
	[1465] = {3, 10, 11, 12}, -- NEW: Amberbarb Wasp
	[1466] = {11}, -- NEW: Brightpaw
	[1467] = {4, 5}, -- NEW: Sky-Bo
	[1468] = {3, 4, 7, 10, 12}, -- NEW: Bloodbeak
	[1469] = {3, 4, 7, 10, 12}, -- NEW: Junglebeak
	[1470] = {3, 4, 7, 10, 12}, -- NEW: Axebeak Hatchling
	[1471] = {10}, -- NEW: Fruit Hunter
	[1472] = {3}, -- TAMER: Gnawface
	[1473] = {3}, -- TAMER: Carrotus Maximus
	[1474] = {6}, -- TAMER: Gorefu
	[1475] = {6}, -- TAMER: Otto
	[1476] = {4}, -- TAMER: Mr. Pointy
	[1477] = {8}, -- TAMER: Syd
	[1478] = {7}, -- NEW: Syd the Squid
	[1479] = {3}, -- TAMER: Brutus
	[1480] = {3}, -- TAMER: Quintessence of Light
	[1482] = {3}, -- TAMER: Rukus
	[1483] = {3}, -- TAMER: Mr. Terrible
	[1484] = {3}, -- TAMER: Carroteye
	[1485] = {3}, -- TAMER: Sloppus
	[1486] = {3}, -- TAMER: The Beakinator
	[1487] = {3}, -- TAMER: King Floret
	[1488] = {3}, -- TAMER: Queen Floret
	[1489] = {3}, -- TAMER: Kromli
	[1490] = {3}, -- TAMER: Gromli
	[1492] = {3}, -- TAMER: Grubbles
	[1493] = {3}, -- TAMER: Stings
	[1494] = {3}, -- TAMER: Scrags
	[1495] = {3, 4, 5, 10, 11}, -- NEW: Ore Eater
	[1496] = {3}, -- TAMER: Jahan
	[1497] = {3}, -- TAMER: Samm
	[1498] = {3}, -- TAMER: Archimedes
	[1499] = {3}, -- TAMER: Fiero
	[1500] = {3}, -- TAMER: Tirs
	[1501] = {3}, -- TAMER: Rockbiter
	[1502] = {3}, -- TAMER: Stonechewer
	[1503] = {3}, -- TAMER: Acidtooth
	[1504] = {3}, -- TAMER: Blingtron 4999b
	[1505] = {3}, -- TAMER: Protectron 022481
	[1506] = {3}, -- TAMER: Protectron 011803
	[1507] = {3}, -- TAMER: Stitches Jr.
	[1508] = {3}, -- TAMER: Manos
	[1509] = {3}, -- TAMER: Hanos
	[1510] = {3}, -- TAMER: Fatos
	[1511] = {5}, -- NEW: Lovebird Hatchling
	[1514] = {3}, -- NEW: Mystical Spring Bouquet
	[1515] = {8}, -- NEW: Stonegrinder
	[1516] = {10}, -- NEW: Bush Chicken
	[1517] = {4}, -- NEW: Blazing Cindercrawler
	[1518] = {4}, -- NEW: Stout Alemental
	--[1519] = {???}, -- TAMER: Limbflayer
	[1521] = {8}, -- NEW: Cursed Birman
	[1523] = {5}, -- NEW: Widget the Departed
	[1524] = {7, 9}, -- NEW: Netherspawn, Spawn of Netherspawn
	[1530] = {4}, -- NEW: Frostwolf Ghostpup
	[1531] = {7}, -- NEW: Ancient Nest Guardian
	[1532] = {8}, -- NEW: Ikky
	[1533] = {8}, -- NEW: Lanticore Spawnling
	[1536] = {3}, -- NEW: Zangar Spore
	[1537] = {6}, -- NEW: Crimson Spore
	[1538] = {5}, -- NEW: Umbrafen Spore
	[1539] = {4}, -- NEW: Seaborne Spore
	[1540] = {8}, -- NEW: Brilliant Spore
	[1541] = {10}, -- NEW: Hydraling
	[1542] = {8}, -- NEW: Frostwolf Pup
	[1543] = {7}, -- NEW: Pygmy Cow
	[1544] = {10}, -- NEW: Hatespark the Tiny
	[1545] = {3, 10, 11, 12}, -- NEW: Firewing
	[1546] = {10}, -- NEW: Stormwing
	[1547] = {3}, -- TAMER: Pixiebell
	[1548] = {6}, -- TAMER: Doodle
	[1549] = {3}, -- TAMER: Tally
	[1550] = {4}, -- TAMER: Wolfus
	[1552] = {5}, -- TAMER: Fangra
	[1553] = {7}, -- TAMER: Wolfgar
	[1554] = {7}, -- TAMER: Gladiator Deathy
	[1555] = {7}, -- TAMER: Gladiator Murkalot
	[1556] = {6}, -- TAMER: Gladiator Murkimus
	[1557] = {4}, -- TAMER: Darkwing
	[1558] = {7}, -- TAMER: The Great Kaliri
	[1559] = {7}, -- TAMER: Apexis Guardian
	[1560] = {7}, -- TAMER: Serendipity
	[1561] = {7}, -- TAMER: Grace
	[1562] = {7}, -- TAMER: Atonement
	[1563] = {4, 5, 7, 9}, -- NEW: Bronze Whelpling
	[1564] = {7}, -- NEW: Doom Bloom
	[1565] = {4, 5, 7, 10, 11}, -- NEW: Mechanical Scorpid
	[1566] = {5}, -- NEW: Everbloom Peachick
	[1567] = {8}, -- NEW: Sentinel's Companion
	[1568] = {8}, -- NEW: Puddle Terror
	[1569] = {7}, -- NEW: Soul of the Forge
	[1570] = {8}, -- NEW: Sunfire Kaliri
	[1571] = {3, 6, 7, 9}, -- NEW: Albino River Calf
	[1572] = {3, 4, 5, 9, 10}, -- NEW: Brilliant Bloodfeather
	[1573] = {3, 4, 5, 9, 10}, -- NEW: Golden Dawnfeather
	[1574] = {8}, -- NEW: Son of Sethe
	[1575] = {10}, -- NEW: Sky Fry
	[1576] = {4}, -- NEW: Eye of Observation
	[1577] = {3, 10, 11, 12}, -- NEW: Bloodthorn Hatchling
	[1578] = {4, 6}, -- NEW: Frostshell Pincher
	[1579] = {4, 6}, -- NEW: Ironclaw Scuttler
	[1581] = {4, 6}, -- NEW: Fen Crab
	[1582] = {4, 6}, -- NEW: Zangar Crawler
	[1583] = {4, 6}, -- NEW: Kelp Scuttler
	[1586] = {3, 8, 9}, -- NEW: Cerulean Moth
	[1587] = {3, 8, 9}, -- NEW: Royal Moth
	[1588] = {3, 8, 9}, -- NEW: Dusty Sporewing
	[1589] = {3, 8, 9}, -- NEW: Crimsonwing Moth
	[1590] = {3, 9, 10, 12}, -- NEW: Swamplighter Firefly
	[1591] = {3, 9, 10, 12}, -- NEW: Violet Firefly
	[1592] = {3, 9, 10, 12}, -- NEW: Sapphire Firefly
	[1593] = {3, 9, 10, 12}, -- NEW: Waterfly
	[1594] = {3, 6, 7, 9}, -- NEW: Mudback Calf
	[1595] = {3, 6, 7, 9}, -- NEW: Flat-Tooth Calf
	[1596] = {8}, -- NEW: Veilwatcher Hatchling
	[1597] = {8}, -- NEW: Kaliri Hatchling
	[1598] = {3, 6, 9}, -- NEW: Glowing Sporebat
	[1599] = {3, 6, 9}, -- NEW: Shadow Sporebat
	[1600] = {3, 5, 6, 8}, -- NEW: Bone Serpent
	[1601] = {4}, -- NEW: Servant of Demidos
	[1602] = {8}, -- NEW: Grommloc
	[1603] = {9}, -- NEW: Argi
	[1604] = {7}, -- NEW: Nethaera's Light
	[1605] = {7}, -- NEW: Trunks
	[1607] = {3}, -- TAMER: Gorefu
	[1608] = {3}, -- TAMER: Carrotus Maximus
	[1609] = {3}, -- TAMER: Gnawface
	--[1610] = {???}, -- TAMER: Unborn Val'kyr
	[1615] = {3, 5, 7}, -- NEW: Parched Lizard
	[1622] = {6}, -- NEW: Grotesque
	[1623] = {7, 10, 12}, -- NEW: Leviathan Hatchling
	[1624] = {4}, -- NEW: Abyssius
	[1625] = {7}, -- NEW: Fragment of Anger
	[1626] = {12}, -- NEW: Fragment of Suffering
	[1627] = {9}, -- NEW: Fragment of Desire
	[1628] = {3, 10, 11, 12}, -- NEW: Sister of Temptation
	[1629] = {10, 11, 12}, -- NEW: Stinkrot
	[1631] = {5}, -- NEW: Hyjal Wisp
	[1632] = {6, 7, 9}, -- NEW: Sunblade Micro-Defender
	[1633] = {10}, -- NEW: Chaos Pup
	[1634] = {3}, -- NEW: Wretched Servant
	[1635] = {3}, -- NEW: K'ute
	[1636] = {7}, -- NEW: Race MiniZep
	[1637] = {3}, -- TAMER: Moon
	[1639] = {7}, -- NEW: Graves
	[1640] = {9}, -- TAMER: Spores
	[1641] = {3}, -- TAMER: Dusty
	[1642] = {7}, -- TAMER: Salad
	[1643] = {10}, -- TAMER: Mouthy
	[1644] = {7}, -- TAMER: Carl
	[1645] = {9}, -- TAMER: Mal
	[1646] = {5}, -- TAMER: Enbi'see
	[1647] = {8}, -- TAMER: Bones
	[1648] = {10}, -- TAMER: Sprouts
	[1649] = {3}, -- TAMER: Runts
	[1651] = {12}, -- TAMER: Prince Charming
	[1652] = {8}, -- TAMER: Jenner
	[1653] = {8}, -- TAMER: Brisby
	[1654] = {8}, -- TAMER: Nicodemus
	[1655] = {3, 4, 5, 7, 11, 12}, -- NEW: Slithershock Elver
	[1656] = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, -- NEW: Young Talbuk
	[1660] = {5}, -- NEW: Fel Pup
	[1661] = {8}, -- NEW: Lost Netherpup
	[1662] = {4}, -- NEW: Sea Calf
	[1663] = {6, 7}, -- NEW: Periwinkle Calf
	[1664] = {3}, -- NEW: Nightmare Bell
	[1665] = {9}, -- NEW: Ghostshell Crab
	[1666] = {3}, -- NEW: Blorp
	--[1668] = {???}, -- TAMER: 
	[1671] = {3}, -- TAMER: Felsworn Sentry
	[1672] = {6}, -- NEW: Corrupted Nest Guardian
	[1673] = {3}, -- TAMER: Corrupted Thundertail
	[1674] = {3}, -- TAMER: Chaos Pup
	[1675] = {3}, -- TAMER: Cursed Spirit
	[1676] = {3}, -- TAMER: Felfly
	[1677] = {3}, -- TAMER: Tainted Maulclaw
	[1678] = {3}, -- TAMER: Direflame
	[1679] = {3}, -- TAMER: Mirecroak
	[1680] = {3}, -- TAMER: Dark Gazer
	[1681] = {3}, -- TAMER: Bleakwing
	[1682] = {3}, -- TAMER: Vile Blood of Draenor
	[1683] = {3}, -- TAMER: Dreadwalker
	[1684] = {3}, -- TAMER: Netherfist
	[1685] = {3}, -- TAMER: Skrillix
	[1686] = {3}, -- TAMER: Defiled Earth
	[1687] = {3}, -- NEW: Left Shark
	[1688] = {4, 6, 7, 8}, -- NEW: Crusher
	[1690] = {8}, -- NEW: Shard of Cyrukh
	[1691] = {8}, -- NEW: Nibbles
	[1692] = {10}, -- NEW: Savage Cub
	[1693] = {4}, -- NEW: Blazing Firehawk
	[1725] = {4, 8, 10}, -- NEW: Grumpling
	[1730] = {5, 8, 9, 10, 11}, -- NEW: Spectral Spinner
	[1740] = {3, 5, 8, 10}, -- NEW: Ghost Maggot
	[1741] = {9, 10, 11, 12}, -- NEW: Ghastly Rat
	[1764] = {5}, -- NEW: Energized Manafiend
	[1765] = {6}, -- NEW: Empyreal Manafiend
	[1766] = {4}, -- NEW: Empowered Manafiend
	[1699] = {12}, -- NEW: Enchanted Cauldron
	[1700] = {10}, -- NEW: Enchanted Torch
	[1701] = {11}, -- NEW: Enchanted Pen
	[1705] = {7}, -- NEW: Grumpy
	[1706] = {6}, -- NEW: Ashmaw Cub
	[1708] = {3, 10, 11, 12}, -- NEW: Albatross Chick
	[1709] = {3, 4, 5, 10}, -- NEW: Fledgling Kingfeather
	[1710] = {3, 4, 5, 8, 10}, -- NEW: Fledgling Oliveback
	[1711] = {10}, -- NEW: Skyhorn Nestling
	[1712] = {3, 4, 5, 8, 10}, -- NEW: Golden Eaglet
	[1713] = {3, 4, 5, 8, 10}, -- NEW: Long-Eared Owl
	[1714] = {8}, -- NEW: Northern Hawk Owl
	[1715] = {8}, -- NEW: Nightwatch Swooper
	[1716] = {4}, -- NEW: Fledgling Warden Owl
	[1717] = {10}, -- NEW: Extinguished Eye
	[1718] = {4}, -- NEW: Hateful Eye
	[1719] = {7}, -- NEW: Eye of Inquisition
	[1720] = {8}, -- NEW: Emmigosa
	[1721] = {8}, -- NEW: Stormborne Whelpling
	[1722] = {4, 8, 10}, -- NEW: Dream Whelpling
	[1723] = {7}, -- NEW: Nightmare Whelpling
	[1726] = {3, 5, 8, 11}, -- NEW: Burrow Spiderling
	[1727] = {11}, -- NEW: Nursery Spider
	[1728] = {6, 8, 9, 10}, -- NEW: Juvenile Scuttleback
	[1729] = {3, 5, 7, 9, 11, 12}, -- NEW: Olivetail Hare
	[1731] = {3, 5, 8, 11}, -- NEW: Felspider
	[1734] = {3, 8, 9, 10, 11, 12}, -- NEW: Shimmering Aquafly
	[1735] = {6, 9}, -- NEW: Terror Larva
	[1736] = {3, 5, 8, 11}, -- NEW: Slithering Brownscale
	[1737] = {3, 4, 7, 8}, -- NEW: Vale Flitter
	[1738] = {3, 5, 8}, -- NEW: Auburn Ringtail
	[1739] = {3, 9, 11, 12}, -- NEW: Spring Strider
	[1742] = {3}, -- TAMER: Master Tamer Flummox
	[1743] = {3, 11}, -- NEW: Black-Footed Fox Kit
	[1744] = {3, 11}, -- NEW: Mist Fox Kit
	[1745] = {11}, -- TAMER: Marshmallow
	[1746] = {6}, -- TAMER: Rocket
	[1748] = {9}, -- TAMER: Jinx
	[1749] = {3, 4, 5, 6, 8, 10, 11}, -- NEW: Rose Taipan
	[1750] = {3, 6}, -- NEW: Tiny Apparition
	--[1751] = {???}, -- NEW: Son of Goredome
	[1752] = {8}, -- NEW: Crispin
	[1753] = {8}, -- NEW: Bleakwater Jelly
	[1754] = {9}, -- NEW: Sewer-Pipe Jelly
	[1755] = {12}, -- NEW: Plump Jelly
	[1756] = {12}, -- NEW: Ridgeback Piglet
	--[1757] = {???}, -- TAMER: Brown Piglet
	--[1758] = {???}, -- TAMER: Black Piglet
	[1759] = {8}, -- NEW: Thaumaturgical Piglet
	[1760] = {8}, -- NEW: Fel Piglet
	[1761] = {3, 8, 9, 11}, -- NEW: Echo Batling
	[1762] = {4, 7, 9, 12}, -- NEW: Hog-Nosed Bat
	[1763] = {3, 7, 12}, -- NEW: Spiketail Beaver
	[1770] = {3}, -- TAMER: Thrugtusk
	[1771] = {9}, -- TAMER: Baeloth
	[1772] = {7}, -- TAMER: Wumpas
	[1773] = {9}, -- NEW: Erudite Manafiend
	[1774] = {8}, -- NEW: Eldritch Manafiend
	[1775] = {5, 8, 10, 11}, -- NEW: Coralback Fiddler
	[1776] = {3, 7, 12}, -- NEW: Mudshell Conch
	[1777] = {3}, -- NEW: Broot
	[1778] = {5, 8, 11}, -- NEW: Dust Bunny
	[1780] = {7}, -- TAMER: Kiazor the Destroyer
	[1781] = {9}, -- TAMER: Scuttles
	[1782] = {7}, -- TAMER: Clamps
	[1787] = {3}, -- TAMER: Roots
	[1788] = {3}, -- TAMER: Beaky
	[1789] = {12}, -- TAMER: Sunny
	[1790] = {4}, -- TAMER: Lil' Spirit Guide
	[1791] = {9}, -- TAMER: Quillino
	[1792] = {10}, -- TAMER: Fethyr
	[1793] = {3}, -- TAMER: Egcellent
	[1794] = {4}, -- TAMER: Red Wire
	[1795] = {4}, -- TAMER: Sir Murkeston
	[1796] = {8}, -- TAMER: Coach
	[1797] = {10}, -- TAMER: Greatest Foe
	[1798] = {12}, -- TAMER: Gulp
	[1799] = {3}, -- TAMER: Grommet
	[1800] = {7}, -- TAMER: Itchy
	[1801] = {5}, -- TAMER: Salty Bird
	[1802] = {12}, -- NEW: Fetid Waveling
	[1803] = {9}, -- NEW: Thistleleaf Adventurer
	[1804] = {3}, -- NEW: Risen Saber Kitten
	[1805] = {6}, -- NEW: Alarm-o-Bot
	[1806] = {9}, -- NEW: Knockoff Blingtron
	[1807] = {10}, -- NEW: Vicious Broodling
	[1808] = {12}, -- NEW: Leyline Broodling
	[1809] = {3, 6, 8, 11, 12}, -- NEW: Crystalline Broodling
	[1810] = {3, 7}, -- NEW: Thornclaw Broodling
	[1811] = {6}, -- TAMER: Rocko
	[1815] = {10}, -- TAMER: Heliosus
	[1816] = {3}, -- TAMER: Mini Magmatron
	[1817] = {3}, -- TAMER: Mini Arcanotron
	[1818] = {3}, -- TAMER: Mini Electron
	[1828] = {7}, -- NEW: Baby Winston
	[1840] = {12}, -- TAMER: Snot
	[1841] = {7}, -- TAMER: Slow Moe
	[1842] = {12}, -- TAMER: Rocklick
	[1843] = {8}, -- TAMER: Hungry Icefang
	[1846] = {8}, -- TAMER: Globs
	[1847] = {5}, -- TAMER: Trixy
	[1848] = {3}, -- TAMER: Nightmare Sprout
	[1849] = {7}, -- TAMER: The Maw
	[1850] = {9}, -- TAMER: Thistleleaf Bully
	[1851] = {8}, -- TAMER: Cackling Flame
	[1852] = {10}, -- TAMER: Devouring Blaze
	[1853] = {7}, -- TAMER: Living Coals
	[1855] = {11}, -- TAMER: Splint Jr.
	[1857] = {3}, -- TAMER: Beauty
	[1858] = {7}, -- TAMER: Conviction
	[1859] = {3}, -- TAMER: Dignity
	[1860] = {11}, -- TAMER: Ancient Catacomb Spider
	[1861] = {7}, -- TAMER: Catacomb Bat
	[1862] = {6}, -- TAMER: Catacomb Snake
	[1863] = {5}, -- TAMER: Font of Mana
	[1864] = {6}, -- TAMER: Seed of Mana
	[1865] = {4}, -- TAMER: Essence of Mana
	[1866] = {4}, -- TAMER: Baby Bjorn
	[1867] = {6}, -- TAMER: Mini Musken
	[1868] = {9}, -- TAMER: Mist Wraith
	[1869] = {7}, -- TAMER: Crawdead
	[1870] = {10}, -- TAMER: Gnaw
	[1871] = {6}, -- TAMER: Harbinger of Dark
	[1872] = {6}, -- TAMER: Herald of Light
	[1873] = {11}, -- TAMER: Gusteau
	[1874] = {5}, -- TAMER: Remy
	[1875] = {12}, -- TAMER: Dinner
	[1877] = {12}, -- TAMER: Eye of Inquisition
	[1878] = {10}, -- TAMER: Eye of Interrogation
	[1879] = {5}, -- TAMER: Eye of Impetration
	[1880] = {3}, -- TAMER: Stitches Jr. Jr.
	[1881] = {3}, -- TAMER: Lil'idan
	[1882] = {6}, -- TAMER: Chromadon
	[1883] = {6}, -- TAMER: Blottis
	[1884] = {7}, -- NEW: Baby Elderhorn
	[1885] = {12}, -- NEW: Sunborne Val'kyr
	[1886] = {6}, -- NEW: Trigger
	--[1887] = {???}, -- NEW: Wyrmy Tunkins
	[1888] = {7}, -- NEW: Celestial Calf
	[1889] = {11}, -- NEW: Felbat Pup
	[1890] = {5}, -- NEW: Corgi Pup
	[1891] = {4}, -- TAMER: Vinu
	[1892] = {3}, -- TAMER: Subjugated Tadpole
	[1893] = {3}, -- TAMER: Allured Tadpole
	[1894] = {3}, -- TAMER: Confused Tadpole
	[1895] = {10}, -- TAMER: Hungry Owl
	[1896] = {9}, -- TAMER: Hungry Rat
	[1897] = {12}, -- TAMER: Breezy Book
	[1898] = {6}, -- TAMER: Helpful Spirit
	[1899] = {4}, -- TAMER: Delicate Moth
	[1903] = {6}, -- NEW: Zoom
	[1904] = {5}, -- TAMER: Stumpers
	[1905] = {6}, -- TAMER: Foof
	[1906] = {4}, -- TAMER: Lil' Sizzle
	[1907] = {8}, -- NEW: Pygmy Owl
	[1911] = {3}, -- NEW: Sting Ray Pup
	[1912] = {7}, -- NEW: Young Mutant Warturtle
	[1913] = {3, 4, 5, 9, 10, 11}, -- NEW: Gleamhoof Fawn
	[1914] = {5, 8, 10, 11}, -- NEW: Coastal Sandpiper
	[1915] = {3, 4, 5, 6, 7, 8, 12}, -- NEW: Blind Rat
	[1917] = {3, 4}, -- NEW: Stormstruck Beaver
	[1918] = {12}, -- NEW: Alliance Enthusiast
	[1919] = {12}, -- NEW: Horde Fanatic
	[1920] = {10}, -- NEW: Transmutant
	[1921] = {4}, -- NEW: Untethered Wyrmling
	[1922] = {8}, -- NEW: Lurking Owl Kitten
	[1926] = {9}, -- NEW: Hungering Claw
	[1927] = {8}, -- NEW: Ash'ana
	[1928] = {10}, -- NEW: Firebat Pup
	[1929] = {3}, -- NEW: Corgnelius
	[1930] = {12}, -- NEW: Lagan
	[1931] = {8}, -- NEW: Court Scribe
	[1932] = {7}, -- NEW: Nightmare Lasher
	[1933] = {11}, -- NEW: Nightmare Treant
	[1934] = {7}, -- NEW: Benax
	--[1935] = {???}, -- NEW: Squirky
	[1936] = {8}, -- NEW: Mischief
	--[1937] = {???}, -- NEW: Wonderous Wisdomball
	[1938] = {7}, -- NEW: Rescued Fawn
	[1939] = {8}, -- NEW: Legionnaire Murky
	[1940] = {8}, -- NEW: Knight-Captain Murky
	[1941] = {4}, -- NEW: Snowfang
	--[1943] = {???}, -- NEW: Noblegarden Bunny
	--[1949] = {???}, -- NEW: Igneous Flameling
	[1952] = {3}, -- NEW: Dreadmaw
	[1953] = {5, 9, 11}, -- NEW: Snobold Runt
	[1954] = {8, 11}, -- NEW: Nerubian Swarmer
	[1955] = {4}, -- NEW: Magma Rageling
	[1956] = {6, 12}, -- NEW: Ironbound Proto-Whelp
	[1957] = {3}, -- NEW: Runeforged Servitor
	[1958] = {3, 4, 7, 10}, -- NEW: Sanctum Cub
	[1959] = {6}, -- NEW: Winter Rageling
	[1960] = {3}, -- NEW: Snaplasher
	[1961] = {6, 7, 12}, -- NEW: G0-R41-0N Ultratonk
	[1962] = {8}, -- NEW: Creeping Tentacle
	[1963] = {3}, -- NEW: Boneshard
	[1964] = {3, 4, 5, 6, 7, 8, 9, 10, 12}, -- NEW: Blood Boil
	[1965] = {3, 7, 9}, -- NEW: Blightbreath
	[1966] = {11}, -- NEW: Soulbroken Whelpling
	[1967] = {3}, -- NEW: Drudge Ghoul
	[1968] = {5, 8, 11}, -- NEW: Wicked Soul
	[1969] = {5}, -- NEW: Stardust
	--[1971] = {???}, -- TAMER: Comet
	--[1972] = {???}, -- TAMER: Cosmos
	--[1973] = {???}, -- TAMER: Constellatius
	[1974] = {5}, -- NEW: Snowfeather Hatchling
	[1975] = {7}, -- NEW: Direbeak Hatchling
	[1976] = {4}, -- NEW: Sharptalon Hatchling
	[1977] = {8}, -- NEW: Bloodgazer Hatchling
	--[1978] = {???}, -- NEW: Dutiful Squire
	--[1979] = {???}, -- NEW: Dutiful Gruntling
	--[1981] = {???}, -- TAMER: Swoop
	--[1982] = {???}, -- TAMER: Buzz
	--[1983] = {???}, -- TAMER: Cherry
	[1984] = {6, 7, 9, 12}, -- NEW: Albino Buzzard
	[1997] = {4}, -- NEW: Crackers
	[1999] = {5, 8, 9, 11}, -- NEW: Cavern Moccasin
	[2000] = {7, 8, 10}, -- NEW: Young Venomfang
	[2004] = {7}, -- NEW: Trashy
	[2008] = {12}, -- TAMER: Fido
	[2009] = {4},  -- TAMER: Seer's Eye
	[2010] = {7}, -- TAMER: Flickering Fel
	[2011] = {5}, -- TAMER: Imply
	[2012] = {10}, -- TAMER: Rover
	[2013] = {3}, -- TAMER: Seduction
	[2014] = {12}, -- TAMER: Living Pool
	[2015] = {7}, -- TAMER: Tia Mia and Larry
	[2016] = {7}, -- TAMER: Rock Lobster
	[2017] = {4}, -- NEW: Infinite Hatchling
	[2018] = {10}, -- NEW: Paradox Spirit
	[2022] = {3}, -- NEW: Tylarr Gronnden
	[2042] = {8}, -- NEW: Scraps
}

--[[
local a,b = 0,0
for k,v in pairs(lib.breedData.speciesToAvailableBreeds) do a = a+1 end
for k,v in pairs(lib.breedData.speciesToBaseStatProfile) do b = b+1 end

missingPets = ""
for k,v in pairs(lib.breedData.speciesToBaseStatProfile) do 
	if not lib.breedData.speciesToAvailableBreeds[k] then
		missingPets = missingPets..k..", "
		print(k)
	end
end


print(a,b)]]