﻿---------------------------------
-- Frame
---------------------------------
local frame = CreateFrame("Frame", "BattleResFrame", UIParent)

frame:SetFrameStrata("BACKGROUND")
frame:SetSize(150, 30)
frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background"})
frame:SetBackdropColor(0.2, 0.2, 0.2, 0.7)
frame:SetPoint("BOTTOMLEFT", UIParent, 0, 180)
frame:EnableMouse(true)
frame:SetMovable(true)
frame:SetUserPlaced(true)
frame:SetClampedToScreen(true)
frame:Hide()

frame:SetScript("OnMouseDown", function(self, button)
	self:StartMoving()
end)

frame:SetScript("OnMouseUp", function(self, button)
	self:StopMovingOrSizing()
end)

---------------------------------
-- Bar
---------------------------------
local bar = CreateFrame("StatusBar", nil, frame)
bar:SetStatusBarTexture("Interface\\AddOns\\BattleRes\\Smoothv2")
bar:GetStatusBarTexture():SetHorizTile(false)
bar:SetMinMaxValues(0, 100)
bar:SetValue(0)
bar:SetWidth(150)
bar:SetHeight(14)
bar:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT")
bar:SetStatusBarColor(0,1,0)

bar:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background"})
bar:SetBackdropColor(0.1, 0.1, 0.1, 1)

---------------------------------
-- String
---------------------------------
local stack = bar:CreateFontString(nil, "ARTWORK")
local rTime = bar:CreateFontString(nil, "ARTWORK")
local title = frame:CreateFontString(nil, "ARTWORK")

local font, height, flag = SystemFont_Small:GetFont()
stack:SetFont(font, height, "OUTLINE")
rTime:SetFont(font, height, "OUTLINE")
title:SetFont(font, height, "OUTLINE")

stack:SetJustifyH("LEFT")
rTime:SetJustifyH("RIGHT")
title:SetJustifyH("LEFT")

stack:SetPoint("BOTTOMLEFT",0, 2)
rTime:SetPoint("BOTTOMRIGHT",0, 2)
title:SetPoint("TOPLEFT", 0, -1)

stack:SetText("|cffff00000|r")
rTime:SetText("")
title:SetText("BattleRes")

---------------------------------
-- Update
---------------------------------
local total = 0
local isMovable = false

bar:SetScript("OnUpdate", function(self, elapsed)
	if isMovable then return end --设置位置

	total = total + elapsed
	if total > 0.3 then
		total = 0
		
		local charges, _, started, duration = GetSpellCharges(20484)
		if not charges then
			-- hide out of encounter
			frame:Hide()
			frame:RegisterEvent("SPELL_UPDATE_CHARGES")
			return
		end
		
		local color = (charges > 0) and "|cffffffff" or "|cffff0000"
		local remaining = duration - (GetTime() - started)
		local m = floor(remaining / 60)
		local s = mod(remaining, 60)

		rTime:SetText(("|cffffffff%d:%02d|r"):format(m, s))
		stack:SetText(("%s%d|r"):format(color, charges))
		bar:SetMinMaxValues(0, duration)
		bar:SetValue(duration - remaining)
	end
end)

function frame:SPELL_UPDATE_CHARGES()
	local charges = GetSpellCharges(20484)
	if charges then
		self:UnregisterEvent("SPELL_UPDATE_CHARGES")
		--self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
		isMovable = false
		self:Show()
	end
end

-- function frame:COMBAT_LOG_EVENT_UNFILTERED(_, event, _, srcGUID, srcName, _, _, dstGUID, dstName, _, _, spellId, spellName)
   -- if event == "SPELL_RESURRECT" then
      -- local _, class = UnitClass(dstName)
      -- local c = class and RAID_CLASS_COLORS[class] or GRAY_FONT_COLOR
   -- end
-- end

function frame:PLAYER_ENTERING_WORLD()
	self:UnregisterEvent("SPELL_UPDATE_CHARGES")
	self:Hide()

	local _, instanceType, difficulty = GetInstanceInfo()
	-- raid
	if instanceType == "raid" then
		if IsEncounterInProgress() then --如果 上线时/重载界面后 已在boss战中
			self:Show()
		else
			self:RegisterEvent("SPELL_UPDATE_CHARGES")
		end
	end
	-- challenge mode
	if difficulty == 8 then
		self:Show()
	end
end

function frame:CHALLENGE_MODE_START()
	self:Show()
end

frame:RegisterEvent("PLAYER_ENTERING_WORLD")
frame:RegisterEvent("CHALLENGE_MODE_START")

frame:SetScript("OnEvent", function(self, event, ...)
	self[event](self, ...)
end)

-----------------------------
-- Slash
-----------------------------
SLASH_BATTLERES1, SLASH_BATTLERES2 = '/br', '/battleres'
function SlashCmdList.BATTLERES(msg, editbox)
	if frame:IsShown() then
		frame:Hide()
		isMovable = false
	else
		isMovable = true
		frame:Show()
	end
end