--[[
Written by: Agramonia@Chamber of Aspects-EU
Based on BattlePetBreedID by Simca@Malfurion and Hugh@Burning Blade
]]--

-- Get folder path and set addon namespace
local addonname, internal = ...

-- The only localized functions needed here
local CPBGN = _G.C_PetBattles.GetName
local CPBGS = _G.C_PetBattles.GetPetSpeciesID
local GPII = C_PetJournal.GetPetInfoByPetID
local GPIS = C_PetJournal.GetPetInfoBySpeciesID
local GPS = C_PetJournal.GetPetStats
local ceil = math.ceil

-- Initalize AddOn locals used in this section
local BattleNameText = ""
local BPTNameText = ""

-- This is the new Battle Pet SpeciesID Tooltip creation and setup function
function BPSID_SetSpeciesTooltip(parent, speciesID)

    -- Impossible checks (if missing parent, speciesID, or "rareness")
    local rarity
    if (not parent) or (not speciesID) then return end
    if (rareness) then
        rarity = rareness
    else
        rarity = 4
    end

    -- Set local reference to my tooltip or create it if it doesn't exist
    -- It inherits TooltipBorderedFrameTemplate AND GameTooltipTemplate to match Blizzard's "psuedo-tooltips" yet still make it easy to use 
    local speciestip
    local speciestiptext
    if (parent == FloatingBattlePetTooltip) then
        speciestip = _G["BPSID_SpeciesTooltip2"] or CreateFrame("GameTooltip", "BPSID_SpeciesTooltip2", nil, "TooltipBorderedFrameTemplate,GameTooltipTemplate")
        speciestiptext = "BPSID_SpeciesTooltip2"
    else
        speciestip = _G["BPSID_SpeciesTooltip"] or CreateFrame("GameTooltip", "BPSID_SpeciesTooltip", nil, "TooltipBorderedFrameTemplate,GameTooltipTemplate")
        speciestiptext = "BPSID_SpeciesTooltip"
    end

    -- Check for existence of LibExtraTip
    local extratip = false
    if (internal.LibExtraTip) and (internal.LibExtraTip.GetExtraTip) then
        extratip = internal.LibExtraTip:GetExtraTip(parent)

        -- See if it has hooked our parent
        if (extratip) and (extratip:IsVisible()) then
            parent = extratip
        end
    end

    -- Set positioning/parenting/ownership of Species Tooltip
    speciestip:SetParent(parent)
    speciestip:SetOwner(parent, "ANCHOR_NONE")
    speciestip:SetPoint("TOPLEFT", parent, "BOTTOMLEFT", 0, 2)
    speciestip:SetPoint("TOPRIGHT", parent, "BOTTOMRIGHT", 0, 2)

    -- Remove backdrop created as part of GameTooltipTemplate
    speciestip:SetBackdrop(nil)

    -- Set line for "Current pet's species"
    if (BPSID_Options.Speciestip.Current) and (speciesID) then
        local current = "\124cFFD4A017Species ID:\124r "
        current = current .. speciesID
        speciestip:AddLine(current, 1, 1, 1, 1)
    end

    -- Fix wordwrapping on smaller tooltips
    if _G[speciestiptext .. "TextLeft1"] then
        _G[speciestiptext .. "TextLeft1"]:CanNonSpaceWrap(true)
    end

    -- Fix fonts to all match (if multiple lines exist, which they should 99.9% of the time)
    if _G[speciestiptext .. "TextLeft2"] then
        -- Get fonts from line 1
        local fontpath, fontheight, fontflags = _G[speciestiptext .. "TextLeft1"]:GetFont()

        -- Set iterator at line 2 to start
        local iterline = 2

        -- Match all fonts to line 1
        while _G[speciestiptext .. "TextLeft" .. iterline] do
            _G[speciestiptext .. "TextLeft" .. iterline]:SetFont(fontpath, fontheight, fontflags)
            _G[speciestiptext .. "TextLeft" .. iterline]:CanNonSpaceWrap(true)
            iterline = iterline + 1
        end
    end

    -- Resize height automatically when reshown
    speciestip:Show()
end

-- Display species tooltips on pet frames/tooltips in Pet Battles
local function BPSID_Hook_BattleUpdate(self)
    if not self.petOwner or not self.petIndex or not self.Name then return end

    -- Cache all pets if it is the start of a battle
    if (internal.cacheTime == true) then internal.CacheAllPets() internal.cacheTime = false end

    -- Check if it is a tooltip
    local tooltip = (self:GetName() == "PetBattlePrimaryUnitTooltip")

    -- Calculate offset
    local offset = 0
    if (self.petOwner == 2) then offset = 3 end

    -- Get pet's name
    local name = CPBGN(self.petOwner, self.petIndex)
	local species = CPBGS(self.petOwner, self.petIndex)

    if tooltip then
        -- If this not the same tooltip as before
        if (BattleNameText ~= self.Name:GetText()) then

            -- Downside font if the name gets chopped off
            if self.Name:IsTruncated() then
                -- Retrieve font elements
                local fontName, fontHeight, fontFlags = self.Name:GetFont()

                -- Manually set height to perserve placing of other elements
                self.Name:SetHeight(self.Name:GetHeight())

                -- Store font in addon namespace for later
                if not internal.BattleFontSize then internal.BattleFontSize = { fontName, fontHeight, fontFlags } end

                -- Decrease the font size by 1 until it fits
                while self.Name:IsTruncated() do
                    fontHeight = fontHeight - 1
                    self.Name:SetFont(fontName, fontHeight, fontFlags)
                end
            elseif internal.BattleFontSize then
                -- Reset font size to original if not truncated and original font size known
                self.Name:SetFont(internal.BattleFontSize[1], internal.BattleFontSize[2], internal.BattleFontSize[3])
            end
        end

        -- Set the name text variable to match the real name text now to prepare for the next check
        BattleNameText = self.Name:GetText()

        -- Send to tooltip
        if (BPSID_Options.Tooltips.Enabled) and (BPSID_Options.Tooltips.BattleTooltip) then
            BPSID_SetSpeciesTooltip(PetBattlePrimaryUnitTooltip, internal.speciesCache[self.petIndex + offset])
        end
    end
end

-- Display species tooltips on item-based pet tooltips
local function BPSID_Hook_BPTShow(speciesID, level, rarity, maxHealth, power, speed)
    -- Impossible checks for safety reasons
    if (not BattlePetTooltip.Name) or (not speciesID) or (not level) or (not rarity) or (not maxHealth) or (not power) or (not speed) then return end
    
    -- Set up the species tooltip
    if (BPSID_Options.Tooltips.Enabled) and (BPSID_Options.Tooltips.BPT) then
        BPSID_SetSpeciesTooltip(BattlePetTooltip, speciesID)
    end
end

-- Display species tooltips on pet tooltips from chat links
local function BPSID_Hook_FBPTShow(speciesID, level, rarity, maxHealth, power, speed, name)
    -- Impossible checks for safety reasons
    if (not FloatingBattlePetTooltip.Name) or (not speciesID) or (not level) or (not rarity) or (not maxHealth) or (not power) or (not speed) then return end    

    -- Set up the species tooltip
    if (BPSID_Options.Tooltips.Enabled) and (BPSID_Options.Tooltips.FBPT) then
        BPSID_SetSpeciesTooltip(FloatingBattlePetTooltip, speciesID)
    end
end

-- Display species tooltips on Pet Journal tooltips
function internal.Hook_PJTEnter(self, motion)
    -- Impossible check for safety reasons
    if (not GameTooltip:IsVisible()) then return end

    if (PetJournalPetCard.petID) then
        -- Get data from PetID (which can get from the current PetCard since we know the current PetCard has to be responsible for the tooltip too)
        local speciesID, _, level = GPII(PetJournalPetCard.petID)
        local _, maxHealth, power, speed, rarity = GPS(PetJournalPetCard.petID)
        
        -- If fields become nil due to everything being filtered, show the special runthrough tooltip and escape from the function
        if not quality then
            BPSID_SetSpeciesTooltip(GameTooltip, PetJournalPetCard.speciesID)
            return
        end        

        -- Set up the species tooltip
        if (BPSID_Options.Tooltips.Enabled) and (BPSID_Options.Tooltips.PJT) then
            BPSID_SetSpeciesTooltip(GameTooltip, speciesID)
        end
    elseif (PetJournalPetCard.speciesID) and (BPSID_Options.Tooltips.Enabled) and (BPSID_Options.Tooltips.PJT) then
        -- Set up the species tooltip for a special runthrough (no known species)
        BPSID_SetSpeciesTooltip(GameTooltip, PetJournalPetCard.speciesID)
    end
end

-- Hook for ArkInventory compability, following the example of BattlePetTooltip
function internal.Hook_ArkInventory(tooltip, h)
    -- If the user has chosen not to let ArkInventory handle Battle Pets then we won't need to intervene
    if (not ArkInventory.db.global.option.tooltip.battlepet.enable) or ((tooltip ~= GameTooltip) and (tooltip ~= ItemRefTooltip)) then return end

    -- Decode string
    local class, speciesID, level, rarity, maxHealth, power, speed = ArkInventory.ObjectStringDecode( h )

    -- Escape if not a battlepet link
    if class ~= "battlepet" then return end

    -- Impossible checks for safety reasons
    if (not speciesID) or (not level) or (not rarity) or (not maxHealth) or (not power) or (not speed) then return end

    -- Fix width if too small
    if (tooltip:GetWidth() < 210) then
        tooltip:SetMinimumWidth(210)
        tooltip:Show()
    end    

    -- Set up the tooltip
    if (BPSID_Options.Tooltips.Enabled) and (((BPSID_Options.Tooltips.BPT) and (tooltip == GameTooltip)) or ((BPSID_Options.Tooltips.FBPT) and (tooltip == ItemRefTooltip))) then
        BPSID_SetSpeciesTooltip(tooltip, speciesID)
    end
end

-- Hook our tooltip functions
hooksecurefunc("PetBattleUnitFrame_UpdateDisplay", BPSID_Hook_BattleUpdate)
hooksecurefunc("BattlePetToolTip_Show", BPSID_Hook_BPTShow)
hooksecurefunc("FloatingBattlePet_Show", BPSID_Hook_FBPTShow)
-- Internal.Hook_PJTEnter is called by the ADDON_LOADED event of Blizzard_Collections in BattlePetSpeciesID's Core
-- Internal.Hook_PJTLeave is called by the ADDON_LOADED event of Blizzard_Collections in BattlePetSpeciesID's Core
-- HSFUpdate is handled in BattlePetSpeciesID's Core entirely because it is unrelated to tooltips