--[[
Written by: Agramonia@Chamber of Aspects-EU
Based on BattlePetBreedID by Simca@Malfurion and Hugh@Burning Blade
]]--

--[[
BPSID_Options.Tooltips.Enabled: Enable Battle Pet SpeciesID Tooltips
Show Battle Pet SpeciesID Tooltips...
BPSID_Options.Tooltips.BattleTooltip: In Battle (PrimaryBattlePetUnitTooltip)
BPSID_Options.Tooltips.BPT: On Items (BattlePetTooltip)
BPSID_Options.Tooltips.FBPT: On Chat Links (FloatingBattlePetTooltip)
BPSID_Options.Tooltips.PJT: In the Pet Journal (GameTooltip)

In Tooltips, show...
BPSID_Options.Speciestip.Current: Current pet's species
--]]

-- Get folder path and set addon namespace
local addonname, internal = ...

-- Create options panel
local Options = CreateFrame("Frame", nil, InterfaceOptionsFramePanelContainer)
Options:Hide()
Options.name = "Battle Pet SpeciesID"

-- Variable for easy positioning
local lastcheckbox

-- Ro's CreateFont function for easy FontString creation
local function CreateFont(fontName, r, g, b, anchorPoint, relativeTo, relativePoint, cx, cy, xoff, yoff, text)
    local font = Options:CreateFontString(nil, "BACKGROUND", fontName)
    font:SetJustifyH("LEFT")
    font:SetJustifyV("TOP")
    if type(r) == "string" then -- R is text, no positioning
        text = r
    else
        if r then
            font:SetTextColor(r, g, b, 1)
        end
        font:SetSize(cx, cy)
        font:SetPoint(anchorPoint, relativeTo, relativePoint, xoff, yoff)
    end
    font:SetText(text)
    return font
end

-- CreateCheckbox function for easy Checkbox creation (going to need lots and lots)
local function CreateCheckbox(text, height, width, anchorPoint, relativeTo, relativePoint, xoff, yoff, font)
    local checkbox = CreateFrame("CheckButton", nil, Options, "UICheckButtonTemplate")
    checkbox:SetPoint(anchorPoint, relativeTo, relativePoint, xoff, yoff)
    checkbox:SetSize(height, width)
    local realfont = font or "GameFontNormal"
    checkbox.text:SetFontObject(realfont)
    checkbox.text:SetText(" " .. text)
    lastcheckbox = checkbox
    return checkbox
end

local panelWidth = InterfaceOptionsFramePanelContainer:GetWidth() -- ~623
local wideWidth = panelWidth - 40

-- Create title, version, author, and description fields
local title = CreateFont("GameFontNormalLarge", "Battle Pet SpeciesID")
title:SetPoint("TOPLEFT", 16, -16)
local ver = CreateFont("GameFontNormalSmall", "version "..GetAddOnMetadata(addonname, "Version"))
ver:SetPoint("BOTTOMLEFT", title, "BOTTOMRIGHT", 4, 0)
local auth = CreateFont("GameFontNormalSmall", "created by "..GetAddOnMetadata(addonname, "Author"))
auth:SetPoint("BOTTOMLEFT", ver, "BOTTOMRIGHT", 3, 0)
local desc = CreateFont("GameFontHighlight", nil, nil, nil, "TOPLEFT", title, "BOTTOMLEFT", wideWidth, 40, 0, -8, "Battle Pet SpeciesID displays the SpeciesID of pets in your journal, in battle, in chat links, and in item tooltips.")

local OptTooltipsEnabled = CreateCheckbox("Enable Battle Pet SpeciesID Tooltips", 32, 32, "TOPLEFT", desc, "BOTTOMLEFT", 0, -16)

-- Text above the Tooltips region
local tooltipsTitle = CreateFont("GameFontNormal", "Show Battle Pet SpeciesID Tooltips...")
tooltipsTitle:SetPoint("TOPLEFT", lastcheckbox, "BOTTOMLEFT", 0, -2)
tooltipsTitle:SetTextColor(1, 1, 1, 1)

-- Make Tooltips checkboxes
local OptTooltipsBattleTooltip = CreateCheckbox("In Battle", 32, 32, "TOPLEFT", tooltipsTitle, "BOTTOMLEFT", 0, 0)
local OptTooltipsBPT = CreateCheckbox("On Items", 32, 32, "TOPLEFT", lastcheckbox, "BOTTOMLEFT", 0, 0)
local OptTooltipsFBPT = CreateCheckbox("On Chat Links", 32, 32, "TOPLEFT", lastcheckbox, "BOTTOMLEFT", 0, 0)
local OptTooltipsPJT = CreateCheckbox("In the Pet Journal", 32, 32, "TOPLEFT", lastcheckbox, "BOTTOMLEFT", 0, 0)

-- Text above the Tooltips region
local SpeciestipTitle = CreateFont("GameFontNormal", "In Tooltips, show...")
SpeciestipTitle:SetPoint("TOP", lastcheckbox, "BOTTOM", 40, 0)
SpeciestipTitle:SetTextColor(1, 1, 1, 1)

-- Make Speciestip checkboxes
local OptSpeciestipCurrent = CreateCheckbox("Current pet's species", 32, 32, "TOPLEFT", SpeciestipTitle, "BOTTOMLEFT", 0, 0)

-- Variable to store settings until window is closed in case user wants to 
local tempstorage

-- Disable dependent checkboxes if unchecked
local function BPSID_OptTooltipsEnabled_OnClick(self, button, down)
    
    -- If the checkbox is checked AND it was unchecked at one point in time (to create tempstorage!)
    if (OptTooltipsEnabled:GetChecked()) and (tempstorage) then
        
        -- Enable all tooltip-related checkboxes
        OptTooltipsBattleTooltip:Enable()
        OptTooltipsBPT:Enable()
        OptTooltipsFBPT:Enable()
        OptTooltipsPJT:Enable()
        OptSpeciestipCurrent:Enable()        
        
        -- Set them to their old values
        OptTooltipsBattleTooltip:SetChecked(tempstorage[1])
        OptTooltipsBPT:SetChecked(tempstorage[2])
        OptTooltipsFBPT:SetChecked(tempstorage[3])
        OptTooltipsPJT:SetChecked(tempstorage[4])
        OptSpeciestipCurrent:SetChecked(tempstorage[5])        
        
    elseif (not OptTooltipsEnabled:GetChecked()) then
        
        -- Update tempstorage with the current values from the checkboxes (before they get wiped)
        tempstorage = {
            OptTooltipsBattleTooltip:GetChecked(),
            OptTooltipsBPT:GetChecked(),
            OptTooltipsFBPT:GetChecked(),
            OptTooltipsPJT:GetChecked(),
            OptSpeciestipCurrent:GetChecked()            
        }
        
        -- Disable any tooltip-related checkboxes
        OptTooltipsBattleTooltip:Disable()
        OptTooltipsBPT:Disable()
        OptTooltipsFBPT:Disable()
        OptTooltipsPJT:Disable()
        OptSpeciestipCurrent:Disable()        
        
        -- Uncheck all tooltip-related checkboxes
        OptTooltipsBattleTooltip:SetChecked(nil)
        OptTooltipsBPT:SetChecked(nil)
        OptTooltipsFBPT:SetChecked(nil)
        OptTooltipsPJT:SetChecked(nil)
        OptSpeciestipCurrent:SetChecked(nil)        
    end
end

local function BPSID_Options_Refresh()
    -- Reset all the checkboxes to the old value
    OptTooltipsEnabled:SetChecked(BPSID_Options.Tooltips.Enabled)
    OptTooltipsBattleTooltip:SetChecked(BPSID_Options.Tooltips.BattleTooltip)
    OptTooltipsBPT:SetChecked(BPSID_Options.Tooltips.BPT)
    OptTooltipsFBPT:SetChecked(BPSID_Options.Tooltips.FBPT)
    OptTooltipsPJT:SetChecked(BPSID_Options.Tooltips.PJT)
    OptSpeciestipCurrent:SetChecked(BPSID_Options.Speciestip.Current)
    
    -- Call this to fix the checkboxes to their correct enabled state
    BPSID_OptTooltipsEnabled_OnClick()
end

function Options.refresh()
    BPSID_Options_Refresh()
end

function Options.default()
    
    tempstorage = nil
    
    BPSID_Options = {}
    
    BPSID_Options.Tooltips = {}
    BPSID_Options.Tooltips.Enabled = true -- Enable Battle Pet SpeciesID Tooltips
    BPSID_Options.Tooltips.BattleTooltip = true -- In Battle (PrimaryBattlePetUnitTooltip)
    BPSID_Options.Tooltips.BPT = true -- On Items (BattlePetTooltip)
    BPSID_Options.Tooltips.FBPT = true -- On Chat Links (FloatingBattlePetTooltip)
    BPSID_Options.Tooltips.PJT = true -- In the Pet Journal (GameTooltip)

    BPSID_Options.Speciestip = {}
    BPSID_Options.Speciestip.Current = true -- Current pet's species    
    
    -- Refresh the options page to display the new defaults
    BPSID_Options_Refresh()
end

function Options.okay()
    -- IF THE LAST TOOLTIP CALLED BEFORE THE OPTIONS ARE CHANGED HAS CHANGED FONT,
    -- BAD STUFF WILL HAPPEN SO CALL ORIGINAL FONT CHANGING FUNCTIONS IN OKAY BOX
    
    -- Clear storage for TooltipsEnabled remembering
    tempstorage = nil
        
    -- Retrieve the rest of the settings from the checkboxes
    BPSID_Options.Tooltips.Enabled = OptTooltipsEnabled:GetChecked()
    BPSID_Options.Tooltips.BattleTooltip = OptTooltipsBattleTooltip:GetChecked()
    BPSID_Options.Tooltips.BPT = OptTooltipsBPT:GetChecked()
    BPSID_Options.Tooltips.FBPT = OptTooltipsFBPT:GetChecked()
    BPSID_Options.Tooltips.PJT = OptTooltipsPJT:GetChecked()
    BPSID_Options.Speciestip.Current = OptSpeciestipCurrent:GetChecked()
        
    
    -- Reset fontsize for BattlePetTooltip if original font size known
    if (internal.BPTFontSize) then
        BattlePetTooltip.Name:SetFont(internal.BPTFontSize[1], internal.BPTFontSize[2], internal.BPTFontSize[3])
    end
        
    for i = 1, #PetJournalListScrollFrame.buttons do
          PetJournalListScrollFrame.buttons[i].name:SetFontObject("GameFontNormal")
    end
    
    -- A manual change has occurred (added in v1.0.8 to help update values added in new versions)
    BPSID_Options.ManualChange = GetAddOnMetadata(addonname, "Version")
    
    -- Refresh the options page to display the new values
    BPSID_Options_Refresh()
end

function Options.cancel()
    
    -- Clear storage for TooltipsEnabled remembering
    tempstorage = nil
    
    -- Refresh the options page to display the old settings
    BPSID_Options_Refresh()
end

OptTooltipsEnabled:SetScript("OnClick", BPSID_OptTooltipsEnabled_OnClick)

-- Add the options panel to the Blizzard list
InterfaceOptions_AddCategory(Options)