--[[
Written by: Agramonia@Chamber of Aspects-EU
Based on BattlePetBreedID by Simca@Malfurion and Hugh@Burning Blade
]]--

-- Get folder path and set addon namespace
local addonname, internal = ...

-- These global tables are used everywhere in the code and are absolutely required to be localized
local CPB = _G.C_PetBattles
local CPJ = _G.C_PetJournal

-- These basic lua functions are used in the calculations and must be localized due to the number and frequency of uses
local min = _G.math.min
local abs = _G.math.abs
local floor = _G.math.floor
local gsub = _G.gsub

-- These basic lua functions are used for Retrieving Breed Names
-- They're only used once but still important to localize due to the time sensitive nature of the task
local tostring = _G.tostring
local tonumber = _G.tonumber
local sub = _G.string.sub

-- Declare addon-wide cache variables
internal.cacheTime = true
internal.speciesCache = {}

-- Forward declaration of some simple hook status-check booleans
local PJHooked = false

-- Check if on future build or PTR to enable additional developer functions
local is_ptr = select(4, _G.GetBuildInfo()) ~= GetAddOnMetadata(addonname, "Interface")

-- Get information from pet journal and pass to calculation function
function GetSpeciesID_Journal(nPetID)
    if (nPetID) then
        -- Get information from pet journal
        local nHealth, nMaxHP, nPower, nSpeed, nQuality = CPJ.GetPetStats(nPetID)
        local nSpeciesID, _, nLevel = CPJ.GetPetInfoByPetID(nPetID);
        return nSpeciesID
    else
        return "ERR-PID" -- Should be impossible unless another addon calls it wrong (keeping for debug)
    end
end

-- Get pet stats at the start of battle before values change
function internal.CacheAllPets()
    for iOwner = 1, 2 do
        local IndexMax = CPB.GetNumPets(iOwner)
        for iIndex = 1, IndexMax do
            local nSpeciesID = CPB.GetPetSpeciesID(iOwner, iIndex)
            local nLevel = CPB.GetLevel(iOwner, iIndex)
            local nMaxHP = CPB.GetMaxHealth(iOwner, iIndex)
            local nPower = CPB.GetPower(iOwner, iIndex)
            local nSpeed = CPB.GetSpeed(iOwner, iIndex)
            local nQuality = CPB.GetBreedQuality(iOwner, iIndex)
            local wild = false
            local flying = false
            
            -- If pet is wild, add 20% hp to get the normal stat
            if (CPB.IsWildBattle() and iOwner == 2) then wild = true end
            
            -- Still have to account for flying passive apparently; can't get the stats snapshot before passive is applied
            if (CPB.GetPetType(iOwner, iIndex) == 3) then
                if (iOwner == 1) and ((CPB.GetHealth(iOwner, iIndex) / nMaxHP) > .5) then
                    flying = true
                elseif (iOwner == 2) then
                    flying = true
                end
            end
            
            -- Determine index of Cache arrays. accepted values are 1-6 with 1-3 being your pets and 4-6 being enemy pets
            local offset = 0
            if (iOwner == 2) then offset = 3 end
            
            internal.speciesCache[iIndex + offset] = nSpeciesID
        end
    end
end

-- Create event handling frame and register event(s)
local BPSID_Events = CreateFrame("FRAME", "BPSID_Events")
BPSID_Events:RegisterEvent("ADDON_LOADED")
BPSID_Events:RegisterEvent("PLAYER_LOGIN")
BPSID_Events:RegisterEvent("PLAYER_CONTROL_LOST")
BPSID_Events:RegisterEvent("PET_BATTLE_OPENING_START")
BPSID_Events:RegisterEvent("PET_BATTLE_CLOSE")

-- OnEvent handler function
local function BPSID_Events_OnEvent(self, event, name, ...)
    if (event == "ADDON_LOADED") and (name == addonname) then
        -- Create saved variables if missing
        if (not BPSID_Options) then
            BPSID_Options = {}
        end
        
        -- Otherwise, none exists at all, so set to default
        if (not BPSID_Options.format) then
            BPSID_Options.format = 3
        end
        
        -- If the obsolete format choices exist, update them to defaults
        if (BPSID_Options.format == 4) or (BPSID_Options.format == 5) or (BPSID_Options.format == 6) then BPSID_Options.format = 3 end
        
        -- Set the rest of the defaults
        if not (BPSID_Options.Tooltips) then            
            BPSID_Options.Tooltips = {}
            BPSID_Options.Tooltips.Enabled = true -- Enable Battle Pet SpeciesID Tooltips
            BPSID_Options.Tooltips.BattleTooltip = true -- In Battle (PrimaryBattlePetUnitTooltip)
            BPSID_Options.Tooltips.BPT = true -- On Items (BattlePetTooltip)
            BPSID_Options.Tooltips.FBPT = true -- On Chat Links (FloatingBattlePetTooltip)
            BPSID_Options.Tooltips.PJT = true -- In the Pet Journal (GameTooltip)
            
            BPSID_Options.Speciestip = {}
            BPSID_Options.Speciestip.Current = true -- Current pet's species            
            
            BPSID_Options.BattleFontFix = false -- Test old Pet Battle rarity coloring
        end
        
        if (BPSID_Options.ManualChange == nil) then
            BPSID_Options.ManualChange = false
        end
        
        -- Disable option unless user has manually changed it
        if (BPSID_Options.ManualChange ~= GetAddOnMetadata(addonname, "Version")) then
            BPSID_Options.BattleFontFix = false
        end
        
        -- If this addon loads after the Pet Journal
        if (PetJournalPetCardPetInfo) then
            
            -- Hook into the OnEnter script for the frame that calls GameTooltip in the Pet Journal
            PetJournalPetCardPetInfo:HookScript("OnEnter", internal.Hook_PJTEnter)
            
            -- Set boolean
            PJHooked = true
        end
        
        -- If this addon loads after ArkInventory
        if (ArkInventory) and (ArkInventory.TooltipSetBattlepet) then
            
            -- Hook ArkInventory's Battle Pet tooltips
            hooksecurefunc(ArkInventory, "TooltipSetBattlepet", internal.Hook_ArkInventory)
        end
    elseif (event == "ADDON_LOADED") and (name == "Blizzard_Collections") then
        -- If the Pet Journal loads on demand correctly (when the player opens it)
        if (PetJournalPetCardPetInfo) then
            
            -- Hook into the OnEnter script for the frame that calls GameTooltip in the Pet Journal
            PetJournalPetCardPetInfo:HookScript("OnEnter", internal.Hook_PJTEnter)
            
            -- Set boolean
            PJHooked = true
        end
    elseif (event == "ADDON_LOADED") and (name == "ArkInventory") then    
        -- If this addon loads before ArkInventory
        if (ArkInventory) and (ArkInventory.TooltipSetBattlepet) then
            
            -- Hook ArkInventory's Battle Pet tooltips
            hooksecurefunc(ArkInventory, "TooltipSetBattlepet", internal.Hook_ArkInventory)
        end
    elseif (event == "PLAYER_LOGIN") then
        -- Hook PJ PetCard here
        if (PetJournalPetCardPetInfo) and (not PJHooked) then
            
            -- Hook into the OnEnter script for the frame that calls GameTooltip in the Pet Journal
            PetJournalPetCardPetInfo:HookScript("OnEnter", internal.Hook_PJTEnter)
            
            -- Set boolean
            PJHooked = true
        end
        
        -- Check for presence of LibStub (pretty messy)
        if _G["LibStub"] then
            
            -- Access LibStub
            internal.LibStub = _G["LibStub"]
            
            -- Attempt to access LibExtraTip
            internal.LibExtraTip = internal.LibStub("LibExtraTip-1", true)
        end
    elseif (event == "PLAYER_CONTROL_LOST") then
        
        -- Set this boolean so internal.CacheAllPets() will fire
        internal.cacheTime = true
    elseif (event == "PET_BATTLE_OPENING_START") then
        
        -- Set this boolean so internal.CacheAllPets() will fire
        internal.cacheTime = false
    elseif (event == "PET_BATTLE_CLOSE") then
        
        -- Erase cache
        for i = 1, 6 do
            internal.speciesCache[i] = 0            
        end
        
        -- Set this boolean so internal.CacheAllPets() will fire
        internal.cacheTime = true
    end
end

-- Set our event handler function
BPSID_Events:SetScript("OnEvent", BPSID_Events_OnEvent)

-- Create slash commands
SLASH_BATTLEPETSPECIESID1 = "/battlepetspeciesID"
SLASH_BATTLEPETSPECIESID2 = "/BPSID"
SLASH_BATTLEPETSPECIESID3 = "/speciesID"
SlashCmdList["BATTLEPETSPECIESID"] = function(msg)
    InterfaceOptionsFrame:Show()
    InterfaceOptionsFrameTab2:Click()
    
    local i = 1
    local currAddon = "InterfaceOptionsFrameAddOnsButton" .. i
    while _G[currAddon] do
        if (_G[currAddon]:GetText() == "Battle Pet SpeciesID") then _G[currAddon]:Click() break end
        i = i + 1
        currAddon = "InterfaceOptionsFrameAddOnsButton" .. i
    end
end