if not BastasTools then return end;



--[[----------------------------------------------------------------------------
Reminder Frame
------------------------------------------------------------------------------]]
local frame = CreateFrame("Frame", "BTTalentReminderFrame", UIParent);
frame:ClearAllPoints();
frame:SetHeight(300);
frame:SetWidth(300);
frame:SetPoint("CENTER",0,300);
frame:Hide();
frame.text = frame:CreateFontString(nil,"BACKGROUND","PVPInfoTextFont");
--frame.text:SetAllPoints();
frame.text:SetPoint("BOTTOM");

local button = CreateFrame('Button', 'BTTalentReminderFrameClose', frame, "UIPanelButtonTemplate")
button:SetSize(64, 24)
button:SetPoint('BOTTOM',frame.text,"BOTTOM",0,-24);
button:SetText("Got it!");
button:Show();
button:SetScript('OnClick', function()
   frame:Hide();
end)

local function showmsg(message)
	frame.text:SetText(message);
	button:SetPoint('BOTTOM',frame.text,"BOTTOM",0,-24);
	frame:Show();
end

 

--[[----------------------------------------------------------------------------
Subzone Lookup
------------------------------------------------------------------------------]]
local lookup = {
	["Edge of Discord"] = "boss1",
	["Den of the Devourers"] = "boss2",
	["Gaze of the Legion"] = "boss3",
	["Halls of the Boundless Reach"] = "boss4",
	["Elarian Sanctuary"] = "boss5",
	["The Exhaust"] = "boss6",
	["The Hallowed Felworks"] = "boss7",
	["Chamber of Anguish"] = "boss8",
	["Temple of Anguish"] = "boss9",
	["The World Soul"] = "boss10",
	["Seat of the Pantheon"] = "boss11"
}

local bosses = {
	["boss1"] = "Garothi Worldbreaker",
	["boss2"] = "Felhounds of Sargeras",
	["boss3"] = "Antoran High Command",
	["boss4"] = "Portal Keeper Hasabel",
	["boss5"] = "Eonar the Life-Binder",
	["boss6"] = "Imonar the Soulhunter",
	["boss7"] = "Kin'garoth",
	["boss8"] = "Varimathras",
	["boss9"] = "The Coven of Shivarra",
	["boss10"] = "Aggramar",
	["boss11"] = "Argus the Unmaker"
}



--[[----------------------------------------------------------------------------
Query Expected Talent Rows
------------------------------------------------------------------------------]]
function BastasTools:GetExpectedTalentName(expected,key,rownum)
	local currentSpec = GetSpecialization();
	local available, selected = GetTalentTierInfo(rownum, 1)
	selected = available and selected or 0;
	if ( expected[key] and expected[key] ~= 0 and expected[key] ~= selected ) then
		local name = select(2,GetTalentInfoBySpecialization(currentSpec,rownum,expected[key]));
		return name;
	end
	return "";
end
			
			
			
--[[----------------------------------------------------------------------------
Event Handler
------------------------------------------------------------------------------]]
function BastasTools:CheckTalentReminders()
	local k = GetSubZoneText();
	if ( lookup[k] ) then
		local boss_id = lookup[k];
		local boss_name = bosses[boss_id];
		local msg = "";
		
		BastasTools.db.profile.reminders = BastasTools.db.profile.reminders or {};
		local expected = BastasTools.db.profile.reminders[boss_id];
				
		local currentSpec = GetSpecialization();		
		if ( expected and tostring(expected.specialization) == tostring(currentSpec)) then --check mainspec
			
			--talent line
			local talentNeeds = {};
			local keys = {"talent15","talent30","talent45","talent60","talent75","talent90","talent100"}
			for i=1,7,1 do
				local expectedTalent = BastasTools:GetExpectedTalentName(expected,keys[i],i);
				if ( expectedTalent and expectedTalent ~= "" ) then
					table.insert(talentNeeds,expectedTalent);
				end
			end
			local talentLine = table.concat(talentNeeds,", ");
			if ( talentLine and talentLine ~= "" ) then
				msg = msg .. talentLine .. "\n";
			end
			
			--equipped items line			
			local expectedItems = {};
			if ( expected.legendary1 and tonumber(expected.legendary1)) then
				expectedItems[tonumber(expected.legendary1)] = true;
			end
			if ( expected.legendary2 and tonumber(expected.legendary2)) then
				expectedItems[tonumber(expected.legendary2)] = true;
			end			
			for id in (expected.trinkets or ""):gmatch("(%d+)") do
				local k = tonumber(id) or 0;
				expectedItems[k] = true;
			end
			
			for i=1,20,1 do
				local id = GetInventoryItemID("player",i) or 0;
				expectedItems[id] = false;
			end
			expectedItems[0] = false;
			
			local itemNeeds = {};
			for k,v in pairs(expectedItems) do
				if ( v ) then
					local itemName = GetItemInfo(k) or "";
					if ( itemName and itemName ~= "" ) then
						table.insert(itemNeeds,itemName)
					end
				end
			end
			local itemsLine = table.concat(itemNeeds,", ");
			if ( itemsLine and itemsLine ~= "" ) then
				msg = msg .. itemsLine .. "\n";
			end
		end
		
		if ( msg and msg ~= "" ) then
			--boss name line
			msg = boss_name .. "\n\n" .. msg;
			
			showmsg(msg);
			return;
		end
	end
	frame:Hide();
end







--[[----------------------------------------------------------------------------
Initialization
------------------------------------------------------------------------------]]
function BastasTools:InitTalentReminders()
	self:RegisterEvent("PLAYER_TALENT_UPDATE", self.CheckTalentReminders);
	self:RegisterEvent("PLAYER_EQUIPMENT_CHANGED", self.CheckTalentReminders);
	self:RegisterEvent("ZONE_CHANGED_INDOORS", self.CheckTalentReminders);	
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", self.CheckTalentReminders);	
	self:RegisterEvent("ZONE_CHANGED", self.CheckTalentReminders);	
	self:RegisterEvent("WORLD_MAP_NAME_UPDATE", self.CheckTalentReminders);	
end












