if not BastasTools then return end



--[[----------------------------------------------------------------------------
Update Filter Log
------------------------------------------------------------------------------]]
local filteredLogSize = 100

function BastasTools:AddToFilterLog(message,sender)
	BastasTools.db.global.filteredLog = BastasTools.db.global.filteredLog or {}
	local logentry = sender..": "..message;
	
	local n = table.getn(BastasTools.db.global.filteredLog);
	for k,v in pairs(BastasTools.db.global.filteredLog) do
		if v == logentry then
			return;
		end
	end
	
	if ( n >= filteredLogSize ) then
		table.remove(BastasTools.db.global.filteredLog,1);
	end
	table.insert(BastasTools.db.global.filteredLog,logentry);
	
	if ( BastasTools.db.global.debugFilters ) then
		DEFAULT_CHAT_FRAME:AddMessage("|cff00fbf6[SilentMute]|r "..logentry,1,1,1);
	end
end

function BastasTools:ClearFilterLog()
	BastasTools.db.global.filteredLog = {};
end


--[[----------------------------------------------------------------------------
Setup Filter Tables
------------------------------------------------------------------------------]]
local trade = {};
local names = {};
local tradeStr = "";
local nameStr = "";

--characters that require an escape character for lua pattern matching
local function isSpecial(c)
	return ( c=="%" or c=="." or c=="(" or c==")" or c=="+" or c=="-" or c=="*" or c=="?" or c=="[" or c=="^" or c=="$" );
end

function BastasTools.GetTrade()
	return trade;
end

function BastasTools:SetupSilentMuteFilters()
	if ( BastasTools.db.global.nameFilterStr ~= nameStr ) then
		names = {};
		nameStr = BastasTools.db.global.nameFilterStr;
		if ( nameStr ) then
			local nameStrPadded = tostring(nameStr).."\n";
			for line in nameStrPadded:gmatch("(.-)\n") do
				local str = string.gsub(line,"%-","%%-");
				table.insert(names,string.lower(str));
			end
		end
	end
	
	if ( BastasTools.db.global.tradeFiltersStr ~= tradeStr ) then
		trade = {};
		tradeStr = BastasTools.db.global.tradeFiltersStr;
		if ( tradeStr ) then
			local tradeStrPadded = tostring(tradeStr).."\n";
			for line in tradeStrPadded:gmatch("(.-)\n") do
				local pat = "";
				for c in line:gmatch(".") do
					if ( c:lower() ~= c:upper() ) then
						pat = pat.."["..c:lower()..c:upper().."]" 
					elseif ( isSpecial(c) ) then
						pat = pat.."%"..c;
					else
						pat = pat..c;
					end
				end
				table.insert(trade,pat);
			end
		end
	end
end



--[[----------------------------------------------------------------------------
Filter Functions
------------------------------------------------------------------------------]]
function SilentMute_TradeFilter(self,event,...) 
	local filtered = false;
	local msg = arg1 or select(1, ...) or "";
	local author = arg2 or select(2,...) or "";
	local zoneID = arg7 or select(7, ...) or 0;
	if ( BastasTools.db.global.enableFilters and ( zoneID == 1 or zoneID == 2 ) ) then 
		BastasTools:SetupSilentMuteFilters()
		for _,f in pairs(trade) do
			if ( string.len(f)>=3 and string.find(msg,f) ) then
				filtered = true;
				break;
			end
		end
	end
	
	if ( filtered ) then
		BastasTools:AddToFilterLog(msg,author);
	end
	
	return filtered;
end

function SilentMute_NameFilter(self,event,...) 
	local filtered = false;
	local msg = arg1 or select(1, ...) or "";
	local author = arg2 or select(2,...) or "";
	local zoneID = arg7 or select(7, ...) or 0;
	
	author = string.lower(author);
	
	if ( BastasTools.db.global.enableFilters ) then
		BastasTools:SetupSilentMuteFilters()
		for _,f in pairs(names) do
			local blocked_name = string.lower(f);
			if ( string.len(blocked_name)>=3 and string.find(author,blocked_name) ) then
				filtered = true;
				break;
			end
		end
	end
	
	if ( filtered ) then
		BastasTools:AddToFilterLog(msg,author);
	end
	
	return filtered;
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", SilentMute_TradeFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL", SilentMute_NameFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER", SilentMute_NameFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY", 	SilentMute_NameFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL", 	SilentMute_NameFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_EMOTE", 	SilentMute_NameFilter);
