if not BastasTools then return end
local scm = SendChatMessage;
local isPlayerInVoidForm = false;
local voidFormSpell = 194249;
local addonPrefix = "BT_SPTranslator";

--[[----------------------------------------------------------------------------
Queue Data Structure
------------------------------------------------------------------------------]]
local Queue = {};
function Queue.new()
	return {index = 0};
end

function Queue.is_empty(queue)
	return queue.index == 0;
end

function Queue.push(queue, value)
	queue.index = queue.index+1;
	queue[queue.index] = value;
end

function Queue.pop(queue)
	if ( queue and not Queue.is_empty(queue) ) then
		queue.index = queue.index-1;
		return queue[queue.index+1];
	end
	return false;
end



--[[----------------------------------------------------------------------------
Helper Funcs
------------------------------------------------------------------------------]]
local function isTranslatableChatType(chatType) 
	return chatType == "SAY" or chatType == "YELL" or chatType == "RAID" or chatType == "PARTY";
end

local function PlayerHasVoidForm()
	local i;
	for i=0,40,1 do
		local name, icon, count, dispelType, duration, expires, caster, isStealable, nameplateShowPersonal, spellId = UnitAura("Player",i);
		if ( name and spellId and tonumber(spellId) == voidFormSpell) then
			return true;
		end
	end
	return false;
end




--[[----------------------------------------------------------------------------
Chat Filter
------------------------------------------------------------------------------]]
local TranslationQueue = {};
local function HandleChatMessage(message,sender,timeStamp)
	--print("["..sender.."] (VoidForm): "..message);
	TranslationQueue[sender] = TranslationQueue[sender] or Queue.new();
	Queue.push(TranslationQueue[sender],{message=message, timeStamp=timeStamp});
end

local function ShadowTranslatorFilter( self, event, message, sender, ... ) 
	if (event and message and sender ) then
		if TranslationQueue[sender] and BastasTools.db.global.enableShadowPriestTranslator then
			while ( not Queue.is_empty(TranslationQueue[sender]) ) do
				local tbl = Queue.pop(TranslationQueue[sender]);
				if ( not tbl ) then
					break;
				end
				
				local newMsg = tbl.message;
				local ts = tbl.timeStamp;
				
				if ( math.abs(ts-GetTime()) < 0.5 ) then
					return false, newMsg, sender, ...;
				end
			end
		end
	end
	return false;
end



--[[----------------------------------------------------------------------------
Hook SendChatMessage
------------------------------------------------------------------------------]]
ShadowTranslatorHooked = ShadowTranslatorHooked or false;
if not ShadowTranslatorHooked then
	ShadowTranslatorHooked = true;
	
	function SendChatMessage(text, chatType, languageIndex, channel, ...)
		if ( isPlayerInVoidForm and isTranslatableChatType(chatType) and BastasTools.db.global.enableShadowPriestTranslator ) then
			SendAddonMessage(addonPrefix, text, "RAID");
		end
	
		scm(text, chatType, languageIndex, channel, ...);
	end
	
	C_ChatInfo.RegisterAddonMessagePrefix(addonPrefix);
end



--[[----------------------------------------------------------------------------
Setup Events
------------------------------------------------------------------------------]]
local function ShadowPriestTranslaterEvent(event, prefix, message, channel, sender, ...)
	if ( event == "UNIT_AURA" ) then
		isPlayerInVoidForm = PlayerHasVoidForm();
	elseif ( event == "CHAT_MSG_ADDON" and prefix == addonPrefix ) then
		HandleChatMessage(message,sender,GetTime());
	end
end

function BastasTools:InitShadowPriestTranslator()
	self:RegisterEvent("UNIT_AURA",ShadowPriestTranslaterEvent);
	self:RegisterEvent("CHAT_MSG_ADDON",ShadowPriestTranslaterEvent);
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_SAY",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_YELL",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY",ShadowTranslatorFilter);
ChatFrame_AddMessageEventFilter("CHAT_MSG_PARTY_LEADER",ShadowTranslatorFilter);



