if not ElvUI then return end;
if not ElvUI[1] then return end;
if not BastasTools then return end;

local E = ElvUI[1];
local UF = E:GetModule('UnitFrames');
local LSM = LibStub("LibSharedMedia-3.0")

--WoW API / Variables
local UnitIsUnit = UnitIsUnit
local UnitReaction = UnitReaction
local UnitIsPlayer = UnitIsPlayer
local UnitClass = UnitClass
local RAID_CLASS_COLORS = RAID_CLASS_COLORS
local FACTION_BAR_COLORS = FACTION_BAR_COLORS

--[[----------------------------------------------------------------------------
Glow Frame Util
------------------------------------------------------------------------------]]
local function getFrameLookup(guid)
	if ( guid ) then
		for _,frame in pairs(ElvUF.objects) do
			if (frame and frame.unit and UnitGUID(frame.unit) == guid and frame:IsVisible() and
				(frame.unitframeType == "raid" or frame.unitframeType == "party" or frame.unitframeType == "raid40")
            ) then
				return frame;
			end
		end
	end
	return nil;
end

local tGuids = {};

local function glowOn(guid,c)
	local f = getFrameLookup(guid);
	if ( not f ) then 
		return;
	end

	if ( f ) then
		f.CustomGlow:SetBackdropBorderColor(c.r, c.g, c.b, 1);
		f.CustomGlow.powerGlow:SetBackdropBorderColor(c.r, c.g, c.b, 1);
		
		if ( not f.CustomGlow:IsVisible() ) then
			f.CustomGlow:Show();
			tGuids[guid] = true;
			if f.USE_POWERBAR_OFFSET then
				f.CustomGlow.powerGlow:Show()
			end
		end
	end
end

local function glowOff(guid)
	local f = getFrameLookup(guid);
	if ( not f ) then 
		return;
	end
	
	if ( f and f.CustomGlow and f.CustomGlow:IsVisible() ) then
		f.CustomGlow:Hide();
		f.CustomGlow.powerGlow:Hide();
		tGuids[guid] = false;
	end
end


local function allGlowsOff() 
	for guid,isOn in pairs(tGuids) do
		if ( isOn ) then
			glowOff(guid);
		end
	end
end


--[[----------------------------------------------------------------------------
Frame Construction
------------------------------------------------------------------------------]]
local t = 3;
local function Configure_CustomGlow(frame)
	if not frame.VARIABLES_SET or not frame.CustomGlow then return end --?
	SHADOW_SPACING = t*3; --frame.SHADOW_SPACING;
	local targetHealthGlow = frame.CustomGlow
	local targetPowerGlow = frame.CustomGlow.powerGlow
	targetHealthGlow:ClearAllPoints()
	if frame.USE_POWERBAR_OFFSET then
		if frame.ORIENTATION == "RIGHT" then
			targetHealthGlow:Point("TOPLEFT", frame.Health.backdrop, "TOPLEFT", -SHADOW_SPACING - frame.SPACING, SHADOW_SPACING + frame.SPACING + (frame.USE_CLASSBAR and (frame.USE_MINI_CLASSBAR and 0 or frame.CLASSBAR_HEIGHT) or 0))
			targetHealthGlow:Point("BOTTOMRIGHT", frame.Health.backdrop, "BOTTOMRIGHT", SHADOW_SPACING + frame.SPACING, -SHADOW_SPACING - frame.SPACING)
		else
			targetHealthGlow:Point("TOPLEFT", frame.Health.backdrop, "TOPLEFT", -SHADOW_SPACING - frame.SPACING, SHADOW_SPACING + frame.SPACING + (frame.USE_CLASSBAR and (frame.USE_MINI_CLASSBAR and 0 or frame.CLASSBAR_HEIGHT) or 0))
			targetHealthGlow:Point("BOTTOMRIGHT", frame.Health.backdrop, "BOTTOMRIGHT", SHADOW_SPACING + frame.SPACING, -SHADOW_SPACING - frame.SPACING)
		end

		targetPowerGlow:ClearAllPoints()
		targetPowerGlow:Point("TOPLEFT", frame.Power.backdrop, "TOPLEFT", -SHADOW_SPACING - frame.SPACING, SHADOW_SPACING + frame.SPACING)
		targetPowerGlow:Point("BOTTOMRIGHT", frame.Power.backdrop, "BOTTOMRIGHT", SHADOW_SPACING + frame.SPACING, -SHADOW_SPACING - frame.SPACING)
	else
		targetHealthGlow:Point("TOPLEFT", -SHADOW_SPACING, SHADOW_SPACING-(frame.USE_MINI_CLASSBAR and frame.CLASSBAR_YOFFSET or 0))

		if frame.USE_MINI_POWERBAR then
			targetHealthGlow:Point("BOTTOMLEFT", -SHADOW_SPACING, -SHADOW_SPACING + (frame.POWERBAR_HEIGHT/2))
			targetHealthGlow:Point("BOTTOMRIGHT", SHADOW_SPACING, -SHADOW_SPACING + (frame.POWERBAR_HEIGHT/2))
		else
			targetHealthGlow:Point("BOTTOMLEFT", -SHADOW_SPACING, -SHADOW_SPACING)
			targetHealthGlow:Point("BOTTOMRIGHT", SHADOW_SPACING, -SHADOW_SPACING)
		end
	end
	
	
	
end

local function CreateThickShadow(f)
	if f.shadow then return end
	borderr, borderg, borderb = 0, 0, 0
	backdropr, backdropg, backdropb = 0, 0, 0

	local shadow = CreateFrame("Frame", nil, f)
	shadow:SetOutside(f, t*3, t*3)
	shadow:SetFlattensRenderLayers(false);
	shadow:SetBackdrop( {
		edgeFile = LSM:Fetch("border", "ElvUI GlowBorder"), edgeSize = t*3,
		insets = {left = t*5, right = t*5, top = t*5, bottom = t*5},
	})
	shadow:SetBackdropColor(backdropr, backdropg, backdropb, 0)
	shadow:SetBackdropBorderColor(borderr, borderg, borderb, 0.9)
	shadow:Hide();
	f.shadow = shadow
	return f;
end

local function CreateOverlay(f)
	if f.btoverlay then return end;
	f.btoverlay = f:CreateTexture();
	f.btoverlay:SetAllPoints(f)
	f.btoverlay:SetTexture(1,1,1,0);
	--f.btoverlay:SetFrameStrata("HIGH");
	--f.btoverlay:SetFrameLevel(1);
	f.btoverlay:Hide();
end

function UF:Construct_CustomGlow(frame)	
	frame = CreateThickShadow(frame)
	local x = frame.shadow
	frame.shadow = nil
	x:SetFrameStrata("HIGH")
	x:SetFrameLevel(1)
	x:Hide();

	--Secondary TargetGlow, for power frame when using power offset
	frame = CreateThickShadow(frame)
	local shadow = frame.shadow
	shadow:SetFrameStrata("HIGH")
	shadow:SetFrameLevel(1)
	x.powerGlow = shadow
	frame.shadow = nil
	
	return x
end

local function Construct_GlowFrames(...)
	if ElvUF then
        for _,frame in pairs(ElvUF.objects) do
			if (frame and frame.unit and not frame._initCustomGlow and
				(frame.unitframeType == "raid" or frame.unitframeType == "party" or frame.unitframeType == "raid40")
            ) then
				frame._initCustomGlow = true;
				frame.CustomGlow = UF:Construct_CustomGlow(frame);
				Configure_CustomGlow(frame);
            end
        end
    end
end


--[[----------------------------------------------------------------------------
Events
------------------------------------------------------------------------------]]
local function CLEU_UpdateGlow(_,...)
	if ( not BastasTools.db.global.enableElvGlow ) then
		return;
	end
	local timestamp, event, hideCaster,sourceGUID,sourceName,sourceFlags,sourceRaidFlags,destGUID,destName,destFlags,destRaidFlags,spellId,spellName = CombatLogGetCurrentEventInfo();
	local t = BastasTools.db.global.ElvGlowHighlights or {};
	if ( event == "SPELL_AURA_APPLIED" and t[spellName]) then
		glowOn(destGUID,t[spellName]);
	elseif ( event == "SPELL_AURA_REMOVED" and t[spellName]) then
		glowOff(destGUID);
	end
end

	
function BastasTools:InitElvGlow()
	self:RegisterEvent("PLAYER_ENTERING_WORLD",Construct_GlowFrames);
	self:RegisterEvent("RAID_ROSTER_UPDATE",Construct_GlowFrames);
	self:RegisterEvent("GROUP_ROSTER_UPDATE",Construct_GlowFrames);
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED",CLEU_UpdateGlow);
	self:RegisterEvent("PLAYER_REGEN_ENABLED",allGlowsOff);
end












