BastasTools = LibStub("AceAddon-3.0"):NewAddon("BastasTools", "AceConsole-3.0", "AceEvent-3.0")


--[[----------------------------------------------------------------------------
Colors
------------------------------------------------------------------------------]]
local function Color(r,g,b,a)
	local t = {};
	t.r = r;
	t.g = g;
	t.b = b;
	t.a = a or 1;
	return t;
end

local colors = {};
colors.dk		= Color(.77,.12,.23);
colors.dh 		= Color(.64,.19,.79);
colors.druid 	= Color(1,.49,.04);
colors.hunter 	= Color(.67,.83,.45);
colors.mage 	= Color(.41,.8,.94);
colors.monk		= Color(0,1,.59);
colors.paladin	= Color(.96,.55,.73);
colors.priest	= Color(1,1,1);
colors.rogue	= Color(1,.96,.41);
colors.shaman	= Color(0,.44,.87);
colors.warlock	= Color(.58,.51,.79);
colors.warrior	= Color(.78,.61,.43);
colors.moon		= Color(.8,.8,1);

local iconColor = {};
iconColor[1] = colors.rogue;
iconColor[2] = colors.druid;
iconColor[3] = colors.warlock;
iconColor[4] = colors.hunter;
iconColor[5] = colors.moon;
iconColor[6] = colors.mage;
iconColor[7] = colors.dk;
iconColor[8] = colors.priest;



--[[----------------------------------------------------------------------------
Defaults
------------------------------------------------------------------------------]]
local defaults = {
	global = {
		nameFilterStr="",
		tradeFiltersStr="",
		enableFilters=true,
		debugFilters=false,
		filteredLog = {},
		
		enableAutoMathWhispers=true,
		autoMathGuildAndOfficer=true,
		autoMathSay=true,
		autoMathTradeAndGeneral=false,
		autoMathRaidAndInstance=false,
		autoMathSilent=true,
		
		enableShadowPriestTranslator=true,
		
		enableElvGlow=false,
		ElvGlowHighlights={
			["Empowered Pulse Grenade"] = colors.moon,
			["Ravenous Blaze"] = colors.moon,
			["Soulblight"] = colors.moon,
			["Sentence of Sargeras"] = colors.moon,
			["Crushing Fear"] = colors.druid,
			["Unleashed Rage"] = colors.druid		
		}
	}
}



--[[----------------------------------------------------------------------------
Talent Reminder Option Helpers
------------------------------------------------------------------------------]]
local function SetReminder(info,value)
	local boss = info[#info-1];
	local setting = info[#info];
	if ( boss and setting ) then
		BastasTools.db.profile.reminders = BastasTools.db.profile.reminders or {};
		BastasTools.db.profile.reminders[boss] = BastasTools.db.profile.reminders[boss] or {};
		BastasTools.db.profile.reminders[boss][setting] = value;
	end
end

local function GetReminder(info)
	local boss = info[#info-1] or nil;
	local setting = info[#info] or nil;
	
	if ( boss and setting ) then
		BastasTools.db.profile.reminders = BastasTools.db.profile.reminders or {};
		BastasTools.db.profile.reminders[boss] = BastasTools.db.profile.reminders[boss] or {};
		return BastasTools.db.profile.reminders[boss][setting];
	end
	return false;
end

local function SetReminderRadio(info,value,isSelected)
	if ( isSelected ) then
		SetReminder(info,value);
	end
end

local function GetTalentOptionsRow(info,row)
	local boss = info[#info-1];
	local setting = "specialization";
	local specid;
	if ( boss and setting ) then
		BastasTools.db.profile.reminders = BastasTools.db.profile.reminders or {};
		BastasTools.db.profile.reminders[boss] = BastasTools.db.profile.reminders[boss] or {};
		specid = BastasTools.db.profile.reminders[boss][setting];
	end
	specid = specid or 1;
	
	local t = {};
	t[0] = "";
	for i=1,3,1 do
		local name = select(2,GetTalentInfoBySpecialization(specid,row,i));
		if ( name ) then
			t[i] = name;
		end
	end
	return t;	
end

local function GetLegendaryOptions(info)
	local _,_,classID = UnitClass("player");
	C_LootJournal.SetClassAndSpecFilters(classID,0);
	
	local t = {};
	local t_legendaries = C_LootJournal.GetFilteredLegendaries();
	
	table.sort(t_legendaries,function(a,b) return a and b and a.name < b.name end)
	
	for k,v in ipairs(t_legendaries) do
		t[v.itemID] = v.name
	end
	
	t[0] = "";
	return t;
end



--[[----------------------------------------------------------------------------
Options
------------------------------------------------------------------------------]]
local elvglow_adddebuff = "";
local elvglow_adddebuffcolor = Color(1,1,1);
local options = {
	name = "Bastas Tools",
	handler = BastasTools,
	childGroups = "tab",
	type = "group",
	args = {
		SilentMute = {
			name = "Silent Mute",
			desc = "Silently block trade/general/whisper messages by keyword or player name.",
			type = "group",
			childGroups  = "tab",
			args = {
				openFilterOptions = {
					name = "Options",
					desc = "Setup filtering options.",
					type = "group",
					args = {
						nameFilters = {
							name = "Name Filters",
							desc = "Block messages from players on this list. Put one name per line. Case insensitive. Including the realm is optional. Example: Player-Realm or just Player",
							type = "input",
							order = 3,
							multiline = 20,
							get = function(info) return BastasTools.db.global.nameFilterStr end,
							set = function(info,val) BastasTools.db.global.nameFilterStr = val end
						},
						tradeFilters = {
							name = "Trade/General Chat Filters",
							desc = "Block text containing keywords or phrases. Case insensitive. Put one keyword/phrase per line.",
							type = "input",
							order = 4,
							multiline = 20,
							get = function(info) return BastasTools.db.global.tradeFiltersStr end,
							set = function(info,val) BastasTools.db.global.tradeFiltersStr = val end
						},
						enableFilters = {
							name = "Enabled",
							desc = "Allow the silent mute module to filter out annoying messages.",
							type = "toggle",
							order = 1,
							width = "full",
							get = function(info) return BastasTools.db.global.enableFilters end,
							set = function(info,val) BastasTools.db.global.enableFilters = val end
						},
						debugFilters = {
							name = "Debug Mode",
							desc = "When a message is filtered, display debug information.",
							type = "toggle",
							order = 2,
							width = "full",
							get = function(info) return BastasTools.db.global.debugFilters end,
							set = function(info,val) BastasTools.db.global.debugFilters = val end
						}
					}
				},				
				openFilterLog = {
					name = "Log",
					desc = "View the 100 most-recently blocked messages",
					type = "group",
					args = {
						filterLog = {
							name = "Blocked Messages",
							desc = "The 100 most-recently blocked messages.",
							type = "input",
							width = "full",
							multiline = 25,
							disabled = true,
							descStyle = "inline",
							get = function(info) 
								local txt = table.concat(BastasTools.db.global.filteredLog,"\n");
								if ( txt and txt ~= "" ) then return txt end;
								return "no messages in log.";
							end
						},
						clearLog = {
							name = "Clear",
							desc = "Clear log of blocked messages.",
							type = "execute",
							func = function(info) 
								BastasTools:ClearFilterLog() 
							end
						}
					}
				}
			}
		},
		TalentReminder = {
			name = "Talent Reminders",
			desc = "Remind yourself to use certain talents and legendaries on certain bosses.",
			type = "group",
			args = {
				boss1 = {
					name = "01 Garothi WorldBreaker",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},		
				boss2 = {
					name = "02 Felhounds of Sargeras",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},		
				boss3 = {
					name = "03 Antoran High Command",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},		
				boss4 = {
					name = "04 Portal Keeper Hasabel",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},	
				boss5 = {
					name = "05 Eonar the Life-Binder",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},
				boss6 = {
					name = "06 Imonar the Soulhunter",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},	
				boss7 = {
					name = "07 Kin'garoth",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},	
				boss8 = {
					name = "08 Varimathras",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},					
				boss9 = {
					name = "09 The Coven of Shivarra",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},	
				boss10 = {
					name = "10 Aggramar",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					},
				},		
				boss11 = {
					name = "11 Argus",
					type = "group",
					args = {
						specialization = {
							name = "Main Spec",
							desc = "The primary specialization you use for this encounter.",
							type = "select",
							style = "radio",
							order = 0,
							values = function()
								local t = {};
								for i=1,4,1 do
									local spec = select(2,GetSpecializationInfo(i));
									if ( spec ) then
										t[i] = spec;
									end
								end
								return t;
							end,
							get = GetReminder,
							set = SetReminderRadio
						},
						talent15 = {
							name = "15",
							desc = "Level 15 talent",
							type = "select",
							order = 1,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,1) end,
							get = GetReminder,
							set = SetReminder
						},
						talent30 = {
							name = "30",
							desc = "Level 30 talent",
							type = "select",
							order = 2,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,2) end,
							get = GetReminder,
							set = SetReminder
						},
						talent45 = {
							name = "45",
							desc = "Level 45 talent",
							type = "select",
							order = 3,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,3) end,
							get = GetReminder,
							set = SetReminder
						},
						talent60 = {
							name = "60",
							desc = "Level 60 talent",
							type = "select",
							order = 4,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,4) end,
							get = GetReminder,
							set = SetReminder
						},
						talent75 = {
							name = "75",
							desc = "Level 75 talent",
							type = "select",
							order = 5,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,5) end,
							get = GetReminder,
							set = SetReminder
						},
						talent90 = {
							name = "90",
							desc = "Level 90 talent",
							type = "select",
							order = 6,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,6) end,
							get = GetReminder,
							set = SetReminder
						},
						talent100 = {
							name = "100",
							desc = "Level 100 talent",
							type = "select",
							order = 7,
							style = "dropdown",
							values = function(info) return GetTalentOptionsRow(info,7) end,
							get = GetReminder,
							set = SetReminder
						},
						legendary1 = {
							name = "Legendary 1",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 8,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						legendary2 = {
							name = "Legendary 2",
							desc = "Check for an equipped legendary",
							type = "select",
							order = 9,
							width = "double",
							style = "dropdown",
							values = GetLegendaryOptions,
							get = GetReminder,
							set = SetReminder
						},
						trinkets = {
							name = "Additional Items",
							desc = "Check for additional items using comma-separated item ids. Ex: 1001,1002,1003",
							type = "input",
							order = 10,
							width = "double",
							get = GetReminder,
							set = SetReminder					
						}
					}
				}					
			}
		},
		AutoMath = {
			name = "Auto Math",
			desc = "Automatically compute solutions to math expression in chat messages.",
			type = "group",
			args = {
				enableAutoMathWhispers = {
					name = "Whispers",
					desc = "Enable the auto computing of math expressions found in private chat messages.",
					type = "toggle",
					order = 1,
					width = "full",
					get = function(info) return BastasTools.db.global.enableAutoMathWhispers end,
					set = function(info,val) BastasTools.db.global.enableAutoMathWhispers = val end
				},
				autoMathTradeAndGeneral = {
					name = "Trade / General",
					desc = "Enable the auto computing of math expressions found in trade / general chat messages.",
					type = "toggle",
					order = 2,
					width = "full",
					get = function(info) return BastasTools.db.global.autoMathTradeAndGeneral end,
					set = function(info,val) BastasTools.db.global.autoMathTradeAndGeneral = val end
				},
				autoMathRaidAndInstance = {
					name = "Raid / Instance",
					desc = "Enable the auto computing of math expressions found in raid / instance chat messages.",
					type = "toggle",
					order = 3,
					width = "full",
					get = function(info) return BastasTools.db.global.autoMathRaidAndInstance end,
					set = function(info,val) BastasTools.db.global.autoMathRaidAndInstance = val end
				},
				autoMathGuildAndOfficer = {
					name = "Guild / Officer",
					desc = "Enable the auto computing of math expressions found in guild / officer chat messages.",
					type = "toggle",
					order = 4,
					width = "full",
					get = function(info) return BastasTools.db.global.autoMathGuildAndOfficer end,
					set = function(info,val) BastasTools.db.global.autoMathGuildAndOfficer = val end
				},
				autoMathSay = {
					name = "Say / Yell",
					desc = "Enable the auto computing of math expressions found local say / yell chat messages.",
					type = "toggle",
					order = 5,
					width = "full",
					get = function(info) return BastasTools.db.global.autoMathSay end,
					set = function(info,val) BastasTools.db.global.autoMathSay = val end
				},
				autoMathSilent = {
					name = "Quiet Mode",
					desc = "If checked, answers will be printed locally instead of being automatically sent in a chat message.",
					type = "toggle",
					order = 6,
					width = "full",
					get = function(info) return BastasTools.db.global.autoMathSilent end,
					set = function(info,val) BastasTools.db.global.autoMathSilent = val end
				}

			}
		},
		ShadowPriestTranslator = {
			name = "Voidform Translator",
			desc = "While in a raid group will translate voidform messages from shadow priests. Requires both sender and receiver of messages to have this addon. NOTE: Due to current API limitations this does not work for chat bubbles.",
			type = "group",
			args = {
				enableShadowPriestTranslator = {
					name = "Enabled",
					desc = "Enable the translation of voidform messages among users of this addon.",
					type = "toggle",
					get = function(info) return BastasTools.db.global.enableShadowPriestTranslator end,
					set = function(info,val) BastasTools.db.global.enableShadowPriestTranslator = val end
				},
			},		
		},
		ElvGlow = {
			name = "ElvUI Frame Highlights",
			desc = "Additional highlighting options for ElvUI Raid frames.",
			type = "group",
			args = {
				enableElvGlow = {
					name = "Enabled",
					desc = "Enable additional highlighting options for ElvUI Raid Frames. Requires ElvUI frames.",
					type = "toggle",
					order = 1,
					get = function(info) return BastasTools.db.global.enableElvGlow end,
					set = function(info,val) BastasTools.db.global.enableElvGlow = val end
				},
				addDebuff = {
					name = "Buff/Debuff Name",
					desc = "Set the buff/debuff name to start tracking.",
					type = "input",
					order = 2,
					get = function(info) return elvglow_adddebuff end,
					set = function(info,val) elvglow_adddebuff = val end
				},
				addDebuffColor = {
					name = "Highlight Color",
					desc = "Set the highlight color associated with this buff/debuff.",
					type = "color",
					order = 3,
					get = function(info) return elvglow_adddebuffcolor.r,elvglow_adddebuffcolor.g,elvglow_adddebuffcolor.b,elvglow_adddebuffcolor.a end,
					set = function(info,r,g,b,a) elvglow_adddebuffcolor = Color(r,g,b,a) end
				},
				addDebuffInsert = {
					name = "Add",
					desc = "Add the selected buff/debuff name and its color as a highlight.",
					type = "execute",
					order = 5,
					func = function(info) BastasTools.db.global.ElvGlowHighlights[elvglow_adddebuff] = elvglow_adddebuffcolor end
				},
				addDebuffRemove = { --:thinking:
					name = "Remove",
					desc = "Remove the selected buff/debuff name as a highlight.",
					type = "execute",
					order = 6,
					func = function(info) BastasTools.db.global.ElvGlowHighlights[elvglow_adddebuff] = nil end
				},
				addDebuffSelect = {
						name = "Existing Highlights",
						desc = "Select an existing buff/debuff highlight",
						type = "select",
						order = 7,
						style = "dropdown",
						values = function(info) 
							local t = {};
							for k,v in pairs(BastasTools.db.global.ElvGlowHighlights) do
								t[k] = k;
							end
							return t;
						end,
						get = function(info) return elvglow_adddebuff end,
						set = function(info,value) elvglow_adddebuff = value elvglow_adddebuffcolor = BastasTools.db.global.ElvGlowHighlights[value] end
				}
			}
		}
	}
}



--[[----------------------------------------------------------------------------
Handle Chat Commands
------------------------------------------------------------------------------]]
function BastasTools:ChatCommand(input)
    if not input or input:trim() == "" then
		InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
		InterfaceOptionsFrame_OpenToCategory(self.optionsFrame)
	elseif ( string.lower(input) == "glow" ) then
		BastasTools:ToggleElvGlowMenu()
	end
end



--[[----------------------------------------------------------------------------
Addon Initialized
------------------------------------------------------------------------------]]
function BastasTools:OnInitialize()
    self.db = LibStub("AceDB-3.0"):New("BastasToolsDB", defaults)

	LibStub("AceConfig-3.0"):RegisterOptionsTable("BastasTools",options)
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("BastasTools", "BastasTools")
	self:RegisterChatCommand("bt","ChatCommand")
	
	if ( self.InitAutoMath ) then
		self:InitAutoMath()
	end
	
	if ( self.InitElvGlow ) then
		self:InitElvGlow()
	end
	
	if ( self.InitTalentReminders ) then
		self:InitTalentReminders()
	end
	
	if ( self.InitShadowPriestTranslator ) then
		self:InitShadowPriestTranslator()
	end
end

