if not BastasTools then return end

if AutoMath_EventHandler then
	print("[BastasTools] older version of AutoMath detected. Please uninstall this version of the addon to use the new version.");
	return
end



--[[----------------------------------------------------------------------------
Locals
------------------------------------------------------------------------------]]
local loadstring = loadstring;
local math = math;
local pairs = pairs;
local pcall = pcall;
local setfenv = setfenv;
local string = string;
local tostring = tostring;
local type = type;

chat_events = {
	["CHAT_MSG_GUILD"] 			= 	"autoMathGuildAndOfficer",
	["CHAT_MSG_OFFICER"]		=	"autoMathGuildAndOfficer",
	["CHAT_MSG_CHANNEL"]		=	"autoMathTradeAndGeneral",
	["CHAT_MSG_PARTY"]			=	"autoMathRaidAndInstance",
	["CHAT_MSG_PARTY_LEADER"]	=	"autoMathRaidAndInstance",
	["CHAT_MSG_RAID"]			=	"autoMathRaidAndInstance",
	["CHAT_MSG_RAID_LEADER"]	=	"autoMathRaidAndInstance",
	["CHAT_MSG_RAID_WARNING"]	=	"autoMathRaidAndInstance",
	["CHAT_MSG_SAY"]			=	"autoMathSay",
	["CHAT_MSG_YELL"]			=	"autoMathSay",
	["CHAT_MSG_WHISPER"]		=	"enableAutoMathWhispers",
	["CHAT_MSG_BN_WHISPER"]		=	"enableAutoMathWhispers"
}



--[[----------------------------------------------------------------------------
Sandboxed math functions
------------------------------------------------------------------------------]]
local function celsius(f)
	return ((tonumber(f) or 0)-32)*5/9;
end

local function fahrenheit(c)
	return ((tonumber(c) or 0)*9/5)+32;
end

local function factorial(n)
	local sgn = n >= 0 and 1 or -1;
	local result = 1;
	local abs_n = math.abs(n);
	
	if ( abs_n > 1000 ) then
		return math.huge*sgn;
	else
		for i=1,abs_n,1 do
			result = result * i;
		end
		return result * sgn;
	end
end

local sandbox_env = {
	factorial = factorial,
	fahrenheit	=   fahrenheit,
	ftoc	=	celsius,
	ctof	=	fahrenheit,
	celsius	=	celsius,
	abs		=	math.abs,
	acos	=	math.acos,
	asin	=	math.asin,
	atan	=	math.atan,
	atan2	=	math.atan2,
	ceil	=	math.ceil,
	cos		=	math.cos,
	cosh	=	math.cosh,
	deg		=	math.deg,
	exp		=	math.exp,
	floor	=	math.floor,
	fmod	=	math.fmod,
	frexp	=	math.frexp,
	ldexp	=	math.ldexp,
	log		=	math.log,
	log10	=	math.log10,
	pi		=	math.pi,
	pow		=	math.pow,
	rad		=	math.rad,
	random	=	math.random,
	sin		=	math.sin,
	sinh	=	math.sinh,
	sqrt	=	math.sqrt,
	tan		=	math.tan,
	tanh	=	math.tanh
}



--[[----------------------------------------------------------------------------
isMath( str ): test if the string contains only math symbols & sandbox functions
------------------------------------------------------------------------------]]
local function isMath( str )
	local s = str;
	for pat,_ in pairs(sandbox_env) do
		s = string.gsub(s,pat,"");
	end

	local match = string.match( s, "[%d%s%(%)%^%*%/%+%-%%%.%,]*");
	return match == s;
end



--[[----------------------------------------------------------------------------
Helper Functions
------------------------------------------------------------------------------]]
--mathify the string
local function getMathPortion( str )
	str = string.gsub(str,",","");
	str = string.gsub(str,"(%d+)%!","factorial(%1)");
	
	local s,e = string.find(str,"=");
	if ( s ) then
		return string.sub(str,1,s-1);
	else
		return str;
	end
end

--test if the string contains at least one math operation
local function hasOperator( str )
	local s,e = string.find( str, "[^%d%s%=%.%,]");
	if ( s ) then
		return true;
	else
		return false;
	end
end

--return the math answer, if there is one
local function getAnswer( str )
	if ( str and str:byte(1) ~= 27) then --not bytecode
		str = string.lower(str);
		local mathStr = getMathPortion(str);
		if ( mathStr and hasOperator(mathStr) and isMath(mathStr) ) then
			local func, errorMessage = loadstring('return '..tostring(mathStr)..';');
			if (func) then
				setfenv(func,sandbox_env);
				return pcall(func) and func() or '';
			end
		end
	end
	return '';
end

local function AutoMathMessage(msg, chattype,languageindex,channel)
	if ( BastasTools.db.global.autoMathSilent ) then
		DEFAULT_CHAT_FRAME:AddMessage("|cff00fbf6[AutoMath]|r "..(msg or ""),1,1,1);
	else
		if (chattype == "BN" ) then
			BNSendWhisper(channel,"AutoMath: "..msg);
		else
			SendChatMessage("AutoMath: "..msg,chattype,languageindex,channel);
		end
	end
end

--[[----------------------------------------------------------------------------
Events
------------------------------------------------------------------------------]]
function BastasTools:AutoMath_EventHandler(event, ...)
	local message, sender, language, channelString, target, flags, unknwn, channeldata, channelName,_,_,_,presenceID = ...;
	if ( chat_events[event] and self.db.global[chat_events[event]] ) then
		local ans = getAnswer(message);
		if (ans and type(ans) == "number") then
			if     ( event == "CHAT_MSG_GUILD" ) then
				AutoMathMessage(ans, "GUILD", nil, nil);
			elseif ( event == "CHAT_MSG_OFFICER") then
				AutoMathMessage(ans, "OFFICER", nil, nil);
			elseif ( event == "CHAT_MSG_PARTY" or event == "CHAT_MSG_PARTY_LEADER" ) then
				AutoMathMessage(ans, "PARTY", nil, nil);
			elseif ( event == "CHAT_MSG_SAY" or event == "CHAT_MSG_YELL" ) then
				AutoMathMessage(ans,"SAY",nil,nil);
			elseif ( event == "CHAT_MSG_RAID" or event == "CHAT_MSG_RAID_LEADER" or event == "CHAT_MSG_RAID_WARNING" ) then
				AutoMathMessage(ans,"RAID",nil,nil);
			elseif ( event == "CHAT_MSG_CHANNEL" ) then
				AutoMathMessage(ans,"CHANNEL",nil,channeldata);
			elseif ( event == "CHAT_MSG_WHISPER" ) then
				AutoMathMessage(ans,"WHISPER",nil,sender);
			elseif ( event == "CHAT_MSG_BN_WHISPER" ) then
				AutoMathMessage(ans,"BN",nil,presenceID);
			end
		end
	end
end

function BastasTools:InitAutoMath()
	for k,v in pairs(chat_events) do
		BastasTools:RegisterEvent(k,"AutoMath_EventHandler");
	end
end



--[[----------------------------------------------------------------------------
Chat Command
------------------------------------------------------------------------------]]
SLASH_MATH1 = "/math";
SLASH_MATH2 = "/automath";
SLASH_MATH3 = "/am";

SlashCmdList["MATH"] = function(msg)
	DEFAULT_CHAT_FRAME:AddMessage("|cff00fbf6[AutoMath]|r > "..tostring(msg),1,1,1);
	local ans = getAnswer(msg);
	if (ans and type(ans) == "number") then
		DEFAULT_CHAT_FRAME:AddMessage("|cff00fbf6[AutoMath]|r "..tostring(ans),1,1,1);
	else
		DEFAULT_CHAT_FRAME:AddMessage("|cff00fbf6[AutoMath]|r Invalid Input",1,1,1);
	end
end


