local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Assert = BaikCore.Assert
local Database = BaikCore.Database
local Log = BaikCore.Log
local Option = BaikCore.Option

-- Add Module
local Zoom = BaikActionbar:NewModule("Zoom")
BaikActionbar.Zoom = Zoom

Zoom.DEFAULT = false

-- Constants
local ZOOM_COORD = {0.1, 0.9, 0.1, 0.9}
local NORM_COORD = {0, 1, 0, 1}

local OPTION_NAME = "zoom_style"
local GLOBAL_ZOOM_DB = "global_zoom"

-- Private Variables
local zoomFunc = {}

-- Private Methods
local function GetCoords(zoomed)
    Assert:Boolean(zoomed)

    if Database:Get(GLOBAL_ZOOM_DB) then
        return ZOOM_COORD
    end

    return zoomed and ZOOM_COORD or NORM_COORD
end

local function SyncGlobal()
    local zoom = Database:Get(GLOBAL_ZOOM_DB)
    for dbValue, func in pairs(zoomFunc) do
        func(zoom and true or Database:Get(dbValue))
    end
end

local function GetOpts()
    return {
        name = "Icon",
        type = "group",
        args = {
            zoom = {
                name = "Zoom",
                type = "toggle",
                get = function(...)
                    return Database:Get(GLOBAL_ZOOM_DB)
                end,
                set = function(self, value, ...)
                    Database:Set(GLOBAL_ZOOM_DB, value)
                    SyncGlobal()
                end,
            }
        }
    }
end

-- Zoom API
function Zoom:SetZoomButton(btn, zoomed)
    Assert:Table(btn)
    Assert:Boolean(zoomed)

    local coords = GetCoords(zoomed)
    btn.icon:SetTexCoord(unpack(coords))
    btn:GetCheckedTexture():SetTexCoord(unpack(coords))
end

function Zoom:SetZoomButtons(btnTable, zoomed)
    Assert:Table(btnTable)
    Assert:Boolean(zoomed)

    for _, btn in pairs(btnTable) do
        self:SetZoomButton(btn, zoomed)
    end
end

function Zoom:SetZoomTexture(tex, zoomed)
    Assert:Table(tex)
    Assert:Boolean(zoomed)

    local coords = GetCoords(zoomed)
    tex:SetTexCoord(unpack(coords))
end

function Zoom:SetZoomTextures(texTable, zoomed)
    Assert:Table(texTable)
    Assert:Boolean(zoomed)

    for _, tex in pairs(texTable) do
        self:SetZoomTexture(tex, zoomed)
    end
end

function Zoom:GetOpts(dbValue, SetZoomFunc)
    zoomFunc[dbValue] = SetZoomFunc
    return {
        name = "Zoom",
        type = "toggle",
        disabled = function(...)
            return Database:Get(GLOBAL_ZOOM_DB)
        end,
        get = function(...)
            return Database:Get(dbValue)
        end,
        set = function(self, value, ...)
            Database:Set(dbValue, value)
            SetZoomFunc(value)
        end,
    }
end

-- Ace3 Callbacks
function Zoom:OnInitialize()
    Log:v("Zoom_OnInitialize")
    Database:InitIfEmpty(GLOBAL_ZOOM_DB, Zoom.DEFAULT)
    BaikActionbar:AddOption(OPTION_NAME, GetOpts())
end

function Zoom:OnEnable()
    Log:v("Zoom_OnEnable")
    SyncGlobal()
end

function Zoom:OnDisable()
    Log:v("Zoom_OnDisable")
end
