local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Database = BaikCore.Database
local Border = BaikActionbar.Border
local Log = BaikCore.Log
local Hook = BaikCore.Hook
local Option = BaikCore.Option
local Ui = BaikCore.Ui
local Visibility = BaikCore.Visibility
local Zoom = BaikActionbar.Zoom

-- Add Module (Add prefix to avoid collision)
local BaikStance = BaikActionbar:NewModule("Stance", "AceHook-3.0")

-- Constants
local OPTION_NAME = "stance_style"
local STANCE_ZOOM_DB = "stance_zoom"
local STANCE_BORDER_DB = "stance_border"
local STANCE_VIS_DB = "stance_vis"

-- Constants
local ART = {
    StanceBarLeft,
    StanceBarMiddle,
    StanceBarRight,
    StanceButton1NormalTexture2,
    StanceButton2NormalTexture2,
    StanceButton3NormalTexture2,
    StanceButton4NormalTexture2,
    StanceButton5NormalTexture2,
    StanceButton6NormalTexture2,
    StanceButton7NormalTexture2,
    StanceButton8NormalTexture2,
    StanceButton9NormalTexture2,
    StanceButton10NormalTexture2,
}

local BUTTONS = {
    StanceButton1,
    StanceButton2,
    StanceButton3,
    StanceButton4,
    StanceButton5,
    StanceButton6,
    StanceButton7,
    StanceButton8,
    StanceButton9,
    StanceButton10,
}

-- Private Methods
local function GetYOffset(leftShown, rightShown)
    -- Constants
    local DEFAULT = -1 -- Blizzard incorrectly uses yPos = 0 :P
    local BAR_GAP = 4
    local EXTRA_SIZE = 36

    -- Local variables
    local gapCount = 0
    local extraCount = 0

    if leftShown or rightShown then
        -- Need a little gap if it's off the mainbar
        gapCount = gapCount + 1

        if leftShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end

        if rightShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end
    end

    return DEFAULT + (gapCount * BAR_GAP) + (extraCount * EXTRA_SIZE)
end

local function SetupStanceFrame()
    Log:v("BaikStance_SetupStanceFrame")
    local leftShown = MultiBarBottomLeft:IsShown()
    local rightShown = MultiBarBottomRight:IsShown()
    local forceHide = Database:Get(STANCE_BORDER_DB)

    Border:RemoveAlphas(ART, rightShown or leftShown or forceHide)

    local yPos = GetYOffset(leftShown, rightShown)
    Ui:SetPointFinal(StanceBarFrame, "BOTTOMLEFT", MainMenuBar, "TOPLEFT", 30, yPos, true)
end

local function SetupHook()
    Hook:EnsureSecureHookScript(BaikStance, StanceBarFrame, "OnShow", SetupStanceFrame)
    Hook:EnsureSecureHookScript(BaikStance, MultiBarBottomLeft, "OnShow", SetupStanceFrame)
    Hook:EnsureSecureHookScript(BaikStance, MultiBarBottomLeft, "OnHide", SetupStanceFrame)
    Hook:EnsureSecureHookScript(BaikStance, MultiBarBottomRight, "OnShow", SetupStanceFrame)
    Hook:EnsureSecureHookScript(BaikStance, MultiBarBottomRight, "OnHide", SetupStanceFrame)
end

local function SetZoomed(zoomed)
    Zoom:SetZoomButtons(BUTTONS, zoomed)
end

local function SetBorder(hide)
    Border:RemoveAlphas(ART, hide)
end

local function GetOpts()
    return {
        name = "Stance",
        type = "group",
        args = {
            zoom = Zoom:GetOpts(STANCE_ZOOM_DB, SetZoomed),
            border = Border:GetOpts(STANCE_BORDER_DB, SetBorder),
            vis = Visibility:GetOpts(STANCE_VIS_DB, BUTTONS, nil)
        }
    }
end

-- Ace3 Callbacks
function BaikStance:OnInitialize()
    Log:v("BaikStance_OnInitialize")
    Database:InitIfEmpty(STANCE_ZOOM_DB, Zoom.DEFAULT)
    Database:InitIfEmpty(STANCE_BORDER_DB, Border.DEFAULT)
    Database:InitIfEmpty(STANCE_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function BaikStance:OnEnable()
    Log:v("BaikStance_OnEnable")
    SetupHook()
    SetupStanceFrame()
    SetZoomed(Database:Get(STANCE_ZOOM_DB))
    SetBorder(Database:Get(STANCE_BORDER_DB))
    Visibility:Setup(STANCE_VIS_DB, BUTTONS, nil)
end

function BaikStance:OnDisable()
    Log:v("BaikStance_OnDisable")
    self:UnhookAll()
end
