local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Border = BaikActionbar.Border
local Database = BaikCore.Database
local Log = BaikCore.Log
local Hook = BaikCore.Hook
local Option = BaikCore.Option
local Ui = BaikCore.Ui
local Visibility = BaikCore.Visibility
local Zoom = BaikActionbar.Zoom

-- Add Module (Add prefix to avoid collision)
local BaikPossess = BaikActionbar:NewModule("Possess", "AceHook-3.0")

-- Constants
local OPTION_NAME = "possess_style"
local POSSESS_ZOOM_DB = "possess_zoom"
local POSSESS_BORDER_DB = "possess_border"
local POSSESS_VIS_DB = "possess_vis"

local ART = {
    PossessBackground1,
    PossessBackground2,
    PossessButton1NormalTexture,
    PossessButton2NormalTexture,
}

local BUTTONS = {
    PossessButton1,
    PossessButton2,
}

-- Private Methods
local function GetYOffset(leftShown, rightShown)
    -- Constants
    local DEFAULT = -1 -- Blizzard incorrectly uses yPos = 0 :P
    local BAR_GAP = 4
    local EXTRA_SIZE = 36

    -- Local variables
    local gapCount = 0
    local extraCount = 0

    if leftShown or rightShown then
        -- Need a little gap if it's off the mainbar
        gapCount = gapCount + 1

        if leftShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end

        if rightShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end
    end

    return DEFAULT + (gapCount * BAR_GAP) + (extraCount * EXTRA_SIZE)
end

local function SetupPossessFrame()
    Log:v("BaikPossess_SetupPossessFrame")
    local leftShown = MultiBarBottomLeft:IsShown()
    local rightShown = MultiBarBottomRight:IsShown()
    local forceHide = Database:Get(POSSESS_BORDER_DB)

    Border:RemoveAlphas(ART, rightShown or leftShown or forceHide)

    local yPos = GetYOffset(leftShown, rightShown)
    Ui:SetPointFinal(PossessBarFrame, "BOTTOMLEFT", MainMenuBar, "TOPLEFT", 30, yPos, true)
end

local function SetupHook()
    Hook:EnsureSecureHookScript(BaikPossess, PossessBarFrame, "OnShow", SetupPossessFrame)
    Hook:EnsureSecureHookScript(BaikPossess, MultiBarBottomLeft, "OnShow", SetupPossessFrame)
    Hook:EnsureSecureHookScript(BaikPossess, MultiBarBottomLeft, "OnHide", SetupPossessFrame)
    Hook:EnsureSecureHookScript(BaikPossess, MultiBarBottomRight, "OnShow", SetupPossessFrame)
    Hook:EnsureSecureHookScript(BaikPossess, MultiBarBottomRight, "OnHide", SetupPossessFrame)
end

local function SetZoomed(zoomed)
    Zoom:SetZoomButtons(BUTTONS, zoomed)
end

local function SetBorder(hide)
    Border:RemoveFrames(ART, hide)
end

local function GetOpts()
    return {
        name = "Possess",
        type = "group",
        args = {
            zoom = Zoom:GetOpts(POSSESS_ZOOM_DB, SetZoomed),
            border = Border:GetOpts(POSSESS_BORDER_DB, SetBorder),
            vis = Visibility:GetOpts(POSSESS_VIS_DB, BUTTONS, PossessBarFrame)
        }
    }
end

-- Ace3 Callbacks
function BaikPossess:OnInitialize()
    Log:v("BaikPossess_OnInitialize")
    Database:InitIfEmpty(POSSESS_ZOOM_DB, Zoom.DEFAULT)
    Database:InitIfEmpty(POSSESS_BORDER_DB, Border.DEFAULT)
    Database:InitIfEmpty(POSSESS_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function BaikPossess:OnEnable()
    Log:v("BaikPossess_OnEnable")
    SetupHook()
    SetupPossessFrame()
    SetZoomed(Database:Get(POSSESS_ZOOM_DB))
    SetBorder(Database:Get(POSSESS_BORDER_DB))
    Visibility:Setup(POSSESS_VIS_DB, BUTTONS, PossessBarFrame)
end

function BaikPossess:OnDisable()
    Log:v("BaikPossess_OnDisable")
    self:UnhookAll()
end
