local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Database = BaikCore.Database
local Log = BaikCore.Log
local Hook = BaikCore.Hook
local Option = BaikCore.Option
local Ui = BaikCore.Ui
local Border = BaikActionbar.Border
local Visibility = BaikCore.Visibility
local Zoom = BaikActionbar.Zoom

-- Add Module (Add prefix to avoid collision)
local BaikPet = BaikActionbar:NewModule("Pet", "AceHook-3.0")

-- Constants
local OPTION_NAME = "pet_style"
local PET_ZOOM_DB = "pet_zoom"
local PET_BORDER_DB = "pet_border"
local PET_VIS_DB = "pet_vis"

local ARTS = {
    SlidingActionBarTexture0,
    SlidingActionBarTexture1
}

local ICONS = {
    PetActionButton1Icon,
    PetActionButton2Icon,
    PetActionButton3Icon,
    PetActionButton4Icon,
    PetActionButton5Icon,
    PetActionButton6Icon,
    PetActionButton7Icon,
    PetActionButton8Icon,
    PetActionButton9Icon,
    PetActionButton10Icon,
    PetActionButton1:GetCheckedTexture(),
    PetActionButton2:GetCheckedTexture(),
    PetActionButton3:GetCheckedTexture(),
    PetActionButton4:GetCheckedTexture(),
    PetActionButton5:GetCheckedTexture(),
    PetActionButton6:GetCheckedTexture(),
    PetActionButton7:GetCheckedTexture(),
    PetActionButton8:GetCheckedTexture(),
    PetActionButton9:GetCheckedTexture(),
    PetActionButton10:GetCheckedTexture(),
}

local BORDERS = {
    PetActionButton1NormalTexture2,
    PetActionButton2NormalTexture2,
    PetActionButton3NormalTexture2,
    PetActionButton4NormalTexture2,
    PetActionButton5NormalTexture2,
    PetActionButton6NormalTexture2,
    PetActionButton7NormalTexture2,
    PetActionButton8NormalTexture2,
    PetActionButton9NormalTexture2,
    PetActionButton10NormalTexture2,
}

local VISIBILITY = {
    PetActionButton1,
    PetActionButton2,
    PetActionButton3,
    PetActionButton4,
    PetActionButton5,
    PetActionButton6,
    PetActionButton7,
    PetActionButton8,
    PetActionButton9,
    PetActionButton10,
    PetActionBarFrame,
}

-- Private Methods
local function GetYOffset(leftShown, rightShown)
    -- Constants
    local DEFAULT = 92 -- Blizzard incorrectly uses yPos = 89 :P
    local BAR_GAP = 4
    local EXTRA_SIZE = 36

    -- Local variables
    local gapCount = 0
    local extraCount = 0

    if leftShown or rightShown then
        -- Need a little gap if it's off the mainbar
        gapCount = gapCount + 1

        if leftShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end

        if rightShown then
            gapCount = gapCount + 1
            extraCount = extraCount + 1
        end
    end

    return DEFAULT + (gapCount * BAR_GAP) + (extraCount * EXTRA_SIZE)
end

local function SetupPetFrame()
    Log:v("BaikPet_SetupPetFrame")
    local leftShown = MultiBarBottomLeft:IsShown()
    local rightShown = MultiBarBottomRight:IsShown()
    local forceHide = Database:Get(PET_BORDER_DB)

    Border:RemoveAlphas(BORDERS, rightShown or leftShown or forceHide)
    Border:RemoveFrames(ARTS, rightShown or leftShown or forceHide)

    local yPos = GetYOffset(leftShown, rightShown)
    Ui:SetPointFinal(PetActionBarFrame, "TOPLEFT", MainMenuBar, "BOTTOMLEFT", 40, yPos, true)
end

local function SetupHook()
    Hook:EnsureSecureHookScript(BaikPet, PetActionBarFrame, "OnShow", SetupPetFrame)
    Hook:EnsureSecureHookScript(BaikPet, MultiBarBottomLeft, "OnShow", SetupPetFrame)
    Hook:EnsureSecureHookScript(BaikPet, MultiBarBottomLeft, "OnHide", SetupPetFrame)
    Hook:EnsureSecureHookScript(BaikPet, MultiBarBottomRight, "OnShow", SetupPetFrame)
    Hook:EnsureSecureHookScript(BaikPet, MultiBarBottomRight, "OnHide", SetupPetFrame)
end

local function SetZoomed(zoomed)
    Zoom:SetZoomTextures(ICONS, zoomed)
end

local function SetBorder(hide)
    Border:RemoveAlphas(BORDERS, hide)
    Border:RemoveFrames(ARTS, hide)
end

local function GetOpts()
    return {
        name = "Pet",
        type = "group",
        args = {
            zoom = Zoom:GetOpts(PET_ZOOM_DB, SetZoomed),
            border = Border:GetOpts(PET_BORDER_DB, SetBorder),
            vis = Visibility:GetOpts(PET_VIS_DB, VISIBILITY, PetActionBarFrame)
        }
    }
end

-- Ace3 Callbacks
function BaikPet:OnInitialize()
    Log:v("BaikPet_OnInitialize")
    Database:InitIfEmpty(PET_ZOOM_DB, Zoom.DEFAULT)
    Database:InitIfEmpty(PET_BORDER_DB, Border.DEFAULT)
    Database:InitIfEmpty(PET_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function BaikPet:OnEnable()
    Log:v("BaikPet_OnEnable")
    SetupHook()
    SetZoomed(Database:Get(PET_ZOOM_DB))
    SetBorder(Database:Get(PET_BORDER_DB))
    Visibility:Setup(PET_VIS_DB, VISIBILITY, PetActionBarFrame)
end

function BaikPet:OnDisable()
    Log:v("BaikPet_OnDisable")
    self:UnhookAll()
end
