local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Database = BaikCore.Database
local Log = BaikCore.Log
local Option = BaikCore.Option
local Visibility = BaikCore.Visibility

-- Add Module (Add prefix to avoid collision)
local MicroButton = BaikActionbar:NewModule("MicroButton")

-- Constants
local OPTION_NAME = "micro_style"
local MICRO_VIS_DB = "micro_vis"

-- Constants
local VISIBILITY = {
    CharacterMicroButton,
    SpellbookMicroButton,
    TalentMicroButton,
    AchievementMicroButton,
    QuestLogMicroButton,
    GuildMicroButton,
    LFDMicroButton,
    CollectionsMicroButton,
    EJMicroButton,
    StoreMicroButton,
    MainMenuMicroButton,
}

-- Private Methods
local function GetOpts()
    return {
        name = "MicroButton",
        type = "group",
        args = {
            vis = Visibility:GetOpts(MICRO_VIS_DB, VISIBILITY, nil)
        }
    }
end

-- Ace3 Callbacks
function MicroButton:OnInitialize()
    Log:v("MicroButton_OnInitialize")
    Database:InitIfEmpty(MICRO_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function MicroButton:OnEnable()
    Log:v("MicroButton_OnEnable")
    Visibility:Setup(MICRO_VIS_DB, VISIBILITY, nil)
end

function MicroButton:OnDisable()
    Log:v("MicroButton_OnDisable")
    self:UnhookAll()
end

