local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Border = BaikActionbar.Border
local Database = BaikCore.Database
local Log = BaikCore.Log
local Option = BaikCore.Option
local Table = BaikCore.Table
local Visibility = BaikCore.Visibility
local Zoom = BaikActionbar.Zoom

-- Add Module (Add prefix to avoid collision)
local BaikMenuBar = BaikActionbar:NewModule("MenuBar")

-- Constants
local OPTION_NAME = "menu_bar_style"
local MENU_ZOOM_DB = "menu_bar_zoom"
local MENU_BORDER_DB = "menu_border"
local MENU_VIS_DB = "menu_vis"

-- Constants
local BUTTONS = nil

local BUTTON_PREFIX = {
    "ActionButton%d",
    "MultiBarBottomLeftButton%d",
    "MultiBarBottomRightButton%d",
    "MultiBarLeftButton%d",
    "MultiBarRightButton%d",
}

local VISIBILITY = nil

local VISIBILITY_EXTRA = {
    MainMenuBarArtFrame,
    StatusTrackingBarManager
}

-- Private Methods
local function GetButtons()
    -- Already generated buttons, exit early
    if BUTTONS then
        return BUTTONS
    end

    -- Build table
    local btnTable = {}
    for _, fmt in pairs(BUTTON_PREFIX) do
        for idx = 1, 12, 1 do
            local btnName = string.format(fmt, idx)
            local btn = _G[btnName]
            if not btn then
                Log:i("%s button is nil", btnName)
            else
                table.insert(btnTable, btn)
            end
        end
    end

    BUTTONS = btnTable
    return BUTTONS
end

local function GetVisibility()
    -- Already generated buttons, exit early
    if VISIBILITY then
        return VISIBILITY
    end

    local visTable = {}
    local btns = GetButtons()
    Table:Append(visTable, btns)
    Table:Append(visTable, VISIBILITY_EXTRA)
    VISIBILITY = visTable

    return visTable
end

-- Private Methods
local function SetZoomed(zoomed)
    local btns = GetButtons()
    Zoom:SetZoomButtons(btns, zoomed)
end

local function SetBorder(hide)
    local btns = GetButtons()
    Border:RemoveButtons(btns, hide)
end

local function GetOpts()
    return {
        name = "MainMenuBar",
        type = "group",
        args = {
            zoom = Zoom:GetOpts(MENU_ZOOM_DB, SetZoomed),
            border = Border:GetOpts(MENU_BORDER_DB, SetBorder),
            vis = Visibility:GetOpts(MENU_VIS_DB, GetVisibility(), nil)
        }
    }
end

-- Ace3 Callbacks
function BaikMenuBar:OnInitialize()
    Log:v("BaikMenuBar_OnInitialize")
    Database:InitIfEmpty(MENU_ZOOM_DB, Zoom.DEFAULT)
    Database:InitIfEmpty(MENU_BORDER_DB, Border.DEFAULT)
    Database:InitIfEmpty(MENU_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function BaikMenuBar:OnEnable()
    Log:v("BaikMenuBar_OnEnable")
    SetZoomed(Database:Get(MENU_ZOOM_DB))
    SetBorder(Database:Get(MENU_BORDER_DB))
    Visibility:Setup(MENU_VIS_DB, GetVisibility(), nil)
end

function BaikMenuBar:OnDisable()
    Log:v("BaikMenuBar_OnDisable")
    self:UnhookAll()
end
