local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Assert = BaikCore.Assert
local Hook = BaikCore.Hook
local Log = BaikCore.Log
local Option = BaikCore.Option
local Ui = BaikCore.Ui

-- New Module (Prefix with Baik to avoid name collision)
local BaikBottomRightGrid = BaikActionbar:NewModule("BottomRightGrid", "AceHook-3.0", "AceEvent-3.0")

-- Constants
local BOTTOM_RIGHT_GRID = nil
local BOTTOM_RIGHT_EVENTS = nil

-- Private Methods
local function SetHotKeyBtnParent(btn)
    Assert:Table(btn)
    btn.HotKey:SetParent(btn)
end

local function SetHotKeyGridParent(btn)
    Assert:Table(btn)
    if not btn:IsShown() then
        btn.HotKey:SetParent(MultiBarBottomRight)
    end
end

local function GetGridFrame()
    if BOTTOM_RIGHT_GRID then
        return BOTTOM_RIGHT_GRID
    end

    BOTTOM_RIGHT_GRID = {}

    local pattern = "MultiBarBottomRightButton%d"
    local texPattern = "%sFloatingBG"
    for idx = 1, 6, 1 do
        local btn = _G[string.format(pattern, idx)]
        local texName = string.format(texPattern, btn:GetName())

        -- Copied from FrameXML/MultiActionBars.xml
        local tex = MultiBarBottomRight:CreateTexture(texName, "BACKGROUND", nil, -1)
        tex:SetPoint("TOPLEFT", btn, -15, 15)
        tex:SetPoint("BOTTOMRIGHT", btn, 15, -15)
        tex:SetTexture("Interface\\Buttons\\UI-Quickslot")
        tex:SetAlpha(0.4)

        -- Ensure we reassign hotkey parent
        local function BtnParent()
            SetHotKeyBtnParent(btn)
        end
        Hook:EnsureSecureHookScript(BaikBottomRightGrid, btn, "OnShow", BtnParent)

        local function GridParent()
            if MultibarGrid_IsVisible() then
                SetHotKeyGridParent(btn)
            end
        end
        Hook:EnsureSecureHookScript(BaikBottomRightGrid, btn, "OnHide", GridParent)

        BOTTOM_RIGHT_GRID[btn] = tex
    end

    return BOTTOM_RIGHT_GRID
end

local function ShowAllGrid()
    Log:v("BottomRightGrid_ShowAllGrid()")
    local gridFrames = GetGridFrame()
    for btn, frame in pairs(gridFrames) do
        frame:Show()
        SetHotKeyGridParent(btn)
    end
end

local function HideAllGrid()
    local gridFrame = GetGridFrame()
    for btn, frame in pairs(gridFrame) do
        frame:Hide()
        SetHotKeyBtnParent(btn)
    end
end

local function SafeHideAllGrid()
    Log:v("BottomRightGrid_HideAllGrid()")
    -- Ignore hide
    if MultibarGrid_IsVisible() then
        return
    end

    HideAllGrid()
end

local function SetupHook()
    Hook:EnsureSecureHook(BaikBottomRightGrid, nil, "MultiActionBar_HideAllGrids", HideAllGrid)
    Hook:EnsureSecureHook(BaikBottomRightGrid, nil, "MultiActionBar_ShowAllGrids", ShowAllGrid)
end

-- Lazy load
local function GetEvents()
    if BOTTOM_RIGHT_EVENTS then
        return BOTTOM_RIGHT_EVENTS
    end

    BOTTOM_RIGHT_EVENTS = {
        ["ACTIONBAR_SHOWGRID"] = ShowAllGrid,
        ["ACTIONBAR_HIDEGRID"] = SafeHideAllGrid,
    }

    return BOTTOM_RIGHT_EVENTS
end

local function RegisterEvents()
    local events = GetEvents()
    for event, handler in pairs(events) do
        BaikBottomRightGrid:RegisterEvent(event, handler)
    end
end

local function UnregisterEvents()
    local events = GetEvents()
    for event, _ in pairs(events) do
        BaikBottomRightGrid:UnregisterEvent(event)
    end
end

-- Ace3 Callbacks
function BaikBottomRightGrid:OnInitialize()
    Log:v("BottomRight_OnInitialize")
end

function BaikBottomRightGrid:OnEnable()
    Log:v("BottomRightGrid_OnEnable")
    SetupHook()
    RegisterEvents()
end

function BaikBottomRightGrid:OnDisable()
    Log:v("BottomRightGrid_OnDisable")
    self:UnhookAll()
    UnregisterEvents()
end

