local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Hook = BaikCore.Hook
local Log = BaikCore.Log
local Option = BaikCore.Option
local Ui = BaikCore.Ui

-- New Module (Prefix with Baik to avoid name collision)
local BaikBottomRight = BaikActionbar:NewModule("BottomRight", "AceHook-3.0")

-- Constants
local EXTRA_BARS = {
    MultiBarBottomLeft,
    MultiBarBottomRight,
}

-- Private Methods
local function SetupBottomRight()
    Log:v("BottomRight_SetupBottomRight")
    local function SetSingleRow()
        MultiBarBottomRightButton7:ClearAllPoints()
        MultiBarBottomRightButton7:SetPoint("LEFT", MultiBarBottomRightButton6, "RIGHT", 6, 0)

        MultiBarBottomRightButton1:ClearAllPoints()
        MultiBarBottomRightButton1:SetPoint("TOPLEFT", 0, 0)
    end

    local function MoveRow()
        if MultiBarBottomLeft:IsShown() then
            Ui:SetPointFinal(MultiBarBottomRight, "BOTTOMLEFT", MultiBarBottomLeft, "TOPLEFT", 0, 18, true)
        else
            Ui:SetPointFinal(MultiBarBottomRight, "BOTTOMLEFT", MainMenuBarArtFrame, "TOPLeft", 6, -6, true)
        end
    end

    SetSingleRow()
    MoveRow()
end

local function SetupHook()
    for _, frame in pairs(EXTRA_BARS) do
        frame:HookScript("OnHide", SetupBottomRight)
        frame:HookScript("OnShow", SetupBottomRight)
    end
end

-- This essentially hijacks one of the blizzard API's and forces the API
-- to always change the menu bars to compact mode
local function SetupCompact()
    MainMenuBar.CachedChangeMethod = MainMenuBar.ChangeMenuBarSizeAndPosition
    MainMenuBar.ChangeMenuBarSizeAndPosition = function(value)
        -- Ignore value
        MainMenuBar:CachedChangeMethod(false)
    end
end

local function UndoForcedCompact()
    MainMenuBar.ChangeMenuBarSizeAndPosition = MainMenuBar.CachedChangeMethod
    MainMenuBar.CachedChangeMethod = nil
end

-- Ace3 Callbacks
function BaikBottomRight:OnInitialize()
    Log:v("BottomRight_OnInitialize")
end

function BaikBottomRight:OnEnable()
    Log:v("BottomRight_OnEnable")
    SetupCompact()
    SetupHook()
end

function BaikBottomRight:OnDisable()
    Log:v("BottomRight_OnDisable")
end
