local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Border = BaikActionbar.Border
local Database = BaikCore.Database
local Log = BaikCore.Log
local Option = BaikCore.Option
local Visibility = BaikCore.Visibility
local Zoom = BaikActionbar.Zoom

-- Add Module (Add prefix to avoid collision)
local BaikBag = BaikActionbar:NewModule("Bag")

-- Constants
local OPTION_NAME = "bag_style"
local BAG_ZOOM_DB = "action_bag_zoom"
local BAG_BORDER_DB = "action_bag_border"
local BAG_VIS_DB = "action_bag_vis"

-- Constants
local ICONS = {
    CharacterBag0SlotIconTexture,
    CharacterBag1SlotIconTexture,
    CharacterBag2SlotIconTexture,
    CharacterBag3SlotIconTexture,
    MainMenuBarBackpackButtonIconTexture,
}

local BORDERS = {
    MicroButtonAndBagsBar.MicroBagBar,
    CharacterBag0SlotNormalTexture,
    CharacterBag1SlotNormalTexture,
    CharacterBag2SlotNormalTexture,
    CharacterBag3SlotNormalTexture,
    CharacterBag0Slot.IconBorder,
    CharacterBag1Slot.IconBorder,
    CharacterBag2Slot.IconBorder,
    CharacterBag3Slot.IconBorder,
    MainMenuBarBackpackButtonNormalTexture,
}

local VISIBILITY = {
    MicroButtonAndBagsBar,
    CharacterBag0Slot,
    CharacterBag1Slot,
    CharacterBag2Slot,
    CharacterBag3Slot,
    MainMenuBarBackpackButton,
}

-- Private Methods
local function SetZoomed(zoomed)
    Zoom:SetZoomTextures(ICONS, zoomed)
end

local function SetBorder(hide)
    Border:RemoveFrames(BORDERS, hide)
end

local function GetOpts()
    return {
        name = "Bag",
        type = "group",
        args = {
            zoom = Zoom:GetOpts(BAG_ZOOM_DB, SetZoomed),
            border = Border:GetOpts(BAG_BORDER_DB, SetBorder),
            vis = Visibility:GetOpts(BAG_VIS_DB, VISIBILITY, MicroButtonAndBagsBar)
        }
    }
end

-- Ace3 Callbacks
function BaikBag:OnInitialize()
    Log:v("BaikBag_OnInitialize")
    Database:InitIfEmpty(BAG_ZOOM_DB, Zoom.DEFAULT)
    Database:InitIfEmpty(BAG_BORDER_DB, Border.DEFAULT)
    Database:InitIfEmpty(BAG_VIS_DB, Visibility.DEFAULT)
    Option:AddOption(BaikActionbar.OPTION_NAME, OPTION_NAME, GetOpts())
end

function BaikBag:OnEnable()
    Log:v("BaikBag_OnEnable")
    SetZoomed(Database:Get(BAG_ZOOM_DB))
    SetBorder(Database:Get(BAG_BORDER_DB))
    Visibility:Setup(BAG_VIS_DB, VISIBILITY, MicroButtonAndBagsBar)
end

function BaikBag:OnDisable()
    Log:v("BaikBag_OnDisable")
    self:UnhookAll()
end
