local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local BaikActionbar = BaikCore.BaikActionbar
local Database = BaikCore.Database
local Log = BaikCore.Log
local Option = BaikCore.Option
local Ui = BaikCore.Ui
local VertexColor = BaikCore.VertexColor

-- Add Module
local Art = BaikActionbar:NewModule("Art")

-- Constants
local OPTION_NAME = "action_art_style"
local ART_COLOR_DB = "action_art_color"
local ART_VIS_DB = "action_art_vis"

local FRAMES = {
    -- Gryphons
    MainMenuBarArtFrame.LeftEndCap,
    MainMenuBarArtFrame.RightEndCap,

    -- Actionbar
    MainMenuBarArtFrameBackground.BackgroundSmall,
    MainMenuBarArtFrameBackground.BackgroundLarge,

    -- Statusbar
    StatusTrackingBarManager.SingleBarSmall,
    StatusTrackingBarManager.SingleBarSmallUpper,
    StatusTrackingBarManager.SingleBarLarge,
    StatusTrackingBarManager.SingleBarLargertUpper,

    -- Petbar
    SlidingActionBarTexture0,
    SlidingActionBarTexture1,

    -- Stance
    StanceBarLeft,
    StanceBarMiddle,
    StanceBarRight,
    StanceButton1NormalTexture2,
    StanceButton2NormalTexture2,
    StanceButton3NormalTexture2,
    StanceButton4NormalTexture2,
    StanceButton5NormalTexture2,
    StanceButton6NormalTexture2,
    StanceButton7NormalTexture2,
    StanceButton8NormalTexture2,
    StanceButton9NormalTexture2,
    StanceButton10NormalTexture2,
}

local GRYPHON = {
    MainMenuBarArtFrame.LeftEndCap,
    MainMenuBarArtFrame.RightEndCap,
}

-- Private Methos
local function HideGryphon(hide)
    for _, frame in pairs(GRYPHON) do
        if hide then
            Ui:SetHideFinal(frame)
        else
            Ui:UndoSetHideFinal(frame)
        end
    end
end

local function GetOpts()
    return {
        name = "Art",
        type = "group",
        args = {
            color = VertexColor:GetOpts(ART_COLOR_DB, "Art Color"),
            vis = {
                name = "Hide Gryphons",
                type = "toggle",
                get = function(...)
                    return Database:Get(ART_VIS_DB)
                end,
                set = function(self, value, ...)
                    Database:Set(ART_VIS_DB, value)
                    HideGryphon(value)
                end
            }
        }
    }
end

-- Ace3 Callbacks
function Art:OnInitialize()
    Log:v("Art_OnInitialize")
    Database:InitIfEmpty(ART_COLOR_DB, VertexColor.DEFAULT)
    Database:InitIfEmpty(ART_VIS_DB, false)
    BaikActionbar:AddOption(OPTION_NAME, GetOpts())

    VertexColor:AddFrameAll(FRAMES, ART_COLOR_DB)
end

function Art:OnEnable()
    Log:v("Art_OnEnable")
    VertexColor:Sync(ART_COLOR_DB)
    HideGryphon(Database:Get(ART_VIS_DB))
end

function Art:OnDisable()
    Log:v("Art_OnDisable")
end
