local BaikCore = LibStub("AceAddon-3.0"):GetAddon("BaikCore")
local Assert = BaikCore.Assert
local Log = BaikCore.Log
local Option = BaikCore.Option

-- Add Module
local BaikActionbar = BaikCore:NewModule("BaikActionbar")
BaikCore.BaikActionbar = BaikActionbar

-- Constants
BaikActionbar.OPTION_NAME = "action_bar"

local GENERAL_OPTION = {
    name = "General",
    type = "group",
    order = 0,
    args = {
    }
}

local OPTION = {
    name = "Actionbar",
    type = "group",
    childGroups = "tab",
    order = -1,
    args = {
        general = GENERAL_OPTION,
    }
}

-- BaikActionbar API
function BaikActionbar:AddOption(name, opt)
    Assert:String(name)
    Assert:Table(opt)


    Assert:Null(GENERAL_OPTION.args[name])

    GENERAL_OPTION.args[name] = opt
end

-- Ace3 Callbacks
function BaikActionbar:OnInitialize()
    Log:v("BaikActionbar_OnInitialize")
    Option:AddCategory(self.OPTION_NAME, OPTION)
end

function BaikActionbar:OnEnable()
    Log:v("BaikActionbar_OnEnable")
end

function BaikActionbar:OnDisable()
    Log:v("BaikActionbar_OnDisable")
end
