-- Author: Nerino1
-- Create Date : 3/09/2017
-- Version 3.0
-- Tons of credit to Goldpaw. I used his addons as a template

-- Using the Bagnon way to retrieve names, namespaces and stuff
local MODULE =  ...
local ADDON, Addon = MODULE:match("[^_]+"), _G[MODULE:match("[^_]+")]
local ChampionEquipment = Bagnon:NewModule("ChampionEquipment", Addon)
local ChampionEquipmentButton = Bagnon:NewModule("ChampionEquipmentButton", Addon)

-- Lua API
local f=CreateFrame("frame");
local _G = _G
local string_gsub = string.gsub
local string_match = string.match
local show_champ = 0

-- WoW API
local GetContainerItemInfo = _G.GetContainerItemInfo
local GetItemInfo = _G.GetItemInfo

local strings = {} -- cache of artifact power fontstrings
local cache = {} -- cache of artifact power values
local ignored = {} -- items with no artifact power we'll ignore (todo: add item types to this on startup, to reduce scanning delay)

-- Tooltip used for scanning
local tooltipName = "CEscanner"
local tooltipScanner = CreateFrame("GameTooltip", tooltipName, nil, "GameTooltipTemplate")



function ChampClick()
--print("clicked")
	if 
		show_champ == 0 then
		show_champ = 1
	else 
		show_champ = 0
	end
end

ChampionEquipmentButton.OnEnable = function(self)
	hooksecurefunc(Bagnon.Frame, "Update", function(self)	
		local btn = CreateFrame("Button", "champbtn", self, "OptionsButtonTemplate");
		--btn:SetPoint('TOPRIGHT', self.moneyFrame, 'TOPRIGHT', -4, 18)
		btn:SetPoint('TOPRIGHT', self.optionsToggle, 'TOPRIGHT', -24, 0)
		btn:SetHeight(20)
		btn:SetWidth(20)
		--btn:SetText("Champion Equipment")
		local icon = btn:CreateTexture()
		icon:SetAllPoints(true)
	--	icon:SetTexture("Interface\\Icons\\Achievement_Dungeon_ClassicRaider")
		icon:SetTexture("Interface\\Icons\\Ability_Parry")
		btn.icon = icon
		btn:SetScript("OnClick", function() ChampClick() end)
		btn:SetFrameLevel(3)
		btn:SetScript("OnEnter", function(self)
			GameTooltip:SetOwner(self, "ANCHOR_TOP")
			GameTooltip:SetText("Champion Equipment")
			GameTooltip:AddLine("Click to toggle Champion Equipment labels.", 1, 1, 1)
			GameTooltip:AddLine("Close and reopen bag after clicking.", 1, 1, 1)
			GameTooltip:Show()
		end)

		btn:SetScript("OnLeave", function() GameTooltip:Hide() end)
	end)
end	
		
ChampionEquipment.OnEnable = function(self)
	hooksecurefunc(Bagnon.ItemSlot, "Update", function(self) 
		local itemLink = self:GetItem() -- GetContainerItemLink(self:GetBag(), self:GetID())
		if itemLink and show_champ == 1 then
			local itemIsChampionEquipment = cache[itemLink]
			if (not itemIsChampionEquipment) then
				local itemID = tonumber(string_match(itemLink, "item:(%d+)"))
				if itemID and (not ignored[itemID]) then
					
					tooltipScanner:SetOwner(UIParent, "ANCHOR_NONE")
					tooltipScanner:SetHyperlink(itemLink)
					tooltipScanner:SetBagItem(self:GetBag(), self:GetID())
					for i = 2,4 do
						local line = _G[tooltipName.."TextLeft"..i]
						if line then
							local msg = line:GetText()
							if msg then
								msg = string_gsub(msg, ",", "")
								local championEquipment = string_match(msg, "Champion")
								if championEquipment then
								cache[itemLink] = championEquipment
								itemIsChampionEquipment = championEquipment
	--							print("got one")
								else
									-- Don't scan this itemID again this session
									ignored[itemID] = true
	--								print("ignored")
								end
							end
						end
					end
				end
			end
			if itemIsChampionEquipment then 
				if (not strings[self]) then
					-- Adding an extra layer to get it above glow and border textures
					local holder = _G[self:GetName().."ExtraInfoFrame"] or CreateFrame("Frame", self:GetName().."ExtraInfoFrame", self)
					holder:SetAllPoints()
					-- Using standard blizzard fonts here
					local itemCE = holder:CreateFontString()
					itemCE:SetDrawLayer("ARTWORK")
					itemCE:SetPoint("TOPLEFT", 2, -2)
					itemCE:SetFontObject(_G.NumberFont_Outline_Med or _G.NumberFontNormal) 
					itemCE:SetFont(itemCE:GetFont(), 11, "OUTLINE")
					itemCE:SetShadowOffset(1, -1)
					itemCE:SetShadowColor(0, 0, 0, .5)
					strings[self] = itemCE
				end
				strings[self]:SetText("Champ")
			else
				if strings[self] then
					strings[self]:SetText("")
				end
			end
		else
			if strings[self] then
				strings[self]:SetText("")
			end
		end
	end)
end