﻿-- ////////////////
-- Commande SLASH
-- ////////////////
SLASH_ATA1 = '/ata';
local function AtaCommand(msg, editbox)
	listeHF = 0;
	if msg == 'clean' then CleanTrackList()
	elseif msg == 'check' then CheckBestRaid()
	elseif msg == 'help' or msg == '' then
		print("AtA commands :");
		print(L["ata config"]);
		print(L["ata raid lk"]);
		print(L["ata raid cata"]);
		print(L["ata check"]);
		print(L["ata clean"]);
		print(L["ata save"]);
		print(L["ata load"]);
		print(L["ata defaut"]);
		print(L["ata mount"]);
	elseif msg == 'mount' then CheckMount(false);
	elseif msg == 'mount full' then CheckMount(true);
	elseif msg == 'config' then
		AutoTrackerAchievement:Show();
		if AutoTrackerAchievementDB["Arena"] == true then AutoTrackerAchievement_CheckButton1:SetChecked(true); end
		if AutoTrackerAchievementDB["Raid"] == true then AutoTrackerAchievement_CheckButton2:SetChecked(true); end
		if AutoTrackerAchievementDB["Region"] == true then AutoTrackerAchievement_CheckButton3:SetChecked(true); end
		if AutoTrackerAchievementDB["Donjon"] == true then AutoTrackerAchievement_CheckButton4:SetChecked(true); end
		if AutoTrackerAchievementDB["defaut"] == true then AutoTrackerAchievement_CheckButton5:SetChecked(true); end
	elseif msg == 'reset' then AutoTrackerAchievementDB = AutoTrackerAchievementDB_Defaut;
	elseif msg == 'debug' then
		local name, realm = UnitName("player")
		if name == "Garikover" then
			if AutoTrackerAchievementDB["debug"] == true then
				AutoTrackerAchievementDB["debug"] = false
				print("Ata Debug mode : OFF");
				else
				AutoTrackerAchievementDB["debug"] = true
				print("Ata Debug mode : ON");
			end
		end
	elseif msg == 'info' then
		name, instanceType, difficultyID, difficultyName, maxPlayers, dynamicDifficulty, isDynamic, instanceMapID = GetInstanceInfo()
		print("Idzone = ",GetCurrentMapAreaID())
		print("Diff = ",difficulty);
	elseif string.find(msg, 'save ') == 1 then SaveTrackList(msg);
	elseif string.find(msg, 'load ') == 1 then LoadTrackList(msg);
	elseif string.find(msg, 'defaut ') == 1 then DefautTrackList(msg);
	--elseif msg == 's' then SaveTrackQuests()
	--elseif msg == 'l' then LoadTrackQuests()
	elseif msg == 'get' then AtaMainFunction()
	else
		listeHF = RaidListe(msg);
		if listeHF ~= 0 then
			CleanTrackList()
			AchievListTable(listeHF)
		else
			print(L["Commande non reconnue"]);
		end
	end	
end
SlashCmdList["ATA"] = AtaCommand;

-- ////////////////
-- Données
-- ////////////////
local AutoTrackerAchievementDB_Defaut = {
	["Arena"] = true,
	["Raid"] = true,
	["Region"] = true,
	["Donjon"] = true,
	["defaut"] = true,
	["defautliste"] = "",
	["Favoris"] = {},
	["debug"] = false,
	["version"] = 7.0,
}

local AtaDiff = {

	["None"] = {0, "None",}, -- 0 - None; not in an Instance.
	["5NM"] = {1, "5NM",}, -- 1 - 5-player Instance.
	["5HM"] = {2, "5HM",}, -- 2 - 5-player Heroic Instance.
	["10NM"] = {3, "10NM",}, -- 3 - 10-player Raid Instance.
	["25NM"] = {4, "25NM",}, -- 4 - 25-player Raid Instance.
	["10HM"] = {5, "10HM",}, -- 5 - 10-player Heroic Raid Instance.
	["25HM"] = {6, "25HM",}, -- 6 - 25-player Heroic Raid Instance.
	["LFR"] = {17, "LFR",}, -- 7 - 25-player Raid Finder Instance.
	["Challenge"] = {8, "Challenge",}, -- 8 - Challenge Mode Instance.
	["40NM"] = {9, "40NM",}, -- 9 - 40-player Raid Instance.
	-- 10 - Not used.
	["HeroicScenario"] = {11, "Scenario HM",}, -- 11 - Heroic Scenario Instance.
	["NormalScenario"] = {12, "Scenario",}, -- 12 - Scenario Instance.
	-- 13 - Not used.
	["FlexNormal"] = {14, "Flex NM",}, -- 14 - 10-30-player Normal Raid Instance.
	["FlexHeroic"] = {15, "Flex HM",}, -- 15 - 10-30-player Heroic Raid Instance.
	["Mythic"] = {16, "Mythic",}, -- 16 - 20-player Mythic Raid Instance .
	-- 17 - 10-30-player Raid Finder Instance.
	-- 18 - 40-player Event raid (Used by the level 100 version of Molten Core for WoW's 10th anniversary).
	-- 19 - 5-player Event instance (Used by the level 90 version of UBRS at WoD launch).
	-- 20 - 25-player Event scenario (unknown usage).
	-- 21 - Not used.
	-- 22 - Not used.
	-- 23 - Mythic 5-player Instance.
	-- 24 - Timewalker 5-player Instance.
	
	}

local AtaColor = {
	Green = "|cFF00FF00",
	Red = "|cFFFF0000",
	Blue = "|cFF0000FF",
	Yellow = "|cFFFFFF00",
	}

local HFNeutre = {
	-- Régions
		[16] = {4896,},  -- Arathi Highlands
		[17] = {4900,5444,},  -- Badlands
		[475] = {1193,1276,},  -- Blade's Edge Mountains
		[19] = {4909,},  -- Blasted Lands
		[29] = {4901,},  -- Burning Steppes
		[640] = {4871,5445,5450,5446,5447,5449,},  -- Deepholm
		[101] = {4930,},  -- Desolace
		[23] = {4892,},  -- Eastern Plaguelands
		[182] = {4931,},  -- Felwood
		[492] = {40,},    -- Icecrown
		[606] = {4870,5869,4959,5864,5868,5861,5483,5865,5862,5860,},  -- Mount Hyjal
		[479] = {1194,},  -- Netherstorm
		[37] = {4906,},  -- Northern Stranglethorn
		[28] = {4910,},  -- Searing Gorge
		[473] = {1195,},  -- Shadowmoon Valley
		[493] = {39,938,},	-- Sholazar Basin
		[261] = {4934,},  -- Silithus
		[38] = {4904,},  -- Swamp of Sorrows
		[161] = {4935,},  -- Tanaris
		[673] = {4905,},  -- The Cape of Stranglethorn
		[26] = {4897,},  -- The Hinterlands
		[495] = {38,1428,},    -- The Storm Peaks
		[61] = {4938,},  -- Thousand Needles
		[720] = {4872,4961,5317,},  -- Uldum
		[201] = {4939,},  -- Un'Goro Crater
		[22] = {4893,},  -- Western Plaguelands
		[281] = {4940,5443,},  -- Winterspring
		[467] = {1190,},  -- Zangarmarsh
		[496] = {36,1596,},    -- Zul'Drak
		[181]  = {5547,5448,5546,},	-- Azshara
		[42] = {5453,}, -- Sombrivage
		[478] = {1275,}, -- Terokkar
		[477] = {939,}, -- Nagrand
		-- CATACLYSM
		[488] = {1277,547,}, -- Desolation des dragons
		[486] = {561,}, -- Toundra
		[613] = {4975,5452,}, -- Vashj'ir
		[700] = {5451,4960,}, -- Hautes terres du Crepuscule
		[795] = {5870,5872,5874,5859,5866,5871,5867,}, -- Front du magma
		-- PANDARIE
		[809] = {6537,7286,},  -- Kun-Lai Summit
		[858] = {6540,7316,7312,7313,},  -- Dread Wastes
		[810] = {6539,7297,7298,7288,7299,},  -- Townlong Steppes
		[811] = {7315,7317,7319,7320,},  -- Vale of Eternal Blossoms
		[807] = {6301,7295,},  -- Valley of the Four Winds
		[928] = {8099,8103,8104,8108,8109,8111,8114,8116,8118,8120,8101,8105,8107,8110,8112,8115,8117,8119,8212}, -- L’île du Tonnerre
		[929] = {8123,}, -- L'ile des geants
		[951] = {8714,8726,8729,8712,8728,8730,8727,8723,8784,8722,8725,8724,8743,}, -- Ile du temps figé
		-- DRAENOR
		[949] = {8939,9400,9401,9402,9659,9607,9659,9656,9655,9667,9663,9658,9678,9654,}, -- Gorgrond
		[941] = {8937,9533,9535,9534,9710,9711,9536,9537,}, -- Crête de Givrefeu
		[947] = {8938,9433,8845,9434,9483,9437,9435,9433,9481,9436,9479,9432,}, -- Vallée d'Ombrelune
		[950] = {8942,9615,9617,9541,9548,9610,}, -- Nagrand
		[946] = {8940,9632,9638,9674,9434,9636,9634,9637,9632,9638,9636,9635,9633,9486,}, -- Talador
		[948] = {8941,9613,9612,9600,9571,9601,}, -- Flêches d'Arak
		[945] = {10261,10260,10069,10061,10262,10070,}, -- Jungle de Tanaan
		-- LEGION
		[1015] = {11261,10665,11256,}, -- Azsuna
		[1018] = {11262,10666,11258,}, -- Val'sharah
		[1024] = {11264,10667,11257,}, -- Highmountain / Haut Roc
		[1017] = {11263,10668,11259,}, -- Tornheim
		[1033] = {11265,10669,11260,}, -- Suramar
		[1014] = {11066,}, -- Dalaran
		[1170] = {12101,12102,12103,12104,12069,}, -- Mac'Aree
		[1171] = {12101,12102,12103,12104,12069,}, -- Antoran Wastes
		[1135] = {12101,12102,12103,12104,12069,}, -- Krokuun
		[1184] = {12069,12077,12078,}, -- Argus
		-- BATTLE FOR AZEROTH
		-- TODO
		
	-- Scenarios
		[899] = {7273,7272}, -- Arene annihilation
		[900] = {7275,7276},  -- Crypte des Rois oublies
		[884] = {6930,6931}, -- Festival de Brasse-Lune
		[906] = {7527,7526}, -- Marecage d'Âprefange A
		[851] = {7530,7529}, -- Marecage d'Âprefange H
		[880] = {7266,7267}, -- La forêt de Jade // Pierre verte
		[878] = {7261,7258,7257}, -- Une biere foudroyante
		[882] = {7231,7232,7239,7248}, -- Unga Ingou
		[911] = {8011,8012}, -- Le territoire du Lion
		[913] = {8014,8015}, -- Halte de la Domination
		[912] = {7989,7990,7991,7992,7993}, -- Un peu de patience
		[914] = {7984,7986,7987}, -- Une dague dans la nuit
		[883] = {8017,8016}, --Zan'vess
		[934] = {8106,}, -- Le tresor du roi-tonnerre
		[937] = {8319,}, -- Sombre coeur de la pandarie
		[940] = {8347,}, -- Bataille en haute mer
		[939] = {8329,8330,}, -- Du sang dans la neige
		[938] = {8295,}, -- Les secrets de Ragefeu
		
	--Donjons
		-- LK
		[523] = {1919,}, -- Donjon d'Utgarde
		[520] = {2150,2036,2037,}, -- Le Nexus
		[533] = {1860,1296,1297,}, -- Azjol-Nerub
		[522] = {1862,2038,2056,}, -- Ahn’kahet : l’Ancien royaume
		[534] = {2151,2057,2039,}, -- Donjon de Drak’Tharon
		[536] = {2041,1865,2153,1816,}, -- Le fort Pourpre
		[530] = {2058,2152,2040,1864,}, -- Gundrak
		[526] = {2151,1866,2155,}, -- Ulduar: Les salles de Pierre
		[524] = {2043,2156,2157,1873,1790,}, -- Donjon d’Utgarde: Cime d’Utgarde
		[528] = {1871,1868,2046,2044,2045,}, -- L’Oculus
		[525] = {1834,2042,1867,}, -- Ulduar: Les salles de Foudre
		[542] = {3802,3804,3803,}, -- L’epreuve du champion
		[521] = {1872,1817,}, -- Grottes du Temps: L’epuration de Stratholme
		[602] = {4525,4524,}, -- Citadelle de la Couronne de glace: Fosse de Saron
		[601] = {4522,4523,}, -- Citadelle de la Couronne de glace: La Forge des Âmes
		[603] = {4526,}, -- Citadelle de la Couronne de glace: Salles des Reflets
		-- CATACLYSM
		[753] = {5281,5282,5283,5284,}, -- Cavernes de Rochenoire
		[747] = {5290,5291,5292,}, -- Cite perdue des Tol’vir
		[757] = {5297,5298,}, -- Grim Batol
		[767] = {5285,5286,}, -- Trône des marees
		[820] = {5995,6130,}, -- La fin des temps
		[769] = {5288,5289,}, -- La cime du Vortex
		[768] = {5287,}, -- Le Cœur-de-Pierre
		[819] = {}, -- Heure du crepuscule
		[816] = {6127,6070,}, -- Puits d'eternite
		[759] = {5294,5295,5293,5296,}, -- Salles de l'Origine
		[781] = {5761,5750,5760,5858,}, -- Zul'Aman
		[793] = {5744,5743,5759,5762,}, -- Zul'Gurub
		-- PANDARIE
		[876] = {6420,6400,6089,6402,},  -- Brasserie Brune d'Orage
		[877] = {6477,6472, 6471,},  -- Monastere des Pandashan
		[20] = {6929,6946,6928,},  -- Monastere Ecarlate / cimetiere (1)
		[874] = {6929,6946,6928,},  -- Monastere Ecarlate / cimetiere (2)
		[885] = {6478,6736,6713,}, -- Palais Mogu’shan
		[875] = {6476,6479,6945,}, -- Porte du Soleil couchant
		[871] = {6427,6684,}, -- Salles ecarlates
		[898] = {6531,6394,6396,6821,}, -- Scholomance
		[887] = {6822,6688,6485,}, -- Temple Niuzao
		[867] = {6460,6475,6671,}, -- Un dague dans la nuit
		-- DRAENOR
		[984] = {9552,9023,9551,}, -- Auchindoun
		[993] = {9024,9007,}, -- Dêpot de Tristerail
		[1008] = {9017,9493,9223,}, -- La Flore éternelle
		[964] = {9008,8993,9005,}, -- Mine de la Masse-Sanglante
		[989] = {9033,9035,9034,9036,}, -- Orée-du-ciel
		[987] = {9082,9083,9081,}, -- Quais de Fer
		[969] = {9025,9026,9018,}, -- Terres sacrées de Ombrelune
		[995] = {9057,9058,9045,9056}, -- Sommets du Pic Rochenoire
		-- LEGION
		[1081] = {10709,10710,10711,}, -- Bastion du Freux
		[1146] = {11768,11703,11769,}, -- Cathedrale de la Nuit éternelle
		[1045] = {10679,10707,10680,}, -- Caveau des gardiennes
		[1087] = {10610,10611,}, -- Cour des étoiles
		[1067] = {10769,10766,}, -- Fourré Sombrecoeur
		[1042] = {10413,10411,10412,}, -- Gueule des âmes
		[1079] = {10773,10775,10776,}, -- L'Arcavia
		[1066] = {10554,10553,}, -- Fort Pourpre (Legion)
		[1046] = {10456,10458,10457,}, -- Œil d'Azshara
		[1065] = {10996,10875,}, -- Repaire de Neltharion
		[1115] = {11335,11433,11338,11746,11432,11430,}, -- Retour à Karazhan
		[1041] = {10542,10543,}, -- Salles des Valeureux
		[1178] = {12004,12005,12009,}, -- Le siège du Triumvirat
		-- BATTLE FOR AZEROTH
		-- TODO
		[0] = {,}, -- Alliance -- Port-Liberté
		[0] = {,}, -- Alliance -- Tol Dagor
		[0] = {,}, -- Alliance -- Manoir Malvoie
		[0] = {,}, -- Alliance -- Sanctuaire des Tempêtes
		[0] = {,}, -- Alliance -- Siège de Boralus
		[0] = {,}, -- Horde -- Atal'Dazar
		[0] = {,}, -- Horde -- le Filon !
		[0] = {,}, -- Horde -- Temple de Sephraliss
		[0] = {,}, -- Horde -- Les tréfonds Putrides
		[0] = {,}, -- Horde -- Repos des rois
}
	
local HFAlliance = {
	[43]  = {4925,},  -- Ashenvale
	[476] = {4926,},  -- Bloodmyst Isle
	[486] = {33,},    -- Borean Tundra
	[42]  = {4928,},  -- Darkshore
	[488] = {35,},    -- Dragonblight
	[34]  = {4903,},  -- Duskwood
	[141] = {4929,},  -- Dustwallow Marsh
	[121] = {4932,},  -- Feralas
	[490] = {37,},    -- Grizzly Hills
	[465] = {1189,},  -- Hellfire Peninsula
	[491] = {34,},    -- Howling Fjord
	[35]  = {4899,},  -- Loch Modan
	[477] = {1192,},  -- Nagrand
	[36]  = {4902,},  -- Redridge Mountains
	[607] = {4937,},  -- Southern Barrens
	[81]  = {4936,},  -- Stonetalon Mountains
	[478] = {1191,},  -- Terokkar Forest
	[700] = {4873,5320,5481,},  -- Twilight Highlands
	[613] = {4869,5318,},  -- Vashj'ir
	[39]  = {4903,},  -- Westfall
	[40]  = {4898,},  -- Wetlé"'(è_çà)ands
	[857] = {6535,},  -- Krasarang Wilds
	[809] = {6537,},  -- Kun-Lai Summit
	[806] = {6300,},  -- The Jade Forest
	[947] = {8845,9602,9528,}, -- Vallée d'Ombrelune
	[949] = {8923,}, -- Gorgrond
	[950] = {8927,}, -- Nagrand
	[946] = {8920,}, -- Talador
	[948] = {8925,}, -- Flêches d'Arak
	[945] = {10068,10072,}, -- Jungle de Tanaan
	}

local HFHorde = {
	[43]  = {4976,},  -- Ashenvale
	[181] = {4927,5454,},  -- Azshara
	[486] = {1358,},  -- Borean Tundra
	[488] = {1359,},  -- Dragonblight
	[141] = {4978,},  -- Dustwallow Marsh
	[121] = {4979,},  -- Feralas
	[463] = {4908,},  -- Ghostlands
	[490] = {1357,},  -- Grizzly Hills
	[465] = {1271,},  -- Hellfire Peninsula
	[24]  = {4895,},  -- Hillsbrad Foothills
	[491] = {1356,},  -- Howling Fjord
	[477] = {1273,},  -- Nagrand
	[11]  = {4933,},  -- Northern Barrens
	[21]  = {4894,},  -- Silverpine Forest
	[607] = {4981,},  -- Southern Barrens
	[81]  = {4980,},  -- Stonetalon Mountains
	[478] = {1272,},  -- Terokkar Forest
	[700] = {5501,5482,5321,},  -- Twilight Highlands
	[613] = {4982,5319,},  -- Vashj'ir
	[857] = {6536,},  -- Krasarang Wilds
	[809] = {6538,},  -- Kun-Lai Summit
	[806] = {6534,},  -- The Jade Forest
	[949] = {8924,}, -- Gorgrond
	[941] = {9606,8671,}, -- Crête de Givrefeu
	[950] = {8928,}, -- Nagrand
	[947] = {9529,}, -- Vallée d'Ombrelune
	[946] = {8919,}, -- Talador
	[948] = {8926,}, -- Flêches d'Arak
	[945] = {10075,10265,}, -- Jungle de Tanaan
	}
	
local HFRaids = {
	-- Wrath of the Lich King
	["onyxia10"] = {4402,4404,4403,},
	["onyxia25"] = {4405,4407,4406,},
	["archavon10"] = {4016},
	["archavon25"] = {4017},
	["malygos10"] = {1874,2148},
	["malygos25"] = {1875,2149},
	["sartha10"] = {2049,2050,2051,624,2047},
	["sartha25"] = {2052,2053,2054,1877,2048},
	["naxx10"] = {1997,1858,1856,2178,2176,1996,2182,2146,2184,578},
	["naxx25"] = {2140,1859,1857,2179,2177,2139,2183,2147,2185,579},
	["ulduar10"] = {2907,2909,3056,2905,2911,2925,2927,2930,2923,2919,2933,3058,2937,2934,2931,2947,2945,2941,2940,2939,2951,2959,2953,2955,3006,3076,2961,3182,2963,2967,3176,2971,2977,2975,2973,2982,2980,3179,2989,3180,3138,3181,2996,3159,3015,3008,3012,3014,3003},
	["ulduar25"] = {2908,2910,3057,2906,2912,2926,2928,2929,2924,2921,3059,2938,2936,2932,2948,2946,2944,2943,2942,2952,2960,2954,2956,3007,3077,2962,3184,2965,2968,3183,2972,2978,2976,2974,2983,2981,3187,3237,3189,2995,3188,2997,3164,3016,3010,3013,3017,3002},
	["coliseum10"] = {3917,3797,3936,3996,3799,3800},
	["coliseum25"] = {3916,3813,3937,3997,3815,3816},
	["icc25"] = {4534,4535,4536,4537,4538,4577,4578,4582,4539,4579,4580,4581,4601},
	["icc10"] = {4610,4611,4612,4613,4614,4615,4616,4617,4618,4619,4620,4622,4621},
	-- Cataclysm
	["bwd"] =  {5306,5309,5307,5310,5308,4849,4842},
	["bot"] =  {4852,5312,5311,4850},
	["tfw"] =  {5304,5305,4851},
	["firelands "] =  {5810,5813,5829,5821,5855,5799,5830,5802},
	["ds"] =  {6174,6180,6128,6105,6133,6107,6175,6084},
	-- Mists of Pandaria
	["ms"] = {6455,7056,6687,6823,6674,6686,},
	["hof"] = {6553,6937,6922,6683,6518,6936,},
	["tes"] = {6824,6825,6717,6933,},
	["tot"] = {8094,8038,8073,8077,8082,8097,8098,8037,8081,8087,8086,8090,},
	["os"] = {8537,8529,8461,8448,8530,8520,8462,8543,8459,8527,8531,8453,8536,8538,8521,8532,8528,8679,}, -- Raid Orgrimmar
	-- Warlords of Draenor
	["Highmaul"] = {8948,8947,8974,8958,8975,8976,8977,}, -- Highmaul
	["BRF"] = {8979,8980,8930,8983,8982,8978,8929,8981,8984,8952,}, -- Blackrock Fundry
	["HFC"] = {10013,10012,10020,10087,10073,9979,10057,10030,9989,10086,10026,9988,9972,}, -- Citadelle des flammes infernales
	-- Legion
	["EM"] = {10555, 10772,10753,10663,10755,10771,10830,}, -- Emerald Nightmare / Cauchemar d'émeraude
	["TOV"] = {11337,11387,11386,11377,}, -- Trial of Valor / Jugement des Valeureux
	["Nighthold"] = {10575,10817,10851,10696,10699,10754,10829,10697,10704,10678,10742,}, -- Nighthold / Palais Sacrenuit
	["TOS"] = {11770,11696,11683,11724,11773,11676,11675,11699,11674,}, -- Tomb of Sargeras
	["Antorus"] = {12257, 11948, 12065, 11949, 12030, 11915, 11928, 12046, 12067, 11930, 12129,}, -- Antorus
	-- Battle for Azeroth
	["Uldir"] = {,}, -- Uldir
	}
	
local Mount = {
	-- Vanilla
	{17481,"Baron Vaillefendre",765,AtaDiff["5NM"]}, -- Destrier de Vaillefrendre
	{26054,"Trash AQ40",766,AtaDiff["25NM"]}, -- Cristal de résonance qiraji rouge
	{26055,"Trash AQ40",766,AtaDiff["25NM"]}, -- Cristal de résonance qiraji jaune
	{25953,"Trash AQ40",766,AtaDiff["25NM"]}, -- Cristal de résonance qiraji bleu
	{26056,"Trash AQ40",766,AtaDiff["25NM"]}, -- Cristal de résonance qiraji vert
	-- Burning Crusade
	{41252,"Anzu",723,AtaDiff["25NM"]}, -- Rênes du seigneur corbeau
	{46628,"Kael'thas Haut-Soleil",798,AtaDiff["25NM"]}, -- Faucon-pérégrin blanc rapide
	{36702,"Attumen le Veneur",799,AtaDiff["25NM"]}, -- Rênes de cheval de guerre embrasé
	{40192,"Kael'thas Haut-Soleil",789,AtaDiff["25NM"]}, -- Cendres d'Al'ar
	-- Wrath of the Lich
	{59996,"Skadi le Brutal",524,AtaDiff["5NM"]}, -- Rênes de proto-drake bleu
	{59569,"Corrupteur infini",521,AtaDiff["5NM"]}, -- Rênes de drake bronze
	{61467,"Caveau d’Archavon",532,AtaDiff["10NM"]}, -- Rênes de grand mammouth de guerre noir (horde)
	{61465,"Caveau d’Archavon",532,AtaDiff["10NM"]}, -- Rênes de grand mammouth de guerre noir (alliance)
	{59567,"Malygos",527,AtaDiff["10NM"]}, -- Rênes de drake azur
	{59568,"Malygos",527,AtaDiff["10NM"]}, -- Rênes de drake bleu
	{59571,"Sartharion + 3D",531,AtaDiff["25NM"]}, -- Rênes de drake du Crépuscule
	{59650,"Sartharion + 3D",531,AtaDiff["10NM"]}, -- Rênes de drake noir
	{69395,"Onyxia",718,AtaDiff["25NM"]}, -- Rênes de drake onyxien
	{63796,"Yogg Saron",529,AtaDiff["25NM"]}, -- Tête de Mimiron
	{72286,"Lich King",604,AtaDiff["25HM"]}, -- Rênes d'Invincible
	--C ataclysm
	{88742,"Altairus",769,AtaDiff["5HM"]}, -- Rênes de drake du vent du Nord
	{88746,"Peau-de-Pierre",768,AtaDiff["5NM"]}, -- Rênes de drake de pierre vitrifiée
	{68824,"Grande prêtresse Kilnara",793,AtaDiff["5HM"]}, -- Panthère zulienne rapide
	{96491,"Seigneur sanglant Mandokir",793,AtaDiff["5HM"]}, -- Raptor razzashi cuirassé
	{98204,"Zul'Aman",781,AtaDiff["5HM"]}, -- Ours de bataille amani
	{88744,"Al’Akir",773,AtaDiff["10NM"]}, -- Rênes de drake du vent du Sud
	{101542,"Alysrazor",800,AtaDiff["10NM"]}, -- Serres-de-Flammes d’Alysrazor
	{97493,"Ragnaros",800,AtaDiff["10NM"]}, -- Oeuf fumant de Millagazor
	{110039,"Ultraxion",824,AtaDiff["10NM"]}, -- Expérience 12-B
	{107842,"Aile-de-mort",824,AtaDiff["10NM"]}, -- Rênes de drake flamboyant
	{107845,"Aile-de-mort",824,AtaDiff["10HM"]}, -- Suivante de la Lieuse-de-vie
	-- Mysts of Pandaria
	{127170,"Elegon",896,AtaDiff["10NM"]}, -- Rênes de serpent-nuage astral
	{136471,"Horridon",930,AtaDiff["10NM"]}, -- Rejeton d’Horridon
	{139448,"Ji Kun",930,AtaDiff["10NM"]}, -- Etreinte de Ji Kun
	{148417,"Garrosh Hurlenfer",953,AtaDiff["FlexNormal"]}, -- Mastodonte kor’kron
	-- Warlords of Draenor
	{116660,"Main Noire",1026,AtaDiff["Mythic"]}, -- Destructeur sabot de fer
	{123890,"Archimonde",1026,AtaDiff["Mythic"]}, -- Annihilateur en gangracier
	-- Legion
	{142236,"Attumen",1115,AtaDiff["5NM"]}, -- Rênes éternelles de Minuit
	{137574,"Gul'Dan",1088,AtaDiff["FlexNormal"]}, -- Noyau de brasier infernal
	{137575,"Gul'Dan",1088,AtaDiff["Mythic"]}, -- Noyau de flammes dévorantes
	{143643,"Maîtresse Sassz'ine",1147,AtaDiff["FlexNormal"]}, -- Ver abyssal
	{152789,"Argus l'Annihilateur",1188,AtaDiff["Mythic"]}, -- Ur'zul entravé

	}

local IdZoneRaid = {
	-- Wrath of the Lich King
	["onyxia10"] = 718,
	["onyxia25"] = 718,
	["archavon10"] = 532,
	["archavon25"] = 532,
	["malygos10"] = 527,
	["malygos25"] = 527,
	["sartha10"] = 531,
	["sartha25"] = 531,
	["naxx10"] = 535,
	["naxx25"] = 535,
	["ulduar10"] = 529,
	["ulduar25"] = 529,
	["coliseum10"] = 543,
	["coliseum25"] = 543,
	["icc25"] = 604,
	["icc10"] = 604,
	-- Cataclysm
	["bwd"] =  754,
	["bot"] =  758,
	["tfw"] =  773,
	["firelands "] =  800,
	["ds"] =  824,
	-- Mists of Pandaria
	["ms"] = 896,
	["hof"] = 897,
	["tes"] = 886,
	["tot"] = 930,
	["os"] = 953, -- Raid Orgrimmar
	-- Warlords of Draenor
	["Highmaul"] = 994, -- Highmaul
	["BRF"] = 988, -- Blackrock Fundry
	["HFC"] = 1026, -- Citadelle des flammes infernales
	-- Legion
	["EM"] = 1094,
	["TOV"] = 1114,
	["Nighthold"] = 1088,
	["TOS"] = 1147,
	["Antorus"] = 1188,
	-- BfA
	
	}
	
-- ////////////////
-- Fonctions XML
-- ////////////////
function Ata_CheckButton1_OnClick() -- Arena
if AutoTrackerAchievementDB["Arena"] == true then AutoTrackerAchievementDB["Arena"] = false else AutoTrackerAchievementDB["Arena"] = true end
if AutoTrackerAchievementDB["debug"] == true then print("Arena",AutoTrackerAchievementDB["Arena"]); end
end
function Ata_CheckButton2_OnClick() -- Raid
if AutoTrackerAchievementDB["Raid"] == true then AutoTrackerAchievementDB["Raid"] = false else AutoTrackerAchievementDB["Raid"] = true end
if AutoTrackerAchievementDB["debug"] == true then print("Raids",AutoTrackerAchievementDB["Raid"]); end
end
function Ata_CheckButton3_OnClick() -- Region
if AutoTrackerAchievementDB["Region"] == true then AutoTrackerAchievementDB["Region"] = false else AutoTrackerAchievementDB["Region"] = true end
if AutoTrackerAchievementDB["debug"] == true then print("Region",AutoTrackerAchievementDB["Region"]); end
end
function Ata_CheckButton4_OnClick() -- Donjon
if AutoTrackerAchievementDB["Donjon"] == true then AutoTrackerAchievementDB["Donjon"] = false else AutoTrackerAchievementDB["Donjon"] = true end
if AutoTrackerAchievementDB["debug"] == true then print("Donjon",AutoTrackerAchievementDB["Donjon"]); end
end
function Ata_CheckButton5_OnClick() -- defaut
if AutoTrackerAchievementDB["defaut"] == true then AutoTrackerAchievementDB["defaut"] = false else AutoTrackerAchievementDB["defaut"] = true end
if AutoTrackerAchievementDB["debug"] == true then print("defaut",AutoTrackerAchievementDB["defaut"]); end
end
function Ata_Button1_OnClick()
AutoTrackerAchievement:Hide();
end
function Ata_Button2_OnClick()
if AutoTrackerAchievementDB["debug"] == true then print("Reset"); end
AutoTrackerAchievementDB = AutoTrackerAchievementDB_Defaut;
end
function Ata_Button3_OnClick()
	DefautTrackList(defautval:GetText());
end

-- ////////////////
-- Processus passif
-- ////////////////

local function eventHandler(self, event, arg1,...)
	AtaLocalisation(GetLocale())
	if arg1 == "AutoTrackerAchievement" and event == "ADDON_LOADED" then
		print("Achievement Tracker : OK");
		if AutoTrackerAchievementDB == nil then
			print(L["Creation de la sauvegarde"]);
			AutoTrackerAchievementDB = AutoTrackerAchievementDB_Defaut;
		elseif AutoTrackerAchievementDB["version"] == nil or AutoTrackerAchievementDB["version"] < AutoTrackerAchievementDB_Defaut["version"] then
			print(L["Mise a jour"]);
			-- sauvegarde des anciens parametres
			AutoTrackerAchievementDB_Old = AutoTrackerAchievementDB
			-- ajustement des parametres
			AutoTrackerAchievementDB = AutoTrackerAchievementDB_Defaut		
			-- inserer une restauration des donnees
			for i1,v1 in pairs(AutoTrackerAchievementDB) do
			if AutoTrackerAchievementDB_Old[i1] ~= nil then AutoTrackerAchievementDB[i1] = AutoTrackerAchievementDB_Old[i1] end
			end
		end
	end
	if event == "ZONE_CHANGED_NEW_AREA" or event == "QUEST_ACCEPTEDss" then AtaMainFunction(); end
	--if event == "QUEST_ACCEPTED" then CleanTrackList(); end
	if AutoTrackerAchievementDB["debug"] == true then print("Event : ",event); end
	ModificationFrame()
end

-- FONCTION DE CHARGEMENT
function AutoTrackerAchievement_OnLoad(self)
self:RegisterEvent("ADDON_LOADED");
self:RegisterEvent("ZONE_CHANGED_NEW_AREA");
self:RegisterEvent("PLAYER_ENTERING_WORLD");
self:RegisterEvent("VARIABLES_LOADED");
self:RegisterEvent("QUEST_ACCEPTED");
self:SetScript("OnEvent", eventHandler);
end

-- FONCTIONS RECURRENTES
function CleanTrackList() 
	local achievlisted = {GetTrackedAchievements()};	
	for i=1,#achievlisted do
	RemoveTrackedAchievement(achievlisted[i])
	end
	if AutoTrackerAchievementDB["debug"] == true then print("Nettoyage liste"); end
end
function SaveTrackList(msg)
	local achievlisted = {GetTrackedAchievements()};	
	name = string.gsub(msg, "save ", "");
	if AutoTrackerAchievementDB["debug"] == true and name ~= "" then
	print("Sauvegarde : " .. name);
	AutoTrackerAchievementDB["Favoris"][name] = achievlisted;
	elseif name ~= "" then
	print(L["Liste sauvegardee"]);
	AutoTrackerAchievementDB["Favoris"][name] = achievlisted;
	else
	print(L["Nom de sauvegarde invalide"]);
	end
end
function LoadTrackList(msg)
	name = string.gsub(msg, "load ", "");
	if AutoTrackerAchievementDB["Favoris"][name] ~= nil then
	Liste = AutoTrackerAchievementDB["Favoris"][name];
	AchievListTable(Liste);
	else
	print(L["Pas de liste de ce nom"]);
	end
end
function DeleteTrackList(msg)
	name = string.gsub(msg, "delete ", "")
	AutoTrackerAchievementDB["Favoris"][name] = 0
	tableau = AutoTrackerAchievementDB["Favoris"]
	NewTab = {}
end
function DefautTrackList(msg)
	name = string.gsub(msg, "defaut ", "");
	if AutoTrackerAchievementDB["Favoris"][name] ~= nil then
	AutoTrackerAchievementDB["defautliste"] = name
	if AutoTrackerAchievementDB["debug"] == true then print("Defaut " .. name); end
	else
	print(L["Pas de liste de ce nom"]);
	end
end

-- Tracking des quetes
function SaveTrackQuests()
	listequetes = {}
	if GetNumQuestWatches() > 0 then
		for i = 1,GetNumQuestWatches() do
		questIndex = GetQuestIndexForWatch(1)
		table.insert(listequetes, questIndex)
		RemoveQuestWatch(questIndex)
			if AutoTrackerAchievementDB["debug"] == true then print("Save " .. GetQuestLink(questIndex)); end
		end
	end
end
function LoadTrackQuests()
	if listequetes ~= nil then
	for i=1, #listequetes do
	AddQuestWatch(listequetes[i])
	if AutoTrackerAchievementDB["debug"] == true then print("Load " .. GetQuestLink(listequetes[i])); end
	end
	end
	listequetes = {}
end

-- FONCTION PRINCIPALE
function AtaMainFunction()
	SetMapToCurrentZone()

	instanceName, instanceType, difficulty, difficultyName, maxPlayers, dynamicDifficulty, isDynamic, instanceMapID = GetInstanceInfo()
	local nbtracked = 0
	
	-- DEBUG	
	nbQuests = GetNumQuestWatches()

	CleanTrackList() -- on vire les HFs
	SaveTrackQuests() -- on vire les quêtes + sauvegarde
	IdZone = GetCurrentMapAreaID();
	
	if AutoTrackerAchievementDB["debug"] == true then
		print("Zone = "..IdZone);
		print("nbQuests = "..nbQuests);
		if RaidListe(IdZone) ~= 0 then print("RaidListe = OK"); end
		if CategorieListe(IdZone) ~= 0 then print("CatéListe = OK"); end
	end
	
	-- Arene
	if CategorieListe(IdZone) ~= 0 and AutoTrackerAchievementDB["Arena"] then 
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Arene"); end
		nbtracked = AchievListCat(CategorieListe(IdZone))
	-- Sombrelune + reload quests
	elseif IdZone == 823 and AutoTrackerAchievementDB["Region"] and nbQuests == 0 then
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Sombrelune"); end
		nbtracked = AchievListCat(CategorieListe(823))
	-- Bastonneurs
	elseif IdZone == 922 and AutoTrackerAchievementDB["Region"] and UnitLevel("player") > 99 then
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Bastonneurs (Alliance)"); end
		nbtracked = AchievListCat(CategorieListe(922))
	elseif IdZone == 925 and AutoTrackerAchievementDB["Region"] and UnitLevel("player") > 99 then
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Bastonneurs (Horde)"); end
		nbtracked = AchievListCat(CategorieListe(925))
	
	-- Raid
	elseif RaidListe(IdZone) ~= 0 and AutoTrackerAchievementDB["Raid"] and nbQuests == 0 then
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Raid"); end
		nbtracked = AchievListTable(RaidListe(IdZone))
	
	-- Donjon / Scenario / Region
	elseif ListeHF(IdZone) ~= 0 and difficulty ~= AtaDiff["5NM"][1] and (AutoTrackerAchievementDB["Donjon"] or AutoTrackerAchievementDB["Raid"] or AutoTrackerAchievementDB["Region"]) then
		if AutoTrackerAchievementDB["debug"] == true then print("Type = Donjon / Scenario / Region"); end
		LoadTrackQuests()
		nbtracked = AchievListTable(ListeHF(IdZone))
		
	-- Zone non gerer
	else
		if AutoTrackerAchievementDB["debug"] == true then print("Choix par défaut, chargement des quetes"); end
		LoadTrackQuests()
	end
	
	-- Defaut si aucune quetes en suivi
	if AutoTrackerAchievementDB["defaut"] == true and AutoTrackerAchievementDB["defautliste"] ~= 0 and difficulty == 0 and GetNumQuestWatches() == 0 then
		if nbtracked == nil or nbtracked == 0 then LoadTrackList(AutoTrackerAchievementDB["defautliste"]) end
	end
end

-- Fonction qui renvoie l'id du HF en fonction de la zone (pour les HF de quete)
function ListeHF(IdZone)
	local liste;
	faction = UnitFactionGroup("player")
	if faction == "Alliance" then
		liste = HFAlliance[IdZone];
	elseif faction == "Horde" then
		liste = HFHorde[IdZone];
	end
	
	ListeNeutre = HFNeutre[IdZone];
	
	if liste ~= nil and ListeNeutre ~= nil then
	for i = 1, #liste do
	table.insert(ListeNeutre, liste[i])
	end
	elseif liste ~= nil then
	ListeNeutre = liste	
	end
	
	if ListeNeutre ~= nil then
		return ListeNeutre
	else
		return 0
	end
end

-- Fonction qui renvoie la categorie HF en fonction de la zone (pour les HF pvp et Sombrelune)
function CategorieListe(IdZone)
	-- Battleground
	if IdZone == 461 then return 14802 end -- "Arathi Basin"
	if IdZone == 401 then return 14801 end -- "Alterac Valley"
	if IdZone == 482 then return 14803 end -- "Eye of the Storm"
	if IdZone == 443 then return 14804 end -- "Warsong Gulch"
	if IdZone == 512 then return 14881 end -- "Strand of the Ancients"
	if IdZone == 501 then return 14901 end -- "Wintergrasp"
	-- Cataclysm
	if IdZone == 540 then return 15003 end -- "Isle of Conquest"
	if IdZone == 736 then return 15073 end -- "Battle for Gilneas"
	if IdZone == 626 then return 15074 end -- "Twin Peaks"
	if IdZone == 708 then return 15075 end -- "Tol Barad"
	-- Mop
	if IdZone == 860 then return 15162 end -- "Mines Eclargent"
	if IdZone == 856 or IdZone == 881 then return 15163 end -- "Temple de Kotmogu"
	if IdZone == 935 then return 15218 end -- "Gorge de Vent-Caverneux"
	-- WOD
	if IdZone == 971 then return 15237 end -- "Fief"
	if IdZone == 978 then return 15241 end -- "Ashran"

	-- ARENA
	if IdZone == -1 then return 165 end
	-- Darkmoon Fair
	if IdZone == 823 then return 15101 end
	-- Bastonneurs
	if IdZone == 922 or IdZOne == 925 then return 15202 end

return 0
end

-- Fonction qui liste les HF selon la zone (raids)
function RaidListe(IdZone)
	-- Wrath of the Lich-King
	instanceName, instanceType, difficulty, difficultyName, maxPlayers, dynamicDifficulty, isDynamic, instanceMapID = GetInstanceInfo()
	if difficulty == AtaDiff["25NM"][1] or difficulty == AtaDiff["25HM"][1] then diff = 25 else diff = 10 end
	if IdZone == 718 and diff == 10 then Raid = "onyxia10"
	elseif IdZone == 718 and diff == 25 then Raid = "onyxia25"
	elseif IdZone == 532 and diff == 10 then Raid = "archavon10"
	elseif IdZone == 532 and diff == 25 then Raid = "archavon25"
	elseif IdZone == 527 and diff == 10 then Raid = "malygos10"
	elseif IdZone == 527 and diff == 25 then Raid = "malygos25"
	elseif IdZone == 531 and diff == 10 then Raid = "sartha10"
	elseif IdZone == 531 and diff == 25 then Raid = "sartha25"
	elseif IdZone == 535 and diff == 10 then Raid = "naxx10"
	elseif IdZone == 535 and diff == 25 then Raid = "naxx25"
	elseif IdZone == 529 and diff == 10 then Raid = "ulduar10"
	elseif IdZone == 529 and diff == 25 then Raid = "ulduar25"
	elseif IdZone == 543 and diff == 10 then Raid = "coliseum10"
	elseif IdZone == 543 and diff == 25 then Raid = "coliseum25"
	elseif IdZone == 604 and diff == 10 then Raid = "icc10"
	elseif IdZone == 604 and diff == 25 then Raid = "icc25"
	-- Cataclysm
	elseif IdZone == 754 then Raid = "bwd"
	elseif IdZone == 758 then Raid = "bot"
	elseif IdZone == 773 then Raid = "tfw"
	elseif IdZone == 800 then Raid = "firelands"
	elseif IdZone == 824 then Raid = "ds"
	-- Mists of Pandaria
	elseif IdZone == 896 then Raid = "ms"
	elseif IdZone == 897 then Raid = "hof"
	elseif IdZone == 886 then Raid = "tes"
	elseif IdZone == 930 then Raid = "tot"
	elseif IdZone == 953 then Raid = "os"
	-- attente
	elseif IdZone == 994 then Raid = "Highmaul"
	elseif IdZone == 988 then Raid = "BRF"
	elseif IdZone == 1026 then Raid = "HFC"
	else Raid = IdZone
	end
	
	if AutoTrackerAchievementDB["debug"] == true then
		if HFRaids[Raid] ~= nil then print("-- Région identifiée"); end
		if type(Raid) == "string" then print("-- Raid = texte"); end
		if difficulty ~= AtaDiff["LFR"][1] then print("-- Difficulté = OK "); end
	end
	
	-- Retour des donnees
	if IdZone == 'table' then
		return HFRaids
	elseif type(Raid) == "string" and HFRaids[Raid] ~= nil and difficulty ~= AtaDiff["LFR"][1] then
		return HFRaids[Raid]
	else
		return 0	
	end
end

-- ////////////////
--    Afficheurs
-- ////////////////

-- Print the incomplete achievements in specific category
function AchievListCat(IdCAT)
local currentlytracked = 0
local incomplete = false
	id = IdCAT
	for j = 1, GetCategoryNumAchievements(id) do
		aid, aname, points, completed, month, day, year, description, flags, icon, rewardText, isGuildAch = GetAchievementInfo(id,j)
		if not completed and currentlytracked < 10 then
			-- print (GetAchievementLink(aid));
			AddTrackedAchievement(aid);
			currentlytracked = currentlytracked +1
		end
	end
	return currentlytracked
end

-- Print the incomplete achievements in specific list and and them to the tracking list
function AchievListTable(Liste)
local currentlytracked = 0
local incomplete = false
local currentlycompleted = 0
	
	for i=1,#Liste do
		aid, aname, points, completed, month, day, year, description, flags, icon, rewardText, isGuildAch = GetAchievementInfo(Liste[i])
		if not completed and currentlytracked < 10 then
			-- print (GetAchievementLink(aid));
			AddTrackedAchievement(aid);
			currentlytracked = currentlytracked +1
		else
			currentlycompleted = currentlycompleted + 1
		end
	end
	if i == currentlycompleted then print(L["Zone clean"]); end
	return currentlytracked
end

-- Trouver le raid le plus rentable en HF
function CheckBestRaid()
	Tableau = RaidListe('table');
	TableauNB = {};
	
	for i in pairs(Tableau) do
		TableauNB[i] = 0
		for j,v in pairs(Tableau[i]) do
		aid, aname, points, completed, month, day, year, description, flags, icon, rewardText, isGuildAch = GetAchievementInfo(v)
		if not completed then TableauNB[i] = TableauNB[i] + 1 end
		end
	end
	
	for i,v in pairs(TableauNB) do
		if v ~= 0 then
			print(AtaColor.Green.."ATA : |r ".. GetMapNameByID(IdZoneRaid[i]) .." : "..v);
		end
	end
end

-- Vérifier les montures
function CheckMount()
	local iLocked;
	local a;
	local nbMount = 0;
	print(AtaColor.Green.."ATA : |r Check Mount");
	
	if GetLocale() == "frFR" then a = true end
		
	for j=1,#Mount do
	
		for i=1, C_MountJournal.GetNumMounts() do
		
		
		
			--local creatureName, creatureID, icon, active, summonable, source, isFavorite, isFactionSpecific, faction, unknown, owned = C_MountJournal.GetMountInfo(i)
			
			local creatureName, spellID, icon, active, isUsable, sourceType, isFavorite, isFactionSpecific, faction, hideOnChar, isCollected, mountID = C_MountJournal.GetDisplayedMountInfo(i)
						
			-- Vérification si la monture est dans le tableau et si on la possède
			if spellID == Mount[j][1] and isCollected == false then
			
				-- Check si zone vérouillé
				iLocked = false
				for a=1,GetNumSavedInstances() do 
					local n,_,_,d,l = GetSavedInstanceInfo(a)
					if (string.find(n, GetMapNameByID(Mount[j][3])) and l == true) then iLocked = true end
				end
				
				if iLocked == false then 
					print(AtaColor.Green.."ATA : |r "..GetMapNameByID(Mount[j][3]).." ["..Mount[j][4][2].."]"..(a and (" > ".. Mount[j][2]) or ""));
					nbMount = nbMount + 1;
				end
			
			end
		end		
	end
	
	if nbMount > 0 then
		print(AtaColor.Green.."ATA : |r "..nbMount.." left");
	else
		print(AtaColor.Green.."ATA : |r Finish");
	end
	
end

-- ////////////////
-- Langue
-- ////////////////
function AtaLocalisation(lang)
L = {};
	debut_ligne = "|cFFFF0000> "
	if lang == "frFR" then
		L["Pas de liste de ce nom"] = "Pas de liste de ce nom";
		L["Creation de la sauvegarde"] = "Creation de la sauvegarde";
		L["Mise à jour"] = "Mise à jour";
		L["Nom de sauvegarde invalide"] = "Nom de sauvegarde invalide";
		L["Liste sauvegardee"] = "Liste sauvegardee";
		L["Zone sans Haut-faits"] = "Zone sans Haut-faits";
		L["Commande non reconnue"] = "Commande non reconnue";
		L["Zone clean"] = "Felicitation, il n'y a plus de HF à faire dans cette zone.";
		-- Config
		L["ata config"] = debut_ligne .. "|cFF00FF00/ata config |r affiche l'interface des otpions";
		L["ata check"] = debut_ligne .. "|cFF00FF00/ata check |r affiche le nombre de HF à faire restant dans chaque raid";
		L["ata clean"] = debut_ligne .. "|cFF00FF00/ata clean |r vide le suivi des HF";
		L["ata save"] = debut_ligne .. "|cFF00FF00/ata save <nom> |r enregistre la liste des HF en suivi sous le nom choisi";
		L["ata load"] = debut_ligne .. "|cFF00FF00/ata load <nom> |r affiche les HF enregistres dans la liste <nom>";
		L["ata defaut"] = debut_ligne .. "|cFF00FF00/ata defaut <nom> |r affiche les HF enregistres dans la liste <nom> s'il n'y a rien d'autre à afficher";
		L["ata mount"] = debut_ligne .. "|cFF00FF00/ata mount <nom> |r affiche les raids sans ID pour le farm des montures";
		-- Raids
		L["ata raid lk"] = debut_ligne .. "|cFF00FF00/ata {onyxia/archavon/malygos/sartha/naxx/ulduar/coliseum/icc}{10/25}";
		L["ata raid cata"] = debut_ligne .. "|cFF00FF00/ata {bwd,bot,tfw,firelands,ds}";
		L["ata raid pandaria"] = debut_ligne .. "|cFF00FF00/ata {mv,hof,tes,tot,soo}";
		-- UI
		Text1:SetText("Arene")
		Text2:SetText("Raids")
		Text3:SetText("Regions")
		Text4:SetText("Donjons et Scenarios")
		Text5:SetText("sinon")
	else -- lang == "enEN"
		L["Pas de liste de ce nom"] = "No tracklist with this name";
		L["Creation de la sauvegarde"] = "Generating variables";
		L["Mise a jour"] = "Updating options";
		L["Nom de sauvegarde invalide"] = "Save name error";
		L["Liste sauvegardee"] = "Tracklist recording";
		L["Zone sans Haut-faits"] = "Area without achievement";
		L["Commande non reconnue"] = "Unknwown command";
		L["Zone clean"] = "Congratulation, there is more to achievements in this area.";
		-- Config
		L["ata config"] = debut_ligne .. "|cFF00FF00/ata config |r show settings";
		L["ata check"] = debut_ligne .. "|cFF00FF00/ata check |r show quantity of achievement not completed in each raid";
		L["ata clean"] = debut_ligne .. "|cFF00FF00/ata clean |r clean track list";
		L["ata save"] = debut_ligne .. "|cFF00FF00/ata save <name> |r save achievement track list as <name>";
		L["ata load"] = debut_ligne .. "|cFF00FF00/ata load <nom> |r show the track list <name>";
		L["ata defaut"] = debut_ligne .. "|cFF00FF00/ata defaut <nom> |r show the track list <name> only if there is no achievement in this area";
		L["ata mount"] = debut_ligne .. "|cFF00FF00/ata mount <nom> |r show unlocked raid or dungeon to farm mounts";
		-- Raids
		L["ata raid lk"] = debut_ligne .. "|cFF00FF00/ata {onyxia/archavon/malygos/sartha/naxx/ulduar/coliseum/icc}{10/25}";
		L["ata raid cata"] = debut_ligne .. "|cFF00FF00/ata {bwd,bot,tfw,firelands,ds}";
		L["ata raid pandaria"] = debut_ligne .. "|cFF00FF00/ata {mv,hof,tes,tot,soo}";
		-- UI
		Text1:SetText("Arena")
		Text2:SetText("Raids")
		Text3:SetText("Zones")
		Text4:SetText("Dungeons and Scenarios")
		Text5:SetText("else")
	end

end

function ModificationFrame()
	defautval:SetText(AutoTrackerAchievementDB["defautliste"])
	version:SetText("Version " .. AutoTrackerAchievementDB["version"])
end




