-- Open/Close function
local function ToggleBagsOnCharacterFrame()
    if CharacterFrame:IsShown() then
        OpenAllBags()
    else
        CloseAllBags()
    end
end

-- Hook functions to the character frame show/hide events
CharacterFrame:HookScript("OnShow", function()
    ToggleBagsOnCharacterFrame()
end)

CharacterFrame:HookScript("OnHide", function()
    ToggleBagsOnCharacterFrame()
end)