-- $Id: Core.lua 17 2017-06-02 16:42:23Z arith $
-----------------------------------------------------------------------
-- Upvalued Lua API.
-----------------------------------------------------------------------
-- Functions
local _G = getfenv(0)
local unpack, pairs = _G.unpack, _G.pairs
-- Libraries
local GameTooltip = _G.GameTooltip
-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local FOLDER_NAME, private = ...

local LibStub = _G.LibStub
local L = LibStub("AceLocale-3.0"):GetLocale("AtlasLoot Button")

local addon = LibStub("AceAddon-3.0"):NewAddon("AtlasLoot Button", "AceEvent-3.0")
addon.constants = private.constants
addon.constants.addon_name = private.addon_name
addon.Name = FOLDER_NAME
_G.AtlasLoot_Button = addon

local isInLockdown = false
local profile

local function frame_OnMouseDown(self, buttonName)    
	if (addon.button:IsVisible()) then
		if (buttonName == "LeftButton") then
			if (IsShiftKeyDown()) then
				addon:OpenOptions()
			else
				-- Prevent activation when in combat
				if (profile.disableDraggingInCombat and isInLockdown) then
					return
				end
				GameTooltip:Hide()
				addon.button:StartMoving()
			end
		elseif (buttonName == "RightButton") then
			if (AtlasLoot.GUI.frame:IsVisible()) then
				AtlasLoot.GUI.frame:Hide()
			else
				AtlasLoot.GUI.frame:Show()
			end
			GameTooltip_Hide()
		end
	end
end

local function frame_OnMouseUp(self, buttonName)
	if(addon.button:IsVisible()) then
		addon.button:StopMovingOrSizing()
		local a, b, c, d, e = self:GetPoint()
		profile.point = { a, b, c, d, e }
	end
end

local function frame_OnEnter(self)
	if (profile.show_tooltip) then
		GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT")
		GameTooltip:SetText(L["BUTTON_TEXT"], nil, nil, nil, nil, false)
	end
end

local function frame_OnLeave(self)
	GameTooltip:Hide()
end

local function createButton()
	local f
	if not f then f = CreateFrame("Button", "AtlasLootButton", UIParent) end
	
	f:SetWidth(32)
	f:SetHeight(32)
	local point, relativeTo, relativePoint, ofsx, ofsy = unpack(profile.point)
	f:SetPoint(point or "TOPRIGHT", UIParent, relativePoint or "TOPRIGHT", ofsx or -200, ofsy or -200)
	f:SetClampedToScreen(true)
	f:SetMovable(true)
	f:EnableMouse(true)
	f:RegisterForDrag("LeftButton")
	f:RegisterForClicks("LeftButtonDown", "RightButtonDown")
	
	f.Icon = f:CreateTexture(nil, "ARTWORK")
	f.Icon:SetWidth(18)
	f.Icon:SetHeight(18)
	f.Icon:SetPoint("TOPLEFT", f, "TOPLEFT", 7, -6)
	f.Icon:SetTexture("Interface\\Icons\\INV_Box_01")
	
	f.Border = f:CreateTexture(nil, "OVERLAY")
	f.Border:SetWidth(52)
	f.Border:SetHeight(52)
	f.Border:SetPoint("TOPLEFT", f, "TOPLEFT", 0, 0)
	f.Border:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	
	f:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight", "ADD")
	
	f:SetScript("OnMouseDown", 	frame_OnMouseDown)
	f:SetScript("OnMouseUp", 	frame_OnMouseUp)
	f:SetScript("OnEnter", 		frame_OnEnter)
	f:SetScript("OnLeave", 		frame_OnLeave)
	f:Show()
	return f
end

function addon:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("AtlasLootButtonDB", addon.constants.defaults, true)
	
	profile = self.db.profile

	self.db.RegisterCallback(self, "OnProfileChanged", "Refresh")
	self.db.RegisterCallback(self, "OnProfileCopied", "Refresh")
	self.db.RegisterCallback(self, "OnProfileReset", "Refresh")
	
	addon.button = createButton()

	self:SetupOptions()
end

function addon:OnEnable()
	-- Register events
	for key, value in pairs( addon.constants.events ) do
		self:RegisterEvent( value )
	end

	if(profile.show_button) then
		addon.button:Show()
		addon.button:SetScale(profile.scale or 1)
		local point, relativeTo, relativePoint, ofsx, ofsy = unpack(profile.point)
		addon.button:ClearAllPoints()
		addon.button:SetParent(UIParent)
		addon.button:SetPoint(point or "TOPRIGHT", nil, relativePoint or "TOPRIGHT", ofsx or -200, ofsy or -200)
	else
		addon.button:Hide()
	end

end

function addon:Refresh()
	profile = self.db.profile
	if(profile.show_button) then
		addon.button:Show()
	else
		addon.button:Hide()
	end
	
	addon.button:SetScale(profile.scale or 1)
end

function addon:PLAYER_REGEN_DISABLED()
	-- for combact lockdown
	isInLockdown = true
end

function addon:PLAYER_REGEN_ENABLED()
	isInLockdown = false
end

function addon:PLAYER_STARTED_MOVING()
	if (profile.moving_fadeout) then
		addon.button:SetAlpha(profile.moving_alpha or 1)
	end
end

function addon:PLAYER_STOPPED_MOVING()
	if (profile.moving_fadeout) then
		addon.button:SetAlpha(1)
	end
end
