--[[
$Id: Config.lua 19 2017-06-04 06:58:15Z arith $
]]
-----------------------------------------------------------------------
-- Upvalued Lua API.
-----------------------------------------------------------------------
-- Functions
local _G = getfenv(0)
local pairs = _G.pairs
-- Libraries
-- ----------------------------------------------------------------------------
-- AddOn namespace.
-- ----------------------------------------------------------------------------
local FOLDER_NAME, private = ...
local LibStub = _G.LibStub;
local addon = LibStub("AceAddon-3.0"):GetAddon(private.addon_name)
local L = LibStub("AceLocale-3.0"):GetLocale(private.addon_name);

local AceConfigReg = LibStub("AceConfigRegistry-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")

local optGetter, optSetter
do
	function optGetter(info)
		local key = info[#info]
		return addon.db.profile[key]
	end

	function optSetter(info, value)
		local key = info[#info]
		addon.db.profile[key] = value
		addon:Refresh()
	end
end

local options, moduleOptions = nil, {}

local function getOptions()
	if not options then
		options = {
			type = "group",
			name = L["ADDON_NAME"],
			args = {
				general = {
					order = 1,
					type = "group",
					name = L["OPTIONS_GENERAL"],
					get = optGetter,
					set = optSetter,
					args = {
						intro = {
							order = 1,
							type = "description",
							name = L["ADDON_DESC"],
						},
						show_tooltip = {
							order = 2,
							type = "toggle",
							name = L["Show button tooltip"],
						},
						disableDraggingInCombat = {
							order = 3,
							type = "toggle",
							name = L["Disable dragging while in combat."],
						},
						scale = {
							order = 4,
							type = "range",
							name = L["Button Scale"],
							min = 0.1, max = 2, bigStep = 0.02,
							isPercent = true,
						},
						moving_fadeout = {
							order = 5,
							type = "toggle",
							name = L["Fade-out button when character is moving."],
						},
						moving_alpha = {
							order = 5.1,
							type = "range",
							name = L["Alpha"],
							min = 0, max = 1, bigStep = 0.1,
--							width = "full",
					},
					},
				},
			},
		}
		for k,v in pairs(moduleOptions) do
			options.args[k] = (type(v) == "function") and v() or v
		end
	end
	
	return options
end

function addon:OpenOptions() 
	-- open the profiles tab before, so the menu expands
	InterfaceOptionsFrame_OpenToCategory(addon.optionsFrames.Profiles)
	InterfaceOptionsFrame_OpenToCategory(addon.optionsFrames.General)
	InterfaceOptionsFrame:Raise()
end

local function giveProfiles()
	return LibStub("AceDBOptions-3.0"):GetOptionsTable(addon.db)
end

function addon:SetupOptions()
	self.optionsFrames = {}

	-- setup options table
	AceConfigReg:RegisterOptionsTable(private.addon_name, getOptions)
	self.optionsFrames.General = AceConfigDialog:AddToBlizOptions(private.addon_name, L["ADDON_NAME"], nil, "general")

	self:RegisterModuleOptions("Profiles", giveProfiles, L["Profile Options"])
end

-- Description: Function which extends our options table in a modular way
-- Expected result: add a new modular options table to the modularOptions upvalue as well as the Blizzard config
-- Input:
--		name			: index of the options table in our main options table
--		optionsTable	: the sub-table to insert
--		displayName	: the name to display in the config interface for this set of options
-- Output: None.
function addon:RegisterModuleOptions(name, optionTbl, displayName)
	moduleOptions[name] = optionTbl
	self.optionsFrames[name] = AceConfigDialog:AddToBlizOptions(private.addon_name, displayName, private.addon_name, name)
end
