-- $Id: Atlas_Transportation.lua 94 2018-01-19 15:31:54Z arith $
--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005 ~ 2010 - Dan Gilbert <dan.b.gilbert@gmail.com>
	Copyright 2010 - Lothaer <lothayer@gmail.com>, Atlas Team
	Copyright 2011 ~ 2018 - Arith Hsu, Atlas Team <atlas.addon at gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]
local _G = getfenv(0)
local LibStub = _G.LibStub
local Atlas = LibStub("AceAddon-3.0"):GetAddon("Atlas")

local BZ = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0")
local BF = Atlas_GetLocaleLibBabble("LibBabble-Faction-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("Atlas_Transportation")
local ALC = LibStub("AceLocale-3.0"):GetLocale("Atlas")

local BLUE = "|cff6666ff"
local GREN = "|cff66cc33"
local _RED = "|cffcc3333"
local ORNG = "|cffcc9933"
local PURP = "|cff9900ff"
local WHIT = "|cffffffff"
local LBLU = "|cff33cccc"
local CYAN = "|cff00ffff"
local GREY = "|cff999999"
local ALAN = "|cff7babe0" -- Alliance's taxi node
local HRDE = "|cffda6955" -- Horde's taxi node
local NUTL = "|cfffee570" -- Nutral taxi node
local INDENT = "      "

local myCategory = L["Transportation Maps"]

local CL = {
	["HUNTER"] 	= "|cffabd473",
	["WARLOCK"] 	= "|cff8788ee",
	["PRIEST"] 	= "|cffffffff",
	["PALADIN"] 	= "|cfff58cba",
	["MAGE"] 	= "|cff3fc7eb",
	["ROGUE"] 	= "|cfffff569",
	["DRUID"] 	= "|cffff7d0a",
	["SHAMAN"] 	= "|cff0070de",
	["WARRIOR"] 	= "|cffc79c6e",
	["DEATHKNIGHT"]	= "|cffc41f3b",
	["MONK"] 	= "|cff00ff96",
	["DEMONHUNTER"]	= "|cffa330c9",
}

local myData = {
	TransAllianceCosmos = {
		ZoneName = { WORLD..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		-- WorldMapID = "",
		{ BLUE..BZ["Eastern Kingdoms"] },
		{ ORNG.." 1) "..BZ["Stormwind City"].."\n<--> "..BZ["Ironforge"].."\n<--> "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"].."\n<--> "..BZ["Highbank"]..ALC["Comma"]..BZ["Twilight Highlands"].."\n<--> "..BZ["Shattered Beachhead"]..ALC["Comma"]..BZ["Blasted Lands"].."\n<--> "..BZ["Paw'Don Village"]..ALC["Comma"]..BZ["The Jade Forest"].."\n --> "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"].."\n<--> "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"].."\n<--> "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"].."\n<--> "..BZ["Valiance Keep"]..ALC["Comma"]..BZ["Borean Tundra"].."\n<--> "..BZ["Dalaran"].."\n<--> "..BZ["Stormshield"]..ALC["Comma"]..BZ["Ashran"], 10001 },
		{ ORNG.." 2) "..BZ["Ironforge"], 10002 },
		{ WHIT.." 3) "..BZ["Menethil Harbor"]..ALC["Comma"]..BZ["Wetlands"], 10003 },
		{ WHIT.." 4) "..BZ["Highbank"]..ALC["Comma"]..BZ["Twilight Highlands"], 10004 },
		{ WHIT.." 5) "..BZ["Shattered Beachhead"]..ALC["Comma"]..BZ["Blasted Lands"], 10005 },
		{ WHIT.." 6) "..BZ["Karazhan"]..ALC["Comma"]..BZ["Deadwind Pass"], 10006 },
		{ WHIT.." 7) "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"], 10007 },
		{ WHIT.." 8) "..BZ["Dalaran Crater"]..ALC["Comma"]..BZ["Hillsbrad Foothills"], 10008 },
		{ WHIT.." 9) "..BZ["Shattered Sun Staging Area"]..ALC["Comma"]..BZ["Isle of Quel'Danas"], 10009 },
		{ "" },
		{ BLUE..BZ["Kalimdor"] },
		{ ORNG.."10) "..BZ["Darnassus"], 10010 },
		{ WHIT.."11) "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"], 10011 },
		{ ORNG.."12) "..BZ["The Exodar"], 10012 },
		{ WHIT.."13) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"], 10013 },
		{ WHIT.."14) "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"], 10014 },
		{ WHIT.."15) "..BZ["Theramore"]..ALC["Comma"]..BZ["Dustwallow Marsh"], 10015 },
		{ WHIT.."16) "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"], 10016 },
		{ WHIT.."17) "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"], 10017 },
		{ "" },
		{ BLUE..BZ["Outland"] },
		{ WHIT.."18) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"], 10018 },
		{ ORNG.."19) "..BZ["Shattrath City"], 10019 },
		{ "" },
		{ BLUE..BZ["Northrend"] },
		{ WHIT.."20) "..BZ["Valiance Keep"]..ALC["Comma"]..BZ["Borean Tundra"], 10020 },
		{ WHIT.."21) "..BZ["Valgarde"]..ALC["Comma"]..BZ["Howling Fjord"], 10021 },
		{ ORNG.."22) "..BZ["Dalaran (Northrend)"], 10022 },
		{ WHIT.."23) "..BZ["Wyrmrest Temple"]..ALC["Comma"]..BZ["Dragonblight"], 10023 },
		{ "" },
		{ BLUE..BZ["Pandaria"] },
		{ WHIT.."24) "..BZ["Paw'Don Village"]..ALC["Comma"]..BZ["The Jade Forest"], 10024 },
		{ ORNG.."25) "..BZ["Shrine of Seven Stars"], 10025 },
		{ "" },
		{ BLUE..BZ["Draenor"] },
		{ WHIT.."26) "..BZ["Stormshield"]..ALC["Comma"]..BZ["Ashran"], 10026 },
		{ WHIT.."27) "..BZ["Lunarfall"]..ALC["Comma"]..BZ["Shadowmoon Valley"], 10027 },
		{ "" },
		{ BLUE..BZ["Broken Isles"] },
		{ ORNG.."28) "..BZ["Dalaran"], 10028 },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ ORNG.."-- : "..L["Two ways portal"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },
	},
	TransHordeCosmos = {
		ZoneName = { WORLD..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		-- WorldMapID = "",
		{ BLUE..BZ["Kalimdor"] },
		{ ORNG.." 1) "..BZ["Orgrimmar"], 10001 },
		{ ORNG.." 2) "..BZ["Thunder Bluff"], 10002 },
		{ WHIT.." 3) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"], 10003 },
		{ WHIT.." 4) "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"], 10004 },
		{ WHIT.." 5) "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"], 10005 },
		{ WHIT.." 6) "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"], 10006 },
		{ "" },
		{ BLUE..BZ["Eastern Kingdoms"] },
		{ WHIT.." 7) "..BZ["Shattered Sun Staging Area"]..ALC["Comma"]..BZ["Isle of Quel'Danas"], 10007 },
		{ ORNG.." 8) "..BZ["Silvermoon City"], 10008 },
		{ WHIT.." 9) "..BZ["Brill"]..ALC["Comma"]..BZ["Tirisfal Glades"], 10009 },
		{ ORNG.."10) "..BZ["Undercity"], 10010 },
		{ WHIT.."11) "..BZ["Dalaran Crater"]..ALC["Comma"]..BZ["Hillsbrad Foothills"], 10011 },
		{ WHIT.."12) "..BZ["Dragonmaw Port"]..ALC["Comma"]..BZ["Twilight Highlands"], 10012 },
		{ WHIT.."13) "..BZ["Shattered Landing"]..ALC["Comma"]..BZ["Blasted Lands"], 10013 },
		{ WHIT.."14) "..BZ["Karazhan"]..ALC["Comma"]..BZ["Deadwind Pass"], 10014 },
		{ WHIT.."15) "..BZ["Grom'gol Base Camp"]..ALC["Comma"]..BZ["Northern Stranglethorn"], 10015 },
		{ WHIT.."16) "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"], 10016 },
		{ "" },
		{ BLUE..BZ["Outland"] },
		{ WHIT.."17) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"], 10017 },
		{ ORNG.."18) "..BZ["Shattrath City"], 10018 },
		{ "" },
		{ BLUE..BZ["Northrend"] },
		{ WHIT.."19) "..BZ["Warsong Hold"]..ALC["Comma"]..BZ["Borean Tundra"], 10019 },
		{ WHIT.."20) "..BZ["Vengeance Landing"]..ALC["Comma"]..BZ["Howling Fjord"], 10020 },
		{ ORNG.."21) "..BZ["Dalaran (Northrend)"], 10021 },
		{ WHIT.."22) "..BZ["Wyrmrest Temple"]..ALC["Comma"]..BZ["Dragonblight"], 10022 },
		{ "" },
		{ BLUE..BZ["Pandaria"] },
		{ WHIT.."23) "..BZ["Honeydew Village"]..ALC["Comma"]..BZ["The Jade Forest"], 10023 },
		{ ORNG.."24) "..BZ["Shrine of Two Moons"], 10024 },
		{ "" },
		{ BLUE..BZ["Draenor"] },
		{ WHIT.."25) "..BZ["Warspear"]..ALC["Comma"]..BZ["Ashran"], 10025 },
		{ WHIT.."26) "..BZ["Frostwall Garrison"]..ALC["Comma"]..BZ["Frostfire Ridge"], 10026 },
		{ "" },
		{ BLUE..BZ["Broken Isles"] },
		{ ORNG.."27) "..BZ["Dalaran"], 10027 },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ ORNG.."-- : "..L["Two ways portal"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },
	},
	TransAllianceEast = {
		ZoneName = { BZ["Eastern Kingdoms"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "14",
		Faction = "Alliance",
		{ _RED..BZ["Docks"] },
		{ ORNG.." A') "..BZ["Valgarde"]..ALC["Comma"]..BZ["Howling Fjord"]..ALC["Comma"]..BZ["Northrend"] },
		{ ORNG.." B') "..BZ["Valiance Keep"]..ALC["Comma"]..BZ["Borean Tundra"]..ALC["Comma"]..BZ["Northrend"] },
		{ ORNG.." C') "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ ORNG.." D') "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ ORNG.." E') "..BZ["Theramore"]..ALC["Comma"]..BZ["Dustwallow Marsh"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.."21) "..BZ["Menethil Harbor"]..ALC["Comma"]..BZ["Wetlands"] },
		{ WHIT.."43) "..BZ["Stormwind Harbor"]..ALC["Comma"]..BZ["Elwynn Forest"] },
		{ WHIT.."60) "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..L["Transporter"] },
		{ PURP.." A) "..BZ["Baradin Base Camp"]..ALC["Comma"]..BZ["Tol Barad Peninsula"] },
		{ PURP.." B) "..BZ["Baradin Hold"]..ALC["Comma"]..BZ["Tol Barad"] },
		{ GREY..INDENT..ALC["L-Parenthesis"]..L["Only available after winning the PvP battle"]..ALC["R-Parenthesis"] },
		{ PURP.." C) "..BZ["Highbank"]..ALC["Comma"]..BZ["Twilight Highlands"] },
		{ PURP.." D) "..BZ["Fuselight-by-the-Sea"]..ALC["Comma"]..BZ["Badlands"] },
		{ GREY..INDENT..ALC["L-Parenthesis"]..L["Transporters by the sea and on the cliff"]..ALC["R-Parenthesis"] },
		{ PURP.." A') "..BZ["Ashran"]..ALC["Comma"]..BZ["Draenor"] },
		{ PURP.." B') "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." C') "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." D') "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"] },
		{ PURP.." E') "..BZ["Temple of Earth"]..ALC["Comma"]..BZ["Deepholm"] },
		{ PURP.." F') "..BZ["Darkmoon Island"] },
		{ PURP.." G') "..BZ["Paw'Don Village"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Comma"]..BZ["Pandaria"] },
		{ WHIT.."29) "..BZ["The Mystic Ward"]..ALC["Comma"]..BZ["Ironforge"]..ALC["Comma"]..BZ["Dun Morogh"] },
		{ WHIT.."43) "..BZ["Mage Quarter"]..ALC["Comma"]..BZ["Stormwind"]..ALC["Comma"]..BZ["Elwynn Forest"] },
		{ WHIT.."62) "..BZ["Shattered Beachhead"]..ALC["Comma"]..BZ["Blasted Lands"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Hyphen"]..L["Druid Only"] },
		{ GREN.." A) "..BZ["Seradane"]..ALC["Comma"]..BZ["The Hinterlands"] },
		{ GREN.." B) "..BZ["Twilight Grove"]..ALC["Comma"]..BZ["Duskwood"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Isle of Quel'Danas"] },
		{ WHIT.." 1) "..BZ["Shattered Sun Staging Area"] },
		{ "" },
		{ BLUE..BZ["Ghostlands"] },
		{ WHIT.." 2) "..BZ["Zul'Aman"] },
		{ "" },
		{ BLUE..BZ["Eastern Plaguelands"] },
		{ GREN.." 3) "..BZ["Acherus: The Ebon Hold"]..ALC["L-Parenthesis"]..L["Death Knight Only"]..ALC["R-Parenthesis"] },
		{ WHIT.." 4) "..BZ["Light's Hope Chapel"] },
		{ WHIT.." 5) "..BZ["Eastwall Tower"] },
		{ WHIT.." 6) "..BZ["Northpass Tower"] },
		{ WHIT.." 7) "..BZ["Plaguewood Tower"] },
		{ WHIT.." 8) "..BZ["Light's Shield Tower"] },
		{ WHIT.." 9) "..BZ["Crown Guard Tower"] },
		{ WHIT.."10) "..BZ["Thondroril River"] },
		{ "" },
		{ BLUE..BZ["Western Plaguelands"] },
		{ WHIT.."11) "..BZ["Hearthglen"] },
		{ WHIT.."12) "..BZ["The Menders' Stead"] },
		{ WHIT.."13) "..BZ["Andorhal"] },
		{ GREY..INDENT..ALC["L-Parenthesis"]..L["Won't be available once the Battle for Andorhal chain is finished."]..ALC["R-Parenthesis"] },
		{ WHIT.."14) "..BZ["Chillwind Camp"] },
		{ "" },
		{ BLUE..BZ["The Hinterlands"] },
		{ WHIT.."15) "..BZ["Aerie Peak"] },
		{ WHIT.."16) "..BZ["Stormfeather Outpost"] },
		{ "" },
		{ BLUE..BZ["Arathi Highlands"] },
		{ WHIT.."17) "..BZ["Refuge Pointe"] },
		{ "" },
		{ BLUE..BZ["Wetlands"] },
		{ WHIT.."18) "..BZ["Dun Modr"] },
		{ WHIT.."19) "..BZ["Whelgar's Retreat"] },
		{ WHIT.."20) "..BZ["Greenwarden's Grove"] },
		{ WHIT.."21) "..BZ["Menethil Harbor"] },
		{ WHIT.."22) "..BZ["Slabchisel's Survey"] },
		{ "" },
		{ BLUE..BZ["Twilight Highlands"] },
		{ WHIT.."23) "..BZ["Vermillion Redoubt"] },
		{ WHIT.."24) "..BZ["Thundermar"] },
		{ WHIT.."25) "..BZ["Kirthaven"] },
		{ WHIT.."26) "..BZ["Victor's Point"] },
		{ WHIT.."27) "..BZ["Firebeard's Patrol"] },
		{ WHIT.."28) "..BZ["Highbank"] },
		{ "" },
		{ BLUE..BZ["Dun Morogh"] },
		{ WHIT.."29) "..BZ["Ironforge"] },
		{ WHIT.."30) "..BZ["Kharanos"] },
		{ WHIT.."31) "..BZ["Gol'Bolar Quarry"] },
		{ "" },
		{ BLUE..BZ["Loch Modan"] },
		{ WHIT.."32) "..BZ["Thelsamar"] },
		{ WHIT.."33) "..BZ["Farstrider Lodge"] },
		{ "" },
		{ BLUE..BZ["Searing Gorge"] },
		{ WHIT.."34) "..BZ["Thorium Point"] },
		{ WHIT.."35) "..BZ["Iron Summit"] },
		{ "" },
		{ BLUE..BZ["Badlands"] },
		{ WHIT.."36) "..BZ["Dragon's Mouth"] },
		{ WHIT.."37) "..BZ["Dustwind Dig"] },
		{ WHIT.."38) "..BZ["Fuselight"] },
		{ "" },
		{ BLUE..BZ["Burning Steppes"] },
		{ WHIT.."39) "..BZ["Chiselgrip"] },
		{ WHIT.."40) "..BZ["Morgan's Vigil"] },
		{ WHIT.."41) "..BZ["Flamestar Post"] },
		{ WHIT.."42) "..BZ["Terror Wing Path"]..ALC["Comma"]..BZ["Burning Steppes"] },
		{ WHIT..INDENT..ALC["L-Parenthesis"]..L["The Bogpaddle Bullet"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Elwynn Forest"] },
		{ WHIT.."43) "..BZ["Stormwind"] },
		{ WHIT.."44) "..BZ["Goldshire"] },
		{ WHIT.."45) "..BZ["Eastvale Logging Camp"] },
		{ "" },
		{ BLUE..BZ["Redridge Mountains"] },
		{ WHIT.."46) "..BZ["Lakeshire"] },
		{ WHIT.."47) "..BZ["Camp Everstill"] },
		{ WHIT.."48) "..BZ["Shalewind Canyon"] },
		{ "" },
		{ BLUE..BZ["Westfall"] },
		{ WHIT.."49) "..BZ["Furlbrow's Pumpkin Farm"] },
		{ WHIT.."50) "..BZ["Moonbrook"] },
		{ WHIT.."51) "..BZ["Sentinel Hill"] },
		{ "" },
		{ BLUE..BZ["Duskwood"] },
		{ WHIT.."52) "..BZ["Raven Hill"] },
		{ WHIT.."53) "..BZ["Darkshire"] },
		{ "" },
		{ BLUE..BZ["Swamp of Sorrows"] },
		{ WHIT.."54) "..BZ["The Harborage"] },
		{ WHIT.."55) "..BZ["Marshtide Watch"] },
		{ WHIT.."56) "..BZ["Bogpaddle"] },
		{ "" },
		{ BLUE..BZ["Northern Stranglethorn"] },
		{ WHIT.."57) "..BZ["Rebel Camp"] },
		{ WHIT.."58) "..BZ["Fort Livingston"] },
		{ "" },
		{ BLUE..BZ["The Cape of Stranglethorn"] },
		{ WHIT.."59) "..BZ["Explorers' League Digsite"] },
		{ WHIT.."60) "..BZ["Booty Bay"] },
		{ "" },
		{ BLUE..BZ["Blasted Lands"] },
		{ WHIT.."61) "..BZ["Nethergarde Keep"] },
		{ WHIT.."62) "..BZ["Shattered Beachhead"] },
		{ WHIT.."63) "..BZ["Surwich"] },
		{ "" },
		{ BLUE..BZ["Vashj'ir"] },
		{ CYAN.."64) "..BZ["Smuggler's Scar"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."65) "..BZ["Sandy Beach"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["Slash"]..L["Gryphon"]..ALC["R-Parenthesis"] },
		{ CYAN.."66) "..BZ["Silver Tide Hollow"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."67) "..BZ["Tranquil Wash"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."68) "..BZ["Voldrin's Hold"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["Slash"]..L["Gryphon"]..ALC["R-Parenthesis"] },
		{ CYAN.."69) "..BZ["Darkbreak Cove"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },
		{ GREN.."-- : "..BZ["Deeprun Tram"]..ALC["Slash"]..L["Special transportation"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Cataclysm Explorer", "ac=4868" },
		{ "Eastern Kingdoms Explorer", "ac=42" },
		{ "Explore Arathi Highlands", "ac=761" },
		{ "Explore Badlands", "ac=765" },
		{ "Explore Blasted Lands", "ac=766" },
		{ "Explore Burning Steppes", "ac=775" },
		{ "Explore Deadwind Pass", "ac=777" },
		{ "Explore Dun Morogh", "ac=627" },
		{ "Explore Duskwood", "ac=778" },
		{ "Explore Eastern Plaguelands", "ac=771" },
		{ "Explore Elwynn Forest", "ac=776" },
		{ "Explore Eversong Woods", "ac=859" },
		{ "Explore Ghostlands", "ac=858" },
		{ "Explore Hillsbrad Foothills", "ac=772" },
		{ "Explore Isle of Quel'Danas", "ac=868" },
		{ "Explore Loch Modan", "ac=779" },
		{ "Explore Northern Stranglethorn", "ac=781" },
		{ "Explore Redridge Mountains", "ac=780" },
		{ "Explore Searing Gorge", "ac=774" },
		{ "Explore Silverpine Forest", "ac=769" },
		{ "Explore Swamp of Sorrows", "ac=782" },
		{ "Explore the Cape of Stranglethorn", "ac=4995" },
		{ "Explore The Hinterlands", "ac=773" },
		{ "Explore Tirisfal Glades", "ac=768" },
		{ "Explore Twilight Highlands", "ac=4866" },
		{ "Explore Vashj'ir", "ac=4825" },
		{ "Explore Western Plaguelands", "ac=770" },
		{ "Explore Westfall", "ac=802" },
		{ "Explore Wetlands", "ac=841" },
		{ "From Hell's Heart I Stab at Thee", "ac=4975" },
		{ "Stood in the Fire", "ac=5518" },
		{ "Surveying the Damage", "ac=4827" },
		{ LBLU..QUESTS_LABEL },
		{ "Arathi Highlands Quests", "ac=4896" },
		{ "Badlands Quests", "ac=4900" },
		{ "Blasted Lands Quests", "ac=4909" },
		{ "Burning Steppes Quests", "ac=4901" },
		{ "Cape of Stranglethorn Quests", "ac=4905" },
		{ "Eastern Plaguelands Quests", "ac=4892" },
		{ "Full Caravan", "ac=5442" },
		{ "Hinterlands Quests", "ac=4897" },
		{ "Loch Modan and Wetlands Quests", "ac=4899" },
		{ "Loremaster of Eastern Kingdoms", "ac=1676" },
		{ "Northern Stranglethorn Quests", "ac=4906" },
		{ "Ready, Set, Goat!", "ac=5444" },
		{ "Redridge Mountains Quests", "ac=4902" },
		{ "Searing Gorge Quests", "ac=4910" },
		{ "Swamp of Sorrows Quests", "ac=4904" },
		{ "The Green Hills of Stranglethorn", "ac=940" },
		{ "Western Plaguelands Quests", "ac=4893" },
		{ "Westfall and Duskwood Quests", "ac=4903" },
		{ "20,000 Leagues Under the Sea", "ac=5318" },
		{ "Breaking Out of Tol Barad", "ac=4874" },
		{ "Consumed by Nightmare", "ac=5451" },
		{ "Wildhammer Tour of Duty", "ac=5481" },
		{ "Fading into Twilight", "ac=4873" },
		{ "King of the Mountain", "ac=5320" },
		{ "Loremaster of Cataclysm", "ac=4875" },
		{ "Round Three. Fight!", "ac=4960" },
		{ "Sinking into Vashj'ir", "ac=4869" },
		{ "Visions of Vashj'ir Past", "ac=5452" },
	},
	TransHordeEast = {
		ZoneName = { BZ["Eastern Kingdoms"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "14",
		Faction = "Horde",
		{ _RED..L["Zeppelin Towers"]..ALC["Slash"]..BZ["Docks"] },
		{ ORNG.." A') "..BZ["Vengeance Landing"]..ALC["Comma"]..BZ["Howling Fjord"]..ALC["Comma"]..BZ["Northrend"] },
		{ ORNG.." B') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ ORNG.." C') "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.."19) "..BZ["Brill"]..ALC["Comma"]..BZ["Tirisfal Glades"] },
		{ WHIT.."54) "..BZ["Grom'gol Base Camp"]..ALC["Comma"]..BZ["Northern Stranglethorn"] },
		{ WHIT.."56) "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..L["Orb of Translocation"] },
		{ PURP.." A) "..BZ["Hellscream's Grasp"]..ALC["Comma"]..BZ["Tol Barad Peninsula"] },
		{ PURP.." B) "..BZ["Baradin Hold"]..ALC["Comma"]..BZ["Tol Barad"] },
		{ GREY..INDENT..ALC["L-Parenthesis"]..L["Only available after winning the PvP battle"]..ALC["R-Parenthesis"] },
		{ PURP.." C) "..BZ["Dragonmaw Port"]..ALC["Comma"]..BZ["Twilight Highlands"] },
		{ PURP.." D) "..BZ["Fuselight-by-the-Sea"]..ALC["Comma"]..BZ["Badlands"] },
		{ GREY..INDENT..ALC["L-Parenthesis"]..L["Transporters by the sea and on the cliff"]..ALC["R-Parenthesis"] },
		{ PURP.." A') "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"] },
		{ PURP.." B') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.." 3) "..BZ["Sunfury Spire"]..ALC["Comma"]..BZ["Silvermoon City"]..ALC["Comma"]..BZ["Eversong Woods"] },
		{ WHIT.."20) "..BZ["Magic Quarter"]..ALC["Comma"]..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"] },
		{ WHIT.."51) "..BZ["Shattered Landing"]..ALC["Comma"]..BZ["Blasted Lands"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Hyphen"]..L["Druid Only"] },
		{ GREN.." A) "..BZ["Seradane"]..ALC["Comma"]..BZ["The Hinterlands"] },
		{ GREN.." B) "..BZ["Twilight Grove"]..ALC["Comma"]..BZ["Duskwood"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Isle of Quel'Danas"] },
		{ WHIT.." 1) "..BZ["Shattered Sun Staging Area"] },
		{ "" },
		{ BLUE..BZ["Eversong Woods"] },
		{ WHIT.." 2) "..BZ["Falconwing Square"] },
		{ WHIT.." 3) "..BZ["Silvermoon City"] },
		{ WHIT.." 4) "..BZ["Fairbreeze Village"] },
		{ "" },
		{ BLUE..BZ["Ghostlands"] },
		{ WHIT.." 5) "..BZ["Tranquillien"] },
		{ WHIT.." 6) "..BZ["Zul'Aman"] },
		{ "" },
		{ BLUE..BZ["Eastern Plaguelands"] },
		{ GREN.." 7) "..BZ["Acherus: The Ebon Hold"]..ALC["L-Parenthesis"]..L["Death Knight Only"]..ALC["R-Parenthesis"] },
		{ WHIT.." 8) "..BZ["Light's Hope Chapel"] },
		{ WHIT.." 9) "..BZ["Northpass Tower"] },
		{ WHIT.."10) "..BZ["Plaguewood Tower"] },
		{ WHIT.."11) "..BZ["Eastwall Tower"] },
		{ WHIT.."12) "..BZ["Light's Shield Tower"] },
		{ WHIT.."13) "..BZ["Crown Guard Tower"] },
		{ WHIT.."14) "..BZ["Thondroril River"] },
		{ "" },
		{ BLUE..BZ["Western Plaguelands"] },
		{ WHIT.."15) "..BZ["The Menders' Stead"] },
		{ WHIT.."16) "..BZ["Hearthglen"] },
		{ WHIT.."17) "..BZ["Andorhal"] },
		{ "" },
		{ BLUE..BZ["Tirisfal Glades"] },
		{ WHIT.."18) "..BZ["The Bulwark"] },
		{ WHIT.."19) "..BZ["Brill"] },
		{ WHIT.."20) "..BZ["Undercity"] },
		{ "" },
		{ BLUE..BZ["Silverpine Forest"] },
		{ WHIT.."21) "..BZ["Forsaken High Command"] },
		{ WHIT.."22) "..BZ["Forsaken Rear Guard"] },
		{ WHIT.."23) "..BZ["The Sepulcher"] },
		{ WHIT.."24) "..BZ["The Forsaken Front"] },
		{ "" },
		{ BLUE..BZ["Hillsbrad Foothills"] },
		{ WHIT.."25) "..BZ["Southpoint Gate"] },
		{ WHIT.."26) "..BZ["Ruins of Southshore"] },
		{ WHIT.."27) "..BZ["Eastpoint Tower"] },
		{ WHIT.."28) "..BZ["Tarren Mill"] },
		{ WHIT.."29) "..BZ["Strahnbrad"] },
		{ "" },
		{ BLUE..BZ["Arathi Highlands"] },
		{ WHIT.."30) "..BZ["Galen's Fall"] },
		{ WHIT.."31) "..BZ["Hammerfall"] },
		{ "" },
		{ BLUE..BZ["The Hinterlands"] },
		{ WHIT.."32) "..BZ["Hiri'watha Research Station"] },
		{ WHIT.."33) "..BZ["Revantusk Village"] },
		{ "" },
		{ BLUE..BZ["Twilight Highlands"] },
		{ WHIT.."34) "..BZ["Vermillion Redoubt"] },
		{ WHIT.."35) "..BZ["The Gullet"] },
		{ WHIT.."36) "..BZ["Bloodgulch"] },
		{ WHIT.."37) "..BZ["The Krazzworks"] },
		{ WHIT.."38) "..BZ["Dragonmaw Port"] },
		{ WHIT.."39) "..BZ["Crushblow"] },
		{ "" },
		{ BLUE..BZ["Badlands"] },
		{ WHIT.."40) "..BZ["Fuselight"] },
		{ WHIT.."41) "..BZ["Bloodwatcher Point"] },
		{ WHIT.."42) "..BZ["New Kargath"] },
		{ "" },
		{ BLUE..BZ["Searing Gorge"] },
		{ WHIT.."43) "..BZ["Thorium Point"] },
		{ WHIT.."44) "..BZ["Iron Summit"] },
		{ "" },
		{ BLUE..BZ["Burning Steppes"] },
		{ WHIT.."45) "..BZ["Flame Crest"] },
		{ WHIT.."46) "..BZ["Chiselgrip"] },
		{ WHIT.."47) "..BZ["Flamestar Post"] },
		{ PURP.."48) "..BZ["Terror Wing Path"]..ALC["L-Parenthesis"]..L["The Bogpaddle Bullet"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Swamp of Sorrows"] },
		{ WHIT.."49) "..BZ["Bogpaddle"] },
		{ WHIT.."50) "..BZ["Stonard"] },
		{ "" },
		{ BLUE..BZ["Blasted Lands"] },
		{ WHIT.."51) "..BZ["Dreadmaul Hold"] },
		{ WHIT.."52) "..BZ["Shattered Landing"] },
		{ WHIT.."53) "..BZ["Sunveil Excursion"] },
		{ "" },
		{ BLUE..BZ["Northern Stranglethorn"] },
		{ WHIT.."54) "..BZ["Bambala"] },
		{ WHIT.."55) "..BZ["Grom'gol Base Camp"] },
		{ "" },
		{ BLUE..BZ["The Cape of Stranglethorn"] },
		{ WHIT.."56) "..BZ["Hardwrench Hideaway"] },
		{ WHIT.."57) "..BZ["Booty Bay"] },
		{ "" },
		{ BLUE..BZ["Vashj'ir"] },
		{ CYAN.."58) "..BZ["Smuggler's Scar"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."59) "..BZ["Sandy Beach"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["Slash"]..L["Wind Rider"]..ALC["R-Parenthesis"] },
		{ CYAN.."60) "..BZ["Silver Tide Hollow"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."61) "..BZ["Legion's Rest"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ CYAN.."62) "..BZ["Stygian Bounty"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["Slash"]..L["Wind Rider"]..ALC["R-Parenthesis"] },
		{ CYAN.."63) "..BZ["Tenebrous Cavern"]..ALC["L-Parenthesis"]..L["Seahorse"]..ALC["R-Parenthesis"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },
		{ GREN.."-- : "..L["Special transportation"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Cataclysm Explorer", "ac=4868" },
		{ "Eastern Kingdoms Explorer", "ac=42" },
		{ "Explore Arathi Highlands", "ac=761" },
		{ "Explore Badlands", "ac=765" },
		{ "Explore Blasted Lands", "ac=766" },
		{ "Explore Burning Steppes", "ac=775" },
		{ "Explore Deadwind Pass", "ac=777" },
		{ "Explore Dun Morogh", "ac=627" },
		{ "Explore Duskwood", "ac=778" },
		{ "Explore Eastern Plaguelands", "ac=771" },
		{ "Explore Elwynn Forest", "ac=776" },
		{ "Explore Eversong Woods", "ac=859" },
		{ "Explore Ghostlands", "ac=858" },
		{ "Explore Hillsbrad Foothills", "ac=772" },
		{ "Explore Isle of Quel'Danas", "ac=868" },
		{ "Explore Loch Modan", "ac=779" },
		{ "Explore Northern Stranglethorn", "ac=781" },
		{ "Explore Redridge Mountains", "ac=780" },
		{ "Explore Searing Gorge", "ac=774" },
		{ "Explore Silverpine Forest", "ac=769" },
		{ "Explore Swamp of Sorrows", "ac=782" },
		{ "Explore the Cape of Stranglethorn", "ac=4995" },
		{ "Explore The Hinterlands", "ac=773" },
		{ "Explore Tirisfal Glades", "ac=768" },
		{ "Explore Twilight Highlands", "ac=4866" },
		{ "Explore Vashj'ir", "ac=4825" },
		{ "Explore Western Plaguelands", "ac=770" },
		{ "Explore Westfall", "ac=802" },
		{ "Explore Wetlands", "ac=841" },
		{ "From Hell's Heart I Stab at Thee", "ac=4975" },
		{ "Stood in the Fire", "ac=5518" },
		{ "Surveying the Damage", "ac=4827" },
		{ LBLU..QUESTS_LABEL },
		{ "Arathi Highlands Quests", "ac=4896" },
		{ "Badlands Quests", "ac=4900" },
		{ "Blasted Lands Quests", "ac=4909" },
		{ "Burning Steppes Quests", "ac=4901" },
		{ "Cape of Stranglethorn Quests", "ac=4905" },
		{ "Eastern Plaguelands Quests", "ac=4892" },
		{ "Full Caravan", "ac=5442" },
		{ "Ghostlands Quests", "ac=4908" },
		{ "Hillsbrad Foothills Quests", "ac=4895" },
		{ "Hinterlands Quests", "ac=4897" },
		{ "Loremaster of Eastern Kingdoms", "ac=1676" },
		{ "Northern Stranglethorn Quests", "ac=4906" },
		{ "Ready, Set, Goat!", "ac=5444" },
		{ "Searing Gorge Quests", "ac=4910" },
		{ "Silverpine Forest Quests", "ac=4894" },
		{ "Swamp of Sorrows Quests", "ac=4904" },
		{ "The Green Hills of Stranglethorn", "ac=940" },
		{ "Western Plaguelands Quests", "ac=4893" },
		{ "20,000 Leagues Under the Sea", "ac=5319" },
		{ "Breaking Out of Tol Barad", "ac=4874" },
		{ "Consumed by Nightmare", "ac=5451" },
		{ "Dragonmaw Tour of Duty", "ac=5482" },
		{ "Fading into Twilight", "ac=5501" },
		{ "King of the Mountain", "ac=5321" },
		{ "Loremaster of Cataclysm", "ac=4875" },
		{ "Round Three. Fight!", "ac=4960" },
		{ "Sinking into Vashj'ir", "ac=4982" },
		{ "Visions of Vashj'ir Past", "ac=5452" },
	},
	TransAllianceWest = {
		ZoneName = { BZ["Kalimdor"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "13",
		Faction = "Alliance",
		{ _RED..BZ["Docks"] },
		{ ORNG.." A) "..BZ["Valaar's Berth"]..ALC["Comma"]..BZ["Azuremyst Isle"] },
		{ ORNG.." A') "..BZ["Stormwind Harbor"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ ORNG.." B') "..BZ["Menethil Harbor"]..ALC["Comma"]..BZ["Wetlands"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ ORNG.." C') "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ WHIT.." 3) "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"] },
		{ WHIT.."28) "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"] },
		{ WHIT.."32) "..BZ["Theramore"]..ALC["Comma"]..BZ["Dustwallow Marsh"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..BZ["Waygate"] },
		{ PURP.." A) "..BZ["Shaper's Terrace"]..ALC["Comma"]..BZ["Un'Goro Crater"] },
		{ PURP.." B) "..BZ["Nordune Ridge"]..ALC["Comma"]..BZ["Mount Hyjal"] },
		{ PURP.." A') "..BZ["Waygate"]..ALC["Comma"]..BZ["Sholazar Basin"]..ALC["Comma"]..BZ["Northrend"] },
		{ PURP.." B') "..BZ["Molten Front"] },
		{ PURP.." C') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." D') "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"] },
		{ WHIT.." 2) "..BZ["Temple of the Moon"]..ALC["Comma"]..BZ["Darnassus"]..ALC["Comma"]..BZ["Teldrassil"] },
		{ WHIT.." 3) "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"] },
		{ WHIT.." 5) "..BZ["The Vault of Lights"]..ALC["Comma"]..BZ["The Exodar"]..ALC["Comma"]..BZ["Azuremyst Isle"] },
		{ WHIT.."48) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Hyphen"]..L["Druid Only"] },
		{ GREN.." A) "..BZ["Stormrage Barrow Dens"]..ALC["Comma"]..BZ["Moonglade"] },
		{ GREN.." B) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"] },
		{ GREN.." C) "..BZ["Dream Bough"]..ALC["Comma"]..BZ["Feralas"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Teldrassil"] },
		{ WHIT.." 1) "..BZ["Dolanaar"] },
		{ WHIT.." 2) "..BZ["Darnassus"] },
		{ WHIT.." 3) "..BZ["Rut'theran Village"] },
		{ "" },
		{ BLUE..BZ["Azuremyst Isle"]..ALC["Slash"]..BZ["Bloodmyst Isle"] },
		{ WHIT.." 4) "..BZ["Azure Watch"] },
		{ WHIT.." 5) "..BZ["The Exodar"] },
		{ WHIT.." 6) "..BZ["Blood Watch"] },
		{ "" },
		{ BLUE..BZ["Darkshore"] },
		{ WHIT.." 7) "..BZ["Lor'danel"] },
		{ WHIT.." 8) "..BZ["Grove of the Ancients"] },
		{ "" },
		{ BLUE..BZ["Ashenvale"] },
		{ WHIT.." 9) "..BZ["Blackfathom Camp"] },
		{ WHIT.."10) "..BZ["Astranaar"] },
		{ WHIT.."11) "..BZ["Forest Song"] },
		{ WHIT.."12) "..BZ["Stardust Spire"] },
		{ "" },
		{ BLUE..BZ["Stonetalon Mountains"] },
		{ WHIT.."13) "..BZ["Windshear Hold"] },
		{ WHIT.."14) "..BZ["Mirkfallon Post"] },
		{ WHIT.."15) "..BZ["Thal'darah Overlook"] },
		{ WHIT.."16) "..BZ["Farwatcher's Glen"] },
		{ WHIT.."17) "..BZ["Northwatch Expedition Base Camp"] },
		{ "" },
		{ BLUE..BZ["Desolace"] },
		{ WHIT.."18) "..BZ["Nijel's Point"] },
		{ WHIT.."19) "..BZ["Thunk's Abode"] },
		{ WHIT.."20) "..BZ["Karnum's Glade"] },
		{ WHIT.."21) "..BZ["Ethel Rethor"] },
		{ WHIT.."22) "..BZ["Thargad's Camp"] },
		{ "" },
		{ BLUE..BZ["Feralas"] },
		{ WHIT.."23) "..BZ["Dreamer's Rest"] },
		{ WHIT.."24) "..BZ["Feathermoon"] },
		{ WHIT.."25) "..BZ["Ruins of Feathermoon"] },
		{ WHIT.."26) "..BZ["Tower of Estulan"] },
		{ WHIT.."27) "..BZ["Shadebough"] },
		{ "" },
		{ BLUE..BZ["Northern Barrens"]..ALC["Slash"]..BZ["Southern Barrens"] },
		{ WHIT.."28) "..BZ["Ratchet"] },
		{ WHIT.."29) "..BZ["Honor's Stand"] },
		{ WHIT.."30) "..BZ["Northwatch Hold"] },
		{ WHIT.."31) "..BZ["Fort Triumph"] },
		{ "" },
		{ BLUE..BZ["Dustwallow Marsh"] },
		{ WHIT.."32) "..BZ["Theramore"] },
		{ WHIT.."33) "..BZ["Mudsprocket"] },
		{ "" },
		{ BLUE..BZ["Thousand Needles"] },
		{ WHIT.."34) "..BZ["Fizzle & Pozzik's Speedbarge"] },
		{ "" },
		{ BLUE..BZ["Tanaris"] },
		{ WHIT.."35) "..BZ["Gadgetzan"] },
		{ WHIT.."36) "..BZ["Bootlegger Outpost"] },
		{ WHIT.."37) "..BZ["Gunstan's Dig"] },
		{ "" },
		{ BLUE..BZ["Un'Goro Crater"] },
		{ WHIT.."38) "..BZ["Marshal's Stand"] },
		{ WHIT.."39) "..BZ["Mossy Pile"] },
		{ "" },
		{ BLUE..BZ["Silithus"] },
		{ WHIT.."40) "..BZ["Cenarion Hold"] },
		{ "" },
		{ BLUE..BZ["Felwood"] },
		{ WHIT.."41) "..BZ["Emerald Sanctuary"] },
		{ WHIT.."42) "..BZ["Wildheart Point"] },
		{ WHIT.."43) "..BZ["Whisperwind Grove"] },
		{ WHIT.."44) "..BZ["Talonbranch Glade"] },
		{ "" },
		{ BLUE..BZ["Moonglade"] },
		{ WHIT.."45) "..BZ["Moonglade"] },
		{ WHIT..INDENT..ALC["L-Parenthesis"]..L["South of the path along Lake Elune'ara"]..ALC["R-Parenthesis"] },
		{ GREN.."46) "..BZ["Nighthaven"]..ALC["L-Parenthesis"]..L["Druid Only"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Winterspring"] },
		{ WHIT.."47) "..BZ["Everlook"] },
		{ "" },
		{ BLUE..BZ["Mount Hyjal"] },
		{ WHIT.."48) "..BZ["Nordrassil"] },
		{ WHIT.."49) "..BZ["Shrine of Aviana"] },
		{ WHIT.."50) "..BZ["Shrine of Aessina"] },
		{ WHIT.."51) "..BZ["Sanctuary of Malorne"] },
		{ WHIT.."52) "..BZ["Gates of Sothann"] },
		{ "" },
		{ BLUE..BZ["Uldum"] },
		{ WHIT.."53) "..BZ["Ramkahen"] },
		{ WHIT.."54) "..BZ["Schnottz's Landing"] },
		{ WHIT.."55) "..BZ["Oasis of Vir'sar"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },	
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Cataclysm Explorer", "ac=4868" },
		{ "Explore Ashenvale", "ac=845" },
		{ "Explore Azshara", "ac=852" },
		{ "Explore Azuremyst Isle", "ac=860" },
		{ "Explore Bloodmyst Isle", "ac=861" },
		{ "Explore Darkshore", "ac=844" },
		{ "Explore Desolace", "ac=848" },
		{ "Explore Durotar", "ac=728" },
		{ "Explore Dustwallow Marsh", "ac=850" },
		{ "Explore Felwood", "ac=853" },
		{ "Explore Feralas", "ac=849" },
		{ "Explore Hyjal", "ac=4863" },
		{ "Explore Moonglade", "ac=855" },
		{ "Explore Mulgore", "ac=736" },
		{ "Explore Northern Barrens", "ac=750" },
		{ "Explore Silithus", "ac=856" },
		{ "Explore Southern Barrens", "ac=4996" },
		{ "Explore Stonetalon Mountains", "ac=847" },
		{ "Explore Tanaris", "ac=851" },
		{ "Explore Teldrassil", "ac=842" },
		{ "Explore Thousand Needles", "ac=846" },
		{ "Explore Uldum", "ac=4865" },
		{ "Explore Un'Goro Crater", "ac=854" },
		{ "Explore Winterspring", "ac=857" },
		{ "Kalimdor Explorer", "ac=43" },
		{ "Stood in the Fire", "ac=5518" },
		{ "Surveying the Damage", "ac=4827" },
		{ LBLU..QUESTS_LABEL },
		{ "Ashenvale Quests", "ac=4925" },
		{ "Bloodmyst Isle Quests", "ac=4926" },
		{ "Darkshore Quests", "ac=4928" },
		{ "Desolace Quests", "ac=4930" },
		{ "Dustwallow Marsh Quests", "ac=4929" },
		{ "E'ko Madness", "ac=5443" },
		{ "Felwood Quests", "ac=4931" },
		{ "Feralas Quests", "ac=4932" },
		{ "Ghosts in the Dark", "ac=5453" },
		{ "Glutton for Fiery Punishment", "ac=5448" },
		{ "Glutton for Icy Punishment", "ac=5546" },
		{ "Glutton for Shadowy Punishment", "ac=5547" },
		{ "Loremaster of Kalimdor", "ac=1678" },
		{ "Silithus Quests", "ac=4934" },
		{ "Southern Barrens Quests", "ac=4937" },
		{ "Stonetalon Mountains Quests", "ac=4936" },
		{ "Tanaris Quests", "ac=4935" },
		{ "Thousand Needles Quests", "ac=4938" },
		{ "Un'Goro Crater Quests", "ac=4939" },
		{ "Winterspring Quests", "ac=4940" },
		{ "And the Meek Shall Inherit Kalimdor", "ac=5868" },
		{ "Beware of the 'Unbeatable?' Pterodactyl", "ac=4959" },
		{ "Bounce", "ac=5483" },
		{ "Coming Down the Mountain", "ac=4870" },
		{ "Death From Above", "ac=5874" },
		{ "Fireside Chat", "ac=5870" },
		{ "Flawless Victory", "ac=5867" },
		{ "Gang War", "ac=5864" },
		{ "Have... Have We Met?", "ac=5865" },
		{ "Help the Bombardier! I'm the Bombardier!", "ac=5317" },
		{ "In a Thousand Years Even You Might be Worth Something", "ac=4961" },
		{ "Infernal Ambassadors", "ac=5869" },
		{ "King of the Spider-Hill", "ac=5872" },
		{ "Legacy of Leyara", "ac=5859" },
		{ "Loremaster of Cataclysm", "ac=4875" },
		{ "Ludicrous Speed", "ac=5862" },
		{ "Master of the Molten Flow", "ac=5871" },
		{ "Ready for Raiding II", "ac=5873" },
		{ "The 'Unbeatable?' Pterodactyl: BEATEN.", "ac=5860" },
		{ "The Fiery Lords of Sethria's Roost", "ac=5861" },
		{ "The Molten Front Offensive", "ac=5866" },
		{ "Unearthing Uldum", "ac=4872" },
		{ "Veteran of the Molten Front", "ac=5879" },
	},
	TransHordeWest = {
		ZoneName = { BZ["Kalimdor"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "13",
		Faction = "Horde",
		{ _RED..L["Zeppelin Towers"]..ALC["Slash"]..BZ["Docks"] },
		{ ORNG.." A') "..BZ["Warsong Hold"]..ALC["Comma"]..BZ["Borean Tundra"]..ALC["Comma"]..BZ["Northrend"] },
		{ ORNG.." B') "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ ORNG.." C') "..BZ["Grom'gol Base Camp"]..ALC["Comma"]..BZ["Northern Stranglethorn"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ ORNG.." D') "..BZ["Booty Bay"]..ALC["Comma"]..BZ["The Cape of Stranglethorn"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ WHIT.." 2) "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"] },
		{ WHIT.." 5) "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"] },
		{ WHIT.."12) "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..BZ["Waygate"] },
		{ PURP.." A) "..BZ["Shaper's Terrace"]..ALC["Comma"]..BZ["Un'Goro Crater"] },
		{ PURP.." B) "..BZ["Nordune Ridge"]..ALC["Comma"]..BZ["Mount Hyjal"] },
		{ PURP.." A') "..BZ["Waygate"]..ALC["Comma"]..BZ["Sholazar Basin"]..ALC["Comma"]..BZ["Northrend"] },
		{ PURP.." B') "..BZ["Molten Front"] },
		{ PURP.." C') "..BZ["Temple of Earth"]..ALC["Comma"]..BZ["Deepholm"] },
		{ PURP.." D') "..BZ["Hellscream's Grasp"]..ALC["Comma"]..BZ["Tol Barad Peninsula"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." E') "..BZ["Vashj'ir"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." F') "..BZ["Dragonmaw Port"]..ALC["Comma"]..BZ["Twilight Highlands"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." G') "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"] },
		{ PURP.." H') "..BZ["Honeydew Village"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Comma"]..BZ["Pandaria"] },
		{ PURP.." I') "..BZ["Shattered Landing"]..ALC["Comma"]..BZ["Blasted Lands"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." J') "..BZ["Darkmoon Island"] },
		{ PURP.." K') "..BZ["Warspear"]..ALC["Comma"]..BZ["Ashran"]..ALC["Comma"]..BZ["Draenor"] },
		{ WHIT.." 2) "..BZ["Spirit Rise"]..ALC["Comma"]..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"] },
		{ WHIT.." 5) "..BZ["Valley of Spirits"]..ALC["Comma"]..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Mulgore"] },
		{ WHIT.." 1) "..BZ["Bloodhoof Village"] },
		{ WHIT.." 2) "..BZ["Thunder Bluff"] },
		{ "" },
		{ BLUE..BZ["Durotar"] },
		{ WHIT.." 3) "..BZ["Sen'jin Village"] },
		{ WHIT.." 4) "..BZ["Razor Hill"] },
		{ WHIT.." 5) "..BZ["Orgrimmar"] },
		{ "" },
		{ BLUE..BZ["Azshara"] },
		{ WHIT.." 6) "..BZ["Valormok"] },
		{ WHIT.." 7) "..BZ["Southern Rocketway"] },
		{ WHIT.." 8) "..BZ["Bilgewater Harbor"] },
		{ WHIT.." 9) "..BZ["Northern Rocketway"] },
		{ "" },
		{ BLUE..BZ["Northern Barrens"] },
		{ WHIT.."10) "..BZ["Nozzlepot's Outpost"] },
		{ WHIT.."11) "..BZ["Crossroads"] },
		{ WHIT.."12) "..BZ["Ratchet"] },
		{ "" },
		{ BLUE..BZ["Ashenvale"] },
		{ WHIT.."13) "..BZ["The Mor'Shan Ramparts"] },
		{ WHIT.."14) "..BZ["Splintertree Post"] },
		{ WHIT.."15) "..BZ["Silverwind Refuge"] },
		{ WHIT.."16) "..BZ["Hellscream's Watch"] },
		{ WHIT.."17) "..BZ["Zoram'gar Outpost"] },
		{ "" },
		{ BLUE..BZ["Stonetalon Mountains"] },
		{ WHIT.."18) "..BZ["Cliffwalker Post"] },
		{ WHIT.."19) "..BZ["The Sludgewerks"] },
		{ WHIT.."20) "..BZ["Sun Rock Retreat"] },
		{ WHIT.."21) "..BZ["Krom'gar Fortress"] },
		{ WHIT.."22) "..BZ["Malaka'jin"] },
		{ "" },
		{ BLUE..BZ["Desolace"] },
		{ WHIT.."23) "..BZ["Thunk's Abode"] },
		{ WHIT.."24) "..BZ["Karnum's Glade"] },
		{ WHIT.."25) "..BZ["Furien's Post"] },
		{ WHIT.."26) "..BZ["Ethel Rethor"] },
		{ WHIT.."27) "..BZ["Shadowprey Village"] },
		{ "" },
		{ BLUE..BZ["Southern Barrens"] },
		{ WHIT.."28) "..BZ["Hunter's Hill"] },
		{ WHIT.."29) "..BZ["Vendetta Point"] },
		{ WHIT.."30) "..BZ["Desolation Hold"] },
		{ "" },
		{ BLUE..BZ["Dustwallow Marsh"] },
		{ WHIT.."31) "..BZ["Brackenwall Village"] },
		{ WHIT.."32) "..BZ["Mudsprocket"] },
		{ "" },
		{ BLUE..BZ["Feralas"] },
		{ WHIT.."33) "..BZ["Camp Ataya"] },
		{ WHIT.."34) "..BZ["Stonemaul Hold"] },
		{ WHIT.."35) "..BZ["Camp Mojache"] },
		{ "" },
		{ BLUE..BZ["Thousand Needles"] },
		{ WHIT.."36) "..BZ["Westreach Summit"] },
		{ WHIT.."37) "..BZ["Fizzle & Pozzik's Speedbarge"] },
		{ "" },
		{ BLUE..BZ["Tanaris"] },
		{ WHIT.."38) "..BZ["Gadgetzan"] },
		{ WHIT.."39) "..BZ["Bootlegger Outpost"] },
		{ WHIT.."40) "..BZ["Dawnrise Expedition"] },
		{ "" },
		{ BLUE..BZ["Un'Goro Crater"] },
		{ WHIT.."41) "..BZ["Marshal's Stand"] },
		{ WHIT.."42) "..BZ["Mossy Pile"] },
		{ "" },
		{ BLUE..BZ["Silithus"] },
		{ WHIT.."43) "..BZ["Cenarion Hold"] },
		{ "" },
		{ BLUE..BZ["Felwood"] },
		{ WHIT.."44) "..BZ["Emerald Sanctuary"] },
		{ WHIT.."45) "..BZ["Wildheart Point"] },
		{ WHIT.."46) "..BZ["Whisperwind Grove"] },
		{ WHIT.."47) "..BZ["Irontree Clearing"] },
		{ "" },
		{ BLUE..BZ["Moonglade"] },
		{ WHIT.."48) "..BZ["Moonglade"] },
		{ WHIT..INDENT..ALC["L-Parenthesis"]..L["West of the path to Timbermaw Hold"]..ALC["R-Parenthesis"] },
		{ GREN.."49) "..BZ["Nighthaven"]..ALC["L-Parenthesis"]..L["Druid Only"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Winterspring"] },
		{ WHIT.."50) "..BZ["Everlook"] },
		{ "" },
		{ BLUE..BZ["Mount Hyjal"] },
		{ WHIT.."51) "..BZ["Nordrassil"] },
		{ WHIT.."52) "..BZ["Shrine of Aviana"] },
		{ WHIT.."53) "..BZ["Shrine of Aessina"] },
		{ WHIT.."54) "..BZ["Sanctuary of Malorne"] },
		{ WHIT.."55) "..BZ["Gates of Sothann"] },
		{ "" },
		{ BLUE..BZ["Uldum"] },
		{ WHIT.."56) "..BZ["Ramkahen"] },
		{ WHIT.."57) "..BZ["Schnottz's Landing"] },
		{ WHIT.."58) "..BZ["Oasis of Vir'sar"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },	
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Cataclysm Explorer", "ac=4868" },
		{ "Explore Ashenvale", "ac=845" },
		{ "Explore Azshara", "ac=852" },
		{ "Explore Azuremyst Isle", "ac=860" },
		{ "Explore Bloodmyst Isle", "ac=861" },
		{ "Explore Darkshore", "ac=844" },
		{ "Explore Desolace", "ac=848" },
		{ "Explore Durotar", "ac=728" },
		{ "Explore Dustwallow Marsh", "ac=850" },
		{ "Explore Felwood", "ac=853" },
		{ "Explore Feralas", "ac=849" },
		{ "Explore Hyjal", "ac=4863" },
		{ "Explore Moonglade", "ac=855" },
		{ "Explore Mulgore", "ac=736" },
		{ "Explore Northern Barrens", "ac=750" },
		{ "Explore Silithus", "ac=856" },
		{ "Explore Southern Barrens", "ac=4996" },
		{ "Explore Stonetalon Mountains", "ac=847" },
		{ "Explore Tanaris", "ac=851" },
		{ "Explore Teldrassil", "ac=842" },
		{ "Explore Thousand Needles", "ac=846" },
		{ "Explore Uldum", "ac=4865" },
		{ "Explore Un'Goro Crater", "ac=854" },
		{ "Explore Winterspring", "ac=857" },
		{ "Kalimdor Explorer", "ac=43" },
		{ "Stood in the Fire", "ac=5518" },
		{ "Surveying the Damage", "ac=4827" },
		{ LBLU..QUESTS_LABEL },
		{ "Ashenvale Quests", "ac=4976" },
		{ "Azshara Quests", "ac=4927" },
		{ "Desolace Quests", "ac=4930" },
		{ "Dustwallow Marsh Quests", "ac=4978" },
		{ "E'ko Madness", "ac=5443" },
		{ "Felwood Quests", "ac=4931" },
		{ "Feralas Quests", "ac=4979" },
		{ "Glutton for Fiery Punishment", "ac=5448" },
		{ "Glutton for Icy Punishment", "ac=5546" },
		{ "Glutton for Shadowy Punishment", "ac=5547" },
		{ "Joy Ride", "ac=5454" },
		{ "Loremaster of Kalimdor", "ac=1678" },
		{ "Northern Barrens Quests", "ac=4933" },
		{ "Silithus Quests", "ac=4934" },
		{ "Southern Barrens Quests", "ac=4981" },
		{ "Stonetalon Mountains Quests", "ac=4980" },
		{ "Tanaris Quests", "ac=4935" },
		{ "Thousand Needles Quests", "ac=4938" },
		{ "Un'Goro Crater Quests", "ac=4939" },
		{ "Winterspring Quests", "ac=4940" },
		{ "And the Meek Shall Inherit Kalimdor", "ac=5868" },
		{ "Beware of the 'Unbeatable?' Pterodactyl", "ac=4959" },
		{ "Bounce", "ac=5483" },
		{ "Coming Down the Mountain", "ac=4870" },
		{ "Death From Above", "ac=5874" },
		{ "Fireside Chat", "ac=5870" },
		{ "Flawless Victory", "ac=5867" },
		{ "Gang War", "ac=5864" },
		{ "Have... Have We Met?", "ac=5865" },
		{ "Help the Bombardier! I'm the Bombardier!", "ac=5317" },
		{ "In a Thousand Years Even You Might be Worth Something", "ac=4961" },
		{ "Infernal Ambassadors", "ac=5869" },
		{ "King of the Spider-Hill", "ac=5872" },
		{ "Legacy of Leyara", "ac=5859" },
		{ "Loremaster of Cataclysm", "ac=4875" },
		{ "Ludicrous Speed", "ac=5862" },
		{ "Master of the Molten Flow", "ac=5871" },
		{ "Ready for Raiding II", "ac=5873" },
		{ "The 'Unbeatable?' Pterodactyl: BEATEN.", "ac=5860" },
		{ "The Fiery Lords of Sethria's Roost", "ac=5861" },
		{ "The Molten Front Offensive", "ac=5866" },
		{ "Unearthing Uldum", "ac=4872" },
		{ "Veteran of the Molten Front", "ac=5879" },
	},
	TransAllianceStormwindCity = {
		ZoneName = { BZ["Stormwind City"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "301",
		Faction = "Alliance",
		LargeMap = "TransAllianceStormwindCity",
		{ _RED..BZ["Docks"] },
		{ ORNG.." A) "..BZ["Rut'theran Village"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"], 10001 },
		{ ORNG.." B) "..BZ["Valiance Keep"]..ALC["Comma"]..BZ["Borean Tundra"]..ALC["Comma"]..BZ["Northrend"], 10002 },
		{ "" },
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"], 10003 },
		{ PURP.." B) "..BZ["Fuselight-by-the-Sea"]..ALC["Comma"]..BZ["Badlands"], 10004 },
		{ PURP.." C) "..BZ["Paw'Don Village"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Comma"]..BZ["Pandaria"], 10005 },
		{ PURP.." D) "..BZ["Baradin Base Camp"]..ALC["Comma"]..BZ["Tol Barad Peninsula"], 10006 },
		{ PURP.." E) "..BZ["Darkbreak Cove"]..ALC["Comma"]..BZ["Vashj'ir"], 10007 },
		{ PURP.." F) "..BZ["Highbank"]..ALC["Comma"]..BZ["Twilight Highlands"], 10008 },
		{ PURP.." G) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"]..ALC["Comma"]..BZ["Kalimdor"], 10009 },
		{ PURP.." H) "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"]..ALC["Comma"]..BZ["Kalimdor"], 10010 },
		{ PURP.." I) "..BZ["Temple of Earth"]..ALC["Comma"]..BZ["Deepholm"], 10011 },
		{ PURP.." J) "..BZ["Stormshield"]..ALC["Comma"]..BZ["Ashran"]..ALC["Comma"]..BZ["Draenor"], 10012 },
		{ PURP.." K) "..BZ["Dalaran"]..ALC["Comma"]..BZ["Broken Isles"], 10013 },
		{ "" },
		{ _RED..DUNGEON_FLOOR_DEEPRUNTRAM1 },
		{ WHIT.." 1) "..BZ["Ironforge"], 10014 },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ WHIT.." 2) "..L["Gryphon Master"], 10015 },
	},
	TransHordeOrgrimmar = {
		ZoneName = { BZ["Orgrimmar"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "321",
		Faction = "Horde",
		LargeMap = "TransHordeOrgrimmar",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Shattered Landing"]..ALC["Comma"]..BZ["Blasted Lands"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10001 },
		{ GREY..INDENT..ALC["L-Parenthesis"]..BZ["Cleft of Shadow"]..ALC["R-Parenthesis"] },
		{ PURP.." B) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"]..ALC["Comma"]..BZ["Outland"], 10002 },
		{ GREY..INDENT..ALC["L-Parenthesis"]..BZ["Cleft of Shadow"]..ALC["Slash"]..BZ["Valley of Spirits"]..ALC["R-Parenthesis"] },
		{ PURP.." C) "..BZ["Hellscream's Grasp"]..ALC["Comma"]..BZ["Tol Barad Peninsula"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10003 },
		{ PURP.." D) "..BZ["Ramkahen"]..ALC["Comma"]..BZ["Uldum"], 10004 },
		{ PURP.." E) "..BZ["Vashj'ir"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10005 },
		{ PURP.." F) "..BZ["Temple of Earth"]..ALC["Comma"]..BZ["Deepholm"], 10006 },
		{ PURP.." G) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"], 10007 },
		{ PURP.." H) "..BZ["Dragonmaw Port"]..ALC["Comma"]..BZ["Twilight Highlands"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10008 },
		{ PURP.." I) "..BZ["Honeydew Village"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Comma"]..BZ["Pandaria"], 10009 },
		{ PURP.." J) "..BZ["Warspear"]..ALC["Comma"]..BZ["Ashran"]..ALC["Comma"]..BZ["Draenor"], 10010 },
		{ PURP.." K) "..BZ["Dalaran"]..ALC["Comma"]..BZ["Karazhan"], 10016 },
		{ GREY..INDENT..ALC["L-Parenthesis"]..BZ["Cleft of Shadow"]..ALC["Slash"]..BZ["Valley of Spirits"]..ALC["R-Parenthesis"] },
		{ "" },
		{ _RED..L["Zeppelin Towers"] },
		{ ORNG.." A) "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"], 10011 },
		{ ORNG.." B) "..BZ["Warsong Hold"]..ALC["Comma"]..BZ["Borean Tundra"]..ALC["Comma"]..BZ["Northrend"], 10012 },
		{ ORNG.." C) "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10013 },
		{ ORNG.." D) "..BZ["Grom'gol Base Camp"]..ALC["Comma"]..BZ["Northern Stranglethorn"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10014 },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ WHIT.." 1) "..L["Wind Rider Master"], 10015 },
		{ "" },
		{ _RED..ALC["Connection"] },
		{ BLUE.." A) "..BZ["Northern Barrens"], 10017 },
		{ BLUE.." B) "..BZ["Durotar"], 10018 },
		{ BLUE.." C) "..BZ["Azshara"], 10019 },
	},
	TransAllianceOutland = {
		ZoneName = { BZ["Outland"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "466",
		Faction = "Alliance",
		{ _RED..L["Portals"]..ALC["Slash"]..L["Transporter"] },
		{ PURP.." A') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." B') "..BZ["Sun's Reach Sanctum"]..ALC["Comma"]..BZ["Isle of Quel'Danas"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." C') "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.." 1) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"] },
		{ WHIT.." 9) "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Hellfire Peninsula"] },
		{ WHIT.." 1) "..BZ["The Stair of Destiny"] },
		{ WHIT.." 2) "..BZ["Shatter Point"] },
		{ WHIT.." 3) "..BZ["Honor Point"] },
		{ WHIT.." 4) "..BZ["Honor Hold"] },
		{ WHIT.." 5) "..BZ["Temple of Telhamat"] },
		{ "" },
		{ BLUE..BZ["Zangarmarsh"] },
		{ WHIT.." 6) "..BZ["Telredor"] },
		{ WHIT.." 7) "..BZ["Orebor Harborage"] },
		{ "" },
		{ BLUE..BZ["Nagrand"] },
		{ WHIT.." 8) "..BZ["Telaar"] },
		{ "" },
		{ BLUE..BZ["Terokkar Forest"] },
		{ WHIT.." 9) "..BZ["Shattrath City"] },
		{ WHIT.."10) "..BZ["Allerian Stronghold"] },
		{ GREN.."11) "..BZ["Blackwind Landing"] },
		{ GREN..INDENT..ALC["L-Parenthesis"]..L["Requires honored faction with Sha'tari Skyguard"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Shadowmoon Valley"] },
		{ WHIT.."12) "..BZ["Wildhammer Stronghold"] },
		{ GREN.."13) "..BZ["Altar of Sha'tar"]..ALC["L-Parenthesis"]..BF["The Aldor"]..ALC["R-Parenthesis"] },
		{ GREN.."14) "..BZ["Sanctum of the Stars"]..ALC["L-Parenthesis"]..BF["The Scryers"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Blade's Edge Mountains"] },
		{ WHIT.."15) "..BZ["Sylvanaar"] },
		{ WHIT.."16) "..BZ["Evergrove"] },
		{ WHIT.."17) "..BZ["Toshley's Station"] },
		{ GREN.."18) "..BZ["Skyguard Outpost"] },
		{ GREN..INDENT..ALC["L-Parenthesis"]..L["Requires honored faction with Sha'tari Skyguard"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Netherstorm"] },
		{ WHIT.."19) "..BZ["Area 52"] },
		{ WHIT.."20) "..BZ["The Stormspire"] },
		{ WHIT.."21) "..BZ["Cosmowrench"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Bloody Rare", "ac=1312" },
		{ "Explore Blade's Edge Mountains", "ac=865" },
		{ "Explore Hellfire Peninsula", "ac=862" },
		{ "Explore Nagrand", "ac=866" },
		{ "Explore Netherstorm", "ac=843" },
		{ "Explore Shadowmoon Valley", "ac=864" },
		{ "Explore Terokkar Forest", "ac=867" },
		{ "Explore Zangarmarsh", "ac=863" },
		{ "Medium Rare", "ac=1311" },
		{ "Outland Explorer", "ac=44" },
		{ LBLU..QUESTS_LABEL },
		{ "Blade's Edge Bomberman", "ac=1276" },
		{ "Bombs Away", "ac=1275" },
		{ "Hills Like White Elekk", "ac=939" },
		{ "Into the Nether", "ac=1194" },
		{ "Loremaster of Outland", "ac=1262" },
		{ "Mysteries of the Marsh", "ac=1190" },
		{ "Nagrand Slam", "ac=1192" },
		{ "On the Blade's Edge", "ac=1193" },
		{ "Shadow of the Betrayer", "ac=1195" },
		{ "Terror of Terokkar", "ac=1191" },
		{ "To Hellfire and Back", "ac=1189" },
	},
	TransHordeOutland = {
		ZoneName = { BZ["Outland"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "466",
		Faction = "Horde",
		{ _RED..L["Portals"]..ALC["Slash"]..L["Transporter"] },
		{ PURP.." A') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." B') "..BZ["Sun's Reach Sanctum"]..ALC["Comma"]..BZ["Isle of Quel'Danas"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." C') "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.." 1) "..BZ["The Stair of Destiny"]..ALC["Comma"]..BZ["Hellfire Peninsula"] },
		{ WHIT.." 8) "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Hellfire Peninsula"] },
		{ WHIT.." 1) "..BZ["The Stair of Destiny"] },
		{ WHIT.." 2) "..BZ["Thrallmar"] },
		{ WHIT.." 3) "..BZ["Spinebreaker Post"] },
		{ WHIT.." 4) "..BZ["Falcon Watch"] },
		{ "" },
		{ BLUE..BZ["Zangarmarsh"] },
		{ WHIT.." 5) "..BZ["Swamprat Post"] },
		{ WHIT.." 6) "..BZ["Zabra'jin"] },
		{ "" },
		{ BLUE..BZ["Nagrand"] },
		{ WHIT.." 7) "..BZ["Garadar"] },
		{ "" },
		{ BLUE..BZ["Terokkar Forest"] },
		{ WHIT.." 8) "..BZ["Shattrath City"] },
		{ WHIT.." 9) "..BZ["Stonebreaker Hold"] },
		{ GREN.."10) "..BZ["Blackwind Landing"] },
		{ GREN..INDENT..ALC["L-Parenthesis"]..L["Requires honored faction with Sha'tari Skyguard"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Shadowmoon Valley"] },
		{ WHIT.."11) "..BZ["Shadowmoon Village"] },
		{ GREN.."12) "..BZ["Altar of Sha'tar"]..ALC["L-Parenthesis"]..BF["The Aldor"]..ALC["R-Parenthesis"] },
		{ GREN.."13) "..BZ["Sanctum of the Stars"]..ALC["L-Parenthesis"]..BF["The Scryers"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Blade's Edge Mountains"] },
		{ WHIT.."14) "..BZ["Thunderlord Stronghold"] },
		{ WHIT.."15) "..BZ["Evergrove"] },
		{ WHIT.."16) "..BZ["Mok'Nathal Village"] },
		{ GREN.."17) "..BZ["Skyguard Outpost"] },
		{ GREN..INDENT..ALC["L-Parenthesis"]..L["Requires honored faction with Sha'tari Skyguard"]..ALC["R-Parenthesis"] },
		{ "" },
		{ BLUE..BZ["Netherstorm"] },
		{ WHIT.."18) "..BZ["Area 52"] },
		{ WHIT.."19) "..BZ["The Stormspire"] },
		{ WHIT.."20) "..BZ["Cosmowrench"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Bloody Rare", "ac=1312" },
		{ "Explore Blade's Edge Mountains", "ac=865" },
		{ "Explore Hellfire Peninsula", "ac=862" },
		{ "Explore Nagrand", "ac=866" },
		{ "Explore Netherstorm", "ac=843" },
		{ "Explore Shadowmoon Valley", "ac=864" },
		{ "Explore Terokkar Forest", "ac=867" },
		{ "Explore Zangarmarsh", "ac=863" },
		{ "Medium Rare", "ac=1311" },
		{ "Outland Explorer", "ac=44" },
		{ LBLU..QUESTS_LABEL },
		{ "Blade's Edge Bomberman", "ac=1276" },
		{ "Bombs Away", "ac=1275" },
		{ "Hills Like White Elekk", "ac=939" },
		{ "Into the Nether", "ac=1194" },
		{ "Loremaster of Outland", "ac=1262" },
		{ "Mysteries of the Marsh", "ac=1190" },
		{ "Nagrand Slam", "ac=1273" },
		{ "On the Blade's Edge", "ac=1193" },
		{ "Shadow of the Betrayer", "ac=1195" },
		{ "Terror of Terokkar", "ac=1272" },
		{ "To Hellfire and Back", "ac=1271" },
	},
	TransAllianceNorthrend = {
		ZoneName = { BZ["Northrend"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "485",
		Faction = "Alliance",
		{ _RED..BZ["Docks"] },
		{ ORNG.." A') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ ORNG.." B') "..BZ["Menethil Harbor"]..ALC["Comma"]..BZ["Wetlands"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ WHIT.." 1) "..BZ["Valiance Keep"]..ALC["Comma"]..BZ["Borean Tundra"] },
		{ WHIT.." 5) "..BZ["Unu'pe"]..ALC["Comma"]..BZ["Borean Tundra"] },
		{ WHIT.." 9) "..BZ["Moa'ki Harbor"]..ALC["Comma"]..BZ["Dragonblight"] },
		{ WHIT.."14) "..BZ["Kamagua"]..ALC["Comma"]..BZ["Howling Fjord"] },
		{ WHIT.."15) "..BZ["Valgarde"]..ALC["Comma"]..BZ["Howling Fjord"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..BZ["Waygate"] },
		{ PURP.." A) "..BZ["Waygate"]..ALC["Comma"]..BZ["Sholazar Basin"] },
		{ PURP.." B) "..BZ["Wintergrasp Fortress"]..ALC["Comma"]..BZ["Wintergrasp"] },
		{ PURP.." C) "..BZ["Violet Stand"]..ALC["Comma"]..BZ["Crystalsong Forest"] },
		{ PURP.." D) "..BZ["Garm's Rise"]..ALC["Comma"]..BZ["The Storm Peaks"] },
		{ PURP.." A') "..BZ["Shaper's Terrace"]..ALC["Comma"]..BZ["Un'Goro Crater"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." B') "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." C') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ WHIT.."25) "..BZ["Dalaran"]..ALC["Comma"]..BZ["Crystalsong Forest"] },
		{ WHIT.."27) "..BZ["K3"]..ALC["Comma"]..BZ["The Storm Peaks"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Hyphen"]..L["Druid Only"] },
		{ GREN.." A) "..BZ["Grizzly Hills"]..GREY.." (50.38, 29.40)" },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Borean Tundra"] },
		{ WHIT.." 1) "..BZ["Valiance Keep"] },
		{ WHIT.." 2) "..BZ["Amber Ledge"] },
		{ "" },
		{ BLUE..BZ["Coldarra"] },
		{ WHIT.." 3) "..BZ["Transitus Shield"] },
		{ "" },
		{ BLUE..BZ["Borean Tundra"] },
		{ WHIT.." 4) "..BZ["Fizzcrank Airstrip"] },
		{ WHIT.." 5) "..BZ["Unu'pe"] },
		{ "" },
		{ BLUE..BZ["Sholazar Basin"] },
		{ WHIT.." 6) "..BZ["Nesingwary Base Camp"] },
		{ WHIT.." 7) "..BZ["River's Heart"] },
		{ "" },
		{ BLUE..BZ["Dragonblight"] },
		{ WHIT.." 8) "..BZ["Stars' Rest"] },
		{ WHIT.." 9) "..BZ["Moa'ki Harbor"] },
		{ WHIT.."10) "..BZ["Fordragon Hold"] },
		{ WHIT.."11) "..BZ["Wyrmrest Temple"] },
		{ WHIT.."12) "..BZ["Wintergarde Keep"] },
		{ "" },
		{ BLUE..BZ["Howling Fjord"] },
		{ WHIT.."13) "..BZ["Westguard Keep"] },
		{ WHIT.."14) "..BZ["Kamagua"] },
		{ WHIT.."15) "..BZ["Valgarde"] },
		{ WHIT.."16) "..BZ["Fort Wildervar"] },
		{ "" },
		{ BLUE..BZ["Grizzly Hills"] },
		{ WHIT.."17) "..BZ["Amberpine Lodge"] },
		{ WHIT.."18) "..BZ["Westfall Brigade Encampment"] },
		{ "" },
		{ BLUE..BZ["Zul'Drak"] },
		{ WHIT.."19) "..BZ["Gundrak"] },
		{ WHIT.."20) "..BZ["Zim'Torga"] },
		{ WHIT.."21) "..BZ["The Argent Stand"] },
		{ WHIT.."22) "..BZ["Light's Breach"] },
		{ WHIT.."23) "..BZ["Ebon Watch"] },
		{ "" },
		{ BLUE..BZ["Crystalsong Forest"] },
		{ WHIT.."24) "..BZ["Windrunner's Overlook"] },
		{ WHIT.."25) "..BZ["Dalaran"] },
		{ "" },
		{ BLUE..BZ["The Storm Peaks"] },
		{ WHIT.."26) "..BZ["Frosthold"] },
		{ WHIT.."27) "..BZ["K3"] },
		{ WHIT.."28) "..BZ["Bouldercrag's Refuge"] },
		{ WHIT.."29) "..BZ["Ulduar"] },
		{ WHIT.."30) "..BZ["Dun Niffelem"] },
		{ "" },
		{ BLUE..BZ["Icecrown"] },
		{ WHIT.."31) "..BZ["The Argent Vanguard"] },
		{ WHIT.."32) "..BZ["Crusaders' Pinnacle"] },
		{ WHIT.."33) "..BZ["Argent Tournament Grounds"] },
		{ WHIT.."34) "..BZ["The Shadow Vault"] },
		{ WHIT.."35) "..BZ["Death's Rise"] },
		{ "" },
		{ BLUE..BZ["Wintergrasp"] },
		{ WHIT.."36) "..BZ["Valiance Landing Camp"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },	
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Borean Tundra", "ac=1264" },
		{ "Explore Crystalsong Forest", "ac=1457" },
		{ "Explore Dragonblight", "ac=1265" },
		{ "Explore Grizzly Hills", "ac=1266" },
		{ "Explore Howling Fjord", "ac=1263" },
		{ "Explore Icecrown", "ac=1270" },
		{ "Explore Sholazar Basin", "ac=1268" },
		{ "Explore Storm Peaks", "ac=1269" },
		{ "Explore Zul'Drak", "ac=1267" },
		{ "Frostbitten", "ac=2257" },
		{ "Higher Learning", "ac=1956" },
		{ "Northrend Explorer", "ac=45" },
		{ "Northern Exposure", "ac=2256" },
		{ LBLU..QUESTS_LABEL },
		{ "D.E.H.T.A's Little P.I.T.A.", "ac=561" },
		{ "Fo' Grizzle My Shizzle", "ac=37" },
		{ "Guru of Drakuru", "ac=1596" },
		{ "Honorary Frenzyheart", "ac=961" },
		{ "I've Toured the Fjord", "ac=34" },
		{ "Icecrown: The Final Goal", "ac=40" },
		{ "Into the Basin", "ac=39" },
		{ "Loremaster of Northrend", "ac=41" },
		{ "Might of Dragonblight", "ac=35" },
		{ "Mine Sweeper", "ac=1428" },
		{ "Nothing Boring About Borean", "ac=33" },
		{ "Rapid Defense", "ac=1277" },
		{ "Savior of the Oracles", "ac=962" },
		{ "The Empire of Zul'Drak", "ac=36" },
		{ "The Snows of Northrend", "ac=938" },
		{ "The Summit of Storm Peaks", "ac=38" },
		{ "Veteran of the Wrathgate", "ac=547" },
	},
	TransHordeNorthrend = {
		ZoneName = { BZ["Northrend"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "485",
		Faction = "Horde",
		{ _RED..L["Zeppelin Towers"] },
		{ ORNG.." A') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ ORNG.." B') "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ WHIT.." 1) "..BZ["Warsong Hold"]..ALC["Comma"]..BZ["Borean Tundra"] },
		{ WHIT.." 6) "..BZ["Unu'pe"]..ALC["Comma"]..BZ["Borean Tundra"] },
		{ WHIT.."10) "..BZ["Moa'ki Harbor"]..ALC["Comma"]..BZ["Dragonblight"] },
		{ WHIT.."14) "..BZ["Kamagua"]..ALC["Comma"]..BZ["Howling Fjord"] },
		{ WHIT.."16) "..BZ["Vengeance Landing"]..ALC["Comma"]..BZ["Howling Fjord"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Slash"]..BZ["Waygate"] },
		{ PURP.." A) "..BZ["Waygate"]..ALC["Comma"]..BZ["Sholazar Basin"] },
		{ PURP.." B) "..BZ["Wintergrasp Fortress"]..ALC["Comma"]..BZ["Wintergrasp"] },
		{ PURP.." C) "..BZ["Violet Stand"]..ALC["Comma"]..BZ["Crystalsong Forest"] },
		{ PURP.." D) "..BZ["Garm's Rise"]..ALC["Comma"]..BZ["The Storm Peaks"] },
		{ PURP.." A') "..BZ["Shaper's Terrace"]..ALC["Comma"]..BZ["Un'Goro Crater"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." B') "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." C') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ WHIT.."27) "..BZ["Dalaran"]..ALC["Comma"]..BZ["Crystalsong Forest"] },
		{ WHIT.."28) "..BZ["K3"]..ALC["Comma"]..BZ["The Storm Peaks"] },
		{ "" },
		{ _RED..L["Portals"]..ALC["Hyphen"]..L["Druid Only"] },
		{ GREN.." A) "..BZ["Grizzly Hills"]..GREY.." (50.38, 29.40)" },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Borean Tundra"] },
		{ WHIT.." 1) "..BZ["Warsong Hold"] },
		{ WHIT.." 2) "..BZ["Amber Ledge"] },
		{ "" },
		{ BLUE..BZ["Coldarra"] },
		{ WHIT.." 3) "..BZ["Transitus Shield"] },
		{ "" },
		{ BLUE..BZ["Borean Tundra"] },
		{ WHIT.." 4) "..BZ["Bor'gorok Outpost"] },
		{ WHIT.." 5) "..BZ["Taunka'le Village"] },
		{ WHIT.." 6) "..BZ["Unu'pe"] },
		{ "" },
		{ BLUE..BZ["Sholazar Basin"] },
		{ WHIT.." 7) "..BZ["Nesingwary Base Camp"] },
		{ WHIT.." 8) "..BZ["River's Heart"] },
		{ "" },
		{ BLUE..BZ["Dragonblight"] },
		{ WHIT.." 9) "..BZ["Agmar's Hammer"] },
		{ WHIT.."10) "..BZ["Moa'ki Harbor"] },
		{ WHIT.."11) "..BZ["Kor'kron Vanguard"] },
		{ WHIT.."12) "..BZ["Wyrmrest Temple"] },
		{ WHIT.."13) "..BZ["Venomspite"] },
		{ "" },
		{ BLUE..BZ["Howling Fjord"] },
		{ WHIT.."14) "..BZ["Kamagua"] },
		{ WHIT.."15) "..BZ["New Agamand"] },
		{ WHIT.."16) "..BZ["Vengeance Landing"] },
		{ WHIT.."17) "..BZ["Apothecary Camp"] },
		{ WHIT.."18) "..BZ["Camp Winterhoof"] },
		{ "" },
		{ BLUE..BZ["Grizzly Hills"] },
		{ WHIT.."19) "..BZ["Conquest Hold"] },
		{ WHIT.."20) "..BZ["Camp Oneqwah"] },
		{ "" },
		{ BLUE..BZ["Zul'Drak"] },
		{ WHIT.."21) "..BZ["Gundrak"] },
		{ WHIT.."22) "..BZ["Zim'Torga"] },
		{ WHIT.."23) "..BZ["The Argent Stand"] },
		{ WHIT.."24) "..BZ["Light's Breach"] },
		{ WHIT.."25) "..BZ["Ebon Watch"] },
		{ "" },
		{ BLUE..BZ["Crystalsong Forest"] },
		{ WHIT.."26) "..BZ["Sunreaver's Command"] },
		{ WHIT.."27) "..BZ["Dalaran"] },
		{ "" },
		{ BLUE..BZ["The Storm Peaks"] },
		{ WHIT.."28) "..BZ["K3"] },
		{ WHIT.."29) "..BZ["Camp Tunka'lo"] },
		{ WHIT.."30) "..BZ["Grom'arsh Crash-Site"] },
		{ WHIT.."31) "..BZ["Bouldercrag's Refuge"] },
		{ WHIT.."32) "..BZ["Ulduar"] },
		{ WHIT.."33) "..BZ["Dun Niffelem"] },
		{ "" },
		{ BLUE..BZ["Icecrown"] },
		{ WHIT.."34) "..BZ["The Argent Vanguard"] },
		{ WHIT.."35) "..BZ["Crusaders' Pinnacle"] },
		{ WHIT.."36) "..BZ["Argent Tournament Grounds"] },
		{ WHIT.."37) "..BZ["The Shadow Vault"] },
		{ WHIT.."38) "..BZ["Death's Rise"] },
		{ "" },
		{ BLUE..BZ["Wintergrasp"] },
		{ WHIT.."39) "..BZ["Warsong Camp"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Ship / Zeppelin sailing path to destination"] },	
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Borean Tundra", "ac=1264" },
		{ "Explore Crystalsong Forest", "ac=1457" },
		{ "Explore Dragonblight", "ac=1265" },
		{ "Explore Grizzly Hills", "ac=1266" },
		{ "Explore Howling Fjord", "ac=1263" },
		{ "Explore Icecrown", "ac=1270" },
		{ "Explore Sholazar Basin", "ac=1268" },
		{ "Explore Storm Peaks", "ac=1269" },
		{ "Explore Zul'Drak", "ac=1267" },
		{ "Frostbitten", "ac=2257" },
		{ "Higher Learning", "ac=1956" },
		{ "Northrend Explorer", "ac=45" },
		{ "Northern Exposure", "ac=2256" },
		{ LBLU..QUESTS_LABEL },
		{ "D.E.H.T.A's Little P.I.T.A.", "ac=561" },
		{ "Fo' Grizzle My Shizzle", "ac=1357" },
		{ "Guru of Drakuru", "ac=1596" },
		{ "Honorary Frenzyheart", "ac=961" },
		{ "I've Toured the Fjord", "ac=1356" },
		{ "Icecrown: The Final Goal", "ac=40" },
		{ "Into the Basin", "ac=39" },
		{ "Loremaster of Northrend", "ac=41" },
		{ "Might of Dragonblight", "ac=1359" },
		{ "Mine Sweeper", "ac=1428" },
		{ "Nothing Boring About Borean", "ac=1358" },
		{ "Rapid Defense", "ac=1277" },
		{ "Savior of the Oracles", "ac=962" },
		{ "The Empire of Zul'Drak", "ac=36" },
		{ "The Snows of Northrend", "ac=938" },
		{ "The Summit of Storm Peaks", "ac=38" },
		{ "Veteran of the Wrathgate", "ac=547" },
	},
	TransDeepholm = {
		ZoneName = { BZ["Deepholm"] },
		WorldMapID = "640",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Temple of Earth"] },
		{ PURP.." B) "..BZ["Therazane's Throne"] },
		{ PURP.." A') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." B') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Deepholm", "ac=4864" },
		{ "Cataclysm Explorer", "ac=4868" },
		{ LBLU..QUESTS_LABEL },
		{ "Deep into Deepholm", "ac=4871" },
		{ "Fungal Frenzy", "ac=5450" },
		{ "Fungalophobia", "ac=5445" },
		{ "Loremaster of Cataclysm", "ac=4875" },
		{ "My Very Own Broodmother", "ac=5447" },
		{ "Rock Lover", "ac=5449" },
		{ "The Glop Family Line", "ac=5446" },
	},
	TransDarkmoonFaire = {
		ZoneName = { BZ["Darkmoon Island"] },
		WorldMapID = "823",
		{ PURP.." A) "..L["Portals"] },
		{ PURP..INDENT.." -> "..BZ["Elwynn Forest"] },
		{ PURP..INDENT.." -> "..BZ["Mulgore"] },
	},
	TransAlliancePandaria = {
		ZoneName = { BZ["Pandaria"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "862",
		Faction = "Alliance",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Paw'Don Village"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ PURP.." B) "..BZ["Violet Rise"]..ALC["Comma"]..BZ["Isle of Thunder"] },
		{ PURP.." C) "..BZ["Shan'ze Dao"]..ALC["Comma"]..BZ["Townlong Steppes"] },
		{ PURP.." D) "..BZ["The Skyfire"]..ALC["Comma"]..BZ["Krasarang Wilds"] },
		{ PURP.." A') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." B') "..BZ["Ironforge"]..ALC["Comma"]..BZ["Dun Morogh"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." C') "..BZ["Dalaran"]..ALC["Comma"]..BZ["Crystalsong Forest"]..ALC["Comma"]..BZ["Northrend"] },
		{ PURP.." D') "..BZ["The Exodar"]..ALC["Comma"]..BZ["Azuremyst Isle"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." E') "..BZ["Darnassus"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." F') "..BZ["Ratchet"]..ALC["Comma"]..BZ["Northern Barrens"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY..ALC["L-Parenthesis"]..L["Gleep Chatterswitch"]..ALC["R-Parenthesis"] },
		{ PURP.." G') "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"]..ALC["Comma"]..BZ["Outland"] },
		{ "" },
		{ _RED..L["Special transportation"] },
		{ ORNG.." A) "..BZ["The Arboretum"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." B) "..BZ["Thunder Hold"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." C) "..BZ["Strongarm Airstrip"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Slash"]..BZ["Serenity Falls"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." D) "..BZ["Winds' Edge"]..ALC["Comma"]..BZ["Valley of the Four Winds"]..ALC["Slash"]..BZ["The Deepwild"]..ALC["Comma"]..BZ["Krasarang Wilds"] },
		{ INDENT..GREY..L["Rappelling Rope"]..ALC["Slash"]..L["Climbing Rope"] },
		{ ORNG.." E) "..BZ["Whispercloud Rise"]..ALC["Slash"]..BZ["Zouchin Province"]..ALC["Comma"]..BZ["Kun-Lai Summit"] },
		{ INDENT..GREY..L["Whispercloud's Balloon"] },
		{ ORNG.." F) "..BZ["Serpent's Spine"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Slash"]..BZ["Terrace of Gurthan"]..ALC["Comma"]..BZ["Dread Wastes"] },
		{ INDENT..GREY..L["Shado-Pan Rope"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["The Jade Forest"] },
		{ WHIT.." 1) "..BZ["Paw'Don Village"] },
		{ WHIT.." 2) "..BZ["Pearlfin Village"] },
		{ WHIT.." 3) "..BZ["Serpent's Overlook"] },
		{ WHIT.." 4) "..BZ["Jade Temple Grounds"] },
		{ WHIT.." 5) "..BZ["Dawn's Blossom"] },
		{ WHIT.." 6) "..BZ["The Arboretum"] },
		{ WHIT.." 7) "..BZ["Tian Monastery"] },
		{ WHIT.." 8) "..BZ["Emperor's Omen"] },
		{ WHIT.." 9) "..BZ["Sri-La Village"] },
		{ "" },
		{ BLUE..BZ["Valley of the Four Winds"] },
		{ WHIT.."10) "..BZ["Pang's Stead"] },
		{ WHIT.."11) "..BZ["Grassy Cline"] },
		{ WHIT.."12) "..BZ["Halfhill"] },
		{ WHIT.."13) "..BZ["Stoneplow"] },
		{ "" },
		{ BLUE..BZ["Krasarang Wilds"] },
		{ WHIT.."14) "..BZ["Sentinel Basecamp"] },
		{ WHIT.."15) "..BZ["Cradle of Chi-Ji"] },
		{ WHIT.."16) "..BZ["Marista"] },
		{ WHIT.."17) "..BZ["The Incursion"] },
		{ WHIT.."18) "..BZ["Zhu's Watch"] },
		{ WHIT.."19) "..BZ["Lion's Landing"] },
		{ GREY..INDENT..L["Require to complete \"Meet the Scout\" quest line first."] },
		{ "" },
		{ BLUE..BZ["The Veiled Stair"] },
		{ WHIT.."20) "..BZ["Tavern in the Mists"] },
		{ "" },
		{ BLUE..BZ["Kun-Lai Summit"] },
		{ WHIT.."21) "..BZ["Binan Village"] },
		{ WHIT.."22) "..BZ["Westwind Rest"] },
		{ WHIT.."23) "..BZ["Shado-Pan Fallback"] },
		{ WHIT.."24) "..BZ["Kota Basecamp"] },
		{ WHIT.."25) "..BZ["Winter's Blossom"] },
		{ WHIT.."26) "..BZ["One Keg"] },
		{ WHIT.."27) "..BZ["Temple of the White Tiger"] },
		{ WHIT.."28) "..BZ["Zouchin Village"] },
		{ "" },
		{ BLUE..BZ["Townlong Steppes"] },
		{ WHIT.."29) "..BZ["Longying Outpost"] },
		{ WHIT.."30) "..BZ["Gao-Ran Battlefront"] },
		{ WHIT.."31) "..BZ["Rensai's Watchpost"] },
		{ WHIT.."32) "..BZ["Shado-Pan Garrison"] },
		{ "" },
		{ BLUE..BZ["Dread Wastes"] },
		{ WHIT.."33) "..BZ["The Sunset Brewgarden"] },
		{ WHIT.."34) "..BZ["Klaxxi'vess"] },
		{ WHIT.."35) "..BZ["The Lion's Redoubt"] },
		{ WHIT.."36) "..BZ["The Briny Muck"] },
		{ WHIT.."37) "..BZ["Soggy's Gamble"] },
		{ "" },
		{ BLUE..BZ["Vale of Eternal Blossoms"] },
		{ WHIT.."38) "..BZ["Serpent's Spine"] },
		{ WHIT.."39) "..BZ["Shrine of Seven Stars"] },
		{ "" },
		{ BLUE..BZ["Isle of Giants"] },
		{ WHIT.."40) "..BZ["Beeble's Wreck"] },
		{ "" },
		{ BLUE..BZ["Timeless Isle"] },
		{ WHIT.."41) "..BZ["Tushui Landing"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Jade Forest", "ac=6351" },
		{ "Explore Krasarang Wilds", "ac=6975" },
		{ "Explore Kun-Lai Summit", "ac=6976" },
		{ "Explore Townlong Steppes", "ac=6977" },
		{ "Explore Vale of Eternal Blossoms", "ac=6979" },
		{ "Explore Valley of the Four Winds", "ac=6969" },
		{ "Pandaria Explorer", "ac=6974" },
		{ "Extreme Treasure Hunter", "ac=8726" },
		{ "Eyes On The Ground", "ac=8725" },
		{ "Finders Keepers", "ac=7282" },
		{ "Fish Tales", "ac=6846" },
		{ "Fortune of Pandaria", "ac=7995" },
		{ "Glorious!", "ac=7439" },
		{ "Gods and Monsters", "ac=8051" },
		{ "Heart of the Mantid Swarm", "ac=6857" },
		{ "Hozen in the Mist", "ac=6850" },
		{ "I'm In Your Base, Killing Your Dudes", "ac=7932" },
		{ "Is Another Man's Treasure", "ac=7284" },
		{ "Killing Time", "ac=8712" },
		{ "Legend of the Brewfathers", "ac=7230" },
		{ "Legend of the Past", "ac=8723" },
		{ "Lost and Found", "ac=7281" },
		{ "One Man's Trash...", "ac=7283" },
		{ "Pilgrimage", "ac=8724" },
		{ "Restore Balance", "ac=7381" },
		{ "Riches of Pandaria", "ac=7997" },
		{ "Rolo's Riddle", "ac=8730" },
		{ "Rumbles of Thunder", "ac=8050" },
		{ "The Dark Heart of the Mogu", "ac=6754" },
		{ "The Seven Burdens of Shaohao", "ac=6855" },
		{ "The Song of the Yaungol", "ac=6847" },
		{ "The Zandalari Prophecy", "ac=8049" },
		{ "Timeless Champion", "ac=8714" },
		{ "Timeless Legends", "ac=8784" },
		{ "Timeless Nutriment", "ac=8722" },
		{ "Treasure of Pandaria", "ac=7994" },
		{ "Treasure, Treasure Everywhere", "ac=8729" },
		{ "Wanderers, Dreamers, and You", "ac=7518" },
		{ "What Is Worth Fighting For", "ac=6858" },
		{ "Where There's Pirates, There's Booty", "ac=8727" },
		{ "Zarhym Altogether", "ac=8743" },
		{ "Zul'Again", "ac=8078" },
		{ LBLU..QUESTS_LABEL },
		{ "A Taste of History", "ac=7318" },
		{ "A Taste of Things to Come", "ac=7294" },
		{ "Ain't Lost No More", "ac=7296" },
		{ "Amber is the Color of My Energy", "ac=7312" },
		{ "Blue Response", "ac=8112" },
		{ "Boop", "ac=8118" },
		{ "Champion of Chi-Ji", "ac=7287" },
		{ "Collateral Damage", "ac=7323" },
		{ "Defender of Gods", "ac=7310" },
		{ "Direhorn in a China Shop", "ac=8120" },
		{ "Dog Pile", "ac=7320" },
		{ "Dread Haste Makes Dread Waste", "ac=6540" },
		{ "Every Day I'm Pand-a-ren", "ac=7285" },
		{ "Finish Them!", "ac=7286" },
		{ "Fire in the Yaung-hole!", "ac=7309" },
		{ "For the Ward!", "ac=8117" },
		{ "Getting Around with the Shado-Pan", "ac=7298" },
		{ "Green Acres", "ac=7292" },
		{ "How To Strain Your Dragon", "ac=7290" },
		{ "In a Trail of Smoke", "ac=7291" },
		{ "Isle of Thunder", "ac=8099" },
		{ "It Was Worth Every Ritual Stone", "ac=8101" },
		{ "Know Your Role", "ac=7308" },
		{ "Listen to the Drunk Fish", "ac=7295" },
		{ "Loner and a Rebel", "ac=7299" },
		{ "Loremaster of Pandaria", "ac=6541" },
		{ "Mighty Roamin' Krasaranger", "ac=6535" },
		{ "One Many Army", "ac=7317" },
		{ "One Step at a Time", "ac=7324" },
		{ "One Steppe Forward, Two Steppes Back", "ac=6539" },
		{ "Operation: Shieldwall Campaign", "ac=7928" },
		{ "Our Powers Combined", "ac=8119" },
		{ "Over Their Heads", "ac=7316" },
		{ "Pay to Slay", "ac=8100" },
		{ "Platform Hero", "ac=8114" },
		{ "Proven Strength", "ac=7297" },
		{ "Rally the Valley", "ac=6301" },
		{ "Ready for RAAAAIIIIDDD?!?ing", "ac=8107" },
		{ "Ready for Raiding III", "ac=7319" },
		{ "Roll Club", "ac=7322" },
		{ "Savior of Stoneplow", "ac=7502" },
		{ "Shadow Hopper", "ac=7289" },
		{ "Silent Assassin", "ac=7307" },
		{ "Slum It in the Summit", "ac=6537" },
		{ "Speed Metal", "ac=8115" },
		{ "Spreading the Warmth", "ac=7321" },
		{ "Stay Klaxxi", "ac=7313" },
		{ "Stormbreaker", "ac=8121" },
		{ "Test Drive", "ac=7314" },
		{ "The Crumble Bundle", "ac=8105" },
		{ "The Mogu Below-gu", "ac=8109" },
		{ "These Mogu Have Gotta Go-gu", "ac=8110" },
		{ "This Isn't Even My Final Form", "ac=8111" },
		{ "Thunder Plunder", "ac=8104" },
		{ "Till the Break of Dawn", "ac=7293" },
		{ "Upjade Complete", "ac=6300" },
		{ "When in Ihgaluk, Do as the Skumblade Do", "ac=8108" },
		{ "Yak Attack", "ac=7288" },
		{ "You Made Me Bleed My Own Blood", "ac=8116" },
		{ "Zandalari Library Card", "ac=8212" },
	},
	TransHordePandaria = {
		ZoneName = { BZ["Pandaria"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "862",
		Faction = "Horde",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Honeydew Village"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ PURP.." B) "..BZ["Dawnseeker Promontory"]..ALC["Comma"]..BZ["Isle of Thunder"] },
		{ PURP.." C) "..BZ["Shan'ze Dao"]..ALC["Comma"]..BZ["Townlong Steppes"] },
		{ PURP.." D) "..BZ["Sparkrocket Outpost"]..ALC["Comma"]..BZ["Krasarang Wilds"] },
		{ PURP.." E) "..BZ["Ruins of Ogudei"]..ALC["Comma"]..BZ["Krasarang Wilds"] },
		{ PURP.." A') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." B') "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." C') "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"]..ALC["Comma"]..BZ["Outland"] },
		{ PURP.." D') "..BZ["Dalaran"]..ALC["Comma"]..BZ["Crystalsong Forest"]..ALC["Comma"]..BZ["Northrend"] },
		{ PURP.." E') "..BZ["Silvermoon City"]..ALC["Comma"]..BZ["Eversong Woods"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." F') "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ "" },
		{ _RED..L["Special transportation"] },
		{ ORNG.." A) "..BZ["The Arboretum"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." B) "..BZ["Thunder Hold"]..ALC["Comma"]..BZ["The Jade Forest"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." C) "..BZ["Strongarm Airstrip"]..ALC["Comma"]..BZ["The Jade Forest"]..ALC["Slash"]..BZ["Serenity Falls"] },
		{ INDENT..GREY..L["Abandoned Kite"]..ALC["L-Parenthesis"]..L["From sea level to ground level"]..ALC["R-Parenthesis"] },
		{ ORNG.." D) "..BZ["Winds' Edge"]..ALC["Comma"]..BZ["Valley of the Four Winds"]..ALC["Slash"]..BZ["The Deepwild"]..ALC["Comma"]..BZ["Krasarang Wilds"] },
		{ INDENT..GREY..L["Rappelling Rope"]..ALC["Slash"]..L["Climbing Rope"] },
		{ ORNG.." E) "..BZ["Whispercloud Rise"]..ALC["Slash"]..BZ["Zouchin Province"]..ALC["Comma"]..BZ["Kun-Lai Summit"] },
		{ INDENT..GREY..L["Whispercloud's Balloon"] },
		{ ORNG.." F) "..BZ["Serpent's Spine"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Slash"]..BZ["Terrace of Gurthan"]..ALC["Comma"]..BZ["Dread Wastes"] },
		{ INDENT..GREY..L["Shado-Pan Rope"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["The Jade Forest"] },
		{ WHIT.." 1) "..BZ["Honeydew Village"] },
		{ WHIT.." 2) "..BZ["Tian Monastery"] },
		{ WHIT.." 3) "..BZ["Emperor's Omen"] },
		{ WHIT.." 4) "..BZ["Sri-La Village"] },
		{ WHIT.." 5) "..BZ["Dawn's Blossom"] },
		{ WHIT.." 6) "..BZ["The Arboretum"] },
		{ WHIT.." 7) "..BZ["Jade Temple Grounds"] },
		{ WHIT.." 8) "..BZ["Serpent's Overlook"] },
		{ WHIT.." 9) "..BZ["Grookin Hill"] },
		{ "" },
		{ BLUE..BZ["Valley of the Four Winds"] },
		{ WHIT.."10) "..BZ["Pang's Stead"] },
		{ WHIT.."11) "..BZ["Grassy Cline"] },
		{ WHIT.."12) "..BZ["Halfhill"] },
		{ WHIT.."13) "..BZ["Stoneplow"] },
		{ "" },
		{ BLUE..BZ["Krasarang Wilds"] },
		{ WHIT.."14) "..BZ["Dawnchaser Retreat"] },
		{ WHIT.."15) "..BZ["Cradle of Chi-Ji"] },
		{ WHIT.."16) "..BZ["Marista"] },
		{ WHIT.."17) "..BZ["Thunder Cleft"] },
		{ WHIT.."18) "..BZ["Zhu's Watch"] },
		{ WHIT.."19) "..BZ["Domination Point"] },
		{ GREY..INDENT..L["Require to complete \"Meet the Scout\" quest line first."] },
		{ "" },
		{ BLUE..BZ["The Veiled Stair"] },
		{ WHIT.."20) "..BZ["Tavern in the Mists"] },
		{ "" },
		{ BLUE..BZ["Kun-Lai Summit"] },
		{ WHIT.."21) "..BZ["Binan Village"] },
		{ WHIT.."22) "..BZ["Eastwind Rest"] },
		{ WHIT.."23) "..BZ["Shado-Pan Fallback"] },
		{ WHIT.."24) "..BZ["Kota Basecamp"] },
		{ WHIT.."25) "..BZ["Winter's Blossom"] },
		{ WHIT.."26) "..BZ["One Keg"] },
		{ WHIT.."27) "..BZ["Temple of the White Tiger"] },
		{ WHIT.."28) "..BZ["Zouchin Village"] },
		{ WHIT.."29) "..BZ["Serpent's Spine"] },
		{ "" },
		{ BLUE..BZ["Townlong Steppes"] },
		{ WHIT.."30) "..BZ["Longying Outpost"] },
		{ WHIT.."31) "..BZ["Gao-Ran Battlefront"] },
		{ WHIT.."32) "..BZ["Rensai's Watchpost"] },
		{ WHIT.."33) "..BZ["Shado-Pan Garrison"] },
		{ "" },
		{ BLUE..BZ["Dread Wastes"] },
		{ WHIT.."34) "..BZ["The Sunset Brewgarden"] },
		{ WHIT.."35) "..BZ["Klaxxi'vess"] },
		{ WHIT.."36) "..BZ["The Briny Muck"] },
		{ WHIT.."37) "..BZ["Soggy's Gamble"] },
		{ "" },
		{ BLUE..BZ["Vale of Eternal Blossoms"] },
		{ WHIT.."38) "..BZ["Serpent's Spine"] },    
		{ WHIT.."39) "..BZ["Shrine of Two Moons"] },
		{ "" },
		{ BLUE..BZ["Isle of Giants"] },
		{ WHIT.."40) "..BZ["Bozzle's Wreck"] },
		{ "" },
		{ BLUE..BZ["Timeless Isle"] },
		{ WHIT.."41) "..BZ["Huojin Landing"] },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Jade Forest", "ac=6351" },
		{ "Explore Krasarang Wilds", "ac=6975" },
		{ "Explore Kun-Lai Summit", "ac=6976" },
		{ "Explore Townlong Steppes", "ac=6977" },
		{ "Explore Vale of Eternal Blossoms", "ac=6979" },
		{ "Explore Valley of the Four Winds", "ac=6969" },
		{ "Extreme Treasure Hunter", "ac=8726" },
		{ "Pandaria Explorer", "ac=6974" },
		{ "Eyes On The Ground", "ac=8725" },
		{ "Finders Keepers", "ac=7282" },
		{ "Fish Tales", "ac=6846" },
		{ "Fortune of Pandaria", "ac=7995" },
		{ "Glorious!", "ac=7439" },
		{ "Gods and Monsters", "ac=8051" },
		{ "Heart of the Mantid Swarm", "ac=6857" },
		{ "Hozen in the Mist", "ac=6850" },
		{ "I'm In Your Base, Killing Your Dudes", "ac=7932" },
		{ "Is Another Man's Treasure", "ac=7284" },
		{ "Killing Time", "ac=8712" },
		{ "Legend of the Brewfathers", "ac=7230" },
		{ "Legend of the Past", "ac=8723" },
		{ "Lost and Found", "ac=7281" },
		{ "One Man's Trash...", "ac=7283" },
		{ "Pilgrimage", "ac=8724" },
		{ "Restore Balance", "ac=7381" },
		{ "Riches of Pandaria", "ac=7997" },
		{ "Rolo's Riddle", "ac=8730" },
		{ "Rumbles of Thunder", "ac=8050" },
		{ "The Dark Heart of the Mogu", "ac=6754" },
		{ "The Seven Burdens of Shaohao", "ac=6855" },
		{ "The Song of the Yaungol", "ac=6847" },
		{ "The Zandalari Prophecy", "ac=8049" },
		{ "Timeless Champion", "ac=8714" },
		{ "Timeless Legends", "ac=8784" },
		{ "Timeless Nutriment", "ac=8722" },
		{ "Treasure of Pandaria", "ac=7994" },
		{ "Treasure, Treasure Everywhere", "ac=8729" },
		{ "Wanderers, Dreamers, and You", "ac=7518" },
		{ "What Is Worth Fighting For", "ac=6858" },
		{ "Where There's Pirates, There's Booty", "ac=8727" },
		{ "Zarhym Altogether", "ac=8743" },
		{ "Zul'Again", "ac=8078" },
		{ LBLU..QUESTS_LABEL },
		{ "A Taste of History", "ac=7318" },
		{ "A Taste of Things to Come", "ac=7294" },
		{ "Ain't Lost No More", "ac=7296" },
		{ "Amber is the Color of My Energy", "ac=7312" },
		{ "Blue Response", "ac=8112" },
		{ "Boop", "ac=8118" },
		{ "Champion of Chi-Ji", "ac=7287" },
		{ "Collateral Damage", "ac=7323" },
		{ "Defender of Gods", "ac=7310" },
		{ "Direhorn in a China Shop", "ac=8120" },
		{ "Dog Pile", "ac=7320" },
		{ "Dominance Offensive Campaign", "ac=7929" },
		{ "Dread Haste Makes Dread Waste", "ac=6540" },
		{ "Every Day I'm Pand-a-ren", "ac=7285" },
		{ "Finish Them!", "ac=7286" },
		{ "Fire in the Yaung-hole!", "ac=7309" },
		{ "For the Ward!", "ac=8117" },
		{ "Getting Around with the Shado-Pan", "ac=7298" },
		{ "Green Acres", "ac=7292" },
		{ "How To Strain Your Dragon", "ac=7290" },
		{ "In a Trail of Smoke", "ac=7291" },
		{ "Isle of Thunder", "ac=8099" },
		{ "It Was Worth Every Ritual Stone", "ac=8101" },
		{ "Know Your Role", "ac=7308" },
		{ "Listen to the Drunk Fish", "ac=7295" },
		{ "Loner and a Rebel", "ac=7299" },
		{ "Loremaster of Pandaria", "ac=6541" },
		{ "Mighty Roamin' Krasaranger", "ac=6536" },
		{ "One Many Army", "ac=7317" },
		{ "One Step at a Time", "ac=7324" },
		{ "One Steppe Forward, Two Steppes Back", "ac=6539" },
		{ "Our Powers Combined", "ac=8119" },
		{ "Over Their Heads", "ac=7316" },
		{ "Pay to Slay", "ac=8100" },
		{ "Platform Hero", "ac=8114" },
		{ "Proven Strength", "ac=7297" },
		{ "Rally the Valley", "ac=6301" },
		{ "Ready for RAAAAIIIIDDD?!?ing", "ac=8107" },
		{ "Ready for Raiding III", "ac=7319" },
		{ "Roll Club", "ac=7322" },
		{ "Savior of Stoneplow", "ac=7502" },
		{ "Shadow Hopper", "ac=7289" },
		{ "Silent Assassin", "ac=7307" },
		{ "Slum It in the Summit", "ac=6538" },
		{ "Speed Metal", "ac=8115" },
		{ "Spreading the Warmth", "ac=7321" },
		{ "Stay Klaxxi", "ac=7313" },
		{ "Stormbreaker", "ac=8121" },
		{ "Test Drive", "ac=7314" },
		{ "The Crumble Bundle", "ac=8105" },
		{ "The Mogu Below-gu", "ac=8109" },
		{ "These Mogu Have Gotta Go-gu", "ac=8110" },
		{ "This Isn't Even My Final Form", "ac=8111" },
		{ "Thunder Plunder", "ac=8104" },
		{ "Till the Break of Dawn", "ac=7293" },
		{ "Upjade Complete", "ac=6534" },
		{ "When in Ihgaluk, Do as the Skumblade Do", "ac=8108" },
		{ "Yak Attack", "ac=7288" },
		{ "You Made Me Bleed My Own Blood", "ac=8116" },
		{ "Zandalari Library Card", "ac=8212" },
	},
	TransAllianceDraenor = {
		ZoneName = { BZ["Draenor"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "962",
		Faction = "Alliance",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Khadgar's Tower"]..ALC["Comma"]..BZ["Talador"], 10052 },
		{ PURP.." A') "..BZ["Darnassus"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"], 10053 },
		{ PURP.." B') "..BZ["Ironforge"]..ALC["Comma"]..BZ["Dun Morogh"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10054 },
		{ PURP.." C') "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10055 },
		{ NUTL.."19) "..BZ["Zangarra"]..ALC["Comma"]..BZ["Talador"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Shadowmoon Valley"] },
		{ ALAN.." 1) "..BZ["Lunarfall"], 10001 },
		{ NUTL.." 2) "..BZ["Exile's Rise"], 10002 },
		{ ALAN.." 3) "..BZ["Embaari Village"], 10003 },
		{ ALAN.." 4) "..BZ["Path of Light"], 10004 },
		{ ALAN.." 5) "..BZ["Elodor"], 10005 },
		{ ALAN.." 6) "..BZ["Tranquil Court"], 10006 },
		{ ALAN.." 7) "..BZ["The Draakorium"], 10007 },
		{ ALAN.." 8) "..BZ["Twilight Glade"], 10008 },
		{ NUTL.." 9) "..BZ["Socrethar's Rise"], 10009 },
		{ NUTL.."10) "..BZ["Darktide Roost"], 10010 },
		{ NUTL.."11) "..BZ["Akeeta's Hovel"], 10011 },
		{ "" },
		{ BLUE..BZ["Talador"] },
		{ ALAN.."12) "..BZ["Anchorite's Sojourn"], 10012 },
		{ NUTL.."13) "..BZ["Terokkar Refuge"], 10013 },
		{ ALAN.."14) "..BZ["Exarch's Refuge"], 10014 },
		{ NUTL.."15) "..BZ["Retribution Point"], 10015 },
		{ NUTL.."16) "..BZ["Shattrath City"], 10016 },
		{ ALAN.."17) "..BZ["Redemption Rise"], 10017 },
		{ ALAN.."18) "..BZ["Fort Wrynn"], 10018 },
		{ NUTL.."19) "..BZ["Zangarra"], 10019 },
		{ "" },
		{ BLUE..BZ["Gorgrond"] },
		{ ALAN.."20) "..BZ["Bastion Rise"], 10020 },
		{ ALAN.."21) "..BZ["Deeproot"], 10021 },
		{ ALAN.."22) "..BZ["Highpass"], 10022 },
		{ ALAN.."23) "..BZ["Wildwood Wash"], 10023 },
		{ NUTL.."24) "..BZ["Everbloom Wilds"], 10024 },
		{ NUTL.."25) "..BZ["Everbloom Overlook"], 10025 },
		{ NUTL.."26) "..BZ["Breaker's Crown"], 10026 },
		{ NUTL.."27) "..BZ["Skysea Point"], 10027 },
		{ NUTL.."28) "..BZ["Iron Docks"], 10028 },
		{ "" },
		{ BLUE..BZ["Spires of Arak"] },
		{ NUTL.."29) "..BZ["Apexis Excavation"], 10029 },
		{ ALAN.."30) "..BZ["Southport"], 10030 },
		{ NUTL.."31) "..BZ["Veil Terokk"], 10031 },
		{ NUTL.."32) "..BZ["Crow's Crook"], 10032 },
		{ NUTL.."33) "..BZ["Talon Watch"], 10033 },
		{ NUTL.."34) "..BZ["Pinchwhistle Gearworks"], 10034 },
		{ "" },
		{ BLUE..BZ["Nagrand"] },
		{ NUTL.."35) "..BZ["The Ring of Trials"], 10035 },
		{ ALAN.."36) "..BZ["Telaari Station"], 10036 },
		{ NUTL.."37) "..BZ["Nivek's Overlook"], 10037 },
		{ ALAN.."38) "..BZ["Yrel's Watch"], 10038 },
		{ NUTL.."39) "..BZ["Rilzit's Holdfast"], 10039 },
		{ NUTL.."40) "..BZ["Joz's Rylaks"], 10040 },
		{ NUTL.."41) "..BZ["Throne of the Elements"], 10041 },
		{ "" },
		{ BLUE..BZ["Frostfire Ridge"] },
		{ ALAN.."42) "..BZ["Iron Siegeworks"], 10042 },
		{ NUTL.."43) "..BZ["Bloodmaul Slag Mines"], 10043 },
		{ "" },
		{ BLUE..BZ["Ashran"] },
		{ ALAN.."44) "..BZ["Stormshield"], 10044 },
		{ "" },
		{ BLUE..BZ["Tanaan Jungle"] },
		{ ALAN.."45) "..BZ["The Iron Front"], 10045 },
		{ NUTL.."46) "..BZ["Sha'naari Refuge"], 10046 },
		{ NUTL.."47) "..BZ["Malo's Lookout"], 10047 },
		{ ALAN.."48) "..BZ["Lion's Watch"], 10048 },
		{ NUTL.."49) "..BZ["Aktar's Post"], 10049 },
		{ NUTL.."50) "..BZ["Vault of the Earth"], 10050 },
		{ NUTL.."51) "..BZ["Throne of Kil'jaeden"], 10051 },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP..L["Purple"]..ALC["Colon"]..L["Portals"] },
		{ NUTL..L["Yellow"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Nutral"] },
		{ ALAN..L["Blue"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..FACTION_ALLIANCE },
		{ WHIT..L["White"]..ALC["Colon"]..L["Special transportation"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Airship"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Frostfire Ridge", "ac=8937" },
		{ "Explore Gorgrond", "ac=8939" },
		{ "Explore Nagrand", "ac=8942" },
		{ "Explore Shadowmoon Valley", "ac=8938" },
		{ "Explore Spires of Arak", "ac=8941" },
		{ "Explore Talador", "ac=8940" },
		{ "Explore Tanaan Jungle", "ac=10260" },
		{ "Draenor Explorer", "ac=8935" },
		{ "Draenor Pathfinder", "ac=10018" },
		{ "Expert Treasure Hunter", "ac=9727" },
		{ "Gorgrond Monster Hunter", "ac=9400" },
		{ "Grand Treasure Hunter", "ac=9728" },
		{ "Hellbane", "ac=10061" },
		{ "I Came, I Clawed, I Conquered", "ac=10069" },
		{ "Jungle Hunter", "ac=10259" },
		{ "Jungle Stalker", "ac=10070" },
		{ "Jungle Treasure Hunter", "ac=10261" },
		{ "Jungle Treasure Master", "ac=10262" },
		{ "Master Treasure Hunter", "ac=10348" },
		{ "Prove Your Strength", "ac=9402" },
		{ "Shredder Maniac", "ac=9401" },
		{ "Treasure Hunter", "ac=9726" },
		{ LBLU..QUESTS_LABEL },
		{ "A Demidos of Reality", "ac=9437" },
		{ "A-VOID-ance", "ac=9433" },
		{ "Ancient No More", "ac=9678" },
		{ "Arak Star", "ac=9605" },
		{ "As I Walk Through the Valley of the Shadow of Moon", "ac=8845" },
		{ "Between Arak and a Hard Place", "ac=8925" },
		{ "Bobbing for Orcs", "ac=9635" },
		{ "Breaker of Chains", "ac=9533" },
		{ "Broke Back Precipice", "ac=9571" },
		{ "Buried Treasures", "ac=9548" },
		{ "Burn It to the Ground", "ac=9667" },
		{ "By Fire Be... Merged?", "ac=9537" },
		{ "Chapter I: Call of the Archmage", "ac=9640" },
		{ "Chapter II: Gul'dan Strikes Back", "ac=9641" },
		{ "Chapter III: The Foundry Falls", "ac=9642" },
		{ "Chapter IV: Darkness Incarnate", "ac=10021" },
		{ "Charged Up", "ac=9634" },
		{ "Cut off the Head", "ac=9633" },
		{ "Delectable Ogre Delicacies", "ac=9534" },
		{ "Don't Let the Tala-door Hit You on the Way Out", "ac=8920" },
		{ "Draenor's Last Stand", "ac=10068" },
		{ "Eggs in One Basket", "ac=9612" },
		{ "Fight the Power", "ac=9655" },
		{ "Fish Gotta Swim, Birds Gotta Eat", "ac=9613" },
		{ "Goodness Gracious", "ac=9486" },
		{ "Heralds of the Legion", "ac=9638" },
		{ "History of Violence", "ac=9610" },
		{ "I Want More Talador", "ac=9674" },
		{ "I Was Framed!", "ac=9483" },
		{ "In Plain Sight", "ac=9656" },
		{ "In Pursuit of Gul'dan", "ac=10067" },
		{ "Iron Wings", "ac=9659" },
		{ "It's the Stones!", "ac=9436" },
		{ "King of the Monsters", "ac=9601" },
		{ "Loremaster of Draenor", "ac=9833" },
		{ "Make It a Bonus", "ac=9607" },
		{ "Making the Cut", "ac=9617" },
		{ "Master Relic Hunter", "ac=9825" },
		{ "Mean and Green", "ac=9654" },
		{ "Monster Mash", "ac=9600" },
		{ "Nagrandeur", "ac=8927" },
		{ "On the Shadow's Trail", "ac=9528" },
		{ "One of Us! One of Us!", "ac=9434" },
		{ "Picky Palate", "ac=9663" },
		{ "Pillars of Draenor", "ac=9658" },
		{ "Planned to Fail", "ac=9711" },
		{ "Poisoning the Well", "ac=9710" },
		{ "Poor Communication", "ac=9637" },
		{ "Putting the Gore in Gorgrond", "ac=8923" },
		{ "Rumble in the Jungle", "ac=10072" },
		{ "Securing Draenor", "ac=9564" },
		{ "Shoot For the Moon", "ac=9602" },
		{ "Slagnarok", "ac=9536" },
		{ "Take From Them Everything", "ac=9435" },
		{ "That Was Entirely Unnecessary", "ac=9535" },
		{ "The Garrison Campaign", "ac=9491" },
		{ "The Power Is Yours", "ac=9632" },
		{ "The Song of Silence", "ac=9541" },
		{ "United We Stand", "ac=9636" },
		{ "Welcome to Draenor", "ac=8921" },
		{ "With a Nagrand Cherry On Top", "ac=9615" },
		{ "Would You Like a Pamphlet?", "ac=9432" },
		{ "Writing in the Snow", "ac=9530" },
		{ "You Can't Make a Giant Omelette...", "ac=9479" },
		{ "You Have Been Rylakinated!", "ac=9481" },
	},
	TransHordeDraenor = {
		ZoneName = { BZ["Draenor"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "962",
		Faction = "Horde",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Khadgar's Tower"]..ALC["Comma"]..BZ["Talador"], 10051 },
		{ PURP.." A') "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"], 10052 },
		{ PURP.." B') "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"]..ALC["Comma"]..BZ["Kalimdor"], 10053 },
		{ PURP.." C') "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10054 },
		{ NUTL.."18) "..BZ["Zangarra"]..ALC["Comma"]..BZ["Talador"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Frostfire Ridge"] },
		{ HRDE.." 1) "..BZ["Frostwall Garrison"], 10001 },
		{ HRDE.." 2) "..BZ["Wor'gol"], 10002 },
		{ HRDE.." 3) "..BZ["Bladespire Fortress"], 10003 },
		{ HRDE.." 4) "..BZ["Stonefang Outpost"], 10004 },
		{ HRDE.." 5) "..BZ["Throm'Var"], 10005 },
		{ HRDE.." 6) "..BZ["Darkspear's Edge"], 10006 },
		{ NUTL.." 7) "..BZ["Bloodmaul Slag Mines"], 10007 },
		{ HRDE.." 8) "..BZ["Wolf's Stand"], 10008 },
		{ HRDE.." 9) "..BZ["Thunder Pass"], 10009 },
		{ "" },
		{ BLUE..BZ["Gorgrond"] },
		{ HRDE.."10) "..BZ["Evermorn Springs"], 10010 },
		{ HRDE.."11) "..BZ["Bastion Rise"], 10011 },
		{ HRDE.."12) "..BZ["Beastwatch"], 10012 },
		{ NUTL.."13) "..BZ["Breaker's Crown"], 10013 },
		{ NUTL.."14) "..BZ["Skysea Point"], 10014 },
		{ NUTL.."15) "..BZ["Iron Docks"], 10015 },
		{ NUTL.."16) "..BZ["Everbloom Wilds"], 10016 },
		{ NUTL.."17) "..BZ["Everbloom Overlook"], 10017 },
		{ "" },
		{ BLUE..BZ["Talador"] },
		{ NUTL.."18) "..BZ["Zangarra"], 10018 },
		{ HRDE.."19) "..BZ["Vol'jin's Pride"], 10019 },
		{ HRDE.."20) "..BZ["Frostwolf Overlook"], 10020 },
		{ HRDE.."21) "..BZ["Durotan's Grasp"], 10021 },
		{ NUTL.."22) "..BZ["Shattrath City"], 10022 },
		{ NUTL.."23) "..BZ["Terokkar Refuge"], 10023 },
		{ HRDE.."24) "..BZ["Exarch's Refuge"], 10024 },
		{ NUTL.."25) "..BZ["Retribution Point"], 10025 },
		{ "" },
		{ BLUE..BZ["Spires of Arak"] },
		{ NUTL.."26) "..BZ["Apexis Excavation"], 10026 },
		{ NUTL.."27) "..BZ["Crow's Crook"], 10027 },
		{ HRDE.."28) "..BZ["Axefall"], 10028 },
		{ NUTL.."29) "..BZ["Veil Terokk"], 10029 },
		{ NUTL.."30) "..BZ["Talon Watch"], 10030 },
		{ NUTL.."31) "..BZ["Pinchwhistle Gearworks"], 10031 },
		{ "" },
		{ BLUE..BZ["Nagrand"] },
		{ NUTL.."32) "..BZ["Wor'var"], 10032 },
		{ HRDE.."33) "..BZ["The Ring of Trials"], 10033 },
		{ NUTL.."34) "..BZ["Throne of the Elements"], 10034 },
		{ NUTL.."35) "..BZ["Joz's Rylaks"], 10035 },
		{ NUTL.."36) "..BZ["Rilzit's Holdfast"], 10036 },
		{ HRDE.."37) "..BZ["Riverside Post"], 10037 },
		{ NUTL.."38) "..BZ["Nivek's Overlook"], 10038 },
		{ "" },
		{ BLUE..BZ["Shadowmoon Valley"] },
		{ NUTL.."39) "..BZ["Akeeta's Hovel"], 10039 },
		{ NUTL.."40) "..BZ["Exile's Rise"], 10040 },
		{ NUTL.."41) "..BZ["Socrethar's Rise"], 10041 },
		{ NUTL.."42) "..BZ["Darktide Roost"], 10042 },
		{ "" },
		{ BLUE..BZ["Ashran"] },
		{ HRDE.."43) "..BZ["Warspear"], 10043 },
		{ "" },
		{ BLUE..BZ["Tanaan Jungle"] },
		{ HRDE.."44) "..BZ["The Iron Front"], 10044 },
		{ NUTL.."45) "..BZ["Sha'naari Refuge"], 10045 },
		{ NUTL.."46) "..BZ["Vault of the Earth"], 10046 },
		{ HRDE.."47) "..BZ["Vol'mar"], 10047 },
		{ NUTL.."48) "..BZ["Aktar's Post"], 10048 },
		{ NUTL.."49) "..BZ["Malo's Lookout"], 10049 },
		{ WHIT.."50) "..BZ["Throne of Kil'jaeden"], 10050 },
		{ "" },
		{ PURP..L["Purple"]..ALC["Colon"]..L["Portals"] },
		{ NUTL..L["Yellow"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Nutral"] },
		{ HRDE..L["Red"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..FACTION_HORDE },
		{ WHIT..L["White"]..ALC["Colon"]..L["Special transportation"] },
		{ PURP.."-- : "..L["Portal / Waygate Path to the destination"] },
		{ CYAN.."-- : "..L["Airship"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Frostfire Ridge", "ac=8937" },
		{ "Explore Gorgrond", "ac=8939" },
		{ "Explore Nagrand", "ac=8942" },
		{ "Explore Shadowmoon Valley", "ac=8938" },
		{ "Explore Spires of Arak", "ac=8941" },
		{ "Explore Talador", "ac=8940" },
		{ "Explore Tanaan Jungle", "ac=10260" },
		{ "Draenor Explorer", "ac=8935" },
		{ "Draenor Pathfinder", "ac=10018" },
		{ "Expert Treasure Hunter", "ac=9727" },
		{ "Gorgrond Monster Hunter", "ac=9400" },
		{ "Grand Treasure Hunter", "ac=9728" },
		{ "Hellbane", "ac=10061" },
		{ "I Came, I Clawed, I Conquered", "ac=10069" },
		{ "Jungle Hunter", "ac=10259" },
		{ "Jungle Stalker", "ac=10070" },
		{ "Jungle Treasure Hunter", "ac=10261" },
		{ "Jungle Treasure Master", "ac=10262" },
		{ "Master Treasure Hunter", "ac=10348" },
		{ "Prove Your Strength", "ac=9402" },
		{ "Shredder Maniac", "ac=9401" },
		{ "Treasure Hunter", "ac=9726" },
		{ LBLU..QUESTS_LABEL },
		{ "A Demidos of Reality", "ac=9437" },
		{ "A-VOID-ance", "ac=9433" },
		{ "Ancient No More", "ac=9678" },
		{ "Arak Star", "ac=9605" },
		{ "Between Arak and a Hard Place", "ac=8926" },
		{ "Bobbing for Orcs", "ac=9635" },
		{ "Breaker of Chains", "ac=9533" },
		{ "Broke Back Precipice", "ac=9571" },
		{ "Buried Treasures", "ac=9548" },
		{ "Burn It to the Ground", "ac=9667" },
		{ "By Fire Be... Merged?", "ac=9537" },
		{ "Chapter I: Call of the Archmage", "ac=9640" },
		{ "Chapter II: Gul'dan Strikes Back", "ac=9641" },
		{ "Chapter III: The Foundry Falls", "ac=9642" },
		{ "Chapter IV: Darkness Incarnate", "ac=10148" },
		{ "Charged Up", "ac=9634" },
		{ "Cut off the Head", "ac=9633" },
		{ "Delectable Ogre Delicacies", "ac=9534" },
		{ "Don't Let the Tala-door Hit You on the Way Out", "ac=8919" },
		{ "Draenor's Last Stand", "ac=10075" },
		{ "Eggs in One Basket", "ac=9612" },
		{ "Fight the Power", "ac=9655" },
		{ "Fish Gotta Swim, Birds Gotta Eat", "ac=9613" },
		{ "Frostfire Fridge", "ac=9606" },
		{ "Goodness Gracious", "ac=9486" },
		{ "Heralds of the Legion", "ac=9638" },
		{ "History of Violence", "ac=9610" },
		{ "I Want More Talador", "ac=9674" },
		{ "I Was Framed!", "ac=9483" },
		{ "In Plain Sight", "ac=9656" },
		{ "In Pursuit of Gul'dan", "ac=10074" },
		{ "Iron Wings", "ac=9659" },
		{ "It's the Stones!", "ac=9436" },
		{ "King of the Monsters", "ac=9601" },
		{ "Loremaster of Draenor", "ac=9923" },
		{ "Make It a Bonus", "ac=9607" },
		{ "Making the Cut", "ac=9617" },
		{ "Master Relic Hunter", "ac=9836" },
		{ "Mean and Green", "ac=9654" },
		{ "Monster Mash", "ac=9600" },
		{ "Nagrandeur", "ac=8928" },
		{ "On the Shadow's Trail", "ac=9529" },
		{ "One of Us! One of Us!", "ac=9434" },
		{ "Picky Palate", "ac=9663" },
		{ "Pillars of Draenor", "ac=9658" },
		{ "Planned to Fail", "ac=9711" },
		{ "Poisoning the Well", "ac=9710" },
		{ "Poor Communication", "ac=9637" },
		{ "Putting the Gore in Gorgrond", "ac=8924" },
		{ "Rumble in the Jungle", "ac=10265" },
		{ "Securing Draenor", "ac=9562" },
		{ "Slagnarok", "ac=9536" },
		{ "Take From Them Everything", "ac=9435" },
		{ "That Was Entirely Unnecessary", "ac=9535" },
		{ "The Garrison Campaign", "ac=9492" },
		{ "The Power Is Yours", "ac=9632" },
		{ "The Song of Silence", "ac=9541" },
		{ "United We Stand", "ac=9636" },
		{ "Welcome to Draenor", "ac=8922" },
		{ "With a Nagrand Cherry On Top", "ac=9615" },
		{ "Would You Like a Pamphlet?", "ac=9432" },
		{ "Writing in the Snow", "ac=9531" },
		{ "You Can't Make a Giant Omelette...", "ac=9479" },
		{ "You Have Been Rylakinated!", "ac=9481" },
		{ "You'll Get Caught Up In The... Frostfire!", "ac=8671" },
	},
	TransAllianceAshran = {
		ZoneName = { BZ["Ashran"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "1009",
		Faction = "Alliance",
		{ _RED..L["Taxi Nodes"] },
		{ WHIT.." A) "..BZ["Stormshield"], 10001 },
		{ "" },
		{ _RED..L["Portals"] },
		{ PURP.." B) "..BZ["Lion's Watch"], 10002 },
		{ PURP.." C) "..BZ["Ironforge"], 10003 },
		{ PURP.." D) "..BZ["Stormwind City"], 10004 },
		{ PURP.." E) "..BZ["Darnassus"], 10005 },
	},
	TransHordeAshran = {
		ZoneName = { BZ["Ashran"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "1011",
		Faction = "Horde",
		{ _RED..L["Taxi Nodes"] },
		{ WHIT.." A) "..BZ["Warspear"], 10001 },
		{ "" },
		{ _RED..L["Portals"] },
		{ PURP.." B) "..BZ["Vol'mar"], 10002 },
		{ PURP.." C) "..BZ["Thunder Bluff"], 10003 },
		{ PURP.." D) "..BZ["Undercity"], 10004 },
		{ PURP.." E) "..BZ["Orgrimmar"], 10005 },
	},
	TransAllianceBrokenIsles = {
		ZoneName = { BZ["Broken Isles"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"] },
		WorldMapID = "1007",
		Faction = "Alliance",
		LargeMap = "TransAllianceBrokenIsles",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Greyfang Enclave"], 10040 },
		{ INDENT..GREY.."  -> "..BZ["Ironforge"]..ALC["Comma"]..BZ["Dun Morogh"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.." <-> "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.."  -> "..BZ["Shrine of Seven Stars"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Comma"]..BZ["Pandaria"] },
		{ INDENT..GREY.."  -> "..BZ["The Exodar"]..ALC["Comma"]..BZ["Azuremyst Isle"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Darnassus"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ PURP.." B) "..BZ["Chamber of the Guardian"], 10041 },
		{ INDENT..GREY.."  -> "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"]..ALC["Comma"]..BZ["Outland"] },
		{ INDENT..GREY.."  -> "..BZ["Wyrmrest Temple"]..ALC["Comma"]..BZ["Dragonblight"]..ALC["Comma"]..BZ["Northrend"] },
		{ INDENT..GREY.."  -> "..BZ["Dalaran Crater"]..ALC["Comma"]..BZ["Hillsbrad Foothills"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..INDENT.._RED..ALC["L-Parenthesis"]..L["Warning: Drop"]..ALC["R-Parenthesis"] },
		{ INDENT..GREY.."  -> "..BZ["Karazhan"]..ALC["Comma"]..BZ["Deadwind Pass"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." C) "..format(ALC["Portal to %s"], BZ["Dalaran"])..GREY.." (30.1, 40.7)", 10042 },
		{ NUTL.."37) "..BZ["Deliverance Point"]..ALC["Hyphen"].._G["BROKENSHORE_BUILDING_MAGETOWER"]..GREY.." (46.3, 61.9)" },
		{ INDENT..GREY.."  -> "..BZ["Meredil"]..ALC["Comma"]..BZ["Suramar"] },
		{ INDENT..GREY.."  -> "..BZ["Valdisdall"]..ALC["Comma"]..BZ["Stormheim"] },
		{ INDENT..GREY.."  -> "..BZ["Lorlathil"]..ALC["Comma"]..BZ["Val'sharah"] },
		{ INDENT..GREY.."  -> "..BZ["Crumbled Palace"]..ALC["Comma"]..BZ["Azsuna"] },
		{ INDENT..GREY.."  -> "..BZ["Thunder Totem"]..ALC["Comma"]..BZ["Highmountain"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Dalaran"] },
		{ NUTL.." 1) "..BZ["Krasus' Landing"]..GREY.." (69.8, 51.1)", 10001 },
		{ "" },
		{ BLUE..BZ["Azsuna"] },
		{ NUTL.." 2) "..BZ["Watchers' Aerie"]..GREY.." (51.8, 82.1)", 10002 },
		{ NUTL.." 3) "..BZ["Wardens' Redoubt"]..GREY.." (48.2, 73.8)", 10003 },
		{ NUTL.." 4) "..BZ["Shackle's Den"]..GREY.." (56.2, 58.9)", 10004 },
		{ NUTL.." 5) "..BZ["Illidari Stand"]..GREY.." (44.6, 43.8)", 10005 },
		{ NUTL.." 6) "..BZ["Illidari Perch"]..GREY.." (31.8, 46.3)", 10006 },
		{ NUTL.." 7) "..BZ["Felblaze Ingress"]..GREY.." (63.8, 28.5)", 10007 },
		{ NUTL.." 8) "..BZ["Azurewing Repose"]..GREY.." (48.4, 28.0)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10008 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (47.6, 28.1)" },
		{ NUTL.." 9) "..BZ["Challiane's Terrace"]..GREY.." (40.8, 9.0)", 10009 },
		{ NUTL.."10) "..BZ["Eye of Azshara"]..GREY.." (38.3, 46.1)", 10010 },
		{ "" },
		{ BLUE..BZ["Val'sharah"] },
		{ NUTL.."11) "..BZ["Lorlathil"]..GREY.." (55.0, 72.5)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10011 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (54.7, 74.9)" },
		{ NUTL.."12) "..BZ["Gloaming Reef"]..GREY.." (25.9, 66.5)", 10012 },
		{ NUTL.."13) "..BZ["Bradensbrook"]..GREY.." (42.2, 58.5)", 10013 },
		{ NUTL.."14) "..BZ["Garden of the Moon"]..GREY.." (56.7, 57.7)", 10014 },
		{ NUTL.."15) "..BZ["Starsong Refuge"]..GREY.." (69.0, 50.8)", 10015 },
		{ GREN.." 1) "..BZ["The Dreamgrove"]..CL["DRUID"]..ALC["L-Parenthesis"]..L["Druid Only"]..ALC["R-Parenthesis"]..GREY.." (61.7, 33.9)", 10100 },
		{ "" },
		{ BLUE..BZ["Highmountain"] },
		{ NUTL.."16) "..BZ["Obsidian Overlook"]..GREY.." (47.3, 84.6)", 10016 },
		{ NUTL.."17) "..BZ["Ironhorn Enclave"]..GREY.." (56.8, 83.9)", 10017 },
		{ NUTL.."18) "..BZ["Sylvan Falls"]..GREY.." (35.9, 65.9)", 10018 },
		{ NUTL.."19) "..BZ["Thunder Totem"]..GREY.." (44.9, 38.7)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10019 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (39.8, 42.2)" },
		{ NUTL.."20) "..BZ["Stonehoof Watch"]..GREY.." (59.2, 65.1)", 10020 },
		{ NUTL.."21) "..BZ["Nesingwary"]..GREY.." (40.2, 52.7)", 10021 },
		{ NUTL.."22) "..BZ["Skyhorn"]..GREY.." (52.6, 45.2)", 10022 },
		{ NUTL.."23) "..BZ["Felbane Camp"]..GREY.." (29.9, 39.3)", 10023 },
		{ NUTL.."24) "..BZ["The Witchwood"]..GREY.." (38.3, 39.3)", 10024 },
		{ NUTL.."25) "..BZ["Prepfoot"]..GREY.." (58.0, 28.6)", 10025 },
		{ NUTL.."26) "..BZ["Shipwreck Cove"]..GREY.." (41.9, 10.4)", 10026 },
		{ GREN.." 2) "..BZ["Trueshot Lodge"]..CL["HUNTER"]..ALC["L-Parenthesis"]..L["Hunter Only"]..ALC["R-Parenthesis"]..GREY.." (35.7, 27.5)", 10101 },
		{ "" },
		{ BLUE..BZ["Stormheim"] },
		{ ALAN.."27) "..BZ["Skyfire Triage Camp"]..GREY.." (33.6, 50.6)", 10027 },
		{ ALAN.."28) "..BZ["Lorna's Watch"]..GREY.." (37.4, 64.0)", 10028 },
		{ NUTL.."29) "..BZ["Stormtorn Foothills"]..GREY.." (52.0, 34.8)", 10029 },
		{ NUTL.."30) "..BZ["Valdisdall"]..GREY.." (60.7, 50.9)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10030 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (60.2, 52.2)" },
		{ ALAN.."31) "..BZ["Greywatch"]..GREY.." (72.2, 59.8)", 10031 },
		{ NUTL.."32) "..BZ["Shield's Rest"]..GREY.." (89.8, 10.7)", 10032 },
		{ NUTL.."33) "..BZ["Hafr Fjall"]..GREY.." (55.6, 87.5)", 10033 },
		{ "" },
		{ BLUE..BZ["Suramar"] },
		{ NUTL.."34) "..BZ["Irongrove Retreat"]..GREY.." (25.5, 31.7)", 10034 },
		{ NUTL.."35) "..BZ["Meredil"]..GREY.." (34.4, 49.4)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10035 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (33.1, 48.2)" },
		{ NUTL.."36) "..BZ["Crimson Thicket"]..GREY.." (64.3, 42.0)", 10036 },
		{ "" },
		{ BLUE..BZ["Broken Shore"] },
		{ NUTL.."37) "..BZ["Deliverance Point"]..GREY.." (45.1, 64.0)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10037 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (44.9, 61.3)" },
		{ NUTL.."38) "..BZ["Aalgen Point"]..GREY.." (70.7, 47.6)", 10038 },
		{ NUTL.."39) "..BZ["Vengeance Point"]..GREY.." (49.7, 21.1)", 10039 },
		{ GREN.." 3) "..BZ["Acherus: The Ebon Hold"]..CL["DEATHKNIGHT"]..ALC["L-Parenthesis"]..L["Death Knight Only"]..ALC["R-Parenthesis"], 10102 },
		{ "" },
		{ CL["MAGE"]..Atlas_GetClassName("MAGE")..ALC["Hyphen"]..L["Teleportation Nexus"] },
		{ INDENT..GREY..ALC["L-Parenthesis"]..L["Requires Teleportation Nexus Advancement"]..ALC["R-Parenthesis"] },
		{ INDENT..CL["MAGE"].." 1) "..BZ["Ley-Ruins of Zarkhenar"]..GREY.." (57.9, 15.1)", 10201 },
		{ INDENT..CL["MAGE"].." 2) "..BZ["Sylvan Falls"]..GREY.." (31.4, 63.8)", 10202 },
		{ INDENT..CL["MAGE"].." 3) "..BZ["Weeping Bluffs"]..GREY.." (52.5, 35.2)", 10203 },
		{ INDENT..CL["MAGE"].." 4) "..BZ["Temple of Elune"]..GREY.." (33.5, 34.7)", 10204 },
		{ INDENT..CL["MAGE"].." 5) "..BZ["Meredil"]..GREY.." (33.4, 50.4)", 10205 },
		{ "" },
		{ CL["HUNTER"]..Atlas_GetClassName("HUNTER")..ALC["Hyphen"]..L["Great Eagle"] },
		{ INDENT..GREY..ALC["L-Parenthesis"]..L["Requires Eagle Ally Advancement"]..ALC["R-Parenthesis"] },
		{ INDENT..CL["HUNTER"].." 1) "..BZ["The Dreamgrove"]..GREY.." (44.1, 15.0)", 10301 },
		{ INDENT..CL["HUNTER"].." 2) "..BZ["Faronaar"]..GREY.." (25.4, 43.1)", 10302 },
		{ INDENT..CL["HUNTER"].." 3) "..BZ["Isle of the Watchers"]..GREY.." (51.0, 79.9)", 10303 },
		{ INDENT..CL["HUNTER"].." 4) "..BZ["Western Suramar"]..GREY.." (41.3, 82.8)", 10304 },
		{ INDENT..CL["HUNTER"].." 5) "..BZ["Eastern Suramar"]..GREY.." (70.2, 71.1)", 10305 },
		{ INDENT..CL["HUNTER"].." 6) "..BZ["Thorim's Peak"]..GREY.." (38.1, 79.2)", 10306 },
		{ INDENT..CL["HUNTER"].." 7) "..BZ["Nastrondir"]..GREY.." (45.9, 35.8)", 10307 },
		{ INDENT..CL["HUNTER"].." 8) "..BZ["Eastern Highmountain"]..GREY.." (56.7, 67.8)", 10308 },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP..L["Purple"]..ALC["Colon"]..L["Portals"] },
		{ NUTL..L["Yellow"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Nutral"] },
		{ ALAN..L["Blue"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..FACTION_ALLIANCE },
		{ GREN..L["Green"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Class Specific Only"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Azsuna", "ac=10665" },
		{ "Explore Highmountain", "ac=10667" },
		{ "Explore Stormheim", "ac=10668" },
		{ "Explore Suramar", "ac=10669" },
		{ "Explore Val'sharah", "ac=10666" },
		{ "Broken Isles Explorer", "ac=11188" },
		{ "Broken Isles Pathfinder, Part One", "ac=11190" },
		{ "Adventurer of Azsuna", "ac=11261" },
		{ "Adventurer of Highmountain", "ac=11264" },
		{ "Adventurer of Stormheim", "ac=11263" },
		{ "Adventurer of Suramar", "ac=11265" },
		{ "Adventurer of Val'sharah", "ac=11262" },
		{ "Treasures of Azsuna", "ac=11256" },
		{ "Treasures of Highmountain", "ac=11257" },
		{ "Treasures of Stormheim", "ac=11259" },
		{ "Treasures of Suramar", "ac=11260" },
		{ "Treasures of Val'sharah", "ac=11258" },
		{ "Going Up", "ac=10627" },
		{ "Higher Dimensional Learning", "ac=11175" },
		{ LBLU..QUESTS_LABEL },
		{ "50 World Quests Completed", "ac=11126" },
		{ "200 World Quests Completed", "ac=11127" },
		{ "500 World Quests Completed", "ac=11128" },
		{ "1000 World Quests Completed", "ac=11129" },
		{ "2500 World Quests Completed", "ac=11130" },
		{ "5000 World Quests Completed", "ac=11131" },
		{ "10,000 World Quests Completed", "ac=11132" },
		{ "Ain't No Mountain High Enough", "ac=10059" },
		{ "Azsuna Matata", "ac=10763" },
		{ "Drum Circle", "ac=10398" },
		{ "Good Suramaritan", "ac=11124" },
		{ "Harbinger", "ac=11240" },
		{ "Hatchling of the Talon", "ac=10774" },
		{ "Insurrection", "ac=11340" },
		{ "Leyline Bling", "ac=10756" },
		{ "Lock, Stock and Two Smoking Goblins", "ac=11232" },
		{ "Loremaster of Legion", "ac=11157" },
		{ "Nightfallen But Not Forgotten", "ac=10617" },
		{ "No Shellfish Endeavor", "ac=11427" },
		{ "Now You're Thinking With Portals", "ac=11125" },
		{ "Pillars of Creation", "ac=10877" },
		{ "Tehd & Marius' Excellent Adventure", "ac=11186" },
		{ "That's Val'sharah Folks!", "ac=10698" },
		{ "Variety is the Spice of Life", "ac=11189" },
		{ "Vrykul Story, Bro", "ac=10790" },
		{ "What a Ripoff!", "ac=10793" },
		{ "Why Can't I Hold All This Mana?", "ac=11133" },
		{ "Zoom!", "ac=10626" },
	},
	TransHordeBrokenIsles = {
		ZoneName = { BZ["Broken Isles"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"] },
		WorldMapID = "1007",
		Faction = "Horde",
		LargeMap = "TransHordeBrokenIsles",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Windrunner's Sanctuary"], 10040 },
		{ INDENT..GREY.." <-> "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Shrine of Two Moons"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Comma"]..BZ["Pandaria"] },
		{ INDENT..GREY.."  -> "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.."  -> "..BZ["Silvermoon City"]..ALC["Comma"]..BZ["Eversong Woods"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." B) "..BZ["Chamber of the Guardian"], 10041 },
		{ INDENT..GREY.."  -> "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"]..ALC["Comma"]..BZ["Outland"] },
		{ INDENT..GREY.."  -> "..BZ["Wyrmrest Temple"]..ALC["Comma"]..BZ["Dragonblight"]..ALC["Comma"]..BZ["Northrend"] },
		{ INDENT..GREY.."  -> "..BZ["Dalaran Crater"]..ALC["Comma"]..BZ["Hillsbrad Foothills"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..INDENT.._RED..ALC["L-Parenthesis"]..L["Warning: Drop"]..ALC["R-Parenthesis"] },
		{ INDENT..GREY.."  -> "..BZ["Karazhan"]..ALC["Comma"]..BZ["Deadwind Pass"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ PURP.." C) "..format(ALC["Portal to %s"], BZ["Dalaran"])..GREY.." (30.1, 40.7)", 10042 },
		{ NUTL.."37) "..BZ["Deliverance Point"]..ALC["Hyphen"].._G["BROKENSHORE_BUILDING_MAGETOWER"]..GREY.." (46.3, 61.9)" },
		{ INDENT..GREY.."  -> "..BZ["Meredil"]..ALC["Comma"]..BZ["Suramar"] },
		{ INDENT..GREY.."  -> "..BZ["Valdisdall"]..ALC["Comma"]..BZ["Stormheim"] },
		{ INDENT..GREY.."  -> "..BZ["Lorlathil"]..ALC["Comma"]..BZ["Val'sharah"] },
		{ INDENT..GREY.."  -> "..BZ["Crumbled Palace"]..ALC["Comma"]..BZ["Azsuna"] },
		{ INDENT..GREY.."  -> "..BZ["Thunder Totem"]..ALC["Comma"]..BZ["Highmountain"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ BLUE..BZ["Dalaran"] },
		{ NUTL.." 1) "..BZ["Krasus' Landing"]..GREY.." (69.8, 51.1)", 10001 },
		{ "" },
		{ BLUE..BZ["Azsuna"] },
		{ NUTL.." 2) "..BZ["Watchers' Aerie"]..GREY.." (51.8, 82.1)", 10002 },
		{ NUTL.." 3) "..BZ["Wardens' Redoubt"]..GREY.." (48.2, 73.8)", 10003 },
		{ NUTL.." 4) "..BZ["Shackle's Den"]..GREY.." (56.2, 58.9)", 10004 },
		{ NUTL.." 5) "..BZ["Illidari Stand"]..GREY.." (44.6, 43.8)", 10005 },
		{ NUTL.." 6) "..BZ["Illidari Perch"]..GREY.." (31.8, 46.3)", 10006 },
		{ NUTL.." 7) "..BZ["Felblaze Ingress"]..GREY.." (63.8, 28.5)", 10007 },
		{ NUTL.." 8) "..BZ["Azurewing Repose"]..GREY.." (48.4, 28.0)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10008 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (47.6, 28.1)" },
		{ NUTL.." 9) "..BZ["Challiane's Terrace"]..GREY.." (40.8, 9.0)", 10009 },
		{ NUTL.."10) "..BZ["Eye of Azshara"]..GREY.." (38.3, 46.1)", 10010 },
		{ "" },
		{ BLUE..BZ["Val'sharah"] },
		{ NUTL.."11) "..BZ["Lorlathil"]..GREY.." (55.0, 72.5)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10011 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (54.7, 74.9)" },
		{ NUTL.."12) "..BZ["Gloaming Reef"]..GREY.." (25.9, 66.5)", 10012 },
		{ NUTL.."13) "..BZ["Bradensbrook"]..GREY.." (42.2, 58.5)", 10013 },
		{ NUTL.."14) "..BZ["Garden of the Moon"]..GREY.." (56.7, 57.7)", 10014 },
		{ NUTL.."15) "..BZ["Starsong Refuge"]..GREY.." (69.0, 50.8)", 10015 },
		{ GREN.." 1) "..BZ["The Dreamgrove"]..CL["DRUID"]..ALC["L-Parenthesis"]..L["Druid Only"]..ALC["R-Parenthesis"]..GREY.." (61.7, 33.9)", 10100 },
		{ "" },
		{ BLUE..BZ["Highmountain"] },
		{ NUTL.."16) "..BZ["Obsidian Overlook"]..GREY.." (47.3, 84.6)", 10016 },
		{ NUTL.."17) "..BZ["Ironhorn Enclave"]..GREY.." (56.8, 83.9)", 10017 },
		{ NUTL.."18) "..BZ["Sylvan Falls"]..GREY.." (35.9, 65.9)", 10018 },
		{ NUTL.."19) "..BZ["Thunder Totem"]..GREY.." (44.9, 38.7)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10019 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (39.8, 42.2)" },
		{ NUTL.."20) "..BZ["Stonehoof Watch"]..GREY.." (59.2, 65.1)", 10020 },
		{ NUTL.."21) "..BZ["Nesingwary"]..GREY.." (40.2, 52.7)", 10021 },
		{ NUTL.."22) "..BZ["Skyhorn"]..GREY.." (52.6, 45.2)", 10022 },
		{ NUTL.."23) "..BZ["Felbane Camp"]..GREY.." (29.9, 39.3)", 10023 },
		{ NUTL.."24) "..BZ["The Witchwood"]..GREY.." (38.3, 39.3)", 10024 },
		{ NUTL.."25) "..BZ["Prepfoot"]..GREY.." (58.0, 28.6)", 10025 },
		{ NUTL.."26) "..BZ["Shipwreck Cove"]..GREY.." (41.9, 10.4)", 10026 },
		{ GREN.." 2) "..BZ["Trueshot Lodge"]..CL["HUNTER"]..ALC["L-Parenthesis"]..L["Hunter Only"]..ALC["R-Parenthesis"]..GREY.." (35.7, 27.5)", 10101 },
		{ "" },
		{ BLUE..BZ["Stormheim"] },
		{ HRDE.."27) "..BZ["Forsaken Foothold"]..GREY.." (36.5, 30.7)", 10027 },
		{ HRDE.."28) "..BZ["Cullen's Post"]..GREY.." (44.9, 59.1)", 10028 },
		{ NUTL.."29) "..BZ["Stormtorn Foothills"]..GREY.." (52.0, 34.8)", 10029 },
		{ NUTL.."30) "..BZ["Valdisdall"]..GREY.." (60.7, 50.9)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10030 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (60.2, 52.2)" },
		{ HRDE.."31) "..BZ["Dreadwake's Landing"]..GREY.." (54.5, 73.0)", 10031 },
		{ NUTL.."32) "..BZ["Shield's Rest"]..GREY.." (89.8, 10.7)", 10032 },
		{ NUTL.."33) "..BZ["Hafr Fjall"]..GREY.." (55.6, 87.5)", 10033 },
		{ "" },
		{ BLUE..BZ["Suramar"] },
		{ NUTL.."34) "..BZ["Irongrove Retreat"]..GREY.." (25.5, 31.7)", 10034 },
		{ NUTL.."35) "..BZ["Meredil"]..GREY.." (34.4, 49.4)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10035 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (33.1, 48.2)" },
		{ NUTL.."36) "..BZ["Crimson Thicket"]..GREY.." (64.3, 42.0)", 10036 },
		{ "" },
		{ BLUE..BZ["Broken Shore"] },
		{ NUTL.."37) "..BZ["Deliverance Point"]..GREY.." (45.1, 64.0)".."\n"..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"], 10037 },
		{ INDENT..CL["WARRIOR"]..L["Warrior's landing / jumping point (from or back to Skyhold)"] },
		{ INDENT..INDENT..GREY.." (44.9, 61.3)" },
		{ NUTL.."38) "..BZ["Aalgen Point"]..GREY.." (70.7, 47.6)", 10038 },
		{ NUTL.."39) "..BZ["Vengeance Point"]..GREY.." (49.7, 21.1)", 10039 },
		{ GREN.." 3) "..BZ["Acherus: The Ebon Hold"]..ALC["L-Parenthesis"]..L["Death Knight Only"]..ALC["R-Parenthesis"], 10102 },
		{ "" },
		{ CL["MAGE"]..Atlas_GetClassName("MAGE")..ALC["Hyphen"]..L["Teleportation Nexus"] },
		{ INDENT..GREY..ALC["L-Parenthesis"]..L["Requires Teleportation Nexus Advancement"]..ALC["R-Parenthesis"] },
		{ INDENT..CL["MAGE"].." 1) "..BZ["Ley-Ruins of Zarkhenar"]..GREY.." (57.9, 15.1)", 10201 },
		{ INDENT..CL["MAGE"].." 2) "..BZ["Sylvan Falls"]..GREY.." (31.4, 63.8)", 10202 },
		{ INDENT..CL["MAGE"].." 3) "..BZ["Weeping Bluffs"]..GREY.." (52.5, 35.2)", 10203 },
		{ INDENT..CL["MAGE"].." 4) "..BZ["Temple of Elune"]..GREY.." (33.5, 34.7)", 10204 },
		{ INDENT..CL["MAGE"].." 5) "..BZ["Meredil"]..GREY.." (33.4, 50.4)", 10205 },
		{ "" },
		{ CL["HUNTER"]..Atlas_GetClassName("HUNTER")..ALC["Hyphen"]..L["Great Eagle"] },
		{ INDENT..GREY..ALC["L-Parenthesis"]..L["Requires Eagle Ally Advancement"]..ALC["R-Parenthesis"] },
		{ INDENT..CL["HUNTER"].." 1) "..BZ["The Dreamgrove"]..GREY.." (44.1, 15.0)", 10301 },
		{ INDENT..CL["HUNTER"].." 2) "..BZ["Faronaar"]..GREY.." (25.4, 43.1)", 10302 },
		{ INDENT..CL["HUNTER"].." 3) "..BZ["Isle of the Watchers"]..GREY.." (51.0, 79.9)", 10303 },
		{ INDENT..CL["HUNTER"].." 4) "..BZ["Western Suramar"]..GREY.." (41.3, 82.8)", 10304 },
		{ INDENT..CL["HUNTER"].." 5) "..BZ["Eastern Suramar"]..GREY.." (70.2, 71.1)", 10305 },
		{ INDENT..CL["HUNTER"].." 6) "..BZ["Thorim's Peak"]..GREY.." (38.1, 79.2)", 10306 },
		{ INDENT..CL["HUNTER"].." 7) "..BZ["Nastrondir"]..GREY.." (45.9, 35.8)", 10307 },
		{ INDENT..CL["HUNTER"].." 8) "..BZ["Eastern Highmountain"]..GREY.." (56.7, 67.8)", 10308 },
		{ "" },
		{ _RED..L["Legend"] },
		{ PURP..L["Purple"]..ALC["Colon"]..L["Portals"] },
		{ NUTL..L["White"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Nutral"] },
		{ HRDE..L["Red"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..FACTION_HORDE },
		{ GREN..L["Green"]..ALC["Colon"]..L["Taxi Nodes"]..ALC["Hyphen"]..L["Class Specific Only"] },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Explore Azsuna", "ac=10665" },
		{ "Explore Highmountain", "ac=10667" },
		{ "Explore Stormheim", "ac=10668" },
		{ "Explore Suramar", "ac=10669" },
		{ "Explore Val'sharah", "ac=10666" },
		{ "Broken Isles Explorer", "ac=11188" },
		{ "Broken Isles Pathfinder, Part One", "ac=11190" },
		{ "Adventurer of Azsuna", "ac=11261" },
		{ "Adventurer of Highmountain", "ac=11264" },
		{ "Adventurer of Stormheim", "ac=11263" },
		{ "Adventurer of Suramar", "ac=11265" },
		{ "Adventurer of Val'sharah", "ac=11262" },
		{ "Treasures of Azsuna", "ac=11256" },
		{ "Treasures of Highmountain", "ac=11257" },
		{ "Treasures of Stormheim", "ac=11259" },
		{ "Treasures of Suramar", "ac=11260" },
		{ "Treasures of Val'sharah", "ac=11258" },
		{ "Going Up", "ac=10627" },
		{ "Higher Dimensional Learning", "ac=11175" },
		{ LBLU..QUESTS_LABEL },
		{ "50 World Quests Completed", "ac=11126" },
		{ "200 World Quests Completed", "ac=11127" },
		{ "500 World Quests Completed", "ac=11128" },
		{ "1000 World Quests Completed", "ac=11129" },
		{ "2500 World Quests Completed", "ac=11130" },
		{ "5000 World Quests Completed", "ac=11131" },
		{ "10,000 World Quests Completed", "ac=11132" },
		{ "Ain't No Mountain High Enough", "ac=10059" },
		{ "Azsuna Matata", "ac=10763" },
		{ "Drum Circle", "ac=10398" },
		{ "Good Suramaritan", "ac=11124" },
		{ "Harbinger", "ac=11240" },
		{ "Hatchling of the Talon", "ac=10774" },
		{ "Insurrection", "ac=11340" },
		{ "Leyline Bling", "ac=10756" },
		{ "Lock, Stock and Two Smoking Goblins", "ac=11232" },
		{ "Loremaster of Legion", "ac=11157" },
		{ "Nightfallen But Not Forgotten", "ac=10617" },
		{ "No Shellfish Endeavor", "ac=11427" },
		{ "Now You're Thinking With Portals", "ac=11125" },
		{ "Pillars of Creation", "ac=10877" },
		{ "Tehd & Marius' Excellent Adventure", "ac=11186" },
		{ "That's Val'sharah Folks!", "ac=10698" },
		{ "Variety is the Spice of Life", "ac=11189" },
		{ "Vrykul Story, Bro", "ac=10790" },
		{ "What a Ripoff!", "ac=10793" },
		{ "Why Can't I Hold All This Mana?", "ac=11133" },
		{ "Zoom!", "ac=10626" },
	},
	TransSuramar = {
		ZoneName = { BZ["Suramar"] },
		WorldMapID = "1033",
		LargeMap = "TransSuramar",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Ruins of Elune'eth"]..GREY.." (36.1, 47.2)", 10001 },
		{ PURP.." B) "..BZ["Tel'anor"]..GREY.." (42.0, 35.2)", 10002 },
		{ PURP.." C) "..BZ["Falanaar"]..GREY.." (21.9, 29.1)".."\n"..ALC["L-Parenthesis"]..BZ["Temple of Fal'adora"]..ALC["R-Parenthesis"].." (40.9, 13.8)".."\n"..ALC["Entrance"]..ALC["Colon"].."(22.9, 35.8 / 20.6, 50.4 / 20.5, 41.9)", 10003 },
		{ INDENT..GREY..ALC["L-Parenthesis"]..BZ["Temple of Fal'adora"]..ALC["R-Parenthesis"].." (40.9, 13.8)" },
		{ INDENT..GREY..ALC["Entrance"]..ALC["Colon"].."(22.9, 35.8 / 20.6, 50.4 / 20.5, 41.9)" },
		{ PURP.." D) "..BZ["Moonfall Overlook"]..ALC["Comma"]..BZ["Moon Guard Stronghold"]..GREY.." (30.8, 11.0)", 10004 },
		{ PURP.." E) "..BZ["Felsoul Hold"]..GREY.." (39.1, 76.3)".."\n"..GREY..ALC["L-Parenthesis"]..BZ["The Fel Breach"]..ALC["R-Parenthesis"].." (54.0, 36.8)".."\n"..GREY..ALC["Entrance"]..ALC["Colon"].."(35.8, 82.1)", 10005 },
		{ INDENT..GREY..ALC["L-Parenthesis"]..BZ["The Fel Breach"]..ALC["R-Parenthesis"].." (54.0, 36.8)" },
		{ INDENT..GREY..ALC["Entrance"]..ALC["Colon"].."(35.8, 82.1)" },
		{ PURP.." F) "..BZ["Sanctum of Order"]..GREY.." (43.4, 60.6)", 10006 },
		{ PURP.." G) "..BZ["Lunastre Estate"]..GREY.." (43.7, 79.2)", 10007 },
		{ PURP.." H) "..BZ["The Waning Crescent"]..GREY.." (47.7, 81.4)", 10008 },
		{ PURP.." I) "..BZ["Twilight Vineyards"]..GREY.." (64.0, 60.4)", 10009 },
		{ PURP.." J) "..BZ["Evermoon Terrace"]..GREY.." (52.0, 78.8)", 10010 },
		{ PURP.." K) "..BZ["Astravar Harbor"]..GREY.." (54.5, 69.4)", 10011 },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ NUTL.." 1) "..BZ["Irongrove Retreat"]..GREY.." (25.5, 31.7)", 10101 },
		{ NUTL.." 2) "..BZ["Meredil"]..GREY.." (34.4, 49.4)", 10102 },
		{ NUTL.." 3) "..BZ["Crimson Thicket"]..GREY.." (64.3, 42.0)", 10103 },
		{ CL["HUNTER"].." 4) "..BZ["Eastern Suramar"]..ALC["L-Parenthesis"]..L["Hunter Only"]..ALC["R-Parenthesis"]..GREY.." (70.2, 71.1)", 10104 },
		{ CL["HUNTER"].." 5) "..BZ["Western Suramar"]..ALC["L-Parenthesis"]..L["Hunter Only"]..ALC["R-Parenthesis"]..GREY.." (41.3, 82.8)", 10105 },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ LBLU..L["Exploration"] },
		{ "Adventurer of Suramar", "ac=11265" },
		{ "Explore Suramar", "ac=10669" },
		{ "Treasures of Suramar", "ac=11260" },
		{ LBLU..QUESTS_LABEL },
		{ "Good Suramaritan", "ac=11124" },
		{ "Insurrection", "ac=11340" },
		{ "Leyline Bling", "ac=10756" },
		{ "Now You're Thinking With Portals", "ac=11125" },
		{ "Why Can't I Hold All This Mana?", "ac=11133" },
	},
	TransDalaran = {
		ZoneName = { BZ["Dalaran"] },
		WorldMapID = "1014",
		DungeonLevel = "10",
		{ _RED..L["Portals"] },
		{ PURP.." A) "..BZ["Greyfang Enclave"]..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"], 10014 },
		{ INDENT..GREY.."  -> "..BZ["Ironforge"]..ALC["Comma"]..BZ["Dun Morogh"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.." <-> "..BZ["Stormwind City"]..ALC["Comma"]..BZ["Elwynn Forest"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.."  -> "..BZ["Shrine of Seven Stars"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Comma"]..BZ["Pandaria"] },
		{ INDENT..GREY.."  -> "..BZ["The Exodar"]..ALC["Comma"]..BZ["Azuremyst Isle"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Darnassus"]..ALC["Comma"]..BZ["Teldrassil"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ "" },
		{ PURP.." B) "..BZ["Windrunner's Sanctuary"]..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"], 10015 },
		{ INDENT..GREY.."  -> "..BZ["Silvermoon City"]..ALC["Comma"]..BZ["Eversong Woods"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.."  -> "..BZ["Thunder Bluff"]..ALC["Comma"]..BZ["Mulgore"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Undercity"]..ALC["Comma"]..BZ["Tirisfal Glades"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..GREY.." <-> "..BZ["Orgrimmar"]..ALC["Comma"]..BZ["Durotar"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Shrine of Two Moons"]..ALC["Comma"]..BZ["Vale of Eternal Blossoms"]..ALC["Comma"]..BZ["Pandaria"] },
		{ "" },
		{ PURP.." C) "..BZ["Chamber of the Guardian"]..NUTL..ALC["L-Parenthesis"]..L["Nutral"]..ALC["R-Parenthesis"], 10016 },
		{ INDENT..GREY.."  -> "..BZ["Caverns of Time"]..ALC["Comma"]..BZ["Tanaris"]..ALC["Comma"]..BZ["Kalimdor"] },
		{ INDENT..GREY.."  -> "..BZ["Shattrath City"]..ALC["Comma"]..BZ["Terokkar Forest"]..ALC["Comma"]..BZ["Outland"] },
		{ INDENT..GREY.."  -> "..BZ["Wyrmrest Temple"]..ALC["Comma"]..BZ["Dragonblight"]..ALC["Comma"]..BZ["Northrend"] },
		{ INDENT..GREY.."  -> "..BZ["Dalaran Crater"]..ALC["Comma"]..BZ["Hillsbrad Foothills"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ INDENT..INDENT.._RED..ALC["L-Parenthesis"]..L["Warning: Drop"]..ALC["R-Parenthesis"] },
		{ INDENT..GREY.."  -> "..BZ["Karazhan"]..ALC["Comma"]..BZ["Deadwind Pass"]..ALC["Comma"]..BZ["Eastern Kingdoms"] },
		{ "" },
		{ _RED..L["Taxi Nodes"] },
		{ INDENT..WHIT.." 1) "..L["Aludane Whitecloud <Flight Master>"], 10013 },
		{ "" },
		{ _RED..L["Class Order Halls"] },
		{ INDENT..CL["DEMONHUNTER"]..Atlas_GetClassName("DEMONHUNTER") },
		{ INDENT..CL["DEMONHUNTER"].." A) "..L["Illidari Gateway"], 10001 },
		{ "" },
		{ INDENT..CL["HUNTER"]..Atlas_GetClassName("HUNTER") },
		{ INDENT..CL["HUNTER"].." A) "..L["Talua <Eagle Keeper>"]..ALC["Hyphen"]..L["Flight to Trueshot Lodge"], 10002 },
		{ "" },
		{ INDENT..CL["PALADIN"]..Atlas_GetClassName("PALADIN") },
		{ INDENT..CL["PALADIN"].." A) "..format(ALC["Portal to %s"], BZ["Sanctum of Light"])..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"], 10003 },
		{ INDENT..CL["PALADIN"].." B) "..format(ALC["Portal to %s"], BZ["Sanctum of Light"])..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"], 10004 },
		{ "" },
		{ INDENT..CL["PRIEST"]..Atlas_GetClassName("PRIEST") },
		{ INDENT..CL["PRIEST"].." A) "..format(ALC["Portal to %s"], BZ["Netherlight Temple"])..HRDE..ALC["L-Parenthesis"]..FACTION_HORDE..ALC["R-Parenthesis"], 10005 },
		{ INDENT..CL["PRIEST"].." B) "..format(ALC["Portal to %s"], BZ["Netherlight Temple"])..ALAN..ALC["L-Parenthesis"]..FACTION_ALLIANCE..ALC["R-Parenthesis"], 10006 },
		{ "" },
		{ INDENT..CL["ROGUE"]..Atlas_GetClassName("ROGUE")..ALC["Hyphen"]..L["Connection to the Hall of Shadows"] },
		{ INDENT..CL["ROGUE"].." A) "..BZ["Glorious Goods"], 10007 },
		{ INDENT..CL["ROGUE"].." B) "..BZ["One More Glass"], 10008 },
		{ INDENT..CL["ROGUE"].." C) "..BZ["Tanks for Everything"], 10009 },
		{ "" },
		{ INDENT..CL["SHAMAN"]..Atlas_GetClassName("SHAMAN") },
		{ INDENT..CL["SHAMAN"].." A) "..format(ALC["Portal to %s"], BZ["The Maelstrom"]), 10010 },
		{ "" },
		{ INDENT..CL["WARLOCK"]..Atlas_GetClassName("WARLOCK") },
		{ INDENT..CL["WARLOCK"].." A) "..format(ALC["Portal to %s"], BZ["Dreadscar Rift"]), 10011 },
		{ INDENT..INDENT..GREY..ALC["L-Parenthesis"]..BZ["The Underbelly Descent"]..ALC["R-Parenthesis"] },
		{ "" },
		{ INDENT..CL["WARRIOR"]..Atlas_GetClassName("WARRIOR") },
		{ INDENT..CL["WARRIOR"].." A) "..L["Jump to Skyhold"], 10012 },
		{ "" },
		{ LBLU..ACHIEVEMENTS..ALC["Colon"] },
		{ "Underbelly Tycoon", "ac=11066" },
--		{ LBLU..QUESTS_LABEL },
	},
	TransEmeraldDreamway = {
		ZoneName = { BZ["Emerald Dreamway"]..CL["DRUID"]..ALC["L-Parenthesis"]..L["Druid Only"]..ALC["R-Parenthesis"] },
		WorldMapID = "1048",
		{ _RED..L["Portals"] },
		{ GREN.." A) "..BZ["The Dreamgrove"]..ALC["Comma"]..BZ["Val'sharah"]..ALC["Comma"]..BZ["Broken Isles"], 10001 },
		{ GREN.." B) "..BZ["Grizzly Hills"]..ALC["Comma"]..BZ["Northrend"], 10002 },
		{ GREN.." C) "..BZ["Dream Bough"]..ALC["Comma"]..BZ["Feralas"]..ALC["Comma"]..BZ["Kalimdor"], 10003 },
		{ GREN.." D) "..BZ["Stormrage Barrow Dens"]..ALC["Comma"]..BZ["Moonglade"]..ALC["Comma"]..BZ["Kalimdor"], 10004 },
		{ GREN.." E) "..BZ["Twilight Grove"]..ALC["Comma"]..BZ["Duskwood"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10005 },
		{ GREN.." F) "..BZ["Seradane"]..ALC["Comma"]..BZ["The Hinterlands"]..ALC["Comma"]..BZ["Eastern Kingdoms"], 10006 },
		{ GREN.." G) "..BZ["Nordrassil"]..ALC["Comma"]..BZ["Mount Hyjal"]..ALC["Comma"]..BZ["Kalimdor"], 10007 },
	},
}

local myDB = {
	TransAllianceCosmos = {
		{  1, 10001, 424, 395 }, -- Stormwind City
		{  2, 10002, 436, 356 }, -- Ironforge
		{  3, 10003, 441, 337 }, -- Menethil Harbor
		{  4, 10004, 496, 351 }, -- Highbank
		{  5, 10005, 467, 410 }, -- Shattered Beachhead
		{  6, 10006, 448, 423 }, -- Karazhan
		{  7, 10007, 420, 451 }, -- Booty Bay
		{  8, 10008, 424, 300 }, -- Dalaran Crater
		{  9, 10009, 474, 193 }, -- Shattered Sun Staging Area
		{ 10, 10010,  60, 219 }, -- Darnassus
		{ 11, 10011,  77, 232 }, -- Rut'theran Village
		{ 12, 10012,  24, 256 }, -- The Exodar
		{ 13, 10013, 131, 268 }, -- Nordrassil
		{ 14, 10014, 130, 342 }, -- Ratchet
		{ 15, 10015, 140, 374 }, -- Theramore
		{ 16, 10016, 136, 422 }, -- Caverns of Time
		{ 17, 10017,  98, 441 }, -- Ramkahen
		{ 18, 10018, 464,  91 }, -- The Stair of Destiny
		{ 19, 10019, 409, 116 }, -- Shattrath City
		{ 20, 10020, 221, 167 }, -- Valiance Keep
		{ 21, 10021, 331, 181 }, -- Valgarde
		{ 22, 10022, 275, 130 }, -- Dalaran (Northrend)
		{ 23, 10023, 274, 151 }, -- Wyrmrest Temple
		{ 24, 10024, 296, 466 }, -- Paw'Don Village
		{ 25, 10025, 262, 452 }, -- Shrine of Seven Stars
		{ 26, 10026, 190,  84 }, -- Stormshield
		{ 27, 10027, 130, 117 }, -- Lunarfall
		{ 28, 10028, 314, 299 }, -- Dalaran
	},
	TransHordeCosmos = {
		{  1, 10001, 135, 307 }, -- Orgrimmar
		{  2, 10002,  89, 344 }, -- Thunder Bluff
		{  3, 10003, 128, 267 }, -- Nordrassil
		{  4, 10004, 127, 343 }, -- Ratchet
		{  5, 10005, 133, 424 }, -- Caverns of Time
		{  6, 10006,  95, 441 }, -- Ramkahen
		{  7, 10007, 473, 191 }, -- Shattered Sun Staging Area
		{  8, 10008, 478, 228 }, -- Silvermoon City
		{  9, 10009, 417, 278 }, -- Brill
		{ 10, 10010, 427, 285 }, -- Undercity
		{ 11, 10011, 425, 300 }, -- Dalaran Crater
		{ 12, 10012, 497, 342 }, -- Dragonmaw Port
		{ 13, 10013, 468, 415 }, -- Shattered Landing
		{ 14, 10014, 453, 422 }, -- Karazhan
		{ 15, 10015, 427, 431 }, -- Grom'gol Base Camp
		{ 16, 10016, 426, 451 }, -- Booty Bay
		{ 17, 10017, 463,  90 }, -- The Stair of Destiny
		{ 18, 10018, 409, 114 }, -- Shattrath City
		{ 19, 10019, 214, 160 }, -- Warsong Hold
		{ 20, 10020, 341, 173 }, -- Vengeance Landing
		{ 21, 10021, 274, 130 }, -- Dalaran (Northrend)
		{ 22, 10022, 276, 152 }, -- Wyrmrest Temple
		{ 23, 10023, 279, 422 }, -- Honeydew Village
		{ 24, 10024, 262, 446 }, -- Shrine of Two Moons
		{ 25, 10025, 190,  73 }, -- Warspear
		{ 26, 10026,  66,  66 }, -- Frostwall Garrison
		{ 27, 10027, 313, 299 }, -- Dalaran
	},
	TransAllianceStormwindCity = {
		{ "A", 10001,  54, 273, 248, 372, "Orange" }, -- Rut'theran Village
		{ "B", 10002,  24, 140, 216, 203, "Orange" }, -- Valiance Keep
		{ "A", 10003, 228, 418, 466, 553, "Purple" }, -- The Stair of Destiny
		{ "B", 10004, 237, 406, 477, 540, "Purple" }, -- Fuselight-by-the-Sea
		{ "C", 10005, 358, 103, 635, 155, "Purple" }, -- Paw'Don Village
		{ "D", 10006, 389, 111, 671, 163, "Purple" }, -- Baradin Base Camp
		{ "E", 10007, 395,  99, 677, 149, "Purple" }, -- Darkbreak Cove
		{ "F", 10008, 408,  96, 691, 151, "Purple" }, -- Highbank
		{ "G", 10009, 415, 109, 704, 163, "Purple" }, -- Nordrassil
		{ "H", 10010, 411, 119, 699, 181, "Purple" }, -- Ramkahen
		{ "I", 10011, 399, 120, 686, 182, "Purple" }, -- Temple of Earth
		{ "J", 10012, 487, 182, 794, 260, "Purple" }, -- Stormshield
		{ "K", 10013, 441, 169, 736, 240, "Purple" }, -- Dalaran
		{ "1", 10014, 353, 178, 624, 250, "White" }, -- Ironforge
		{ "2", 10015, 374, 346, 656, 464, "White" }, -- Stormwind City
	},
	TransHordeOrgrimmar = {
		{ "A", 10001, 198, 321, 462, 414, "Purple"}, -- Shattered Landing
		{ "B", 10002, 177, 308, 436, 396, "Purple"}, -- The Stair of Destiny
		{ "B", 10002, 117, 352, 361, 445, "Purple"}, -- The Stair of Destiny
		{ "C", 10003, 201, 224, 462, 288, "Purple"}, -- Hellscream's Grasp
		{ "D", 10004, 209, 215, 475, 280, "Purple"}, -- Ramkahen
		{ "E", 10005, 211, 202, 476, 264, "Purple"}, -- Vashj'ir
		{ "F", 10006, 221, 200, 493, 264, "Purple"}, -- Temple of Earth
		{ "G", 10007, 227, 211, 497, 278, "Purple"}, -- Nordrassil
		{ "H", 10008, 219, 222, 486, 283, "Purple"}, -- Dragonmaw Port
		{ "I", 10009, 341, 224, 643, 293, "Purple"}, -- Honeydew Village
		{ "J", 10010, 198, 362, 463, 461, "Purple"}, -- Warspear
		{ "K", 10016, 188, 326, 451, 424, "Purple"}, -- Dalaran
		{ "A", 10011, 170, 329, 426, 424, "Orange" }, -- Thunder Bluff
		{ "B", 10012, 182, 322, 440, 410, "Orange" }, -- Warsong Hold
		{ "C", 10013, 224, 292, 492, 375, "Orange" }, -- Undercity
		{ "D", 10014, 232, 279, 506, 355, "Orange" }, -- Grom'gol Base Camp
		{ "1", 10015, 212, 308, 481, 393, "White" }, -- Wind Rider Master
		{ "A", 10017,  17, 362, 226, 463, "Blue" }, -- Northern Barrens
		{ "B", 10018, 221, 471, 486, 604, "Blue" }, -- Durota
		{ "C", 10019, 399,  27, 711,  44, "Blue" }, -- Azshara
	},
	TransAllianceDraenor = {
		{ "A", 10052, 278, 259 }, -- Khadgar's Tower
		{ "A'", 10053, 450, 10 }, -- Darnassus
		{ "B'", 10054, 494, 60 }, -- Ironforge
		{ "C'", 10055, 493, 136 }, -- Stormwind City
		{ "1", 10001, 307, 302 }, -- Lunarfall
		{ "2", 10002, 337, 314 }, -- Exile's Rise
		{ "3", 10003, 338, 331 }, -- Embaari Village
		{ "4", 10004, 367, 339 }, -- Path of Light
		{ "5", 10005, 365, 320 }, -- Elodor
		{ "6", 10006, 389, 345 }, -- Tranquil Court
		{ "7", 10007, 365, 356 }, -- The Draakorium
		{ "8", 10008, 328, 355 }, -- Twilight Glade
		{ "9", 10009, 337, 382 }, -- Socrethar's Rise
		{ "10", 10010, 367, 393 }, -- Darktide Roost
		{ "11", 10011, 288, 337 }, -- Akeeta's Hovel
		{ "12", 10012, 283, 288 }, -- Anchorite's Sojourn
		{ "13", 10013, 260, 292 }, -- Terokkar Refuge
		{ "14", 10014, 229, 305 }, -- Exarch's Refuge
		{ "15", 10015, 210, 316 }, -- Retribution Point
		{ "16", 10016, 224, 274 }, -- Shattrath City
		{ "17", 10017, 245, 251 }, -- Redemption Rise
		{ "18", 10018, 260, 245 }, -- Fort Wrynn
		{ "19", 10019, 275, 248 }, -- Zangarra
		{ "20", 10020, 271, 218 }, -- Bastion Rise
		{ "21", 10021, 273, 190 }, -- Deeproot
		{ "22", 10022, 290, 165 }, -- Highpass
		{ "23", 10023, 317, 155 }, -- Wildwood Wash
		{ "24", 10024, 299, 139 }, -- Everbloom Wilds
		{ "25", 10025, 331, 109 }, -- Everbloom Overlook
		{ "26", 10026, 273, 152 }, -- Breaker's Crown
		{ "27", 10027, 259, 120 }, -- Skysea Point
		{ "28", 10028, 266, 95 }, -- Iron Docks
		{ "29", 10029, 237, 349 }, -- Apexis Excavation
		{ "30", 10030, 245, 395 }, -- Southport
		{ "31", 10031, 254, 372 }, -- Veil Terokk
		{ "32", 10032, 261, 355 }, -- Crow's Crook
		{ "33", 10033, 284, 370 }, -- Talon Watch
		{ "34", 10034, 281, 412 }, -- Pinchwhistle Gearworks
		{ "35", 10035, 171, 258 }, -- The Ring of Trials
		{ "36", 10036, 136, 278 }, -- Telaari Station
		{ "37", 10037, 111, 293 }, -- Nivek's Overlook
		{ "38", 10038, 138, 254 }, -- Yrel's Watch
		{ "39", 10039, 117, 240 }, -- Rilzit's Holdfast
		{ "40", 10040, 134, 239 }, -- Joz's Rylaks
		{ "41", 10041, 155, 237 }, -- Throne of the Elements
		{ "42", 10042, 243, 187 }, -- Iron Siegeworks
		{ "43", 10043, 177, 128 }, -- Bloodmaul Slag Mines
		{ "44", 10044, 431, 242 }, -- Stormshield
		{ "45", 10045, 279, 233 }, -- The Iron Front
		{ "46", 10046, 301, 244 }, -- Sha'naari Refuge
		{ "47", 10047, 335, 249 }, -- Malo's Lookout
		{ "48", 10048, 353, 240 }, -- Lion's Watch
		{ "49", 10049, 300, 221 }, -- Aktar's Post
		{ "50", 10050, 330, 223 }, -- Vault of the Earth
		{ "51", 10051, 352, 207 }, -- Throne of Kil'jaeden
	},
	TransHordeDraenor = {
		{ "A", 10051, 283, 260 }, -- Khadgar's Tower
		{ "A'", 10052, 488, 118 }, -- Orgrimmar
		{ "B'", 10053, 489, 245 }, -- Thunder Bluff
		{ "C'", 10054, 378, 4 }, -- Undercity
		{ "1", 10001, 171, 185 }, -- Frostwall Garrison
		{ "2", 10002, 120, 170 }, -- Wor'gol
		{ "3", 10003, 132, 148 }, -- Bladespire Fortress
		{ "4", 10004, 152, 165 }, -- Stonefang Outpost
		{ "5", 10005, 138, 116 }, -- Throm'Var
		{ "6", 10006, 177, 150 }, -- Darkspear's Edge
		{ "7", 10007, 178, 126 }, -- Bloodmaul Slag Mines
		{ "8", 10008, 219, 175 }, -- Wolf's Stand
		{ "9", 10009, 238, 173 }, -- Thunder Pass
		{ "10", 10010, 259, 208 }, -- Evermorn Springs
		{ "11", 10011, 274, 219 }, -- Bastion Rise
		{ "12", 10012, 277, 176 }, -- Beastwatch
		{ "13", 10013, 272, 151 }, -- Breaker's Crown
		{ "14", 10014, 259, 119 }, -- Skysea Point
		{ "15", 10015, 267, 91 }, -- Iron Docks
		{ "16", 10016, 308, 144 }, -- Everbloom Wilds
		{ "17", 10017, 331, 107 }, -- Everbloom Overlook
		{ "18", 10018, 277, 249 }, -- Zangarra
		{ "19", 10019, 262, 256 }, -- Vol'jin's Pride
		{ "20", 10020, 250, 233 }, -- Frostwolf Overlook
		{ "21", 10021, 235, 273 }, -- Durotan's Grasp
		{ "22", 10022, 219, 275 }, -- Shattrath City
		{ "23", 10023, 261, 293 }, -- Terokkar Refuge
		{ "24", 10024, 227, 306 }, -- Exarch's Refuge
		{ "25", 10025, 212, 315 }, -- Retribution Point
		{ "26", 10026, 245, 349 }, -- Apexis Excavation
		{ "27", 10027, 269, 360 }, -- Crow's Crook
		{ "28", 10028, 242, 375 }, -- Axefall
		{ "29", 10029, 262, 373 }, -- Veil Terokk
		{ "30", 10030, 284, 369 }, -- Talon Watch
		{ "31", 10031, 281, 409 }, -- Pinchwhistle Gearworks
		{ "32", 10032, 173, 258 }, -- Wor'var
		{ "33", 10033, 161, 268 }, -- The Ring of Trials
		{ "34", 10034, 156, 235 }, -- Throne of the Elements
		{ "35", 10035, 135, 242 }, -- Joz's Rylaks
		{ "36", 10036, 119, 240 }, -- Rilzit's Holdfast
		{ "37", 10037, 114, 266 }, -- Riverside Post
		{ "38", 10038, 113, 294 }, -- Nivek's Overlook
		{ "39", 10039, 288, 336 }, -- Akeeta's Hovel
		{ "40", 10040, 343, 312 }, -- Exile's Rise
		{ "41", 10041, 332, 382 }, -- Socrethar's Rise
		{ "42", 10042, 366, 392 }, -- Darktide Roost
		{ "43", 10043, 436, 196 }, -- Warspear
		{ "44", 10044, 279, 238 }, -- The Iron Front
		{ "45", 10045, 302, 244 }, -- Sha'naari Refuge
		{ "46", 10046, 334, 249 }, -- Vault of the Earth
		{ "47", 10047, 361, 227 }, -- Vol'mar
		{ "48", 10048, 300, 222 }, -- Aktar's Post
		{ "49", 10049, 331, 224 }, -- Malo's Lookout
		{ "50", 10001, 349, 207 }, -- Throne of Kil'jaeden
	},
	TransAllianceAshran = {
		{ "A", 10001, 153, 331 },
		{ "B", 10002, 187, 305 },
		{ "C", 10003, 258, 333 },
		{ "D", 10004, 306, 299 },
		{ "E", 10005, 328, 379 },
	},
	TransHordeAshran = {
		{ "A", 10001, 205, 135 },
		{ "B", 10002, 252, 169 },
		{ "C", 10003, 240, 98 },
		{ "D", 10004, 313, 91 },
		{ "E", 10005, 289, 202 },
	},
	TransAllianceBrokenIsles = {
		{  "A", 10040, 230, 357, 432, 463, "Purple" }, -- Greyfang Enclave
		{  "B", 10041, 237, 349, 441, 452, "Purple" }, -- Chamber of the Guardian
		{  "C", 10042, 290, 133, 512, 170, "Purple" }, -- Portal to Dalaran
		{  "1", 10001, 249, 341, 454, 447, "TaxiNeutral" }, -- Krasus' Landing
		{  "2", 10002, 151, 378, 324, 497, "TaxiNeutral" }, -- Watchers' Aerie
		{  "3", 10003, 144, 363, 319, 477, "TaxiNeutral" }, -- Wardens' Redoubt
		{  "4", 10004, 165, 336, 348, 439, "TaxiNeutral" }, -- Shackle's Den
		{  "5", 10005, 130, 303, 297, 398, "TaxiNeutral" }, -- Illidari Stand
		{  "6", 10006,  98, 314, 255, 413, "TaxiNeutral" }, -- Illidari Perch
		{  "7", 10007, 191, 275, 380, 358, "TaxiNeutral" }, -- Felblaze Ingress
		{  "8", 10008, 138, 266, 307, 349, "TaxiNeutral" }, -- Azurewing Repose
		{  "9", 10009, 116, 238, 279, 307, "TaxiNeutral" }, -- Challiane's Terrace
		{ "10", 10010, 222, 450, 419, 587, "TaxiNeutral" }, -- Eye of Azshara
		{ "11", 10011, 147, 197, 327, 260, "TaxiNeutral" }, -- Lorlathil
		{ "12", 10012,  75, 185, 223, 240, "TaxiNeutral" }, -- Gloaming Reef
		{ "13", 10013, 117, 175, 280, 226, "TaxiNeutral" }, -- Bradensbrook
		{ "14", 10014, 149, 177, 327, 226, "TaxiNeutral" }, -- Garden of the Moon
		{ "15", 10015, 183, 163, 368, 209, "TaxiNeutral" }, -- Starsong Refuge
		{ "16", 10016, 246, 164, 453, 209, "TaxiNeutral" }, -- Obsidian Overlook
		{ "17", 10017, 277, 164, 503, 211, "TaxiNeutral" }, -- Ironhorn Enclave
		{ "18", 10018, 210, 126, 408, 162, "TaxiNeutral" }, -- Sylvan Falls
		{ "19", 10019, 244, 116, 449, 145, "TaxiNeutral" }, -- Thunder Totem
		{ "20", 10020, 283, 121, 504, 158, "TaxiNeutral" }, -- Stonehoof Watch
		{ "21", 10021, 224,  97, 421, 119, "TaxiNeutral" }, -- Nesingwary
		{ "22", 10022, 263,  84, 479, 106, "TaxiNeutral" }, -- Skyhorn
		{ "23", 10023, 191,  68, 379,  81, "TaxiNeutral" }, -- Felbane Camp
		{ "24", 10024, 217,  67, 414,  81, "TaxiNeutral" }, -- The Witchwood
		{ "25", 10025, 279,  51, 496,  57, "TaxiNeutral" }, -- Prepfoot
		{ "26", 10026, 228,  12, 429,  17, "TaxiNeutral" }, -- Shipwreck Cove
		{ "27", 10027, 297, 152, 522, 194, "TaxiAlliance" }, -- Skyfire Triage Camp (A)
		{ "28", 10028, 318, 176, 542, 227, "TaxiAlliance" }, -- Lorna's Watch (A)
		{ "29", 10029, 344, 127, 588, 163, "TaxiNeutral" }, -- Stormtorn Foothills
		{ "30", 10030, 369, 154, 620, 198, "TaxiNeutral" }, -- Valdisdall
		{ "31", 10031, 404, 171, 664, 219, "TaxiAlliance" }, -- Greywatch (A)
		{ "32", 10032, 442,  83, 717, 107, "TaxiNeutral" }, -- Shield's Rest
		{ "33", 10033, 353, 223, 600, 289, "TaxiNeutral" }, -- Hafr Fjall
		{ "34", 10034, 205, 198, 405, 255, "TaxiNeutral" }, -- Irongrove Retreat
		{ "35", 10035, 225, 227, 433, 284, "TaxiNeutral" }, -- Meredil
		{ "36", 10036, 291, 212, 521, 282, "TaxiNeutral" }, -- Crimson Thicket
		{ "37", 10037, 295, 368, 523, 481, "TaxiNeutral" }, -- Deliverance Point
		{ "38", 10038, 341, 351, 577, 458, "TaxiNeutral" }, -- Aalgen Point
		{ "39", 10039, 304, 322, 533, 424, "TaxiNeutral" }, -- Vengeance Point
		{  "1", 10100, 110, 112, 276, 146, "DRUID" }, -- The Dreamgrove
		{  "2", 10101, 193,  91, 400, 119, "HUNTER" }, -- Trueshot Lodge
		{  "3", 10102, 387, 365, 646, 483, "DEATHKNIGHT" }, -- Acherus: The Ebon Hold
		{  "1", 10201, 169, 245, 350, 321, "MAGE" }, -- Ley-Ruins of Zarkhenar
		{  "2", 10202, 193, 118, 387, 151, "MAGE" }, -- Sylvan Falls
		{  "3", 10203, 298, 170, 522, 220, "MAGE" }, -- Weeping Bluffs
		{  "4", 10204, 139, 172, 313, 219, "MAGE" }, -- Temple of Elune
		{  "5", 10205, 226, 238, 433, 291, "MAGE" }, -- Meredil
		{  "1", 10301, 123, 104, 288, 127, "HUNTER" }, -- The Dreamgrove
		{  "2", 10302,  77, 301, 228, 394, "HUNTER" }, -- Faronaar
		{  "3", 10303, 156, 371, 332, 484, "HUNTER" }, -- Isle of the Watchers
		{  "4", 10304, 247, 282, 451, 363, "HUNTER" }, -- Western Suramar
		{  "5", 10305, 316, 260, 545, 340, "HUNTER" }, -- Eastern Suramar
		{  "6", 10306, 312, 204, 538, 263, "HUNTER" }, -- Thorim's Peak
		{  "7", 10307, 333, 131, 572, 165, "HUNTER" }, -- Nastrondir
		{  "8", 10308, 275, 130, 489, 168, "HUNTER" }, -- Eastern Highmountain
	},
	TransHordeBrokenIsles = {
		{ "A", 10040, 239, 336, 445, 442, "Purple" }, -- Windrunner's Sanctuary
		{ "B", 10041, 237, 348, 442, 458, "Purple" }, -- Chamber of the Guardian
		{  "C", 10042, 290, 133, 512, 170, "Purple" }, -- Portal to Dalaran
		{  "1", 10001, 249, 341, 454, 447, "TaxiNeutral" }, -- Krasus' Landing
		{  "2", 10002, 151, 378, 324, 497, "TaxiNeutral" }, -- Watchers' Aerie
		{  "3", 10003, 144, 363, 319, 477, "TaxiNeutral" }, -- Wardens' Redoubt
		{  "4", 10004, 165, 336, 348, 439, "TaxiNeutral" }, -- Shackle's Den
		{  "5", 10005, 130, 303, 297, 398, "TaxiNeutral" }, -- Illidari Stand
		{  "6", 10006,  98, 314, 255, 413, "TaxiNeutral" }, -- Illidari Perch
		{  "7", 10007, 191, 275, 380, 358, "TaxiNeutral" }, -- Felblaze Ingress
		{  "8", 10008, 138, 266, 307, 349, "TaxiNeutral" }, -- Azurewing Repose
		{  "9", 10009, 116, 238, 279, 307, "TaxiNeutral" }, -- Challiane's Terrace
		{ "10", 10010, 222, 450, 419, 587, "TaxiNeutral" }, -- Eye of Azshara
		{ "11", 10011, 147, 197, 327, 260, "TaxiNeutral" }, -- Lorlathil
		{ "12", 10012,  75, 185, 223, 240, "TaxiNeutral" }, -- Gloaming Reef
		{ "13", 10013, 117, 175, 280, 226, "TaxiNeutral" }, -- Bradensbrook
		{ "14", 10014, 149, 177, 327, 226, "TaxiNeutral" }, -- Garden of the Moon
		{ "15", 10015, 183, 163, 368, 209, "TaxiNeutral" }, -- Starsong Refuge
		{ "16", 10016, 246, 164, 453, 209, "TaxiNeutral" }, -- Obsidian Overlook
		{ "17", 10017, 277, 164, 503, 211, "TaxiNeutral" }, -- Ironhorn Enclave
		{ "18", 10018, 210, 126, 408, 162, "TaxiNeutral" }, -- Sylvan Falls
		{ "19", 10019, 244, 116, 449, 145, "TaxiNeutral" }, -- Thunder Totem
		{ "20", 10020, 283, 121, 504, 158, "TaxiNeutral" }, -- Stonehoof Watch
		{ "21", 10021, 224,  97, 421, 119, "TaxiNeutral" }, -- Nesingwary
		{ "22", 10022, 263,  84, 479, 106, "TaxiNeutral" }, -- Skyhorn
		{ "23", 10023, 191,  68, 379,  81, "TaxiNeutral" }, -- Felbane Camp
		{ "24", 10024, 217,  67, 414,  81, "TaxiNeutral" }, -- The Witchwood
		{ "25", 10025, 279,  51, 496,  57, "TaxiNeutral" }, -- Prepfoot
		{ "26", 10026, 228,  12, 429,  17, "TaxiNeutral" }, -- Shipwreck Cove
		{ "27", 10027, 311, 122, 535, 153, "TaxiHorde" }, -- Forsaken Foothold (H)
		{ "28", 10028, 327, 169, 560, 219, "TaxiHorde" }, -- Cullen's Post (H)
		{ "29", 10029, 344, 127, 588, 163, "TaxiNeutral" }, -- Stormtorn Foothills
		{ "30", 10030, 369, 154, 620, 198, "TaxiNeutral" }, -- Valdisdall
		{ "31", 10031, 355, 191, 599, 249, "TaxiHorde" }, -- Dreadwake's Landing (H)
		{ "32", 10032, 442,  83, 717, 107, "TaxiNeutral" }, -- Shield's Rest
		{ "33", 10033, 353, 223, 600, 289, "TaxiNeutral" }, -- Hafr Fjall
		{ "34", 10034, 205, 198, 405, 255, "TaxiNeutral" }, -- Irongrove Retreat
		{ "35", 10035, 225, 227, 433, 284, "TaxiNeutral" }, -- Meredil
		{ "36", 10036, 291, 212, 521, 282, "TaxiNeutral" }, -- Crimson Thicket
		{ "37", 10037, 295, 368, 523, 481, "TaxiNeutral" }, -- Deliverance Point
		{ "38", 10038, 341, 351, 577, 458, "TaxiNeutral" }, -- Aalgen Point
		{ "39", 10039, 304, 322, 533, 424, "TaxiNeutral" }, -- Vengeance Point
		{  "1", 10100, 110, 112, 276, 146, "DRUID" }, -- The Dreamgrove
		{  "2", 10101, 193,  91, 400, 119, "HUNTER" }, -- Trueshot Lodge
		{  "3", 10102, 387, 365, 646, 483, "DEATHKNIGHT" }, -- Acherus: The Ebon Hold
		{  "1", 10201, 169, 245, 350, 321, "MAGE" }, -- Ley-Ruins of Zarkhenar
		{  "2", 10202, 193, 118, 387, 151, "MAGE" }, -- Sylvan Falls
		{  "3", 10203, 298, 170, 522, 220, "MAGE" }, -- Weeping Bluffs
		{  "4", 10204, 139, 172, 313, 219, "MAGE" }, -- Temple of Elune
		{  "5", 10205, 226, 238, 433, 291, "MAGE" }, -- Meredil
		{  "1", 10301, 123, 104, 288, 127, "HUNTER" }, -- The Dreamgrove
		{  "2", 10302,  77, 301, 228, 394, "HUNTER" }, -- Faronaar
		{  "3", 10303, 156, 371, 332, 484, "HUNTER" }, -- Isle of the Watchers
		{  "4", 10304, 247, 282, 451, 363, "HUNTER" }, -- Western Suramar
		{  "5", 10305, 316, 260, 545, 340, "HUNTER" }, -- Eastern Suramar
		{  "6", 10306, 312, 204, 538, 263, "HUNTER" }, -- Thorim's Peak
		{  "7", 10307, 333, 131, 572, 165, "HUNTER" }, -- Nastrondir
		{  "8", 10308, 275, 130, 489, 168, "HUNTER" }, -- Eastern Highmountain
	},
	TransSuramar = {
		{ "A", 10001, 155, 248, 288, 292, "Purple" }, -- Ruins of Elune'eth
		{ "B", 10002, 209, 175, 351, 209, "Purple" }, -- Tel'anor
		{ "C", 10003,  24, 142, 142, 177, "Purple" }, -- Falanaar
		{ "D", 10004, 103,  23, 231,  34, "Purple" }, -- Moonfall Overlook
		{ "E", 10005, 182, 428, 319, 499, "Purple" }, -- Felsoul Hold
		{ "F", 10006, 242, 357, 387, 412, "Purple" }, -- Sanctum of Order
		{ "G", 10007, 220, 450, 362, 515, "Purple" }, -- Lunastre Estate
		{ "H", 10008, 263, 464, 412, 535, "Purple" }, -- The Waning Crescent
		{ "I", 10009, 414, 329, 588, 389, "Purple" }, -- Twilight Vineyards
		{ "J", 10010, 301, 445, 458, 517, "Purple" }, -- Evermoon Terrace
		{ "K", 10011, 326, 388, 482, 453, "Purple" }, -- Astravar Harbor
		{ "1", 10101,  58, 156, 179, 184, "TaxiNeutral" }, -- Irongrove Retreat
		{ "2", 10102, 134, 263, 264, 308, "TaxiNeutral" }, -- Meredil
		{ "3", 10103, 414, 216, 583, 252, "TaxiNeutral" }, -- Crimson Thicket
		{ "4", 10104, 472, 401, 648, 462, "TaxiNeutral" }, -- Eastern Suramar
		{ "5", 10105, 200, 474, 349, 543, "TaxiNeutral" }, -- Western Suramar
	},
	TransDalaran = {
		{ "A", 10014, 184, 279 }, -- Greyfang Enclave
		{ "B", 10015, 262, 145 }, -- Windrunner's Sanctuary
		{ "C", 10016, 234, 221 }, -- Chamber of the Guardian
		{ "1", 10013, 335, 232 }, -- Aludane Whitecloud <Flight Master>
		{ "A", 10001, 463, 288 }, -- Illidari Gateway
		{ "A", 10002, 345, 200 }, -- Talua <Eagle Keeper>
		{ "A", 10003, 288, 113 }, -- Portal to Sanctum of Light
		{ "B", 10004, 152, 294 }, -- Portal to Sanctum of Light
		{ "A", 10005, 296, 125 }, -- Portal to Netherlight Temple
		{ "B", 10006, 188, 254 }, -- Portal to Netherlight Temple
		{ "A", 10007, 242, 292 }, -- Glorious Goods
		{ "B", 10008, 256, 174 }, -- One More Glass
		{ "C", 10009, 210, 162 }, -- Tanks for Everything
		{ "A", 10010, 319, 222 }, -- Portal to the Maelstrom
		{ "A", 10011, 155, 204 }, -- Portal to Dreadscar Rift
		{ "A", 10012, 354, 217 }, -- Jump to Skyhold
	},
	TransEmeraldDreamway = {
		{ "A", 10001, 234, 147 }, -- The Dreamgrove
		{ "B", 10002, 145, 175 }, -- Grizzly Hills
		{ "C", 10003, 79, 217 }, -- Dream Bough
		{ "D", 10004, 93, 410 }, -- Stormrage Barrow Dens
		{ "E", 10005, 196, 359 }, -- Twilight Grove
		{ "F", 10006, 276, 347 }, -- Seradane
		{ "G", 10007, 299, 285 }, -- Nordrassil
	
	},
}

Atlas:RegisterPlugin("Atlas_Transportation", myCategory, myData, myDB)

