local addonName, addon = ...
local _G = _G

-- luacheck: globals UIDropDownMenu_AddButton

addon.combatProtected = {
	-- List of cvars that can't be modified in combat
	["alwaysShowActionBars"] = true,
	["colorblindSimulator"] = true,
	["colorblindWeaknessFactor"] = true,
	["daltonize"] = true,
	["fullSizeFocusFrame"] = true,
	["garrisonCompleteTalent"] = true,
	["garrisonCompleteTalentType"] = true,
	["nameplateClassResourceTopInset"] = true,
	["nameplateGlobalScale"] = true,
	["NamePlateHorizontalScale"] = true,
	["nameplateLargeBottomInset"] = true,
	["nameplateLargerScale"] = true,
	["nameplateLargeTopInset"] = true,
	["nameplateMaxAlpha"] = true,
	["nameplateMaxAlphaDistance"] = true,
	["nameplateMaxDistance"] = true,
	["nameplateMaxScale"] = true,
	["nameplateMaxScaleDistance"] = true,
	["nameplateMinAlpha"] = true,
	["nameplateMinAlphaDistance"] = true,
	["nameplateMinScale"] = true,
	["nameplateMinScaleDistance"] = true,
	["nameplateMotion"] = true,
	["nameplateMotionSpeed"] = true,
	["nameplateOtherAtBase"] = true,
	["nameplateOtherBottomInset"] = true,
	["nameplateOtherTopInset"] = true,
	["nameplateOverlapH"] = true,
	["nameplateOverlapV"] = true,
	["NameplatePersonalHideDelayAlpha"] = true,
	["nameplatePersonalHideDelaySeconds"] = true,
	["nameplatePersonalShowAlways"] = true,
	["nameplatePersonalShowInCombat"] = true,
	["nameplatePersonalShowWithTarget"] = true,
	["nameplateResourceOnTarget"] = true,
	["nameplateSelectedAlpha"] = true,
	["nameplateSelectedScale"] = true,
	["nameplateSelfAlpha"] = true,
	["nameplateSelfBottomInset"] = true,
	["nameplateSelfScale"] = true,
	["nameplateSelfTopInset"] = true,
	["nameplateShowAll"] = true,
	["nameplateShowEnemies"] = true,
	["nameplateShowEnemyGuardians"] = true,
	["nameplateShowEnemyMinions"] = true,
	["nameplateShowEnemyMinus"] = true,
	["nameplateShowEnemyPets"] = true,
	["nameplateShowEnemyTotems"] = true,
	["nameplateShowFriendlyGuardians"] = true,
	["nameplateShowFriendlyMinions"] = true,
	["nameplateShowFriendlyNPCs"] = true,
	["nameplateShowFriendlyPets"] = true,
	["nameplateShowFriendlyTotems"] = true,
	["nameplateShowFriends"] = true,
	["nameplateShowSelf"] = true,
	["nameplateTargetBehindMaxDistance"] = true,
	["NamePlateVerticalScale"] = true,
	["showArenaEnemyFrames"] = true,
	["showArenaEnemyPets"] = true,
	["showPartyPets"] = true,
	["showTargetOfTarget"] = true,
	["splashScreenBoost"] = true,
	["splashScreenNormal"] = true,
	["targetOfTargetMode"] = true,
	["uiScale"] = true,
	["uiScaleMultiplier"] = true,
	["UnitNameGuildTitle"] = true,
	["useCompactPartyFrames"] = true,
	["useUiScale"] = true,
}

addon.hiddenOptions = {
	-- Names
	["UnitNameOwn"] = { prettyName = UNIT_NAME_OWN, description = OPTION_TOOLTIP_UNIT_NAME_OWN, type = "boolean" },
	["UnitNameNPC"] = { prettyName = UNIT_NAME_NPC, description = OPTION_TOOLTIP_UNIT_NAME_NPC, type = "boolean" },
	["UnitNameNonCombatCreatureName"] = { prettyName = UNIT_NAME_NONCOMBAT_CREATURE, description = OPTION_TOOLTIP_UNIT_NAME_NONCOMBAT_CREATURE, type = "boolean" },
	["UnitNamePlayerGuild"] = { prettyName = UNIT_NAME_GUILD, description = OPTION_TOOLTIP_UNIT_NAME_GUILD, type = "boolean" },
	["UnitNameGuildTitle"] = { prettyName = UNIT_NAME_GUILD_TITLE, description = OPTION_TOOLTIP_UNIT_NAME_GUILD_TITLE , type = "boolean" },
	["UnitNamePlayerPVPTitle"] = { prettyName = UNIT_NAME_PLAYER_TITLE, description = OPTION_TOOLTIP_UNIT_NAME_PLAYER_TITLE, type = "boolean" },
	["UnitNameFriendlyPlayerName"] = { prettyName = UNIT_NAME_FRIENDLY, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY, type = "boolean" },
	["UnitNameFriendlyPetName"] = { prettyName = UNIT_NAME_FRIENDLY_PETS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_PETS, type = "boolean" },
	["UnitNameFriendlyGuardianName"] = { prettyName = UNIT_NAME_FRIENDLY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_GUARDIANS, type = "boolean" },
	["UnitNameFriendlyTotemName"] = { prettyName = UNIT_NAME_FRIENDLY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAME_FRIENDLY_TOTEMS, type = "boolean" },
	["UnitNameFriendlyMinionName"] = { prettyName = UNIT_NAME_FRIENDLY_MINIONS, description = "", type = "boolean" },
	["UnitNameEnemyPlayerName"] = { prettyName = UNIT_NAME_ENEMY, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY, type = "boolean" },
	["UnitNameEnemyPetName"] = { prettyName = UNIT_NAME_ENEMY_PETS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_PETS, type = "boolean" },
	["UnitNameEnemyGuardianName"] = { prettyName = UNIT_NAME_ENEMY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_GUARDIANS, type = "boolean" },
	["UnitNameEnemyTotemName"] = { prettyName = UNIT_NAME_ENEMY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAME_ENEMY_TOTEMS, type = "boolean" },
	["UnitNameEnemyMinionName"] = { prettyName = UNIT_NAME_ENEMY_MINIONS, description = "", type = "boolean" },
	["UnitNameForceHideMinus"] = { prettyName = UNIT_NAME_HIDE_MINUS, description = OPTION_TOOLTIP_UNIT_NAME_HIDE_MINUS, type = "boolean" },
	["UnitNameFriendlySpecialNPCName"] = { prettyName = NPC_NAMES_DROPDOWN_TRACKED, description = NPC_NAMES_DROPDOWN_TRACKED_TOOLTIP, type = "boolean" },
	["UnitNameHostleNPC"] = { prettyName = "Hostile NPCs", description = "Display names for hostile NPCs", type = "boolean" },
	["UnitNameInteractiveNPC"] = { prettyName = "Interactive NPCs", description = "Display names for interactive NPCs", type = "boolean" },
	-- Nameplates
	["nameplateShowFriends"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDS, type = "boolean" },
	["nameplateShowFriendlyPets"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_PETS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_PETS, type = "boolean" },
	["nameplateShowFriendlyGuardians"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_GUARDIANS, type = "boolean" },
	["nameplateShowFriendlyTotems"] = { prettyName = UNIT_NAMEPLATES_SHOW_FRIENDLY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_FRIENDLY_TOTEMS, type = "boolean" },
	["nameplateShowFriendlyNPCs"] = { prettyName = "Friendly NPCs", description = "Always show friendly NPC's nameplates", type = "boolean" },
	["nameplateShowEnemies"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMIES, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMIES, type = "boolean" },
	["nameplateShowEnemyPets"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_PETS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_PETS, type = "boolean" },
	["nameplateShowEnemyGuardians"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_GUARDIANS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_GUARDIANS, type = "boolean" },
	["nameplateShowEnemyTotems"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_TOTEMS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_TOTEMS, type = "boolean" },
	["nameplateShowEnemyMinus"] = { prettyName = UNIT_NAMEPLATES_SHOW_ENEMY_MINUS, description = OPTION_TOOLTIP_UNIT_NAMEPLATES_SHOW_ENEMY_MINUS, type = "boolean" },
	["nameplateOtherAtBase"] = { prettyName = "Nameplate at Base", description = "Position other nameplates at the base, rather than overhead. 2=under unit, 0=over unit", type = "boolean" },
	["nameplateOverlapH"] = { prettyName = "Nameplate Overlap (Horizontal)", description = "Percentage amount for horizontal overlap of nameplates", type = "number" },
	["nameplateOverlapV"] = { prettyName = "Nameplate Overlap (Vertical)", description = "Percentage amount for vertical overlap of nameplates", type = "number" },
	["nameplateMaxDistance"] = { prettyName = "Nameplate Distance", description = "The max distance to show nameplates.", type = "number" },
	["nameplateTargetBehindMaxDistance"] = { prettyName = "Nameplate Target Behind Distance", description = "The max distance to show the target nameplate when the target is behind the camera.", type = "number" },
	["nameplateGlobalScale"] = { prettyName = "Nameplate Global Scale", description = "Applies global scaling to non-self nameplates, this is applied AFTER selected, min, and max scale.", type = "number" },
	["nameplateMinScale"] = { prettyName = "Nameplate Min Scale", description = "The minimum scale of nameplates.", type = "number" },
	["nameplateMaxScale"] = { prettyName = "Nameplate Max Scale", description = "The max scale of nameplates.", type = "number" },
	["nameplateLargerScale"] = { prettyName = "Nameplate Larger Scale", description = "An additional scale modifier for important monsters.", type = "number" },
	["nameplateMinScaleDistance"] = { prettyName = "Nameplate Min Scale Distance", description = "The distance from the max distance that nameplates will reach their minimum scale.", type = "number" },
	["nameplateMaxScaleDistance"] = { prettyName = "Nameplate Max Scale Distance", description = "The distance from the camera that nameplates will reach their maximum scale", type = "number" },
	["nameplateMinAlpha"] = { prettyName = "Nameplate Min Alpha", description = "The minimum alpha of nameplates.", type = "number" },
	["nameplateMaxAlpha"] = { prettyName = "Nameplate Max Alpha", description = "The max alpha of nameplates.", type = "number" },
	["nameplateMinAlphaDistance"] = { prettyName = "Nameplate Min Alpha Distance", description = "The distance from the max distance that nameplates will reach their minimum alpha.", type = "number" },
	["nameplateMaxAlphaDistance"] = { prettyName = "Nameplate Max Alpha Distance", description = "The distance from the camera that nameplates will reach their maximum alpha.", type = "number" },
	["nameplateSelectedScale"] = { prettyName = "Nameplate Selected Scale", description = "The scale of the selected nameplate.", type = "number" },
	["nameplateSelectedAlpha"] = { prettyName = "Nameplate Selected Alpha", description = "The alpha of the selected nameplate.", type = "number" },
	["nameplateSelfScale"] = { prettyName = "Nameplate Self Scale", description = "The scale of the self nameplate.", type = "number" },
	["nameplateSelfAlpha"] = { prettyName = "Nameplate Self Alpha", description = "The alpha of the self nameplate.", type = "number" },
	["nameplateSelfBottomInset"] = { prettyName = "Nameplate Self Bottom Inset", description = "The inset from the bottom (in screen percent) that the self nameplate is clamped to.", type = "number" },
	["nameplateSelfTopInset"] = { prettyName = "Nameplate Self Top Inset", description = "The inset from the top (in screen percent) that the self nameplate is clamped to.", type = "number" },
	["nameplateOtherBottomInset"] = { prettyName = "Nameplate Other Bottom Inset", description = "The inset from the bottom (in screen percent) that the non-self nameplates are clamped to.", type = "number" },
	["nameplateOtherTopInset"] = { prettyName = "Nameplate Other Top Inset", description = "The inset from the top (in screen percent) that the non-self nameplates are clamped to.", type = "number" },
	["nameplateLargeBottomInset"] = { prettyName = "Nameplate Large Bottom Inset", description = "The inset from the bottom (in screen percent) that large nameplates are clamped to.", type = "number" },
	["nameplateLargeTopInset"] = { prettyName = "Nameplate Large Top Inset", description = "The inset from the top (in screen percent) that large nameplates are clamped to.", type = "number" },
	["nameplateClassResourceTopInset"] = { prettyName = "Nameplate Class Resource Top Inset", description = "The inset from the top (in screen percent) that nameplates are clamped to when class resources are being displayed on them.", type = "number" },
	["NamePlateHorizontalScale"] = { prettyName = "Nameplate Horizontal Scale", description = "Applied to horizontal size of all nameplates.", type = "number" },
	["NamePlateVerticalScale"] = { prettyName = "Nameplate Vertical Scale", description = "Applied to vertical size of all nameplates.", type = "number" },
	["nameplateResourceOnTarget"] = { prettyName = "Nameplate Resource On Target", description = "Nameplate class resource overlay mode. 0=self, 1=target", type = "number" },
	["nameplateShowSelf"] = { prettyName = "Show Nameplate Resource Bar", description = "Display class resource bar. 0=off 1=on", type = "number" },
	["nameplateShowAll"] = { prettyName = "Always Show Nameplates", description = "Show nameplates at all times.", type = "number" },
	["nameplateMotion"] = { prettyName = "Nameplate Motion Type", description = "0 = Overlapping - 1 = Stacking", type = "number" },
	["namePlateFriendlySize"] = { prettyName = "", description = "", type = "number" },
	["namePlateEnemySize"] = { prettyName = "", description = "", type = "number" },
	["namePlateSelfClickThrough"] = { prettyName = "", description = "", type = "number" },
	["namePlateFriendlyClickThrough"] = { prettyName = "", description = "", type = "number" },
	["namePlateEnemyClickThrough"] = { prettyName = "", description = "", type = "number" },
	["nameplatePersonalShowAlways"] = { prettyName = "", description = "Always show personal nameplate", type = "boolean" },
	["nameplatePersonalShowInCombat"] = { prettyName = "", description = "Always show personal nameplate while in combat", type = "boolean" },
	["nameplatePersonalShowWithTarget"] = { prettyName = "", description = "Always show personal nameplate with a hostile target", type = "boolean" },
	["nameplatePersonalHideDelaySeconds"] = { prettyName = "", description = "The delay to wait before hiding the personal nameplate", type = "boolean" },
	["ShowNamePlateLoseAggroFlash"] = { prettyName = nil, description = "When enabled, if you are a tank role and lose aggro, the nameplate with briefly flash.", type = "boolean" },
	["ShowClassColorInNameplate"] = { prettyName = SHOW_CLASS_COLOR_IN_V_KEY, description = OPTION_TOOLTIP_SHOW_CLASS_COLOR_IN_V_KEY, type = "boolean" },
	["ShowClassColorInFriendlyNameplate"] = { prettyName = "Class color friendly nameplates", description = "Class color for friendly nameplates", type = "boolean" },
	
	["nameplateTargetRadialPosition"] = { prettyName = nil, description = "When target is off screen, position its nameplate radially around sides and bottom", type = "number"},
	["nameplateOccludedAlphaMult"] = { prettyName = nil, description = "Alpha multiplier of nameplates for occluded targets", type = "number"},


	["reverseCleanupBags"] = { prettyName = REVERSE_CLEAN_UP_BAGS_TEXT, description = OPTION_TOOLTIP_REVERSE_CLEAN_UP_BAGS, type = "boolean" },
	["lootLeftmostBag"] = { prettyName = REVERSE_NEW_LOOT_TEXT, description = OPTION_TOOLTIP_REVERSE_NEW_LOOT, type = "boolean" },
	["stopAutoAttackOnTargetChange"] = { prettyName = STOP_AUTO_ATTACK, description = OPTION_TOOLTIP_STOP_AUTO_ATTACK, type = "boolean" },
	["assistAttack"] = { prettyName = ASSIST_ATTACK, description = OPTION_TOOLTIP_ASSIST_ATTACK, type = "boolean" },
	["autoSelfCast"] = { prettyName = AUTO_SELF_CAST_TEXT, description = OPTION_TOOLTIP_SELF_CAST_TEXT, type = "boolean" },
	["ActionButtonUseKeyDown"] = { prettyName = ACTION_BUTTON_USE_KEY_DOWN, description = OPTION_TOOLTIP_ACTION_BUTTON_USE_KEY_DOWN, type = "boolean" },
	["mapFade"] = { prettyName = MAP_FADE_TEXT, description = OPTION_TOOLTIP_MAP_FADE, type = "boolean" },
	["trackQuestSorting"] = { type = "table", options = {"proximity", "top" } },
	["removeChatDelay"] = { prettyName = REMOVE_CHAT_DELAY_TEXT, description = OPTION_TOOLTIP_REMOVE_CHAT_DELAY_TEXT, type = "boolean" },
	["secureAbilityToggle"] = { prettyName = SECURE_ABILITY_TOGGLE, description = OPTION_TOOLTIP_SECURE_ABILITY_TOGGLE, type = "boolean" },
	["scriptErrors"] = { prettyName = SHOW_LUA_ERRORS, description = OPTION_TOOLTIP_SHOW_LUA_ERRORS, type = "boolean" },
	["lootUnderMouse"] = { prettyName = LOOT_UNDER_MOUSE_TEXT, description = OPTION_TOOLTIP_LOOT_UNDER_MOUSE_TEXT, type = "boolean" },
	["ShowQuestUnitCircles"] = { prettyName = "Quest Unit Circles", description = "Determines if units related to a quest display an indicator on the ground", type = "boolean" },
	["autoLootDefault"] = { prettyName = AUTO_LOOT_DEFAULT_TEXT, description = OPTION_TOOLTIP_AUTO_LOOT_DEFAULT, type = "boolean" },
	["threatShowNumeric"] = { prettyName = SHOW_NUMERIC_THREAT, description = OPTION_TOOLTIP_SHOW_NUMERIC_THREAT, type = "boolean" },
	["showLootSpam"] = { prettyName = SHOW_LOOT_SPAM, description = OPTION_TOOLTIP_SHOW_LOOT_SPAM, type = "boolean" },
	["advancedWatchFrame"] = { prettyName = ADVANCED_OBJECTIVES_TEXT, description = OPTION_TOOLTIP_ADVANCED_OBJECTIVES_TEXT, type = "" },
	["watchFrameIgnoreCursor"] = { prettyName = OBJECTIVES_IGNORE_CURSOR_TEXT, description = OPTION_TOOLTIP_OBJECTIVES_IGNORE_CURSOR, type = "boolean" },
	["guildMemberNotify"] = { prettyName = GUILDMEMBER_ALERT, description = OPTION_TOOLTIP_GUILDMEMBER_ALERT, type = "boolean" },
	["showArenaEnemyFrames"] = { prettyName = SHOW_ARENA_ENEMY_FRAMES_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_FRAMES, type = "boolean" },
	["autoClearAFK"] = { prettyName = nil, description = OPTION_TOOLTIP_CLEAR_AFK, type = "boolean" },
	["colorblindWeaknessFactor"] = { prettyName = nil, description = OPTION_TOOLTIP_ADJUST_COLORBLIND_STRENGTH, type = "boolean" },
	["autoLootDefault"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_LOOT_DEFAULT, type = "boolean" },
	["autoLootRate"] = { prettyName = "Auto Loot Rate", description = "Rate in milliseconds to tick auto loot", type = "number" },
	["ChatAmbienceVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_, type = "boolean" },
	["threatShowNumeric"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_NUMERIC_THREAT, type = "boolean" },
	["rightActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR3, type = "boolean" },
	["emphasizeMySpellEffects"] = { prettyName = nil, description = OPTION_TOOLTIP_EMPHASIZE_MY_SPELLS, type = "boolean" },
	["chatBubblesParty"] = { prettyName = nil, description = OPTION_TOOLTIP_PARTY_CHAT_BUBBLES, type = "boolean" },
	["enableTwitter"] = { prettyName = nil, description = OPTION_TOOLTIP_SOCIAL_ENABLE_TWITTER_FUNCTIONALITY, type = "boolean" },
	["threatPlaySounds"] = { prettyName = nil, description = OPTION_TOOLTIP_PLAY_AGGRO_SOUNDS, type = "boolean" },
	-- Toasts mmhhh...Toast.
	["showToastOnline"] = { prettyName = SHOW_TOAST_ONLINE_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_ONLINE, type = "boolean" },
	["showToastOffline"] = { prettyName = SHOW_TOAST_OFFLINE_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_OFFLINE, type = "boolean" },
	["showToastBroadcast"] = { prettyName = SHOW_TOAST_BROADCAST_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_BROADCAST, type = "boolean" },
	["showToastFriendRequest"] = { prettyName = SHOW_TOAST_FRIEND_REQUEST_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_FRIEND_REQUEST, type = "boolean" },
	["showToastConversation"] = { prettyName = SHOW_TOAST_CONVERSATION_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_CONVERSATION, type = "boolean" },
	["showToastWindow"] = { prettyName = SHOW_TOAST_WINDOW_TEXT, description = OPTION_TOOLTIP_SHOW_TOAST_WINDOW, type = "boolean" },
	["toastDuration"] = { prettyName = nil, description = OPTION_TOOLTIP_TOAST_DURATION, type = "number" },

	["enableMouseSpeed"] = { prettyName = ENABLE_MOUSE_SPEED, description = OPTION_TOOLTIP_ENABLE_MOUSE_SPEED, type = "boolean" },
	["mouseInvertPitch"] = { prettyName = INVERT_MOUSE, description = OPTION_TOOLTIP_INVERT_MOUSE, type = "boolean" },
	["enableWoWMouse"] = { prettyName = WOW_MOUSE, description = OPTION_TOOLTIP_WOW_MOUSE, type = "boolean" },
	["autointeract"] = { prettyName = CLICK_TO_MOVE, description = OPTION_TOOLTIP_CLICK_TO_MOVE, type = "boolean" },
	["mouseSpeed"] = { prettyName = MOUSE_SENSITIVITY, description = OPTION_TOOLTIP_MOUSE_SENSITIVITY, type = "number" },

	["wholeChatWindowClickable"] = { prettyName = nil, description = OPTION_TOOLTIP_CHAT_WHOLE_WINDOW_CLICKABLE, type = "boolean" },
	["useEnglishAudio"] = { prettyName = nil, description = OPTION_TOOLTIP_USE_ENGLISH_AUDIO, type = "boolean" },
	["ChatSoundVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_, type = "number" },
	--["reducedLagTolerance"] = { prettyName = "Custom Lag Tolerance", description = OPTION_TOOLTIP_REDUCED_LAG_TOLERANCE, type = "boolean" },
	["EnableMicrophone"] = { prettyName = nil, description = OPTION_TOOLTIP_ENABLE_MICROPHONE, type = "boolean" },
	["autoOpenLootHistory"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_OPEN_LOOT_HISTORY, type = "boolean" },
	["showVKeyCastbarOnlyOnTarget"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY_ONLY_ON_TARGET, type = "boolean" },
	["displaySpellActivationOverlays"] = { prettyName = nil, description = OPTION_TOOLTIP_DISPLAY_SPELL_ALERTS, type = "boolean" },
	["hdPlayerModels"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_HD_MODELS, type = "boolean" },
	["autoLootKey"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_LOOT_KEY, type = "boolean" }, -- TODO TYPE
	["SpellQueueWindow"] = { prettyName = LAG_TOLERANCE, description = "Determines how far ahead of the \'end of a spell\' start-recovery spell system can be, before allowing spell request to be sent to the server. Ie this controls the built-in lag for the ability queuing system. Ideally, you\'ll want to set this to your in-game latency.", type = "number" },
	["advancedCombatLogging"] = { prettyName = nil, description = OPTION_TOOLTIP_ADVANCED_COMBAT_LOGGING, type = "boolean" },
	["disableServerNagle"] = { prettyName = nil, description = OPTION_TOOLTIP_OPTIMIZE_NETWORK_SPEED, type = "boolean" },
	-- Camera
	["cameraYawSmoothSpeed"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_FOLLOW_SPEED, type = "number" },
	["cameraWaterCollision"] = { prettyName = nil, description = OPTION_TOOLTIP_WATER_COLLISION, type = "boolean" },
	["cameraBobbing"] = { prettyName = nil, description = OPTION_TOOLTIP_HEAD_BOB, type = "boolean" },
	["cameraPivot"] = { prettyName = nil, description = OPTION_TOOLTIP_SMART_PIVOT, type = "boolean" },
	["cameraDistanceMaxZoomFactor"] = { prettyName = MAX_FOLLOW_DIST, description = OPTION_TOOLTIP_MAX_FOLLOW_DIST, type = "number" },
	["cameraYawMoveSpeed"] = { prettyName = MOUSE_LOOK_SPEED, description = OPTION_TOOLTIP_MOUSE_LOOK_SPEED, type = "number" },
	["cameraTerrainTilt"] = { prettyName = nil, description = OPTION_TOOLTIP_FOLLOW_TERRAIN, type = "boolean" },
	["cameraHeadMovementStrength"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementWhileStanding"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementRange"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeadMovementSmoothRate"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitch"] = { prettyName = nil, description = nil, type = "number" },
	-- ["cameraDynamicPitchBaseFovPad"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitchBaseFovPadFlying"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDynamicPitchSmartPivotCutoffDist"] = { prettyName = nil, description = nil, type = "number" },
	["cameraOverShoulder"] = { prettyName = nil, description = nil, type = "number" },
	["cameraLockedTargetFocusing"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDistanceMoveSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraPitchMoveSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraBobbingSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraFoVSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraDistanceSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraGroundSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraHeightSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraPitchSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraTargetSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	-- ["cameraFlyingMountHeightSmoothSpeed"] = { prettyName = nil, description = nil, type = "number" },
	["cameraViewBlendStyle"] = { prettyName = nil, description = nil, type = "number" },
	["camerasmooth"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothPitch"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothYaw"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothStyle"] = { prettyName = nil, description = nil, type = "number" },
	["cameraSmoothTrackingStyle"] = { prettyName = nil, description = nil, type = "number" },

	["chatBubbles"] = { prettyName = nil, description = OPTION_TOOLTIP_CHAT_BUBBLES, type = "boolean" },
	["autoDismountFlying"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_DISMOUNT_FLYING, type = "boolean" },
	["bottomRightActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR2, type = "boolean" },
	["showPartyBackground"] = { prettyName = SHOW_PARTY_BACKGROUND_TEXT, description = OPTION_TOOLTIP_SHOW_PARTY_BACKGROUND, type = "boolean" },
	["showPartyPets"] = { prettyName = SHOW_PARTY_PETS_TEXT, description = OPTION_TOOLTIP_SHOW_PARTY_PETS, type = "boolean" },
	["showArenaEnemyFrames"] = { prettyName = SHOW_ARENA_ENEMY_FRAMES_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_FRAMES, type = "boolean" },
	["showArenaEnemyCastbar"] = { prettyName = SHOW_ARENA_ENEMY_CASTBAR_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_CASTBAR, type = "boolean" },
	["showArenaEnemyPets"] = { prettyName = SHOW_ARENA_ENEMY_PETS_TEXT, description = OPTION_TOOLTIP_SHOW_ARENA_ENEMY_PETS, type = "boolean" },
	["fullSizeFocusFrame"] = { prettyName = FULL_SIZE_FOCUS_FRAME_TEXT, description = OPTION_TOOLTIP_FULL_SIZE_FOCUS_FRAME, type = "boolean" },
	["spamFilter"] = { prettyName = nil, description = OPTION_TOOLTIP_SPAM_FILTER, type = "boolean" },
	["profanityFilter"] = { prettyName = nil, description = OPTION_TOOLTIP_PROFANITY_FILTER, type = "boolean" },
	["EnableVoiceChat"] = { prettyName = nil, description = OPTION_TOOLTIP_ENABLE_VOICECHAT, type = "boolean" },
	["rightTwoActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR4, type = "boolean" },
	["rotateMinimap"] = { prettyName = nil, description = OPTION_TOOLTIP_ROTATE_MINIMAP, type = "boolean" },
	["blockTrades"] = { prettyName = nil, description = OPTION_TOOLTIP_BLOCK_TRADES, type = "boolean" },
	["movieSubtitle"] = { prettyName = nil, description = OPTION_TOOLTIP_CINEMATIC_SUBTITLES, type = "boolean" },
	["displayFreeBagSlots"] = { prettyName = nil, description = OPTION_TOOLTIP_DISPLAY_FREE_BAG_SLOTS, type = "boolean" },
	["lockActionBars"] = { prettyName = nil, description = OPTION_TOOLTIP_LOCK_ACTIONBAR, type = "boolean" },
	["screenEdgeFlash"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_FULLSCREEN_STATUS, type = "boolean" },
	["showVKeyCastbar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY, type = "boolean" },
	["chatMouseScroll"] = { prettyName = CHAT_MOUSE_WHEEL_SCROLL, description = OPTION_TOOLTIP_CHAT_MOUSE_WHEEL_SCROLL, type = "boolean" },
	["InboundChatVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_OUTPUT_VOLUME, type = "number" },
	["spellActivationOverlayOpacity"] = { prettyName = nil, description = OPTION_TOOLTIP_SPELL_ALERT_OPACITY, type = "number" },
	["PushToTalkSound"] = { prettyName = nil, description = OPTION_TOOLTIP_PUSHTOTALK_SOUND, type = "boolean" },
	["countdownForCooldowns"] = { prettyName = nil, description = OPTION_TOOLTIP_COUNTDOWN_FOR_COOLDOWNS, type = "boolean" },
	["VoiceActivationSensitivity"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_ACTIVATION_SENSITIVITY, type = "number" },
	["alwaysShowActionBars"] = { prettyName = nil, description = OPTION_TOOLTIP_ALWAYS_SHOW_MULTIBARS, type = "boolean" },
	["OutboundChatVolume"] = { prettyName = nil, description = OPTION_TOOLTIP_VOICE_INPUT_VOLUME, type = "number" },
	["autoQuestWatch"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_QUEST_WATCH, type = "boolean" },
	["SpellTooltip_DisplayAvgValues"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_POINTS_AS_AVG, type = "boolean" },
	["bottomLeftActionBar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_MULTIBAR1, type = "boolean" },
	["showVKeyCastbarSpellName"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR_IN_V_KEY_SPELL_NAME, type = "boolean" },
	["buffDurations"] = { prettyName = SHOW_BUFF_DURATION_TEXT, description = OPTION_TOOLTIP_SHOW_BUFF_DURATION, type = "boolean" },
	["showDispelDebuffs"] = { prettyName = SHOW_DISPELLABLE_DEBUFFS_TEXT, description = OPTION_TOOLTIP_SHOW_DISPELLABLE_DEBUFFS, type = "boolean" },
	["showCastableBuffs"] = { prettyName = SHOW_CASTABLE_BUFFS_TEXT, description = OPTION_TOOLTIP_SHOW_CASTABLE_BUFFS, type = "boolean" },
	["deselectOnClick"] = { prettyName = nil, description = OPTION_TOOLTIP_GAMEFIELD_DESELECT, type = "boolean" },
	["autoQuestProgress"] = { prettyName = nil, description = OPTION_TOOLTIP_AUTO_QUEST_PROGRESS, type = "boolean" },
	["UberTooltips"] = { prettyName = USE_UBERTOOLTIPS, description = OPTION_TOOLTIP_USE_UBERTOOLTIPS, type = "boolean" },
	-- Sound
	["Sound_EnableAllSound"] = { prettyName = ENABLE_SOUND, description = OPTION_TOOLTIP_ENABLE_SOUND, type = "boolean" },
	["Sound_EnableDSPEffects"] = { prettyName = ENABLE_DSP_EFFECTS, description = OPTION_TOOLTIP_ENABLE_DSP_EFFECTS, type = "boolean" },
	["Sound_SFXVolume"] = { prettyName = SOUND_VOLUME, description = OPTION_TOOLTIP_SOUND_VOLUME, type = "number" },
	["Sound_ZoneMusicNoDelay"] = { prettyName = ENABLE_MUSIC_LOOPING, description = OPTION_TOOLTIP_ENABLE_MUSIC_LOOPING, type = "boolean" },
	["Sound_EnableDialog"] = { prettyName = ENABLE_DIALOG, description = OPTION_TOOLTIP_ENABLE_DIALOG, type = "boolean" },
	["Sound_EnableSoundWhenGameIsInBG"] = { prettyName = ENABLE_BGSOUND, description = OPTION_TOOLTIP_ENABLE_BGSOUND, type = "boolean" },
	["Sound_EnableEmoteSounds"] = { prettyName = ENABLE_EMOTE_SOUNDS, description = OPTION_TOOLTIP_ENABLE_EMOTE_SOUNDS, type = "boolean" },
	["Sound_EnableAmbience"] = { prettyName = ENABLE_AMBIENCE, description = OPTION_TOOLTIP_ENABLE_AMBIENCE, type = "boolean" },
	["Sound_DialogVolume"] = { prettyName = DIALOG_VOLUME, description = OPTION_TOOLTIP_DIALOG_VOLUME, type = "number" },
	["Sound_EnablePetBattleMusic"] = { prettyName = ENABLE_PET_BATTLE_MUSIC, description = OPTION_TOOLTIP_ENABLE_PET_BATTLE_MUSIC, type = "boolean" },
	["Sound_MusicVolume"] = { prettyName = MUSIC_VOLUME, description = OPTION_TOOLTIP_MUSIC_VOLUME, type = "number" },
	["Sound_EnableReverb"] = { prettyName = ENABLE_REVERB, description = OPTION_TOOLTIP_ENABLE_REVERB, type = "boolean" },
	["Sound_MasterVolume"] = { prettyName = MASTER_VOLUME, description = OPTION_TOOLTIP_MASTER_VOLUME, type = "number" },
	["Sound_EnableMusic"] = { prettyName = ENABLE_MUSIC, description = OPTION_TOOLTIP_ENABLE_MUSIC, type = "boolean" },
	["Sound_AmbienceVolume"] = { prettyName = AMBIENCE_VOLUME, description = OPTION_TOOLTIP_AMBIENCE_VOLUME, type = "number" },
	["Sound_EnableErrorSpeech"] = { prettyName = ENABLE_ERROR_SPEECH, description = OPTION_TOOLTIP_ENABLE_ERROR_SPEECH, type = "boolean" },
	["Sound_EnableSFX"] = { prettyName = ENABLE_SOUNDFX, description = OPTION_TOOLTIP_ENABLE_SOUNDFX, type = "boolean" },
	["Sound_ListenerAtCharacter"] = { prettyName = ENABLE_SOUND_AT_CHARACTER, description = OPTION_TOOLTIP_ENABLE_SOUND_AT_CHARACTER, type = "boolean" },
	["Sound_EnablePetSounds"] = { prettyName = ENABLE_PET_SOUNDS, description = OPTION_TOOLTIP_ENABLE_PET_SOUNDS, type = "boolean" },
	["Sound_EnablePositionalLowPassFilter"] = { prettyName = ENABLE_SOFTWARE_HRTF, description = OPTION_TOOLTIP_ENABLE_SOFTWARE_HRTF, type = "boolean" },

	["showTargetOfTarget"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_OF_TARGET, type = "boolean" },
	["guildMemberNotify"] = { prettyName = nil, description = OPTION_TOOLTIP_GUILDMEMBER_ALERT, type = "boolean" },
	["showTutorials"] = { prettyName = SHOW_TUTORIALS, description = OPTION_TOOLTIP_SHOW_TUTORIALS, type = "boolean" },
	["lossOfControl"] = { prettyName = nil, description = OPTION_TOOLTIP_LOSS_OF_CONTROL, type = "boolean" },
	["blockChannelInvites"] = { prettyName = nil, description = OPTION_TOOLTIP_BLOCK_CHAT_CHANNEL_INVITE, type = "boolean" },
	["showTargetCastbar"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_TARGET_CASTBAR, type = "boolean" },
	["enablePetBattleCombatText"] = { prettyName = nil, description = OPTION_TOOLTIP_SHOW_PETBATTLE_COMBAT, type = "boolean" },
	["colorblindMode"] = { prettyName = nil, description = OPTION_TOOLTIP_USE_COLORBLIND_MODE, type = "boolean" },
	["useIPv6"] = { prettyName = USEIPV6, description = OPTION_TOOLTIP_USEIPV6, type = "boolean" },
	["interactOnLeftClick"] = { prettyName = INTERACT_ON_LEFT_CLICK_TEXT, description = OPTION_TOOLTIP_INTERACT_ON_LEFT_CLICK, type = "boolean" },
	["enableMovePad"] = { prettyName = MOVE_PAD, description = OPTION_TOOLTIP_MOVE_PAD, type = "boolean" },
	["colorblindSimulator"] = { prettyName = nil, description = OPTION_TOOLTIP_COLORBLIND_FILTER, type = "boolean" },

	["noBuffDebuffFilterOnTarget"] = { prettyName = "No Debuff Filter on Target", description = "Do not filter buffs or debuffs at all on targets", type = "boolean" },
	["showHonorAsExperience"] = { prettyName = nil, description = "Show the honor bar as a regular experience bar in place of rep", type = "boolean" },
	-- Tab-Targetting
	["TargetNearestUseNew"] = { prettyName = nil, description = "Use 7.2 'nearest target' functionality", type = "boolean" },
	--["TargetPriorityAllowAnyOnScreen"] = { prettyName = nil, description = "If set, and no 100% correct target is available, allow selecting any valid in-range target (2 = also out-of-range)", type = "boolean" },
	["TargetPriorityCombatLock"] = { prettyName = nil, description = "1=Lock to in-combat targets when starting from an in-combat target. 2=Further restrict to in-combat with player.", type = "boolean" },
	["TargetPriorityCombatLockHighlight"] = { prettyName = nil, description = "1=Lock to in-combat targets when starting from an in-combat target. 2=Further restrict to in-combat with player. (while doing hold-to-target)", type = "boolean" },
	--["TargetPriorityHoldHighlightDelay"] = { prettyName = nil, description = "Delay in Milliseconds before priority target highlight starts when holding the button", type = "number" },
	--["TargetPriorityIncludeBehind"] = { prettyName = nil, description = "If set, include target's behind the player in priority target selection", type = "boolean" },
	["TargetPriorityPvp"] = { prettyName = nil, description = "When in pvp, give higher priority to players and important pvp targets (2 = all pvp targets, 3 = players only)", type = "boolean" },
	--["TargetPriorityPvpLock"] = { prettyName = nil, description = "Lock to important pvp targets when starting from a pvp target.", type = "boolean" },
	--["TargetPriorityPvpLockHighlight"] = { prettyName = nil, description = "Lock to players when starting from a player target in pvp. (while doing hold-to-target)", type = "boolean" },
	--["TargetPriorityValueBank"] = { prettyName = nil, description = "Selects the scoring values bank for calculating target priority order", type = "boolean" },
	["TargetPriorityCombatLockContextualRelaxation"] = { prettyName = nil, description = "1=Enables relaxation of combat lock based on context (eg. no in-combat target infront)", type = "number" },

	["unitClutter"] = { prettyName = nil, description = "Enables/Disables unit clutter", type = "boolean" },
	["unitClutterInstancesOnly"] = { prettyName = nil, description = "Whether or not to use unit clutter in instances only (0 or 1)", type = "boolean" },
	["unitClutterPlayerThreshold"] = { prettyName = nil, description = "The number of players that have to be nearby to trigger unit clutter", type = "boolean" },

	["comboPointLocation"] = { prettyName = nil, description = "Location of combo points in UI. 1=target, 2=self", type = "number" },
	["doNotFlashLowHealthWarning"] = { prettyName = nil, description = "Do not flash your screen red when you are low on health.", type = "boolean" },
	["findYourselfAnywhere"] = { prettyName = nil, description = "Always Highlight your character", type = "boolean" },
	["findYourselfAnywhereOnlyInCombat"] = { prettyName = nil, description = "Highlight your character only when in combat", type = "boolean" },
	["findYourselfInBG"] = { prettyName = nil, description = "Always Highlight your character in Battlegrounds", type = "boolean" },
	["findYourselfInBGOnlyInCombat"] = { prettyName = "Highlight your character in Battlegrounds only when in combat", description = "", type = "boolean" },
	["findYourselfInRaid"] = { prettyName = nil, description = "Always Highlight your character in Raids", type = "boolean" },
	["findYourselfInRaidOnlyInCombat"] = { prettyName = nil, description = "Highlight your character in Raids only when in combat", type = "boolean" },
	["findYourselfMode"] = { prettyName = nil, description = "Highlight you character. 0 = circle, 1 = circle & outline", type = "boolean" },
	["flashErrorMessageRepeats"] = { prettyName = nil, description = "Flashes the center screen red error text if the same message is fired.", type = "boolean" },
	-- Floating Combat Text
	["enableFloatingCombatText"] = { prettyName = SHOW_COMBAT_TEXT_TEXT, description = OPTION_TOOLTIP_SHOW_COMBAT_TEXT , type = "boolean" },
	["floatingCombatTextAllSpellMechanics"] = { prettyName = nil, description = "", type = "boolean" },
	["floatingCombatTextAuras"] = { prettyName = COMBAT_TEXT_SHOW_AURAS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_AURAS , type = "boolean" },
	["floatingCombatTextCombatDamage"] = { prettyName = SHOW_DAMAGE_TEXT, description = OPTION_TOOLTIP_SHOW_DAMAGE, type = "boolean" },
	["floatingCombatTextCombatDamageAllAutos"] = { prettyName = nil, description = "Show all auto-attack numbers, rather than hiding non-event numbers", type = "boolean" },
	["floatingCombatTextCombatDamageDirectionalOffset"] = { prettyName = nil, description = "Amount to offset directional damage numbers when they start", type = "boolean" },
	["floatingCombatTextCombatDamageDirectionalScale"] = { prettyName = "Directional Scale", description = "Directional damage numbers movement scale (disabled = no directional numbers)", type = "boolean" },
	["floatingCombatTextCombatHealing"] = { prettyName = SHOW_COMBAT_HEALING, description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING, type = "boolean" },
	["floatingCombatTextCombatHealingAbsorbSelf"] = { prettyName = SHOW_COMBAT_HEALING_ABSORB_SELF.." (Self)", description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING_ABSORB_SELF, type = "boolean" },
	["floatingCombatTextCombatHealingAbsorbTarget"] = { prettyName = SHOW_COMBAT_HEALING_ABSORB_TARGET.." (Target)" , description = OPTION_TOOLTIP_SHOW_COMBAT_HEALING_ABSORB_TARGET, type = "boolean" },
	["floatingCombatTextCombatLogPeriodicSpells"] = { prettyName = LOG_PERIODIC_EFFECTS, description = OPTION_TOOLTIP_LOG_PERIODIC_EFFECTS, type = "boolean" },
	["floatingCombatTextCombatState"] = { prettyName = COMBAT_TEXT_SHOW_COMBAT_STATE_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_COMBAT_STATE, type = "boolean" },
	["floatingCombatTextComboPoints"] = { prettyName = COMBAT_TEXT_SHOW_COMBO_POINTS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_COMBO_POINTS , type = "boolean" },
	["floatingCombatTextDamageReduction"] = { prettyName =COMBAT_TEXT_SHOW_RESISTANCES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_RESISTANCES, type = "boolean" },
	["floatingCombatTextDodgeParryMiss"] = { prettyName = COMBAT_TEXT_SHOW_DODGE_PARRY_MISS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_DODGE_PARRY_MISS, type = "boolean" },
	["floatingCombatTextEnergyGains"] = { prettyName = COMBAT_TEXT_SHOW_ENERGIZE_TEXT.." & "..COMBAT_TEXT_SHOW_COMBO_POINTS_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_ENERGIZE, type = "boolean" },
	["floatingCombatTextFloatMode"] = { prettyName = COMBAT_TEXT_FLOAT_MODE_LABEL, description = OPTION_TOOLTIP_COMBAT_TEXT_MODE, type = "number" },
	["floatingCombatTextFriendlyHealers"] = { prettyName = COMBAT_TEXT_SHOW_FRIENDLY_NAMES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_FRIENDLY_NAMES, type = "boolean" },
	["floatingCombatTextHonorGains"] = { prettyName = COMBAT_TEXT_SHOW_HONOR_GAINED_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_HONOR_GAINED, type = "boolean" },
	["floatingCombatTextLowManaHealth"] = { prettyName = COMBAT_TEXT_SHOW_LOW_HEALTH_MANA_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_LOW_HEALTH_MANA, type = "boolean" },
	["floatingCombatTextPeriodicEnergyGains"] = { prettyName = COMBAT_TEXT_SHOW_PERIODIC_ENERGIZE_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_PERIODIC_ENERGIZE, type = "boolean" },
	["floatingCombatTextPetMeleeDamage"] = { prettyName = SHOW_PET_MELEE_DAMAGE, description = OPTION_TOOLTIP_SHOW_PET_MELEE_DAMAGE, type = "boolean" },
	["floatingCombatTextPetSpellDamage"] = { prettyName = SHOW_PET_SPELL_DAMAGE, description = "Display pet spell damage in the world", type = "boolean" },
	["floatingCombatTextReactives"] = { prettyName = COMBAT_TEXT_SHOW_REACTIVES_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_REACTIVES, type = "boolean" },
	["floatingCombatTextRepChanges"] = { prettyName = COMBAT_TEXT_SHOW_REPUTATION_TEXT, description = OPTION_TOOLTIP_COMBAT_TEXT_SHOW_REPUTATION, type = "boolean" },
	["floatingCombatTextSpellMechanics"] = { prettyName = SHOW_TARGET_EFFECTS, description = OPTION_TOOLTIP_SHOW_TARGET_EFFECTS, type = "boolean" },
	["floatingCombatTextSpellMechanicsOther"] = { prettyName = SHOW_OTHER_TARGET_EFFECTS, description = OPTION_TOOLTIP_SHOW_OTHER_TARGET_EFFECTS, type = "boolean" },
	-- Status Text
	["statusText"] = { prettyName = STATUS_TEXT, description = "Whether the status bars show numeric health/mana values", type = "boolean"},
	["statusTextDisplay"] = { prettyName = STATUS_TEXT, description = OPTION_TOOLTIP_STATUS_TEXT_DISPLAY, type = "boolean"},
	["playerStatusText"] = { prettyName = STATUS_TEXT_PLAYER, description = OPTION_TOOLTIP_STATUS_TEXT_PLAYER , type = "boolean"}, -- removed
	["petStatusText"] = { prettyName = STATUS_TEXT_PET, description = OPTION_TOOLTIP_STATUS_TEXT_PET, type = "boolean"}, -- removed
	["partyStatusText"] = { prettyName = STATUS_TEXT_PARTY, description = OPTION_TOOLTIP_STATUS_TEXT_PARTY, type = "boolean"}, -- removed
	["targetStatusText"] = { prettyName = STATUS_TEXT_TARGET, description = OPTION_TOOLTIP_STATUS_TEXT_TARGET, type = "boolean"}, -- removed
	["alternateResourceText"] = { prettyName = ALTERNATE_RESOURCE_TEXT, description = OPTION_TOOLTIP_ALTERNATE_RESOURCE, type = "boolean"}, -- removed
	["xpBarText"] = { prettyName = XP_BAR_TEXT, description = OPTION_TOOLTIP_XP_BAR, type = "boolean" },

	["violenceLevel"] = { prettyName = "Violence Level", description = "Sets the violence level of the game", type = "number" },
	["ffxGlow"] = { prettyName = "FFX Glow", description = "full screen glow effect", type = "boolean" },
	["ffxNether"] = { prettyName = "FFX Nether", description = "full screen nether / glow effect", type = "boolean" },
	["releaseUITextures"] = { prettyName = "Release UI Textures", description = "Release Hidden UI Textures by default", type = "boolean" },
	["alwaysCompareItems"] = { prettyName = "Always Compare Items", description = "Always show item comparison tooltips", type = "boolean" },
	["showSpenderFeedback"] = { prettyName= "Show spender feedback", description = "Shows/Hide the flash after spending rage/mana/etc in resource bars.", type = "boolean" },
	-- Loss of Control UI
	["lossOfControlFull"] = { prettyName = "Loss of Control: Full", description = "Sets the type of the Loss of Control alert. (0 = Off, 1 = Only Alert, 2 = Show Full Duration)", type = "number" },
	["lossOfControlSilence"] = { prettyName = "Loss of Control: Silence", description = "Sets the type of the Loss of Control alert. (0 = Off, 1 = Only Alert, 2 = Show Full Duration)", type = "number" },
	["lossOfControlInterrupt"] = { prettyName = "Loss of Control: Interrupt", description = "Sets the type of the Loss of Control alert. (0 = Off, 1 = Only Alert, 2 = Show Full Duration)", type = "number" },
	["lossOfControlDisarm"] = { prettyName = "Loss of Control: Disarm", description = "Sets the type of the Loss of Control alert. (0 = Off, 1 = Only Alert, 2 = Show Full Duration)", type = "number" },
	["lossOfControlRoot"] = { prettyName = "Loss of Control: Root", description = "Sets the type of the Loss of Control alert. (0 = Off, 1 = Only Alert, 2 = Show Full Duration)", type = "number" },
	["synchronizeMacros"] = { prettyName = "Synchronize Macros", description = "Toggles synchronizing Macros with the server on/off", type = "boolean" },
	["synchronizeConfig"] = { prettyName = "Synchronize Config", description = "Toggles synchronizing settings with the server on/off", type = "boolean" },
	["cursorsizepreferred"] = { prettyName = "Cursor Size", description = "0 = 32x32, 1 = 48x48, 2 = 64x64, -1 = autodetect", type = "number" },
	["ffxDeath"] = { prettyName = "FFX Death", description = "Enables full screen death effect", type = "boolean" },
	["WorldTextScale"] = { prettyName = "World Text Scale", description = "The scale of in-world damage numbers, xp gain, artifact gains, etc", type = "number" },


	-- 7.1.5 dump (1/16/17)
	["BrowserNavigateLog"] = { description = "Enables Logging of browser navigation requests (Requires /reload)" },
	--["CACHE-WGOB-GameObjectsHotfixCount"] = {},
	--["CACHE-WGOB-GameObjectsRecordCount"] = {},
	--["CACHE-WQST-QuestObjectiveHotfixCount"] = {},
	--["CACHE-WQST-QuestObjectiveRecordCount"] = {},
	--["CACHE-WQST-QuestObjectiveXEffectHotfixCount"] = {},
	--["CACHE-WQST-QuestObjectiveXEffectRecordCount"] = {},
	--["CACHE-WQST-QuestV2HotfixCount"] = {},
	--["CACHE-WQST-QuestV2RecordCount"] = {},
	["ChatMusicVolume"] = {},
	["CombatHealingAbsorbSelf"] = {},
	["DepthBasedOpacity"] = {},
	["DesktopGamma"] = {},
	-- ["EJDungeonDifficulty"] = { description = "Stores the last dungeon difficulty viewed in the encounter journal" },
	-- ["EJLootClass"] = { description = "Stores the last class that loot was filtered by in the encounter journal" },
	-- ["EJLootSpec"] = { description = "Stores the last spec that loot was filtered by in the encounter journal" },
	-- ["EJRaidDifficulty"] = { description = "Stores the last raid difficulty viewed in the encounter journal" },
	["EmitterCombatrange"] = { description = "Range to stop shoulder/weapon emissions during combat" },
	-- ["ErrorFilter"] = {},
	-- ["ErrorLevelMax"] = {},
	-- ["ErrorLevelMin"] = {},
	-- ["Errors"] = {},
	["FootstepSounds"] = { description = "play footstep sounds" },
	["Gamma"] = {},
	["LodLiquid"] = { description = "Render using lod liquid" },
	["M2ForceAdditiveParticleSort"] = { description = "force all particles to sort as though they were additive" },
	["M2UseInstancing"] = { description = "use hardware instancing" },
	["M2UseLOD"] = { description = "use model lod" },
	["M2UseThreads"] = { description = "multithread model animations" },
	["MSAAAlphaTest"] = { description = "Enable MSAA for alpha-tested geometry" },
	["MSAAQuality"] = { description = "Multisampling AA quality" },
	["MaxObservedPetBattles"] = { description = "Maximum number of observed pet battles" },
	["NameplatePersonalHideDelayAlpha"] = { description = "Determines the alpha of the personal nameplate after no visibility conditions are met (during the period of time specified by NameplatePersonalHideDelaySeconds)." },
	["NonEmitterCombatRange"] = { description = "Range to stop shoulder/weapon emissions outside combat" },
	["ObjectSelectionCircle"] = {},
	["OutlineEngineMode"] = {},
	-- ["Outline"] = { description="Outline Mode" }, -- don't know what this does aside from make you flash when it's set
	["POIShiftComplete"] = {},
	-- ["PraiseTheSun"] = {},
	["PushToTalkButton"] = { description = "String representation of the Push-To-Talk button." },
	["RAIDDepthBasedOpacity"] = {},
	["RAIDLightMode"] = {},
	["RAIDOutlineEngineMode"] = {},
	["RAIDSSAO"] = {},
	["RAIDSSAOBlur"] = {},
	["RAIDWaterDetail"] = {},
	["RAIDcomponentTextureLevel"] = {},
	["RAIDenvironmentDetail"] = {},
	["RAIDfarclip"] = {},
	["RAIDgraphicsQuality"] = {},
	["RAIDgroundEffectDensity"] = {},
	["RAIDgroundEffectDist"] = {},
	["RAIDgroundEffectFade"] = { description = "Raid Ground effect fade" },
	["RAIDhorizonStart"] = { description = "Raid Horizon start distance" },
	["RAIDlodObjectCullDist"] = {},
	["RAIDlodObjectCullSize"] = {},
	["RAIDlodObjectMinSize"] = {},
	["RAIDlodObjectFadeScale"] = {},
	["RAIDparticleDensity"] = {},
	["RAIDparticleMTDensity"] = {},
	["RAIDprojectedTextures"] = {},
	["RAIDreflectionMode"] = {},
	["RAIDrefraction"] = {},
	["RAIDrippleDetail"] = {},
	["RAIDsettingsEnabled"] = { description = "Raid graphic settings are available" },
	["RAIDsettingsInit"] = {},
	["RAIDshadowMode"] = {},
	["RAIDshadowSoft"] = {},
	["RAIDshadowTextureSize"] = {},
	["RAIDsunShafts"] = {},
	["RAIDterrainLodDist"] = {},
	["RAIDterrainMipLevel"] = {},
	["RAIDterrainTextureLod"] = {},
	["RAIDtextureFilteringMode"] = {},
	["RAIDweatherDensity"] = {},
	["RAIDwmoLodDist"] = {},
	["RAIDworldBaseMip"] = {},
	["RenderScale"] = { description = "Render scale (for supersampling or undersampling)" },
	["ResampleQuality"] = { description = "Resample quality" },
	["SSAO"] = {},
	["SSAOBlur"] = {},
	["SSAODistance"] = { description = "SSAO distance" },
	["SkyCloudLOD"] = {},
	["SoundPerf_VariationCap"] = { description = "Limit sound kit variations to cut down on memory usage and disk thrashing on 32-bit machines" },
	["SoundUseNewBusSystem"] = { description = "use the new bus structure or fallback to the old one" },
	["Sound_DSPBufferSize"] = { description = "sound buffer size, default 0" },
	["Sound_EnableArmorFoleySoundForOthers"] = {},
	["Sound_EnableArmorFoleySoundForSelf"] = {},
	["Sound_EnableMixMode2"] = {},
	["Sound_EnableMode2"] = {},
	["Sound_MaxCacheSizeInBytes"] = { description = "Max cache size in bytes" },
	["Sound_MaxCacheableSizeInBytes"] = { description = "Max sound size that will be cached, larger files will be streamed instead" },
	["Sound_NumChannels"] = {},
	["Sound_OutputDriverIndex"] = {},
	["Sound_OutputDriverName"] = {},
	["Sound_OutputSampleRate"] = { description = "output sample rate" },
	["Sound_VoiceChatInputDriverIndex"] = {},
	["Sound_VoiceChatInputDriverName"] = {},
	["Sound_VoiceChatOutputDriverIndex"] = {},
	["Sound_VoiceChatOutputDriverName"] = {},
	["SplineOpt"] = { description = "toggles use of spline coll optimization" },
	["StartTalkingDelay"] = {},
	["StartTalkingTime"] = {},
	["StopTalkingDelay"] = {},
	["StopTalkingTime"] = {},
	["TargetPriorityValueBank"] = { description = "Selects the active targeting values bank for calculating target priority order" },
	["VoiceChatMode"] = { description = "Push to talk(0) or voice activation(1)" },
	["VoiceChatSelfMute"] = { description = "Turn off your ability to talk." },
	["WorldTextCritScreenY"] = {},
	["WorldTextGravity"] = {},
	["WorldTextNonRandomZ"] = {},
	["WorldTextRampDuration"] = {},
	["WorldTextRampPow"] = {},
	["WorldTextRampPowCrit"] = {},
	["WorldTextRandomXY"] = {},
	["WorldTextRandomZMax"] = {},
	["WorldTextRandomZMin"] = {},
	["WorldTextScreenY"] = {},
	["WorldTextStartPosRandomness"] = {},
	-- ["accounttype"] = {},
	-- ["actionedAdventureJournalEntries"] = { description = "Which adventure journal entries flagged with ADVENTURE_JOURNAL_HIDE_AFTER_ACTION the user acted upon" },
	-- ["activeCUFProfile"] = { description = "The last active CUF Profile." },
	-- ["addFriendInfoShown"] = { description = "The info for Add Friend has been shown" },
	-- ["advJournalLastOpened"] = { description = "Last time the Adventure Journal opened" },
	-- ["agentUID"] = { description = "The UID provided by Battle.net to be passed to Agent" },
	["allowCompareWithToggle"] = {},
	["allowD3D9BackingStore"] = { description = "Allow D3D9 to have texture backing to decrease load times and increase the chance of an out of memory crash" },
	["animFrameSkipLOD"] = { description = "animations will skip frames at distance" },
	["asyncHandlerTimeout"] = { description = "Engine option: Async read main thread timeout" },
	["asyncThreadSleep"] = { description = "Engine option: Async read thread sleep" },
	["auctionDisplayOnCharacter"] = { description = "Show auction items on the dress-up paperdoll" },
	["audioLocale"] = { description = "Set the game locale for audio content" },
	["autoCompleteResortNamesOnRecency"] = { description = "Shows people you recently spoke with higher up on the AutoComplete list." },
	["autoCompleteUseContext"] = { description = "The system will, for example, only show people in your guild when you are typing /gpromote. Names will also never be removed." },
	["autoCompleteWhenEditingFromCenter"] = { description = "If you edit a name by inserting characters into the center, a smarter auto-complete will occur." },
	["autoDismount"] = { description = "Automatically dismount when needed" },
	-- ["autoFilledMultiCastSlots"] = { description = "Bitfield that saves whether multi-cast slots have been automatically filled." },
	-- ["autoQuestPopUps"] = { description = "Saves current pop-ups for quests that are automatically acquired or completed." },
	["autoStand"] = { description = "Automatically stand when needed" },
	["autoUnshift"] = { description = "Automatically leave shapeshift form when needed" },
	["autojoinBGVoice"] = { description = "Automatically join the voice session in battleground chat" },
	["autojoinPartyVoice"] = { description = "Automatically join the voice session in party/raid chat" },
	-- ["bloatTest"] = {},
	-- ["bloatnameplates"] = {},
	-- ["bloatthreat"] = {},
	["bodyQuota"] = { description = "Maximum number of componented bodies seen at once" },
	["breakUpLargeNumbers"] = { description = "Toggles using commas in large numbers" },
	["bspcache"] = { description = "BSP node caching" },
	["calendarShowBattlegrounds"] = { description = "Whether Battleground holidays should appear in the calendar" },
	["calendarShowDarkmoon"] = { description = "Whether Darkmoon Faire holidays should appear in the calendar" },
	["calendarShowLockouts"] = { description = "Whether raid lockouts should appear in the calendar" },
	["calendarShowResets"] = { description = "Whether raid resets should appear in the calendar" },
	["calendarShowWeeklyHolidays"] = { description = "Whether weekly holidays should appear in the calendar" },
	["cameraCustomViewSmoothing"] = {},
	["cameraDistanceMax"] = {},
	["cameraDistanceMaxFactor"] = {},
	["cameraDistanceRateMult"] = {},
	["cameraDive"] = {},
	["cameraHeightIgnoreStandState"] = {},
	["cameraPitchSmoothMax"] = {},
	["cameraPitchSmoothMin"] = {},
	["cameraPivotDXMax"] = {},
	["cameraPivotDYMin"] = {},
	-- ["cameraSavedDistance"] = {},
	-- ["cameraSavedPetBattleDistance"] = {},
	-- ["cameraSavedPitch"] = {},
	-- ["cameraSavedVehicleDistance"] = {},
	-- ["cameraView"] = {},
	["cameraYawSmoothMax"] = {},
	["cameraYawSmoothMin"] = {},
	["cameraZDamp"] = {},
	["cameraZoomSpeed"] = {},
	-- ["characterFrameCollapsed"] = {},
	["chatStyle"] = { description = "The style of Edit Boxes for the ChatFrame. Valid values: \"classic\", \"im\"" },
	["checkAddonVersion"] = {},
	["cloakFixEnabled"] = {},
	-- ["closedInfoFrames"] = { description = "Bitfield for which help frames have been acknowledged by the user" },
	["colorChatNamesByClass"] = { description = "If enabled, the name of a player speaking in chat will be colored according to his class." },
	["combatLogReducedRetentionTime"] = { description = "The maximum duration in seconds to retain combat log entries when we're low on memory" },
	["combatLogRetentionTime"] = { description = "The maximum duration in seconds to retain combat log entries" },
	["combatTextFloatMode"] = {},
	["componentCompress"] = { description = "Character component texture compression" },
	["componentEmissive"] = { description = "Character component unlit/emissive" },
	["componentSpecular"] = { description = "DISABLED FOR 7.0.3 - Character component specular highlights" },
	["componentTexCacheSize"] = { description = "Character component texture cache size (in MB)" },
	["componentTexLoadLimit"] = { description = "Character component texture loading limit per frame" },
	["componentTextureLevel"] = {},
	["componentThread"] = { description = "Multi thread character component processing" },
	-- ["currencyCategoriesCollapsed"] = { description = "Internal CVar for tracking collapsed currency categories." },
	-- ["currencyTokensBackpack1"] = { description = "Currency token types shown on backpack." },
	-- ["currencyTokensBackpack2"] = { description = "Currency token types shown on backpack." },
	-- ["currencyTokensUnused1"] = { description = "Currency token types marked as unused." },
	-- ["currencyTokensUnused2"] = { description = "Currency token types marked as unused." },
	["daltonize"] = { description = "Attempt to correct for color blindness (set colorblindSimulator to type of colorblindness)" },
	-- ["dangerousShipyardMissionWarningAlreadyShown"] = { description = "Boolean indicating whether the shipyard's dangerous mission warning has been shown" },
	-- ["debugSoundPlayerSpellsOnlyOnPlayerBus"] = {},
	["detailDoodadInstancing"] = { description = "Detail doodad instancing" },
	["digSites"] = { description = "If enabled, the archaeological dig site system will be used." },
	["disableAutoRealmSelect"] = { description = "Disable automatically selecting a realm on login" },
	["displayWorldPVPObjectives"] = { description = "Whether to show world PvP objectives" },
	-- ["displayedRAFFriendInfo"] = { description = "Stores whether we already told a recruited person about their new BattleTag friend" },
	["dontShowEquipmentSetsOnItems"] = { description = "Don't show which equipment sets an item is associated with" },
	["doodadLodDist"] = { description = "Doodad level of detail distance" },
	["doodadUnloadDist"] = {},
	["enableBGDL"] = { description = "Background Download (on async net thread) Enabled" },
	-- ["enableCombatText"] = {},
	["enablePVPNotifyAFK"] = { description = "The ability to shutdown the AFK notification system" },
	["enablePetBattleFloatingCombatText"] = { description = "Whether to show floating combat text for pet battles" },
	-- ["engineSurvey"] = {},
	["enterWorld"] = {},
	["entityLodDist"] = { description = "Entity level of detail distance" },
	["environmentDetail"] = {},
	["expandUpgradePanel"] = {},
	["farclip"] = {},
	["fctCombatState"] = {},
	-- ["fctFriendlyHealers"] = {},
	["ffxAntiAliasingMode"] = { description = "Anti Aliasing Mode" },
	["ffxRectangle"] = { description = "use rectangle texture for full screen effects" },
	-- ["flaggedTutorials"] = { description = "Internal cvar for saving completed tutorials in order" },
	["flightAngleLookAhead"] = { description = "Enables more dynamic attitude adjustments while flying" },
	-- ["floatingCombatTextCombatDamageStyle"] = { description = "No longer used" },
	["forceEnglishNames"] = {},
	["forceLODCheck"] = { description = "If enabled, we will skip checking DBC for LOD count and every m2 will scan the folder for skin profiles" },
	-- ["friendInvitesCollapsed"] = { description = "Whether friend invites are hidden in the friends list" },
	["friendsSmallView"] = { description = "Whether to use smaller buttons in the friends list" },
	["friendsViewButtons"] = { description = "Whether to show the friends list view buttons" },
	["fullDump"] = { description = "When you crash, generate a full memory dump" },
	["gameTip"] = {},
	["garrisonCompleteTalent"] = {},
	["garrisonCompleteTalentType"] = {},
	["graphicsDepthEffects"] = { description = "UI value of the graphics setting" },
	["graphicsEnvironmentDetail"] = {},
	["graphicsLightingQuality"] = { description = "UI value of the graphics setting" },
	["graphicsLiquidDetail"] = { description = "UI value of the graphics setting" },
	["graphicsOutlineMode"] = { description = "UI value of the graphics setting" },
	["graphicsParticleDensity"] = {},
	["graphicsProjectedTextures"] = { description = "UI value of the graphics setting" },
	["graphicsQuality"] = {},
	["graphicsSSAO"] = { description = "UI value of the graphics setting" },
	["graphicsShadowQuality"] = {},
	["graphicsSunshafts"] = { description = "UI value of the graphics setting" },
	["graphicsTextureFiltering"] = {},
	["graphicsTextureResolution"] = {},
	["graphicsViewDistance"] = {},
	["groundEffectDensity"] = {},
	["groundEffectDist"] = {},
	["groundEffectFade"] = { description = "Ground effect fade" },
	-- ["guildNewsFilter"] = { description = "Stores the guild news filters" },
	["guildRewardsCategory"] = { description = "Show category of guild rewards" },
	["guildRewardsUsable"] = { description = "Show usable guild rewards only" },
	-- ["guildRosterView"] = { description = "The current guild roster display mode" },
	["guildShowOffline"] = { description = "Show offline guild members in the guild UI" },
	["gxAFRDevicesCount"] = { description = "Force to set number of AFR devices" },
	["gxAdapter"] = { description = "Force to run the specified adapter index (-1 to let client choose)" },
	-- ["gxApi"] = {},
	["gxAspect"] = { description = "constrain window aspect" },
	["gxCursor"] = { description = "toggle hardware cursor" },
	["gxDepthResolveHandleCaching"] = { description = "Caching of the target handle for the depth resolve" },
	["gxFixLag"] = { description = "prevent cursor lag" },
	["gxFullscreenResolution"] = { description = "resolution" },
	["gxMaxFrameLatency"] = { description = "maximum number of frames ahead of GPU the CPU can be" },
	["gxMaximize"] = {},
	["gxMonitor"] = { description = "monitor" },
	["gxNewResolution"] = { description = "resolution to be set" },
	["gxPreferWindowedFullscreen"] = { description = "prefer which fullscreen mode for toggle" },
	-- ["gxRefresh"] = {},
	["gxStereoConvergence"] = { description = "Set stereoscopic rendering convergence depth" },
	["gxStereoEnabled"] = { description = "Enable stereoscopic rendering" },
	["gxStereoSeparation"] = { description = "Set stereoscopic rendering separation percentage" },
	["gxTextureCacheSize"] = { description = "GX Texture Cache Size" },
	["gxTripleBuffer"] = { description = "triple buffer" },
	["gxVSync"] = { description = "vsync on or off" },
	["gxWindow"] = {},
	["gxWindowedResolution"] = {},
	-- ["hardTrackedQuests"] = { description = "Internal cvar for saving hard (user manually selected) tracked quests in order" },
	-- ["hardTrackedWorldQuests"] = { description = "Internal cvar for saving hard tracked world quests" },
	["hbaoBias"] = { description = "HBAO Bias" },
	["hbaoBlurSharp"] = { description = "HBAO Blur Sharpness" },
	["hbaoNormals"] = { description = "Use Normals for HBAO" },
	["hbaoPowerExp"] = { description = "HBAO Power Exponent" },
	["hbaoRadius"] = { description = "HBAO Radius" },
	-- ["heirloomCollectedFilters"] = { description = "Bitfield for which collected filters are applied in the heirloom journal" },
	-- ["heirloomSourceFilters"] = { description = "Bitfield for which source filters are applied in the heirloom journal" },
	["hideAdventureJournalAlerts"] = { description = "Hide alerts shown on the Adventure Journal Microbutton" },
	["horizonStart"] = {},
	["hotReloadModels"] = { description = "Allow an active model to be reloaded when a new version is detected in the bin folder. If this is disabled, the model data will only be refreshed after all game objects using the model are deleted" },
	["hwDetect"] = {},
	["hwPCF"] = { description = "Hardware PCF Filtering" },
	["incompleteQuestPriorityThresholdDelta"] = {},
	["initialRealmListTimeout"] = { description = "How long to wait for the initial realm list before failing login (in seconds)" },
	["installLocale"] = {},
	--["installType"] = {},
	-- ["lastAddonVersion"] = {},
	-- ["lastCharacterIndex"] = {},
	-- ["lastGarrisonMissionTutorial"] = { description = "Stores the last garrison mission tutorial the player has accepted" },
	-- ["lastReadEULA"] = {},
	-- ["lastReadTOS"] = {},
	-- ["lastReadTerminationWithoutNotice"] = {},
	-- ["lastTalkedToGM"] = { description = "Stores the last GM someone was talking to in case they reload the UI while the GM chat window is open." },
	-- ["lastTransmogOutfitID"] = { description = "SetID of the last loaded transmog outfit" },
	-- ["lastVoidStorageTutorial"] = { description = "Stores the last void storage tutorial the player has accepted" },
	["launchAgent"] = { description = "Set this to have the client start up Agent" },
	-- ["lfGuildComment"] = { description = "Stores the player's Looking For Guild comment" },
	-- ["lfGuildSettings"] = { description = "Bit field of Looking For Guild player settings" },
	-- ["lfdCollapsedHeaders"] = { description = "Stores which LFD headers are collapsed." },
	-- ["lfdSelectedDungeons"] = { description = "Stores which LFD dungeons are selected." },
	["lfgAutoFill"] = { description = "Whether to automatically add party members while looking for a group" },
	["lfgAutoJoin"] = { description = "Whether to automatically join a party while looking for a group" },
	-- ["lfgListSearchLanguages"] = { description = "A simple bitfield for what languages we want to search in." },
	-- ["lfgSelectedRoles"] = { description = "Stores what roles the player is willing to take on." },
	["lightMode"] = {},
	["locale"] = { description = "Set the game locale" },
	["lockedWorldMap"] = { description = "Whether the world map is locked when sized down" },
	["lodObjectCullDist"] = {},
	["lodObjectCullSize"] = {},
	["lodObjectMinSize"] = {},
	["lodTerrainDiv"] = { description = "Terrain lod divisor" },
	["mapAnimDuration"] = { description = "Duration for the alpha animation" },
	["mapAnimMinAlpha"] = { description = "Alpha value to animate to when player moves with windowed world map open" },
	["mapAnimStartDelay"] = { description = "Start delay for the alpha animation" },
	["mapQuestDifficulty"] = {},
	-- ["maxAnimThreads"] = {},
	["maxFPS"] = { description = "Set FPS limit" },
	["maxFPSBk"] = { description = "Set background FPS limit" },
	["maxLightCount"] = { description = "Maximum lights to render" },
	["maxLightDist"] = { description = "Maximum distance to render lights" },
	["miniWorldMap"] = { description = "Whether or not the world map has been toggled to smaller size" },
	["minimapAltitudeHintMode"] = { description = "Change minimap altitude difference display. 0=none, 1=darken, 2=arrows" },
	["minimapInsideZoom"] = { description = "The current indoor minimap zoom level" },
	["minimapPortalMax"] = { description = "Max Number of Portals to traverse for minimap" },
	-- ["minimapShapeshiftTracking"] = { description = "Stores shapeshift-specific tracking spells that were active last session." },
	["minimapShowArchBlobs"] = { description = "Stores whether to show archaeology blobs on the minimap." },
	["minimapShowQuestBlobs"] = { description = "Stores whether to show the quest blobs on the minimap." },
	-- ["minimapTrackedInfo"] = {},
	-- ["minimapTrackedInfov2"] = { description = "Stores the minimap tracking that was active last session." },
	["minimapZoom"] = { description = "The current outdoor minimap zoom level" },
	["missingTransmogSourceInItemTooltips"] = { description = "Whether to show if you have collected the appearance of an item but not from that item itself" },
	-- ["mountJournalFilters"] = { description = "Bitfield for which collected filters are applied in the mount journal" },
	-- ["mountJournalSourceFilters"] = { description = "Bitfield for which source filters are applied in the mount journal" },
	["mouseInvertYaw"] = {},
	["mtParticles"] = { description = "multithread building of particle vertices" },
	["nameplateMotionSpeed"] = { description = "Controls the rate at which nameplate animates into their target locations [0.0-1.0]" },
	["nameplateShowEnemyMinions"] = {},
	["nameplateShowFriendlyMinions"] = {},
	["nearclip"] = { description = "Near clip plane distance" },
	-- ["orderHallMissionTutorial"] = { description = "Stores information about which order hall mission tutorials the player has seen" },
	["outdoorMinAltitudeDistance"] = { description = "Minimum altitude distance for outdoor objects when you are also outdoors before the altitude difference marker displays" },
	["outlineMouseOverFadeDuration"] = {},
	["outlineSelectionFadeDuration"] = {},
	["overrideArchive"] = { description = "Whether or not the client loads alternate data" },
	["particleDensity"] = {},
	["particleMTDensity"] = {},
	["partyBackgroundOpacity"] = { description = "The opacity of the party background" },
	["pathSmoothing"] = { description = "NPC will round corners on ground paths" },
	-- ["pendingInviteInfoShown"] = { description = "The info for pending invites has been shown" },
	-- ["petJournalFilters"] = { description = "Bitfield for which collected filters are applied in the pet journal" },
	-- ["petJournalSort"] = { description = "Sorting value for the pet journal" },
	-- ["petJournalSourceFilters"] = { description = "Bitfield for which source filters are applied in the pet journal" },
	-- ["petJournalTab"] = { description = "Stores the last tab the pet journal was opened to" },
	-- ["petJournalTypeFilters"] = { description = "Bitfield for which type filters are applied in the pet journal" },
	["physicsLevel"] = { description = "Level of physics world interaction" },
	["playIntroMovie"] = {},
	--["playerStatLeftDropdown"] = { description = "The player stat selected in the left dropdown" },
	--["playerStatRightDropdown"] = { description = "The player stat selected in the right dropdown" },
	-- ["portal"] = { description = "Name of Battle.net portal to use" },
	["predictedHealth"] = { description = "Whether or not to use predicted health values in the UI" },
	["preloadLoadingDistObject"] = { description = "Object preload distance when loading" },
	["preloadLoadingDistTerrain"] = { description = "Terrain preload distance when loading" },
	["preloadPlayerModels"] = { description = "Preload all local racial models into memory" },
	["preloadStreamingDistObject"] = { description = "Object preload distance when streaming" },
	["preloadStreamingDistTerrain"] = { description = "Terrain preload distance when streaming" },
	["primaryProfessionsFilter"] = { description = "If enabled, primary profession world quests icons will be shown on world maps" },
	["processAffinityMask"] = { description = "Sets which core(s) WoW may execute on - changes require restart to take effect" },
	["projectedTextures"] = {},
	["pvpBlacklistMaps0"] = { description = "Blacklist PVP Map" },
	["pvpBlacklistMaps1"] = { description = "Blacklist PVP Map" },
	-- ["pvpSelectedRoles"] = { description = "Stores what roles the player will fulfill in a BG." },
	-- ["questLogCollapseFilter"] = {},
	-- ["questLogCollapseHeaderFilter"] = {},
	-- ["questLogOpen"] = { description = "Whether the quest log appears the side of the windowed map. " },
	["questPOI"] = { description = "If enabled, the quest POI system will be used." },
	["raidFramesDisplayAggroHighlight"] = { description = "Whether to display aggro highlights on Raid Frames" },
	["raidFramesDisplayClassColor"] = { description = "Colors raid frames with the class color" },
	["raidFramesDisplayOnlyDispellableDebuffs"] = { description = "Whether to display only dispellable debuffs on Raid Frames" },
	["raidFramesDisplayPowerBars"] = { description = "Whether to display mana, rage, etc. on Raid Frames" },
	["raidFramesHealthText"] = { description = "How to display health text on the raid frames" },
	["raidFramesHeight"] = { description = "The height of the individual raid frames" },
	["raidFramesPosition"] = { description = "Where the raid frames should be placed" },
	["raidFramesWidth"] = { description = "The width of the individual raid frames" },
	["raidGraphicsDepthEffects"] = {},
	["raidGraphicsEnvironmentDetail"] = {},
	["raidGraphicsGroundClutter"] = {},
	["raidGraphicsLightingQuality"] = {},
	["raidGraphicsLiquidDetail"] = {},
	["raidGraphicsOutlineMode"] = {},
	["raidGraphicsParticleDensity"] = {},
	["raidGraphicsProjectedTextures"] = {},
	["raidGraphicsSSAO"] = {},
	["raidGraphicsShadowQuality"] = {},
	["raidGraphicsSunshafts"] = {},
	["raidGraphicsTextureFiltering"] = {},
	["raidGraphicsTextureResolution"] = {},
	["raidGraphicsViewDistance"] = {},
	["raidOptionDisplayMainTankAndAssist"] = { description = "Whether to display main tank and main assist units in the raid frames" },
	["raidOptionDisplayPets"] = { description = "Whether to display pets on the raid frames" },
	["raidOptionIsShown"] = { description = "Whether the Raid Frames are shown" },
	["raidOptionKeepGroupsTogether"] = { description = "The way to group raid frames" },
	["raidOptionLocked"] = { description = "Whether the raid frames are locked" },
	["raidOptionShowBorders"] = { description = "Displays borders around the raid frames." },
	["raidOptionSortMode"] = { description = "The way to sort raid frames" },
	["raidOrBattleCount"] = {},
	["rawMouseAccelerationEnable"] = { description = "Enable acceleration for raw mouse input" },
	["rawMouseEnable"] = { description = "Enable raw mouse input" },
	["rawMouseRate"] = { description = "Raw mouse update rate" },
	["rawMouseResolution"] = { description = "Raw mouse resolution" },
	--["readContest"] = {},
	--["readEULA"] = {},
	--["readScanning"] = {},
	--["readTOS"] = {},
	--["readTerminationWithoutNotice"] = {},
	-- ["realmName"] = {},
	["reflectionDownscale"] = { description = "Reflection downscale" },
	["reflectionMode"] = {},
	["refraction"] = {},
	["repositionfrequency"] = {},
	-- ["reputationsCollapsed"] = { description = "List of reputation categories that have been collapsed in the Reputation tab" },
	["rippleDetail"] = {},
	["sceneOcclusionEnable"] = { description = "Scene software occlusion" },
	["screenshotFormat"] = {},
	["screenshotQuality"] = {},
	["scriptProfile"] = { description = "Whether or not script profiling is enabled" },
	["scriptWarnings"] = { description = "Whether or not the UI shows Lua warnings" },
	["secondaryProfessionsFilter"] = { description = "If enabled, secondary profession world quests icons will be shown on world maps" },
	-- ["seenAsiaCharacterUpgradePopup"] = { description = "Seen the free character upgrade popup (Asia)" },
	-- ["seenCharacterUpgradePopup"] = {},
	-- ["serverAlert"] = { description = "Get the glue-string tag for the URL" },
	-- ["serviceTypeFilter"] = { description = "Which trainer services to show" },
	["shadowCull"] = { description = "enable shadow frustum culling" },
	["shadowInstancing"] = { description = "enable instancing when rendering shadowmaps" },
	["shadowMode"] = {},
	["shadowScissor"] = { description = "enable scissoring when rendering shadowmaps" },
	["shadowSoft"] = {},
	["shadowTextureSize"] = {},
	-- ["shipyardMissionTutorialAreaBuff"] = { description = "Stores whether the player has accepted the first area buff mission tutorial" },
	-- ["shipyardMissionTutorialBlockade"] = { description = "Stores whether the player has accepted the first blockade mission tutorial" },
	-- ["shipyardMissionTutorialFirst"] = { description = "Stores whether the player has accepted the first mission tutorial" },
	["showAllEnemyDebuffs"] = {},
	["showArtifactXPBar"] = { description = "Show the artifact xp as priority over reputation" },
	["showBattlefieldMinimap"] = { description = "Whether or not the battlefield minimap is shown" },
	["showBuilderFeedback"] = { description = "Show animation when building power for builder/spender bar" },
	["showErrors"] = {},
	["showKeyring"] = {},
	["showNPETutorials"] = { description = "display NPE tutorials" },
	["showNewbieTips"] = {},
	["showQuestObjectivesOnMap"] = { description = "Shows quest POIs on the main map." },
	["showQuestTrackingTooltips"] = { description = "Displays quest tracking information in unit and object tooltips" },
	["showSpectatorTeamCircles"] = { description = "Determines if the team color circles are visible while spectating or commentating a wargame" },
	["showTamers"] = { description = "If enabled, pet battle icons will be shown on world maps" },
	["showTimestamps"] = { description = "The format of timestamps in chat or \"none\"" },
	-- ["showTokenFrame"] = { description = "The token UI has been shown" },
	-- ["showTokenFrameHonor"] = { description = "The token UI has shown Honor" },
	-- ["showToolsUI"] = {},
	["showfootprintparticles"] = { description = "toggles rendering of footprint particles" },
	["simd"] = { description = "Enable SIMD features (e.g. SSE)" },
	["skipStartGear"] = { description = "Whether we should show starter gear on character create" },
	["smoothUnitPhasing"] = { description = "The client will try to smoothly switch between the same on model different phases." },
	["smoothUnitPhasingActorPurgatoryTimeMs"] = { description = "Time to keep client-actor displays in purgatory before letting go of them, if they were despawned" },
	["smoothUnitPhasingAliveTimeoutMs"] = { description = "Time to wait for an alive unit to get it's despawn message" },
	["smoothUnitPhasingDestroyedPurgatoryTimeMs"] = { description = "Time to keep unit displays in purgatory before letting go of them, if they were destroyed" },
	["smoothUnitPhasingDistThreshold"] = { description = "Distance threshold to active smooth unit phasing." },
	["smoothUnitPhasingEnableAlive"] = { description = "Use units that have not despawn yet if they match, in hopes the despawn message will come later." },
	["smoothUnitPhasingUnseenPurgatoryTimeMs"] = { description = "Time to keep unit displays in purgatory before letting go of them, if they were just unseen." },
	["smoothUnitPhasingVehicleExtraTimeoutMs"] = { description = "Extra time to wait before releasing a vehicle, after it has smooth phased. This allows it's passengers to smooth phase as well." },
	["spellBookSort"] = {},
	["spellClutter"] = { description = "Enables/Disables spell clutter" },
	["spellClutterDefaultTargetScalar"] = { description = "Starting target scalar value (min 0.1)" },
	["spellClutterHostileScalar"] = { description = "Scalar we apply to the hostile creature spells (min 0.001)" },
	["spellClutterMinSpellCount"] = { description = "Min spells on a target before we apply clutter logic (min 0)" },
	["spellClutterPartySizeScalar"] = { description = "Scales the targetScalar by how different the party size is from this (min 1)" },
	["spellClutterPlayerScalarMultiplier"] = { description = "Increases number of effects on \"interesting\" targets multiplicatively (min 0.1)" },
	["spellClutterRangeConstant"] = { description = "How many yards before the priority is doubled (min 1.0)" },
	["splashScreenBoost"] = { description = "Show boost splash screen id " },
	["splashScreenNormal"] = { description = "Show normal splash screen id" },
	-- ["statCategoriesCollapsed"] = {},
	-- ["statCategoriesCollapsed_2"] = {},
	-- ["statCategoryOrder"] = {},
	-- ["statCategoryOrder_2"] = {},
	["streamBeams"] = { description = "Use vertex streaming for beams (Gfx Driver Workaround). 0=Auto Detect, 1=Never Stream, 2=Always Stream" },
	["streamStatusMessage"] = { description = "Whether to display status messages while streaming content" },
	["streamingCameraLookAheadTime"] = { description = "Look ahead time for streaming." },
	["streamingCameraMaxRadius"] = { description = "Max radius of the streaming camera." },
	["streamingCameraRadius"] = { description = "Base radius of the streaming camera." },
	["sunShafts"] = {},
	["superTrackerDist"] = {},
	["synchronizeBindings"] = {},
	["synchronizeChatFrames"] = {},
	["synchronizeSettings"] = { description = "Whether client settings should be stored on the server" },
	["taintLog"] = {},
	-- ["talentFrameShown"] = { description = "The talent UI has been shown" },
	["talentPointsSpent"] = { description = "The player has spent a talent point" },
	["targetOfTargetMode"] = { description = "The conditions under which target of target should be shown" },
	["terrainAlphaBitDepth"] = { description = "Terrain alpha map bit depth" },
	["terrainHoles"] = { description = "Terrain holes affect occlusion" },
	["terrainLodDist"] = {},
	["terrainMipLevel"] = {},
	["terrainTextureLod"] = {},
	["test_cameraDynamicPitch"] = { description = "ActionCam" },
	["test_cameraDynamicPitchBaseFovPad"] = { description = "ActionCam" },
	["test_cameraDynamicPitchBaseFovPadDownScale"] = { description = "ActionCam" },
	["test_cameraDynamicPitchBaseFovPadFlying"] = { description = "ActionCam" },
	["test_cameraDynamicPitchSmartPivotCutoffDist"] = { description = "ActionCam" },
	["test_cameraHeadMovementDeadZone"] = { description = "ActionCam" },
	["test_cameraHeadMovementFirstPersonDampRate"] = { description = "ActionCam" },
	["test_cameraHeadMovementMovingDampRate"] = { description = "ActionCam" },
	["test_cameraHeadMovementMovingStrength"] = { description = "ActionCam" },
	["test_cameraHeadMovementRangeScale"] = { description = "ActionCam" },
	["test_cameraHeadMovementStandingDampRate"] = { description = "ActionCam" },
	["test_cameraHeadMovementStandingStrength"] = { description = "ActionCam" },
	["test_cameraHeadMovementStrength"] = { description = "ActionCam" },
	["test_cameraLockedTargetFocusing"] = { description = "ActionCam" },
	["test_cameraOverShoulder"] = { description = "ActionCam" },
	["test_cameraTargetFocusEnemyEnable"] = { description = "ActionCam" },
	["test_cameraTargetFocusEnemyStrengthPitch"] = { description = "ActionCam" },
	["test_cameraTargetFocusEnemyStrengthYaw"] = { description = "ActionCam" },
	["test_cameraTargetFocusInteractEnable"] = { description = "ActionCam" },
	["test_cameraTargetFocusInteractStrengthPitch"] = { description = "ActionCam" },
	["test_cameraTargetFocusInteractStrengthYaw"] = { description = "ActionCam" },
	["textLocale"] = { description = "Set the game locale for text" },
	["textureFilteringMode"] = {},
	["threatWarning"] = { description = "Whether or not to show threat warning UI (0 = off, 1 = in dungeons, 2 = in party/raid, 3 = always)" },
	["threatWorldText"] = { description = "Whether or not to show threat floaters in combat" },
	["timeMgrAlarmEnabled"] = { description = "Toggles whether or not the time manager's alarm will go off" },
	["timeMgrAlarmMessage"] = { description = "The time manager's alarm message" },
	["timeMgrAlarmTime"] = { description = "The time manager's alarm time in minutes" },
	["timeMgrUseLocalTime"] = { description = "Toggles the use of either the realm time or your system time" },
	["timeMgrUseMilitaryTime"] = { description = "Toggles the display of either 12 or 24 hour time" },
	["timingMethod"] = { description = "Desired method for game timing" },
	-- ["timingTestError"] = { description = "Error reported by the timing validation system" }, -- read-only
	-- ["toyBoxCollectedFilters"] = { description = "Bitfield for which collected filters are applied in the toybox" },
	-- ["toyBoxSourceFilters"] = { description = "Bitfield for which source filters are applied in the toybox" },
	-- ["trackedAchievements"] = { description = "Internal cvar for saving tracked achievements in order" },
	-- ["trackedQuests"] = { description = "Internal cvar for saving automatically tracked quests in order" },
	-- ["trackedWorldQuests"] = { description = "Internal cvar for saving tracked world quests" },
	-- ["trackerFilter"] = {},
	-- ["trackerSorting"] = {},
	["transmogCurrentSpecOnly"] = { description = "Stores whether transmogs apply to current spec instead of all specs" },
	-- ["transmogrifyShowCollected"] = { description = "Whether to show collected transmogs in the at the transmogrifier" }, -- read-only
	-- ["transmogrifyShowUncollected"] = { description = "Whether to show uncollected transmogs in the at the transmogrifier" }, -- read-only
	-- ["transmogrifySourceFilters"] = { description = "Bitfield for which source filters are applied in the wardrobe at the transmogrifier" },
	["twitterCharactersPerMedia"] = { description = "Number of characters needed when attaching media to a Twitter post" },
	-- ["twitterGetConfigTime"] = { description = "Last time that we got Twitter configuration data successfully" },
	["twitterShortUrlLength"] = { description = "Number of characters that non-https URLS get shortened to" },
	["twitterShortUrlLengthHttps"] = { description = "Number of characters that https URLS get shortened to" },
	["uiScale"] = {},
	["uiScaleMultiplier"] = { description = "A multiplier for the default UI scale. -1=determine based on system/monitor DPI, 0.5-2.0=multiplier to use when calculating UI scale. Only applied when useUIScale is 0." },
	["unitHighlights"] = { description = "Whether the highlight circle around units should be displayed" },
	["useCompactPartyFrames"] = { description = "Use the new raid frames for parties" },
	["useUiScale"] = {},
	["videoOptionsVersion"] = {},
	-- ["wardrobeShowCollected"] = { description = "Whether to show collected transmogs in the wardrobe" }, -- read-only
	-- ["wardrobeShowUncollected"] = { description = "Whether to show uncollected transmogs in the wardrobe" }, -- read-only
	-- ["wardrobeSourceFilters"] = { description = "Bitfield for which source filters are applied in the wardrobe in the collection journal" },
	["warp"] = { description = "UI value of the graphics setting" },
	["warpScreenSize"] = { description = "Physical monitor size" },
	["warpViewDistance"] = { description = "Physical distance from the viewer to the monitor" },
	["warpViewTilt"] = { description = "Angle of the side monitors IN RADIANS" },
	["watchFrameBaseAlpha"] = { description = "Objectives frame opacity." },
	-- ["watchFrameState"] = { description = "Stores Objectives frame locked and collapsed states" },
	["waterDetail"] = {},
	["weatherDensity"] = {},
	["webChallengeURLTimeout"] = { description = "How long to wait for the web challenge URL (in seconds). 0 means wait forever." },
	["whisperMode"] = { description = "The action new whispers take by default: \"popout\", \"inline\", \"popout_and_inline\"" },
	["windowResizeLock"] = { description = "prevent resizing in windowed mode" },
	["wmoDoodadDist"] = { description = "Wmo doodad load distance" },
	["wmoLodDist"] = {},
	["worldBaseMip"] = {},
	["worldLoadSort"] = { description = "Sort objects by distance when loading" },
	["worldMapOpacity"] = { description = "Opacity for the world map when sized down" },
	["worldMaxMipLevel"] = { description = "World maximum texture mip level" },
	["worldPoolUsage"] = { description = "Usage static/dynamic/stream" },
	["worldPreloadHighResTextures"] = { description = "Require high res textures to be loaded in streaming non critical radius when preloading" },
	["worldPreloadNonCritical"] = { description = "Require objects to be loaded in streaming non critical radius when preloading" },
	["worldPreloadSort"] = { description = "Sort objects by distance when preloading" },
	["worldQuestFilterArtifactPower"] = { description = "If enabled, world quests with artifact power rewards will be shown on the map" },
	["worldQuestFilterEquipment"] = { description = "If enabled, world quests with equipment rewards will be shown on the map" },
	["worldQuestFilterGold"] = { description = "If enabled, world quests with gold rewards will be shown on the map" },
	["worldQuestFilterOrderResources"] = { description = "If enabled, world quests with order resource rewards will be shown on the map" },
	["worldQuestFilterProfessionMaterials"] = { description = "If enabled, world quests with profession material rewards will be shown on the map" },
	["CastTimingEnhancements"] = { prettyName = nil, description = "Hold chain precasts, and predict anim timed casts", type = "boolean" },
	["autoAcceptQuickJoinRequests"] = { prettyName = "Auto-accept quick join requests", description = "", type = "boolean" },
	
	["AimingStrafeLeftUsesMoveBackwards"] = { description = "Uses backwards move anim when aiming a ranged weapon and strafing to the left" },
	["DebugTorsoTwist"] = { description = "Debug visualization for Torso Twist: 1 = Player, 2 = Target, 3 = All" },
	
	["lodObjectFadeScale"] = {},
}

local CategoryNames = { -- not sure how meaningful these really are (/Blizzard_Console/Blizzard_Console_AutoComplete.lua Enum.ConsoleCategory)
	[0] = "Debug",
	[1] = "Graphics",
	[2] = "Console",
	[3] = "Combat",
	[4] = "Game",
	[5] = "Default",
	[6] = "Net",
	[7] = "Sound",
	[8] = "GM",
	[9] = "None",
}

--[[
	C_Console.GetAllCommands() returns a list of tables in this format:
		category: number from 0 to 9 representing a category above
		command: cvar name
		commandType: 0 seems to represent a cvar, 1 is a script command (like quit)
		help: cvar description text
--]]

for _, info in pairs(C_Console.GetAllCommands()) do
	if not addon.hiddenOptions[info.command]
	  and info.commandType == 0 -- cvar, rather than script
	  and info.category ~= 0 -- ignore debug category
	  and not strfind(info.command:lower(), 'debug') -- a number of commands with "debug" in their name are inexplicibly not in the "debug" category
	  and info.category ~= 8 -- ignore GM category
	then
		local value = GetCVar(info.command)
		local optionTable = {
			-- prettyName = info.command, -- the api doesn't provide pretty names, so the only way to keep these would be to create a table for them
			description = info.help,		
		}
		addon.hiddenOptions[info.command] = optionTable
	end
end


-- Allow case-insensitive lookup of cvars in our table (relatively slow, so match the case when possible)
local NoCase = {
	__index = function(t, mk) -- get
		if mk and mk.lower then
			local mk = mk:lower()
			for k,v in pairs(t) do
				if k:lower() == mk then
					return v
				end
			end
		end
	end,
	__newindex = function(t, mk, mv) -- set
		if mk and mk.lower then
			local mk = mk:lower()
			for k,v in pairs(t) do
				if k:lower() == mk then
					t[k] = mv
					return
				end
			end
		end
	end,
}
setmetatable(addon.hiddenOptions, NoCase)
