-- Achievement Checker 0.1.9
--
-- Syntax: /ac [Emblematic]
-- Will check raid members for the completion of a linked achievement and display in a readycheck view.
-- Biggest drawback is that it needs somewhere between inspectionrange and zonerange to check the other players
-- Reporting will be done to raidchat for now.
-- Starting point for this addon was taken from oRA2's ready check, so credits to the oRA2 team.
-- author: Zblob (Zblob at telenet.be)

-- TODO
-- Localisation
-- Partial achievements (info isn't given in Comparing Achievement API though)
-- Reporting to other channels
-- More freedom in how to give the ach parameter (id, text, ..)

-- Changelog

-- 0.1.9
-- Toc Update for 7.3.5

-- 0.1.8
-- Toc Update for 7.1.0

-- 0.1.7
-- Toc Update for 6.2.3

-- 0.1.6
-- Toc Update for 6.0.2

-- 0.1.5
-- Toc Update for 5.4

-- 0.1.4.1
-- Added a link to the achievement in the report

-- 0.1.4
-- Updated for MoP
-- Fixed a Lua error when giving a textual parameter instead of an achievementid or achievementlink

-- 0.1.3
-- toc update to 4.2
-- Fix for missing pointer

-- 0.1.2
-- toc update to gameversion 4.0
-- Fixed references to "this:"
-- Added support for non-raid groups
-- Added functionality to call /ac with the achievementidnumber (thanks to Lefaux@Sen'jin EU for the tip)



SLASH_ACHCHECK1, SLASH_ACHCHECK2 = '/ac', '/achievementcheck'
function SlashCmdList.ACHCHECK(msg, editbox)
	PerformCheck(msg)
end


local frame, timer, timeout, checktimer, achid, achname, raidid, events, curraider, groupstatus, totalplayers = "", 0, 3, false, 1, "", 1, {}, "", 0, 0

local new, del
do
	local cache = setmetatable({},{__mode="k"})
	function new(...)
		local t = next(cache)
		if t then
			cache[t] = nil
			for i = 1, select("#", ...) do
				table.insert(t, (select(i, ...)))
			end
			return t
		else
			return {...}
		end
	end
	function del(t)
		if type(t) == "table" then
			for k, v in pairs(t) do
				if type(v) == "table" then
					v = del(v)
				end
				t[k] = nil
			end
			cache[t] = true
		end
		return nil
	end
end

function ACUpdateReport()
	local text = ""
	local i = 0
	for name, state in pairs(achres) do
		i = i + 1
		if i == 21 then text = "" end
		
		if state == "no reply" then
			text = text .. "|c00CCCCCC" .. name .. "|r\n"
		elseif state == "offline" then
			text = text .. "|c00FFFFFF" .. name .. "|r\n"
		elseif state == "timeout" then
			text = text .. "|c00FFFFFF" .. name .. "|r\n"
		elseif state == "not complete" then
			text = text .. "|c00FF0000" .. name .. "|r\n"
		else
			text = text .. "|c0000FF00" .. name .. "|r\n"
		end
		
		if i <= 20 then frame.leftinfo:SetText(text)
		else frame.rightinfo:SetText(text) end
	end
end


function ACCheckClose()
	frame:Hide()
end

function ACCheckReport()
	local chat, nytext, ctext, nctext, nrtext = "raid", "","","",""
	local i = 0
	for name, state in pairs(achres) do
		i = i + 1
		
		if state == "no reply" then
			nytext = nytext .. name ..  " "
		elseif state == "offline" then
			nrtext = nrtext .. name ..  " "
		elseif state == "timeout" then
			nrtext = nrtext .. name ..  " "
		elseif state == "not complete" then
			nctext = nctext .. name ..  " "
		else
			ctext = ctext .. name ..  " "
		end
	end

	if groupstatus == 1 then chat = "party" end
	if groupstatus ~= 0 then
		SendChatMessage("[AC] Achievement Check Report for: ".. GetAchievementLink(achid), chat, mylang,"");
		SendChatMessage("[AC] Completed: ".. ctext, chat, mylang,"");
		SendChatMessage("[AC] Not Completed: ".. nctext, chat, mylang,"");
		SendChatMessage("[AC] No reply: ".. nrtext, chat, mylang,"");
	end
	
end


function PerformCheck(achievement)
	if not achievement or achievement == "" then print("[AC] No achievement parameter linked") return end;
	
	-- Addition from Lefaux@Sen'jin EU
 	-- used to access the achievement not by click on the achievement but rather via its ID (handy with macros)
	local id
	if tonumber(achievement) ~= nil then
		id = tonumber(achievement)
	else
		ach = achievement
		id = ach:match( "^achievement:(%d+)" ) or ach:match( "|Hachievement:(%d+)" )
	end
	if id == nil then print("[AC] No achievement parameter linked") return end;
	
	achres = del(achres)
	achres = new()

	if IsInRaid()
	-- In raid
	then groupstatus = 2
		 totalplayers = GetNumGroupMembers()
		 for i = 1, totalplayers, 1 do
			 local name, _, _, _, _, _, _, _ = GetRaidRosterInfo(i)
			 achres[name] = "no reply"
		end
	else if IsInGroup()
	-- In party
		then groupstatus = 1
			 totalplayers = GetNumSubgroupMembers()
			 for i = 1, totalplayers, 1 do
				local name = GetUnitName("party"..i)
				achres[name] = "no reply"
			 end
		else 
	-- Solo
			groupstatus = 0
			 totalplayers = 1
			 achres[UnitName("player")] = "no reply"
		end
	end
			

	frame.leftinfo:SetText("")
	frame.rightinfo:SetText("")
	frame.closebuttontext:SetText("Close")
	frame.closebutton:SetScript("OnClick", ACCheckClose)
	frame.reportbuttontext:SetText("Report")
	frame.reportbutton:SetScript("OnClick", ACCheckReport)

	--local id = ach:match( "^achievement:(%d+)" ) or ach:match( "|Hachievement:(%d+)" )
	achid = id
	local _, name, _, completed, _, _, _, _, _, _, _ = GetAchievementInfo(id)
	frame.rheader:SetText("Achievement Check:\n "..name)
	achname = name;

	frame:Show()

	if completed then achres[UnitName("player")] = "complete" else achres[UnitName("player")] = "not complete" end
	ACUpdateReport()
	raidid = 1
	ACCheckNextPlayer()

end

function events:INSPECT_ACHIEVEMENT_READY(unit, event)
	frame:UnregisterEvent("INSPECT_ACHIEVEMENT_READY")
	local ccompleted, cmonth, cday, cyear = GetAchievementComparisonInfo(achid)
	ClearAchievementComparisonUnit()
	if ccompleted then achres[curraider] = "complete" else achres[curraider] = "not complete" end
	ACUpdateReport()
	checktimer = false
	raidid = raidid + 1
	ACCheckNextPlayer()
end


-- Event Handler
function EventHandler(self,event,...)
	if (events[event]) then
		events[event](self,event,...)
	end
end


function ACCheckNextPlayer()
	local rname, unit, online = "", "", 0
	if raidid <= totalplayers then
		if groupstatus == 2 then 
			rname, _, _, _, _, _, _, online = GetRaidRosterInfo(raidid) 
			unit = "raid"..raidid
		else if groupstatus == 1 then
				unit = "party"..raidid
				rname = GetUnitName(unit)
				online = UnitIsConnected(unit)
			 else rname = UnitName("player")
			 end
		end
		if rname ~= UnitName("player") then
			curraider=rname
			if online then
				timer = 0
				checktimer = true
				frame:RegisterEvent("INSPECT_ACHIEVEMENT_READY")
				SetAchievementComparisonUnit(unit)
			else 	achres[curraider] = "offline"
				ACUpdateReport()
				raidid=raidid+1
				ACCheckNextPlayer()
			end
		else 	raidid=raidid+1
			ACCheckNextPlayer()
		end
	end
	
end




function UpdateHandler(self, elapsed)
	timer = timer + elapsed
	if(checktimer and timer > timeout) then 
		ClearAchievementComparisonUnit()
		achres[curraider] = "timeout"
		raidid = raidid + 1
		checktimer = false
		ACUpdateReport()
		ACCheckNextPlayer()
	end
end




function SetupACFrame()
	local f = GameFontNormal:GetFont()
	local report = CreateFrame("Frame", nil, UIParent)
	report:Hide()
	report:SetWidth(325)
	report:SetHeight(335)
	report:EnableMouse(true)
	report:SetMovable(true)
	report:RegisterForDrag("LeftButton")
	report:SetScript("OnDragStart", function(f) f:StartMoving() end)
	report:SetScript("OnDragStop", function(f) f:StopMovingOrSizing() end)
	report:SetScript("OnEvent", EventHandler);
	report:SetScript("OnUpdate", UpdateHandler);
	report:SetBackdrop({
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
		})
	report:SetBackdropBorderColor(.5, .5, .5)
	report:SetBackdropColor(0,0,0)
	report:ClearAllPoints()
	report:SetPoint("BOTTOM", ReadyCheckFrame, "TOP", 0, 0)

	-- Local pointer
	frame = report

	local rfade = report:CreateTexture(nil, "BORDER")
	rfade:SetWidth(319)
	rfade:SetHeight(25)
	rfade:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
	rfade:SetPoint("TOP", report, "TOP", 0, -4)
	rfade:SetBlendMode("ADD")
	rfade:SetGradientAlpha("VERTICAL", .1, .1, .1, 0, .25, .25, .25, 1)

	local rheader = report:CreateFontString(nil,"OVERLAY")
	rheader:SetFont(f, 14)
	rheader:SetWidth(300)
	rheader:SetHeight(30)
	rheader:SetText("header")
	rheader:SetTextColor(1, .8, 0)
	rheader:ClearAllPoints()
	rheader:SetPoint("TOP", report, "TOP", 0, -10)
	frame.rheader = rheader
	
	local leftinfo = report:CreateFontString(nil,"OVERLAY")
	leftinfo:SetFont(f, 12)
	leftinfo:SetWidth(175)
	leftinfo:SetHeight(300)
	leftinfo:SetJustifyV("TOP")
	leftinfo:SetText("leftinfo")
	leftinfo:ClearAllPoints()
	leftinfo:SetPoint("TOPLEFT", report, "TOPLEFT", 0, -40)
	frame.leftinfo = leftinfo

	local rightinfo = report:CreateFontString(nil,"OVERLAY")
	rightinfo:SetFont(f, 12)
	rightinfo:SetWidth(175)
	rightinfo:SetHeight(300)
	rightinfo:SetJustifyV("TOP")
	rightinfo:SetText("rightinfo")
	rightinfo:ClearAllPoints()
	rightinfo:SetPoint("TOPRIGHT", report, "TOPRIGHT", 0, -40)
	frame.rightinfo = rightinfo

	reportbutton = CreateFrame("Button", nil, report)
	reportbutton.owner = self
	reportbutton:SetWidth(125)
	reportbutton:SetHeight(32)
	reportbutton:SetPoint("BOTTOMLEFT", report, "BOTTOMLEFT", 10, 10)
	frame.reportbutton = reportbutton

	local t = reportbutton:CreateTexture()
	t:SetWidth(125)
	t:SetHeight(32)
	t:SetPoint("CENTER", reportbutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	reportbutton:SetNormalTexture(t)

	t = reportbutton:CreateTexture(nil, "BACKGROUND")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(reportbutton)
	reportbutton:SetPushedTexture(t)

	t = reportbutton:CreateTexture()
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Highlight")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(reportbutton)
	t:SetBlendMode("ADD")
	reportbutton:SetHighlightTexture(t)

	reportbuttontext = reportbutton:CreateFontString(nil,"OVERLAY")
	reportbuttontext:SetFontObject(GameFontHighlight)
	reportbuttontext:SetText("left")
	reportbuttontext:SetAllPoints(reportbutton)
	frame.reportbuttontext = reportbuttontext

	closebutton = CreateFrame("Button", nil, report)
	closebutton.owner = self
	closebutton:SetWidth(125)
	closebutton:SetHeight(32)
	closebutton:SetPoint("BOTTOMRIGHT", report, "BOTTOMRIGHT", -10, 10)
	frame.closebutton = closebutton

	local t = closebutton:CreateTexture()
	t:SetWidth(125)
	t:SetHeight(32)
	t:SetPoint("CENTER", closebutton, "CENTER")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	closebutton:SetNormalTexture(t)

	t = closebutton:CreateTexture(nil, "BACKGROUND")
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(closebutton)
	closebutton:SetPushedTexture(t)

	t = closebutton:CreateTexture()
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Highlight")
	t:SetTexCoord(0, 0.625, 0, 0.6875)
	t:SetAllPoints(closebutton)
	t:SetBlendMode("ADD")
	closebutton:SetHighlightTexture(t)

	closebuttontext = closebutton:CreateFontString(nil,"OVERLAY")
	closebuttontext:SetFontObject(GameFontHighlight)
	closebuttontext:SetText("left")
	closebuttontext:SetAllPoints(closebutton)
	frame.closebuttontext = closebuttontext

end

