--
-- Aardvark
-- Version: AR 5.0.7.4
-- Author: Walkerbo
-- Date: Saturday 30 June 2018
--

-- I have tried to name variables, functions, frames, and buttons to be more descriptive

--===================         Metrics, Lists & Variables          ============================
local addonName = 'Aardvark'
local versionNumber = 'AR 5.0.7.4'
local playerName = GetUnitName('player')

-- The floating button and action bar buttons
local AardvarkMagicButton, AardvarkActionBar, AardvarkActionBarSellButton, AardvarkActionBarAardvarkButton, AardvarkActionBarDestroyButton, ActionBarGlobalButton, ActionBarCharacterButton

-- A table of all the Aardvark images
local AVKImg = {
    avkban = 'Interface\\AddOns\\Aardvark\\Files\\AVK_ban', --  Aardvark Banner
    avkchari = 'Interface\\AddOns\\Aardvark\\Files\\AVK_charicon', -- Aardvark Character List Icon
    avkchari_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVK_charicon_alt', -- Aardvark Character List Icon Alt
    avkci = 'Interface\\AddOns\\Aardvark\\Files\\AVK_cx_icon', -- Aardvark Close Icon
    avkglobi = 'Interface\\AddOns\\Aardvark\\Files\\AVK_globicon', -- Aardvark Global List Icon
    avkglobi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVK_globicon_alt', -- Aardvark Global List Icon Alt
    avki = 'Interface\\AddOns\\Aardvark\\Files\\AVK_icon', -- Aardvark Icon
    avki_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVK_icon_alt', -- Aardvark Icon Alt
    avksi = 'Interface\\AddOns\\Aardvark\\Files\\AVKS_icon', -- Aardvark Sell Icon
    avksi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKS_icon_alt', -- Aardvark Sell Icon Alt
    avksoi = 'Interface\\AddOns\\Aardvark\\Files\\AVKS_oicon', -- Aardvark Sell Options Icon Alt
    avksoi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKS_oicon_alt', -- Aardvark Sell Options Icon Alt
    avks_dis = 'Interface\\AddOns\\Aardvark\\Files\\AVKS_icon_dis', -- Aardvark Sell Disabled
    avkdi = 'Interface\\AddOns\\Aardvark\\Files\\AVKD_icon', -- Aardvark Destroy Icon
    avkdi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKD_icon_alt', -- Aardvark Destroy Icon Alt
    avkdoi = 'Interface\\AddOns\\Aardvark\\Files\\AVKD_oicon', -- Aardvark Destroy Options Icon Alt
    avkdoi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKD_oicon_alt', -- Aardvark Destroy Options Icon Alt
    avkri = 'Interface\\AddOns\\Aardvark\\Files\\AVKR_icon', -- Aardvark Repair Icon
    avkri_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKR_icon_alt', -- Aardvark Repair Icon Alt
    avkpchari = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_cicon', -- Aardvark Protect Character Icon
    avkpchari_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_cicon_alt', -- Aardvark Protect Character Icon Alt
    avkpglobi = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_gicon', -- Aardvark Protect Global Icon
    avkpglobi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_gicon_alt', -- Aardvark Protect Global Icon Alt
    avkpi = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_icon', -- Aardvark Protect Icon
    avkpi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_icon_alt', -- Aardvark Protect Icon Alt
    avkpoi = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_oicon', -- Aardvark Protect Options Icon
    avkpoi_alt = 'Interface\\AddOns\\Aardvark\\Files\\AVKP_oicon_alt' -- Aardvark Protect Options Icon Alt
}

-- Font objects
local avkCheckBoxBigFont = CreateFont('avkCheckBoxBigFont')
avkCheckBoxBigFont:SetFont('Interface\\AddOns\\Aardvark\\Files\\neuropol.ttf', 29)
local avkCheckBoxFont = CreateFont('avkCheckBoxFont')
avkCheckBoxFont:SetFont('Interface\\AddOns\\Aardvark\\Files\\vixar.TTF', 15)
local avkContentFont = CreateFont('avkContentFont')
avkContentFont:SetFont('Interface\\AddOns\\Aardvark\\Files\\vixar.TTF', 14.8)
local avkScrollTitleFont = CreateFont('avkScrollTitleFont')
avkScrollTitleFont:SetFont('Interface\\AddOns\\Aardvark\\Files\\vixar.TTF', 20)
local avkButtonFont = CreateFont('avkButtonFont')
avkButtonFont:SetFont('Interface\\AddOns\\Aardvark\\Files\\vixar.TTF', 15)

-- The font colours
local AVKFont = {
    avkBlueText = '|cff00ffff',
    avkBlueTextMessagePrefix = '|cff00ffff [' .. addonName .. ']: ',
    avkBlueTextMessagePrefixSuffix = '|cff00ffff [' .. addonName .. ']: |r',
    avkGreenText = '|cff00ff00',
    avkRedText = '|cffff0000',
    avkPinkText = '|cffff00ff',
    avkOrangeText = '|cffff8c00'
}

-- Content strings
local AVKText = {
    avkLoad = (AVKFont.avkBlueText .. ' *** ' .. addonName .. ' - ' .. versionNumber .. ' Loaded *** \n'), -- Load Message
    avkOptions = ('Slash Commands:\n' .. AVKFont.avkBlueText .. '/avk |r ~  Show/Hide Aardvark frame\n' .. AVKFont.avkBlueText .. '/avkdestroy |r ~  Destroy function\n' .. AVKFont.avkBlueText .. '/avkclear |r ~  Clear all lists\n' .. AVKFont.avkBlueText .. '/avkpos |r ~  Reset Aardvark frame and button positions\n'), -- Options Text
    avkSellOptions = ('The ' .. AVKFont.avkGreenText .. 'Aardvark Sell|r function can sometimes lag depending on the size of your list and the number items you have in your bags.\n\nIf this occurs turn on the action bar and spam the sell button.\n\nI will continue to tinker with the sell function to try and remove this issue.'), -- Sell Text
    avkDestroyOptions = ('The ' .. AVKFont.avkRedText .. 'Aardvark Destroy|r function will destroy|r the items that you have added to your destroy lists regardless of bind, value, rarity or colour.\n\n' .. AVKFont.avkRedText .. "Destroyed items CANNOT be recovered.|r\n\nThere are no take backs, no do-overs, no whoops didn't mean to do that, etc.\n\nThe only way to recover a destroyed item is to go and farm it again.\n\n" .. AVKFont.avkRedText .. 'You have been warned!'), -- Destroy Text
    avkRepairOptions = ('The ' .. AVKFont.avkPinkText .. 'Aardvark Repair|r function operates after the destroy function and prior to the\n sell function.\n\n Damaged items must\n be repaired before\n they can be sold.'), -- Repair Text
    avkProtectOptions = ('The ' .. AVKFont.avkOrangeText .. 'Aardvark Protect|r function was created to protect those special items that you want to ensure are not sold or destroyed even if they are listed in your other sell and/or destroy lists.\n\nThe protect lists have no restrictions which means you can protect any item regardless of colour or value.'), -- Protect Text
    avkMagicButton = ('Drag&Drop/Click&Drop: Add Item to Character List\nDrag&Drop/Click&Drop + Alt: Add Item to Global List\nDrag&Drop/Click&Drop + Ctrl: Add Item to Protect List\nLeft Click: Show/Hide Aardvark Frame\nMiddle Click + Drag: Move Aardvark Button\nMiddle Click + Drag: Move Aardvark Action Bar\nRight Click: Destroy Listed Items'), -- Aardvark Button Tooltip Text
    avkAboutAardvark = ("There once was a little blue Aardvark that grew up in Azeroth.\n\nHe loved to farm, spending all day and half of the night digging up herbs, mining ore, weaving cloth and collecting little treasures.\n\nAfter few years he started to develop RSI in his little paws as he was always clicking to sell items that he didn't want, dragging and dropping items that he couldn't sell and, in a lot of cases, deleting items just to clean out his bags ready to farm again.\n\nOne day after an extremely long day of farming he thought;" .. AVKFont.avkBlueText .. "\n\"What if I could open my bags and have all the stuff I don't want just magically disappear?\"|r \n\nWith this thought he started to teach his little arthritic paws how to code.\nHis code is very messy, overly long and undoubtedly very inefficient but it does what he wants it to do.\n\nHopefully you can find it useful too.") -- Aardvark Text
}

-- All sizings
local AVKSize = {
    actionBarButtonGap = 47,
    backdropEdgeSize = 20,
    checkBoxBigSize = 24,
    checkBoxSize = 22,
    checkBoxChildGapX = 15,
    checkboxBigGapY = 38,
    checkboxGapY = 32,
    clearButtonHight = 32,
    closeButtonGap = -8,
    closeButtonSize = 20,
    mainFrameHeight = 580,
    mainFrameMarginGap = 10,
    mainFrameNavigationButtonSize = 40,
    mainFrameNavigationButtonSpace = 76,
    mainFrameNavigationFrameY = -125,
    mainFrameNavigationFrameHeight = 60,
    mainFrameWidth = 610,
    mainPanelElementGap = 20,
    mainPanelHeight = 343,
    mainPanelWidth = 590,
    optionsButtonSize = 25,
    optionsFrameWidth = 360,
    optionsFrameElementGap = 10,
    scaleSliderMin = .5,
    scaleSliderMax = 1.5,
    scaleSliderScale = 1.2,
    scrollButtonHeight = 16,
    scrollButtonNumber = 13,
    scrollButtonWidth = 267,
    scrollFrameHeight = 223,
    scrollFrameWidth = 282,
    scrollTitleHeight = 48,
    scrollTitlePointX = 10,
    scrollTitlePointY = -16,
    textBoxWidthShrink = 35,
    toolTipAnchor = -22
}

-- List of vendors that will not buy items
local AVKVendorBlacklist = {
    98737, -- Holt Thunderhorn -- Hunter class hall
    97111, -- Illanna Dreadmoore -- Death Knight class hall
    91190, -- Sister Elda -- Paladin class hall
    87302, -- Murg -- Horde garrison inn chef
    79828, -- Murg -- Horde garrison inn chef - Yes, this is a second Murg - No, I have no idea why
    -- 77368, -- Madison Clark -- This NPC can now buy items
    63596, -- Audrey Burnhep
    27914, -- Ethereal Soul Trader
    111741, -- Fjornson Stonecarver -- Warrior class hall
    111740, -- Mile Raitheborne -- Warlock class hall
    111739, -- Gorma Windspeaker -- Shaman class hall
    111738, -- Juvess the Duskwhisperer -- Priest class hall
    111737, -- Celadine the Fatekeeper -- Druid class hall
    111736, -- Vahu the Weathered -- Demon Hunter class hall
    110624, -- Edirah -- Mage class hall
    106942, -- Lorewalker Cho -- Monk class hall
    102641 -- Filius Sparkstache -- Rogue class hall
}

-- Options filter table
local AVKFilterOptions = {
    weaponOneHanded = true,
    weaponTwoHanded = true,
    weaponRanged = true,
    weaponOffHand = true,
    armourPlate = true,
    armourMail = true,
    armourLeather = true,
    armourCloth = true,
    equipSlotHead = true,
    equipSlotNeck = true,
    equipSlotShoulders = true,
    equipSlotChest = true,
    equipSlotCloak = true,
    equipSlotShirt = true,
    equipSlotTabard = true,
    equipSlotWrists = true,
    equipSlotHands = true,
    equipSlotWaist = true,
    equipSlotLegs = true,
    equipSlotFeet = true,
    equipSlotRings = true,
    equipSlotTrinkets = true,
    rarityGrey = true,
    rarityWhite = true,
    rarityGreen = true,
    rarityBlue = true,
    rarityPurple = true,
    rarityHeirloom = true,
    rarityLegendary = true,
    rarityArtifact = true,
    bindingNone = true,
    bindingOnEquip = true,
    bindingOnPickup = true,
    bindingSoulbound = true,
    bindingToAccount = true,
    valueValuable = true,
    valueWorthless = true,
    otherPets = true,
    otherMounts = true,
    otherRecipes = true,
    otherReagents = true,
    otherFoodDrink = true,
    otherGems = true,
    otherEnchantments = true,
    otherBags = true,
    otherOther = true
}

-- Repair variables to populate repair messages after the sell message
local repairAmount, repairMessageType = 0, 0

--===================         Functions & Slash Commands         ============================
local function avkManageLists() -- Start up function to initialise lists
    if not AVKGlobalSettings then -- Create Aardvark options table if it does not already exist
        AVKGlobalSettings = {
            Aardvark = {
                amfb = true, -- Aardvark main floating button
                amfbt = true, -- Aardvark main floating button tooltip
                afab = true, -- Aardvark floating action bar
                afabas = true, -- Aardvark floating action bar always show
                afabv = true -- Aardvark floating action bar vertical
            },
            Destroy = {
                ded = true, -- Destroy enable destroy
                dead = true, -- Destroy enable auto destroy
                dddm = true, -- Destroy detailed destroy messages
                dntdm = true, -- Destroy nothing to destroy messages
                dialsm = true, -- Destroy item added to list success messages
                dialfm = true, -- Destroy item added to list fail messages
                dlit = true -- Destroy show listed item tooltips
            },
            Repair = {
                rer = true, -- Repair enable repair
                rgr = false, -- Repair guild repair
                rcarm = true, -- Repair cannot afford repair messages
                rntrm = true, -- Repair nothing to repair messages
                rvcrm = true -- Repair vendor cannot repair messages
            },
            Sell = {
                ses = true, -- Sell enable sell
                seas = true, -- Sell enable auto sell
                seasg = true, -- Sell enable auto sell greys
                stil = false, -- Sell twelve item limit
                sdsm = true, -- Sell detailed sell messages
                sntsm = true, -- Sell nothing to sell messages
                sialsm = true, -- Sell item added to list success messages
                sialfm = true, -- Sell item added to list fail messages
                slit = true -- Sell show listed item tooltips
            },
            Protect = {
                pialsm = true, -- Protect item added to list success messages
                pdpm = true, -- Protect display protected messages
                pcbp = true, -- Protect caged battle pets
                plit = true -- Protect show listed item tooltips
            },
            FrameScales = {
                amfs = 1, -- Aardvark Main Frame Scale
                ambs = 1, -- Aardvark Magic Button Scale
                aabs = 1 -- Aardvark Action Bar Scale
            }
        }
        AardvarkMainFrame:Show() -- Show Aardvark frame if the settings list did not already exist
    end
    if not AVKGlobalSellList then
        AVKGlobalSellList = {} -- Create empty global sell list if it does not already exist
    end
    if not AVKGlobalDestroyList then
        AVKGlobalDestroyList = {} -- Create empty global destroy list if it does not already exist
    end
    if not AVKGlobalProtectList then
        AVKGlobalProtectList = {} -- Create empty global protect list if it does not already exist
    end
    if not AVKCharacterSellList then
        AVKCharacterSellList = {} -- Create empty character sell list if it does not already exist
    end
    if not AVKCharacterDestroyList then
        AVKCharacterDestroyList = {} -- Create empty character destroy list if it does not already exist
    end
    if not AVKCharacterProtectList then
        AVKCharacterProtectList = {} -- Create empty character protect list if it does not already exist
    end
    for k, v in pairs(AVKGlobalSettings) do -- Set all checkboxes
        for a, b in pairs(v) do
            if k ~= 'FrameScales' then
                local checkBoxName = 'CB' .. a
                _G[checkBoxName]:SetChecked(b)
                if k == 'Aardvark' and AVKGlobalSettings.Aardvark.afab == false and (a == 'afabas' or a == 'afabv') then -- Hide option checkboxes if their parent is unchecked
                    _G[checkBoxName]:Hide()
                elseif k == 'Sell' and a ~= 'ses' and AVKGlobalSettings.Sell.ses == false then
                    _G[checkBoxName]:Hide()
                elseif k == 'Destroy' and a ~= 'ded' and AVKGlobalSettings.Destroy.ded == false then
                    _G[checkBoxName]:Hide()
                elseif k == 'Repair' and a ~= 'rer' and AVKGlobalSettings.Repair.rer == false then
                    _G[checkBoxName]:Hide()
                end
            end
        end
    end
    if AVKGlobalSettings.Aardvark.amfb == false then -- Hide magic button if it is set to hide
        AardvarkMagicButton:Hide()
    end
    if AVKGlobalSettings.Aardvark.afab == true and AVKGlobalSettings.Aardvark.afabas == true then -- Show action bar if always show is checked
        AardvarkActionBar:Show()
    end
end

local function avkProtectCagedPet() -- Function to protect caged battle pets
    if AVKGlobalSettings.Protect.pcbp then
        local BattlePetCageListed = false
        for k, v in pairs(AVKGlobalProtectList) do
            if v == 82800 then
                BattlePetCageListed = true
                break
            end
        end
        if BattlePetCageListed then
            BattlePetCageListed = false
        else
            BattlePetCageListed = false
            table.insert(AVKGlobalProtectList, 1, 82800)
        end
        BattlePetCageListed = false
    end
end

--[[
local function filterTest()  -- debug
	print("filterTest")
	if CBrarityGrey:GetChecked() then-- Cloth Armour
		print("CLOTH")
		elseif CBrarityWhite:GetChecked() then -- Leather Armour
		print("LEATHER")
		elseif CBrarityGreen:GetChecked() then-- Mail Armour
		print("MAIL")
		elseif CBrarityBlue:GetChecked() then-- Plate Armour
		print("PLATE")
		else
		print("OTHER")
	end
end
--]]

local function avkCheckFilter(itemID)
    local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(itemID)
    if (AVKFilterOptions.rarityGrey and itemRarity == 0) or (AVKFilterOptions.rarityWhite and itemRarity == 1) or (AVKFilterOptions.rarityGreen and itemRarity == 2) or (AVKFilterOptions.rarityBlue and itemRarity == 3) or (AVKFilterOptions.rarityPurple and itemRarity == 4) or (AVKFilterOptions.rarityHeirloom and itemRarity == 5) or (AVKFilterOptions.rarityLegendary and itemRarity == 6) or (AVKFilterOptions.rarityArtifact and itemRarity == 7) then
        --		return true, itemLink
        print(true, itemLink)
    else
        --		return false
        print(false, itemLink)
    end
end

local function avkUpdateLists() -- Update lists function
    avkProtectCagedPet()
    FauxScrollFrame_Update(AardvarkSellGlobalScrollFrame, #AVKGlobalSellList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Global sell
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkSellGlobalScrollFrame)
        local button = AardvarkSellGlobalScrollFrame.buttons[index]
        button.index = offset
        if offset <= #AVKGlobalSellList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKGlobalSellList[offset])
            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    FauxScrollFrame_Update(AardvarkSellCharacterScrollFrame, #AVKCharacterSellList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Character sell
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkSellCharacterScrollFrame)
        local button = AardvarkSellCharacterScrollFrame.buttons[index]
        button.index = offset
        if offset <= #AVKCharacterSellList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKCharacterSellList[offset])
            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    FauxScrollFrame_Update(AardvarkDestroyGlobalScrollFrame, #AVKGlobalDestroyList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Global destroy
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkDestroyGlobalScrollFrame)
        local button = AardvarkDestroyGlobalScrollFrame.buttons[index]
        button.index = offset
        if offset <= #AVKGlobalDestroyList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKGlobalDestroyList[offset])
            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    FauxScrollFrame_Update(AardvarkDestroyCharacterScrollFrame, #AVKCharacterDestroyList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Character destroy
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkDestroyCharacterScrollFrame)
        local button = AardvarkDestroyCharacterScrollFrame.buttons[index]
        button.index = offset
        if offset <= #AVKCharacterDestroyList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKCharacterDestroyList[offset])
            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    FauxScrollFrame_Update(AardvarkProtectGlobalScrollFrame, #AVKGlobalProtectList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Global protect
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkProtectGlobalScrollFrame)
        local button = AardvarkProtectGlobalScrollFrame.buttons[index]
        button.index = offset
        if offset <= #AVKGlobalProtectList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKGlobalProtectList[offset])
            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    FauxScrollFrame_Update(AardvarkProtectCharacterScrollFrame, #AVKCharacterProtectList, AVKSize.scrollButtonNumber, AVKSize.scrollButtonHeight) -- Character protect
    for index = 1, AVKSize.scrollButtonNumber do
        local offset = index + FauxScrollFrame_GetOffset(AardvarkProtectCharacterScrollFrame)
        local button = AardvarkProtectCharacterScrollFrame.buttons[index]
        button.index = offset

        if offset <= #AVKCharacterProtectList then
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, iconFileDataID, itemSellPrice, itemClassID, itemSubClassID, bindType, expacID, itemSetID, isCraftingReagent = GetItemInfo(AVKCharacterProtectList[offset])

            button:SetText(itemLink)
            button:Show()
        else
            button:Hide()
        end
    end
    avkProtectCagedPet()
end

local function toggleAVKPanels(buttonName) -- Main frame navigation buttons function
    avkUpdateLists()
    if buttonName == AardvarkMainFrameCloseButton then
        AardvarkMainFrame:Hide()
        AardvarkScalePanel:Hide()
        AardvarkSideOptionsPanel:Hide()
    elseif buttonName == AardvarkNavigationAardvarkButton then
        AardvarkDestroyOptionsPanel:Hide()
        AardvarkDestroyPanel:Hide()
        AardvarkProtectOptionsPanel:Hide()
        AardvarkProtectPanel:Hide()
        AardvarkRepairPanel:Hide()
        AardvarkSellOptionsPanel:Hide()
        AardvarkSellPanel:Hide()
        AardvarkSideOptionsPanel:Hide()
        AardvarkSillyPanel:Hide()
        AardvarkAardvarkPanel:Show()
        AardvarkFilterOptionsPanel:Show()
        AardvarkSideOptionsPanel:Show()
    elseif buttonName == AardvarkNavigationSellButton then
        AardvarkAardvarkPanel:Hide()
        AardvarkDestroyOptionsPanel:Hide()
        AardvarkDestroyPanel:Hide()
        AardvarkFilterOptionsPanel:Hide()
        AardvarkProtectOptionsPanel:Hide()
        AardvarkProtectPanel:Hide()
        AardvarkRepairPanel:Hide()
        AardvarkSillyPanel:Hide()
        AardvarkSellOptionsPanel:Show()
        AardvarkSellPanel:Show()
    elseif buttonName == AardvarkNavigationDestroyButton then
        AardvarkAardvarkPanel:Hide()
        AardvarkDestroyOptionsPanel:Hide()
        AardvarkFilterOptionsPanel:Hide()
        AardvarkProtectOptionsPanel:Hide()
        AardvarkProtectPanel:Hide()
        AardvarkRepairPanel:Hide()
        AardvarkSellOptionsPanel:Hide()
        AardvarkSellPanel:Hide()
        AardvarkSillyPanel:Hide()
        AardvarkDestroyOptionsPanel:Show()
        AardvarkDestroyPanel:Show()
    elseif buttonName == AardvarkNavigationProtectButton then
        AardvarkAardvarkPanel:Hide()
        AardvarkDestroyOptionsPanel:Hide()
        AardvarkDestroyPanel:Hide()
        AardvarkFilterOptionsPanel:Hide()
        AardvarkRepairPanel:Hide()
        AardvarkSellOptionsPanel:Hide()
        AardvarkSellPanel:Hide()
        AardvarkSillyPanel:Hide()
        AardvarkProtectOptionsPanel:Show()
        AardvarkProtectPanel:Show()
    elseif buttonName == AardvarkNavigationRepairButton then
        AardvarkAardvarkPanel:Hide()
        AardvarkDestroyPanel:Hide()
        AardvarkFilterOptionsPanel:Hide()
        AardvarkProtectPanel:Hide()
        AardvarkSellPanel:Hide()
        AardvarkSideOptionsPanel:Hide()
        AardvarkSillyPanel:Hide()
        AardvarkRepairPanel:Show()
    elseif buttonName == AardvarkNavigationSillyButton then
        AardvarkAardvarkPanel:Hide()
        AardvarkDestroyPanel:Hide()
        AardvarkFilterOptionsPanel:Hide()
        AardvarkProtectPanel:Hide()
        AardvarkRepairPanel:Hide()
        AardvarkSellPanel:Hide()
        AardvarkSideOptionsPanel:Hide()
        AardvarkSillyPanel:Show()
    elseif buttonName == AardvarkSideFrameCloseButton then
        AardvarkSideOptionsPanel:Hide()
    elseif buttonName == AardvarkSellOptionsButton then
        AardvarkSideOptionsPanel:Show()
    elseif buttonName == AardvarkDestroyOptionsButton then
        AardvarkSideOptionsPanel:Show()
    elseif buttonName == AardvarkProtectOptionsButton then
        AardvarkFilterOptionsPanel:Hide()
        AardvarkSideOptionsPanel:Show()
    elseif buttonName == AardvarkScaleFrameButton then
        AardvarkSideOptionsPanel:Hide()
        if AardvarkScalePanel:IsVisible() then
            AardvarkScalePanel:Hide()
            AardvarkScalePanel:ClearAllPoints()
            AardvarkScalePanel:SetPoint('BOTTOMLEFT', AardvarkMainFrame, 'BOTTOMRIGHT', 0, 0)
        else
            AardvarkScalePanel:ClearAllPoints()
            AardvarkScalePanel:SetPoint('BOTTOMLEFT', AardvarkMainFrame, 'BOTTOMRIGHT', 0, 0)
            AardvarkScalePanel:Show()
        end
    elseif buttonName == AardvarkScaleFrameCloseButton then
        AardvarkScalePanel:Hide()
    else
        print('FAILED', buttonName)
    end
    avkUpdateLists()
end

local function toggleFloatingActionBar()
    if AVKGlobalSettings.Aardvark.afab == true and (AVKGlobalSettings.Aardvark.afabas == true or AardvarkActionBarSellButton:IsEnabled()) then
        AardvarkActionBar:Show()
    else
        AardvarkActionBar:Hide()
    end
end

local function toggleVerticleActionBar() -- Layout the action bar buttons
    if AVKGlobalSettings.Aardvark.afabv == true then
        AardvarkActionBar:SetSize(AVKSize.actionBarButtonGap, AVKSize.actionBarButtonGap * 7)
        AardvarkActionBarAardvarkButton:ClearAllPoints()
        AardvarkActionBarAardvarkButton:SetPoint('TOP', 0, -5)
        AardvarkActionBarSellButton:SetPoint('CENTER', AardvarkActionBarAardvarkButton, 0, -AVKSize.actionBarButtonGap)
        AardvarkActionBarDestroyButton:SetPoint('CENTER', AardvarkActionBarSellButton, 0, -AVKSize.actionBarButtonGap)
        AardvarkActionBarGlobalButton:SetPoint('CENTER', AardvarkActionBarDestroyButton, 0, -AVKSize.actionBarButtonGap)
        AardvarkActionBarCharacterButton:SetPoint('CENTER', AardvarkActionBarGlobalButton, 0, -AVKSize.actionBarButtonGap)
        AardvarkActionBarGlobalProtectButton:SetPoint('CENTER', AardvarkActionBarCharacterButton, 0, -AVKSize.actionBarButtonGap)
        AardvarkActionBarCharacterProtectButton:SetPoint('CENTER', AardvarkActionBarGlobalProtectButton, 0, -AVKSize.actionBarButtonGap)
    else
        AardvarkActionBar:SetSize(AVKSize.actionBarButtonGap * 7, AVKSize.actionBarButtonGap)
        AardvarkActionBarAardvarkButton:ClearAllPoints()
        AardvarkActionBarAardvarkButton:SetPoint('LEFT', 5, 0)
        AardvarkActionBarSellButton:SetPoint('CENTER', AardvarkActionBarAardvarkButton, AVKSize.actionBarButtonGap, 0)
        AardvarkActionBarDestroyButton:SetPoint('CENTER', AardvarkActionBarSellButton, AVKSize.actionBarButtonGap, 0)
        AardvarkActionBarGlobalButton:SetPoint('CENTER', AardvarkActionBarDestroyButton, AVKSize.actionBarButtonGap, 0)
        AardvarkActionBarCharacterButton:SetPoint('CENTER', AardvarkActionBarGlobalButton, AVKSize.actionBarButtonGap, 0)
        AardvarkActionBarGlobalProtectButton:SetPoint('CENTER', AardvarkActionBarCharacterButton, AVKSize.actionBarButtonGap, 0)
        AardvarkActionBarCharacterProtectButton:SetPoint('CENTER', AardvarkActionBarGlobalProtectButton, AVKSize.actionBarButtonGap, 0)
    end
end

-- Check item on list functions
local function checkItemOnGlobalSellList(currentItem)
    for k, v in pairs(AVKGlobalSellList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

local function checkItemOnCharacterSellList(currentItem)
    for k, v in pairs(AVKCharacterSellList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

local function checkItemOnGlobalDestroyList(currentItem)
    for k, v in pairs(AVKGlobalDestroyList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

local function checkItemOnCharacterDestroyList(currentItem)
    for k, v in pairs(AVKCharacterDestroyList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

local function checkItemOnGlobalProtectedList(currentItem)
    for k, v in pairs(AVKGlobalProtectList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

local function checkItemOnCharacterProtectedList(currentItem)
    for k, v in pairs(AVKCharacterProtectList) do
        if v == currentItem then
            return true
        end
    end
    return false
end

--[[
	local function consolidateLists()  --  debug
	print("consolidateLists")
	end
--]]

-- Add item to list functions
local function addItemToGlobalProtectList()
    local itemType, itemID, _, _ = GetCursorInfo()
    local _, itemLink, itemQuality, _, _, _, _, _, _, _, itemValue = GetItemInfo(itemID)
    if itemType ~= 'item' then -- If not item end
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. ' That was not an item.') -- Cannot disable this message, because we have to learn
    else
        if checkItemOnGlobalProtectedList(itemID) == true then -- If already on list print item already listed message
            if AVKGlobalSettings.Protect.pialsm == true then
                print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global protect list.')
            end
        else
            if AVKGlobalSettings.Protect.pialsm == true then -- Print item added to list message
                print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkOrangeText .. ' added to your global protect list.')
            end
            table.insert(AVKGlobalProtectList, 1, itemID)
            toggleAVKPanels(AardvarkNavigationProtectButton)
        end
    end
    avkUpdateLists()
    ClearCursor()
end

local function addItemToCharacterProtectList()
    local itemType, itemID, _, _ = GetCursorInfo()
    local _, itemLink, itemQuality, _, _, _, _, _, _, _, itemValue = GetItemInfo(itemID)
    if itemType ~= 'item' then -- If not item end
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. ' That was not an item.') -- Cannot disable this message, because we have to learn
    else
        if checkItemOnGlobalProtectedList(itemID) == true then -- If already on list print item already listed message
            if AVKGlobalSettings.Protect.pialsm == true then
                print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global protect list.')
            end
        elseif checkItemOnCharacterProtectedList(itemID) == true then -- If already on list print item already listed message
            if AVKGlobalSettings.Protect.pialsm == true then
                print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on ' .. playerName .. "'s protect list.")
            end
        else
            if AVKGlobalSettings.Protect.pialsm == true then -- Print item added to list message
                print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkOrangeText .. ' added to ' .. playerName .. "'s protect list.")
            end
            table.insert(AVKCharacterProtectList, 1, itemID)
            toggleAVKPanels(AardvarkNavigationProtectButton)
        end
    end
    avkUpdateLists()
    ClearCursor()
end

local function addItemToGlobalList()
    local itemType, itemID, _, _ = GetCursorInfo()
    local _, itemLink, itemQuality, _, _, _, _, _, _, _, itemValue = GetItemInfo(itemID)
    if itemType ~= 'item' then -- If not item end
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. ' That was not an item.') -- Cannot disable this message, because we have to learn
    else
        if itemValue ~= 0 then
            if checkItemOnGlobalSellList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Sell.sialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global sell list.')
                end
            else -- If not already on list add to list
                if AVKGlobalSettings.Sell.sialsm == true then -- Print item added to list message
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkGreenText .. ' added to your global sell list.')
                end
                table.insert(AVKGlobalSellList, 1, itemID)
                toggleAVKPanels(AardvarkNavigationSellButton)
            end
        elseif itemValue == 0 then -- If is item + has no value
            if checkItemOnGlobalDestroyList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Destroy.dialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global destroy list.')
                end
            else -- If not already on list add to list end
                if AVKGlobalSettings.Destroy.dialsm == true then -- Print item added to list message
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkRedText .. ' added to your global destroy list.')
                end
                table.insert(AVKGlobalDestroyList, 1, itemID)
                toggleAVKPanels(AardvarkNavigationDestroyButton)
            end
        end
    end
    avkUpdateLists()
    ClearCursor()
end

local function addItemToCharacterList()
    local itemType, itemID, _, _ = GetCursorInfo()
    local _, itemLink, itemQuality, _, _, _, _, _, _, _, itemValue = GetItemInfo(itemID)
    if itemType ~= 'item' then -- f not item end
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. ' That was not an item.') -- Cannot disable this message, because we have to learn
    else
        if itemValue ~= 0 then
            if checkItemOnGlobalSellList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Sell.sialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global sell list.')
                end
            elseif checkItemOnCharacterSellList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Sell.sialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on ' .. playerName .. "'s sell list.")
                end
            else -- If not already on list add to list
                if AVKGlobalSettings.Sell.sialsm == true then -- Print item added to list message
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkGreenText .. ' added to ' .. playerName .. "'s sell list.")
                end
                table.insert(AVKCharacterSellList, 1, itemID)
                toggleAVKPanels(AardvarkNavigationSellButton)
            end
        elseif itemValue == 0 then -- If is item + has no value
            if checkItemOnGlobalDestroyList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Destroy.dialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on your global destroy list.')
                end
            elseif checkItemOnCharacterDestroyList(itemID) == true then -- If already on list print item already listed message
                if AVKGlobalSettings.Destroy.dialfm == true then
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. ' is already on ' .. playerName .. "'s destroy list.")
                end
            else -- If not already on list add to list end
                if AVKGlobalSettings.Destroy.dialsm == true then -- Print item added to list message
                    print(AVKFont.avkBlueTextMessagePrefixSuffix .. itemLink .. AVKFont.avkRedText .. ' added to ' .. playerName .. "'s destroy list.")
                end
                table.insert(AVKCharacterDestroyList, 1, itemID)
                toggleAVKPanels(AardvarkNavigationDestroyButton)
            end
        end
    end
    avkUpdateLists()
    ClearCursor()
end

-- Validate vendor
local function checkVendorBlacklist(currentVendor)
    for k, v in pairs(AVKVendorBlacklist) do
        if (v == currentVendor) then
            return true
        end
    end
    return false
end

-- Sell function
local function avkSell()
    local vendorGUID, vendorName = UnitGUID('target'), UnitName('target')
    local _, _, _, _, _, npcID, _ = strsplit('-', vendorGUID)
    local vendorID = tonumber(npcID)
    local profitCounter = 0 -- Cash counting variable
    local twelveCounter = 0 -- Twelve item counter
    if checkVendorBlacklist(vendorID) then -- Check if vendor ID is on blacklist
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkGreenText .. vendorName .. ' refuses to buy your items.')
    else
        for sellBag = 0, 4 do -- Check each bag
            local sellBagSlot = GetContainerNumSlots(sellBag)
            for sellSlot = 0, sellBagSlot do -- Check each bag slot
                local currentItemID = GetContainerItemID(sellBag, sellSlot)
                if currentItemID then -- If current bag slot has an item then get the item info
                    local _, itemLink, itemQuality, _, _, _, _, _, _, _, itemValue = GetItemInfo(currentItemID)
                    local _, itemCount, _, _, _, _, _, _ = GetContainerItemInfo(sellBag, sellSlot)
                    if (checkItemOnGlobalProtectedList(currentItemID) == true or checkItemOnCharacterProtectedList(currentItemID) == true) and itemValue ~= 0 then
                        if AVKGlobalSettings.Sell.sdsm == true and AVKGlobalSettings.Protect.pdpm == true then
                            print(' - Protected: ' .. itemLink .. ' not sold.')
                        end
                    elseif checkItemOnGlobalSellList(currentItemID) == true or checkItemOnCharacterSellList(currentItemID) == true or (AVKGlobalSettings.Sell.seasg == true and itemQuality == 0) then
                        if twelveCounter ~= 12 then -- Test twelve item count
                            UseContainerItem(sellBag, sellSlot) -- Sell current item -- Comment out to debug
                            if AVKGlobalSettings.Sell.sdsm == true then -- If messages are on
                                print(' - Sold: ' .. itemCount .. ' ' .. itemLink .. ' for ' .. GetCoinTextureString(itemCount * itemValue))
                            end
                            profitCounter = profitCounter + (itemCount * itemValue) -- Add sale value to profit counter
                            if AVKGlobalSettings.Sell.stil == true then -- If twelve item limit
                                twelveCounter = twelveCounter + 1 -- Increase twelve counter
                            end
                        end
                    end
                end
            end
        end
        if profitCounter ~= 0 then -- If items were sold print out total -- this message cannot be disabled
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkGreenText .. 'Total Profit :-|r  ' .. GetCoinTextureString(profitCounter))
        elseif AVKGlobalSettings.Sell.sntsm == true then -- If no items sell print out grind message
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkGreenText .. 'Nothing to sell. Better grind some more.')
        end
        profitCounter = 0 -- Reset counters
        twelveCounter = 0
    end
    -- Repair print chunk
    if repairMessageType == 1 then
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkPinkText .. 'Repairs paid with guild funds :- |r' .. GetCoinTextureString(repairAmount)) -- Repair message 1
    elseif repairMessageType == 2 then
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkPinkText .. 'Repairs funded by you :- |r' .. GetCoinTextureString(repairAmount)) -- Repair message 2
    elseif repairMessageType == 3 then
        if AVKGlobalSettings.Repair.rcarm == true then
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkPinkText .. "Guild won't pay and you can't afford it!") -- Repair message 3
        end
    elseif repairMessageType == 4 then
        if AVKGlobalSettings.Repair.rntrm == true then
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkPinkText .. 'Nothing to repair.') -- Repair message 4
        end
    elseif repairMessageType == 5 then
        if AVKGlobalSettings.Repair.rvcrm == true then
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkPinkText .. 'This vendor cannot repair.') -- Repair message 5
        end
    end
    -- Reset the repair values to 0
    repairAmount = 0
    repairMessageType = 0
end

-- Destroy function
local function avkDestroy()
    local destroyedItemCount = 0 -- Destroyed items counting variable
    local destroyedSlotCount = 0
    -- Destroyed slots counting variable
    for destroyBag = 0, 4 do -- Check each bag
        local destroyBagSlot = GetContainerNumSlots(destroyBag)
        for destroySlot = 0, destroyBagSlot do -- Check each bag slot
            local currentItemID = GetContainerItemID(destroyBag, destroySlot)
            if currentItemID then -- If current bag slot has an item then get the item info
                -- 	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

                local _, itemLink, _, _, _, _, _, _, _, _, itemValue = GetItemInfo(currentItemID)
                local _, itemCount, _, _, _, _, _, _ = GetContainerItemInfo(destroyBag, destroySlot)
                if (checkItemOnGlobalProtectedList(currentItemID) == true or checkItemOnCharacterProtectedList(currentItemID) == true) and itemValue == 0 then
                    if AVKGlobalSettings.Destroy.dddm == true and AVKGlobalSettings.Protect.pdpm == true then -- Print each item destroyed
                        print(' - Protected: ' .. itemLink .. ' not destroyed.')
                    end
                elseif checkItemOnGlobalDestroyList(currentItemID) == true or checkItemOnCharacterDestroyList(currentItemID) == true then
                    destroyedItemCount = destroyedItemCount + itemCount
                    destroyedSlotCount = destroyedSlotCount + 1
                    -- If item Destroy messages are on print
                    if AVKGlobalSettings.Destroy.dddm == true then -- Print each item destroyed
                        print(' - Destroyed: ' .. itemCount .. ' ' .. itemLink)
                    end
                    PickupContainerItem(destroyBag, destroySlot)
                    DeleteCursorItem() -- Destroy current item --  Comment out to debug
                end
            end
        end
    end
    if destroyedSlotCount ~= 0 then -- If items were destroyed print out total -- If no items destroyed print out bag space message
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkRedText .. 'Items destroyed :-|r ' .. destroyedItemCount .. AVKFont.avkRedText .. '  ~  Bagslots cleared :-|r ' .. destroyedSlotCount)
    elseif AVKGlobalSettings.Destroy.dntdm == true then
        print(AVKFont.avkBlueTextMessagePrefixSuffix .. AVKFont.avkRedText .. 'Nothing destroyed. No bag space saved.')
    end
end

-- Repair function
local function avkRepair()
    if CanMerchantRepair() then
        local repairAllCost, _ = GetRepairAllCost()
        if repairAllCost ~= 0 then
            if CanGuildBankRepair() and AVKGlobalSettings.Repair.rgr == true then
                RepairAllItems(1) --  Comment out to debug
                -- Set the repair variables
                repairAmount, repairMessageType = repairAllCost, 1
            elseif GetMoney() >= repairAllCost then
                RepairAllItems() --  Comment out to debug
                repairAmount, repairMessageType = repairAllCost, 2
            elseif GetMoney() < repairAllCost then
                RepairAllItems() --  Comment out to debug
                if AVKGlobalSettings.Repair.rcarm == true then
                    repairAmount, repairMessageType = repairAllCost, 3
                end
            end
        else
            if AVKGlobalSettings.Repair.rntrm == true then
                repairAmount, repairMessageType = repairAllCost, 4
            end
        end
    else
        if AVKGlobalSettings.Repair.rvcrm == true then
            repairAmount, repairMessageType = repairAllCost, 5
        end
    end
end

-- Slash commands
SLASH_AARDVARK1 = '/avk' -- Show frame
function SlashCmdList.AARDVARK(msg, editbox)
    AardvarkMainFrame:Show()
    avkUpdateLists()
end

SLASH_AARDVARKRFP1 = '/avkpos' -- Reset layouts and scales
function SlashCmdList.AARDVARKRFP(msg, editbox)
    AardvarkMainFrame:ClearAllPoints()
    AardvarkMainFrame:SetPoint('LEFT', 250, 0)
    AVKGlobalSettings.FrameScales.amfs = 1
    AardvarkMainFrame:SetScale(AVKGlobalSettings.FrameScales.amfs)
    AardvarkMainFrame:Show()
    AardvarkMagicButton:ClearAllPoints()
    AardvarkMagicButton:SetPoint('BOTTOMRIGHT', AardvarkMainFrame, 'TOPRIGHT', 0, 20)
    AVKGlobalSettings.FrameScales.ambs = 1
    AardvarkMagicButton:SetScale(AVKGlobalSettings.FrameScales.ambs)
    AardvarkMagicButton:Show()
    AardvarkActionBar:ClearAllPoints()
    AardvarkActionBar:SetPoint('TOPLEFT', AardvarkMainFrame, 'TOPRIGHT', 0, 0)
    AVKGlobalSettings.FrameScales.aabs = 1
    AardvarkActionBar:SetScale(AVKGlobalSettings.FrameScales.aabs)
    AardvarkActionBar:Show()
    avkUpdateLists()
end

SLASH_AARDVARKD1 = '/avkdestroy' -- Destroy
function SlashCmdList.AARDVARKD(msg, editbox)
    avkDestroy()
end

SLASH_AARDVARKCB1 = '/avkclear' -- Clear all lists
function SlashCmdList.AARDVARKCB(msg, editbox)
    AVKGlobalSellList = {} -- Global Sell
    AVKGlobalDestroyList = {} -- Global Destroy
    AVKGlobalProtectList = {} -- Global Protect
    AVKCharacterSellList = {} -- Character Sell
    AVKCharacterDestroyList = {} -- Character Destroy
    AVKCharacterProtectList = {} -- Character Protect
    avkUpdateLists()
    print(AVKFont.avkBlueTextMessagePrefix .. 'All Lists Cleared')
end

SLASH_AARDVARKSG1 = '/avksg' -- Special add item to global destroy list ignoring value check
function SlashCmdList.AARDVARKSG(msg, editbox)
    local itemID = tonumber(string.match(msg, 'item:(%d+):'))
    if checkItemOnGlobalDestroyList(itemID) == true then -- If already on list print item already listed message
        if AVKGlobalSettings.Destroy.dialfm == true then
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. msg .. ' is already on your global destroy list.')
        end
    else -- If not already on list add to list end
        if AVKGlobalSettings.Destroy.dialsm == true then -- Print item added to list message
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. msg .. AVKFont.avkRedText .. ' added to your global destroy list.')
        end
        table.insert(AVKGlobalDestroyList, 1, itemID)
        toggleAVKPanels(AardvarkNavigationDestroyButton)
    end
    avkUpdateLists()
end

SLASH_AARDVARKSC1 = '/avksc' -- Special add item to character destroy list ignoring value check
function SlashCmdList.AARDVARKSC(msg, editbox)
    local itemID = tonumber(string.match(msg, 'item:(%d+):'))
    if checkItemOnGlobalDestroyList(itemID) == true then -- If already on list print item already listed message
        if AVKGlobalSettings.Destroy.dialfm == true then
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. msg .. ' is already on your global destroy list.')
        end
    elseif checkItemOnCharacterDestroyList(itemID) == true then
        if AVKGlobalSettings.Destroy.dialfm == true then -- If already on list print item already listed message
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. msg .. ' is already on ' .. playerName .. "'s destroy list.")
        end
    else -- If not already on list add to list end
        if AVKGlobalSettings.Destroy.dialsm == true then -- Print item added to list message
            print(AVKFont.avkBlueTextMessagePrefixSuffix .. msg .. AVKFont.avkRedText .. ' added to ' .. playerName .. "'s destroy list.")
        end
        table.insert(AVKCharacterDestroyList, 1, itemID)
        toggleAVKPanels(AardvarkNavigationDestroyButton)
    end
    avkUpdateLists()
end

--===================         AardvarkMainFrame         ============================
local AardvarkMainFrame = CreateFrame('Frame', 'AardvarkMainFrame', UIParent, 'TooltipBorderedFrameTemplate')
AardvarkMainFrame:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkMainFrame:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkMainFrame:SetSize(AVKSize.mainFrameWidth, AVKSize.mainFrameHeight)
AardvarkMainFrame:ClearAllPoints()
AardvarkMainFrame:SetPoint('LEFT', 250, 0)
AardvarkMainFrame:EnableMouse(true)
AardvarkMainFrame:SetMovable(true)
AardvarkMainFrame:RegisterForDrag('RightButton', 'LeftButton')
AardvarkMainFrame:SetScript('OnDragStart', AardvarkMainFrame.StartMoving)
AardvarkMainFrame:SetScript('OnDragStop', AardvarkMainFrame.StopMovingOrSizing)
AardvarkMainFrame:SetToplevel(true)
AardvarkMainFrame:SetScript(
    'OnEvent',
    function(self, event, ...) -- Triggers when a registered event fires
        if event == 'PLAYER_LOGIN' then
            print(AVKText.avkLoad)
            avkManageLists()
            avkUpdateLists()
            toggleVerticleActionBar()
        elseif event == 'MERCHANT_SHOW' then
            if AVKGlobalSettings.Destroy.ded == true and AVKGlobalSettings.Destroy.dead then
                avkDestroy()
            end
            if AVKGlobalSettings.Repair.rer == true then
                avkRepair()
            end
            if AVKGlobalSettings.Sell.ses == true and AVKGlobalSettings.Sell.seas == true then
                avkSell()
            end
            if AVKGlobalSettings.Aardvark.afab == true then
                AardvarkActionBarSellButton:Enable()
                AardvarkActionBar:Show()
            else
                AardvarkActionBar:Hide()
            end
        elseif event == 'MERCHANT_CLOSED' then
            AardvarkActionBarSellButton:Disable()
            if AVKGlobalSettings.Aardvark.afabas == false then
                AardvarkActionBar:Hide()
            end
        end
        AardvarkMainFrame:SetScale(AVKGlobalSettings.FrameScales.amfs)
        AardvarkMagicButton:SetScale(AVKGlobalSettings.FrameScales.ambs)
        AardvarkActionBar:SetScale(AVKGlobalSettings.FrameScales.aabs)
    end
)
AardvarkMainFrame:RegisterEvent('PLAYER_LOGIN') -- Register events to track
AardvarkMainFrame:RegisterEvent('MERCHANT_SHOW')
AardvarkMainFrame:RegisterEvent('MERCHANT_CLOSED')
AardvarkMainFrame:Hide()

local AardvarkMainFrameCloseButton = CreateFrame('Button', 'AardvarkMainFrameCloseButton', AardvarkMainFrame)
AardvarkMainFrameCloseButton:SetPoint('TOPRIGHT', AVKSize.closeButtonGap, AVKSize.closeButtonGap)
AardvarkMainFrameCloseButton:SetSize(AVKSize.closeButtonSize, AVKSize.closeButtonSize)
AardvarkMainFrameCloseButton:SetNormalTexture(AVKImg.avkci)
AardvarkMainFrameCloseButton:SetHighlightTexture(AVKImg.avkci, 'ADD')
AardvarkMainFrameCloseButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkMainFrameCloseButton)
    end
)

local AardvarkMainFrameBanner = CreateFrame('Frame', 'AardvarkOptionsFrameBanner', AardvarkMainFrame)
AardvarkMainFrameBanner:SetSize(590, 90)
AardvarkMainFrameBanner:SetPoint('TOP', 0, -29)
AardvarkMainFrameBanner.Texture = AardvarkMainFrameBanner:CreateTexture(nil, 'BACKGROUND')
AardvarkMainFrameBanner.Texture:SetPoint('TOP', 0, 0)
AardvarkMainFrameBanner.Texture:SetTexture(AVKImg.avkban)

--===================         AardvarkNavigationPanel         ============================
local AardvarkNavigationPanel = CreateFrame('Frame', 'AardvarkNavigationPanel', AardvarkMainFrame)
AardvarkNavigationPanel:SetSize(AVKSize.mainFrameWidth, AVKSize.mainFrameNavigationFrameHeight)
AardvarkNavigationPanel:SetPoint('TOP', 0, -140)

local AardvarkNavigationDestroyButton = CreateFrame('Button', 'AardvarkNavigationDestroyButton', AardvarkNavigationPanel)
AardvarkNavigationDestroyButton:SetPoint('CENTER', -AVKSize.mainFrameNavigationButtonSpace * .5, 0)
AardvarkNavigationDestroyButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationDestroyButton:SetNormalTexture(AVKImg.avkdi)
AardvarkNavigationDestroyButton:SetHighlightTexture(AVKImg.avkdi_alt, 'BLEND')
AardvarkNavigationDestroyButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationDestroyButton)
    end
)

local AardvarkNavigationSellButton = CreateFrame('Button', 'AardvarkNavigationSellButton', AardvarkNavigationPanel)
AardvarkNavigationSellButton:SetPoint('CENTER', AardvarkNavigationDestroyButton, -AVKSize.mainFrameNavigationButtonSpace, 0)
AardvarkNavigationSellButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationSellButton:SetNormalTexture(AVKImg.avksi)
AardvarkNavigationSellButton:SetHighlightTexture(AVKImg.avksi_alt, 'BLEND')
AardvarkNavigationSellButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationSellButton)
    end
)

local AardvarkNavigationAardvarkButton = CreateFrame('Button', 'AardvarkNavigationAardvarkButton', AardvarkNavigationPanel)
AardvarkNavigationAardvarkButton:SetPoint('CENTER', AardvarkNavigationSellButton, -AVKSize.mainFrameNavigationButtonSpace, 0)
AardvarkNavigationAardvarkButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationAardvarkButton:SetNormalTexture(AVKImg.avki)
AardvarkNavigationAardvarkButton:SetHighlightTexture(AVKImg.avki_alt, 'BLEND')
AardvarkNavigationAardvarkButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationAardvarkButton)
    end
)

local AardvarkNavigationProtectButton = CreateFrame('Button', 'AardvarkNavigationProtectButton', AardvarkNavigationPanel)
AardvarkNavigationProtectButton:SetPoint('LEFT', AardvarkNavigationDestroyButton, AVKSize.mainFrameNavigationButtonSpace, 0)
AardvarkNavigationProtectButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationProtectButton:SetNormalTexture(AVKImg.avkpi)
AardvarkNavigationProtectButton:SetHighlightTexture(AVKImg.avkpi_alt, 'BLEND')
AardvarkNavigationProtectButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationProtectButton)
    end
)

local AardvarkNavigationRepairButton = CreateFrame('Button', 'AardvarkNavigationRepairButton', AardvarkNavigationPanel)
AardvarkNavigationRepairButton:SetPoint('CENTER', AardvarkNavigationProtectButton, AVKSize.mainFrameNavigationButtonSpace, 0)
AardvarkNavigationRepairButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationRepairButton:SetNormalTexture(AVKImg.avkri)
AardvarkNavigationRepairButton:SetHighlightTexture(AVKImg.avkri_alt, 'BLEND')
AardvarkNavigationRepairButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationRepairButton)
    end
)

local AardvarkNavigationSillyButton = CreateFrame('Button', 'AardvarkNavigationSillyButton', AardvarkNavigationPanel)
AardvarkNavigationSillyButton:SetPoint('CENTER', AardvarkNavigationRepairButton, AVKSize.mainFrameNavigationButtonSpace, 0)
AardvarkNavigationSillyButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkNavigationSillyButton:SetNormalTexture(AVKImg.avki)
AardvarkNavigationSillyButton:SetHighlightTexture(AVKImg.avki_alt, 'BLEND')
AardvarkNavigationSillyButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkNavigationSillyButton)
    end
)

--===================     AardvarkAardvarkPanel     =============================
local AardvarkAardvarkPanel = CreateFrame('Frame', 'AardvarkAardvarkPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkAardvarkPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkAardvarkPanel:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkAardvarkPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkAardvarkPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkAardvarkPanel:Show()

local CBamfb = CreateFrame('CheckButton', 'CBamfb', AardvarkAardvarkPanel, 'UICheckButtonTemplate')
CBamfb:ClearAllPoints()
CBamfb:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap)
CBamfb:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBamfb.text:SetText(AVKFont.avkBlueText .. ' Aardvark Button')
CBamfb.text:SetFontObject(avkCheckBoxBigFont)
CBamfb:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Aardvark.amfb == true then
            AVKGlobalSettings.Aardvark.amfb = false
            AardvarkMagicButton:Hide()
        else
            AVKGlobalSettings.Aardvark.amfb = true
            AardvarkMagicButton:Show()
        end
    end
)

local CBamfbt = CreateFrame('CheckButton', 'CBamfbt', AardvarkAardvarkPanel, 'UICheckButtonTemplate')
CBamfbt:ClearAllPoints()
CBamfbt:SetPoint('TOPLEFT', CBamfb, 0, -AVKSize.checkboxBigGapY)
CBamfbt:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBamfbt.text:SetText(AVKFont.avkBlueText .. ' Aardvark Button Tooltip')
CBamfbt.text:SetFontObject(avkCheckBoxBigFont)
CBamfbt:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Aardvark.amfbt == true then
            AVKGlobalSettings.Aardvark.amfbt = false
        else
            AVKGlobalSettings.Aardvark.amfbt = true
        end
    end
)

local CBafab = CreateFrame('CheckButton', 'CBafab', AardvarkAardvarkPanel, 'UICheckButtonTemplate')
CBafab:ClearAllPoints()
CBafab:SetPoint('TOPLEFT', CBamfbt, 0, -AVKSize.checkboxBigGapY)
CBafab:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBafab.text:SetText(AVKFont.avkBlueText .. ' Aardvark Action Bar')
CBafab.text:SetFontObject(avkCheckBoxBigFont)
CBafab:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Aardvark.afab == true then
            AVKGlobalSettings.Aardvark.afab = false
            CBafabas:Hide()
            CBafabv:Hide()
            AardvarkActionBar:Hide()
        else
            AVKGlobalSettings.Aardvark.afab = true
            if not AardvarkActionBar:IsVisible() then
                CBafabas:Show()
                CBafabv:Show()
                AardvarkActionBar:Show()
            end
        end
    end
)

local CBafabas = CreateFrame('CheckButton', 'CBafabas', AardvarkAardvarkPanel, 'UICheckButtonTemplate')
CBafabas:ClearAllPoints()
CBafabas:SetPoint('TOPLEFT', CBafab, AVKSize.checkBoxChildGapX, -AVKSize.checkboxBigGapY)
CBafabas:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBafabas.text:SetText(' Always Show Action Bar')
CBafabas.text:SetFontObject(avkCheckBoxFont)
CBafabas:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Aardvark.afabas == true then
            AVKGlobalSettings.Aardvark.afabas = false
            toggleFloatingActionBar()
        else
            AVKGlobalSettings.Aardvark.afabas = true
            AardvarkActionBar:Show()
        end
    end
)

local CBafabv = CreateFrame('CheckButton', 'CBafabv', AardvarkAardvarkPanel, 'UICheckButtonTemplate')
CBafabv:ClearAllPoints()
CBafabv:SetPoint('TOPLEFT', CBafabas, 0, -AVKSize.checkboxGapY)
CBafabv:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBafabv.text:SetText(' Verticle Align Action Bar')
CBafabv.text:SetFontObject(avkCheckBoxFont)
CBafabv:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Aardvark.afabv == true then
            AVKGlobalSettings.Aardvark.afabv = false
            toggleVerticleActionBar()
        else
            AVKGlobalSettings.Aardvark.afabv = true
            toggleVerticleActionBar()
        end
    end
)

local AardvarkAardvarkPanelTextBox = CreateFrame('Frame', 'AardvarkAardvarkPanelTextBox', AardvarkAardvarkPanel)
AardvarkAardvarkPanelTextBox:SetSize(AVKSize.mainPanelWidth - AVKSize.textBoxWidthShrink, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkAardvarkPanelTextBox:SetPoint('BOTTOMLEFT', AVKSize.mainPanelElementGap, AVKSize.mainPanelElementGap)
AardvarkAardvarkPanelText = AardvarkAardvarkPanelTextBox:CreateFontString('AardvarkAardvarkPanelText')
AardvarkAardvarkPanelText:SetJustifyH('LEFT')
AardvarkAardvarkPanelText:SetJustifyV('BOTTOM')
AardvarkAardvarkPanelText:SetAllPoints(AardvarkAardvarkPanelTextBox)
AardvarkAardvarkPanelText:SetFontObject(avkContentFont)
AardvarkAardvarkPanelText:SetText(AVKText.avkOptions)

local AardvarkScaleFrameButton = CreateFrame('Button', 'AardvarkScaleFrameButton', AardvarkAardvarkPanel, 'UIMenuButtonStretchTemplate')
AardvarkScaleFrameButton:SetSize(AVKSize.scrollFrameWidth * .25, AVKSize.clearButtonHight)
AardvarkScaleFrameButton:SetPoint('BOTTOMRIGHT', -10, 10)
AardvarkScaleFrameButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkScaleFrameButton:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkScaleFrameButton:SetNormalFontObject(avkButtonFont)
AardvarkScaleFrameButton:SetHighlightFontObject(avkButtonFont)
AardvarkScaleFrameButton:SetFormattedText('Scale')
AardvarkScaleFrameButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkScaleFrameButton)
    end
)

--===================         AardvarkSideOptionsPanel         ============================
local AardvarkSideOptionsPanel = CreateFrame('Frame', 'AardvarkSideOptionsPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkSideOptionsPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSideOptionsPanel:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkSideOptionsPanel:SetPoint('TOPLEFT', AardvarkMainFrame, 'TOPRIGHT', AVKSize.mainFrameMarginGap)
AardvarkSideOptionsPanel:SetSize(AVKSize.optionsFrameWidth, AVKSize.mainFrameHeight)
AardvarkSideOptionsPanel:SetParent(AardvarkMainFrame)
AardvarkSideOptionsPanel:SetToplevel(true)
AardvarkSideOptionsPanel:Hide()

local AardvarkSideFrameCloseButton = CreateFrame('Button', 'AardvarkSideFrameCloseButton', AardvarkSideOptionsPanel)
AardvarkSideFrameCloseButton:SetPoint('TOPRIGHT', AVKSize.closeButtonGap, AVKSize.closeButtonGap)
AardvarkSideFrameCloseButton:SetSize(AVKSize.closeButtonSize, AVKSize.closeButtonSize)
AardvarkSideFrameCloseButton:SetNormalTexture(AVKImg.avkci)
AardvarkSideFrameCloseButton:SetHighlightTexture(AVKImg.avkci, 'ADD')
AardvarkSideFrameCloseButton:SetScript(
    'OnClick',
    function(self)
        AardvarkSideOptionsPanel:Hide()
    end
)

--===================         AardvarkSellOptionsPanel         ============================
local AardvarkSellOptionsPanel = CreateFrame('Frame', 'AardvarkSellOptionsPanel', AardvarkSideOptionsPanel)
AardvarkSellOptionsPanel:SetSize(AVKSize.mainFrameWidth / 2 + AVKSize.mainFrameMarginGap * 2, AVKSize.mainFrameHeight)
AardvarkSellOptionsPanel:SetPoint('TOP', AardvarkSideOptionsPanel, 'TOP', AVKSize.mainFrameMarginGap)
AardvarkSellOptionsPanel:Hide()

local CBses = CreateFrame('CheckButton', 'CBses', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBses:ClearAllPoints()
CBses:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap * 1.5)
CBses:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBses.text:SetText(AVKFont.avkGreenText .. ' Aardvark Sell')
CBses.text:SetFontObject(avkCheckBoxBigFont)
CBses:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.ses == true then
            AVKGlobalSettings.Sell.ses = false
            CBseas:Hide()
            CBseasg:Hide()
            CBstil:Hide()
            CBsdsm:Hide()
            CBsntsm:Hide()
            CBsialsm:Hide()
            CBsialfm:Hide()
            CBslit:Hide()
        else
            AVKGlobalSettings.Sell.ses = true
            CBseas:Show()
            CBseasg:Show()
            CBstil:Show()
            CBsdsm:Show()
            CBsntsm:Show()
            CBsialsm:Show()
            CBsialfm:Show()
            CBslit:Show()
        end
    end
)

local CBseas = CreateFrame('CheckButton', 'CBseas', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBseas:ClearAllPoints()
CBseas:SetPoint('TOPLEFT', CBses, AVKSize.checkBoxChildGapX, -AVKSize.checkboxGapY * 1.2)
CBseas:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBseas.text:SetText(' Auto Sell')
CBseas.text:SetFontObject(avkCheckBoxFont)
CBseas:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.seas == true then
            AVKGlobalSettings.Sell.seas = false
        else
            AVKGlobalSettings.Sell.seas = true
        end
    end
)

local CBseasg = CreateFrame('CheckButton', 'CBseasg', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBseasg:ClearAllPoints()
CBseasg:SetPoint('TOPLEFT', CBseas, 0, -AVKSize.checkboxGapY)
CBseasg:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBseasg.text:SetText(' Auto Sell Greys')
CBseasg.text:SetFontObject(avkCheckBoxFont)
CBseasg:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.seasg == true then
            AVKGlobalSettings.Sell.seasg = false
        else
            AVKGlobalSettings.Sell.seasg = true
        end
    end
)

local CBstil = CreateFrame('CheckButton', 'CBstil', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBstil:ClearAllPoints()
CBstil:SetPoint('TOPLEFT', CBseasg, 0, -AVKSize.checkboxGapY)
CBstil:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBstil.text:SetText(' Sell 12 Items At A Time')
CBstil.text:SetFontObject(avkCheckBoxFont)
CBstil:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.stil == true then
            AVKGlobalSettings.Sell.stil = false
        else
            AVKGlobalSettings.Sell.stil = true
        end
    end
)

local CBsdsm = CreateFrame('CheckButton', 'CBsdsm', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBsdsm:ClearAllPoints()
CBsdsm:SetPoint('TOPLEFT', CBstil, 0, -AVKSize.checkboxGapY)
CBsdsm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBsdsm.text:SetText(' Detailed Sell Messages')
CBsdsm.text:SetFontObject(avkCheckBoxFont)
CBsdsm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.sdsm == true then
            AVKGlobalSettings.Sell.sdsm = false
        else
            AVKGlobalSettings.Sell.sdsm = true
        end
    end
)

local CBsntsm = CreateFrame('CheckButton', 'CBsntsm', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBsntsm:ClearAllPoints()
CBsntsm:SetPoint('TOPLEFT', CBsdsm, 0, -AVKSize.checkboxGapY)
CBsntsm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBsntsm.text:SetText(' Nothing To Sell Messages')
CBsntsm.text:SetFontObject(avkCheckBoxFont)
CBsntsm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.sntsm == true then
            AVKGlobalSettings.Sell.sntsm = false
        else
            AVKGlobalSettings.Sell.sntsm = true
        end
    end
)

local CBsialsm = CreateFrame('CheckButton', 'CBsialsm', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBsialsm:ClearAllPoints()
CBsialsm:SetPoint('TOPLEFT', CBsntsm, 0, -AVKSize.checkboxGapY)
CBsialsm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBsialsm.text:SetText(' Item Added Messages')
CBsialsm.text:SetFontObject(avkCheckBoxFont)
CBsialsm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.sialsm == true then
            AVKGlobalSettings.Sell.sialsm = false
        else
            AVKGlobalSettings.Sell.sialsm = true
        end
    end
)

local CBsialfm = CreateFrame('CheckButton', 'CBsialfm', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBsialfm:ClearAllPoints()
CBsialfm:SetPoint('TOPLEFT', CBsialsm, 0, -AVKSize.checkboxGapY)
CBsialfm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBsialfm.text:SetText(' Item Not Added Messages')
CBsialfm.text:SetFontObject(avkCheckBoxFont)
CBsialfm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.sialfm == true then
            AVKGlobalSettings.Sell.sialfm = false
        else
            AVKGlobalSettings.Sell.sialfm = true
        end
    end
)

local CBslit = CreateFrame('CheckButton', 'CBslit', AardvarkSellOptionsPanel, 'UICheckButtonTemplate')
CBslit:ClearAllPoints()
CBslit:SetPoint('TOPLEFT', CBsialfm, 0, -AVKSize.checkboxGapY)
CBslit:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBslit.text:SetText(' Show Listed Item Tooltips')
CBslit.text:SetFontObject(avkCheckBoxFont)
CBslit:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Sell.slit == true then
            AVKGlobalSettings.Sell.slit = false
        else
            AVKGlobalSettings.Sell.slit = true
        end
    end
)

local AardvarkSellOptionsPanelTextBox = CreateFrame('Frame', 'AardvarkSellOptionsPanelTextBox', AardvarkSellOptionsPanel)
AardvarkSellOptionsPanelTextBox:SetSize(AVKSize.mainFrameWidth / 2, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkSellOptionsPanelTextBox:SetPoint('BOTTOM', AardvarkSideOptionsPanel, 'BOTTOM', 0, AVKSize.checkBoxChildGapX)
AardvarkSellOptionsPanelText = AardvarkSellOptionsPanelTextBox:CreateFontString('AardvarkSellOptionsPanelText')
AardvarkSellOptionsPanelText:SetJustifyH('BOTTOM')
AardvarkSellOptionsPanelText:SetJustifyV('BOTTOM')
AardvarkSellOptionsPanelText:SetAllPoints(AardvarkSellOptionsPanelTextBox)
AardvarkSellOptionsPanelText:SetFontObject(avkContentFont)
AardvarkSellOptionsPanelText:SetText(AVKText.avkSellOptions)

--===================         AardvarkSellPanel         ============================
local AardvarkSellPanel = CreateFrame('Frame', 'AardvarkSellPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkSellPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSellPanel:SetBackdropBorderColor(0, 1, 0, 1)
AardvarkSellPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkSellPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkSellPanel:Hide()

local AardvarkSellOptionsButton = CreateFrame('Button', 'AardvarkSellOptionsButton', AardvarkSellPanel)
AardvarkSellOptionsButton:SetSize(AVKSize.optionsButtonSize, AVKSize.optionsButtonSize)
AardvarkSellOptionsButton:SetPoint('CENTER', AardvarkNavigationSillyButton, AVKSize.mainFrameNavigationButtonSpace * .5 + AVKSize.optionsButtonSize, 0)
AardvarkSellOptionsButton:SetNormalTexture(AVKImg.avksoi)
AardvarkSellOptionsButton:SetHighlightTexture(AVKImg.avksoi_alt, 'BLEND')
AardvarkSellOptionsButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkSellOptionsButton)
    end
)

-- Global Sell
local AardvarkSellGlobalTitle = CreateFrame('Frame', 'AardvarkSellGlobalTitle', AardvarkSellPanel)
AardvarkSellGlobalTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkSellGlobalTitle:SetPoint('TOPLEFT', AardvarkSellPanel, AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkSellGlobalTitleText = AardvarkSellGlobalTitle:CreateFontString('AardvarkSellGlobalTitleText')
AardvarkSellGlobalTitleText:SetPoint('CENTER', 0, 0)
AardvarkSellGlobalTitleText:SetJustifyH('CENTER')
AardvarkSellGlobalTitleText:SetJustifyV('CENTER')
AardvarkSellGlobalTitleText:SetAllPoints(AardvarkSellGlobalTitle)
AardvarkSellGlobalTitleText:SetFontObject(avkScrollTitleFont)
AardvarkSellGlobalTitleText:SetText('Global Sell List')

local AardvarkSellGlobalScrollParent = CreateFrame('Button', 'AardvarkSellGlobalScrollParent', AardvarkSellPanel, 'TooltipBorderedFrameTemplate')
AardvarkSellGlobalScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSellGlobalScrollParent:SetBackdropBorderColor(0, 1, 0, 1)
AardvarkSellGlobalScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkSellGlobalScrollParent:SetPoint('TOP', AardvarkSellGlobalTitle, 'BOTTOM', 0, -8)
AardvarkSellGlobalScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToGlobalList()
    end
)
AardvarkSellGlobalScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToGlobalList()
        end
    end
)

local AardvarkSellGlobalScrollFrame = CreateFrame('ScrollFrame', 'AardvarkSellGlobalScrollFrame', AardvarkSellGlobalScrollParent, 'FauxScrollFrameTemplate')
AardvarkSellGlobalScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkSellGlobalScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkSellGlobalScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkSellGlobalScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkSellGlobalScrollFrame.buttons[i] = CreateFrame('Button', 'sglb' .. i, AardvarkSellGlobalScrollParent)
    local button = AardvarkSellGlobalScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            --	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKGlobalSellList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_LEFT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Sell.slit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToGlobalList()
                    else
                        if AVKGlobalSettings.Sell.slit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKGlobalSellList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToGlobalList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkSellGlobalClearListButton = CreateFrame('Button', 'AardvarkSellGlobalClearListButton', AardvarkSellPanel, 'UIMenuButtonStretchTemplate')
AardvarkSellGlobalClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkSellGlobalClearListButton:SetPoint('TOP', AardvarkSellGlobalScrollParent, 'BOTTOM', 0, -5)
AardvarkSellGlobalClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSellGlobalClearListButton:SetBackdropBorderColor(0, 1, 0, 1)
AardvarkSellGlobalClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkSellGlobalClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkSellGlobalClearListButton:SetFormattedText('Clear Global Sell List')
AardvarkSellGlobalClearListButton:RegisterForClicks('RightButtonUp')
AardvarkSellGlobalClearListButton:SetScript(
    'OnClick',
    function()
        AVKGlobalSellList = {}
        avkUpdateLists()
    end
)

-- Character Sell
local AardvarkSellLocalTitle = CreateFrame('Frame', 'AardvarkSellLocalTitle', AardvarkSellPanel)
AardvarkSellLocalTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkSellLocalTitle:SetPoint('TOPRIGHT', AardvarkSellPanel, -AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkSellLocalTitleText = AardvarkSellLocalTitle:CreateFontString('AardvarkSellLocalTitleText')
AardvarkSellLocalTitleText:SetPoint('CENTER', 0, 0)
AardvarkSellLocalTitleText:SetJustifyH('CENTER')
AardvarkSellLocalTitleText:SetJustifyV('CENTER')
AardvarkSellLocalTitleText:SetAllPoints(AardvarkSellLocalTitle)
AardvarkSellLocalTitleText:SetFontObject(avkScrollTitleFont)
AardvarkSellLocalTitleText:SetText(playerName .. "'s\nSell List")

local AardvarkSellCharacterScrollParent = CreateFrame('Button', 'AardvarkSellCharacterScrollParent', AardvarkSellPanel, 'TooltipBorderedFrameTemplate')
AardvarkSellCharacterScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSellCharacterScrollParent:SetBackdropBorderColor(0, 1, 0, 1)
AardvarkSellCharacterScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkSellCharacterScrollParent:SetPoint('TOP', AardvarkSellLocalTitle, 'BOTTOM', 0, -8)
AardvarkSellCharacterScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToCharacterList()
    end
)
AardvarkSellCharacterScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToCharacterList()
        end
    end
)

local AardvarkSellCharacterScrollFrame = CreateFrame('ScrollFrame', 'AardvarkSellCharacterScrollFrame', AardvarkSellCharacterScrollParent, 'FauxScrollFrameTemplate')
AardvarkSellCharacterScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkSellCharacterScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkSellCharacterScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkSellCharacterScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkSellCharacterScrollFrame.buttons[i] = CreateFrame('Button', 'sclb' .. i, AardvarkSellCharacterScrollParent)
    local button = AardvarkSellCharacterScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            --	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKCharacterSellList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_RIGHT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Sell.slit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToCharacterList()
                    else
                        if AVKGlobalSettings.Sell.slit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKCharacterSellList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToCharacterList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkSellCharacterClearListButton = CreateFrame('Button', 'AardvarkSellCharacterClearListButton', AardvarkSellPanel, 'UIMenuButtonStretchTemplate')
AardvarkSellCharacterClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkSellCharacterClearListButton:SetPoint('TOP', AardvarkSellCharacterScrollParent, 'BOTTOM', 0, -5)
AardvarkSellCharacterClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSellCharacterClearListButton:SetBackdropBorderColor(0, 1, 0, 1)
AardvarkSellCharacterClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkSellCharacterClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkSellCharacterClearListButton:SetFormattedText('Clear ' .. playerName .. "'s Sell List")
AardvarkSellCharacterClearListButton:RegisterForClicks('RightButtonUp')
AardvarkSellCharacterClearListButton:SetScript(
    'OnClick',
    function()
        AVKCharacterSellList = {}
        avkUpdateLists()
    end
)

--===================         AardvarkDestroyOptionsPanel         ============================
local AardvarkDestroyOptionsPanel = CreateFrame('Frame', 'AardvarkDestroyOptionsPanel', AardvarkSideOptionsPanel)

AardvarkDestroyOptionsPanel:SetSize(AVKSize.mainFrameWidth / 2 + AVKSize.mainFrameMarginGap * 2, AVKSize.mainFrameHeight)
AardvarkDestroyOptionsPanel:SetPoint('TOP', AardvarkSideOptionsPanel, 'TOP', AVKSize.mainFrameMarginGap)
AardvarkDestroyOptionsPanel:Hide()

local CBded = CreateFrame('CheckButton', 'CBded', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBded:ClearAllPoints()
CBded:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap * 1.5)
CBded:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBded.text:SetText(AVKFont.avkRedText .. ' Aardvark Destroy')
CBded.text:SetFontObject(avkCheckBoxBigFont)
CBded:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.ded == true then
            AVKGlobalSettings.Destroy.ded = false
            CBdead:Hide()
            CBdddm:Hide()
            CBdntdm:Hide()
            CBdialsm:Hide()
            CBdialfm:Hide()
            CBdlit:Hide()
        else
            AVKGlobalSettings.Destroy.ded = true
            CBdead:Show()
            CBdddm:Show()
            CBdntdm:Show()
            CBdialsm:Show()
            CBdialfm:Show()
            CBdlit:Show()
        end
    end
)

local CBdead = CreateFrame('CheckButton', 'CBdead', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdead:ClearAllPoints()
CBdead:SetPoint('TOPLEFT', CBded, AVKSize.checkBoxChildGapX, -AVKSize.checkboxGapY * 1.2)
CBdead:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdead.text:SetText(' Auto Destroy')
CBdead.text:SetFontObject(avkCheckBoxFont)
CBdead:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dead == true then
            AVKGlobalSettings.Destroy.dead = false
        else
            AVKGlobalSettings.Destroy.dead = true
        end
    end
)

local CBdddm = CreateFrame('CheckButton', 'CBdddm', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdddm:ClearAllPoints()
CBdddm:SetPoint('TOPLEFT', CBdead, 0, -AVKSize.checkboxGapY)
CBdddm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdddm.text:SetText(' Detailed Destroy Messages')
CBdddm.text:SetFontObject(avkCheckBoxFont)
CBdddm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dddm == true then
            AVKGlobalSettings.Destroy.dddm = false
        else
            AVKGlobalSettings.Destroy.dddm = true
        end
    end
)

local CBdntdm = CreateFrame('CheckButton', 'CBdntdm', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdntdm:ClearAllPoints()
CBdntdm:SetPoint('TOPLEFT', CBdddm, 0, -AVKSize.checkboxGapY)
CBdntdm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdntdm.text:SetText(' Nothing To Destroy Messages')
CBdntdm.text:SetFontObject(avkCheckBoxFont)
CBdntdm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dntdm == true then
            AVKGlobalSettings.Destroy.dntdm = false
        else
            AVKGlobalSettings.Destroy.dntdm = true
        end
    end
)

local CBdialsm = CreateFrame('CheckButton', 'CBdialsm', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdialsm:ClearAllPoints()
CBdialsm:SetPoint('TOPLEFT', CBdntdm, 0, -AVKSize.checkboxGapY)
CBdialsm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdialsm.text:SetText(' Item Added Messages')
CBdialsm.text:SetFontObject(avkCheckBoxFont)
CBdialsm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dialsm == true then
            AVKGlobalSettings.Destroy.dialsm = false
        else
            AVKGlobalSettings.Destroy.dialsm = true
        end
    end
)

local CBdialfm = CreateFrame('CheckButton', 'CBdialfm', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdialfm:ClearAllPoints()
CBdialfm:SetPoint('TOPLEFT', CBdialsm, 0, -AVKSize.checkboxGapY)
CBdialfm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdialfm.text:SetText(' Item Not Added Messages')
CBdialfm.text:SetFontObject(avkCheckBoxFont)
CBdialfm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dialfm == true then
            AVKGlobalSettings.Destroy.dialfm = false
        else
            AVKGlobalSettings.Destroy.dialfm = true
        end
    end
)

local CBdlit = CreateFrame('CheckButton', 'CBdlit', AardvarkDestroyOptionsPanel, 'UICheckButtonTemplate')
CBdlit:ClearAllPoints()
CBdlit:SetPoint('TOPLEFT', CBdialfm, 0, -AVKSize.checkboxGapY)
CBdlit:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBdlit.text:SetText(' Show Listed Item Tooltips')
CBdlit.text:SetFontObject(avkCheckBoxFont)
CBdlit:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Destroy.dlit == true then
            AVKGlobalSettings.Destroy.dlit = false
        else
            AVKGlobalSettings.Destroy.dlit = true
        end
    end
)

local AardvarkDestroyOptionsPanelTextBox = CreateFrame('Frame', 'AardvarkDestroyOptionsPanelTextBox', AardvarkDestroyOptionsPanel)
AardvarkDestroyOptionsPanelTextBox:SetSize(AVKSize.optionsFrameWidth - AVKSize.optionsFrameElementGap * 4, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkDestroyOptionsPanelTextBox:SetPoint('BOTTOM', AardvarkSideOptionsPanel, 'BOTTOM', 0, AVKSize.checkBoxChildGapX)
AardvarkDestroyOptionsPanelText = AardvarkDestroyOptionsPanelTextBox:CreateFontString('AardvarkDestroyOptionsPanelText')
AardvarkDestroyOptionsPanelText:SetJustifyH('BOTTOM')
AardvarkDestroyOptionsPanelText:SetJustifyV('BOTTOM')
AardvarkDestroyOptionsPanelText:SetAllPoints(AardvarkDestroyOptionsPanelTextBox)
AardvarkDestroyOptionsPanelText:SetFontObject(avkContentFont)
AardvarkDestroyOptionsPanelText:SetText(AVKText.avkDestroyOptions)

--===================         AardvarkDestroyPanel         ============================
local AardvarkDestroyPanel = CreateFrame('Frame', 'AardvarkDestroyPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkDestroyPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkDestroyPanel:SetBackdropBorderColor(1, 0, 0, 1)
AardvarkDestroyPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkDestroyPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkDestroyPanel:Hide()

local AardvarkDestroyOptionsButton = CreateFrame('Button', 'AardvarkDestroyOptionsButton', AardvarkDestroyPanel)
AardvarkDestroyOptionsButton:SetSize(AVKSize.optionsButtonSize, AVKSize.optionsButtonSize)
AardvarkDestroyOptionsButton:SetPoint('CENTER', AardvarkNavigationSillyButton, AVKSize.mainFrameNavigationButtonSpace * .5 + AVKSize.optionsButtonSize, 0)
AardvarkDestroyOptionsButton:SetNormalTexture(AVKImg.avkdoi)
AardvarkDestroyOptionsButton:SetHighlightTexture(AVKImg.avkdoi_alt, 'BLEND')
AardvarkDestroyOptionsButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkDestroyOptionsButton)
    end
)

-- Global Destroy
local AardvarkDestroyGlobalTitle = CreateFrame('Frame', 'AardvarkDestroyGlobalTitle', AardvarkDestroyPanel)
AardvarkDestroyGlobalTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkDestroyGlobalTitle:SetPoint('TOPLEFT', AardvarkDestroyPanel, AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkDestroyGlobalTitleText = AardvarkDestroyGlobalTitle:CreateFontString('AardvarkDestroyGlobalTitleText')
AardvarkDestroyGlobalTitleText:SetPoint('CENTER', 0, 0)
AardvarkDestroyGlobalTitleText:SetJustifyH('CENTER')
AardvarkDestroyGlobalTitleText:SetJustifyV('CENTER')
AardvarkDestroyGlobalTitleText:SetAllPoints(AardvarkDestroyGlobalTitle)
AardvarkDestroyGlobalTitleText:SetFontObject(avkScrollTitleFont)
AardvarkDestroyGlobalTitleText:SetText('Global Destroy List')

local AardvarkDestroyGlobalScrollParent = CreateFrame('Button', 'AardvarkDestroyGlobalScrollParent', AardvarkDestroyPanel, 'TooltipBorderedFrameTemplate')
AardvarkDestroyGlobalScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkDestroyGlobalScrollParent:SetBackdropBorderColor(1, 0, 0, 1)
AardvarkDestroyGlobalScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkDestroyGlobalScrollParent:SetPoint('TOP', AardvarkDestroyGlobalTitle, 'BOTTOM', 0, -8)
AardvarkDestroyGlobalScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToGlobalList()
    end
)
AardvarkDestroyGlobalScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToGlobalList()
        end
    end
)

local AardvarkDestroyGlobalScrollFrame = CreateFrame('ScrollFrame', 'AardvarkDestroyGlobalScrollFrame', AardvarkDestroyGlobalScrollParent, 'FauxScrollFrameTemplate')
AardvarkDestroyGlobalScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkDestroyGlobalScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkDestroyGlobalScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkDestroyGlobalScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkDestroyGlobalScrollFrame.buttons[i] = CreateFrame('Button', 'dglb' .. i, AardvarkDestroyGlobalScrollParent)
    local button = AardvarkDestroyGlobalScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            --	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKGlobalDestroyList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_LEFT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Destroy.dlit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToGlobalList()
                    else
                        if AVKGlobalSettings.Destroy.dlit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKGlobalDestroyList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToGlobalList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkDestroyGlobalClearListButton = CreateFrame('Button', 'AardvarkDestroyGlobalClearListButton', AardvarkDestroyPanel, 'UIMenuButtonStretchTemplate')
AardvarkDestroyGlobalClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkDestroyGlobalClearListButton:SetPoint('TOP', AardvarkDestroyGlobalScrollParent, 'BOTTOM', 0, -5)
AardvarkDestroyGlobalClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkDestroyGlobalClearListButton:SetBackdropBorderColor(1, 0, 0, 1)
AardvarkDestroyGlobalClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkDestroyGlobalClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkDestroyGlobalClearListButton:SetFormattedText('Clear Global Destroy List')
AardvarkDestroyGlobalClearListButton:RegisterForClicks('RightButtonUp')
AardvarkDestroyGlobalClearListButton:SetScript(
    'OnClick',
    function()
        AVKGlobalDestroyList = {}
        avkUpdateLists()
    end
)

-- Character Destroy
local AardvarkDestroyCharacterTitle = CreateFrame('Frame', 'AardvarkDestroyCharacterTitle', AardvarkDestroyPanel)
AardvarkDestroyCharacterTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkDestroyCharacterTitle:SetPoint('TOPRIGHT', AardvarkDestroyPanel, -AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkDestroyCharacterTitleText = AardvarkDestroyCharacterTitle:CreateFontString('AardvarkDestroyCharacterTitleText')
AardvarkDestroyCharacterTitleText:SetPoint('CENTER', 0, 0)
AardvarkDestroyCharacterTitleText:SetJustifyH('CENTER')
AardvarkDestroyCharacterTitleText:SetJustifyV('CENTER')
AardvarkDestroyCharacterTitleText:SetAllPoints(AardvarkDestroyCharacterTitle)
AardvarkDestroyCharacterTitleText:SetFontObject(avkScrollTitleFont)
AardvarkDestroyCharacterTitleText:SetText(playerName .. "'s\nDestroy List")

local AardvarkDestroyCharacterScrollParent = CreateFrame('Button', 'AardvarkDestroyCharacterScrollParent', AardvarkDestroyPanel, 'TooltipBorderedFrameTemplate')
AardvarkDestroyCharacterScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkDestroyCharacterScrollParent:SetBackdropBorderColor(1, 0, 0, 1)
AardvarkDestroyCharacterScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkDestroyCharacterScrollParent:SetPoint('TOP', AardvarkDestroyCharacterTitle, 'BOTTOM', 0, -8)
AardvarkDestroyCharacterScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToCharacterList()
    end
)
AardvarkDestroyCharacterScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToCharacterList()
        end
    end
)

local AardvarkDestroyCharacterScrollFrame = CreateFrame('ScrollFrame', 'AardvarkDestroyCharacterScrollFrame', AardvarkDestroyCharacterScrollParent, 'FauxScrollFrameTemplate')
AardvarkDestroyCharacterScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkDestroyCharacterScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkDestroyCharacterScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkDestroyCharacterScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkDestroyCharacterScrollFrame.buttons[i] = CreateFrame('Button', 'dclb' .. i, AardvarkDestroyCharacterScrollParent)
    local button = AardvarkDestroyCharacterScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            --	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKCharacterDestroyList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_RIGHT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Destroy.dlit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToCharacterList()
                    else
                        if AVKGlobalSettings.Destroy.dlit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKCharacterDestroyList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToCharacterList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkDestroyCharacterClearListButton = CreateFrame('Button', 'AardvarkDestroyCharacterClearListButton', AardvarkDestroyPanel, 'UIMenuButtonStretchTemplate')
AardvarkDestroyCharacterClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkDestroyCharacterClearListButton:SetPoint('TOP', AardvarkDestroyCharacterScrollParent, 'BOTTOM', 0, -5)
AardvarkDestroyCharacterClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkDestroyCharacterClearListButton:SetBackdropBorderColor(1, 0, 0, 1)
AardvarkDestroyCharacterClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkDestroyCharacterClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkDestroyCharacterClearListButton:SetFormattedText('Clear ' .. playerName .. "'s Destroy List")
AardvarkDestroyCharacterClearListButton:RegisterForClicks('RightButtonUp')
AardvarkDestroyCharacterClearListButton:SetScript(
    'OnClick',
    function()
        AVKCharacterDestroyList = {}
        avkUpdateLists()
    end
)

--===================         AardvarkProtectOptionsPanel         ============================
local AardvarkProtectOptionsPanel = CreateFrame('Frame', 'AardvarkProtectOptionsPanel', AardvarkSideOptionsPanel)
AardvarkProtectOptionsPanel:SetSize(AVKSize.mainFrameWidth / 2 + AVKSize.mainFrameMarginGap * 2, AVKSize.mainFrameHeight)
AardvarkProtectOptionsPanel:SetPoint('TOP', AardvarkSideOptionsPanel, 'TOP', AVKSize.mainFrameMarginGap)
AardvarkProtectOptionsPanel:Hide()

local CBpep = CreateFrame('CheckButton', 'CBpep', AardvarkProtectOptionsPanel, 'UICheckButtonTemplate')
CBpep:ClearAllPoints()
CBpep:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap * 1.5)
CBpep:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBpep.text:SetText(AVKFont.avkOrangeText .. ' Aardvark Protect')
CBpep.text:SetFontObject(avkCheckBoxBigFont)
CBpep:SetChecked(true)
CBpep:EnableMouse(false)

local CBpialsm = CreateFrame('CheckButton', 'CBpialsm', AardvarkProtectOptionsPanel, 'UICheckButtonTemplate')
CBpialsm:ClearAllPoints()
CBpialsm:SetPoint('TOPLEFT', CBpep, AVKSize.checkBoxChildGapX * 1.5, -AVKSize.checkboxGapY * 1.2)
CBpialsm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBpialsm.text:SetText(' Item Added Messages')
CBpialsm.text:SetFontObject(avkCheckBoxFont)
CBpialsm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Protect.pialsm == true then
            AVKGlobalSettings.Protect.pialsm = false
        else
            AVKGlobalSettings.Protect.pialsm = true
        end
    end
)

local CBpdpm = CreateFrame('CheckButton', 'CBpdpm', AardvarkProtectOptionsPanel, 'UICheckButtonTemplate')
CBpdpm:ClearAllPoints()
CBpdpm:SetPoint('TOPLEFT', CBpialsm, 0, -AVKSize.checkboxGapY)
CBpdpm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBpdpm.text:SetText(' Protected Item Messages')
CBpdpm.text:SetFontObject(avkCheckBoxFont)
CBpdpm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Protect.pdpm == true then
            AVKGlobalSettings.Protect.pdpm = false
        else
            AVKGlobalSettings.Protect.pdpm = true
        end
    end
)

local CBpcbp = CreateFrame('CheckButton', 'CBpcbp', AardvarkProtectOptionsPanel, 'UICheckButtonTemplate')
CBpcbp:ClearAllPoints()
CBpcbp:SetPoint('TOPLEFT', CBpdpm, 0, -AVKSize.checkboxGapY)
CBpcbp:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBpcbp.text:SetText(' Protect Caged Battle Pets')
CBpcbp.text:SetFontObject(avkCheckBoxFont)
CBpcbp:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Protect.pcbp == true then
            AVKGlobalSettings.Protect.pcbp = false
        else
            AVKGlobalSettings.Protect.pcbp = true
        end
        avkUpdateLists()
    end
)

local CBplit = CreateFrame('CheckButton', 'CBplit', AardvarkProtectOptionsPanel, 'UICheckButtonTemplate')
CBplit:ClearAllPoints()
CBplit:SetPoint('TOPLEFT', CBpcbp, 0, -AVKSize.checkboxGapY)
CBplit:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBplit.text:SetText(' Show Listed Item Tooltips')
CBplit.text:SetFontObject(avkCheckBoxFont)
CBplit:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Protect.plit == true then
            AVKGlobalSettings.Protect.plit = false
        else
            AVKGlobalSettings.Protect.plit = true
        end
    end
)

local AardvarkProtectOptionsPanelTextBox = CreateFrame('Frame', 'AardvarkProtectOptionsPanelTextBox', AardvarkProtectOptionsPanel)
AardvarkProtectOptionsPanelTextBox:SetSize(AVKSize.mainFrameWidth / 2, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkProtectOptionsPanelTextBox:SetPoint('BOTTOM', AardvarkSideOptionsPanel, 'BOTTOM', 0, AVKSize.checkBoxChildGapX)
AardvarkProtectOptionsPanelText = AardvarkProtectOptionsPanelTextBox:CreateFontString('AardvarkProtectOptionsPanelText')
AardvarkProtectOptionsPanelText:SetJustifyH('BOTTOM')
AardvarkProtectOptionsPanelText:SetJustifyV('BOTTOM')
AardvarkProtectOptionsPanelText:SetAllPoints(AardvarkProtectOptionsPanelTextBox)
AardvarkProtectOptionsPanelText:SetFontObject(avkContentFont)
AardvarkProtectOptionsPanelText:SetText(AVKText.avkProtectOptions)

--===================          AardvarkProtectPanel         ============================
local AardvarkProtectPanel = CreateFrame('Frame', 'AardvarkProtectPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkProtectPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkProtectPanel:SetBackdropBorderColor(1, .5, 0, 1)
AardvarkProtectPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkProtectPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkProtectPanel:Hide()

local AardvarkProtectOptionsButton = CreateFrame('Button', 'AardvarkProtectOptionsButton', AardvarkProtectPanel)
AardvarkProtectOptionsButton:SetSize(AVKSize.optionsButtonSize, AVKSize.optionsButtonSize)
AardvarkProtectOptionsButton:SetPoint('CENTER', AardvarkNavigationSillyButton, AVKSize.mainFrameNavigationButtonSpace * .5 + AVKSize.optionsButtonSize, 0)
AardvarkProtectOptionsButton:SetNormalTexture(AVKImg.avkpoi)
AardvarkProtectOptionsButton:SetHighlightTexture(AVKImg.avkpoi_alt, 'BLEND')
AardvarkProtectOptionsButton:SetScript(
    'OnClick',
    function()
        toggleAVKPanels(AardvarkProtectOptionsButton)
    end
)

-- Global Protect
local AardvarkProtectGlobalTitle = CreateFrame('Frame', 'AardvarkProtectGlobalTitle', AardvarkProtectPanel)
AardvarkProtectGlobalTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkProtectGlobalTitle:SetPoint('TOPLEFT', AardvarkProtectPanel, AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkProtectPanelTitleText = AardvarkProtectGlobalTitle:CreateFontString('AardvarkProtectPanelTitleText')
AardvarkProtectPanelTitleText:SetPoint('CENTER', 0, 0)
AardvarkProtectPanelTitleText:SetJustifyH('CENTER')
AardvarkProtectPanelTitleText:SetJustifyV('CENTER')
AardvarkProtectPanelTitleText:SetAllPoints(AardvarkProtectGlobalTitle)
AardvarkProtectPanelTitleText:SetFontObject(avkScrollTitleFont)
AardvarkProtectPanelTitleText:SetText('Global Protect List')

local AardvarkProtectGlobalScrollParent = CreateFrame('Button', 'AardvarkProtectGlobalScrollParent', AardvarkProtectPanel, 'TooltipBorderedFrameTemplate')
AardvarkProtectGlobalScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkProtectGlobalScrollParent:SetBackdropBorderColor(1, .5, 0, 1)
AardvarkProtectGlobalScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkProtectGlobalScrollParent:SetPoint('TOP', AardvarkProtectGlobalTitle, 'BOTTOM', 0, -8)
AardvarkProtectGlobalScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToGlobalProtectList()
    end
)
AardvarkProtectGlobalScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToGlobalProtectList()
        end
    end
)

local AardvarkProtectGlobalScrollFrame = CreateFrame('ScrollFrame', 'AardvarkProtectGlobalScrollFrame', AardvarkProtectGlobalScrollParent, 'FauxScrollFrameTemplate')
AardvarkProtectGlobalScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkProtectGlobalScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkProtectGlobalScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkProtectGlobalScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkProtectGlobalScrollFrame.buttons[i] = CreateFrame('Button', 'pglb' .. i, AardvarkProtectGlobalScrollParent)
    local button = AardvarkProtectGlobalScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            --	local itemName,itemLink,itemRarity,itemLevel,itemMinLevel,itemType,itemSubType,itemStackCount,itemEquipLoc,iconFileDataID,itemSellPrice,itemClassID,itemSubClassID,bindType,expacID,itemSetID,isCraftingReagent=GetItemInfo(v)

            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKGlobalProtectList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_LEFT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Protect.plit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToGlobalProtectList()
                    else
                        if AVKGlobalSettings.Protect.plit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKGlobalProtectList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToGlobalProtectList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkProtectGlobalClearListButton = CreateFrame('Button', 'AardvarkProtectGlobalClearListButton', AardvarkProtectPanel, 'UIMenuButtonStretchTemplate')
AardvarkProtectGlobalClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkProtectGlobalClearListButton:SetPoint('TOP', AardvarkProtectGlobalScrollParent, 'BOTTOM', 0, -5)
AardvarkProtectGlobalClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkProtectGlobalClearListButton:SetBackdropBorderColor(1, .5, 0, 1)
AardvarkProtectGlobalClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkProtectGlobalClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkProtectGlobalClearListButton:SetFormattedText('Clear Global Protect List')
AardvarkProtectGlobalClearListButton:RegisterForClicks('RightButtonUp')
AardvarkProtectGlobalClearListButton:SetScript(
    'OnClick',
    function()
        AVKGlobalProtectList = {}
        avkUpdateLists()
    end
)

-- Character Protect
local AardvarkProtectCharacterTitle = CreateFrame('Frame', 'AardvarkProtectCharacterTitle', AardvarkProtectPanel)
AardvarkProtectCharacterTitle:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollTitleHeight)
AardvarkProtectCharacterTitle:SetPoint('TOPRIGHT', AardvarkProtectPanel, -AVKSize.scrollTitlePointX, AVKSize.scrollTitlePointY)
AardvarkProtectCharacterTitleText = AardvarkProtectCharacterTitle:CreateFontString('AardvarkProtectCharacterTitleText')
AardvarkProtectCharacterTitleText:SetPoint('CENTER', 0, 0)
AardvarkProtectCharacterTitleText:SetJustifyH('CENTER')
AardvarkProtectCharacterTitleText:SetJustifyV('CENTER')
AardvarkProtectCharacterTitleText:SetAllPoints(AardvarkProtectCharacterTitle)
AardvarkProtectCharacterTitleText:SetFontObject(avkScrollTitleFont)
AardvarkProtectCharacterTitleText:SetText(playerName .. "'s\nProtect List")

local AardvarkProtectCharacterScrollParent = CreateFrame('Button', 'AardvarkProtectCharacterScrollParent', AardvarkProtectPanel, 'TooltipBorderedFrameTemplate')
AardvarkProtectCharacterScrollParent:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkProtectCharacterScrollParent:SetBackdropBorderColor(1, .5, 0, 1)
AardvarkProtectCharacterScrollParent:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkProtectCharacterScrollParent:SetPoint('TOP', AardvarkProtectCharacterTitle, 'BOTTOM', 0, -8)
AardvarkProtectCharacterScrollParent:SetScript(
    'OnReceiveDrag',
    function()
        addItemToCharacterProtectList()
    end
)
AardvarkProtectCharacterScrollParent:SetScript(
    'OnClick',
    function()
        if GetCursorInfo() then
            addItemToCharacterProtectList()
        end
    end
)

local AardvarkProtectCharacterScrollFrame = CreateFrame('ScrollFrame', 'AardvarkProtectCharacterScrollFrame', AardvarkProtectCharacterScrollParent, 'FauxScrollFrameTemplate')
AardvarkProtectCharacterScrollFrame:SetPoint('TOPLEFT', 0, -8)
AardvarkProtectCharacterScrollFrame:SetPoint('BOTTOMRIGHT', -30, 8)
AardvarkProtectCharacterScrollFrame:SetScript(
    'OnVerticalScroll',
    function(self, offset)
        FauxScrollFrame_OnVerticalScroll(self, offset, 16, avkUpdateLists)
    end
)

AardvarkProtectCharacterScrollFrame.buttons = {}
for i = 1, AVKSize.scrollButtonNumber do
    AardvarkProtectCharacterScrollFrame.buttons[i] = CreateFrame('Button', 'pclb' .. i, AardvarkProtectCharacterScrollParent)
    local button = AardvarkProtectCharacterScrollFrame.buttons[i]
    button:SetSize(AVKSize.scrollButtonWidth, AVKSize.scrollButtonHeight)
    button:SetNormalFontObject('GameFontHighlightLeft')
    button:SetPoint('TOPLEFT', 8, -(i - 1) * AVKSize.scrollButtonHeight - 8)
    button:SetHighlightTexture('Interface\\BUTTONS\\UI-Listbox-Highlight2')
    button:SetScript(
        'OnEnter',
        function(self)
            local itemName, itemLink, _, _, _, _, _, _, _, _, _ = GetItemInfo(AVKCharacterProtectList[self.index])
            GameTooltip:SetOwner(self, 'ANCHOR_RIGHT', AVKSize.toolTipAnchor, AVKSize.toolTipAnchor * .4)
            GameTooltip:SetHyperlink(itemLink)
            if GetCursorInfo() or AVKGlobalSettings.Protect.plit == false then
                GameTooltip:Hide()
            end
            button:SetScript(
                'OnClick',
                function(self)
                    if GetCursorInfo() then
                        addItemToCharacterProtectList()
                    else
                        if AVKGlobalSettings.Protect.plit == true then
                            GameTooltip:SetHyperlink(itemLink)
                        end
                        table.remove(AVKCharacterProtectList, self.index)
                        GameTooltip:Hide()
                        avkUpdateLists()
                    end
                end
            )
            button:SetScript(
                'OnReceiveDrag',
                function()
                    GameTooltip:Hide()
                    addItemToCharacterProtectList()
                end
            )
        end
    )
    button:SetScript(
        'OnLeave',
        function(self)
            GameTooltip:Hide()
        end
    )
end

local AardvarkProtectCharacterClearListButton = CreateFrame('Button', 'AardvarkProtectCharacterClearListButton', AardvarkProtectPanel, 'UIMenuButtonStretchTemplate')
AardvarkProtectCharacterClearListButton:SetSize(AVKSize.scrollFrameWidth, AVKSize.clearButtonHight)
AardvarkProtectCharacterClearListButton:SetPoint('TOP', AardvarkProtectCharacterScrollParent, 'BOTTOM', 0, -5)
AardvarkProtectCharacterClearListButton:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = true, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkProtectCharacterClearListButton:SetBackdropBorderColor(1, .5, 0, 1)
AardvarkProtectCharacterClearListButton:SetNormalFontObject(avkButtonFont)
AardvarkProtectCharacterClearListButton:SetHighlightFontObject(avkButtonFont)
AardvarkProtectCharacterClearListButton:SetFormattedText('Clear ' .. playerName .. "'s Protect List")
AardvarkProtectCharacterClearListButton:RegisterForClicks('RightButtonUp')
AardvarkProtectCharacterClearListButton:SetScript(
    'OnClick',
    function()
        AVKCharacterProtectList = {}
        avkUpdateLists()
    end
)

--===================          AardvarkRepairPanel         ============================
local AardvarkRepairPanel = CreateFrame('Frame', 'AardvarkRepairPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkRepairPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkRepairPanel:SetBackdropBorderColor(1, 0, 1, 1)
AardvarkRepairPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkRepairPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkRepairPanel:Hide()

local CBrer = CreateFrame('CheckButton', 'CBrer', AardvarkRepairPanel, 'UICheckButtonTemplate')
CBrer:ClearAllPoints()
CBrer:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap)
CBrer:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBrer.text:SetText(AVKFont.avkPinkText .. ' Aardvark Repair')
CBrer.text:SetFontObject(avkCheckBoxBigFont)
CBrer:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Repair.rer == true then
            AVKGlobalSettings.Repair.rer = false
            CBrgr:Hide()
            CBrcarm:Hide()
            CBrntrm:Hide()
            CBrvcrm:Hide()
        else
            AVKGlobalSettings.Repair.rer = true
            CBrgr:Show()
            CBrcarm:Show()
            CBrntrm:Show()
            CBrvcrm:Show()
        end
    end
)

local CBrgr = CreateFrame('CheckButton', 'CBrgr', AardvarkRepairPanel, 'UICheckButtonTemplate')
CBrgr:ClearAllPoints()
CBrgr:SetPoint('TOPLEFT', CBrer, AVKSize.checkBoxChildGapX, -AVKSize.checkboxGapY * 1.2)
CBrgr:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBrgr.text:SetText(' Guild Repair')
CBrgr.text:SetFontObject(avkCheckBoxFont)
CBrgr:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Repair.rgr == true then
            AVKGlobalSettings.Repair.rgr = false
        else
            AVKGlobalSettings.Repair.rgr = true
        end
    end
)

local CBrcarm = CreateFrame('CheckButton', 'CBrcarm', AardvarkRepairPanel, 'UICheckButtonTemplate')
CBrcarm:ClearAllPoints()
CBrcarm:SetPoint('TOPLEFT', CBrgr, 0, -AVKSize.checkboxGapY)
CBrcarm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBrcarm.text:SetText(' Cannot Afford Repair Messages')
CBrcarm.text:SetFontObject(avkCheckBoxFont)
CBrcarm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Repair.rcarm == true then
            AVKGlobalSettings.Repair.rcarm = false
        else
            AVKGlobalSettings.Repair.rcarm = true
        end
    end
)

local CBrntrm = CreateFrame('CheckButton', 'CBrntrm', AardvarkRepairPanel, 'UICheckButtonTemplate')
CBrntrm:ClearAllPoints()
CBrntrm:SetPoint('TOPLEFT', CBrcarm, 0, -AVKSize.checkboxGapY)
CBrntrm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBrntrm.text:SetText(' Nothing To Repair Messages')
CBrntrm.text:SetFontObject(avkCheckBoxFont)
CBrntrm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Repair.rntrm == true then
            AVKGlobalSettings.Repair.rntrm = false
        else
            AVKGlobalSettings.Repair.rntrm = true
        end
    end
)

local CBrvcrm = CreateFrame('CheckButton', 'CBrvcrm', AardvarkRepairPanel, 'UICheckButtonTemplate')
CBrvcrm:ClearAllPoints()
CBrvcrm:SetPoint('TOPLEFT', CBrntrm, 0, -AVKSize.checkboxGapY)
CBrvcrm:SetSize(AVKSize.checkBoxBigSize, AVKSize.checkBoxBigSize)
CBrvcrm.text:SetText(' Vendor Cannot Repair Messages')
CBrvcrm.text:SetFontObject(avkCheckBoxFont)
CBrvcrm:SetScript(
    'OnClick',
    function()
        if AVKGlobalSettings.Repair.rvcrm == true then
            AVKGlobalSettings.Repair.rvcrm = false
        else
            AVKGlobalSettings.Repair.rvcrm = true
        end
    end
)

local AardvarkRepairPanelTextBox = CreateFrame('Frame', 'AardvarkRepairPanelTextBox', AardvarkRepairPanel)
AardvarkRepairPanelTextBox:SetSize(AVKSize.scrollFrameWidth - AVKSize.textBoxWidthShrink, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkRepairPanelTextBox:SetPoint('TOPRIGHT', -AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap)
AardvarkRepairPanelText = AardvarkRepairPanelTextBox:CreateFontString('AardvarkRepairPanelText')
AardvarkRepairPanelText:SetJustifyH('CENTER')
AardvarkRepairPanelText:SetJustifyV('TOP')
AardvarkRepairPanelText:SetAllPoints(AardvarkRepairPanelTextBox)
AardvarkRepairPanelText:SetFontObject(avkContentFont)
AardvarkRepairPanelText:SetText(AVKText.avkRepairOptions)

--===================         AardvarkSillyPanel         ============================
local AardvarkSillyPanel = CreateFrame('Frame', 'AardvarkSillyPanel', AardvarkMainFrame, 'TooltipBorderedFrameTemplate')
AardvarkSillyPanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkSillyPanel:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkSillyPanel:SetSize(AVKSize.mainPanelWidth, AVKSize.mainPanelHeight)
AardvarkSillyPanel:SetPoint('BOTTOM', 0, AVKSize.mainFrameMarginGap)
AardvarkSillyPanel:Hide()

local AardvarkSillyPanelTextBox = CreateFrame('Frame', 'AardvarkSillyPanelTextBox', AardvarkSillyPanel)
AardvarkSillyPanelTextBox:SetSize(AVKSize.mainPanelWidth - AVKSize.mainPanelElementGap, AVKSize.mainPanelHeight - AVKSize.mainPanelElementGap)
AardvarkSillyPanelTextBox:SetPoint('TOP', AardvarkSillyPanel, 0, -11)
AardvarkSillyText = AardvarkSillyPanelTextBox:CreateFontString('AardvarkSillyText')
AardvarkSillyText:SetAllPoints(AardvarkSillyPanelTextBox)
AardvarkSillyText:SetFontObject(avkContentFont)
AardvarkSillyText:SetText(AVKText.avkAboutAardvark)

--===================         AardvarkScalePanel         ============================
local AardvarkScalePanel = CreateFrame('Frame', 'AardvarkScalePanel', UIParent, 'TooltipBorderedFrameTemplate')
AardvarkScalePanel:SetBackdrop({bgFile = nil, insets = nil, tileSize = nil, tile = false, edgeFile = 'Interface\\Tooltips\\UI-Tooltip-Border', edgeSize = AVKSize.backdropEdgeSize})
AardvarkScalePanel:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkScalePanel:ClearAllPoints()
AardvarkScalePanel:SetPoint('BOTTOMRIGHT', AardvarkMainFrame, 'BOTTOMLEFT', 250, 0)
AardvarkScalePanel:SetSize(AVKSize.scrollFrameWidth, AVKSize.scrollFrameHeight)
AardvarkScalePanel:SetParent(AardvarkMainFrame)
AardvarkScalePanel:SetClampedToScreen(true)
AardvarkScalePanel:EnableMouse(true)
AardvarkScalePanel:SetMovable(true)
AardvarkScalePanel:RegisterForDrag('RightButton', 'LeftButton')
AardvarkScalePanel:SetScript('OnDragStart', AardvarkScalePanel.StartMoving)
AardvarkScalePanel:SetScript('OnDragStop', AardvarkScalePanel.StopMovingOrSizing)
AardvarkScalePanel:SetToplevel(true)
AardvarkScalePanel:Hide()

local AardvarkScaleFrameCloseButton = CreateFrame('Button', 'AardvarkScaleFrameCloseButton', AardvarkScalePanel)
AardvarkScaleFrameCloseButton:SetPoint('TOPRIGHT', AVKSize.closeButtonGap, AVKSize.closeButtonGap)
AardvarkScaleFrameCloseButton:SetSize(AVKSize.closeButtonSize, AVKSize.closeButtonSize)
AardvarkScaleFrameCloseButton:SetNormalTexture(AVKImg.avkci)
AardvarkScaleFrameCloseButton:SetHighlightTexture(AVKImg.avkci, 'ADD')
AardvarkScaleFrameCloseButton:SetScript(
    'OnClick',
    function(self)
        AardvarkScalePanel:Hide()
    end
)

local AardvarkMagicButtonScaler = CreateFrame('Slider', 'AardvarkMagicButtonScaler', AardvarkScalePanel, 'OptionsSliderTemplate')
AardvarkMagicButtonScaler:SetPoint('CENTER', 0, 0)
AardvarkMagicButtonScaler:SetScale(AVKSize.scaleSliderScale)
AardvarkMagicButtonScaler.textLow = _G['AardvarkMagicButtonScaler' .. 'Low']
AardvarkMagicButtonScaler.textHigh = _G['AardvarkMagicButtonScaler' .. 'High']
AardvarkMagicButtonScaler.text = _G['AardvarkMagicButtonScaler' .. 'Text']
AardvarkMagicButtonScaler:SetMinMaxValues(AVKSize.scaleSliderMin, AVKSize.scaleSliderMax)
AardvarkMagicButtonScaler.minValue, AardvarkMagicButtonScaler.maxValue = AardvarkMagicButtonScaler:GetMinMaxValues()
AardvarkMagicButtonScaler.textLow:SetText((AVKSize.scaleSliderMin * 100) .. ('%'))
AardvarkMagicButtonScaler.textHigh:SetText((AVKSize.scaleSliderMax * 100) .. ('%'))
AardvarkMagicButtonScalerText:SetFontObject(avkButtonFont)
AardvarkMagicButtonScalerText:SetText(AVKFont.avkBlueText .. 'Aardvark Button')
AardvarkMagicButtonScaler:SetValue(.5)
AardvarkMagicButtonScaler:SetValueStep(1)
AardvarkMagicButtonScaler:SetScript(
    'OnValueChanged',
    function(self, event, arg1)
        AVKGlobalSettings.FrameScales.ambs = tonumber(event)
        AardvarkMagicButton:SetScale(AVKGlobalSettings.FrameScales.ambs)
    end
)

local AardvarkMainFrameScaler = CreateFrame('Slider', 'AardvarkMainFrameScaler', AardvarkScalePanel, 'OptionsSliderTemplate')
AardvarkMainFrameScaler:SetPoint('CENTER', AardvarkMagicButtonScaler, 0, AVKSize.actionBarButtonGap)
AardvarkMainFrameScaler:SetScale(AVKSize.scaleSliderScale)
AardvarkMainFrameScaler.textLow = _G['AardvarkMainFrameScaler' .. 'Low']
AardvarkMainFrameScaler.textHigh = _G['AardvarkMainFrameScaler' .. 'High']
AardvarkMainFrameScaler.text = _G['AardvarkMainFrameScaler' .. 'Text']
AardvarkMainFrameScaler:SetMinMaxValues(AVKSize.scaleSliderMin, AVKSize.scaleSliderMax)
AardvarkMainFrameScaler.minValue, AardvarkMainFrameScaler.maxValue = AardvarkMainFrameScaler:GetMinMaxValues()
AardvarkMainFrameScaler.textLow:SetText((AVKSize.scaleSliderMin * 100) .. ('%'))
AardvarkMainFrameScaler.textHigh:SetText((AVKSize.scaleSliderMax * 100) .. ('%'))
AardvarkMainFrameScalerText:SetFontObject(avkButtonFont)
AardvarkMainFrameScalerText:SetText(AVKFont.avkBlueText .. 'Aardvark Frame')
AardvarkMainFrameScaler:SetValue(.5)
AardvarkMainFrameScaler:SetValueStep(1)
AardvarkMainFrameScaler:SetScript(
    'OnValueChanged',
    function(self, event, arg1)
        AVKGlobalSettings.FrameScales.amfs = tonumber(event)
        AardvarkMainFrame:SetScale(AVKGlobalSettings.FrameScales.amfs)
    end
)

local AardvarkActionBarScaler = CreateFrame('Slider', 'AardvarkActionBarScaler', AardvarkScalePanel, 'OptionsSliderTemplate')
AardvarkActionBarScaler:SetPoint('CENTER', AardvarkMagicButtonScaler, 0, -AVKSize.actionBarButtonGap)
AardvarkActionBarScaler:SetScale(AVKSize.scaleSliderScale)
AardvarkActionBarScaler.textLow = _G['AardvarkActionBarScaler' .. 'Low']
AardvarkActionBarScaler.textHigh = _G['AardvarkActionBarScaler' .. 'High']
AardvarkActionBarScaler.text = _G['AardvarkActionBarScaler' .. 'Text']
AardvarkActionBarScaler:SetMinMaxValues(AVKSize.scaleSliderMin, AVKSize.scaleSliderMax)
AardvarkActionBarScaler.minValue, AardvarkActionBarScaler.maxValue = AardvarkActionBarScaler:GetMinMaxValues()
AardvarkActionBarScaler.textLow:SetText((AVKSize.scaleSliderMin * 100) .. ('%'))
AardvarkActionBarScaler.textHigh:SetText((AVKSize.scaleSliderMax * 100) .. ('%'))
AardvarkActionBarScalerText:SetFontObject(avkButtonFont)
AardvarkActionBarScalerText:SetText(AVKFont.avkBlueText .. 'Aardvark Action Bar')
AardvarkActionBarScaler:SetValue(1)
AardvarkActionBarScaler:SetValueStep(1)
AardvarkActionBarScaler:SetScript(
    'OnValueChanged',
    function(self, event, arg1)
        AVKGlobalSettings.FrameScales.aabs = tonumber(event)
        AardvarkActionBar:SetScale(AVKGlobalSettings.FrameScales.aabs)
    end
)

--=====================   AardvarkMagicButton    ======================
AardvarkMagicButton = CreateFrame('Button', 'AardvarkMagicButton', UIParent)
AardvarkMagicButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkMagicButton:ClearAllPoints()
AardvarkMagicButton:SetPoint('BOTTOMRIGHT', AardvarkMainFrame, 'TOPRIGHT', 0, 20)
AardvarkMagicButton:SetNormalTexture(AVKImg.avki)
AardvarkMagicButton:SetHighlightTexture(AVKImg.avki_alt, 'BLEND')
AardvarkMagicButton:SetMovable(true)
AardvarkMagicButton:SetClampedToScreen(true)
AardvarkMagicButton:RegisterForDrag('MiddleButton')
AardvarkMagicButton:SetScript('OnDragStart', AardvarkMagicButton.StartMoving)
AardvarkMagicButton:SetScript('OnDragStop', AardvarkMagicButton.StopMovingOrSizing)
AardvarkMagicButton:SetToplevel(true)
AardvarkMagicButton:SetScript(
    'OnEnter',
    function(self)
        GameTooltip:SetOwner(self, 'ANCHOR_TOP', 5, 5)
        GameTooltip:AddDoubleLine(addonName, versionNumber, 0, 1, 1, 0, 1, 1)
        GameTooltip:AddLine(AVKText.avkMagicButton)
        if AVKGlobalSettings.Aardvark.amfbt == true then
            GameTooltip:Show()
        else
            GameTooltip:Hide()
        end
        AardvarkMagicButton:SetScript(
            'OnReceiveDrag',
            function()
                if GetCursorInfo() then
                    if IsAltKeyDown() then
                        addItemToGlobalList()
                    else
                        addItemToCharacterList()
                    end
                end
            end
        )
        AardvarkMagicButton:RegisterForClicks('RightButtonUp', 'LeftButtonUp')
        AardvarkMagicButton:SetScript(
            'OnClick',
            function(self, button)
                if button == 'RightButton' then
                    avkDestroy()
                elseif button == 'LeftButton' then
                    if GetCursorInfo() then
                        if IsControlKeyDown() then
                            addItemToGlobalProtectList()
                        elseif IsAltKeyDown() then
                            addItemToGlobalList()
                        else
                            addItemToCharacterList()
                        end
                    else
                        if AardvarkMainFrame:IsVisible() then
                            avkUpdateLists()
                            AardvarkMainFrame:Hide()
                        else
                            AardvarkMainFrame:Show()
                        end
                    end
                end
            end
        )
    end
)
AardvarkMagicButton:SetScript(
    'OnLeave',
    function(self)
        GameTooltip:Hide()
        GameTooltip:SetScale(1)
    end
)

--=====================  AardvarkActionBar   ======================
AardvarkActionBar = CreateFrame('Frame', 'AardvarkActionBar', UIParent)
AardvarkActionBar:SetBackdropBorderColor(0, 1, 1, 1)
AardvarkActionBar:ClearAllPoints()
AardvarkActionBar:SetPoint('TOPLEFT', AardvarkMainFrame, 'TOPRIGHT', 0, 0)
AardvarkActionBar:SetMovable(true)
AardvarkActionBar:SetClampedToScreen(true)
AardvarkActionBar:SetToplevel(true)
AardvarkActionBar:Hide()

AardvarkActionBarAardvarkButton = CreateFrame('Button', 'AardvarkActionBarAardvarkButton', AardvarkActionBar)
AardvarkActionBarAardvarkButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)

AardvarkActionBarAardvarkButton:SetNormalTexture(AVKImg.avki)
AardvarkActionBarAardvarkButton:SetHighlightTexture(AVKImg.avki_alt, 'BLEND')
AardvarkActionBarAardvarkButton:SetParent(AardvarkActionBar)
AardvarkActionBarAardvarkButton:EnableMouse(true)
AardvarkActionBarAardvarkButton:SetMovable(true)
AardvarkActionBarAardvarkButton:RegisterForDrag('MiddleButton')
AardvarkActionBarAardvarkButton:SetScript(
    'OnDragStart',
    function()
        AardvarkActionBarAardvarkButton:GetParent():StartMoving()
    end
)
AardvarkActionBarAardvarkButton:SetScript(
    'OnDragStop',
    function()
        AardvarkActionBarAardvarkButton:GetParent():StopMovingOrSizing()
    end
)
AardvarkActionBarAardvarkButton:SetScript(
    'OnClick',
    function()
        print('AardvarkActionBarAardvarkButton')
    end
)
AardvarkActionBarAardvarkButton:SetScript(
    'OnClick',
    function()
        if AardvarkMainFrame:IsVisible() then
            avkUpdateLists()
            AardvarkMainFrame:Hide()
        else
            AardvarkMainFrame:Show()
        end
    end
)

AardvarkActionBarSellButton = CreateFrame('Button', 'AardvarkActionBarSellButton', AardvarkActionBar)
AardvarkActionBarSellButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarSellButton:SetNormalTexture(AVKImg.avksi)
AardvarkActionBarSellButton:SetHighlightTexture(AVKImg.avksi_alt, 'BLEND')
AardvarkActionBarSellButton:SetDisabledTexture(AVKImg.avks_dis)
AardvarkActionBarSellButton:Disable()
AardvarkActionBarSellButton:SetScript('OnClick', avkSell)

AardvarkActionBarDestroyButton = CreateFrame('Button', 'AardvarkActionBarDestroyButton', AardvarkActionBar)
AardvarkActionBarDestroyButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarDestroyButton:SetNormalTexture(AVKImg.avkdi)
AardvarkActionBarDestroyButton:SetHighlightTexture(AVKImg.avkdi_alt, 'BLEND')
AardvarkActionBarDestroyButton:RegisterForClicks('RightButtonUp')
AardvarkActionBarDestroyButton:SetScript(
    'OnClick',
    function(self, button)
        if button == 'RightButton' then
            avkDestroy()
        end
    end
)

AardvarkActionBarGlobalButton = CreateFrame('Button', 'AardvarkActionBarGlobalButton', AardvarkActionBar)
AardvarkActionBarGlobalButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarGlobalButton:SetNormalTexture(AVKImg.avkglobi)
AardvarkActionBarGlobalButton:SetHighlightTexture(AVKImg.avkglobi_alt, 'BLEND')
AardvarkActionBarGlobalButton:SetScript('OnReceiveDrag', addItemToGlobalList)
AardvarkActionBarGlobalButton:SetScript(
    'OnClick',
    function(self, button)
        if GetCursorInfo() then
            addItemToGlobalList()
        end
    end
)

AardvarkActionBarCharacterButton = CreateFrame('Button', 'AardvarkActionBarCharacterButton', AardvarkActionBar)
AardvarkActionBarCharacterButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarCharacterButton:SetNormalTexture(AVKImg.avkchari)
AardvarkActionBarCharacterButton:SetHighlightTexture(AVKImg.avkchari_alt, 'BLEND')
AardvarkActionBarCharacterButton:SetClampedToScreen(true)
AardvarkActionBarCharacterButton:SetScript('OnReceiveDrag', addItemToCharacterList)
AardvarkActionBarCharacterButton:SetScript(
    'OnClick',
    function(self, button)
        if GetCursorInfo() then
            addItemToCharacterList()
        end
    end
)

AardvarkActionBarGlobalProtectButton = CreateFrame('Button', 'AardvarkActionBarGlobalProtectButton', AardvarkActionBar)
AardvarkActionBarGlobalProtectButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarGlobalProtectButton:SetNormalTexture(AVKImg.avkpglobi)
AardvarkActionBarGlobalProtectButton:SetHighlightTexture(AVKImg.avkpglobi_alt, 'BLEND')
AardvarkActionBarGlobalProtectButton:SetClampedToScreen(true)
AardvarkActionBarGlobalProtectButton:SetScript('OnReceiveDrag', addItemToGlobalProtectList)
AardvarkActionBarGlobalProtectButton:SetScript(
    'OnClick',
    function(self, button)
        if GetCursorInfo() then
            addItemToGlobalProtectList()
        end
    end
)

AardvarkActionBarCharacterProtectButton = CreateFrame('Button', 'AardvarkActionBarCharacterProtectButton', AardvarkActionBar)
AardvarkActionBarCharacterProtectButton:SetSize(AVKSize.mainFrameNavigationButtonSize, AVKSize.mainFrameNavigationButtonSize)
AardvarkActionBarCharacterProtectButton:SetNormalTexture(AVKImg.avkpchari)
AardvarkActionBarCharacterProtectButton:SetHighlightTexture(AVKImg.avkpchari_alt, 'BLEND')
AardvarkActionBarCharacterProtectButton:SetClampedToScreen(true)
AardvarkActionBarCharacterProtectButton:SetScript('OnReceiveDrag', addItemToGlobalProtectList)
AardvarkActionBarCharacterProtectButton:SetScript(
    'OnClick',
    function(self, button)
        if GetCursorInfo() then
            addItemToCharacterProtectList()
        end
    end
)

--===================         AardvarkFilterOptionsPanel         ============================
local AardvarkFilterOptionsPanel = CreateFrame('Frame', 'AardvarkFilterOptionsPanel', AardvarkSideOptionsPanel)
AardvarkFilterOptionsPanel:SetSize(AVKSize.mainFrameWidth / 2 + AVKSize.mainFrameMarginGap * 2, AVKSize.mainFrameHeight)
AardvarkFilterOptionsPanel:SetPoint('TOP', AardvarkSideOptionsPanel, 'TOP', AVKSize.mainFrameMarginGap)
AardvarkFilterOptionsPanel:Hide()

local CBrarityGrey = CreateFrame('CheckButton', 'CBrarityGrey', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityGrey:ClearAllPoints()
CBrarityGrey:SetPoint('TOPLEFT', AVKSize.mainPanelElementGap, -AVKSize.mainPanelElementGap * 1.2)
CBrarityGrey:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityGrey.text:SetText('CBrarityGrey')
CBrarityGrey.text:SetFontObject(avkCheckBoxFont)
CBrarityGrey:SetChecked(true)
CBrarityGrey:SetScript(
    'OnClick',
    function()
        if CBrarityGrey:GetChecked() then
            AVKFilterOptions.rarityGrey = true
        else
            AVKFilterOptions.rarityGrey = false
        end
    end
)

local CBrarityWhite = CreateFrame('CheckButton', 'CBrarityWhite', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityWhite:ClearAllPoints()
CBrarityWhite:SetPoint('TOPLEFT', CBrarityGrey, 0, -AVKSize.checkboxGapY)
CBrarityWhite:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityWhite.text:SetText('CBrarityWhite')
CBrarityWhite.text:SetFontObject(avkCheckBoxFont)
CBrarityWhite:SetChecked(true)
CBrarityWhite:SetScript(
    'OnClick',
    function()
        if CBrarityWhite:GetChecked() then
            AVKFilterOptions.rarityWhite = true
        else
            AVKFilterOptions.rarityWhite = true
        end
    end
)

local CBrarityGreen = CreateFrame('CheckButton', 'CBrarityGreen', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityGreen:ClearAllPoints()
CBrarityGreen:SetPoint('TOPLEFT', CBrarityWhite, 0, -AVKSize.checkboxGapY)
CBrarityGreen:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityGreen.text:SetText('CBrarityGreen')
CBrarityGreen.text:SetFontObject(avkCheckBoxFont)
CBrarityGreen:SetChecked(true)
CBrarityGreen:SetScript(
    'OnClick',
    function()
        if CBrarityGreen:GetChecked() then
            AVKFilterOptions.rarityGreen = true
        else
            AVKFilterOptions.rarityGreen = false
        end
    end
)

local CBrarityBlue = CreateFrame('CheckButton', 'CBrarityBlue', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityBlue:ClearAllPoints()
CBrarityBlue:SetPoint('TOPLEFT', CBrarityGreen, 0, -AVKSize.checkboxGapY)
CBrarityBlue:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityBlue.text:SetText('CBrarityBlue')
CBrarityBlue.text:SetFontObject(avkCheckBoxFont)
CBrarityBlue:SetChecked(true)
CBrarityBlue:SetScript(
    'OnClick',
    function()
        if CBrarityBlue:GetChecked() then
            AVKFilterOptions.rarityBlue = true
        else
            AVKFilterOptions.rarityBlue = false
        end
    end
)

local CBrarityPurple = CreateFrame('CheckButton', 'CBrarityPurple', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityPurple:ClearAllPoints()
CBrarityPurple:SetPoint('TOPLEFT', CBrarityBlue, 0, -AVKSize.checkboxGapY)
CBrarityPurple:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityPurple.text:SetText('CBrarityPurple')
CBrarityPurple.text:SetFontObject(avkCheckBoxFont)
CBrarityPurple:SetChecked(true)
CBrarityPurple:SetScript(
    'OnClick',
    function()
        if CBrarityPurple:GetChecked() then
            AVKFilterOptions.rarityPurple = true
        else
            AVKFilterOptions.rarityPurple = false
        end
    end
)

local CBrarityLegendary = CreateFrame('CheckButton', 'CBrarityLegendary', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityLegendary:ClearAllPoints()
CBrarityLegendary:SetPoint('TOPLEFT', CBrarityPurple, 0, -AVKSize.checkboxGapY)
CBrarityLegendary:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityLegendary.text:SetText('CBrarityLegendary')
CBrarityLegendary.text:SetFontObject(avkCheckBoxFont)
CBrarityLegendary:SetChecked(true)
CBrarityLegendary:SetScript(
    'OnClick',
    function()
        if CBrarityLegendary:GetChecked() then
            AVKFilterOptions.rarityLegendary = true
        else
            AVKFilterOptions.rarityLegendary = false
        end
    end
)

local CBrarityArtifact = CreateFrame('CheckButton', 'CBrarityArtifact', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityArtifact:ClearAllPoints()
CBrarityArtifact:SetPoint('TOPLEFT', CBrarityLegendary, 0, -AVKSize.checkboxGapY)
CBrarityArtifact:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityArtifact.text:SetText('CBrarityArtifact')
CBrarityArtifact.text:SetFontObject(avkCheckBoxFont)
CBrarityArtifact:SetChecked(true)
CBrarityArtifact:SetScript(
    'OnClick',
    function()
        if CBrarityArtifact:GetChecked() then
            AVKFilterOptions.rarityArtifact = true
        else
            AVKFilterOptions.rarityArtifact = false
        end
    end
)

local CBrarityHeirloom = CreateFrame('CheckButton', 'CBrarityHeirloom', AardvarkFilterOptionsPanel, 'UICheckButtonTemplate')
CBrarityHeirloom:ClearAllPoints()
CBrarityHeirloom:SetPoint('TOPLEFT', CBrarityArtifact, 0, -AVKSize.checkboxGapY)
CBrarityHeirloom:SetSize(AVKSize.checkBoxSize, AVKSize.checkBoxSize)
CBrarityHeirloom.text:SetText('CBrarityHeirloom')
CBrarityHeirloom.text:SetFontObject(avkCheckBoxFont)
CBrarityHeirloom:SetChecked(true)
CBrarityHeirloom:SetScript(
    'OnClick',
    function()
        if CBrarityHeirloom:GetChecked() then
            AVKFilterOptions.rarityHeirloom = true
        else
            AVKFilterOptions.rarityHeirloom = false
        end
    end
)
