local ateam_start = nil;
local ateam_enable = true;

local spellIds = {
	42650, -- Army of the Dead
};

-- Slash Command
SLASH_ATEAM1 = "/ateam"
SlashCmdList["ATEAM"] = function (args) ateam_onSlash(args) end

-- Spells map
local spells = {};
for _, v in pairs(spellIds) do spells[v] = true; end

-- onEvent listener
function ateam_onEvent (self, event, ...)
	local unit, _,_,_, spell = ...;

	-- Is it the right Spellevent?
	local isUnit = UnitInParty(unit) or (unit == UnitGUID("player")) or (unit == "player");
	local isSpell = event == "UNIT_SPELLCAST_CHANNEL_START" and spells[spell];

	if(ateam_enable and isSpell and isUnit) then
		-- Is another ATeam-Soundtrack still playing?
		if(ateam_start == nil or time() - ateam_start >= 24) then
			ateam_start = time();
			PlaySoundFile("Interface\\AddOns\\ATeam\\soundtrack.mp3");
		end
	end
end

function ateam_onLoad (self)
	ateam_print("ATeam Mod loaded!");
	self:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START");
	self:RegisterEvent("UNIT_SPELLCAST_START");
end

function ateam_onSlash(args)
	if(args == "enable") then
		ateam_enable = true;
		ateam_print("ATeam Mod enabled!");
	elseif(args == "disable") then
		ateam_enable = false;
		ateam_print("ATeam Mod disabled!");
	end
end

function ateam_print(arg)
	DEFAULT_CHAT_FRAME:AddMessage(arg)
end

function printBoolean (name, arg)
	ateam_print(name .. ": " .. (arg and "true" or "false"));
end