local addonFrame = CreateFrame('Button', 'ApButtonFrame', UIParent, 'ActionButtonTemplate, SecureActionButtonTemplate')
local tooltip = CreateFrame('GameTooltip', 'ApButtonTooltip', addonFrame, 'GameTooltipTemplate')
local events = {}
local slashCommands = {}

local awaiting = false
local bagSlots

setglobal('BINDING_NAME_CLICK ApButtonFrame:LeftButton', 'Click AP Button')

addonFrame:SetSize(50, 50)
addonFrame:SetClampedToScreen(true)
addonFrame:SetAttribute('type', 'item')
addonFrame.NormalTexture:SetTexture(nil)
addonFrame:RegisterForDrag('LeftButton')
addonFrame:SetScale(1)
addonFrame:SetAttribute('shift-type1', 'macro')
addonFrame:Show()

tooltip:SetOwner(addonFrame, 'TOPLEFT', 0, 0)
tooltip:Show()
tooltip:SetAlpha(0)

local function eventHandler (self, event, ...)
  events[event](self, ...)
end

addonFrame:SetScript('OnEvent', eventHandler)
addonFrame:SetScript('OnDragStart', function (self)
  if (self:IsMovable() == true) then
    self:StartMoving()
  end
end)
addonFrame:SetScript('OnReceiveDrag', function (self)
  frameAnchor = {addonFrame:GetPoint()}
  self:StopMovingOrSizing()
end)

addonFrame:SetScript('OnEnter', function (self)
  tooltip:SetAlpha(1)
end)
addonFrame:SetScript('OnLeave', function (self)
  tooltip:SetAlpha(0)
end)

function scanBags ()
  if (UnitAffectingCombat('player') == true) then
    awaiting = true
    return
  end
  awaiting = false
  for i = 4, 0, -1 do
    local slots = GetContainerNumSlots(i)
    for j = slots, 1, -1 do
      local id = GetContainerItemID(i, j)
      if (IsArtifactPowerItem(id) == true) then
        local itemLink = GetContainerItemLink(i, j)
        local start, duration = GetContainerItemCooldown(i, j)
        addonFrame:SetAttribute('item', i .. ' ' .. j)
        addonFrame.icon:SetTexture(GetItemIcon(id))
        if (duration > 0) then
          addonFrame.cooldown:SetCooldown(start, duration)
        elseif (addonFrame.cooldown:GetCooldownDuration() > 0) then
          addonFrame.cooldown:SetCooldown(0, 0)
        end
        addonFrame:SetAttribute('shift-macrotext1', '/run ChatEdit_InsertLink(\"' .. itemLink .. '\")' )
        addonFrame:Enable()
        addonFrame:Show()
        addonFrame:SetAlpha(1)
        addonFrame:EnableMouse(true)
        tooltip:SetOwner(addonFrame, 'TOPLEFT', 0, 0)
        tooltip:SetText('tooltip', nil, nil, nil, nil, true)
        tooltip:SetHyperlink(itemLink)
        if (addonFrame:IsMouseOver() == false) then
          tooltip:SetAlpha(0)
        else
          tooltip:SetAlpha(1)
        end
        return
      end
    end
  end
  addonFrame:Disable()
  addonFrame:Hide()
end

function events:ADDON_LOADED (addon)
  if (addon == 'ApButton') then
    if (frameAnchor ~= nil) then
      addonFrame:SetPoint(unpack(frameAnchor))
    else
      addonFrame:SetPoint('CENTER', UIParent, 'CENTER', 0, 0)
    end
    if (movable ~= nil) then
      addonFrame:SetMovable(movable)
    else
      addonFrame:SetMovable(true)
    end
  end
end

function events:PLAYER_REGEN_DISABLED ()
  addonFrame:Disable()
  addonFrame:SetAlpha(0)
  addonFrame:EnableMouse(false)
  tooltip:SetAlpha(0)
end

function events:PLAYER_REGEN_ENABLED ()
  if (awaiting == true) then
    scanBags()
  else
    addonFrame:Enable()
    addonFrame:SetAlpha(1)
    addonFrame:EnableMouse(true)
    if (addonFrame:IsMouseOver() == true) then
      tooltip:SetAlpha(1)
    end
  end
end

events['BAG_UPDATE_DELAYED'] = scanBags

for k, v in pairs(events) do
  addonFrame:RegisterEvent(k)
end

function slashCommands:lock ()
  addonFrame:SetMovable(false)
  movable = false
  print('Artifact Power Button was locked')
end

function slashCommands:unlock ()
  addonFrame:SetMovable(true)
  movable = true
  print('Artifact Power Button was unlocked')
end

local function slashHandler (command)
  command = string.lower(command)
  if (slashCommands[command] ~= nil) then
    slashCommands[command]()
    return
  end
  print('APB: unknown command "' .. command .. '"')
end

SLASH_ARTIFACTPOWERBUTTON1 = '/apb'
SlashCmdList["ARTIFACTPOWERBUTTON"] = slashHandler
