local DefaultYearMsg = "Congratulations, [You]! [Me] earned [Achievement] [Years] years ago!"
local DefaultMonthMsg = "Congratulations, [You]! [Me] earned [Achievement] [Months] months ago!"
local DefaultWeekMsg = "Congratulations, [You]! [Me] earned [Achievement] [Weeks] weeks ago!"
local DefaultDayMsg = "Congratulations, [You]! [Me] earned [Achievement] [Days] days ago!"
local DefaultGenericMsg = "Congratulations, [You]! Just remember [Me] earned [Achievement] before you."
local DefaultFailMsg = "Congratulations [You], I guess. [Or] [Achievement] is a stupid achievement."
local AchievementNameToIDMap = nil

AHEventFrame = CreateFrame("Frame")
local OnButton = CreateFrame("CheckButton", nil, AHEventFrame, "UICheckButtonTemplate")
local YearText=CreateFrame("EditBox", nil, AHEventFrame)

local MonthText=CreateFrame("EditBox", nil, AHEventFrame)

local WeekText=CreateFrame("EditBox", nil, AHEventFrame)

local DayText=CreateFrame("EditBox", nil, AHEventFrame)

local GenericText=CreateFrame("EditBox", nil, AHEventFrame)

local FailText=CreateFrame("EditBox", nil, AHEventFrame)


local function Write()
   OnButton:SetChecked(AH_On)


   YearText:SetText(AH_YearMsg)
   MonthText:SetText(AH_MonthMsg)
   WeekText:SetText(AH_WeekMsg)
   DayText:SetText(AH_DayMsg)
   GenericText:SetText(AH_GenericMsg)
   FailText:SetText(AH_FailMsg)
end

local function Read()
   AH_On = OnButton:GetChecked()
   AH_YearMsg = YearText:GetText()
   AH_MonthMsg = MonthText:GetText()
   AH_WeekMsg = WeekText:GetText()
   AH_DayMsg = DayText:GetText()
   AH_GenericMsg = GenericText:GetText()
   AH_FailMsg = FailText:GetText()
   Write()
end

local function Round(Num, NumDecimalPlaces)
   local Mult = 10^(NumDecimalPlaces or 0)
   return math.floor(Num * Mult + 0.5) / Mult
end

function Trim(Message)
   return(Message:gsub("^%s*(.-)%s*$", "%1"))
end

function ToKey(Message)
   return(string.upper(string.gsub(Message, " ", "")))
end

local function AddAchievementToMap(ID, Achievement)
   if (ID == nil) then return end
   -- AH_Debug = AH_Debug .. "[" .. Achievement .. "]"
   AchievementNameToIDMap[ToKey(Achievement)] = ID
   ID = GetPreviousAchievement(ID)
   if (ID == nil) then return end
   AddAchievementToMap(GetAchievementInfo(ID))
end

local function AddAchievementsToMap()
   AH_Debug = ""
   AchievementNameToIDMap = {}
   for i, Catagory in ipairs(GetCategoryList()) do
      for j = 1, GetCategoryNumAchievements(Catagory, true) do
         AddAchievementToMap(GetAchievementInfo(Catagory, j));
      end
   end
end

local function HandleAddonLoaded(Self)
   if (AH_On == nil) then AH_On = true end
   if (AH_YearMsg == nil) then AH_YearMsg = DefaultYearMsg end
   if (AH_MonthMsg == nil) then AH_MonthMsg = DefaultMonthMsg end
   if (AH_WeekMsg == nil) then AH_WeekMsg = DefaultWeekMsg end
   if (AH_DayMsg == nil) then AH_DayMsg = DefaultDayMsg end
   if (AH_GenericMsg == nil) then AH_GenericMsg = DefaultGenericMsg end
   if (AH_FailMsg == nil) then AH_FailMsg = DefaultFailMsg end
   Write()
   Self:UnregisterEvent("ADDON_LOADED") 
end

local function HandleChatMsgGuildAchievement(Message, You)
   if (AchievementNameToIDMap == nil) then AddAchievementsToMap() end
   local Achievement = string.match(Message, "%[(.*)%]", 1)
   ID = AchievementNameToIDMap[ToKey(Achievement)]
   if (ID == nil) then print("ah : Unknown achievement " .. Achievement) return end

   local Index = string.find(You, "-")
   if (Index ~= nil) then You = string.sub(You, 1, Index - 1) end

   local Me = GetUnitName("player")

   if (You == Me) then return end

   ID, Achievement, Points, Completed, Month, Day, Year = GetAchievementInfo(ID)

   Days = -1
   if (Completed) then
      Then = time({year = Year + 2000, month = Month, day = Day })
      Now = time({year = date("%y") + 2000, month = date("%m"), day = date("%d") })
      Days = (Now - Then) / 86400
   end
   Weeks = Round(Days / 7)
   Months = Round(Days / 30)
   Years = Round(Days / 365)

   local Message = ""
   if ((Years >= 2) and (AH_YearMsg ~= "")) then
      Message = AH_YearMsg
      Message = string.gsub(Message, "%[Years]", tostring(Years))
   elseif ((Months >= 2) and (AH_MonthMsg ~= "")) then
      Message = AH_MonthMsg
      Message = string.gsub(Message, "%[Months]", tostring(Months))
   elseif ((Weeks >= 2) and (AH_WeekMsg ~= "")) then
      Message = AH_WeekMsg
      Message = string.gsub(Message, "%[Weeks]", tostring(Weeks))
   elseif ((Days >= 2) and (AH_DayMsg ~= "")) then
      Message = AH_DayMsg
      Message = string.gsub(Message, "%[Days]", tostring(Days))
   elseif (Days >= 0) then
      if (AH_GenericMsg ~= "") then
         Message = AH_GenericMsg
      end
   elseif (AH_FailMsg ~= "") then
      Message = AH_FailMsg
   end

   if (You == "Arsoness") then
      Message = "[You] rocks! [Or]"
      Message = Message .. "[You] is the best! [Or]"
      Message = Message .. "[You] is so awesome! [Or]"
      Message = Message .. "I wish I could be as cool as [You]! [Or]"
      Message = Message .. "All hail [You]! [Or]"
      Message = Message .. "Yay [You]! [Or]"
      Message = Message .. "I have a secret crush on [You]."
   end

   Message = string.gsub(Message, "%[Me]", Me)
   Message = string.gsub(Message, "%[You]", You)
   Message = string.gsub(Message, "%[Achievement]", Achievement)

   local Messages = {}
   Message = Message .. "[Or]"
   local Count = 0
   local StartIndex = 1
   local StopIndex = 1
   while (true) do
      StopIndex = string.find(Message, "%[Or]", StartIndex)
      if (StopIndex == nil) then break end
      StopIndex = StopIndex - 1
      Count = Count + 1
      Messages[Count] = Trim(string.sub(Message, StartIndex, StopIndex))
      StartIndex = StopIndex + 5
   end
   local Pick = math.random(Count)
   Message = Messages[Pick]

   if (Message == "") then
      -- Do nothing
   elseif (AH_On) then
      SendChatMessage(Message, "GUILD")
   end
end

local function OnEvent(Self, Event, Message, Sender)
   if (Event == "ADDON_LOADED") then
      HandleAddonLoaded(Self);
   elseif (Event == "CHAT_MSG_GUILD_ACHIEVEMENT") then
      HandleChatMsgGuildAchievement(Message, Sender)
   end
end

AHEventFrame:RegisterEvent("ADDON_LOADED");
AHEventFrame:RegisterEvent("CHAT_MSG_GUILD_ACHIEVEMENT")
AHEventFrame:SetScript("OnEvent", OnEvent);
AHEventFrame.name = "AH"

InterfaceOptions_AddCategory(AHEventFrame);


local x = 25

local y = 0

local function SetTextAtt(w, text)
   local l = AHEventFrame:CreateFontString()
   l:SetPoint("TOPLEFT", AHEventFrame, "TOPLEFT", x, y)

   l:SetFontObject(GameFontNormal)

   l:SetText(text)

   y = y - 15;

   w:SetMultiLine(true)

   w:SetPoint("TOPLEFT", AHEventFrame, "TOPLEFT", x + 25, y)

   w:SetFontObject(GameFontNormal)

   --w:SetHeight(100)

   w:SetWidth(500)

   w:SetTextColor(0, 1, 1, 1)

   w:SetScript("OnEditFocusLost", function()
 Read() 
end)

   w:SetBackdrop({

         bgFile = [[Interface\Buttons\WHITE8x8]],

         edgeFile = [[Interface\Tooltips\UI-Tooltip-Border]],

         edgeSize = 14,

         insets = {left = 3, right = 3, top = 3, bottom = 3},

   })

   w:SetBackdropColor(0, 0, 0)

   w:SetBackdropBorderColor(0.3, 0.3, 0.3)

   w:SetAutoFocus(false)

   w:SetTextInsets(10, 10, 10, 10)

   w:SetCursorPosition(0)

   w:SetJustifyH("LEFT")

   w:SetJustifyV("TOP")

   y = y - 60
end

x = 25

y = -25

OnButton:SetPoint("TOPLEFT", AHEventFrame, "TOPLEFT", x, y)

OnButton:SetScript("OnClick", function() Read() end)
x = x + 50
local OnLabel = AHEventFrame:CreateFontString()

OnLabel:SetPoint("TOPLEFT", AHEventFrame, "TOPLEFT", x, y - 10)

OnLabel:SetFontObject(GameFontNormal)

OnLabel:SetText("Enabled")

x = x + 400

local ResetButton = CreateFrame("Button", nil, AHEventFrame, "UIPanelButtonTemplate")
ResetButton:SetPoint("TOPLEFT", AHEventFrame, "TOPLEFT", x, y)

ResetButton:SetText("Reset")


ResetButton:SetWidth(100)


ResetButton:SetScript("OnClick", function()
   AH_YearMsg = DefaultYearMsg
   AH_MonthMsg = DefaultMonthMsg 
   AH_WeekMsg = DefaultWeekMsg 
   AH_DayMsg = DefaultDayMsg 
   AH_GenericMsg = DefaultGenericMsg 
   AH_FailMsg = DefaultFailMsg
   Write()
end)
x = 25
y = y - 50
SetTextAtt(YearText, "if (Years >= 2) then")

SetTextAtt(MonthText, "else if (Months >= 2) then")

SetTextAtt(WeekText, "else if (Weeks >= 2) then")


SetTextAtt(DayText, "else if (Days >= 2) then")

SetTextAtt(GenericText, "else if (Days >= 0) then")

SetTextAtt(FailText, "else")


SLASH_MESSAGE1 = "/ah"
SlashCmdList["MESSAGE"] =  function(arg)
   InterfaceOptionsFrame_OpenToCategory("AH") 
   InterfaceOptionsFrame_OpenToCategory("AH") 
end

