# Техническая информация по аддону TipOff

Версия: 0.2

<!--
    Этот файл содержит техническое описание структуры и принципов работы аддона TipOff.
    Все упоминания старого названия заменены на TipOff.
-->

## Структура файлов

- **TipOff.toc** — основной TOC-файл аддона, указывает на все используемые lua-файлы и xml, а также на базу данных и иконки.
- **main.lua** — основной код аддона, логика отображения информации в тултипах, настройки, обработка команд (теперь команды удалены).
- **util.lua** — вспомогательные функции: глубокое копирование таблиц, дамп таблиц, проверка наличия значения в массиве.
- **embeds.xml** — подключение библиотек Ace3 (AceAddon, AceDB, AceConfig, AceConsole, AceHook) и LibStub.
- **Data/Icons.lua** — таблица с иконками профессий для отображения в тултипах.
- **Data/TipOffDB.lua** — большая база данных с информацией об использовании предметов (структура не просмотрена из-за размера, но используется как ItemDB.Items).

## Используемые библиотеки
- **AceAddon-3.0** — создание и управление аддоном.
- **AceDB-3.0** — хранение настроек пользователя (SavedVariables).
- **AceConfig-3.0, AceConfigDialog-3.0** — создание и отображение настроек в интерфейсе (сейчас отключено).
- **AceConsole-3.0** — обработка slash-команд (сейчас отключено).
- **AceHook-3.0** — перехват событий.
- **LibStub** — менеджер библиотек.

## Основные объекты и функции
- **TipOff** — основной объект аддона.
- **TipOffDB** — глобальная таблица с базой данных предметов и иконок.
- **SetItemTooltip(tooltip, ...)** — главная функция, добавляющая информацию в тултип предмета (рецепты, квесты, профессии).
- **IsQuestCompleted** — проверка выполнения квеста (через IsQuestFlaggedCompleted).
- **GetIcon** — получение строки для отображения иконки.
- **SellGrayItems** — автопродажа серого хлама при открытии торговца (если включено). Продаёт все серые предметы из сумок, выводит сумму продажи в чат.
- **AutoRepair** — авторемонт экипировки при открытии торговца (если включено). Сначала пытается починиться за счёт гильдии (если хватает и в гильдбанке, и у игрока), если не удалось — за личные средства. Если не хватает ни там, ни там — выводит ошибку. Если в гильдбанке есть, а у игрока нет — отдельное сообщение.

## Настройки пользователя
- **filterProfs** — фильтровать по профессиям игрока.
- **filterUselessQuests** — скрывать бесполезные квесты.
- **autoSellGray** — автопродажа серого хлама.
- **autoRepair** — авторемонт экипировки.

## Структура данных
- **TipOff.Icons** — таблица с иконками профессий (см. Data/Icons.lua).
- **TipOff.Items** — большая таблица с данными по предметам (структура: ItemDB.Items.ERA и ItemDB.Items.SOD, далее по имени предмета — профессии, квесты и т.д.).

## Особенности
- Для отображения информации в тултипе используются хуки на GameTooltip.
- Вся логика отображения информации завязана на структуру TipOff.Items и TipOff.Icons.
- При автопродаже и авторемонте используются проверки на наличие средств у игрока и в гильдбанке, с информативными сообщениями об успехе или ошибке.
- Если для ремонта за счёт гильдии не хватает личных средств, выводится отдельное сообщение.

---

Этот файл можно использовать как справочник при портировании и доработке аддона под 3.3.5. 

