local E, L, V, P, G = unpack(ElvUI)
local UF = E:GetModule("UnitFrames")

--Lua functions
--WoW API / Variables
local CreateFrame = CreateFrame

function UF:Construct_Trinket(frame)
	local trinket = CreateFrame("Frame", nil, frame)
	trinket.bg = CreateFrame("Frame", nil, trinket)
	trinket.bg:SetTemplate(nil, nil, nil, self.thinBorders, true)
	trinket.bg:OffsetFrameLevel(-1, trinket)
	trinket:SetInside(trinket.bg)

	return trinket
end

function UF:Configure_Trinket(frame)
	if not frame.VARIABLES_SET then return end
	local db = frame.db
	local trinket = frame.Trinket

	trinket.bg:Size(db.pvpTrinket.size)
	trinket.bg:ClearAllPoints()
	if db.pvpTrinket.position == "RIGHT" then
		trinket.bg:Point("LEFT", frame, "RIGHT", db.pvpTrinket.xOffset, db.pvpTrinket.yOffset)
	else
		trinket.bg:Point("RIGHT", frame, "LEFT", db.pvpTrinket.xOffset, db.pvpTrinket.yOffset)
	end

	if db.pvpTrinket.enable and not frame:IsElementEnabled("Trinket") then
		frame:EnableElement("Trinket")
	elseif not db.pvpTrinket.enable and frame:IsElementEnabled("Trinket") then
		frame:DisableElement("Trinket")
	end
end